/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.collections.prefixmap;

import java.io.Serializable;
import java.util.Iterator;
import java.util.Objects;
import java.util.PrimitiveIterator;

interface PrefixTrie<V extends Serializable>
extends Serializable {
    default public V add(String prefix, V value) {
        Objects.requireNonNull(prefix, "The prefix may not be null");
        Objects.requireNonNull(value, "The value may not be null");
        return this.add(prefix.codePoints().iterator(), value);
    }

    public V add(PrimitiveIterator.OfInt var1, V var2);

    default public V remove(String prefix) {
        Objects.requireNonNull(prefix, "The prefix may not be null");
        return this.remove(prefix.codePoints().iterator());
    }

    default public V remove(PrimitiveIterator.OfInt prefix) {
        throw new UnsupportedOperationException("The 'remove(PrimitiveIterator.OfInt prefix)' method has not been implemented in " + this.getClass().getCanonicalName());
    }

    default public boolean containsPrefix(String prefix) {
        return this.get(prefix) != null;
    }

    default public boolean containsPrefix(PrimitiveIterator.OfInt prefix) {
        return this.get(prefix) != null;
    }

    default public V get(String input) {
        Objects.requireNonNull(input, "The input may not be null");
        return this.get(input.codePoints().iterator());
    }

    public V get(PrimitiveIterator.OfInt var1);

    default public V getShortestMatch(String input) {
        Objects.requireNonNull(input, "The input may not be null");
        return this.getShortestMatch(input.codePoints().iterator());
    }

    public V getShortestMatch(PrimitiveIterator.OfInt var1);

    default public V getLongestMatch(String input) {
        Objects.requireNonNull(input, "The input may not be null");
        return this.getLongestMatch(input.codePoints().iterator());
    }

    public V getLongestMatch(PrimitiveIterator.OfInt var1);

    default public Iterator<V> getAllMatches(String input) {
        Objects.requireNonNull(input, "The input may not be null");
        return this.getAllMatches(input.codePoints().iterator());
    }

    public Iterator<V> getAllMatches(PrimitiveIterator.OfInt var1);

    public void clear();

    public boolean caseSensitive();
}

