/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import oracle.jdbc.aq.AQDequeueOptions;
import oracle.jdbc.aq.AQEnqueueOptions;
import oracle.jdbc.aq.AQMessage;
import oracle.jdbc.driver.AQAgentI;
import oracle.jdbc.driver.AQMessageI;
import oracle.jdbc.driver.AQMessagePropertiesI;
import oracle.jdbc.driver.T4CConnection;
import oracle.jdbc.driver.T4CMAREngine;
import oracle.jdbc.driver.T4CTTIaqjms;
import oracle.jdbc.driver.T4CTTIaqm;
import oracle.jdbc.driver.T4Ctoh;
import oracle.jdbc.internal.JMSDequeueOptions;
import oracle.jdbc.internal.JMSEnqueueOptions;
import oracle.jdbc.internal.JMSMessage;
import oracle.jdbc.internal.JMSMessageProperties;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.sql.TypeDescriptor;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.THIN_INTERNAL})
class T4CTTIaqi {
    static final int AQIVER_DEFAULT = 1;
    static final int AQIVER_12_2 = 2;
    static final int AQIVER_12_1 = 1;
    static final int AQTTC_ENQ_STREAMING_DISABLED = 0;
    static final int AQTTC_ENQ_STREAMING_ENABLED = 1;
    static final int AQTCC_OCI_ONE_PIECE = 0;
    static final int AQTCC_OCI_FIRST_PIECE = 1;
    static final int AQTCC_OCI_NEXT_PIECE = 2;
    static final int AQTCC_OCI_LAST_PIECE = 3;
    T4CConnection connection;
    T4CMAREngine meg;
    T4CTTIaqm aqm;
    T4Ctoh toh;
    private AQMessagePropertiesI messageProperties = null;
    private JMSEnqueueOptions jmsEnqueueOptions = null;
    private JMSMessageProperties jmsProp = null;
    private JMSDequeueOptions jmsDequeueOptions = null;
    private AQEnqueueOptions aqEnqueueOptions = null;
    private AQDequeueOptions aqDequeueOptions = null;
    private int aqxaqopt = 0;
    private boolean isAQMsg = false;
    private byte[] aqmcorBytes;
    private byte[] aqmeqnBytes;
    private byte[] senderAgentName = null;
    private byte[] senderAgentAddress = null;
    private byte senderAgentProtocol = 0;
    private byte[] queueNameBytes = null;
    private AQAgentI[] attrRecipientList = null;
    private byte[][] recipientTextValues = null;
    private byte[][] recipientBinaryValues = null;
    private int[] recipientKeywords = null;
    private byte[] consumerNameBytes = null;
    private byte[] correlationBytes = null;
    private byte[] conditionBytes = null;
    private int nbExtensions = 0;
    private byte[][] extensionTextValues = null;
    private byte[][] extensionBinaryValues = null;
    private int[] extensionKeywords = null;
    private byte[] messageOid = null;
    private int aqiver = 1;
    private byte[] messageData = null;
    private boolean isRawQueue = false;
    private boolean bStreamingMode = false;
    private int blockSize = 8192;
    private InputStream payloadStream = null;
    private int bitMappedEnqueueOption = 0;
    private byte[] headerPropBytes = null;
    private byte[] userPropBytes = null;
    private long aqiflg = 0L;
    private boolean useEnqOpt = false;
    private boolean lcrx2y = false;
    private T4CTTIaqjms aqjms;

    T4CTTIaqi(T4CConnection t4CConnection, int n2, String string, JMSEnqueueOptions jMSEnqueueOptions, JMSMessage jMSMessage, AQMessagePropertiesI aQMessagePropertiesI, JMSMessageProperties jMSMessageProperties, JMSDequeueOptions jMSDequeueOptions) throws IOException, SQLException {
        this.isAQMsg = false;
        this.initCommon(t4CConnection, n2, string, aQMessagePropertiesI);
        this.aqjms = new T4CTTIaqjms(t4CConnection);
        this.jmsProp = jMSMessageProperties;
        this.isRawQueue = true;
        if (this.aqxaqopt == 1) {
            this.jmsEnqueueOptions = jMSEnqueueOptions;
            if (jMSMessage.getStreamPayload() == null) {
                this.setStreamingMode(false);
                this.setInputStream(null);
                this.messageData = jMSMessage.getPayload();
            } else {
                this.setStreamingMode(true);
                this.setBlockSize(jMSMessage.getChunkSize());
                this.setInputStream(jMSMessage.getStreamPayload());
                this.messageData = null;
            }
            this.messageOid = jMSMessage.getToid();
            this.bitMappedEnqueueOption = jMSEnqueueOptions.getDeliveryMode().getCode() + jMSEnqueueOptions.getVisibility().getCode();
            if (this.jmsProp != null) {
                this.headerPropBytes = this.meg.conv.StringToCharBytes(this.jmsProp.getHeaderProperties());
                this.userPropBytes = this.meg.conv.StringToCharBytes(this.jmsProp.getUserProperties());
            } else {
                this.headerPropBytes = null;
                this.userPropBytes = null;
            }
        } else {
            this.jmsDequeueOptions = jMSDequeueOptions;
            this.messageOid = TypeDescriptor.RAWTOID;
            String string2 = this.jmsDequeueOptions.getConsumerName();
            this.consumerNameBytes = (byte[])(string2 != null && string2.length() > 0 ? this.meg.conv.StringToCharBytes(string2) : null);
            String string3 = this.jmsDequeueOptions.getCorrelation();
            this.correlationBytes = (byte[])(string3 != null && string3.length() != 0 ? this.meg.conv.StringToCharBytes(string3) : null);
            String string4 = this.jmsDequeueOptions.getCondition();
            this.conditionBytes = (byte[])(string4 != null && string4.length() > 0 ? this.meg.conv.StringToCharBytes(string4) : null);
        }
        this.initVersion();
        this.initFlag();
    }

    T4CTTIaqi(T4CConnection t4CConnection, int n2, String string, AQEnqueueOptions aQEnqueueOptions, AQMessage aQMessage, AQMessagePropertiesI aQMessagePropertiesI, AQDequeueOptions aQDequeueOptions, byte[] byArray, int n3) throws IOException, SQLException {
        String string2 = null;
        this.isAQMsg = true;
        this.initCommon(t4CConnection, n2, string, aQMessagePropertiesI);
        if (this.aqxaqopt == 1) {
            this.aqEnqueueOptions = aQEnqueueOptions;
            AQMessageI aQMessageI = (AQMessageI)aQMessage;
            this.messageData = aQMessageI.getPayload();
            this.messageOid = aQMessageI.getPayloadTOID();
            this.aqiver = aQMessageI.getPayloadVersion();
            this.isRawQueue = aQMessageI.isRAWPayload();
            string2 = this.aqEnqueueOptions.getTransformation();
        } else {
            this.messageOid = byArray;
            this.aqiver = n3;
            this.isRawQueue = AQMessageI.compareToid(byArray, TypeDescriptor.RAWTOID);
            this.aqDequeueOptions = aQDequeueOptions;
            String string3 = this.aqDequeueOptions.getConsumerName();
            this.consumerNameBytes = (byte[])(string3 != null && string3.length() > 0 ? this.meg.conv.StringToCharBytes(string3) : null);
            String string4 = this.aqDequeueOptions.getCorrelation();
            this.correlationBytes = (byte[])(string4 != null && string4.length() != 0 ? this.meg.conv.StringToCharBytes(string4) : null);
            String string5 = this.aqDequeueOptions.getCondition();
            this.conditionBytes = (byte[])(string5 != null && string5.length() > 0 ? this.meg.conv.StringToCharBytes(string5) : null);
            string2 = this.aqDequeueOptions.getTransformation();
        }
        if (string2 != null && string2.length() > 0) {
            this.nbExtensions = 1;
            this.extensionTextValues = new byte[this.nbExtensions][];
            this.extensionBinaryValues = new byte[this.nbExtensions][];
            this.extensionKeywords = new int[this.nbExtensions];
            this.extensionTextValues[0] = this.meg.conv.StringToCharBytes(string2);
            this.extensionBinaryValues[0] = null;
            this.extensionKeywords[0] = 196;
        } else {
            this.nbExtensions = 0;
        }
        this.initFlag();
    }

    void initCommon(T4CConnection t4CConnection, int n2, String string, AQMessagePropertiesI aQMessagePropertiesI) throws IOException, SQLException {
        this.connection = t4CConnection;
        this.meg = this.connection.getMarshalEngine();
        this.aqxaqopt = n2;
        this.toh = new T4Ctoh(t4CConnection);
        this.aqm = new T4CTTIaqm(this.connection, this.toh);
        this.messageProperties = aQMessagePropertiesI;
        if (this.aqxaqopt == 1 && this.messageProperties != null) {
            String string2 = this.messageProperties.getCorrelation();
            this.aqmcorBytes = (byte[])(string2 != null && string2.length() != 0 ? this.meg.conv.StringToCharBytes(string2) : null);
            String string3 = this.messageProperties.getExceptionQueue();
            this.aqmeqnBytes = (byte[])(string3 != null && string3.length() != 0 ? this.meg.conv.StringToCharBytes(string3) : null);
            AQAgentI aQAgentI = (AQAgentI)this.messageProperties.getSender();
            if (aQAgentI != null) {
                this.senderAgentName = (byte[])(aQAgentI.getName() != null ? this.meg.conv.StringToCharBytes(aQAgentI.getName()) : null);
                this.senderAgentAddress = (byte[])(aQAgentI.getAddress() != null ? this.meg.conv.StringToCharBytes(aQAgentI.getAddress()) : null);
                this.senderAgentProtocol = (byte)aQAgentI.getProtocol();
            } else {
                this.senderAgentName = null;
                this.senderAgentAddress = null;
                this.senderAgentProtocol = 0;
            }
            this.attrRecipientList = (AQAgentI[])this.messageProperties.getRecipientList();
            if (this.attrRecipientList != null && this.attrRecipientList.length > 0) {
                this.recipientTextValues = new byte[this.attrRecipientList.length * 3][];
                this.recipientBinaryValues = new byte[this.attrRecipientList.length * 3][];
                this.recipientKeywords = new int[this.attrRecipientList.length * 3];
                for (int i2 = 0; i2 < this.attrRecipientList.length; ++i2) {
                    if (this.attrRecipientList[i2].getName() != null) {
                        this.recipientTextValues[3 * i2] = this.meg.conv.StringToCharBytes(this.attrRecipientList[i2].getName());
                    }
                    if (this.attrRecipientList[i2].getAddress() != null) {
                        this.recipientTextValues[3 * i2 + 1] = this.meg.conv.StringToCharBytes(this.attrRecipientList[i2].getAddress());
                    }
                    this.recipientBinaryValues[3 * i2 + 2] = new byte[1];
                    this.recipientBinaryValues[3 * i2 + 2][0] = (byte)this.attrRecipientList[i2].getProtocol();
                    this.recipientKeywords[3 * i2] = 3 * i2;
                    this.recipientKeywords[3 * i2 + 1] = 3 * i2 + 1;
                    this.recipientKeywords[3 * i2 + 2] = 3 * i2 + 2;
                }
            }
        } else {
            this.aqmcorBytes = null;
            this.aqmeqnBytes = null;
            this.senderAgentName = null;
            this.senderAgentAddress = null;
            this.senderAgentProtocol = 0;
        }
        this.queueNameBytes = (byte[])(string != null && string.length() != 0 ? this.meg.conv.StringToCharBytes(string) : null);
    }

    void initVersion() {
        try {
            this.aqiver = this.connection.getVersionNumber() >= 12200 && TypeDescriptor.isV2available(this.messageOid) ? 2 : 1;
        }
        catch (Exception exception) {
            this.aqiver = 1;
        }
    }

    void initFlag() {
        this.aqiflg = 0L;
        if (this.aqxaqopt == 1) {
            if (this.connection.autocommit) {
                this.aqiflg = 32L;
            }
            if (!this.isAQMsg && this.jmsEnqueueOptions.getDeliveryMode() == JMSEnqueueOptions.DeliveryMode.BUFFERED || this.isAQMsg && this.aqEnqueueOptions.getDeliveryMode() == AQEnqueueOptions.DeliveryMode.BUFFERED) {
                this.aqiflg |= 2L;
            }
            this.aqiflg = this.bStreamingMode ? (this.aqiflg |= 1L) : (this.aqiflg |= 0L);
        } else {
            this.aqiflg = this.connection.autocommit ? 2L : 1L;
            if (this.isAQMsg) {
                if (this.aqDequeueOptions.getDeliveryFilter() == AQDequeueOptions.DeliveryFilter.BUFFERED) {
                    this.aqiflg |= 2L;
                } else if (this.aqDequeueOptions.getDeliveryFilter() == AQDequeueOptions.DeliveryFilter.PERSISTENT_OR_BUFFERED) {
                    this.aqiflg |= 0x10L;
                }
            } else {
                this.aqiflg |= (long)this.jmsDequeueOptions.getDeliveryMode().getCode();
                this.aqiflg |= (long)this.jmsDequeueOptions.getDequeueMode().getCode();
                this.aqiflg |= (long)this.jmsDequeueOptions.getVisibility().getCode();
                if (this.jmsDequeueOptions.getWait() == 4) {
                    this.aqiflg |= 4L;
                }
            }
        }
    }

    void marshalPropagation() throws IOException {
        byte[] byArray = this.isAQMsg ? this.aqEnqueueOptions.getRelativeMessageId() : null;
        this.meg.marshalDALC(byArray);
        if (byArray != null) {
            if (this.isAQMsg) {
                this.meg.marshalSB4(this.aqEnqueueOptions.getSequenceDeviation().getCode());
            } else {
                this.meg.marshalSB4(0);
            }
        }
    }

    void marshalHeader() throws IOException {
        this.meg.marshalUB1((short)6);
        if (this.queueNameBytes != null && this.queueNameBytes.length != 0) {
            this.meg.marshalSWORD(this.queueNameBytes.length);
            this.meg.marshalCHR(this.queueNameBytes);
        } else {
            this.meg.marshalSWORD(0);
        }
        this.meg.marshalB1Array(this.messageOid);
        this.meg.marshalUB2(this.aqiver);
        this.meg.marshalUB4(this.aqiflg);
        if (this.useEnqOpt) {
            byte[] byArray;
            if (this.isAQMsg) {
                this.meg.marshalSB4(this.aqEnqueueOptions.getVisibility().getCode());
            } else {
                this.meg.marshalSB4(this.jmsEnqueueOptions.getVisibility().getCode());
            }
            byte[] byArray2 = byArray = this.isAQMsg ? this.aqEnqueueOptions.getRelativeMessageId() : null;
            if (byArray != null && byArray.length > 0) {
                this.meg.marshalSWORD(byArray.length);
                this.meg.marshalB1Array(byArray);
            } else {
                this.meg.marshalSWORD(0);
            }
            if (this.isAQMsg) {
                this.meg.marshalSB4(this.aqEnqueueOptions.getSequenceDeviation().getCode());
            } else {
                this.meg.marshalSB4(0);
            }
            if (this.nbExtensions > 0) {
                this.meg.marshalSWORD(this.nbExtensions);
                this.meg.marshalKPDKV(this.extensionTextValues, this.extensionBinaryValues, this.extensionKeywords);
            } else {
                this.meg.marshalSWORD(0);
            }
            this.meg.marshalSB4(0);
        }
    }

    void marshalData() throws IOException {
        AQAgentI[] aQAgentIArray;
        this.meg.marshalUB1((short)7);
        this.meg.marshalUB4(this.aqiflg);
        if (!this.lcrx2y) {
            this.marshalAQM();
        }
        if ((aQAgentIArray = (AQAgentI[])this.messageProperties.getRecipientList()) != null && aQAgentIArray.length > 0) {
            this.meg.marshalSWORD(aQAgentIArray.length * 3);
            this.meg.marshalKPDKV(this.recipientTextValues, this.recipientBinaryValues, this.recipientKeywords);
        } else {
            this.meg.marshalSWORD(0);
        }
        if (!this.useEnqOpt) {
            this.meg.marshalSB4(this.aqEnqueueOptions.getVisibility().getCode());
            byte[] byArray = this.aqEnqueueOptions.getRelativeMessageId();
            if (byArray != null && byArray.length > 0) {
                this.meg.marshalSWORD(byArray.length);
                this.meg.marshalB1Array(byArray);
            } else {
                this.meg.marshalSWORD(0);
            }
            this.meg.marshalSB4(this.aqEnqueueOptions.getSequenceDeviation().getCode());
        }
        if (this.messageData != null) {
            if (!this.isRawQueue) {
                this.toh.init(this.messageOid, this.messageData.length);
                this.toh.marshal(this.meg);
                this.meg.marshalCLR(this.messageData, 0, this.messageData.length);
            } else {
                this.meg.marshalUB4(this.messageData.length);
                this.meg.marshalB1Array(this.messageData);
            }
        } else {
            this.meg.marshalUB4(0L);
        }
    }

    void marshalJmsData() throws IOException {
        this.meg.marshalUB1((short)7);
        this.marshalAQM();
        int n2 = this.jmsEnqueueOptions.getDeliveryMode().getCode() + this.jmsEnqueueOptions.getVisibility().getCode();
        this.meg.marshalSB4(n2);
        if (this.jmsProp != null) {
            this.aqjms.aqjmsflags = this.jmsProp.getJMSMessageType().getCode();
            this.aqjms.aqjmshdrpcnt = 0;
            this.aqjms.aqjmsusrprpcnt = 0;
        } else {
            this.aqjms.aqjmsflags = 0;
            this.aqjms.aqjmshdrpcnt = 0;
            this.aqjms.aqjmsusrprpcnt = 0;
        }
        this.aqjms.aqjmshdrprop = this.headerPropBytes;
        this.aqjms.aqjmsuserprop = this.userPropBytes;
        this.aqjms.marshal();
        if (this.messageOid != null) {
            this.meg.marshalSWORD(16);
            this.meg.marshalB1Array(this.messageOid);
        } else {
            this.meg.marshalSWORD(0);
        }
        this.meg.marshalUB2(this.aqiver);
        if (this.messageData != null) {
            this.meg.marshalUB4(this.messageData.length);
            this.meg.marshalB1Array(this.messageData);
        } else {
            this.meg.marshalUB4(0L);
        }
        this.meg.marshalSB4((int)this.aqiflg);
    }

    void marshalAQM() throws IOException {
        this.aqm.initToDefaultValues();
        if (this.messageProperties != null) {
            this.aqm.aqmpri = this.messageProperties.getPriority();
            this.aqm.aqmdel = this.messageProperties.getDelay();
            this.aqm.aqmexp = this.messageProperties.getExpiration();
            this.aqm.originalMsgId = this.messageProperties.getPreviousQueueMessageId();
        }
        this.aqm.aqmcorBytes = this.aqmcorBytes;
        this.aqm.aqmeqnBytes = this.aqmeqnBytes;
        this.aqm.senderAgentName = this.senderAgentName;
        this.aqm.senderAgentAddress = this.senderAgentAddress;
        this.aqm.senderAgentProtocol = this.senderAgentProtocol;
        this.aqm.marshal();
    }

    void marshalDone() throws IOException {
        this.meg.marshalUB1((short)9);
    }

    void marshal() throws IOException {
        this.meg.marshalDALC(this.queueNameBytes);
        this.marshalAQM();
        AQAgentI[] aQAgentIArray = (AQAgentI[])this.messageProperties.getRecipientList();
        if (aQAgentIArray != null && aQAgentIArray.length > 0) {
            this.meg.marshalSWORD(aQAgentIArray.length * 3);
            this.meg.marshalKPDKV(this.recipientTextValues, this.recipientBinaryValues, this.recipientKeywords);
        } else {
            this.meg.marshalSWORD(0);
        }
        if (this.aqxaqopt == 2) {
            this.meg.marshalDALC(this.consumerNameBytes);
        } else {
            this.meg.marshalSWORD(0);
        }
        if (this.aqxaqopt == 2) {
            if (this.isAQMsg) {
                this.meg.marshalSB4(this.aqDequeueOptions.getDequeueMode().getCode());
            } else {
                this.meg.marshalSB4(this.jmsDequeueOptions.getDequeueMode().getCode());
            }
        } else {
            this.meg.marshalSB4(0);
        }
        if (this.isAQMsg) {
            if (this.aqxaqopt == 2) {
                this.meg.marshalSB4(this.aqDequeueOptions.getNavigation().getCode());
            } else {
                this.meg.marshalSB4(0);
            }
        } else {
            this.meg.marshalSB4(0);
        }
        if (this.aqxaqopt == 1) {
            if (this.isAQMsg) {
                this.meg.marshalSB4(this.aqEnqueueOptions.getVisibility().getCode());
            } else {
                this.meg.marshalSB4(this.jmsEnqueueOptions.getVisibility().getCode());
            }
        } else if (this.isAQMsg) {
            this.meg.marshalSB4(this.aqDequeueOptions.getVisibility().getCode());
        } else {
            this.meg.marshalSB4(this.jmsDequeueOptions.getVisibility().getCode());
        }
        if (this.aqxaqopt == 2) {
            if (this.isAQMsg) {
                this.meg.marshalSB4(this.aqDequeueOptions.getWait());
            } else {
                this.meg.marshalSB4(this.jmsDequeueOptions.getWait());
            }
        } else {
            this.meg.marshalSB4(0);
        }
        byte[] byArray = null;
        if (this.aqxaqopt == 2) {
            byArray = this.isAQMsg ? this.aqDequeueOptions.getDequeueMessageId() : this.jmsDequeueOptions.getDequeueMessageId();
        }
        this.meg.marshalDALC(byArray);
        if (this.aqxaqopt == 2) {
            this.meg.marshalDALC(this.correlationBytes);
        } else {
            this.meg.marshalSWORD(0);
        }
        if (this.connection.getTTCVersion() >= 1) {
            this.meg.marshalDALC(this.conditionBytes);
            this.meg.marshalSWORD(0);
        }
        byte[] byArray2 = null;
        if (this.aqxaqopt == 1) {
            byArray2 = this.isAQMsg ? this.aqEnqueueOptions.getRelativeMessageId() : null;
        }
        this.meg.marshalDALC(byArray2);
        if (this.aqxaqopt == 1) {
            if (this.isAQMsg) {
                this.meg.marshalSB4(this.aqEnqueueOptions.getSequenceDeviation().getCode());
            } else {
                this.meg.marshalSB4(0);
            }
        } else {
            this.meg.marshalSB4(0);
        }
        this.meg.marshalDALC(this.messageOid);
        this.meg.marshalUB2(this.aqiver);
        if (this.aqxaqopt == 1) {
            if (this.messageData != null) {
                if (!this.isRawQueue) {
                    this.meg.marshalSWORD(this.messageData.length);
                    this.toh.init(this.messageOid, this.messageData.length);
                    this.toh.marshal(this.meg);
                    this.meg.marshalCLR(this.messageData, 0, this.messageData.length);
                    this.meg.marshalUB4(0L);
                } else {
                    this.meg.marshalSWORD(0);
                    this.meg.marshalDALC(this.messageData);
                }
            } else {
                this.meg.marshalSWORD(0);
                this.meg.marshalUB4(0L);
            }
        } else {
            this.meg.marshalSWORD(0);
            this.meg.marshalUB4(0L);
        }
        this.meg.marshalUB4(0L);
        long l2 = 0L;
        if (this.aqxaqopt == 1) {
            if (this.connection.autocommit) {
                l2 = 32L;
            }
            if (!this.isAQMsg && this.jmsEnqueueOptions.getDeliveryMode() == JMSEnqueueOptions.DeliveryMode.BUFFERED || this.isAQMsg && this.aqEnqueueOptions.getDeliveryMode() == AQEnqueueOptions.DeliveryMode.BUFFERED) {
                l2 |= 2L;
            }
            l2 = this.bStreamingMode ? (l2 |= 1L) : (l2 |= 0L);
        } else {
            l2 = this.connection.autocommit ? 2L : 1L;
            if (this.isAQMsg) {
                if (this.aqDequeueOptions.getDeliveryFilter() == AQDequeueOptions.DeliveryFilter.BUFFERED) {
                    l2 |= 2L;
                } else if (this.aqDequeueOptions.getDeliveryFilter() == AQDequeueOptions.DeliveryFilter.PERSISTENT_OR_BUFFERED) {
                    l2 |= 0x10L;
                }
            } else {
                l2 |= (long)this.jmsDequeueOptions.getDeliveryMode().getCode();
                l2 |= (long)this.jmsDequeueOptions.getDequeueMode().getCode();
                l2 |= (long)this.jmsDequeueOptions.getVisibility().getCode();
                if (this.jmsDequeueOptions.getWait() == 4) {
                    l2 |= 4L;
                }
            }
        }
        this.meg.marshalUB4(l2);
        if (this.nbExtensions > 0) {
            this.meg.marshalSWORD(this.nbExtensions);
            this.meg.marshalKPDKV(this.extensionTextValues, this.extensionBinaryValues, this.extensionKeywords);
        } else {
            this.meg.marshalSWORD(0);
        }
        this.meg.marshalSWORD(0);
        if (this.aqxaqopt == 1 && this.bStreamingMode) {
            this.writeStreamingPayload();
        }
    }

    private void setStreamingMode(boolean bl) {
        this.bStreamingMode = bl;
    }

    private void setBlockSize(int n2) {
        if (n2 > 0) {
            this.blockSize = n2;
        }
    }

    private void setInputStream(InputStream inputStream) {
        this.payloadStream = inputStream;
    }

    private void writeStreamingPayload() throws IOException {
        int n2;
        byte[] byArray = new byte[this.blockSize];
        boolean bl = true;
        while (true) {
            if ((n2 = this.payloadStream.read(byArray)) < this.blockSize) break;
            if (bl) {
                this.writeFirst(byArray, n2);
                bl = false;
                continue;
            }
            this.writeNext(byArray, n2);
        }
        this.writeLast(byArray, n2);
        this.payloadStream.close();
        this.payloadStream = null;
    }

    private void writeFirst(byte[] byArray, int n2) throws IOException {
        this.meg.marshalUB1((short)1);
        this.meg.marshalSB8(n2);
        this.meg.marshalB1Array(byArray, 0, n2);
    }

    private void writeNext(byte[] byArray, int n2) throws IOException {
        this.meg.marshalUB1((short)2);
        this.meg.marshalSB8(n2);
        this.meg.marshalB1Array(byArray, 0, n2);
    }

    private void writeLast(byte[] byArray, int n2) throws IOException {
        if (n2 > 0) {
            this.meg.marshalUB1((short)3);
            this.meg.marshalSB8(n2);
            this.meg.marshalB1Array(byArray, 0, n2);
        } else {
            this.meg.marshalUB1((short)3);
            this.meg.marshalSB8(0L);
        }
    }

    boolean isRawQueue() {
        return this.isRawQueue;
    }
}

