/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.system.service.impl;

import com.ruoyi.system.domain.HydrologyModel;
import com.ruoyi.system.mapper.HydrologyModelMapper;
import com.ruoyi.system.service.IHydrologyModelService;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class HydrologyModelServiceImpl
implements IHydrologyModelService {
    @Autowired
    private HydrologyModelMapper hydrologyModelMapper;

    @Override
    public HydrologyModel selectHydrologyModelById(Long id) {
        return this.hydrologyModelMapper.selectHydrologyModelById(id);
    }

    @Override
    public HydrologyModel selectHydrologyModelByCode(String modelCode) {
        return this.hydrologyModelMapper.selectHydrologyModelByCode(modelCode);
    }

    @Override
    public List<HydrologyModel> selectHydrologyModelList(HydrologyModel hydrologyModel) {
        return this.hydrologyModelMapper.selectHydrologyModelList(hydrologyModel);
    }

    @Override
    public int insertHydrologyModel(HydrologyModel hydrologyModel) {
        hydrologyModel.setCreateTime(new Date());
        hydrologyModel.setDelFlag("0");
        hydrologyModel.setStatus("0");
        return this.hydrologyModelMapper.insertHydrologyModel(hydrologyModel);
    }

    @Override
    public int updateHydrologyModel(HydrologyModel hydrologyModel) {
        hydrologyModel.setUpdateTime(new Date());
        return this.hydrologyModelMapper.updateHydrologyModel(hydrologyModel);
    }

    @Override
    public int deleteHydrologyModelByIds(Long[] ids) {
        return this.hydrologyModelMapper.deleteHydrologyModelByIds(ids);
    }

    @Override
    public int deleteHydrologyModelById(Long id) {
        return this.hydrologyModelMapper.deleteHydrologyModelById(id);
    }

    @Override
    public int approveHydrologyModel(HydrologyModel hydrologyModel) {
        hydrologyModel.setApproveTime(new Date());
        hydrologyModel.setUpdateTime(new Date());
        return this.hydrologyModelMapper.approveHydrologyModel(hydrologyModel);
    }

    @Override
    public List<Map<String, Object>> countModelsByType(HydrologyModel hydrologyModel) {
        return this.hydrologyModelMapper.countModelsByType(hydrologyModel);
    }

    @Override
    public String generateModelCode(String modelType) {
        String timestamp = String.valueOf(System.currentTimeMillis());
        String uuid = UUID.randomUUID().toString().replace("-", "").substring(0, 4).toUpperCase();
        String prefix = "";
        switch (modelType) {
            case "1": {
                prefix = "DAM";
                break;
            }
            case "2": {
                prefix = "RIVER";
                break;
            }
            case "3": {
                prefix = "STATION";
                break;
            }
            case "4": {
                prefix = "IRR";
                break;
            }
            case "5": {
                prefix = "FLOOD";
                break;
            }
            default: {
                prefix = "HYDRO";
            }
        }
        return prefix + timestamp + uuid;
    }
}

