/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.common;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import springfox.documentation.service.VendorExtension;

public class ExternalDocumentation {
    private final String url;
    private final String description;
    private final List<VendorExtension> extensions = new ArrayList<VendorExtension>();

    public ExternalDocumentation(String url, String description, Collection<VendorExtension> extensions) {
        this.url = url;
        this.description = description;
        this.extensions.addAll(extensions);
    }

    public String getUrl() {
        return this.url;
    }

    public String getDescription() {
        return this.description;
    }

    public Collection<VendorExtension> getExtensions() {
        return this.extensions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExternalDocumentation that = (ExternalDocumentation)o;
        return Objects.equals(this.url, that.url) && Objects.equals(this.description, that.description) && Objects.equals(this.extensions, that.extensions);
    }

    public int hashCode() {
        return Objects.hash(this.url, this.description, this.extensions);
    }

    public String toString() {
        return new StringJoiner(", ", ExternalDocumentation.class.getSimpleName() + "[", "]").add("url='" + this.url + "'").add("description='" + this.description + "'").add("extensions=" + this.extensions).toString();
    }
}

