/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.system.service.impl;

import com.ruoyi.common.config.RuoYiConfig;
import com.ruoyi.common.utils.DateUtils;
import com.ruoyi.system.domain.WatershedModel;
import com.ruoyi.system.mapper.WatershedModelMapper;
import com.ruoyi.system.service.IWatershedModelService;
import java.io.File;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class WatershedModelServiceImpl
implements IWatershedModelService {
    @Autowired
    private WatershedModelMapper watershedModelMapper;

    @Override
    public WatershedModel selectWatershedModelById(Long id) {
        return this.watershedModelMapper.selectWatershedModelByModelId(id);
    }

    @Override
    public List<WatershedModel> selectWatershedModelList(WatershedModel watershedModel) {
        return this.watershedModelMapper.selectWatershedModelList(watershedModel);
    }

    @Override
    public int insertWatershedModel(WatershedModel watershedModel) {
        Date now = DateUtils.getNowDate();
        System.out.println("\u8bbe\u7f6e\u521b\u5efa\u65f6\u95f4: " + now);
        watershedModel.setCreateTime(now);
        watershedModel.setUpdateTime(now);
        int result = this.watershedModelMapper.insertWatershedModel(watershedModel);
        System.out.println("\u63d2\u5165\u7ed3\u679c: " + result);
        return result;
    }

    @Override
    public int updateWatershedModel(WatershedModel watershedModel) {
        watershedModel.setUpdateTime(DateUtils.getNowDate());
        return this.watershedModelMapper.updateWatershedModel(watershedModel);
    }

    @Override
    public int deleteWatershedModelByIds(Long[] ids) {
        for (Long id : ids) {
            this.deleteLocalFile(id);
        }
        return this.watershedModelMapper.deleteWatershedModelByModelIds(ids);
    }

    @Override
    public int deleteWatershedModelById(Long id) {
        this.deleteLocalFile(id);
        return this.watershedModelMapper.deleteWatershedModelByModelId(id);
    }

    private void deleteLocalFile(Long id) {
        try {
            WatershedModel model = this.watershedModelMapper.selectWatershedModelByModelId(id);
            if (model != null && model.getFilePath() != null && !model.getFilePath().isEmpty()) {
                String fullPath;
                File file;
                String filePath;
                String string = filePath = model.getFilePath().startsWith("/profile") ? model.getFilePath().substring("/profile".length()) : model.getFilePath();
                if (filePath.startsWith("/")) {
                    filePath = filePath.substring(1);
                }
                if ((file = new File(fullPath = RuoYiConfig.getProfile() + "/" + filePath)).exists()) {
                    boolean deleted = file.delete();
                    System.out.println("\u6587\u4ef6\u5220\u9664" + (deleted ? "\u6210\u529f: " : "\u5931\u8d25: ") + fullPath);
                } else {
                    System.out.println("\u6587\u4ef6\u4e0d\u5b58\u5728: " + fullPath);
                }
            }
        }
        catch (Exception e) {
            System.err.println("\u5220\u9664\u672c\u5730\u6587\u4ef6\u65f6\u51fa\u9519: " + e.getMessage());
        }
    }
}

