/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.util;

import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.reader.ObjectReaderImplDate;
import com.alibaba.fastjson2.util.IOUtils;
import com.alibaba.fastjson2.util.JDKUtils;
import com.alibaba.fastjson2.util.TypeUtils;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.DateTimeException;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.zone.ZoneRules;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public class DateUtils {
    public static final ZoneId DEFAULT_ZONE_ID;
    public static final String SHANGHAI_ZONE_ID_NAME = "Asia/Shanghai";
    public static final ZoneId SHANGHAI_ZONE_ID;
    public static final ZoneRules SHANGHAI_ZONE_RULES;
    public static final String OFFSET_8_ZONE_ID_NAME = "+08:00";
    public static final ZoneId OFFSET_8_ZONE_ID;
    public static final LocalDate LOCAL_DATE_19700101;
    static DateTimeFormatter DATE_TIME_FORMATTER_34;
    static DateTimeFormatter DATE_TIME_FORMATTER_COOKIE;
    static DateTimeFormatter DATE_TIME_FORMATTER_COOKIE_LOCAL;
    static DateTimeFormatter DATE_TIME_FORMATTER_RFC_2822;
    static final int LOCAL_EPOCH_DAY;
    private static final int[] POWERS;

    public static Date parseDateYMDHMS19(String str) {
        if (str == null || str.isEmpty()) {
            return null;
        }
        long millis = DateUtils.parseMillisYMDHMS19(str, DEFAULT_ZONE_ID);
        return new Date(millis);
    }

    public static Date parseDate(String str, String format) {
        return DateUtils.parseDate(str, format, DEFAULT_ZONE_ID);
    }

    public static Date parseDate(String str, String format, ZoneId zoneId) {
        if (str == null || str.isEmpty() || "null".equals(str)) {
            return null;
        }
        if (format == null || format.isEmpty() || "string".equals(format)) {
            long millis = DateUtils.parseMillis(str, zoneId);
            if (millis == 0L) {
                return null;
            }
            return new Date(millis);
        }
        switch (format) {
            case "yyyy-MM-dd'T'HH:mm:ss": {
                long millis = DateUtils.parseMillis19(str, zoneId, DateTimeFormatPattern.DATE_TIME_FORMAT_19_DASH_T);
                return new Date(millis);
            }
            case "yyyy-MM-dd HH:mm:ss": {
                long millis = DateUtils.parseMillisYMDHMS19(str, zoneId);
                return new Date(millis);
            }
            case "yyyy/MM/dd HH:mm:ss": {
                long millis = DateUtils.parseMillis19(str, zoneId, DateTimeFormatPattern.DATE_TIME_FORMAT_19_SLASH);
                return new Date(millis);
            }
            case "dd.MM.yyyy HH:mm:ss": {
                long millis = DateUtils.parseMillis19(str, zoneId, DateTimeFormatPattern.DATE_TIME_FORMAT_19_DOT);
                return new Date(millis);
            }
            case "yyyy-MM-dd": {
                long millis = DateUtils.parseMillis10(str, zoneId, DateTimeFormatPattern.DATE_FORMAT_10_DASH);
                return new Date(millis);
            }
            case "yyyy/MM/dd": {
                long millis = DateUtils.parseMillis10(str, zoneId, DateTimeFormatPattern.DATE_FORMAT_10_SLASH);
                return new Date(millis);
            }
            case "yyyyMMdd": {
                DateTimeFormatter formatter = DateTimeFormatter.ofPattern(format);
                LocalDate ldt = LocalDate.parse(str, formatter);
                long millis = DateUtils.millis(zoneId, ldt.getYear(), ldt.getMonthValue(), ldt.getDayOfMonth(), 0, 0, 0, 0);
                return new Date(millis);
            }
            case "yyyyMMddHHmmssSSSZ": {
                long millis = DateUtils.parseMillis(str, DEFAULT_ZONE_ID);
                return new Date(millis);
            }
            case "iso8601": {
                return DateUtils.parseDate(str);
            }
        }
        if (zoneId == null) {
            zoneId = DEFAULT_ZONE_ID;
        }
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(format);
        LocalDateTime ldt = LocalDateTime.parse(str, formatter);
        long millis = DateUtils.millis(ldt, zoneId);
        return new Date(millis);
    }

    public static Date parseDate(String str) {
        long millis = DateUtils.parseMillis(str, DEFAULT_ZONE_ID);
        if (millis == 0L) {
            return null;
        }
        return new Date(millis);
    }

    public static Date parseDate(String str, ZoneId zoneId) {
        long millis = DateUtils.parseMillis(str, zoneId);
        if (millis == 0L) {
            return null;
        }
        return new Date(millis);
    }

    public static long parseMillis(String str) {
        return DateUtils.parseMillis(str, DEFAULT_ZONE_ID);
    }

    public static long parseMillis(String str, ZoneId zoneId) {
        if (str == null) {
            return 0L;
        }
        if (JDKUtils.STRING_CODER != null && JDKUtils.STRING_VALUE != null && JDKUtils.STRING_CODER.applyAsInt(str) == 0) {
            byte[] bytes = JDKUtils.STRING_VALUE.apply(str);
            return DateUtils.parseMillis(bytes, 0, bytes.length, StandardCharsets.ISO_8859_1, zoneId);
        }
        char[] chars = JDKUtils.getCharArray(str);
        return DateUtils.parseMillis(chars, 0, chars.length, zoneId);
    }

    public static LocalDateTime parseLocalDateTime(String str) {
        if (str == null) {
            return null;
        }
        return DateUtils.parseLocalDateTime(str, 0, str.length());
    }

    public static LocalDateTime parseLocalDateTime(String str, int off, int len) {
        char[] chars;
        LocalDateTime ldt;
        if (str == null || len == 0) {
            return null;
        }
        if (JDKUtils.STRING_CODER != null && JDKUtils.STRING_VALUE != null && JDKUtils.STRING_CODER.applyAsInt(str) == 0) {
            byte[] bytes = JDKUtils.STRING_VALUE.apply(str);
            ldt = DateUtils.parseLocalDateTime(bytes, off, len);
        } else if (JDKUtils.JVM_VERSION == 8 && !JDKUtils.FIELD_STRING_VALUE_ERROR) {
            chars = JDKUtils.getCharArray(str);
            ldt = DateUtils.parseLocalDateTime(chars, off, len);
        } else {
            chars = new char[len];
            str.getChars(off, off + len, chars, 0);
            ldt = DateUtils.parseLocalDateTime(chars, off, len);
        }
        if (ldt == null) {
            switch (str) {
                case "": 
                case "null": 
                case "00000000": 
                case "000000000000": 
                case "0000\u5e7400\u670800\u65e5": 
                case "0000-0-00": 
                case "0000-00-0": 
                case "0000-00-00": {
                    return null;
                }
            }
            throw new DateTimeParseException(str, str, off);
        }
        return ldt;
    }

    public static LocalDateTime parseLocalDateTime(char[] str, int off, int len) {
        if (str == null || len == 0) {
            return null;
        }
        switch (len) {
            case 4: {
                if (str[off] == 'n' && str[off + 1] == 'u' && str[off + 2] == 'l' && str[off + 3] == 'l') {
                    return null;
                }
                String input = new String(str, off, len);
                throw new DateTimeParseException("illegal input " + input, input, 0);
            }
            case 8: {
                if (str[2] == ':' && str[5] == ':') {
                    LocalTime localTime = DateUtils.parseLocalTime8(str, off);
                    return LocalDateTime.of(LOCAL_DATE_19700101, localTime);
                }
                LocalDate localDate = DateUtils.parseLocalDate8(str, off);
                if (localDate == null) {
                    return null;
                }
                return LocalDateTime.of(localDate, LocalTime.MIN);
            }
            case 9: {
                LocalDate localDate = DateUtils.parseLocalDate9(str, off);
                if (localDate == null) {
                    return null;
                }
                return LocalDateTime.of(localDate, LocalTime.MIN);
            }
            case 10: {
                LocalDate localDate = DateUtils.parseLocalDate10(str, off);
                if (localDate == null) {
                    return null;
                }
                return LocalDateTime.of(localDate, LocalTime.MIN);
            }
            case 11: {
                LocalDate localDate = DateUtils.parseLocalDate11(str, off);
                if (localDate == null) {
                    return null;
                }
                return LocalDateTime.of(localDate, LocalTime.MIN);
            }
            case 12: {
                return DateUtils.parseLocalDateTime12(str, off);
            }
            case 14: {
                return DateUtils.parseLocalDateTime14(str, off);
            }
            case 16: {
                return DateUtils.parseLocalDateTime16(str, off);
            }
            case 17: {
                return DateUtils.parseLocalDateTime17(str, off);
            }
            case 18: {
                return DateUtils.parseLocalDateTime18(str, off);
            }
            case 19: {
                return DateUtils.parseLocalDateTime19(str, off);
            }
            case 20: {
                return DateUtils.parseLocalDateTime20(str, off);
            }
        }
        return DateUtils.parseLocalDateTimeX(str, off, len);
    }

    public static LocalTime parseLocalTime5(byte[] str, int off) {
        int minute;
        int hour;
        if (off + 5 > str.length) {
            return null;
        }
        int second = 0;
        if (str[off + 2] == 58) {
            hour = IOUtils.digit2(str, off);
            minute = IOUtils.digit2(str, off + 3);
        } else if (str[off + 1] == 58 && str[off + 3] == 58) {
            hour = IOUtils.digit1(str, off);
            minute = IOUtils.digit1(str, off + 2);
            second = IOUtils.digit1(str, off + 4);
        } else {
            return null;
        }
        return DateUtils.localTime(hour, minute, second);
    }

    public static LocalTime parseLocalTime5(char[] str, int off) {
        int minute;
        int hour;
        if (off + 5 > str.length) {
            return null;
        }
        int second = 0;
        if (str[off + 2] == ':') {
            hour = IOUtils.digit2(str, off);
            minute = IOUtils.digit2(str, off + 3);
        } else if (str[off + 1] == ':' && str[off + 3] == ':') {
            hour = IOUtils.digit1(str, off);
            minute = IOUtils.digit1(str, off + 2);
            second = IOUtils.digit1(str, off + 4);
        } else {
            return null;
        }
        return DateUtils.localTime(hour, minute, second);
    }

    public static LocalTime parseLocalTime6(byte[] str, int off) {
        int second;
        int minute;
        int hour;
        if (off + 5 > str.length) {
            return null;
        }
        byte c1 = str[off + 1];
        byte c4 = str[off + 4];
        if (str[off + 2] == 58 && c4 == 58) {
            hour = IOUtils.digit2(str, off);
            minute = IOUtils.digit1(str, off + 3);
            second = IOUtils.digit1(str, off + 5);
        } else if (c1 == 58 && c4 == 58) {
            hour = IOUtils.digit1(str, off);
            minute = IOUtils.digit2(str, off + 2);
            second = IOUtils.digit1(str, off + 5);
        } else if (c1 == 58 && str[off + 3] == 58) {
            hour = IOUtils.digit1(str, off);
            minute = IOUtils.digit1(str, off + 2);
            second = IOUtils.digit2(str, off + 4);
        } else {
            return null;
        }
        return DateUtils.localTime(hour, minute, second);
    }

    public static LocalTime parseLocalTime6(char[] str, int off) {
        int second;
        int minute;
        int hour;
        if (off + 5 > str.length) {
            return null;
        }
        char c1 = str[off + 1];
        char c4 = str[off + 4];
        if (str[off + 2] == ':' && c4 == ':') {
            hour = IOUtils.digit2(str, off);
            minute = IOUtils.digit1(str, off + 3);
            second = IOUtils.digit1(str, off + 5);
        } else if (c1 == ':' && c4 == ':') {
            hour = IOUtils.digit1(str, off);
            minute = IOUtils.digit2(str, off + 2);
            second = IOUtils.digit1(str, off + 5);
        } else if (c1 == ':' && str[off + 3] == ':') {
            hour = IOUtils.digit1(str, off);
            minute = IOUtils.digit1(str, off + 2);
            second = IOUtils.digit2(str, off + 4);
        } else {
            return null;
        }
        return DateUtils.localTime(hour, minute, second);
    }

    public static LocalTime parseLocalTime7(byte[] str, int off) {
        int second;
        int minute;
        int hour;
        if (off + 5 > str.length) {
            return null;
        }
        byte c2 = str[off + 2];
        byte c4 = str[off + 4];
        if (str[off + 1] == 58 && c4 == 58) {
            hour = IOUtils.digit1(str, off);
            minute = IOUtils.digit2(str, off + 2);
            second = IOUtils.digit2(str, off + 5);
        } else if (c2 == 58 && c4 == 58) {
            hour = IOUtils.digit2(str, off);
            minute = IOUtils.digit1(str, off + 3);
            second = IOUtils.digit2(str, off + 5);
        } else if (c2 == 58 && str[off + 5] == 58) {
            hour = IOUtils.digit2(str, off);
            minute = IOUtils.digit2(str, off + 3);
            second = IOUtils.digit1(str, off + 6);
        } else {
            return null;
        }
        return DateUtils.localTime(hour, minute, second);
    }

    public static LocalTime parseLocalTime7(char[] str, int off) {
        int second;
        int minute;
        int hour;
        if (off + 5 > str.length) {
            return null;
        }
        char c2 = str[off + 2];
        char c4 = str[off + 4];
        if (str[off + 1] == ':' && c4 == ':') {
            hour = IOUtils.digit1(str, off);
            minute = IOUtils.digit2(str, off + 2);
            second = IOUtils.digit2(str, off + 5);
        } else if (c2 == ':' && c4 == ':') {
            hour = IOUtils.digit2(str, off);
            minute = IOUtils.digit1(str, off + 3);
            second = IOUtils.digit2(str, off + 5);
        } else if (c2 == ':' && str[off + 5] == ':') {
            hour = IOUtils.digit2(str, off);
            minute = IOUtils.digit2(str, off + 3);
            second = IOUtils.digit1(str, off + 6);
        } else {
            return null;
        }
        return DateUtils.localTime(hour, minute, second);
    }

    public static LocalTime parseLocalTime8(byte[] bytes, int off) {
        long hms;
        return off + 8 > bytes.length || (hms = DateUtils.hms(bytes, off)) == -1L ? null : LocalTime.of((int)hms & 0xFF, (int)(hms >> 24) & 0xFF, (int)(hms >> 48) & 0xFF);
    }

    public static LocalTime parseLocalTime8(char[] bytes, int off) {
        return off + 8 > bytes.length || bytes[off + 2] != ':' || bytes[off + 5] != ':' ? null : DateUtils.localTime(IOUtils.digit2(bytes, off), IOUtils.digit2(bytes, off + 3), IOUtils.digit2(bytes, off + 6));
    }

    public static LocalTime parseLocalTime(char c0, char c1, char c2, char c3, char c4, char c5, char c6, char c7) {
        if (c2 != ':' || c5 != ':') {
            return null;
        }
        char h0 = c0;
        char h1 = c1;
        char i0 = c3;
        char i1 = c4;
        char s0 = c6;
        char s1 = c7;
        if (h0 < '0' || h0 > '9' || h1 < '0' || h1 > '9') {
            return null;
        }
        int hour = (h0 - 48) * 10 + (h1 - 48);
        if (i0 < '0' || i0 > '9' || i1 < '0' || i1 > '9') {
            return null;
        }
        int minute = (i0 - 48) * 10 + (i1 - 48);
        if (s0 < '0' || s0 > '9' || s1 < '0' || s1 > '9') {
            return null;
        }
        int second = (s0 - 48) * 10 + (s1 - 48);
        return LocalTime.of(hour, minute, second);
    }

    public static LocalTime parseLocalTime10(byte[] str, int off) {
        if (off + 10 > str.length || str[off + 2] != 58 || str[off + 5] != 58 || str[off + 8] != 46) {
            return null;
        }
        int hour = IOUtils.digit2(str, off);
        int minute = IOUtils.digit2(str, off + 3);
        int second = IOUtils.digit2(str, off + 6);
        int millis = IOUtils.digit1(str, off + 9);
        if (millis > 0) {
            millis *= 100000000;
        }
        return (hour | minute | second | minute) < 0 ? null : LocalTime.of(hour, minute, second, millis);
    }

    public static LocalTime parseLocalTime10(char[] str, int off) {
        if (off + 10 > str.length || str[off + 2] != ':' || str[off + 5] != ':' || str[off + 8] != '.') {
            return null;
        }
        int hour = IOUtils.digit2(str, off);
        int minute = IOUtils.digit2(str, off + 3);
        int second = IOUtils.digit2(str, off + 6);
        int millis = IOUtils.digit1(str, off + 9);
        if (millis > 0) {
            millis *= 100000000;
        }
        return (hour | minute | second | minute) < 0 ? null : LocalTime.of(hour, minute, second, millis);
    }

    public static LocalTime parseLocalTime11(byte[] str, int off) {
        long hms;
        if (off + 11 > str.length || (hms = DateUtils.hms(str, off)) == -1L || str[off + 8] != 46) {
            return null;
        }
        int hour = (int)hms & 0xFF;
        int minute = (int)(hms >> 24) & 0xFF;
        int second = (int)(hms >> 48) & 0xFF;
        int millis = IOUtils.digit2(str, off + 9);
        if (millis > 0) {
            millis *= 10000000;
        }
        return LocalTime.of(hour, minute, second, millis);
    }

    public static LocalTime parseLocalTime11(char[] str, int off) {
        if (off + 11 > str.length || str[off + 2] != ':' || str[off + 5] != ':' || str[off + 8] != '.') {
            return null;
        }
        int hour = IOUtils.digit2(str, off);
        int minute = IOUtils.digit2(str, off + 3);
        int second = IOUtils.digit2(str, off + 6);
        int millis = IOUtils.digit2(str, off + 9);
        if (millis > 0) {
            millis *= 10000000;
        }
        return (hour | minute | second | minute) < 0 ? null : LocalTime.of(hour, minute, second, millis);
    }

    public static LocalTime parseLocalTime12(byte[] str, int off) {
        long hms;
        if (off + 12 > str.length || (hms = DateUtils.hms(str, off)) == -1L || str[off + 8] != 46) {
            return null;
        }
        int hour = (int)hms & 0xFF;
        int minute = (int)(hms >> 24) & 0xFF;
        int second = (int)(hms >> 48) & 0xFF;
        int millis = IOUtils.digit3(str, off + 9);
        if (millis > 0) {
            millis *= 1000000;
        }
        return LocalTime.of(hour, minute, second, millis);
    }

    public static LocalTime parseLocalTime12(char[] str, int off) {
        if (off + 12 > str.length || str[off + 2] != ':' || str[off + 5] != ':' || str[off + 8] != '.') {
            return null;
        }
        int hour = IOUtils.digit2(str, off);
        int minute = IOUtils.digit2(str, off + 3);
        int second = IOUtils.digit2(str, off + 6);
        int millis = IOUtils.digit3(str, off + 9);
        if (millis > 0) {
            millis *= 1000000;
        }
        return (hour | minute | second | minute) < 0 ? null : LocalTime.of(hour, minute, second, millis);
    }

    public static LocalTime parseLocalTime15(byte[] str, int off) {
        long hms;
        if (off + 15 > str.length || (hms = DateUtils.hms(str, off)) == -1L || str[off + 8] != 46) {
            return null;
        }
        int hour = (int)hms & 0xFF;
        int minute = (int)(hms >> 24) & 0xFF;
        int second = (int)(hms >> 48) & 0xFF;
        int nanos = DateUtils.readNanos(str, 6, off + 9);
        return nanos < 0 ? null : LocalTime.of(hour, minute, second, nanos);
    }

    public static LocalTime parseLocalTime15(char[] str, int off) {
        int nanos;
        int second;
        int minute;
        if (off + 15 > str.length || str[off + 2] != ':' || str[off + 5] != ':' || str[off + 8] != '.') {
            return null;
        }
        int hour = IOUtils.digit2(str, off);
        return (hour | (minute = IOUtils.digit2(str, off + 3)) | (second = IOUtils.digit2(str, off + 6)) | (nanos = DateUtils.readNanos(str, 6, off + 9))) < 0 ? null : LocalTime.of(hour, minute, second, nanos);
    }

    public static LocalTime parseLocalTime18(byte[] str, int off) {
        long hms;
        if (off + 18 > str.length || (hms = DateUtils.hms(str, off)) == -1L || str[off + 8] != 46) {
            return null;
        }
        int hour = (int)hms & 0xFF;
        int minute = (int)(hms >> 24) & 0xFF;
        int second = (int)(hms >> 48) & 0xFF;
        int nanos = DateUtils.readNanos(str, 9, off + 9);
        return nanos < 0 ? null : LocalTime.of(hour, minute, second, nanos);
    }

    public static LocalTime parseLocalTime18(char[] str, int off) {
        int nanos;
        int second;
        int minute;
        if (off + 18 > str.length || str[off + 2] != ':' || str[off + 5] != ':' || str[off + 8] != '.') {
            return null;
        }
        int hour = IOUtils.digit2(str, off);
        return (hour | (minute = IOUtils.digit2(str, off + 3)) | (second = IOUtils.digit2(str, off + 6)) | (nanos = DateUtils.readNanos(str, 9, off + 9))) < 0 ? null : LocalTime.of(hour, minute, second, nanos);
    }

    private static LocalTime localTime(int hour, int minute, int second) {
        return (hour | minute | second) < 0 ? null : LocalTime.of(hour, minute, second);
    }

    public static LocalDateTime parseLocalDateTime(byte[] str, int off, int len) {
        if (str == null || len == 0) {
            return null;
        }
        switch (len) {
            case 4: {
                if (str[off] == 110 && str[off + 1] == 117 && str[off + 2] == 108 && str[off + 3] == 108) {
                    return null;
                }
                String input = new String(str, off, len);
                throw new DateTimeParseException("illegal input " + input, input, 0);
            }
            case 8: {
                LocalDate localDate = DateUtils.parseLocalDate8(str, off);
                if (localDate == null) {
                    return null;
                }
                return LocalDateTime.of(localDate, LocalTime.MIN);
            }
            case 9: {
                LocalDate localDate = DateUtils.parseLocalDate9(str, off);
                if (localDate == null) {
                    return null;
                }
                return LocalDateTime.of(localDate, LocalTime.MIN);
            }
            case 10: {
                LocalDate localDate = DateUtils.parseLocalDate10(str, off);
                if (localDate == null) {
                    return null;
                }
                return LocalDateTime.of(localDate, LocalTime.MIN);
            }
            case 11: {
                return LocalDateTime.of(DateUtils.parseLocalDate11(str, off), LocalTime.MIN);
            }
            case 12: {
                return DateUtils.parseLocalDateTime12(str, off);
            }
            case 14: {
                return DateUtils.parseLocalDateTime14(str, off);
            }
            case 16: {
                return DateUtils.parseLocalDateTime16(str, off);
            }
            case 17: {
                return DateUtils.parseLocalDateTime17(str, off);
            }
            case 18: {
                return DateUtils.parseLocalDateTime18(str, off);
            }
            case 19: {
                return DateUtils.parseLocalDateTime19(str, off);
            }
            case 20: {
                return DateUtils.parseLocalDateTime20(str, off);
            }
        }
        return DateUtils.parseLocalDateTimeX(str, off, len);
    }

    public static LocalDate parseLocalDate(String str) {
        LocalDate localDate;
        if (str == null) {
            return null;
        }
        if (JDKUtils.STRING_CODER != null && JDKUtils.STRING_VALUE != null && JDKUtils.STRING_CODER.applyAsInt(str) == 0) {
            byte[] bytes = JDKUtils.STRING_VALUE.apply(str);
            localDate = DateUtils.parseLocalDate(bytes, 0, bytes.length);
        } else {
            char[] chars = JDKUtils.getCharArray(str);
            localDate = DateUtils.parseLocalDate(chars, 0, chars.length);
        }
        if (localDate == null) {
            switch (str) {
                case "": 
                case "null": 
                case "00000000": 
                case "0000\u5e7400\u670800\u65e5": 
                case "0000-0-00": 
                case "0000-00-00": {
                    return null;
                }
            }
            throw new DateTimeParseException(str, str, 0);
        }
        return localDate;
    }

    public static LocalDate parseLocalDate(byte[] str, int off, int len) {
        if (str == null || len == 0) {
            return null;
        }
        if (off + len > str.length) {
            String input = new String(str, off, len);
            throw new DateTimeParseException("illegal input " + input, input, 0);
        }
        switch (len) {
            case 8: {
                return DateUtils.parseLocalDate8(str, off);
            }
            case 9: {
                return DateUtils.parseLocalDate9(str, off);
            }
            case 10: {
                return DateUtils.parseLocalDate10(str, off);
            }
            case 11: {
                return DateUtils.parseLocalDate11(str, off);
            }
        }
        if (len == 4 && str[off] == 110 && str[off + 1] == 117 && str[off + 2] == 108 && str[off + 3] == 108) {
            return null;
        }
        String input = new String(str, off, len);
        throw new DateTimeParseException("illegal input " + input, input, 0);
    }

    public static LocalDate parseLocalDate(char[] str, int off, int len) {
        if (str == null || len == 0) {
            return null;
        }
        if (off + len > str.length) {
            String input = new String(str, off, len);
            throw new DateTimeParseException("illegal input " + input, input, 0);
        }
        switch (len) {
            case 8: {
                return DateUtils.parseLocalDate8(str, off);
            }
            case 9: {
                return DateUtils.parseLocalDate9(str, off);
            }
            case 10: {
                return DateUtils.parseLocalDate10(str, off);
            }
            case 11: {
                return DateUtils.parseLocalDate11(str, off);
            }
        }
        if (len == 4 && str[off] == 'n' && str[off + 1] == 'u' && str[off + 2] == 'l' && str[off + 3] == 'l') {
            return null;
        }
        String input = new String(str, off, len);
        throw new DateTimeParseException("illegal input " + input, input, 0);
    }

    public static long parseMillis(byte[] bytes, int off, int len) {
        return DateUtils.parseMillis(bytes, off, len, StandardCharsets.UTF_8, DEFAULT_ZONE_ID);
    }

    public static long parseMillis(byte[] bytes, int off, int len, Charset charset) {
        return DateUtils.parseMillis(bytes, off, len, charset, DEFAULT_ZONE_ID);
    }

    public static long parseMillis(byte[] chars, int off, int len, Charset charset, ZoneId zoneId) {
        char c10;
        long millis;
        if (chars == null || len == 0) {
            return 0L;
        }
        if (len == 4 && IOUtils.isNULL(chars, off)) {
            return 0L;
        }
        char c0 = (char)chars[off];
        if (c0 == '\"' && chars[len - 1] == 34) {
            try (JSONReader jsonReader = JSONReader.of(chars, off, len, charset);){
                Date date = (Date)ObjectReaderImplDate.INSTANCE.readObject(jsonReader, null, null, 0L);
                millis = date.getTime();
            }
        } else if (len == 19) {
            millis = DateUtils.parseMillis19(chars, off, zoneId);
        } else if (len > 19 || len == 16 && ((c10 = (char)chars[off + 10]) == '+' || c10 == '-')) {
            ZonedDateTime zdt = DateUtils.parseZonedDateTime(chars, off, len, zoneId);
            if (zdt == null) {
                String input = new String(chars, off, len - off);
                throw new DateTimeParseException("illegal input " + input, input, 0);
            }
            millis = zdt.toInstant().toEpochMilli();
        } else if ((c0 == '-' || c0 >= '0' && c0 <= '9') && IOUtils.isNumber(chars, off, len)) {
            millis = TypeUtils.parseLong(chars, off, len);
            if (len == 8 && millis >= 19700101L && millis <= 21000101L) {
                int year = (int)millis / 10000;
                int month = (int)millis % 10000 / 100;
                int dom = (int)millis % 100;
                if (month >= 1 && month <= 12) {
                    int max = 31;
                    switch (month) {
                        case 2: {
                            boolean leapYear = (year & 3) == 0 && (year % 100 != 0 || year % 400 == 0);
                            max = leapYear ? 29 : 28;
                            break;
                        }
                        case 4: 
                        case 6: 
                        case 9: 
                        case 11: {
                            max = 30;
                        }
                    }
                    if (dom <= max) {
                        LocalDateTime ldt = LocalDateTime.of(year, month, dom, 0, 0, 0);
                        ZonedDateTime zdt = ZonedDateTime.ofLocal(ldt, zoneId, null);
                        long seconds = zdt.toEpochSecond();
                        millis = seconds * 1000L;
                    }
                }
            }
        } else {
            LocalDateTime ldt;
            char last = (char)chars[len - 1];
            if (last == 'Z') {
                zoneId = ZoneOffset.UTC;
            }
            if ((ldt = DateUtils.parseLocalDateTime(chars, off, len)) == null && IOUtils.getLongLE(chars, off) == 3256155501228994608L && IOUtils.getShortLE(chars, off + 8) == 12336) {
                ldt = LocalDateTime.of(1970, 1, 1, 0, 0, 0);
            }
            ZonedDateTime zdt = ZonedDateTime.ofLocal(ldt, zoneId, null);
            long seconds = zdt.toEpochSecond();
            int nanos = ldt.getNano();
            millis = seconds < 0L && nanos > 0 ? (seconds + 1L) * 1000L + (long)(nanos / 1000000) - 1000L : seconds * 1000L + (long)(nanos / 1000000);
        }
        return millis;
    }

    public static long parseMillis(char[] bytes, int off, int len) {
        return DateUtils.parseMillis(bytes, off, len, DEFAULT_ZONE_ID);
    }

    public static long parseMillis(char[] chars, int off, int len, ZoneId zoneId) {
        char c10;
        long millis;
        if (chars == null || len == 0) {
            return 0L;
        }
        if (len == 4 && IOUtils.isNULL(chars, off)) {
            return 0L;
        }
        char c0 = chars[off];
        if (c0 == '\"' && chars[len - 1] == '\"') {
            try (JSONReader jsonReader = JSONReader.of(chars, off, len);){
                Date date = (Date)ObjectReaderImplDate.INSTANCE.readObject(jsonReader, null, null, 0L);
                millis = date.getTime();
            }
        } else if (len == 19) {
            millis = DateUtils.parseMillis19(chars, off, zoneId);
        } else if (len > 19 || len == 16 && ((c10 = chars[off + 10]) == '+' || c10 == '-')) {
            ZonedDateTime zdt = DateUtils.parseZonedDateTime(chars, off, len, zoneId);
            if (zdt == null) {
                String input = new String(chars, off, len - off);
                throw new DateTimeParseException("illegal input " + input, input, 0);
            }
            millis = zdt.toInstant().toEpochMilli();
        } else if ((c0 == '-' || c0 >= '0' && c0 <= '9') && IOUtils.isNumber(chars, off, len)) {
            millis = TypeUtils.parseLong(chars, off, len);
            if (len == 8 && millis >= 19700101L && millis <= 21000101L) {
                int year = (int)millis / 10000;
                int month = (int)millis % 10000 / 100;
                int dom = (int)millis % 100;
                if (month >= 1 && month <= 12) {
                    int max = 31;
                    switch (month) {
                        case 2: {
                            boolean leapYear = (year & 3) == 0 && (year % 100 != 0 || year % 400 == 0);
                            max = leapYear ? 29 : 28;
                            break;
                        }
                        case 4: 
                        case 6: 
                        case 9: 
                        case 11: {
                            max = 30;
                        }
                    }
                    if (dom <= max) {
                        LocalDateTime ldt = LocalDateTime.of(year, month, dom, 0, 0, 0);
                        ZonedDateTime zdt = ZonedDateTime.ofLocal(ldt, zoneId, null);
                        long seconds = zdt.toEpochSecond();
                        millis = seconds * 1000L;
                    }
                }
            }
        } else {
            LocalDateTime ldt;
            char last = chars[len - 1];
            if (last == 'Z') {
                --len;
                zoneId = ZoneOffset.UTC;
            }
            if ((ldt = DateUtils.parseLocalDateTime(chars, off, len)) == null && IOUtils.getLongLE(chars, off) == 0x30003000300030L && IOUtils.getLongLE(chars, off + 4) == 12666580113555501L && (long)IOUtils.getIntLE(chars, off + 8) == 0x300030L) {
                ldt = LocalDateTime.of(1970, 1, 1, 0, 0, 0);
            }
            if (ldt == null) {
                String input = new String(chars, off, len - off);
                throw new DateTimeParseException("illegal input " + input, input, 0);
            }
            ZonedDateTime zdt = ZonedDateTime.ofLocal(ldt, zoneId, null);
            long seconds = zdt.toEpochSecond();
            int nanos = ldt.getNano();
            millis = seconds < 0L && nanos > 0 ? (seconds + 1L) * 1000L + (long)(nanos / 1000000) - 1000L : seconds * 1000L + (long)(nanos / 1000000);
        }
        return millis;
    }

    public static LocalDate parseLocalDate8(byte[] str, int off) {
        int dom;
        int month;
        int year;
        if (off + 8 > str.length) {
            return null;
        }
        char c1 = (char)str[off + 1];
        char c3 = (char)str[off + 3];
        char c4 = (char)str[off + 4];
        if (c4 == '-' && str[off + 6] == 45) {
            year = IOUtils.digit4(str, off);
            month = IOUtils.digit1(str, off + 5);
            dom = IOUtils.digit1(str, off + 7);
        } else if (c1 == '/' && c3 == '/') {
            month = IOUtils.digit1(str, off);
            dom = IOUtils.digit1(str, off + 2);
            year = IOUtils.digit4(str, off + 4);
        } else if (c1 == '-' && str[off + 5] == 45) {
            dom = IOUtils.digit1(str, off);
            month = DateUtils.month((char)str[off + 2], c3, c4);
            year = IOUtils.digit2(str, off + 6);
            if (year != -1) {
                year += 2000;
            }
        } else {
            year = IOUtils.digit4(str, off);
            month = IOUtils.digit2(str, off + 4);
            dom = IOUtils.digit2(str, off + 6);
        }
        if ((year | month | dom) <= 0) {
            return null;
        }
        return LocalDate.of(year, month, dom);
    }

    public static LocalDate parseLocalDate8(char[] str, int off) {
        int dom;
        int month;
        int year;
        if (off + 8 > str.length) {
            return null;
        }
        char c1 = str[off + 1];
        char c3 = str[off + 3];
        char c4 = str[off + 4];
        if (c4 == '-' && str[off + 6] == '-') {
            year = IOUtils.digit4(str, off);
            month = IOUtils.digit1(str, off + 5);
            dom = IOUtils.digit1(str, off + 7);
        } else if (c1 == '/' && c3 == '/') {
            month = IOUtils.digit1(str, off);
            dom = IOUtils.digit1(str, off + 2);
            year = IOUtils.digit4(str, off + 4);
        } else if (c1 == '-' && str[off + 5] == '-') {
            dom = IOUtils.digit1(str, off);
            month = DateUtils.month(str[off + 2], c3, c4);
            year = IOUtils.digit2(str, off + 6);
            if (year != -1) {
                year += 2000;
            }
        } else {
            year = IOUtils.digit4(str, off);
            month = IOUtils.digit2(str, off + 4);
            dom = IOUtils.digit2(str, off + 6);
        }
        if ((year | month | dom) <= 0) {
            return null;
        }
        return LocalDate.of(year, month, dom);
    }

    public static LocalDate parseLocalDate9(byte[] str, int off) {
        int dom;
        int month;
        int year;
        if (off + 9 > str.length) {
            return null;
        }
        char c1 = (char)str[off + 1];
        char c2 = (char)str[off + 2];
        char c4 = (char)str[off + 4];
        char c6 = (char)str[off + 6];
        char c7 = (char)str[off + 7];
        if (c4 == '-' && c7 == '-' || c4 == '/' && c7 == '/') {
            year = IOUtils.digit4(str, off);
            month = IOUtils.digit2(str, off + 5);
            dom = IOUtils.digit1(str, off + 8);
        } else if (c4 == '-' && c6 == '-' || c4 == '/' && c6 == '/') {
            year = IOUtils.digit4(str, off);
            month = IOUtils.digit1(str, off + 5);
            dom = IOUtils.digit2(str, off + 7);
        } else if (c1 == '.' && c4 == '.') {
            dom = IOUtils.digit1(str, off);
            month = IOUtils.digit2(str, off + 2);
            year = IOUtils.digit4(str, off + 5);
        } else if (c2 == '.' && c4 == '.' || c2 == '-' && c4 == '-') {
            dom = IOUtils.digit2(str, off);
            month = IOUtils.digit1(str, off + 3);
            year = IOUtils.digit4(str, off + 5);
        } else if (c1 == '-' && c4 == '-') {
            dom = IOUtils.digit1(str, off);
            month = IOUtils.digit2(str, off + 2);
            year = IOUtils.digit4(str, off + 5);
        } else if (c2 == '-' && c6 == '-') {
            dom = IOUtils.digit2(str, off);
            month = DateUtils.month((char)str[off + 3], c4, (char)str[off + 5]);
            year = IOUtils.digit2(str, off + 7);
            if (year != -1) {
                year += 2000;
            }
        } else if (c1 == '/' && c4 == '/') {
            month = IOUtils.digit1(str, off);
            dom = IOUtils.digit2(str, off + 2);
            year = IOUtils.digit4(str, off + 5);
        } else if (c2 == '/' && c4 == '/') {
            month = IOUtils.digit2(str, off);
            dom = IOUtils.digit1(str, off + 3);
            year = IOUtils.digit4(str, off + 5);
        } else {
            return null;
        }
        if ((year | month | dom) <= 0) {
            return null;
        }
        return LocalDate.of(year, month, dom);
    }

    public static LocalDate parseLocalDate9(char[] str, int off) {
        int dom;
        int month;
        int year;
        if (off + 9 > str.length) {
            return null;
        }
        char c1 = str[off + 1];
        char c2 = str[off + 2];
        char c4 = str[off + 4];
        char c6 = str[off + 6];
        char c7 = str[off + 7];
        char c8 = str[off + 8];
        if (c4 == '-' && c7 == '-' || c4 == '/' && c7 == '/') {
            year = IOUtils.digit4(str, off);
            month = IOUtils.digit2(str, off + 5);
            dom = IOUtils.digit1(str, off + 8);
        } else if (c4 == '-' && c6 == '-' || c4 == '/' && c6 == '/') {
            year = IOUtils.digit4(str, off);
            month = IOUtils.digit1(str, off + 5);
            dom = IOUtils.digit2(str, off + 7);
        } else if (c4 == '\u5e74' && c6 == '\u6708' && c8 == '\u65e5' || c4 == '\ub144' && c6 == '\uc6d4' && c8 == '\uc77c') {
            year = IOUtils.digit4(str, off);
            month = IOUtils.digit1(str, off + 5);
            dom = IOUtils.digit1(str, off + 7);
        } else if (c1 == '.' && c4 == '.') {
            dom = IOUtils.digit1(str, off);
            month = IOUtils.digit2(str, off + 2);
            year = IOUtils.digit4(str, off + 5);
        } else if (c2 == '.' && c4 == '.' || c2 == '-' && c4 == '-') {
            dom = IOUtils.digit2(str, off);
            month = IOUtils.digit1(str, off + 3);
            year = IOUtils.digit4(str, off + 5);
        } else if (c1 == '-' && c4 == '-') {
            dom = IOUtils.digit1(str, off);
            month = IOUtils.digit2(str, off + 2);
            year = IOUtils.digit4(str, off + 5);
        } else if (c2 == '-' && c6 == '-') {
            dom = IOUtils.digit2(str, off);
            month = DateUtils.month(str[off + 3], c4, str[off + 5]);
            year = IOUtils.digit2(str, off + 7);
            if (year != -1) {
                year += 2000;
            }
        } else if (c1 == '/' && c4 == '/') {
            month = IOUtils.digit1(str, off);
            dom = IOUtils.digit2(str, off + 2);
            year = IOUtils.digit4(str, off + 5);
        } else if (c2 == '/' && c4 == '/') {
            month = IOUtils.digit2(str, off);
            dom = IOUtils.digit1(str, off + 3);
            year = IOUtils.digit4(str, off + 5);
        } else {
            return null;
        }
        if ((year | month | dom) <= 0) {
            return null;
        }
        return LocalDate.of(year, month, dom);
    }

    public static LocalDate parseLocalDate10(byte[] str, int off) {
        int dom;
        int month;
        int year;
        if (off + 10 > str.length) {
            return null;
        }
        char c2 = (char)str[off + 2];
        char c4 = (char)str[off + 4];
        char c5 = (char)str[off + 5];
        char c7 = (char)str[off + 7];
        if (c4 == '-' && c7 == '-' || c4 == '/' && c7 == '/') {
            year = IOUtils.digit4(str, off);
            month = IOUtils.digit2(str, off + 5);
            dom = IOUtils.digit2(str, off + 8);
        } else if (c2 == '.' && c5 == '.' || c2 == '-' && c5 == '-') {
            dom = IOUtils.digit2(str, off);
            month = IOUtils.digit2(str, off + 3);
            year = IOUtils.digit4(str, off + 6);
        } else if (c2 == '/' && c5 == '/') {
            month = IOUtils.digit2(str, off);
            dom = IOUtils.digit2(str, off + 3);
            year = IOUtils.digit4(str, off + 6);
        } else if (str[off + 1] == 32 && c5 == ' ') {
            dom = IOUtils.digit1(str, off);
            month = DateUtils.month(c2, (char)str[off + 3], c4);
            year = IOUtils.digit4(str, off + 6);
        } else {
            return null;
        }
        return (year | month | dom) <= 0 ? null : LocalDate.of(year, month, dom);
    }

    public static LocalDate parseLocalDate10(char[] str, int off) {
        int dom;
        int month;
        int year;
        if (off + 10 > str.length) {
            return null;
        }
        char c1 = str[off + 1];
        char c2 = str[off + 2];
        char c4 = str[off + 4];
        char c5 = str[off + 5];
        char c6 = str[off + 6];
        char c7 = str[off + 7];
        char c9 = str[off + 9];
        if (c4 == '-' && c7 == '-' || c4 == '/' && c7 == '/') {
            year = IOUtils.digit4(str, off);
            month = IOUtils.digit2(str, off + 5);
            dom = IOUtils.digit2(str, off + 8);
        } else if (c2 == '.' && c5 == '.' || c2 == '-' && c5 == '-') {
            dom = IOUtils.digit2(str, off);
            month = IOUtils.digit2(str, off + 3);
            year = IOUtils.digit4(str, off + 6);
        } else if (c2 == '/' && c5 == '/') {
            month = IOUtils.digit2(str, off);
            dom = IOUtils.digit2(str, off + 3);
            year = IOUtils.digit4(str, off + 6);
        } else if (c4 == '\u5e74' && c6 == '\u6708' && c9 == '\u65e5' || c4 == '\ub144' && c6 == '\uc6d4' && c9 == '\uc77c') {
            year = IOUtils.digit4(str, off);
            month = IOUtils.digit1(str, off + 5);
            dom = IOUtils.digit2(str, off + 7);
        } else if (c4 == '\u5e74' && c7 == '\u6708' && c9 == '\u65e5' || c4 == '\ub144' && c7 == '\uc6d4' && c9 == '\uc77c') {
            year = IOUtils.digit4(str, off);
            month = IOUtils.digit2(str, off + 5);
            dom = IOUtils.digit1(str, off + 8);
        } else if (c1 == ' ' && c5 == ' ') {
            dom = IOUtils.digit1(str, off);
            month = DateUtils.month(c2, str[off + 3], c4);
            year = IOUtils.digit4(str, off + 6);
        } else {
            return null;
        }
        return (year | month | dom) <= 0 ? null : LocalDate.of(year, month, dom);
    }

    public static LocalDate parseLocalDate11(char[] str, int off) {
        int dom;
        int month;
        int year;
        if (off + 11 > str.length) {
            return null;
        }
        char c4 = str[off + 4];
        char c7 = str[off + 7];
        char c10 = str[off + 10];
        if (c4 == '\u5e74' && c7 == '\u6708' && c10 == '\u65e5' || c4 == '-' && c7 == '-' && c10 == 'Z' || c4 == '\ub144' && c7 == '\uc6d4' && c10 == '\uc77c') {
            year = IOUtils.digit4(str, off);
            month = IOUtils.digit2(str, off + 5);
            dom = IOUtils.digit2(str, off + 8);
        } else if (str[off + 2] == ' ' && str[off + 6] == ' ') {
            year = IOUtils.digit4(str, off + 7);
            month = DateUtils.month(str[off + 3], c4, str[off + 5]);
            dom = IOUtils.digit2(str, off);
        } else {
            return null;
        }
        if ((year | month | dom) < 0 || year == 0 && month == 0 && dom == 0) {
            return null;
        }
        return LocalDate.of(year, month, dom);
    }

    public static LocalDate parseLocalDate11(byte[] str, int off) {
        int dom;
        int month;
        int year;
        if (off + 11 > str.length) {
            return null;
        }
        if (str[off + 4] == 45 && str[off + 7] == 45 && str[off + 10] == 90) {
            year = IOUtils.digit4(str, off);
            month = IOUtils.digit2(str, off + 5);
            dom = IOUtils.digit2(str, off + 8);
        } else if (str[off + 2] == 32 && str[off + 6] == 32) {
            year = IOUtils.digit4(str, off + 7);
            month = DateUtils.month((char)str[off + 3], (char)str[off + 4], (char)str[off + 5]);
            dom = IOUtils.digit2(str, off);
        } else {
            return null;
        }
        if ((year | month | dom) < 0 || year == 0 && month == 0 && dom == 0) {
            return null;
        }
        return LocalDate.of(year, month, dom);
    }

    public static LocalDateTime parseLocalDateTime12(char[] str, int off) {
        int minute;
        int hour;
        int dom;
        int month;
        if (off + 12 > str.length) {
            String input = new String(str, off, str.length - off);
            throw new DateTimeParseException("illegal input " + input, input, 0);
        }
        int year = IOUtils.digit4(str, off);
        if ((year | (month = IOUtils.digit2(str, off + 4)) | (dom = IOUtils.digit2(str, off + 6)) | (hour = IOUtils.digit2(str, off + 8)) | (minute = IOUtils.digit2(str, off + 10))) < 0) {
            String input = new String(str, off, off + 12);
            throw new DateTimeParseException("illegal input " + input, input, 0);
        }
        if (year == 0 && month == 0 && dom == 0 && hour == 0 && minute == 0) {
            return null;
        }
        return LocalDateTime.of(year, month, dom, hour, minute, 0);
    }

    public static LocalDateTime parseLocalDateTime12(byte[] str, int off) {
        int minute;
        int hour;
        int dom;
        int month;
        if (off + 12 > str.length) {
            String input = new String(str, off, str.length - off);
            throw new DateTimeParseException("illegal input " + input, input, 0);
        }
        int year = IOUtils.digit4(str, off);
        if ((year | (month = IOUtils.digit2(str, off + 4)) | (dom = IOUtils.digit2(str, off + 6)) | (hour = IOUtils.digit2(str, off + 8)) | (minute = IOUtils.digit2(str, off + 10))) < 0) {
            String input = new String(str, off, off + 12);
            throw new DateTimeParseException("illegal input " + input, input, 0);
        }
        if (year == 0 && month == 0 && dom == 0 && hour == 0 && minute == 0) {
            return null;
        }
        return LocalDateTime.of(year, month, dom, hour, minute, 0);
    }

    public static LocalDateTime parseLocalDateTime14(char[] str, int off) {
        int second;
        int minute;
        int hour;
        int dom;
        int month;
        if (off + 14 > str.length) {
            return null;
        }
        int year = IOUtils.digit4(str, off);
        return (year | (month = IOUtils.digit2(str, off + 4)) | (dom = IOUtils.digit2(str, off + 6)) | (hour = IOUtils.digit2(str, off + 8)) | (minute = IOUtils.digit2(str, off + 10)) | (second = IOUtils.digit2(str, off + 12))) < 0 ? null : LocalDateTime.of(year, month, dom, hour, minute, second);
    }

    public static LocalDateTime parseLocalDateTime14(byte[] str, int off) {
        int second;
        int minute;
        int hour;
        int dom;
        int month;
        if (off + 14 > str.length) {
            return null;
        }
        int year = IOUtils.digit4(str, off);
        return (year | (month = IOUtils.digit2(str, off + 4)) | (dom = IOUtils.digit2(str, off + 6)) | (hour = IOUtils.digit2(str, off + 8)) | (minute = IOUtils.digit2(str, off + 10)) | (second = IOUtils.digit2(str, off + 12))) < 0 ? null : LocalDateTime.of(year, month, dom, hour, minute, second);
    }

    public static LocalDateTime parseLocalDateTime16(char[] str, int off) {
        int minute;
        int hour;
        int dom;
        int month;
        int year;
        if (off + 16 > str.length) {
            return null;
        }
        char c1 = str[off + 1];
        char c2 = str[off + 2];
        char c3 = str[off + 3];
        char c4 = str[off + 4];
        char c5 = str[off + 5];
        char c7 = str[off + 7];
        char c10 = str[off + 10];
        char c12 = str[off + 12];
        char c13 = str[off + 13];
        char c14 = str[off + 14];
        int second = 0;
        if (c4 == '-' && c7 == '-' && (c10 == 'T' || c10 == ' ') && c13 == ':') {
            year = IOUtils.digit4(str, off);
            month = IOUtils.digit2(str, off + 5);
            dom = IOUtils.digit2(str, off + 8);
            hour = IOUtils.digit2(str, off + 11);
            minute = IOUtils.digit2(str, off + 14);
        } else if (str[off + 8] == 'T' && str[off + 15] == 'Z') {
            year = IOUtils.digit4(str, off);
            month = IOUtils.digit2(str, off + 4);
            dom = IOUtils.digit2(str, off + 6);
            hour = IOUtils.digit2(str, off + 9);
            minute = IOUtils.digit2(str, off + 11);
            second = IOUtils.digit2(str, off + 13);
        } else if (c4 == '-' && c7 == '-' && (c10 == 'T' || c10 == ' ') && c12 == ':' && c14 == ':') {
            year = IOUtils.digit4(str, off);
            month = IOUtils.digit2(str, off + 5);
            dom = IOUtils.digit2(str, off + 8);
            hour = IOUtils.digit1(str, off + 11);
            minute = IOUtils.digit1(str, off + 13);
            second = IOUtils.digit1(str, off + 15);
        } else if (c1 == ' ' && c5 == ' ' && c10 == ' ' && c13 == ':') {
            dom = IOUtils.digit1(str, off);
            month = DateUtils.month(c2, c3, c4);
            year = IOUtils.digit4(str, off + 6);
            hour = IOUtils.digit2(str, off + 11);
            minute = IOUtils.digit2(str, off + 14);
        } else if (c1 == ' ' && c5 == ' ' && c10 == ' ' && c12 == ':' && c14 == ':') {
            dom = IOUtils.digit1(str, off);
            month = DateUtils.month(c2, c3, c4);
            year = IOUtils.digit4(str, off + 6);
            hour = IOUtils.digit1(str, off + 11);
            minute = IOUtils.digit1(str, off + 13);
            second = IOUtils.digit1(str, off + 15);
        } else {
            return null;
        }
        return (year | month | dom | hour | minute | second) < 0 ? null : LocalDateTime.of(year, month, dom, hour, minute, second);
    }

    public static LocalDateTime parseLocalDateTime16(byte[] str, int off) {
        int minute;
        int hour;
        int dom;
        int month;
        int year;
        if (off + 16 > str.length) {
            return null;
        }
        byte c1 = str[off + 1];
        byte c2 = str[off + 2];
        byte c3 = str[off + 3];
        byte c4 = str[off + 4];
        byte c5 = str[off + 5];
        byte c6 = str[off + 6];
        byte c7 = str[off + 7];
        byte c8 = str[off + 8];
        byte c9 = str[off + 9];
        byte c10 = str[off + 10];
        byte c11 = str[off + 11];
        byte c12 = str[off + 12];
        byte c13 = str[off + 13];
        byte c14 = str[off + 14];
        byte c15 = str[off + 15];
        int second = 0;
        if (c4 == 45 && c7 == 45 && (c10 == 84 || c10 == 32) && c13 == 58) {
            year = IOUtils.digit4(str, off);
            month = IOUtils.digit2(str, off + 5);
            dom = IOUtils.digit2(str, off + 8);
            hour = IOUtils.digit2(str, off + 11);
            minute = IOUtils.digit2(str, off + 14);
        } else if (str[off + 8] == 84 && str[off + 15] == 90) {
            year = IOUtils.digit4(str, off);
            month = IOUtils.digit2(str, off + 4);
            dom = IOUtils.digit2(str, off + 6);
            hour = IOUtils.digit2(str, off + 9);
            minute = IOUtils.digit2(str, off + 11);
            second = IOUtils.digit2(str, off + 13);
        } else if (c4 == 45 && c7 == 45 && (c10 == 84 || c10 == 32) && c12 == 58 && c14 == 58) {
            year = IOUtils.digit4(str, off);
            month = IOUtils.digit2(str, off + 5);
            dom = IOUtils.digit2(str, off + 8);
            hour = IOUtils.digit1(str, off + 11);
            minute = IOUtils.digit1(str, off + 13);
            second = IOUtils.digit1(str, off + 15);
        } else if (c1 == 32 && c5 == 32 && c10 == 32 && c13 == 58) {
            dom = IOUtils.digit1(str, off);
            month = DateUtils.month(c2, c3, c4);
            year = IOUtils.digit4(str, off + 6);
            hour = IOUtils.digit2(str, off + 11);
            minute = IOUtils.digit2(str, off + 14);
        } else if (c1 == 32 && c5 == 32 && c10 == 32 && c12 == 58 && c14 == 58) {
            dom = IOUtils.digit1(str, off);
            month = DateUtils.month(c2, c3, c4);
            year = IOUtils.digit4(str, off + 6);
            hour = IOUtils.digit1(str, off + 11);
            minute = IOUtils.digit1(str, off + 13);
            second = IOUtils.digit1(str, off + 15);
        } else if (c4 == -27 && c5 == -71 && c6 == -76 && c8 == -26 && c9 == -100 && c10 == -120 && c13 == -26 && c14 == -105 && c15 == -91) {
            year = IOUtils.digit4(str, off);
            month = IOUtils.digit1(str, off + 7);
            dom = IOUtils.digit2(str, off + 11);
            hour = 0;
            minute = 0;
        } else if (c4 == -27 && c5 == -71 && c6 == -76 && c9 == -26 && c10 == -100 && c11 == -120 && c13 == -26 && c14 == -105 && c15 == -91) {
            year = IOUtils.digit4(str, off);
            month = IOUtils.digit2(str, off + 7);
            dom = IOUtils.digit1(str, off + 12);
            hour = 0;
            minute = 0;
        } else {
            return null;
        }
        return (year | month | dom | hour | minute | second) < 0 ? null : LocalDateTime.of(year, month, dom, hour, minute, second);
    }

    public static LocalDateTime parseLocalDateTime17(char[] str, int off) {
        int second;
        int minute;
        int hour;
        int dom;
        int month;
        int year;
        if (off + 17 > str.length) {
            String input = new String(str, off, str.length - off);
            throw new DateTimeParseException("illegal input " + input, input, 0);
        }
        char c1 = str[off + 1];
        char c2 = str[off + 2];
        char c3 = str[off + 3];
        char c4 = str[off + 4];
        char c5 = str[off + 5];
        char c6 = str[off + 6];
        char c7 = str[off + 7];
        char c8 = str[off + 8];
        char c10 = str[off + 10];
        char c11 = str[off + 11];
        char c12 = str[off + 12];
        char c13 = str[off + 13];
        char c14 = str[off + 14];
        char c15 = str[off + 15];
        char c16 = str[off + 16];
        int nanoOfSecond = 0;
        if (c4 == '-' && c7 == '-' && (c10 == 'T' || c10 == ' ') && c13 == ':' && c16 == 'Z') {
            year = IOUtils.digit4(str, off);
            month = IOUtils.digit2(str, off + 5);
            dom = IOUtils.digit2(str, off + 8);
            hour = IOUtils.digit2(str, off + 11);
            minute = IOUtils.digit2(str, off + 14);
            second = 0;
        } else if (c4 == '-' && c6 == '-' && (c8 == ' ' || c8 == 'T') && c11 == ':' && c14 == ':') {
            year = IOUtils.digit4(str, off);
            month = IOUtils.digit1(str, off + 5);
            dom = IOUtils.digit1(str, off + 7);
            hour = IOUtils.digit2(str, off + 9);
            minute = IOUtils.digit2(str, off + 12);
            second = IOUtils.digit2(str, off + 15);
        } else if (c2 == ' ' && c6 == ' ' && c11 == ' ' && c14 == ':') {
            dom = IOUtils.digit2(str, off);
            month = DateUtils.month(c3, c4, c5);
            year = IOUtils.digit4(str, off + 7);
            hour = IOUtils.digit2(str, off + 12);
            minute = IOUtils.digit2(str, off + 15);
            second = 0;
        } else if (c1 == ' ' && c5 == ' ' && c10 == ' ' && c12 == ':' && c14 == ':') {
            dom = IOUtils.digit1(str, off);
            month = DateUtils.month(c2, c3, c4);
            year = IOUtils.digit4(str, off + 6);
            hour = IOUtils.digit1(str, off + 11);
            minute = IOUtils.digit1(str, off + 13);
            second = IOUtils.digit2(str, off + 15);
        } else if (c1 == ' ' && c5 == ' ' && c10 == ' ' && c12 == ':' && c15 == ':') {
            dom = IOUtils.digit1(str, off);
            month = DateUtils.month(c2, c3, c4);
            year = IOUtils.digit4(str, off + 6);
            hour = IOUtils.digit1(str, off + 11);
            minute = IOUtils.digit2(str, off + 13);
            second = IOUtils.digit1(str, off + 16);
        } else if (c1 == ' ' && c5 == ' ' && c10 == ' ' && c13 == ':' && c15 == ':') {
            dom = IOUtils.digit1(str, off);
            month = DateUtils.month(c2, c3, c4);
            year = IOUtils.digit4(str, off + 6);
            hour = IOUtils.digit2(str, off + 11);
            minute = IOUtils.digit1(str, off + 14);
            second = IOUtils.digit1(str, off + 16);
        } else if (c2 == ' ' && c6 == ' ' && c11 == ' ' && c13 == ':' && c15 == ':') {
            dom = IOUtils.digit2(str, off);
            month = DateUtils.month(c3, c4, c5);
            year = IOUtils.digit4(str, off + 7);
            hour = IOUtils.digit1(str, off + 12);
            minute = IOUtils.digit1(str, off + 14);
            second = IOUtils.digit1(str, off + 16);
        } else {
            year = IOUtils.digit4(str, off);
            month = IOUtils.digit2(str, off + 4);
            dom = IOUtils.digit2(str, off + 6);
            hour = IOUtils.digit2(str, off + 8);
            minute = IOUtils.digit2(str, off + 10);
            second = IOUtils.digit2(str, off + 12);
            nanoOfSecond = DateUtils.readNanos(str, 3, off + 14);
        }
        return (year | month | dom | hour | minute | second | nanoOfSecond) < 0 ? null : LocalDateTime.of(year, month, dom, hour, minute, second, nanoOfSecond);
    }

    public static LocalDateTime parseLocalDateTime17(byte[] str, int off) {
        int minute;
        int hour;
        int dom;
        int month;
        int year;
        if (off + 17 > str.length) {
            String input = new String(str, off, str.length - off);
            throw new DateTimeParseException("illegal input " + input, input, 0);
        }
        byte c1 = str[off + 1];
        byte c2 = str[off + 2];
        byte c3 = str[off + 3];
        byte c4 = str[off + 4];
        byte c5 = str[off + 5];
        byte c6 = str[off + 6];
        byte c7 = str[off + 7];
        byte c8 = str[off + 8];
        byte c9 = str[off + 9];
        byte c10 = str[off + 10];
        byte c11 = str[off + 11];
        byte c12 = str[off + 12];
        byte c13 = str[off + 13];
        byte c14 = str[off + 14];
        byte c15 = str[off + 15];
        byte c16 = str[off + 16];
        int second = 0;
        int nanoOfSecond = 0;
        if (c4 == 45 && c7 == 45 && (c10 == 84 || c10 == 32) && c13 == 58 && c16 == 90) {
            year = IOUtils.digit4(str, off);
            month = IOUtils.digit2(str, off + 5);
            dom = IOUtils.digit2(str, off + 8);
            hour = IOUtils.digit2(str, off + 11);
            minute = IOUtils.digit2(str, off + 14);
            second = 0;
        } else if (c4 == 45 && c6 == 45 && (c8 == 32 || c8 == 84) && c11 == 58 && c14 == 58) {
            year = IOUtils.digit4(str, off);
            month = IOUtils.digit1(str, off + 5);
            dom = IOUtils.digit1(str, off + 7);
            hour = IOUtils.digit2(str, off + 9);
            minute = IOUtils.digit2(str, off + 12);
            second = IOUtils.digit2(str, off + 15);
        } else if (c2 == 32 && c6 == 32 && c11 == 32 && c14 == 58) {
            dom = IOUtils.digit2(str, off);
            month = DateUtils.month(c3, c4, c5);
            year = IOUtils.digit4(str, off + 7);
            hour = IOUtils.digit2(str, off + 12);
            minute = IOUtils.digit2(str, off + 15);
            second = 0;
        } else if (c1 == 32 && c5 == 32 && c10 == 32 && c12 == 58 && c14 == 58) {
            dom = IOUtils.digit1(str, off);
            month = DateUtils.month(c2, c3, c4);
            year = IOUtils.digit4(str, off + 6);
            hour = IOUtils.digit1(str, off + 11);
            minute = IOUtils.digit1(str, off + 13);
            second = IOUtils.digit2(str, off + 15);
        } else if (c1 == 32 && c5 == 32 && c10 == 32 && c12 == 58 && c15 == 58) {
            dom = IOUtils.digit1(str, off);
            month = DateUtils.month(c2, c3, c4);
            year = IOUtils.digit4(str, off + 6);
            hour = IOUtils.digit1(str, off + 11);
            minute = IOUtils.digit2(str, off + 13);
            second = IOUtils.digit1(str, off + 16);
        } else if (c1 == 32 && c5 == 32 && c10 == 32 && c13 == 58 && c15 == 58) {
            dom = IOUtils.digit1(str, off);
            month = DateUtils.month(c2, c3, c4);
            year = IOUtils.digit4(str, off + 6);
            hour = IOUtils.digit2(str, off + 11);
            minute = IOUtils.digit1(str, off + 14);
            second = IOUtils.digit1(str, off + 16);
        } else if (c2 == 32 && c6 == 32 && c11 == 32 && c13 == 58 && c15 == 58) {
            dom = IOUtils.digit2(str, off);
            month = DateUtils.month(c3, c4, c5);
            year = IOUtils.digit4(str, off + 7);
            hour = IOUtils.digit1(str, off + 12);
            minute = IOUtils.digit1(str, off + 14);
            second = IOUtils.digit1(str, off + 16);
        } else if (c4 == -27 && c5 == -71 && c6 == -76 && c9 == -26 && c10 == -100 && c11 == -120 && c14 == -26 && c15 == -105 && c16 == -91) {
            year = IOUtils.digit4(str, off);
            month = IOUtils.digit2(str, off + 7);
            dom = IOUtils.digit2(str, off + 12);
            hour = 0;
            minute = 0;
        } else {
            year = IOUtils.digit4(str, off);
            month = IOUtils.digit2(str, off + 4);
            dom = IOUtils.digit2(str, off + 6);
            hour = IOUtils.digit2(str, off + 8);
            minute = IOUtils.digit2(str, off + 10);
            second = IOUtils.digit2(str, off + 12);
            nanoOfSecond = DateUtils.readNanos(str, 3, off + 14);
        }
        return (year | month | dom | hour | minute | second | nanoOfSecond) < 0 ? null : LocalDateTime.of(year, month, dom, hour, minute, second, nanoOfSecond);
    }

    public static LocalDateTime parseLocalDateTime18(char[] str, int off) {
        int second;
        int minute;
        int hour;
        int dom;
        int month;
        int year;
        if (off + 18 > str.length) {
            String input = new String(str, off, str.length - off);
            throw new DateTimeParseException("illegal input " + input, input, 0);
        }
        char c1 = str[off + 1];
        char c2 = str[off + 2];
        char c3 = str[off + 3];
        char c4 = str[off + 4];
        char c5 = str[off + 5];
        char c6 = str[off + 6];
        char c7 = str[off + 7];
        char c9 = str[off + 9];
        char c10 = str[off + 10];
        char c11 = str[off + 11];
        char c12 = str[off + 12];
        char c13 = str[off + 13];
        char c14 = str[off + 14];
        char c15 = str[off + 15];
        char c16 = str[off + 16];
        if (c4 == '-' && c6 == '-' && (c9 == ' ' || c9 == 'T') && c12 == ':' && c15 == ':') {
            year = IOUtils.digit4(str, off);
            month = IOUtils.digit1(str, off + 5);
            dom = IOUtils.digit2(str, off + 7);
            hour = IOUtils.digit2(str, off + 10);
            minute = IOUtils.digit2(str, off + 13);
            second = IOUtils.digit2(str, off + 16);
        } else if (c4 == '-' && c7 == '-' && (c9 == ' ' || c9 == 'T') && c12 == ':' && c15 == ':') {
            year = IOUtils.digit4(str, off);
            month = IOUtils.digit2(str, off + 5);
            dom = IOUtils.digit1(str, off + 8);
            hour = IOUtils.digit2(str, off + 10);
            minute = IOUtils.digit2(str, off + 13);
            second = IOUtils.digit2(str, off + 16);
        } else if (c4 == '-' && c7 == '-' && (c10 == ' ' || c10 == 'T') && c12 == ':' && c15 == ':') {
            year = IOUtils.digit4(str, off);
            month = IOUtils.digit2(str, off + 5);
            dom = IOUtils.digit2(str, off + 8);
            hour = IOUtils.digit1(str, off + 11);
            minute = IOUtils.digit2(str, off + 13);
            second = IOUtils.digit2(str, off + 16);
        } else if (c4 == '-' && c7 == '-' && (c10 == ' ' || c10 == 'T') && c13 == ':' && c15 == ':') {
            year = IOUtils.digit4(str, off);
            month = IOUtils.digit2(str, off + 5);
            dom = IOUtils.digit2(str, off + 8);
            hour = IOUtils.digit2(str, off + 11);
            minute = IOUtils.digit1(str, off + 14);
            second = IOUtils.digit2(str, off + 16);
        } else if (c4 == '-' && c7 == '-' && (c10 == ' ' || c10 == 'T') && c13 == ':' && c16 == ':') {
            year = IOUtils.digit4(str, off);
            month = IOUtils.digit2(str, off + 5);
            dom = IOUtils.digit2(str, off + 8);
            hour = IOUtils.digit2(str, off + 11);
            minute = IOUtils.digit2(str, off + 14);
            second = IOUtils.digit1(str, off + 17);
        } else if (c1 == ' ' && c5 == ' ' && c10 == ' ' && c12 == ':' && c15 == ':') {
            dom = IOUtils.digit1(str, off);
            month = DateUtils.month(c2, c3, c4);
            year = IOUtils.digit4(str, off + 6);
            hour = IOUtils.digit1(str, off + 11);
            minute = IOUtils.digit2(str, off + 13);
            second = IOUtils.digit2(str, off + 16);
        } else if (c1 == ' ' && c5 == ' ' && c10 == ' ' && c13 == ':' && c15 == ':') {
            dom = IOUtils.digit1(str, off);
            month = DateUtils.month(c2, c3, c4);
            year = IOUtils.digit4(str, off + 6);
            hour = IOUtils.digit2(str, off + 11);
            minute = IOUtils.digit1(str, off + 14);
            second = IOUtils.digit2(str, off + 16);
        } else if (c1 == ' ' && c5 == ' ' && c10 == ' ' && c13 == ':' && c16 == ':') {
            dom = IOUtils.digit1(str, off);
            month = DateUtils.month(c2, c3, c4);
            year = IOUtils.digit4(str, off + 6);
            hour = IOUtils.digit2(str, off + 11);
            minute = IOUtils.digit2(str, off + 14);
            second = IOUtils.digit1(str, off + 17);
        } else if (c2 == ' ' && c6 == ' ' && c11 == ' ' && c14 == ':' && c16 == ':') {
            dom = IOUtils.digit2(str, off);
            month = DateUtils.month(c3, c4, c5);
            year = IOUtils.digit4(str, off + 7);
            hour = IOUtils.digit2(str, off + 12);
            minute = IOUtils.digit1(str, off + 15);
            second = IOUtils.digit1(str, off + 17);
        } else if (c2 == ' ' && c6 == ' ' && c11 == ' ' && c13 == ':' && c16 == ':') {
            dom = IOUtils.digit2(str, off);
            month = DateUtils.month(c3, c4, c5);
            year = IOUtils.digit4(str, off + 7);
            hour = IOUtils.digit1(str, off + 12);
            minute = IOUtils.digit2(str, off + 14);
            second = IOUtils.digit1(str, off + 17);
        } else if (c2 == ' ' && c6 == ' ' && c11 == ' ' && c13 == ':' && c15 == ':') {
            dom = IOUtils.digit2(str, off);
            month = DateUtils.month(c3, c4, c5);
            year = IOUtils.digit4(str, off + 7);
            hour = IOUtils.digit1(str, off + 12);
            minute = IOUtils.digit1(str, off + 14);
            second = IOUtils.digit2(str, off + 16);
        } else {
            String input = new String(str, off, 18);
            throw new DateTimeParseException("illegal input " + input, input, 0);
        }
        return (year | month | dom | hour | minute | second) < 0 ? null : LocalDateTime.of(year, month, dom, hour, minute, second);
    }

    public static LocalDateTime parseLocalDateTime18(byte[] str, int off) {
        int second;
        int minute;
        int hour;
        int dom;
        int month;
        int year;
        if (off + 18 > str.length) {
            String input = new String(str, off, str.length - off);
            throw new DateTimeParseException("illegal input " + input, input, 0);
        }
        byte c1 = str[off + 1];
        byte c2 = str[off + 2];
        byte c3 = str[off + 3];
        byte c4 = str[off + 4];
        byte c5 = str[off + 5];
        byte c6 = str[off + 6];
        byte c7 = str[off + 7];
        byte c9 = str[off + 9];
        byte c10 = str[off + 10];
        byte c11 = str[off + 11];
        byte c12 = str[off + 12];
        byte c13 = str[off + 13];
        byte c14 = str[off + 14];
        byte c15 = str[off + 15];
        byte c16 = str[off + 16];
        if (c4 == 45 && c6 == 45 && (c9 == 32 || c9 == 84) && c12 == 58 && c15 == 58) {
            year = IOUtils.digit4(str, off);
            month = IOUtils.digit1(str, off + 5);
            dom = IOUtils.digit2(str, off + 7);
            hour = IOUtils.digit2(str, off + 10);
            minute = IOUtils.digit2(str, off + 13);
            second = IOUtils.digit2(str, off + 16);
        } else if (c4 == 45 && c7 == 45 && (c9 == 32 || c9 == 84) && c12 == 58 && c15 == 58) {
            year = IOUtils.digit4(str, off);
            month = IOUtils.digit2(str, off + 5);
            dom = IOUtils.digit1(str, off + 8);
            hour = IOUtils.digit2(str, off + 10);
            minute = IOUtils.digit2(str, off + 13);
            second = IOUtils.digit2(str, off + 16);
        } else if (c4 == 45 && c7 == 45 && (c10 == 32 || c10 == 84) && c12 == 58 && c15 == 58) {
            year = IOUtils.digit4(str, off);
            month = IOUtils.digit2(str, off + 5);
            dom = IOUtils.digit2(str, off + 8);
            hour = IOUtils.digit1(str, off + 11);
            minute = IOUtils.digit2(str, off + 13);
            second = IOUtils.digit2(str, off + 16);
        } else if (c4 == 45 && c7 == 45 && (c10 == 32 || c10 == 84) && c13 == 58 && c15 == 58) {
            year = IOUtils.digit4(str, off);
            month = IOUtils.digit2(str, off + 5);
            dom = IOUtils.digit2(str, off + 8);
            hour = IOUtils.digit2(str, off + 11);
            minute = IOUtils.digit1(str, off + 14);
            second = IOUtils.digit2(str, off + 16);
        } else if (c4 == 45 && c7 == 45 && (c10 == 32 || c10 == 84) && c13 == 58 && c16 == 58) {
            year = IOUtils.digit4(str, off);
            month = IOUtils.digit2(str, off + 5);
            dom = IOUtils.digit2(str, off + 8);
            hour = IOUtils.digit2(str, off + 11);
            minute = IOUtils.digit2(str, off + 14);
            second = IOUtils.digit1(str, off + 17);
        } else if (c1 == 32 && c5 == 32 && c10 == 32 && c12 == 58 && c15 == 58) {
            dom = IOUtils.digit1(str, off);
            month = DateUtils.month(c2, c3, c4);
            year = IOUtils.digit4(str, off + 6);
            hour = IOUtils.digit1(str, off + 11);
            minute = IOUtils.digit2(str, off + 13);
            second = IOUtils.digit2(str, off + 16);
        } else if (c1 == 32 && c5 == 32 && c10 == 32 && c13 == 58 && c15 == 58) {
            dom = IOUtils.digit1(str, off);
            month = DateUtils.month(c2, c3, c4);
            year = IOUtils.digit4(str, off + 6);
            hour = IOUtils.digit2(str, off + 11);
            minute = IOUtils.digit1(str, off + 14);
            second = IOUtils.digit2(str, off + 16);
        } else if (c1 == 32 && c5 == 32 && c10 == 32 && c13 == 58 && c16 == 58) {
            dom = IOUtils.digit1(str, off);
            month = DateUtils.month(c2, c3, c4);
            year = IOUtils.digit4(str, off + 6);
            hour = IOUtils.digit2(str, off + 11);
            minute = IOUtils.digit2(str, off + 14);
            second = IOUtils.digit1(str, off + 17);
        } else if (c2 == 32 && c6 == 32 && c11 == 32 && c14 == 58 && c16 == 58) {
            dom = IOUtils.digit2(str, off);
            month = DateUtils.month(c3, c4, c5);
            year = IOUtils.digit4(str, off + 7);
            hour = IOUtils.digit2(str, off + 12);
            minute = IOUtils.digit1(str, off + 15);
            second = IOUtils.digit1(str, off + 17);
        } else if (c2 == 32 && c6 == 32 && c11 == 32 && c13 == 58 && c16 == 58) {
            dom = IOUtils.digit2(str, off);
            month = DateUtils.month(c3, c4, c5);
            year = IOUtils.digit4(str, off + 7);
            hour = IOUtils.digit1(str, off + 12);
            minute = IOUtils.digit2(str, off + 14);
            second = IOUtils.digit1(str, off + 17);
        } else if (c2 == 32 && c6 == 32 && c11 == 32 && c13 == 58 && c15 == 58) {
            dom = IOUtils.digit2(str, off);
            month = DateUtils.month(c3, c4, c5);
            year = IOUtils.digit4(str, off + 7);
            hour = IOUtils.digit1(str, off + 12);
            minute = IOUtils.digit1(str, off + 14);
            second = IOUtils.digit2(str, off + 16);
        } else {
            String input = new String(str, off, 18);
            throw new DateTimeParseException("illegal input " + input, input, 0);
        }
        return (year | month | dom | hour | minute | second) < 0 ? null : LocalDateTime.of(year, month, dom, hour, minute, second);
    }

    public static LocalDateTime parseLocalDateTime19(char[] str, int off) {
        int second;
        int minute;
        int hour;
        int dom;
        int month;
        int year;
        if (off + 19 > str.length) {
            return null;
        }
        char c1 = str[off + 1];
        char c2 = str[off + 2];
        char c3 = str[off + 3];
        char c4 = str[off + 4];
        char c5 = str[off + 5];
        char c7 = str[off + 7];
        char c10 = str[off + 10];
        char c13 = str[off + 13];
        char c16 = str[off + 16];
        if ((c4 == '-' && c7 == '-' || c4 == '/' && c7 == '/') && (c10 == ' ' || c10 == 'T') && c13 == ':' && c16 == ':') {
            year = IOUtils.digit4(str, off);
            month = IOUtils.digit2(str, off + 5);
            dom = IOUtils.digit2(str, off + 8);
            hour = IOUtils.digit2(str, off + 11);
            minute = IOUtils.digit2(str, off + 14);
            second = IOUtils.digit2(str, off + 17);
        } else if (c2 == '/' && c5 == '/' && (c10 == ' ' || c10 == 'T') && c13 == ':' && c16 == ':') {
            dom = IOUtils.digit2(str, off);
            month = IOUtils.digit2(str, off + 3);
            year = IOUtils.digit4(str, off + 6);
            hour = IOUtils.digit2(str, off + 11);
            minute = IOUtils.digit2(str, off + 14);
            second = IOUtils.digit2(str, off + 17);
        } else if (c1 == ' ' && c5 == ' ' && c10 == ' ' && c13 == ':' && c16 == ':') {
            dom = IOUtils.digit1(str, off);
            month = DateUtils.month(c2, c3, c4);
            year = IOUtils.digit4(str, off + 6);
            hour = IOUtils.digit2(str, off + 11);
            minute = IOUtils.digit2(str, off + 14);
            second = IOUtils.digit2(str, off + 17);
        } else {
            return null;
        }
        return (year | month | dom | hour | minute | second) <= 0 ? null : LocalDateTime.of(year, month, dom, hour, minute, second);
    }

    public static LocalDateTime parseLocalDateTime19(String str, int off) {
        LocalDateTime ldt;
        if (off + 19 > str.length()) {
            return null;
        }
        if (JDKUtils.STRING_CODER != null && JDKUtils.STRING_VALUE != null && JDKUtils.STRING_CODER.applyAsInt(str) == 0) {
            byte[] bytes = JDKUtils.STRING_VALUE.apply(str);
            ldt = DateUtils.parseLocalDateTime19(bytes, off);
        } else if (JDKUtils.JVM_VERSION == 8 && !JDKUtils.FIELD_STRING_VALUE_ERROR) {
            char[] chars = JDKUtils.getCharArray(str);
            ldt = DateUtils.parseLocalDateTime19(chars, off);
        } else {
            char[] chars = new char[19];
            str.getChars(off, off + 19, chars, 0);
            ldt = DateUtils.parseLocalDateTime19(chars, off);
        }
        return ldt;
    }

    public static LocalDateTime parseLocalDateTime19(byte[] str, int off) {
        int dom;
        int month;
        int year;
        if (off + 19 > str.length) {
            return null;
        }
        byte c1 = str[off + 1];
        byte c2 = str[off + 2];
        byte c3 = str[off + 3];
        byte c4 = str[off + 4];
        byte c5 = str[off + 5];
        byte c7 = str[off + 7];
        byte c10 = str[off + 10];
        if ((c4 == 45 && c7 == 45 || c4 == 47 && c7 == 47) && (c10 == 32 || c10 == 84)) {
            year = IOUtils.digit4(str, off);
            month = IOUtils.digit2(str, off + 5);
            dom = IOUtils.digit2(str, off + 8);
        } else if (c2 == 47 && c5 == 47 && (c10 == 32 || c10 == 84)) {
            dom = IOUtils.digit2(str, off);
            month = IOUtils.digit2(str, off + 3);
            year = IOUtils.digit4(str, off + 6);
        } else if (c1 == 32 && c5 == 32 && c10 == 32) {
            dom = IOUtils.digit1(str, off);
            month = DateUtils.month(c2, c3, c4);
            year = IOUtils.digit4(str, off + 6);
        } else {
            return null;
        }
        long hms = DateUtils.hms(str, off + 11);
        if (((long)(year | month | dom) | hms) <= 0L) {
            return null;
        }
        int hour = (int)hms & 0xFF;
        int minute = (int)(hms >> 24) & 0xFF;
        int second = (int)(hms >> 48) & 0xFF;
        return LocalDateTime.of(year, month, dom, hour, minute, second);
    }

    public static LocalDateTime parseLocalDateTime20(char[] str, int off) {
        int second;
        int minute;
        int hour;
        if (off + 19 > str.length || str[off + 2] != ' ' || str[off + 6] != ' ' || str[off + 11] != ' ' || str[off + 14] != ':' || str[off + 17] != ':') {
            return null;
        }
        int dom = IOUtils.digit2(str, off);
        int month = DateUtils.month(str[off + 3], str[off + 4], str[off + 5]);
        int year = IOUtils.digit4(str, off + 7);
        return (year | month | dom | (hour = IOUtils.digit2(str, off + 12)) | (minute = IOUtils.digit2(str, off + 15)) | (second = IOUtils.digit2(str, off + 18))) <= 0 || hour > 24 || minute > 59 || second > 60 ? null : LocalDateTime.of(year, month, dom, hour, minute, second);
    }

    public static LocalDateTime parseLocalDateTime20(byte[] str, int off) {
        int second;
        int minute;
        int hour;
        long hms;
        if (off + 19 > str.length || str[off + 2] != 32 || str[off + 6] != 32 || str[off + 11] != 32 || (hms = DateUtils.hms(str, off + 12)) == -1L) {
            return null;
        }
        int dom = IOUtils.digit2(str, off);
        int month = DateUtils.month(str[off + 3], str[off + 4], str[off + 5]);
        int year = IOUtils.digit4(str, off + 7);
        return (year | month | dom | (hour = (int)hms & 0xFF) | (minute = (int)(hms >> 24) & 0xFF) | (second = (int)(hms >> 48) & 0xFF)) <= 0 || hour > 24 || minute > 59 || second > 60 ? null : LocalDateTime.of(year, month, dom, hour, minute, second);
    }

    public static LocalDateTime parseLocalDateTime26(byte[] str, int off) {
        int nano;
        int second;
        int minute;
        int hour;
        int dom;
        int month;
        long hms;
        byte c10;
        if (off + 26 > str.length || str[off + 4] != 45 || str[off + 7] != 45 || (c10 = str[off + 10]) != 32 && c10 != 84 || (hms = DateUtils.hms(str, off + 11)) == -1L || str[off + 19] != 46) {
            return null;
        }
        int year = IOUtils.digit4(str, off);
        return (year | (month = IOUtils.digit2(str, off + 5)) | (dom = IOUtils.digit2(str, off + 8)) | (hour = (int)hms & 0xFF) | (minute = (int)(hms >> 24) & 0xFF) | (second = (int)(hms >> 48) & 0xFF) | (nano = DateUtils.readNanos(str, 6, off + 20))) <= 0 || hour > 24 || minute > 59 || second > 60 ? null : LocalDateTime.of(year, month, dom, hour, minute, second, nano);
    }

    public static LocalDateTime parseLocalDateTime26(char[] str, int off) {
        int nano;
        int second;
        int minute;
        int hour;
        int dom;
        int month;
        char c10;
        if (off + 26 > str.length || str[off + 4] != '-' || str[off + 7] != '-' || (c10 = str[off + 10]) != ' ' && c10 != 'T' || str[off + 13] != ':' || str[off + 16] != ':' || str[off + 19] != '.') {
            return null;
        }
        int year = IOUtils.digit4(str, off);
        return (year | (month = IOUtils.digit2(str, off + 5)) | (dom = IOUtils.digit2(str, off + 8)) | (hour = IOUtils.digit2(str, off + 11)) | (minute = IOUtils.digit2(str, off + 14)) | (second = IOUtils.digit2(str, off + 17)) | (nano = DateUtils.readNanos(str, 6, off + 20))) <= 0 || hour > 24 || minute > 59 || second > 60 ? null : LocalDateTime.of(year, month, dom, hour, minute, second, nano);
    }

    public static LocalDateTime parseLocalDateTime27(byte[] str, int off) {
        int nano;
        int second;
        int minute;
        int hour;
        int dom;
        int month;
        long hms;
        byte c10;
        if (off + 27 > str.length || str[off + 4] != 45 || str[off + 7] != 45 || (c10 = str[off + 10]) != 32 && c10 != 84 || (hms = DateUtils.hms(str, off + 11)) == -1L || str[off + 19] != 46) {
            return null;
        }
        int year = IOUtils.digit4(str, off);
        return (year | (month = IOUtils.digit2(str, off + 5)) | (dom = IOUtils.digit2(str, off + 8)) | (hour = (int)hms & 0xFF) | (minute = (int)(hms >> 24) & 0xFF) | (second = (int)(hms >> 48) & 0xFF) | (nano = DateUtils.readNanos(str, 7, off + 20))) <= 0 || hour > 24 || minute > 59 || second > 60 ? null : LocalDateTime.of(year, month, dom, hour, minute, second, nano);
    }

    public static LocalDateTime parseLocalDateTime27(char[] str, int off) {
        int nano;
        int second;
        int minute;
        int hour;
        int dom;
        int month;
        char c10;
        if (off + 27 > str.length || str[off + 4] != '-' || str[off + 7] != '-' || (c10 = str[off + 10]) != ' ' && c10 != 'T' || str[off + 13] != ':' || str[off + 16] != ':' || str[off + 19] != '.') {
            return null;
        }
        int year = IOUtils.digit4(str, off);
        return (year | (month = IOUtils.digit2(str, off + 5)) | (dom = IOUtils.digit2(str, off + 8)) | (hour = IOUtils.digit2(str, off + 11)) | (minute = IOUtils.digit2(str, off + 14)) | (second = IOUtils.digit2(str, off + 17)) | (nano = DateUtils.readNanos(str, 7, off + 20))) <= 0 || hour > 24 || minute > 59 || second > 60 ? null : LocalDateTime.of(year, month, dom, hour, minute, second, nano);
    }

    public static LocalDateTime parseLocalDateTime28(char[] str, int off) {
        int nano;
        int second;
        int minute;
        int hour;
        int dom;
        int month;
        char c10;
        if (off + 28 > str.length || str[off + 4] != '-' || str[off + 7] != '-' || (c10 = str[off + 10]) != ' ' && c10 != 'T' || str[off + 13] != ':' || str[off + 16] != ':' || str[off + 19] != '.') {
            return null;
        }
        int year = IOUtils.digit4(str, off);
        return (year | (month = IOUtils.digit2(str, off + 5)) | (dom = IOUtils.digit2(str, off + 8)) | (hour = IOUtils.digit2(str, off + 11)) | (minute = IOUtils.digit2(str, off + 14)) | (second = IOUtils.digit2(str, off + 17)) | (nano = DateUtils.readNanos(str, 8, off + 20))) <= 0 || hour > 24 || minute > 59 || second > 60 ? null : LocalDateTime.of(year, month, dom, hour, minute, second, nano);
    }

    public static LocalDateTime parseLocalDateTime28(byte[] str, int off) {
        int nano;
        int second;
        int minute;
        int hour;
        int dom;
        int month;
        long hms;
        byte c10;
        if (off + 28 > str.length || str[off + 4] != 45 || str[off + 7] != 45 || (c10 = str[off + 10]) != 32 && c10 != 84 || (hms = DateUtils.hms(str, off + 11)) == -1L || str[off + 19] != 46) {
            return null;
        }
        int year = IOUtils.digit4(str, off);
        return (year | (month = IOUtils.digit2(str, off + 5)) | (dom = IOUtils.digit2(str, off + 8)) | (hour = (int)hms & 0xFF) | (minute = (int)(hms >> 24) & 0xFF) | (second = (int)(hms >> 48) & 0xFF) | (nano = DateUtils.readNanos(str, 8, off + 20))) <= 0 || hour > 24 || minute > 59 || second > 60 ? null : LocalDateTime.of(year, month, dom, hour, minute, second, nano);
    }

    public static LocalDateTime parseLocalDateTime29(byte[] str, int off) {
        int nano;
        int second;
        int minute;
        int hour;
        int dom;
        int month;
        long hms;
        byte c10;
        if (off + 29 > str.length || str[off + 4] != 45 || str[off + 7] != 45 || (c10 = str[off + 10]) != 32 && c10 != 84 || (hms = DateUtils.hms(str, off + 11)) == -1L || str[off + 19] != 46) {
            return null;
        }
        int year = IOUtils.digit4(str, off);
        return (year | (month = IOUtils.digit2(str, off + 5)) | (dom = IOUtils.digit2(str, off + 8)) | (hour = (int)hms & 0xFF) | (minute = (int)(hms >> 24) & 0xFF) | (second = (int)(hms >> 48) & 0xFF) | (nano = DateUtils.readNanos(str, 9, off + 20))) <= 0 || hour > 24 || minute > 59 || second > 60 ? null : LocalDateTime.of(year, month, dom, hour, minute, second, nano);
    }

    public static LocalDateTime parseLocalDateTime29(char[] str, int off) {
        int nano;
        int second;
        int minute;
        int hour;
        int dom;
        int month;
        char c10;
        if (off + 29 > str.length || str[off + 4] != '-' || str[off + 7] != '-' || (c10 = str[off + 10]) != ' ' && c10 != 'T' || str[off + 13] != ':' || str[off + 16] != ':' || str[off + 19] != '.') {
            return null;
        }
        int year = IOUtils.digit4(str, off);
        return (year | (month = IOUtils.digit2(str, off + 5)) | (dom = IOUtils.digit2(str, off + 8)) | (hour = IOUtils.digit2(str, off + 11)) | (minute = IOUtils.digit2(str, off + 14)) | (second = IOUtils.digit2(str, off + 17)) | (nano = DateUtils.readNanos(str, 9, off + 20))) <= 0 || hour > 24 || minute > 59 || second > 60 ? null : LocalDateTime.of(year, month, dom, hour, minute, second, nano);
    }

    public static LocalDateTime parseLocalDateTimeX(char[] str, int offset, int len) {
        char c20;
        if (str == null || len == 0) {
            return null;
        }
        if (len < 21 || len > 29) {
            return null;
        }
        char c0 = str[offset];
        char c1 = str[offset + 1];
        char c2 = str[offset + 2];
        char c3 = str[offset + 3];
        char c4 = str[offset + 4];
        char c5 = str[offset + 5];
        char c6 = str[offset + 6];
        char c7 = str[offset + 7];
        char c8 = str[offset + 8];
        char c9 = str[offset + 9];
        char c10 = str[offset + 10];
        char c11 = str[offset + 11];
        char c12 = str[offset + 12];
        char c13 = str[offset + 13];
        char c14 = str[offset + 14];
        char c15 = str[offset + 15];
        char c16 = str[offset + 16];
        char c17 = str[offset + 17];
        char c18 = str[offset + 18];
        char c19 = str[offset + 19];
        char c21 = '0';
        char c22 = '0';
        char c23 = '0';
        char c24 = '0';
        char c25 = '0';
        char c26 = '0';
        char c27 = '0';
        char c28 = '0';
        switch (len) {
            case 21: {
                c20 = str[offset + 20];
                break;
            }
            case 22: {
                c20 = str[offset + 20];
                c21 = str[offset + 21];
                break;
            }
            case 23: {
                c20 = str[offset + 20];
                c21 = str[offset + 21];
                c22 = str[offset + 22];
                break;
            }
            case 24: {
                c20 = str[offset + 20];
                c21 = str[offset + 21];
                c22 = str[offset + 22];
                c23 = str[offset + 23];
                break;
            }
            case 25: {
                c20 = str[offset + 20];
                c21 = str[offset + 21];
                c22 = str[offset + 22];
                c23 = str[offset + 23];
                c24 = str[offset + 24];
                break;
            }
            case 26: {
                c20 = str[offset + 20];
                c21 = str[offset + 21];
                c22 = str[offset + 22];
                c23 = str[offset + 23];
                c24 = str[offset + 24];
                c25 = str[offset + 25];
                break;
            }
            case 27: {
                c20 = str[offset + 20];
                c21 = str[offset + 21];
                c22 = str[offset + 22];
                c23 = str[offset + 23];
                c24 = str[offset + 24];
                c25 = str[offset + 25];
                c26 = str[offset + 26];
                break;
            }
            case 28: {
                c20 = str[offset + 20];
                c21 = str[offset + 21];
                c22 = str[offset + 22];
                c23 = str[offset + 23];
                c24 = str[offset + 24];
                c25 = str[offset + 25];
                c26 = str[offset + 26];
                c27 = str[offset + 27];
                break;
            }
            default: {
                c20 = str[offset + 20];
                c21 = str[offset + 21];
                c22 = str[offset + 22];
                c23 = str[offset + 23];
                c24 = str[offset + 24];
                c25 = str[offset + 25];
                c26 = str[offset + 26];
                c27 = str[offset + 27];
                c28 = str[offset + 28];
            }
        }
        if (c4 != '-' || c7 != '-' || c10 != ' ' && c10 != 'T' || c13 != ':' || c16 != ':' || c19 != '.') {
            if (str[offset + len - 15] == '-' && str[offset + len - 12] == '-' && (str[offset + len - 9] == ' ' || str[offset + len - 9] == 'T') && str[offset + len - 6] == ':' && str[offset + len - 3] == ':') {
                int year = TypeUtils.parseInt(str, offset, len - 15);
                int month = TypeUtils.parseInt(str, offset + len - 14, 2);
                int dayOfMonth = TypeUtils.parseInt(str, offset + len - 11, 2);
                int hour = TypeUtils.parseInt(str, offset + len - 8, 2);
                int minute = TypeUtils.parseInt(str, offset + len - 5, 2);
                int second = TypeUtils.parseInt(str, offset + len - 2, 2);
                return LocalDateTime.of(year, month, dayOfMonth, hour, minute, second);
            }
            return null;
        }
        char y0 = c0;
        char y1 = c1;
        char y2 = c2;
        char y3 = c3;
        char m0 = c5;
        char m1 = c6;
        char d0 = c8;
        char d1 = c9;
        char h0 = c11;
        char h1 = c12;
        char i0 = c14;
        char i1 = c15;
        char s0 = c17;
        char s1 = c18;
        char S0 = c20;
        char S1 = c21;
        char S2 = c22;
        char S3 = c23;
        char S4 = c24;
        char S5 = c25;
        char S6 = c26;
        char S7 = c27;
        char S8 = c28;
        return DateUtils.localDateTime(y0, y1, y2, y3, m0, m1, d0, d1, h0, h1, i0, i1, s0, s1, S0, S1, S2, S3, S4, S5, S6, S7, S8);
    }

    public static LocalDateTime parseLocalDateTimeX(byte[] str, int offset, int len) {
        char c20;
        if (str == null || len == 0) {
            return null;
        }
        if (len < 21 || len > 29) {
            return null;
        }
        char c0 = (char)str[offset];
        char c1 = (char)str[offset + 1];
        char c2 = (char)str[offset + 2];
        char c3 = (char)str[offset + 3];
        char c4 = (char)str[offset + 4];
        char c5 = (char)str[offset + 5];
        char c6 = (char)str[offset + 6];
        char c7 = (char)str[offset + 7];
        char c8 = (char)str[offset + 8];
        char c9 = (char)str[offset + 9];
        char c10 = (char)str[offset + 10];
        char c11 = (char)str[offset + 11];
        char c12 = (char)str[offset + 12];
        char c13 = (char)str[offset + 13];
        char c14 = (char)str[offset + 14];
        char c15 = (char)str[offset + 15];
        char c16 = (char)str[offset + 16];
        char c17 = (char)str[offset + 17];
        char c18 = (char)str[offset + 18];
        char c19 = (char)str[offset + 19];
        char c21 = '0';
        char c22 = '0';
        char c23 = '0';
        char c24 = '0';
        char c25 = '0';
        char c26 = '0';
        char c27 = '0';
        char c28 = '0';
        switch (len) {
            case 21: {
                c20 = (char)str[offset + 20];
                break;
            }
            case 22: {
                c20 = (char)str[offset + 20];
                c21 = (char)str[offset + 21];
                break;
            }
            case 23: {
                c20 = (char)str[offset + 20];
                c21 = (char)str[offset + 21];
                c22 = (char)str[offset + 22];
                break;
            }
            case 24: {
                c20 = (char)str[offset + 20];
                c21 = (char)str[offset + 21];
                c22 = (char)str[offset + 22];
                c23 = (char)str[offset + 23];
                break;
            }
            case 25: {
                c20 = (char)str[offset + 20];
                c21 = (char)str[offset + 21];
                c22 = (char)str[offset + 22];
                c23 = (char)str[offset + 23];
                c24 = (char)str[offset + 24];
                break;
            }
            case 26: {
                c20 = (char)str[offset + 20];
                c21 = (char)str[offset + 21];
                c22 = (char)str[offset + 22];
                c23 = (char)str[offset + 23];
                c24 = (char)str[offset + 24];
                c25 = (char)str[offset + 25];
                break;
            }
            case 27: {
                c20 = (char)str[offset + 20];
                c21 = (char)str[offset + 21];
                c22 = (char)str[offset + 22];
                c23 = (char)str[offset + 23];
                c24 = (char)str[offset + 24];
                c25 = (char)str[offset + 25];
                c26 = (char)str[offset + 26];
                break;
            }
            case 28: {
                c20 = (char)str[offset + 20];
                c21 = (char)str[offset + 21];
                c22 = (char)str[offset + 22];
                c23 = (char)str[offset + 23];
                c24 = (char)str[offset + 24];
                c25 = (char)str[offset + 25];
                c26 = (char)str[offset + 26];
                c27 = (char)str[offset + 27];
                break;
            }
            default: {
                c20 = (char)str[offset + 20];
                c21 = (char)str[offset + 21];
                c22 = (char)str[offset + 22];
                c23 = (char)str[offset + 23];
                c24 = (char)str[offset + 24];
                c25 = (char)str[offset + 25];
                c26 = (char)str[offset + 26];
                c27 = (char)str[offset + 27];
                c28 = (char)str[offset + 28];
            }
        }
        if (c4 != '-' || c7 != '-' || c10 != ' ' && c10 != 'T' || c13 != ':' || c16 != ':' || c19 != '.') {
            if (str[offset + len - 15] == 45 && str[offset + len - 12] == 45 && (str[offset + len - 9] == 32 || str[offset + len - 9] == 84) && str[offset + len - 6] == 58 && str[offset + len - 3] == 58) {
                int year = TypeUtils.parseInt(str, offset, len - 15);
                int month = TypeUtils.parseInt(str, offset + len - 14, 2);
                int dayOfMonth = TypeUtils.parseInt(str, offset + len - 11, 2);
                int hour = TypeUtils.parseInt(str, offset + len - 8, 2);
                int minute = TypeUtils.parseInt(str, offset + len - 5, 2);
                int second = TypeUtils.parseInt(str, offset + len - 2, 2);
                return LocalDateTime.of(year, month, dayOfMonth, hour, minute, second);
            }
            return null;
        }
        char y0 = c0;
        char y1 = c1;
        char y2 = c2;
        char y3 = c3;
        char m0 = c5;
        char m1 = c6;
        char d0 = c8;
        char d1 = c9;
        char h0 = c11;
        char h1 = c12;
        char i0 = c14;
        char i1 = c15;
        char s0 = c17;
        char s1 = c18;
        char S0 = c20;
        char S1 = c21;
        char S2 = c22;
        char S3 = c23;
        char S4 = c24;
        char S5 = c25;
        char S6 = c26;
        char S7 = c27;
        char S8 = c28;
        return DateUtils.localDateTime(y0, y1, y2, y3, m0, m1, d0, d1, h0, h1, i0, i1, s0, s1, S0, S1, S2, S3, S4, S5, S6, S7, S8);
    }

    static ZonedDateTime parseZonedDateTime16(char[] str, int off, ZoneId defaultZonedId) {
        if (off + 16 > str.length) {
            String input = new String(str, off, str.length - off);
            throw new DateTimeParseException("illegal input " + input, input, 0);
        }
        char c0 = str[off];
        char c1 = str[off + 1];
        char c2 = str[off + 2];
        char c3 = str[off + 3];
        char c4 = str[off + 4];
        char c5 = str[off + 5];
        char c6 = str[off + 6];
        char c7 = str[off + 7];
        char c8 = str[off + 8];
        char c9 = str[off + 9];
        char c10 = str[off + 10];
        char c13 = str[off + 13];
        if (c4 != '-' || c7 != '-' || c10 != '+' && c10 != '-' || c13 != ':') {
            String input = new String(str, off, 16);
            throw new DateTimeParseException("illegal input " + input, input, 0);
        }
        char y0 = c0;
        char y1 = c1;
        char y2 = c2;
        char y3 = c3;
        char m0 = c5;
        char m1 = c6;
        char d0 = c8;
        char d1 = c9;
        if (y0 < '0' || y0 > '9' || y1 < '0' || y1 > '9' || y2 < '0' || y2 > '9' || y3 < '0' || y3 > '9') {
            String input = new String(str, off, 16);
            throw new DateTimeParseException("illegal input " + input, input, 0);
        }
        int year = (y0 - 48) * 1000 + (y1 - 48) * 100 + (y2 - 48) * 10 + (y3 - 48);
        if (m0 < '0' || m0 > '9' || m1 < '0' || m1 > '9') {
            String input = new String(str, off, 16);
            throw new DateTimeParseException("illegal input " + input, input, 0);
        }
        int month = (m0 - 48) * 10 + (m1 - 48);
        if (d0 < '0' || d0 > '9' || d1 < '0' || d1 > '9') {
            String input = new String(str, off, 16);
            throw new DateTimeParseException("illegal input " + input, input, 0);
        }
        int dom = (d0 - 48) * 10 + (d1 - 48);
        String zoneIdStr = new String(str, off + 10, 6);
        ZoneId zoneId = DateUtils.getZoneId(zoneIdStr, defaultZonedId);
        LocalDateTime ldt = LocalDateTime.of(LocalDate.of(year, month, dom), LocalTime.MIN);
        return ZonedDateTime.of(ldt, zoneId);
    }

    static ZonedDateTime parseZonedDateTime16(byte[] str, int off, ZoneId defaultZonedId) {
        if (off + 16 > str.length) {
            String input = new String(str, off, str.length - off);
            throw new DateTimeParseException("illegal input " + input, input, 0);
        }
        char c0 = (char)str[off];
        char c1 = (char)str[off + 1];
        char c2 = (char)str[off + 2];
        char c3 = (char)str[off + 3];
        char c4 = (char)str[off + 4];
        char c5 = (char)str[off + 5];
        char c6 = (char)str[off + 6];
        char c7 = (char)str[off + 7];
        char c8 = (char)str[off + 8];
        char c9 = (char)str[off + 9];
        char c10 = (char)str[off + 10];
        char c13 = (char)str[off + 13];
        if (c4 != '-' || c7 != '-' || c10 != '+' && c10 != '-' || c13 != ':') {
            String input = new String(str, off, 16);
            throw new DateTimeParseException("illegal input " + input, input, 0);
        }
        char y0 = c0;
        char y1 = c1;
        char y2 = c2;
        char y3 = c3;
        char m0 = c5;
        char m1 = c6;
        char d0 = c8;
        char d1 = c9;
        if (y0 < '0' || y0 > '9' || y1 < '0' || y1 > '9' || y2 < '0' || y2 > '9' || y3 < '0' || y3 > '9') {
            String input = new String(str, off, 16);
            throw new DateTimeParseException("illegal input " + input, input, 0);
        }
        int year = (y0 - 48) * 1000 + (y1 - 48) * 100 + (y2 - 48) * 10 + (y3 - 48);
        if (m0 < '0' || m0 > '9' || m1 < '0' || m1 > '9') {
            String input = new String(str, off, 16);
            throw new DateTimeParseException("illegal input " + input, input, 0);
        }
        int month = (m0 - 48) * 10 + (m1 - 48);
        if (d0 < '0' || d0 > '9' || d1 < '0' || d1 > '9') {
            String input = new String(str, off, 16);
            throw new DateTimeParseException("illegal input " + input, input, 0);
        }
        int dom = (d0 - 48) * 10 + (d1 - 48);
        String zoneIdStr = new String(str, off + 10, 6);
        ZoneId zoneId = DateUtils.getZoneId(zoneIdStr, defaultZonedId);
        LocalDateTime ldt = LocalDateTime.of(LocalDate.of(year, month, dom), LocalTime.MIN);
        return ZonedDateTime.of(ldt, zoneId);
    }

    public static ZonedDateTime parseZonedDateTime(String str) {
        return DateUtils.parseZonedDateTime(str, DEFAULT_ZONE_ID);
    }

    public static ZonedDateTime parseZonedDateTime(String str, ZoneId defaultZoneId) {
        ZonedDateTime zdt;
        if (str == null) {
            return null;
        }
        int len = str.length();
        if (len == 0) {
            return null;
        }
        if (JDKUtils.STRING_CODER != null && JDKUtils.STRING_VALUE != null && JDKUtils.STRING_CODER.applyAsInt(str) == 0) {
            byte[] bytes = JDKUtils.STRING_VALUE.apply(str);
            zdt = DateUtils.parseZonedDateTime(bytes, 0, bytes.length, defaultZoneId);
        } else {
            char[] chars = JDKUtils.getCharArray(str);
            zdt = DateUtils.parseZonedDateTime(chars, 0, chars.length, defaultZoneId);
        }
        if (zdt == null) {
            switch (str) {
                case "null": 
                case "0": 
                case "0000-00-00": {
                    return null;
                }
            }
            throw new DateTimeParseException(str, str, 0);
        }
        return zdt;
    }

    public static ZonedDateTime parseZonedDateTime(byte[] str, int off, int len) {
        return DateUtils.parseZonedDateTime(str, off, len, DEFAULT_ZONE_ID);
    }

    public static ZonedDateTime parseZonedDateTime(char[] str, int off, int len) {
        return DateUtils.parseZonedDateTime(str, off, len, DEFAULT_ZONE_ID);
    }

    public static ZonedDateTime parseZonedDateTime(byte[] str, int off, int len, ZoneId defaultZoneId) {
        ZoneId zoneId;
        LocalDateTime ldt;
        int month;
        int zoneIdBegin;
        int S8;
        int S7;
        int S6;
        int S5;
        int S4;
        int S3;
        int S2;
        int S1;
        int S0;
        int s1;
        int s0;
        int i1;
        int i0;
        int h1;
        int h0;
        int d1;
        int d0;
        int m1;
        int m0;
        int y3;
        int y2;
        int y1;
        int y0;
        int c20;
        if (str == null) {
            return null;
        }
        if (len == 0) {
            return null;
        }
        if (len == 16) {
            return DateUtils.parseZonedDateTime16(str, off, defaultZoneId);
        }
        if (len < 19) {
            return null;
        }
        String zoneIdStr = null;
        int c0 = str[off];
        int c1 = str[off + 1];
        int c2 = str[off + 2];
        int c3 = str[off + 3];
        int c4 = str[off + 4];
        int c5 = str[off + 5];
        int c6 = str[off + 6];
        char c = str[off + 7];
        int c8 = str[off + 8];
        int c9 = str[off + 9];
        int c10 = str[off + 10];
        int c11 = str[off + 11];
        int c12 = str[off + 12];
        int c13 = str[off + 13];
        int c14 = str[off + 14];
        int c15 = str[off + 15];
        int c16 = str[off + 16];
        int c17 = str[off + 17];
        int c18 = str[off + 18];
        int c19 = (char)(len == 19 ? 32 : (char)str[off + 19]);
        int c21 = 48;
        int c22 = 48;
        int c23 = 48;
        int c24 = 48;
        int c25 = 48;
        int c26 = 48;
        int c27 = 48;
        int c28 = 48;
        char c29 = '\u0000';
        switch (len) {
            case 19: 
            case 20: {
                c20 = 0;
                break;
            }
            case 21: {
                c20 = str[off + 20];
                break;
            }
            case 22: {
                c20 = (char)str[off + 20];
                c21 = (char)str[off + 21];
                break;
            }
            case 23: {
                c20 = (char)str[off + 20];
                c21 = (char)str[off + 21];
                c22 = (char)str[off + 22];
                break;
            }
            case 24: {
                c20 = (char)str[off + 20];
                c21 = (char)str[off + 21];
                c22 = (char)str[off + 22];
                c23 = (char)str[off + 23];
                break;
            }
            case 25: {
                c20 = (char)str[off + 20];
                c21 = (char)str[off + 21];
                c22 = (char)str[off + 22];
                c23 = (char)str[off + 23];
                c24 = (char)str[off + 24];
                break;
            }
            case 26: {
                c20 = (char)str[off + 20];
                c21 = (char)str[off + 21];
                c22 = (char)str[off + 22];
                c23 = (char)str[off + 23];
                c24 = (char)str[off + 24];
                c25 = (char)str[off + 25];
                break;
            }
            case 27: {
                c20 = (char)str[off + 20];
                c21 = (char)str[off + 21];
                c22 = (char)str[off + 22];
                c23 = (char)str[off + 23];
                c24 = (char)str[off + 24];
                c25 = (char)str[off + 25];
                c26 = (char)str[off + 26];
                break;
            }
            case 28: {
                c20 = (char)str[off + 20];
                c21 = (char)str[off + 21];
                c22 = (char)str[off + 22];
                c23 = (char)str[off + 23];
                c24 = (char)str[off + 24];
                c25 = (char)str[off + 25];
                c26 = (char)str[off + 26];
                c27 = (char)str[off + 27];
                break;
            }
            case 29: {
                c20 = (char)str[off + 20];
                c21 = (char)str[off + 21];
                c22 = (char)str[off + 22];
                c23 = (char)str[off + 23];
                c24 = (char)str[off + 24];
                c25 = (char)str[off + 25];
                c26 = (char)str[off + 26];
                c27 = (char)str[off + 27];
                c28 = (char)str[off + 28];
                break;
            }
            default: {
                c20 = (char)str[off + 20];
                c21 = (char)str[off + 21];
                c22 = (char)str[off + 22];
                c23 = (char)str[off + 23];
                c24 = (char)str[off + 24];
                c25 = (char)str[off + 25];
                c26 = (char)str[off + 26];
                c27 = (char)str[off + 27];
                c28 = (char)str[off + 28];
                c29 = (char)str[off + 29];
            }
        }
        boolean isTimeZone = false;
        boolean pm = false;
        if (!(c4 != 45 || c != '-' || c10 != 32 && c10 != 84 || c13 != 58 || c16 != 58 || c19 != 91 && c19 != 90 && c19 != 43 && c19 != 45 && c19 != 32)) {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = c5;
            m1 = c6;
            d0 = c8;
            d1 = c9;
            h0 = c11;
            h1 = c12;
            i0 = c14;
            i1 = c15;
            s0 = c17;
            s1 = c18;
            S0 = 48;
            S1 = 48;
            S2 = 48;
            S3 = 48;
            S4 = 48;
            S5 = 48;
            S6 = 48;
            S7 = 48;
            S8 = 48;
            zoneIdBegin = 19;
        } else if (c4 == 45 && c == '-' && c10 == 32 && c11 == 32 && c14 == 58 && c17 == 58 && len == 20) {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = c5;
            m1 = c6;
            d0 = c8;
            d1 = c9;
            h0 = c12;
            h1 = c13;
            i0 = c15;
            i1 = c16;
            s0 = c18;
            s1 = c19;
            S0 = 48;
            S1 = 48;
            S2 = 48;
            S3 = 48;
            S4 = 48;
            S5 = 48;
            S6 = 48;
            S7 = 48;
            S8 = 48;
            zoneIdBegin = 20;
        } else if (len == 20 && c2 == 32 && c6 == 32 && c11 == 32 && c14 == 58 && c17 == 58) {
            y0 = c;
            y1 = c8;
            y2 = c9;
            y3 = c10;
            month = DateUtils.month((char)c3, (char)c4, (char)c5);
            if (month > 0) {
                m0 = (char)(48 + month / 10);
                m1 = (char)(48 + month % 10);
            } else {
                m0 = 48;
                m1 = 48;
            }
            d0 = c0;
            d1 = c1;
            h0 = c12;
            h1 = c13;
            i0 = c15;
            i1 = c16;
            s0 = c18;
            s1 = c19;
            S0 = 48;
            S1 = 48;
            S2 = 48;
            S3 = 48;
            S4 = 48;
            S5 = 48;
            S6 = 48;
            S7 = 48;
            S8 = 48;
            zoneIdBegin = 20;
        } else if (!(c4 != 45 || c != '-' || c10 != 32 && c10 != 84 || c13 != 58 || c16 != 58 || c19 != 46 || len != 21 && c21 != 91 && c21 != 43 && c21 != 45 && c21 != 90)) {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = c5;
            m1 = c6;
            d0 = c8;
            d1 = c9;
            h0 = c11;
            h1 = c12;
            i0 = c14;
            i1 = c15;
            s0 = c17;
            s1 = c18;
            S0 = c20;
            S1 = 48;
            S2 = 48;
            S3 = 48;
            S4 = 48;
            S5 = 48;
            S6 = 48;
            S7 = 48;
            S8 = 48;
            zoneIdBegin = 21;
            isTimeZone = c21 == 124;
        } else if (!(c4 != 45 || c != '-' || c10 != 32 && c10 != 84 || c13 != 58 || c16 != 58 || c19 != 46 || len != 22 && c22 != 91 && c22 != 43 && c22 != 45 && c22 != 90)) {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = c5;
            m1 = c6;
            d0 = c8;
            d1 = c9;
            h0 = c11;
            h1 = c12;
            i0 = c14;
            i1 = c15;
            s0 = c17;
            s1 = c18;
            S0 = c20;
            S1 = c21;
            S2 = 48;
            S3 = 48;
            S4 = 48;
            S5 = 48;
            S6 = 48;
            S7 = 48;
            S8 = 48;
            zoneIdBegin = 22;
            isTimeZone = c22 == 124;
        } else if (c4 == 45 && c == '-' && (c10 == 32 || c10 == 84) && c13 == 58 && c16 == 90 && c17 == 91 && c21 == 93 && len == 22) {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = c5;
            m1 = c6;
            d0 = c8;
            d1 = c9;
            h0 = c11;
            h1 = c12;
            i0 = c14;
            i1 = c15;
            s0 = 48;
            s1 = 48;
            S0 = 48;
            S1 = 48;
            S2 = 48;
            S3 = 48;
            S4 = 48;
            S5 = 48;
            S6 = 48;
            S7 = 48;
            S8 = 48;
            isTimeZone = true;
            zoneIdBegin = 17;
        } else if (len == 22 && c3 == 32 && c5 == 44 && c6 == 32 && c11 == 32 && c13 == 58 && c16 == 58 && c19 == 32 && (c20 == 65 || c20 == 80) && c21 == 77) {
            y0 = c;
            y1 = c8;
            y2 = c9;
            y3 = c10;
            month = DateUtils.month((char)c0, (char)c1, (char)c2);
            if (month > 0) {
                m0 = (char)(48 + month / 10);
                m1 = (char)(48 + month % 10);
            } else {
                m0 = 48;
                m1 = 48;
            }
            d0 = 48;
            d1 = c4;
            h0 = 48;
            h1 = c12;
            pm = c20 == 80;
            i0 = c14;
            i1 = c15;
            s0 = c17;
            s1 = c18;
            S0 = 48;
            S1 = 48;
            S2 = 48;
            S3 = 48;
            S4 = 48;
            S5 = 48;
            S6 = 48;
            S7 = 48;
            S8 = 48;
            zoneIdBegin = 22;
        } else if (len == 22 && c2 == 47 && c5 == 47 && c10 == 32 && c13 == 58 && c16 == 58 && c19 == 32 && (c20 == 65 || c20 == 80) && c21 == 77) {
            m0 = c0;
            m1 = c1;
            d0 = c3;
            d1 = c4;
            y0 = c6;
            y1 = c;
            y2 = c8;
            y3 = c9;
            h0 = c11;
            h1 = c12;
            pm = c20 == 80;
            i0 = c14;
            i1 = c15;
            s0 = c17;
            s1 = c18;
            S0 = 48;
            S1 = 48;
            S2 = 48;
            S3 = 48;
            S4 = 48;
            S5 = 48;
            S6 = 48;
            S7 = 48;
            S8 = 48;
            zoneIdBegin = 22;
        } else if (len == 23 && c3 == 32 && c5 == 44 && c6 == 32 && c11 == 32 && c14 == 58 && c17 == 58 && c20 == 32 && (c21 == 65 || c21 == 80) && c22 == 77) {
            y0 = c;
            y1 = c8;
            y2 = c9;
            y3 = c10;
            month = DateUtils.month((char)c0, (char)c1, (char)c2);
            if (month > 0) {
                m0 = (char)(48 + month / 10);
                m1 = (char)(48 + month % 10);
            } else {
                m0 = 48;
                m1 = 48;
            }
            d0 = 48;
            d1 = c4;
            h0 = c12;
            h1 = c13;
            pm = c21 == 80;
            i0 = c15;
            i1 = c16;
            s0 = c18;
            s1 = c19;
            S0 = 48;
            S1 = 48;
            S2 = 48;
            S3 = 48;
            S4 = 48;
            S5 = 48;
            S6 = 48;
            S7 = 48;
            S8 = 48;
            zoneIdBegin = 23;
        } else if (len == 23 && c3 == 32 && c6 == 44 && c == ' ' && c12 == 32 && c14 == 58 && c17 == 58 && c20 == 32 && (c21 == 65 || c21 == 80) && c22 == 77) {
            y0 = c8;
            y1 = c9;
            y2 = c10;
            y3 = c11;
            month = DateUtils.month((char)c0, (char)c1, (char)c2);
            if (month > 0) {
                m0 = (char)(48 + month / 10);
                m1 = (char)(48 + month % 10);
            } else {
                m0 = 48;
                m1 = 48;
            }
            d0 = c4;
            d1 = c5;
            h0 = 48;
            h1 = c13;
            pm = c21 == 80;
            i0 = c15;
            i1 = c16;
            s0 = c18;
            s1 = c19;
            S0 = 48;
            S1 = 48;
            S2 = 48;
            S3 = 48;
            S4 = 48;
            S5 = 48;
            S6 = 48;
            S7 = 48;
            S8 = 48;
            zoneIdBegin = 23;
        } else if (len == 23 && c3 == 32 && c5 == 44 && c6 == 32 && c11 == 44 && c12 == 32 && c14 == 58 && c17 == 58 && c20 == 32 && (c21 == 65 || c21 == 80) && c22 == 77) {
            y0 = c;
            y1 = c8;
            y2 = c9;
            y3 = c10;
            month = DateUtils.month((char)c0, (char)c1, (char)c2);
            if (month > 0) {
                m0 = (char)(48 + month / 10);
                m1 = (char)(48 + month % 10);
            } else {
                m0 = 48;
                m1 = 48;
            }
            d0 = 48;
            d1 = c4;
            h0 = 48;
            h1 = c13;
            pm = c21 == 80;
            i0 = c15;
            i1 = c16;
            s0 = c18;
            s1 = c19;
            S0 = 48;
            S1 = 48;
            S2 = 48;
            S3 = 48;
            S4 = 48;
            S5 = 48;
            S6 = 48;
            S7 = 48;
            S8 = 48;
            zoneIdBegin = 23;
        } else if (len == 24 && c3 == 32 && c6 == 44 && c == ' ' && c12 == 32 && c15 == 58 && c18 == 58 && c21 == 32 && (c22 == 65 || c22 == 80) && c23 == 77) {
            y0 = c8;
            y1 = c9;
            y2 = c10;
            y3 = c11;
            month = DateUtils.month((char)c0, (char)c1, (char)c2);
            if (month > 0) {
                m0 = (char)(48 + month / 10);
                m1 = (char)(48 + month % 10);
            } else {
                m0 = 48;
                m1 = 48;
            }
            d0 = c4;
            d1 = c5;
            h0 = c13;
            h1 = c14;
            pm = c22 == 80;
            i0 = c16;
            i1 = c17;
            s0 = c19;
            s1 = c20;
            S0 = 48;
            S1 = 48;
            S2 = 48;
            S3 = 48;
            S4 = 48;
            S5 = 48;
            S6 = 48;
            S7 = 48;
            S8 = 48;
            zoneIdBegin = 24;
        } else if (len == 24 && c3 == 32 && c6 == 44 && c == ' ' && c12 == 44 && c13 == 32 && c15 == 58 && c18 == 58 && c21 == 32 && (c22 == 65 || c22 == 80) && c23 == 77) {
            y0 = c8;
            y1 = c9;
            y2 = c10;
            y3 = c11;
            month = DateUtils.month((char)c0, (char)c1, (char)c2);
            if (month > 0) {
                m0 = (char)(48 + month / 10);
                m1 = (char)(48 + month % 10);
            } else {
                m0 = 48;
                m1 = 48;
            }
            d0 = c4;
            d1 = c5;
            h0 = 48;
            h1 = c14;
            pm = c22 == 80;
            i0 = c16;
            i1 = c17;
            s0 = c19;
            s1 = c20;
            S0 = 48;
            S1 = 48;
            S2 = 48;
            S3 = 48;
            S4 = 48;
            S5 = 48;
            S6 = 48;
            S7 = 48;
            S8 = 48;
            zoneIdBegin = 24;
        } else if (len == 24 && c3 == 32 && c5 == 44 && c6 == 32 && c11 == 44 && c12 == 32 && c15 == 58 && c18 == 58 && c21 == 32 && (c22 == 65 || c22 == 80) && c23 == 77) {
            y0 = c;
            y1 = c8;
            y2 = c9;
            y3 = c10;
            month = DateUtils.month((char)c0, (char)c1, (char)c2);
            if (month > 0) {
                m0 = (char)(48 + month / 10);
                m1 = (char)(48 + month % 10);
            } else {
                m0 = 48;
                m1 = 48;
            }
            d0 = 48;
            d1 = c4;
            h0 = c13;
            h1 = c14;
            pm = c22 == 80;
            i0 = c16;
            i1 = c17;
            s0 = c19;
            s1 = c20;
            S0 = 48;
            S1 = 48;
            S2 = 48;
            S3 = 48;
            S4 = 48;
            S5 = 48;
            S6 = 48;
            S7 = 48;
            S8 = 48;
            zoneIdBegin = 24;
        } else if (!(c4 != 45 || c != '-' || c10 != 32 && c10 != 84 || c13 != 58 || c16 != 58 || c19 != 46 || len != 23 && c23 != 91 && c23 != 124 && c23 != 43 && c23 != 45 && c23 != 90)) {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = c5;
            m1 = c6;
            d0 = c8;
            d1 = c9;
            h0 = c11;
            h1 = c12;
            i0 = c14;
            i1 = c15;
            s0 = c17;
            s1 = c18;
            S0 = c20;
            S1 = c21;
            S2 = c22;
            S3 = 48;
            S4 = 48;
            S5 = 48;
            S6 = 48;
            S7 = 48;
            S8 = 48;
            zoneIdBegin = 23;
            isTimeZone = c23 == 124;
        } else if (!(c4 != 45 || c != '-' || c10 != 32 && c10 != 84 || c13 != 58 || c16 != 58 || c19 != 46 || len != 24 && c24 != 91 && c24 != 124 && c24 != 43 && c24 != 45 && c24 != 90)) {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = c5;
            m1 = c6;
            d0 = c8;
            d1 = c9;
            h0 = c11;
            h1 = c12;
            i0 = c14;
            i1 = c15;
            s0 = c17;
            s1 = c18;
            S0 = c20;
            S1 = c21;
            S2 = c22;
            S3 = c23;
            S4 = 48;
            S5 = 48;
            S6 = 48;
            S7 = 48;
            S8 = 48;
            zoneIdBegin = 24;
            isTimeZone = c24 == 124;
        } else if (!(c4 != 45 || c != '-' || c10 != 32 && c10 != 84 || c13 != 58 || c16 != 58 || c19 != 46 || len != 25 && c25 != 91 && c25 != 124 && c25 != 43 && c25 != 45 && c25 != 90)) {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = c5;
            m1 = c6;
            d0 = c8;
            d1 = c9;
            h0 = c11;
            h1 = c12;
            i0 = c14;
            i1 = c15;
            s0 = c17;
            s1 = c18;
            S0 = c20;
            S1 = c21;
            S2 = c22;
            S3 = c23;
            S4 = c24;
            S5 = 48;
            S6 = 48;
            S7 = 48;
            S8 = 48;
            zoneIdBegin = 25;
            isTimeZone = c25 == 124;
        } else if (len == 25 && c3 == 32 && c6 == 44 && c == ' ' && c12 == 44 && c13 == 32 && c16 == 58 && c19 == 58 && c22 == 32 && (c23 == 65 || c23 == 80) && c24 == 77) {
            y0 = c8;
            y1 = c9;
            y2 = c10;
            y3 = c11;
            month = DateUtils.month((char)c0, (char)c1, (char)c2);
            if (month > 0) {
                m0 = (char)(48 + month / 10);
                m1 = (char)(48 + month % 10);
            } else {
                m0 = 48;
                m1 = 48;
            }
            d0 = c4;
            d1 = c5;
            h0 = c14;
            h1 = c15;
            pm = c23 == 80;
            i0 = c17;
            i1 = c18;
            s0 = c20;
            s1 = c21;
            S0 = 48;
            S1 = 48;
            S2 = 48;
            S3 = 48;
            S4 = 48;
            S5 = 48;
            S6 = 48;
            S7 = 48;
            S8 = 48;
            zoneIdBegin = 25;
        } else if (!(c4 != 45 || c != '-' || c10 != 32 && c10 != 84 || c13 != 58 || c16 != 58 || c19 != 46 || len != 26 && c26 != 91 && c26 != 124 && c26 != 43 && c26 != 45 && c26 != 90)) {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = c5;
            m1 = c6;
            d0 = c8;
            d1 = c9;
            h0 = c11;
            h1 = c12;
            i0 = c14;
            i1 = c15;
            s0 = c17;
            s1 = c18;
            S0 = c20;
            S1 = c21;
            S2 = c22;
            S3 = c23;
            S4 = c24;
            S5 = c25;
            S6 = 48;
            S7 = 48;
            S8 = 48;
            zoneIdBegin = 26;
            isTimeZone = c26 == 124;
        } else if (!(c4 != 45 || c != '-' || c10 != 32 && c10 != 84 || c13 != 58 || c16 != 58 || c19 != 46 || len != 27 && c27 != 91 && c27 != 124 && c27 != 43 && c27 != 45 && c27 != 90)) {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = c5;
            m1 = c6;
            d0 = c8;
            d1 = c9;
            h0 = c11;
            h1 = c12;
            i0 = c14;
            i1 = c15;
            s0 = c17;
            s1 = c18;
            S0 = c20;
            S1 = c21;
            S2 = c22;
            if (c23 == 32) {
                S3 = 48;
                S4 = 48;
                S5 = 48;
                S6 = 48;
                S7 = 48;
                S8 = 48;
                zoneIdBegin = 23;
            } else {
                S3 = c23;
                S4 = c24;
                S5 = c25;
                S6 = c26;
                S7 = 48;
                S8 = 48;
                zoneIdBegin = 27;
                isTimeZone = c27 == 124;
            }
        } else if (!(c4 != 45 || c != '-' || c10 != 32 && c10 != 84 || c13 != 58 || c16 != 58 || c19 != 46 || len != 28 && c28 != 91 && c28 != 124 && c28 != 43 && c28 != 45 && c28 != 90)) {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = c5;
            m1 = c6;
            d0 = c8;
            d1 = c9;
            h0 = c11;
            h1 = c12;
            i0 = c14;
            i1 = c15;
            s0 = c17;
            s1 = c18;
            S0 = c20;
            S1 = c21;
            S2 = c22;
            S3 = c23;
            S4 = c24;
            S5 = c25;
            S6 = c26;
            S7 = c27;
            S8 = 48;
            zoneIdBegin = 28;
            isTimeZone = c28 == 124;
        } else if (len == 28 && c3 == 32 && c == ' ' && c10 == 32 && c13 == 58 && c16 == 58 && c19 == 32 && c23 == 32) {
            month = DateUtils.month((char)c4, (char)c5, (char)c6);
            if (month > 0) {
                m0 = (char)(48 + month / 10);
                m1 = (char)(48 + month % 10);
            } else {
                m0 = 48;
                m1 = 48;
            }
            d0 = c8;
            d1 = c9;
            h0 = c11;
            h1 = c12;
            i0 = c14;
            i1 = c15;
            s0 = c17;
            s1 = c18;
            y0 = c24;
            y1 = c25;
            y2 = c26;
            y3 = c27;
            S0 = 48;
            S1 = 48;
            S2 = 48;
            S3 = 48;
            S4 = 48;
            S5 = 48;
            S6 = 48;
            S7 = 48;
            S8 = 48;
            zoneIdBegin = 19;
            zoneIdStr = new String(str, off + 20, 3);
        } else if (len == 28 && c3 == 44 && c4 == 32 && c6 == 32 && c10 == 32 && c15 == 32 && c18 == 58 && c21 == 58 && c24 == 32) {
            y0 = c11;
            y1 = c12;
            y2 = c13;
            y3 = c14;
            month = DateUtils.month(c, (char)c8, (char)c9);
            if (month > 0) {
                m0 = (char)(48 + month / 10);
                m1 = (char)(48 + month % 10);
            } else {
                m0 = 48;
                m1 = 48;
            }
            d0 = 48;
            d1 = c5;
            h0 = c16;
            h1 = c17;
            i0 = c19;
            i1 = c20;
            s0 = c22;
            s1 = c23;
            S0 = 48;
            S1 = 48;
            S2 = 48;
            S3 = 48;
            S4 = 48;
            S5 = 48;
            S6 = 48;
            S7 = 48;
            S8 = 48;
            zoneIdBegin = 24;
            isTimeZone = true;
        } else if (len == 29 && c3 == 44 && c4 == 32 && c == ' ' && c11 == 32 && c16 == 32 && c19 == 58 && c22 == 58 && c25 == 32) {
            y0 = c12;
            y1 = c13;
            y2 = c14;
            y3 = c15;
            month = DateUtils.month((char)c8, (char)c9, (char)c10);
            if (month > 0) {
                m0 = (char)(48 + month / 10);
                m1 = (char)(48 + month % 10);
            } else {
                m0 = 48;
                m1 = 48;
            }
            d0 = c5;
            d1 = c6;
            h0 = c17;
            h1 = c18;
            i0 = c20;
            i1 = c21;
            s0 = c23;
            s1 = c24;
            S0 = 48;
            S1 = 48;
            S2 = 48;
            S3 = 48;
            S4 = 48;
            S5 = 48;
            S6 = 48;
            S7 = 48;
            S8 = 48;
            zoneIdBegin = 25;
            isTimeZone = true;
        } else if (!(c4 != 45 || c != '-' || c10 != 32 && c10 != 84 || c13 != 58 || c16 != 58 || c19 != 46 || len != 29 && c29 != '[' && c29 != '|' && c29 != '+' && c29 != '-' && c29 != 'Z')) {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = c5;
            m1 = c6;
            d0 = c8;
            d1 = c9;
            h0 = c11;
            h1 = c12;
            i0 = c14;
            i1 = c15;
            s0 = c17;
            s1 = c18;
            S0 = c20;
            S1 = c21;
            S2 = c22;
            S3 = c23;
            S4 = c24;
            S5 = c25;
            S6 = c26;
            S7 = c27;
            S8 = c28;
            zoneIdBegin = 29;
            isTimeZone = c29 == '|';
        } else if (len == 22 && (c17 == 43 || c17 == 45)) {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = c4;
            m1 = c5;
            d0 = c6;
            d1 = c;
            h0 = c8;
            h1 = c9;
            i0 = c10;
            i1 = c11;
            s0 = c12;
            s1 = c13;
            S0 = c14;
            S1 = c15;
            S2 = c16;
            S3 = 48;
            S4 = 48;
            S5 = 48;
            S6 = 48;
            S7 = 48;
            S8 = 48;
            zoneIdBegin = 17;
        } else {
            if (len == 32 && c6 == 44 && c == ' ' && c10 == 45 && c14 == 45 && c19 == 32 && c22 == 58 && c25 == 58 && str[off + 28] == 32 || len == 33 && c == ',' && c8 == 32 && c11 == 45 && c15 == 45 && c20 == 32 && c23 == 58 && c26 == 58 && str[off + 29] == 32 || len == 34 && c8 == 44 && c9 == 32 && c12 == 45 && c16 == 45 && c21 == 32 && c24 == 58 && c27 == 58 && str[off + 30] == 32 || len == 35 && c9 == 44 && c10 == 32 && c13 == 45 && c17 == 45 && c22 == 32 && c25 == 58 && c28 == 58 && str[off + 31] == 32) {
                return DateUtils.parseZonedDateTimeCookie(new String(str, off, len));
            }
            if (len == 34) {
                DateTimeFormatter formatter = DATE_TIME_FORMATTER_34;
                if (formatter == null) {
                    formatter = DATE_TIME_FORMATTER_34 = DateTimeFormatter.ofPattern("EEE MMM dd HH:mm:ss O yyyy", Locale.ENGLISH);
                }
                return ZonedDateTime.parse(new String(str, off, len), formatter);
            }
            if (len == 31 && str[off + 3] == 44) {
                DateTimeFormatter formatter = DATE_TIME_FORMATTER_RFC_2822;
                if (formatter == null) {
                    formatter = DATE_TIME_FORMATTER_RFC_2822 = DateTimeFormatter.ofPattern("EEE, dd MMM yyyy HH:mm:ss Z", Locale.ENGLISH);
                }
                return ZonedDateTime.parse(new String(str, off, len), formatter);
            }
            return null;
        }
        if (pm && h0 == 49 && h1 == 50) {
            pm = false;
        }
        if (pm) {
            int hourValue = DateUtils.hourAfterNoon((char)h0, (char)h1);
            h0 = (char)(hourValue >> 16);
            h1 = (char)hourValue;
        }
        if ((ldt = DateUtils.localDateTime((char)y0, (char)y1, (char)y2, (char)y3, (char)m0, (char)m1, (char)d0, (char)d1, (char)h0, (char)h1, (char)i0, (char)i1, (char)s0, (char)s1, (char)S0, (char)S1, (char)S2, (char)S3, (char)S4, (char)S5, (char)S6, (char)S7, (char)S8)) == null) {
            return null;
        }
        if (isTimeZone) {
            String tzStr;
            switch (tzStr = new String(str, zoneIdBegin, len - zoneIdBegin)) {
                case "UTC": 
                case "[UTC]": {
                    zoneId = ZoneOffset.UTC;
                    break;
                }
                default: {
                    TimeZone timeZone = TimeZone.getTimeZone(tzStr);
                    zoneId = timeZone.toZoneId();
                    break;
                }
            }
        } else if (zoneIdBegin == len) {
            zoneId = defaultZoneId;
        } else {
            char first = (char)str[off + zoneIdBegin];
            if (first == 'Z') {
                zoneId = ZoneOffset.UTC;
            } else {
                if (zoneIdStr == null) {
                    if (first == '+' || first == '-') {
                        zoneIdStr = new String(str, off + zoneIdBegin, len - zoneIdBegin);
                    } else if (first == ' ') {
                        zoneIdStr = new String(str, off + zoneIdBegin + 1, len - zoneIdBegin - 1);
                    } else if (zoneIdBegin < len) {
                        zoneIdStr = new String(str, off + zoneIdBegin + 1, len - zoneIdBegin - 2);
                    }
                }
                zoneId = DateUtils.getZoneId(zoneIdStr, defaultZoneId);
            }
        }
        if (zoneId == null) {
            zoneId = defaultZoneId;
        }
        if (zoneId == null) {
            zoneId = DEFAULT_ZONE_ID;
        }
        return ZonedDateTime.ofLocal(ldt, zoneId, null);
    }

    public static ZonedDateTime parseZonedDateTime(char[] str, int off, int len, ZoneId defaultZoneId) {
        ZoneId zoneId;
        LocalDateTime ldt;
        int month;
        int zoneIdBegin;
        int S8;
        int S7;
        int S6;
        int S5;
        int S4;
        int S3;
        int S2;
        int S1;
        int S0;
        int s1;
        int s0;
        int i1;
        int i0;
        int h1;
        int h0;
        int d1;
        int d0;
        int m1;
        int m0;
        int y3;
        int y2;
        int y1;
        int y0;
        int c20;
        if (str == null) {
            return null;
        }
        if (len == 0) {
            return null;
        }
        if (len == 16) {
            return DateUtils.parseZonedDateTime16(str, off, defaultZoneId);
        }
        if (len < 19) {
            String input = new String(str, off, str.length - off);
            throw new DateTimeParseException("illegal input " + input, input, 0);
        }
        String zoneIdStr = null;
        int c0 = str[off];
        int c1 = str[off + 1];
        int c2 = str[off + 2];
        int c3 = str[off + 3];
        int c4 = str[off + 4];
        int c5 = str[off + 5];
        int c6 = str[off + 6];
        int c7 = str[off + 7];
        int c8 = str[off + 8];
        int c9 = str[off + 9];
        int c10 = str[off + 10];
        int c11 = str[off + 11];
        int c12 = str[off + 12];
        int c13 = str[off + 13];
        int c14 = str[off + 14];
        int c15 = str[off + 15];
        int c16 = str[off + 16];
        int c17 = str[off + 17];
        int c18 = str[off + 18];
        int c19 = len == 19 ? 32 : str[off + 19];
        int c21 = 48;
        int c22 = 48;
        int c23 = 48;
        int c24 = 48;
        int c25 = 48;
        int c26 = 48;
        int c27 = 48;
        int c28 = 48;
        char c29 = '\u0000';
        switch (len) {
            case 19: 
            case 20: {
                c20 = 0;
                break;
            }
            case 21: {
                c20 = str[off + 20];
                break;
            }
            case 22: {
                c20 = str[off + 20];
                c21 = str[off + 21];
                break;
            }
            case 23: {
                c20 = str[off + 20];
                c21 = str[off + 21];
                c22 = str[off + 22];
                break;
            }
            case 24: {
                c20 = str[off + 20];
                c21 = str[off + 21];
                c22 = str[off + 22];
                c23 = str[off + 23];
                break;
            }
            case 25: {
                c20 = str[off + 20];
                c21 = str[off + 21];
                c22 = str[off + 22];
                c23 = str[off + 23];
                c24 = str[off + 24];
                break;
            }
            case 26: {
                c20 = str[off + 20];
                c21 = str[off + 21];
                c22 = str[off + 22];
                c23 = str[off + 23];
                c24 = str[off + 24];
                c25 = str[off + 25];
                break;
            }
            case 27: {
                c20 = str[off + 20];
                c21 = str[off + 21];
                c22 = str[off + 22];
                c23 = str[off + 23];
                c24 = str[off + 24];
                c25 = str[off + 25];
                c26 = str[off + 26];
                break;
            }
            case 28: {
                c20 = str[off + 20];
                c21 = str[off + 21];
                c22 = str[off + 22];
                c23 = str[off + 23];
                c24 = str[off + 24];
                c25 = str[off + 25];
                c26 = str[off + 26];
                c27 = str[off + 27];
                break;
            }
            case 29: {
                c20 = str[off + 20];
                c21 = str[off + 21];
                c22 = str[off + 22];
                c23 = str[off + 23];
                c24 = str[off + 24];
                c25 = str[off + 25];
                c26 = str[off + 26];
                c27 = str[off + 27];
                c28 = str[off + 28];
                break;
            }
            default: {
                c20 = str[off + 20];
                c21 = str[off + 21];
                c22 = str[off + 22];
                c23 = str[off + 23];
                c24 = str[off + 24];
                c25 = str[off + 25];
                c26 = str[off + 26];
                c27 = str[off + 27];
                c28 = str[off + 28];
                c29 = str[off + 29];
            }
        }
        boolean isTimeZone = false;
        boolean pm = false;
        if (!(c4 != 45 || c7 != 45 || c10 != 32 && c10 != 84 || c13 != 58 || c16 != 58 || c19 != 91 && c19 != 90 && c19 != 43 && c19 != 45 && c19 != 32)) {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = c5;
            m1 = c6;
            d0 = c8;
            d1 = c9;
            h0 = c11;
            h1 = c12;
            i0 = c14;
            i1 = c15;
            s0 = c17;
            s1 = c18;
            S0 = 48;
            S1 = 48;
            S2 = 48;
            S3 = 48;
            S4 = 48;
            S5 = 48;
            S6 = 48;
            S7 = 48;
            S8 = 48;
            zoneIdBegin = 19;
        } else if (c4 == 45 && c7 == 45 && c10 == 32 && c11 == 32 && c14 == 58 && c17 == 58 && len == 20) {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = c5;
            m1 = c6;
            d0 = c8;
            d1 = c9;
            h0 = c12;
            h1 = c13;
            i0 = c15;
            i1 = c16;
            s0 = c18;
            s1 = c19;
            S0 = 48;
            S1 = 48;
            S2 = 48;
            S3 = 48;
            S4 = 48;
            S5 = 48;
            S6 = 48;
            S7 = 48;
            S8 = 48;
            zoneIdBegin = 20;
        } else if (len == 20 && c2 == 32 && c6 == 32 && c11 == 32 && c14 == 58 && c17 == 58) {
            y0 = c7;
            y1 = c8;
            y2 = c9;
            y3 = c10;
            month = DateUtils.month((char)c3, (char)c4, (char)c5);
            if (month > 0) {
                m0 = (char)(48 + month / 10);
                m1 = (char)(48 + month % 10);
            } else {
                m0 = 48;
                m1 = 48;
            }
            d0 = c0;
            d1 = c1;
            h0 = c12;
            h1 = c13;
            i0 = c15;
            i1 = c16;
            s0 = c18;
            s1 = c19;
            S0 = 48;
            S1 = 48;
            S2 = 48;
            S3 = 48;
            S4 = 48;
            S5 = 48;
            S6 = 48;
            S7 = 48;
            S8 = 48;
            zoneIdBegin = 20;
        } else if (!(c4 != 45 || c7 != 45 || c10 != 32 && c10 != 84 || c13 != 58 || c16 != 58 || c19 != 46 || len != 21 && c21 != 91 && c21 != 43 && c21 != 45 && c21 != 90)) {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = c5;
            m1 = c6;
            d0 = c8;
            d1 = c9;
            h0 = c11;
            h1 = c12;
            i0 = c14;
            i1 = c15;
            s0 = c17;
            s1 = c18;
            S0 = c20;
            S1 = 48;
            S2 = 48;
            S3 = 48;
            S4 = 48;
            S5 = 48;
            S6 = 48;
            S7 = 48;
            S8 = 48;
            zoneIdBegin = 21;
            isTimeZone = c21 == 124;
        } else if (!(c4 != 45 || c7 != 45 || c10 != 32 && c10 != 84 || c13 != 58 || c16 != 58 || c19 != 46 || len != 22 && c22 != 91 && c22 != 43 && c22 != 45 && c22 != 90)) {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = c5;
            m1 = c6;
            d0 = c8;
            d1 = c9;
            h0 = c11;
            h1 = c12;
            i0 = c14;
            i1 = c15;
            s0 = c17;
            s1 = c18;
            S0 = c20;
            S1 = c21;
            S2 = 48;
            S3 = 48;
            S4 = 48;
            S5 = 48;
            S6 = 48;
            S7 = 48;
            S8 = 48;
            zoneIdBegin = 22;
            isTimeZone = c22 == 124;
        } else if (c4 == 45 && c7 == 45 && (c10 == 32 || c10 == 84) && c13 == 58 && c16 == 90 && c17 == 91 && c21 == 93 && len == 22) {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = c5;
            m1 = c6;
            d0 = c8;
            d1 = c9;
            h0 = c11;
            h1 = c12;
            i0 = c14;
            i1 = c15;
            s0 = 48;
            s1 = 48;
            S0 = 48;
            S1 = 48;
            S2 = 48;
            S3 = 48;
            S4 = 48;
            S5 = 48;
            S6 = 48;
            S7 = 48;
            S8 = 48;
            isTimeZone = true;
            zoneIdBegin = 17;
        } else if (len == 22 && c3 == 32 && c5 == 44 && c6 == 32 && c11 == 32 && c13 == 58 && c16 == 58 && c19 == 32 && (c20 == 65 || c20 == 80) && c21 == 77) {
            y0 = c7;
            y1 = c8;
            y2 = c9;
            y3 = c10;
            month = DateUtils.month((char)c0, (char)c1, (char)c2);
            if (month > 0) {
                m0 = (char)(48 + month / 10);
                m1 = (char)(48 + month % 10);
            } else {
                m0 = 48;
                m1 = 48;
            }
            d0 = 48;
            d1 = c4;
            h0 = 48;
            h1 = c12;
            pm = c20 == 80;
            i0 = c14;
            i1 = c15;
            s0 = c17;
            s1 = c18;
            S0 = 48;
            S1 = 48;
            S2 = 48;
            S3 = 48;
            S4 = 48;
            S5 = 48;
            S6 = 48;
            S7 = 48;
            S8 = 48;
            zoneIdBegin = 22;
        } else if (len == 22 && c2 == 47 && c5 == 47 && c10 == 32 && c13 == 58 && c16 == 58 && c19 == 32 && (c20 == 65 || c20 == 80) && c21 == 77) {
            m0 = c0;
            m1 = c1;
            d0 = c3;
            d1 = c4;
            y0 = c6;
            y1 = c7;
            y2 = c8;
            y3 = c9;
            h0 = c11;
            h1 = c12;
            pm = c20 == 80;
            i0 = c14;
            i1 = c15;
            s0 = c17;
            s1 = c18;
            S0 = 48;
            S1 = 48;
            S2 = 48;
            S3 = 48;
            S4 = 48;
            S5 = 48;
            S6 = 48;
            S7 = 48;
            S8 = 48;
            zoneIdBegin = 22;
        } else if (len == 23 && c3 == 32 && c5 == 44 && c6 == 32 && c11 == 32 && c14 == 58 && c17 == 58 && c20 == 32 && (c21 == 65 || c21 == 80) && c22 == 77) {
            y0 = c7;
            y1 = c8;
            y2 = c9;
            y3 = c10;
            month = DateUtils.month((char)c0, (char)c1, (char)c2);
            if (month > 0) {
                m0 = (char)(48 + month / 10);
                m1 = (char)(48 + month % 10);
            } else {
                m0 = 48;
                m1 = 48;
            }
            d0 = 48;
            d1 = c4;
            h0 = c12;
            h1 = c13;
            pm = c21 == 80;
            i0 = c15;
            i1 = c16;
            s0 = c18;
            s1 = c19;
            S0 = 48;
            S1 = 48;
            S2 = 48;
            S3 = 48;
            S4 = 48;
            S5 = 48;
            S6 = 48;
            S7 = 48;
            S8 = 48;
            zoneIdBegin = 23;
        } else if (len == 23 && c3 == 32 && c6 == 44 && c7 == 32 && c12 == 32 && c14 == 58 && c17 == 58 && c20 == 32 && (c21 == 65 || c21 == 80) && c22 == 77) {
            y0 = c8;
            y1 = c9;
            y2 = c10;
            y3 = c11;
            month = DateUtils.month((char)c0, (char)c1, (char)c2);
            if (month > 0) {
                m0 = (char)(48 + month / 10);
                m1 = (char)(48 + month % 10);
            } else {
                m0 = 48;
                m1 = 48;
            }
            d0 = c4;
            d1 = c5;
            h0 = 48;
            h1 = c13;
            pm = c21 == 80;
            i0 = c15;
            i1 = c16;
            s0 = c18;
            s1 = c19;
            S0 = 48;
            S1 = 48;
            S2 = 48;
            S3 = 48;
            S4 = 48;
            S5 = 48;
            S6 = 48;
            S7 = 48;
            S8 = 48;
            zoneIdBegin = 23;
        } else if (len == 23 && c3 == 32 && c5 == 44 && c6 == 32 && c11 == 44 && c12 == 32 && c14 == 58 && c17 == 58 && c20 == 32 && (c21 == 65 || c21 == 80) && c22 == 77) {
            y0 = c7;
            y1 = c8;
            y2 = c9;
            y3 = c10;
            month = DateUtils.month((char)c0, (char)c1, (char)c2);
            if (month > 0) {
                m0 = (char)(48 + month / 10);
                m1 = (char)(48 + month % 10);
            } else {
                m0 = 48;
                m1 = 48;
            }
            d0 = 48;
            d1 = c4;
            h0 = 48;
            h1 = c13;
            pm = c21 == 80;
            i0 = c15;
            i1 = c16;
            s0 = c18;
            s1 = c19;
            S0 = 48;
            S1 = 48;
            S2 = 48;
            S3 = 48;
            S4 = 48;
            S5 = 48;
            S6 = 48;
            S7 = 48;
            S8 = 48;
            zoneIdBegin = 23;
        } else if (len == 24 && c3 == 32 && c6 == 44 && c7 == 32 && c12 == 32 && c15 == 58 && c18 == 58 && c21 == 32 && (c22 == 65 || c22 == 80) && c23 == 77) {
            y0 = c8;
            y1 = c9;
            y2 = c10;
            y3 = c11;
            month = DateUtils.month((char)c0, (char)c1, (char)c2);
            if (month > 0) {
                m0 = (char)(48 + month / 10);
                m1 = (char)(48 + month % 10);
            } else {
                m0 = 48;
                m1 = 48;
            }
            d0 = c4;
            d1 = c5;
            h0 = c13;
            h1 = c14;
            pm = c22 == 80;
            i0 = c16;
            i1 = c17;
            s0 = c19;
            s1 = c20;
            S0 = 48;
            S1 = 48;
            S2 = 48;
            S3 = 48;
            S4 = 48;
            S5 = 48;
            S6 = 48;
            S7 = 48;
            S8 = 48;
            zoneIdBegin = 24;
        } else if (!(c4 != 45 || c7 != 45 || c10 != 32 && c10 != 84 || c13 != 58 || c16 != 58 || c19 != 46 || len != 23 && c23 != 91 && c23 != 124 && c23 != 43 && c23 != 45 && c23 != 90)) {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = c5;
            m1 = c6;
            d0 = c8;
            d1 = c9;
            h0 = c11;
            h1 = c12;
            i0 = c14;
            i1 = c15;
            s0 = c17;
            s1 = c18;
            S0 = c20;
            S1 = c21;
            S2 = c22;
            S3 = 48;
            S4 = 48;
            S5 = 48;
            S6 = 48;
            S7 = 48;
            S8 = 48;
            zoneIdBegin = 23;
            isTimeZone = c23 == 124;
        } else if (!(c4 != 45 || c7 != 45 || c10 != 32 && c10 != 84 || c13 != 58 || c16 != 58 || c19 != 46 || len != 24 && c24 != 91 && c24 != 124 && c24 != 43 && c24 != 45 && c24 != 90)) {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = c5;
            m1 = c6;
            d0 = c8;
            d1 = c9;
            h0 = c11;
            h1 = c12;
            i0 = c14;
            i1 = c15;
            s0 = c17;
            s1 = c18;
            S0 = c20;
            S1 = c21;
            S2 = c22;
            S3 = c23;
            S4 = 48;
            S5 = 48;
            S6 = 48;
            S7 = 48;
            S8 = 48;
            zoneIdBegin = 24;
            isTimeZone = c24 == 124;
        } else if (len == 24 && c3 == 32 && c6 == 44 && c7 == 32 && c12 == 44 && c13 == 32 && c15 == 58 && c18 == 58 && c21 == 32 && (c22 == 65 || c22 == 80) && c23 == 77) {
            y0 = c8;
            y1 = c9;
            y2 = c10;
            y3 = c11;
            month = DateUtils.month((char)c0, (char)c1, (char)c2);
            if (month > 0) {
                m0 = (char)(48 + month / 10);
                m1 = (char)(48 + month % 10);
            } else {
                m0 = 48;
                m1 = 48;
            }
            d0 = c4;
            d1 = c5;
            h0 = 48;
            h1 = c14;
            pm = c22 == 80;
            i0 = c16;
            i1 = c17;
            s0 = c19;
            s1 = c20;
            S0 = 48;
            S1 = 48;
            S2 = 48;
            S3 = 48;
            S4 = 48;
            S5 = 48;
            S6 = 48;
            S7 = 48;
            S8 = 48;
            zoneIdBegin = 24;
        } else if (len == 24 && c3 == 32 && c5 == 44 && c6 == 32 && c11 == 44 && c12 == 32 && c15 == 58 && c18 == 58 && c21 == 32 && (c22 == 65 || c22 == 80) && c23 == 77) {
            y0 = c7;
            y1 = c8;
            y2 = c9;
            y3 = c10;
            month = DateUtils.month((char)c0, (char)c1, (char)c2);
            if (month > 0) {
                m0 = (char)(48 + month / 10);
                m1 = (char)(48 + month % 10);
            } else {
                m0 = 48;
                m1 = 48;
            }
            d0 = 48;
            d1 = c4;
            h0 = c13;
            h1 = c14;
            pm = c22 == 80;
            i0 = c16;
            i1 = c17;
            s0 = c19;
            s1 = c20;
            S0 = 48;
            S1 = 48;
            S2 = 48;
            S3 = 48;
            S4 = 48;
            S5 = 48;
            S6 = 48;
            S7 = 48;
            S8 = 48;
            zoneIdBegin = 24;
        } else if (!(c4 != 45 || c7 != 45 || c10 != 32 && c10 != 84 || c13 != 58 || c16 != 58 || c19 != 46 || len != 25 && c25 != 91 && c25 != 124 && c25 != 43 && c25 != 45 && c25 != 90)) {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = c5;
            m1 = c6;
            d0 = c8;
            d1 = c9;
            h0 = c11;
            h1 = c12;
            i0 = c14;
            i1 = c15;
            s0 = c17;
            s1 = c18;
            S0 = c20;
            S1 = c21;
            S2 = c22;
            S3 = c23;
            S4 = c24;
            S5 = 48;
            S6 = 48;
            S7 = 48;
            S8 = 48;
            zoneIdBegin = 25;
            isTimeZone = c25 == 124;
        } else if (len == 25 && c3 == 32 && c6 == 44 && c7 == 32 && c12 == 44 && c13 == 32 && c16 == 58 && c19 == 58 && c22 == 32 && (c23 == 65 || c23 == 80) && c24 == 77) {
            y0 = c8;
            y1 = c9;
            y2 = c10;
            y3 = c11;
            month = DateUtils.month((char)c0, (char)c1, (char)c2);
            if (month > 0) {
                m0 = (char)(48 + month / 10);
                m1 = (char)(48 + month % 10);
            } else {
                m0 = 48;
                m1 = 48;
            }
            d0 = c4;
            d1 = c5;
            h0 = c14;
            h1 = c15;
            pm = c23 == 80;
            i0 = c17;
            i1 = c18;
            s0 = c20;
            s1 = c21;
            S0 = 48;
            S1 = 48;
            S2 = 48;
            S3 = 48;
            S4 = 48;
            S5 = 48;
            S6 = 48;
            S7 = 48;
            S8 = 48;
            zoneIdBegin = 25;
        } else if (!(c4 != 45 || c7 != 45 || c10 != 32 && c10 != 84 || c13 != 58 || c16 != 58 || c19 != 46 || len != 26 && c26 != 91 && c26 != 124 && c26 != 43 && c26 != 45 && c26 != 90)) {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = c5;
            m1 = c6;
            d0 = c8;
            d1 = c9;
            h0 = c11;
            h1 = c12;
            i0 = c14;
            i1 = c15;
            s0 = c17;
            s1 = c18;
            S0 = c20;
            S1 = c21;
            S2 = c22;
            S3 = c23;
            S4 = c24;
            S5 = c25;
            S6 = 48;
            S7 = 48;
            S8 = 48;
            zoneIdBegin = 26;
            isTimeZone = c26 == 124;
        } else if (!(c4 != 45 || c7 != 45 || c10 != 32 && c10 != 84 || c13 != 58 || c16 != 58 || c19 != 46 || len != 27 && c27 != 91 && c27 != 124 && c27 != 43 && c27 != 45 && c27 != 90)) {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = c5;
            m1 = c6;
            d0 = c8;
            d1 = c9;
            h0 = c11;
            h1 = c12;
            i0 = c14;
            i1 = c15;
            s0 = c17;
            s1 = c18;
            S0 = c20;
            S1 = c21;
            S2 = c22;
            if (c23 == 32) {
                S3 = 48;
                S4 = 48;
                S5 = 48;
                S6 = 48;
                S7 = 48;
                S8 = 48;
                zoneIdBegin = 23;
            } else {
                S3 = c23;
                S4 = c24;
                S5 = c25;
                S6 = c26;
                S7 = 48;
                S8 = 48;
                zoneIdBegin = 27;
                isTimeZone = c27 == 124;
            }
        } else if (!(c4 != 45 || c7 != 45 || c10 != 32 && c10 != 84 || c13 != 58 || c16 != 58 || c19 != 46 || len != 28 && c28 != 91 && c28 != 124 && c28 != 43 && c28 != 45 && c28 != 90)) {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = c5;
            m1 = c6;
            d0 = c8;
            d1 = c9;
            h0 = c11;
            h1 = c12;
            i0 = c14;
            i1 = c15;
            s0 = c17;
            s1 = c18;
            S0 = c20;
            S1 = c21;
            S2 = c22;
            S3 = c23;
            S4 = c24;
            S5 = c25;
            S6 = c26;
            S7 = c27;
            S8 = 48;
            zoneIdBegin = 28;
            isTimeZone = c28 == 124;
        } else if (len == 28 && c3 == 32 && c7 == 32 && c10 == 32 && c13 == 58 && c16 == 58 && c19 == 32 && c23 == 32) {
            month = DateUtils.month((char)c4, (char)c5, (char)c6);
            if (month > 0) {
                m0 = (char)(48 + month / 10);
                m1 = (char)(48 + month % 10);
            } else {
                m0 = 48;
                m1 = 48;
            }
            d0 = c8;
            d1 = c9;
            h0 = c11;
            h1 = c12;
            i0 = c14;
            i1 = c15;
            s0 = c17;
            s1 = c18;
            y0 = c24;
            y1 = c25;
            y2 = c26;
            y3 = c27;
            S0 = 48;
            S1 = 48;
            S2 = 48;
            S3 = 48;
            S4 = 48;
            S5 = 48;
            S6 = 48;
            S7 = 48;
            S8 = 48;
            zoneIdBegin = 19;
            zoneIdStr = new String(str, off + 20, 3);
        } else if (len == 28 && c3 == 44 && c4 == 32 && c6 == 32 && c10 == 32 && c15 == 32 && c18 == 58 && c21 == 58 && c24 == 32) {
            y0 = c11;
            y1 = c12;
            y2 = c13;
            y3 = c14;
            month = DateUtils.month((char)c7, (char)c8, (char)c9);
            if (month > 0) {
                m0 = (char)(48 + month / 10);
                m1 = (char)(48 + month % 10);
            } else {
                m0 = 48;
                m1 = 48;
            }
            d0 = 48;
            d1 = c5;
            h0 = c16;
            h1 = c17;
            i0 = c19;
            i1 = c20;
            s0 = c22;
            s1 = c23;
            S0 = 48;
            S1 = 48;
            S2 = 48;
            S3 = 48;
            S4 = 48;
            S5 = 48;
            S6 = 48;
            S7 = 48;
            S8 = 48;
            zoneIdBegin = 24;
            isTimeZone = true;
        } else if (len == 29 && c3 == 44 && c4 == 32 && c7 == 32 && c11 == 32 && c16 == 32 && c19 == 58 && c22 == 58 && c25 == 32) {
            y0 = c12;
            y1 = c13;
            y2 = c14;
            y3 = c15;
            month = DateUtils.month((char)c8, (char)c9, (char)c10);
            if (month > 0) {
                m0 = (char)(48 + month / 10);
                m1 = (char)(48 + month % 10);
            } else {
                m0 = 48;
                m1 = 48;
            }
            d0 = c5;
            d1 = c6;
            h0 = c17;
            h1 = c18;
            i0 = c20;
            i1 = c21;
            s0 = c23;
            s1 = c24;
            S0 = 48;
            S1 = 48;
            S2 = 48;
            S3 = 48;
            S4 = 48;
            S5 = 48;
            S6 = 48;
            S7 = 48;
            S8 = 48;
            zoneIdBegin = 25;
            isTimeZone = true;
        } else if (!(c4 != 45 || c7 != 45 || c10 != 32 && c10 != 84 || c13 != 58 || c16 != 58 || c19 != 46 || len != 29 && c29 != '[' && c29 != '|' && c29 != '+' && c29 != '-' && c29 != 'Z')) {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = c5;
            m1 = c6;
            d0 = c8;
            d1 = c9;
            h0 = c11;
            h1 = c12;
            i0 = c14;
            i1 = c15;
            s0 = c17;
            s1 = c18;
            S0 = c20;
            S1 = c21;
            S2 = c22;
            S3 = c23;
            S4 = c24;
            S5 = c25;
            S6 = c26;
            S7 = c27;
            S8 = c28;
            zoneIdBegin = 29;
            isTimeZone = c29 == '|';
        } else if (len == 22 && (c17 == 43 || c17 == 45)) {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = c4;
            m1 = c5;
            d0 = c6;
            d1 = c7;
            h0 = c8;
            h1 = c9;
            i0 = c10;
            i1 = c11;
            s0 = c12;
            s1 = c13;
            S0 = c14;
            S1 = c15;
            S2 = c16;
            S3 = 48;
            S4 = 48;
            S5 = 48;
            S6 = 48;
            S7 = 48;
            S8 = 48;
            zoneIdBegin = 17;
        } else {
            if (len == 32 && c6 == 44 && c7 == 32 && c10 == 45 && c14 == 45 && c19 == 32 && c22 == 58 && c25 == 58 && str[off + 28] == ' ' || len == 33 && c7 == 44 && c8 == 32 && c11 == 45 && c15 == 45 && c20 == 32 && c23 == 58 && c26 == 58 && str[off + 29] == ' ' || len == 34 && c8 == 44 && c9 == 32 && c12 == 45 && c16 == 45 && c21 == 32 && c24 == 58 && c27 == 58 && str[off + 30] == ' ' || len == 35 && c9 == 44 && c10 == 32 && c13 == 45 && c17 == 45 && c22 == 32 && c25 == 58 && c28 == 58 && str[off + 31] == ' ') {
                return DateUtils.parseZonedDateTimeCookie(new String(str, off, len));
            }
            if (len == 34) {
                DateTimeFormatter formatter = DATE_TIME_FORMATTER_34;
                if (formatter == null) {
                    formatter = DATE_TIME_FORMATTER_34 = DateTimeFormatter.ofPattern("EEE MMM dd HH:mm:ss O yyyy", Locale.ENGLISH);
                }
                return ZonedDateTime.parse(new String(str, off, len), formatter);
            }
            if (len == 31 && str[off + 3] == ',') {
                DateTimeFormatter formatter = DATE_TIME_FORMATTER_RFC_2822;
                if (formatter == null) {
                    formatter = DATE_TIME_FORMATTER_RFC_2822 = DateTimeFormatter.ofPattern("EEE, dd MMM yyyy HH:mm:ss Z", Locale.ENGLISH);
                }
                return ZonedDateTime.parse(new String(str, off, len), formatter);
            }
            return null;
        }
        if (pm && h0 == 49 && h1 == 50) {
            pm = false;
        }
        if (pm) {
            int hourValue = DateUtils.hourAfterNoon((char)h0, (char)h1);
            h0 = (char)(hourValue >> 16);
            h1 = (char)hourValue;
        }
        if ((ldt = DateUtils.localDateTime((char)y0, (char)y1, (char)y2, (char)y3, (char)m0, (char)m1, (char)d0, (char)d1, (char)h0, (char)h1, (char)i0, (char)i1, (char)s0, (char)s1, (char)S0, (char)S1, (char)S2, (char)S3, (char)S4, (char)S5, (char)S6, (char)S7, (char)S8)) == null) {
            return null;
        }
        if (isTimeZone) {
            String tzStr;
            switch (tzStr = new String(str, zoneIdBegin, len - zoneIdBegin)) {
                case "UTC": 
                case "[UTC]": {
                    zoneId = ZoneOffset.UTC;
                    break;
                }
                default: {
                    TimeZone timeZone = TimeZone.getTimeZone(tzStr);
                    zoneId = timeZone.toZoneId();
                    break;
                }
            }
        } else if (zoneIdBegin == len) {
            zoneId = defaultZoneId;
        } else {
            char first = str[off + zoneIdBegin];
            if (first == 'Z') {
                zoneId = ZoneOffset.UTC;
            } else {
                if (zoneIdStr == null) {
                    if (first == '+' || first == '-') {
                        zoneIdStr = new String(str, off + zoneIdBegin, len - zoneIdBegin);
                    } else if (first == ' ') {
                        zoneIdStr = new String(str, off + zoneIdBegin + 1, len - zoneIdBegin - 1);
                    } else if (zoneIdBegin < len) {
                        zoneIdStr = new String(str, off + zoneIdBegin + 1, len - zoneIdBegin - 2);
                    }
                }
                zoneId = DateUtils.getZoneId(zoneIdStr, defaultZoneId);
            }
        }
        if (zoneId == null) {
            zoneId = defaultZoneId;
        }
        if (zoneId == null) {
            zoneId = DEFAULT_ZONE_ID;
        }
        return ZonedDateTime.ofLocal(ldt, zoneId, null);
    }

    static ZonedDateTime parseZonedDateTimeCookie(String str) {
        if (str.endsWith(" CST")) {
            DateTimeFormatter formatter = DATE_TIME_FORMATTER_COOKIE_LOCAL;
            if (formatter == null) {
                DATE_TIME_FORMATTER_COOKIE_LOCAL = formatter = DateTimeFormatter.ofPattern("EEEE, dd-MMM-yyyy HH:mm:ss", Locale.ENGLISH);
            }
            String strLocalDateTime = str.substring(0, str.length() - 4);
            LocalDateTime ldt = LocalDateTime.parse(strLocalDateTime, formatter);
            return ZonedDateTime.of(ldt, SHANGHAI_ZONE_ID);
        }
        DateTimeFormatter formatter = DATE_TIME_FORMATTER_COOKIE;
        if (formatter == null) {
            DATE_TIME_FORMATTER_COOKIE = formatter = DateTimeFormatter.ofPattern("EEEE, dd-MMM-yyyy HH:mm:ss zzz", Locale.ENGLISH);
        }
        return ZonedDateTime.parse(str, formatter);
    }

    public static ZoneId getZoneId(String zoneIdStr, ZoneId defaultZoneId) {
        ZoneId zoneId;
        if (zoneIdStr == null) {
            return defaultZoneId != null ? defaultZoneId : DEFAULT_ZONE_ID;
        }
        switch (zoneIdStr) {
            case "000": {
                zoneId = ZoneOffset.UTC;
                break;
            }
            case "+08:00": {
                zoneId = OFFSET_8_ZONE_ID;
                break;
            }
            case "CST": {
                zoneId = SHANGHAI_ZONE_ID;
                break;
            }
            default: {
                int p1;
                char c0;
                if (zoneIdStr.length() > 0 && ((c0 = zoneIdStr.charAt(0)) == '+' || c0 == '-') && zoneIdStr.charAt(zoneIdStr.length() - 1) != ']') {
                    zoneId = ZoneOffset.of(zoneIdStr);
                    break;
                }
                int p0 = zoneIdStr.indexOf(91);
                if (p0 > 0 && (p1 = zoneIdStr.indexOf(93, p0)) > 0) {
                    String str = zoneIdStr.substring(p0 + 1, p1);
                    zoneId = ZoneId.of(str);
                    break;
                }
                zoneId = ZoneId.of(zoneIdStr);
            }
        }
        return zoneId;
    }

    public static long parseMillisYMDHMS19(String str, ZoneId zoneId) {
        int zoneOffsetTotalSeconds;
        int dom;
        int month;
        char c18;
        char c17;
        char c16;
        char c15;
        char c14;
        char c13;
        char c12;
        char c11;
        char c10;
        char c9;
        char c8;
        char c7;
        char c6;
        char c5;
        char c4;
        char c3;
        char c2;
        char c1;
        char c0;
        if (str == null) {
            return 0L;
        }
        if (JDKUtils.JVM_VERSION == 8) {
            char[] chars = JDKUtils.getCharArray(str);
            if (chars.length != 19) {
                throw new DateTimeParseException("illegal input " + str, str, 0);
            }
            c0 = chars[0];
            c1 = chars[1];
            c2 = chars[2];
            c3 = chars[3];
            c4 = chars[4];
            c5 = chars[5];
            c6 = chars[6];
            c7 = chars[7];
            c8 = chars[8];
            c9 = chars[9];
            c10 = chars[10];
            c11 = chars[11];
            c12 = chars[12];
            c13 = chars[13];
            c14 = chars[14];
            c15 = chars[15];
            c16 = chars[16];
            c17 = chars[17];
            c18 = chars[18];
        } else if (JDKUtils.STRING_CODER != null && JDKUtils.STRING_CODER.applyAsInt(str) == 0 && JDKUtils.STRING_VALUE != null) {
            byte[] bytes = JDKUtils.STRING_VALUE.apply(str);
            if (bytes.length != 19) {
                throw new DateTimeParseException("illegal input " + str, str, 0);
            }
            c0 = (char)bytes[0];
            c1 = (char)bytes[1];
            c2 = (char)bytes[2];
            c3 = (char)bytes[3];
            c4 = (char)bytes[4];
            c5 = (char)bytes[5];
            c6 = (char)bytes[6];
            c7 = (char)bytes[7];
            c8 = (char)bytes[8];
            c9 = (char)bytes[9];
            c10 = (char)bytes[10];
            c11 = (char)bytes[11];
            c12 = (char)bytes[12];
            c13 = (char)bytes[13];
            c14 = (char)bytes[14];
            c15 = (char)bytes[15];
            c16 = (char)bytes[16];
            c17 = (char)bytes[17];
            c18 = (char)bytes[18];
        } else {
            if (str.length() != 19) {
                throw new DateTimeParseException("illegal input " + str, str, 0);
            }
            c0 = str.charAt(0);
            c1 = str.charAt(1);
            c2 = str.charAt(2);
            c3 = str.charAt(3);
            c4 = str.charAt(4);
            c5 = str.charAt(5);
            c6 = str.charAt(6);
            c7 = str.charAt(7);
            c8 = str.charAt(8);
            c9 = str.charAt(9);
            c10 = str.charAt(10);
            c11 = str.charAt(11);
            c12 = str.charAt(12);
            c13 = str.charAt(13);
            c14 = str.charAt(14);
            c15 = str.charAt(15);
            c16 = str.charAt(16);
            c17 = str.charAt(17);
            c18 = str.charAt(18);
        }
        if (c4 != '-' || c7 != '-' || c10 != ' ' || c13 != ':' || c16 != ':') {
            throw new DateTimeParseException("illegal input", str, 0);
        }
        char y0 = c0;
        char y1 = c1;
        char y2 = c2;
        char y3 = c3;
        char m0 = c5;
        char m1 = c6;
        char d0 = c8;
        char d1 = c9;
        char h0 = c11;
        char h1 = c12;
        char i0 = c14;
        char i1 = c15;
        char s0 = c17;
        char s1 = c18;
        if (y0 < '0' || y0 > '9' || y1 < '0' || y1 > '9' || y2 < '0' || y2 > '9' || y3 < '0' || y3 > '9') {
            throw new DateTimeParseException("illegal input", str, 0);
        }
        int year = (y0 - 48) * 1000 + (y1 - 48) * 100 + (y2 - 48) * 10 + (y3 - 48);
        if (m0 >= '0' && m0 <= '9' && m1 >= '0' && m1 <= '9') {
            month = (m0 - 48) * 10 + (m1 - 48);
            if (month == 0 && year != 0 || month > 12) {
                throw new DateTimeParseException("illegal input", str, 0);
            }
        } else {
            throw new DateTimeParseException("illegal input", str, 0);
        }
        if (d0 >= '0' && d0 <= '9' && d1 >= '0' && d1 <= '9') {
            dom = (d0 - 48) * 10 + (d1 - 48);
            int max = 31;
            switch (month) {
                case 2: {
                    boolean leapYear = (year & 3) == 0 && (year % 100 != 0 || year % 400 == 0);
                    max = leapYear ? 29 : 28;
                    break;
                }
                case 4: 
                case 6: 
                case 9: 
                case 11: {
                    max = 30;
                }
            }
            if (dom == 0 && year != 0 || dom > max) {
                throw new DateTimeParseException("illegal input", str, 0);
            }
        } else {
            throw new DateTimeParseException("illegal input", str, 0);
        }
        if (h0 < '0' || h0 > '9' || h1 < '0' || h1 > '9') {
            throw new DateTimeParseException("illegal input", str, 0);
        }
        int hour = (h0 - 48) * 10 + (h1 - 48);
        if (i0 < '0' || i0 > '9' || i1 < '0' || i1 > '9') {
            throw new DateTimeParseException("illegal input", str, 0);
        }
        int minute = (i0 - 48) * 10 + (i1 - 48);
        if (s0 < '0' || s0 > '9' || s1 < '0' || s1 > '9') {
            throw new DateTimeParseException("illegal input", str, 0);
        }
        int second = (s0 - 48) * 10 + (s1 - 48);
        if (year == 0 && month == 0 && dom == 0) {
            year = 1970;
            month = 1;
            dom = 1;
        }
        long epochDay = DateUtils.calcEpochDay(year, month, dom);
        long utcSeconds = epochDay * 86400L + (long)(hour * 3600) + (long)(minute * 60) + (long)second;
        if (zoneId == null) {
            zoneId = DEFAULT_ZONE_ID;
        }
        boolean shanghai = zoneId == SHANGHAI_ZONE_ID || zoneId.getRules() == SHANGHAI_ZONE_RULES;
        long SECONDS_1991_09_15_02 = 684900000L;
        if (shanghai && utcSeconds >= SECONDS_1991_09_15_02) {
            zoneOffsetTotalSeconds = 28800;
        } else if (zoneId == ZoneOffset.UTC || "UTC".equals(zoneId.getId())) {
            zoneOffsetTotalSeconds = 0;
        } else {
            LocalDate localDate = LocalDate.of(year, month, dom);
            LocalTime localTime = LocalTime.of(hour, minute, second, 0);
            LocalDateTime ldt = LocalDateTime.of(localDate, localTime);
            ZoneOffset offset = zoneId.getRules().getOffset(ldt);
            zoneOffsetTotalSeconds = offset.getTotalSeconds();
        }
        return (utcSeconds - (long)zoneOffsetTotalSeconds) * 1000L;
    }

    private static long calcEpochDay(int year, int month, int dom) {
        int DAYS_PER_CYCLE = 146097;
        long DAYS_0000_TO_1970 = 719528L;
        long total = 365 * year + ((year + 3) / 4 - (year + 99) / 100 + (year + 399) / 400) + (367 * month - 362) / 12 + (dom - 1);
        if (month > 2) {
            boolean leapYear;
            --total;
            boolean bl = leapYear = (year & 3) == 0 && (year % 100 != 0 || year % 400 == 0);
            if (!leapYear) {
                --total;
            }
        }
        return total - 719528L;
    }

    static long parseMillis19(String str, ZoneId zoneId, DateTimeFormatPattern pattern) {
        int zoneOffsetTotalSeconds;
        int dom;
        int month;
        char s1;
        char s0;
        char i1;
        char i0;
        char h1;
        char h0;
        char d1;
        char d0;
        char m1;
        char m0;
        char y3;
        char y2;
        char y1;
        char y0;
        char c18;
        char c17;
        char c16;
        char c15;
        char c14;
        char c13;
        char c12;
        char c11;
        char c10;
        char c9;
        char c8;
        char c7;
        char c6;
        char c5;
        char c4;
        char c3;
        char c2;
        char c1;
        char c0;
        if (str == null || "null".equals(str)) {
            return 0L;
        }
        if (pattern.length != 19) {
            throw new UnsupportedOperationException();
        }
        if (JDKUtils.JVM_VERSION == 8) {
            char[] chars = JDKUtils.getCharArray(str);
            if (chars.length != 19) {
                throw new DateTimeParseException("illegal input " + str, str, 0);
            }
            c0 = chars[0];
            c1 = chars[1];
            c2 = chars[2];
            c3 = chars[3];
            c4 = chars[4];
            c5 = chars[5];
            c6 = chars[6];
            c7 = chars[7];
            c8 = chars[8];
            c9 = chars[9];
            c10 = chars[10];
            c11 = chars[11];
            c12 = chars[12];
            c13 = chars[13];
            c14 = chars[14];
            c15 = chars[15];
            c16 = chars[16];
            c17 = chars[17];
            c18 = chars[18];
        } else if (JDKUtils.STRING_CODER != null && JDKUtils.STRING_VALUE != null && JDKUtils.STRING_CODER.applyAsInt(str) == 0) {
            byte[] bytes = JDKUtils.STRING_VALUE.apply(str);
            if (bytes.length != 19) {
                throw new DateTimeParseException("illegal input " + str, str, 0);
            }
            c0 = (char)bytes[0];
            c1 = (char)bytes[1];
            c2 = (char)bytes[2];
            c3 = (char)bytes[3];
            c4 = (char)bytes[4];
            c5 = (char)bytes[5];
            c6 = (char)bytes[6];
            c7 = (char)bytes[7];
            c8 = (char)bytes[8];
            c9 = (char)bytes[9];
            c10 = (char)bytes[10];
            c11 = (char)bytes[11];
            c12 = (char)bytes[12];
            c13 = (char)bytes[13];
            c14 = (char)bytes[14];
            c15 = (char)bytes[15];
            c16 = (char)bytes[16];
            c17 = (char)bytes[17];
            c18 = (char)bytes[18];
        } else {
            if (str.length() != 19) {
                throw new DateTimeParseException("illegal input " + str, str, 0);
            }
            c0 = str.charAt(0);
            c1 = str.charAt(1);
            c2 = str.charAt(2);
            c3 = str.charAt(3);
            c4 = str.charAt(4);
            c5 = str.charAt(5);
            c6 = str.charAt(6);
            c7 = str.charAt(7);
            c8 = str.charAt(8);
            c9 = str.charAt(9);
            c10 = str.charAt(10);
            c11 = str.charAt(11);
            c12 = str.charAt(12);
            c13 = str.charAt(13);
            c14 = str.charAt(14);
            c15 = str.charAt(15);
            c16 = str.charAt(16);
            c17 = str.charAt(17);
            c18 = str.charAt(18);
        }
        switch (pattern.ordinal()) {
            case 3: {
                if (c4 != '-' || c7 != '-' || c10 != ' ' || c13 != ':' || c16 != ':') {
                    throw new DateTimeParseException("illegal input", str, 0);
                }
                y0 = c0;
                y1 = c1;
                y2 = c2;
                y3 = c3;
                m0 = c5;
                m1 = c6;
                d0 = c8;
                d1 = c9;
                h0 = c11;
                h1 = c12;
                i0 = c14;
                i1 = c15;
                s0 = c17;
                s1 = c18;
                break;
            }
            case 4: {
                if (c4 != '-' || c7 != '-' || c10 != 'T' || c13 != ':' || c16 != ':') {
                    throw new DateTimeParseException("illegal input", str, 0);
                }
                y0 = c0;
                y1 = c1;
                y2 = c2;
                y3 = c3;
                m0 = c5;
                m1 = c6;
                d0 = c8;
                d1 = c9;
                h0 = c11;
                h1 = c12;
                i0 = c14;
                i1 = c15;
                s0 = c17;
                s1 = c18;
                break;
            }
            case 5: {
                if (c4 != '/' || c7 != '/' || c10 != ' ' || c13 != ':' || c16 != ':') {
                    throw new DateTimeParseException("illegal input", str, 0);
                }
                y0 = c0;
                y1 = c1;
                y2 = c2;
                y3 = c3;
                m0 = c5;
                m1 = c6;
                d0 = c8;
                d1 = c9;
                h0 = c11;
                h1 = c12;
                i0 = c14;
                i1 = c15;
                s0 = c17;
                s1 = c18;
                break;
            }
            case 6: {
                if (c2 != '.' || c5 != '.' || c10 != ' ' || c13 != ':' || c16 != ':') {
                    throw new DateTimeParseException("illegal input", str, 0);
                }
                d0 = c0;
                d1 = c1;
                m0 = c3;
                m1 = c4;
                y0 = c6;
                y1 = c7;
                y2 = c8;
                y3 = c9;
                h0 = c11;
                h1 = c12;
                i0 = c14;
                i1 = c15;
                s0 = c17;
                s1 = c18;
                break;
            }
            default: {
                throw new DateTimeParseException("illegal input", str, 0);
            }
        }
        if (y0 < '0' || y0 > '9' || y1 < '0' || y1 > '9' || y2 < '0' || y2 > '9' || y3 < '0' || y3 > '9') {
            throw new DateTimeParseException("illegal input", str, 0);
        }
        int year = (y0 - 48) * 1000 + (y1 - 48) * 100 + (y2 - 48) * 10 + (y3 - 48);
        if (m0 >= '0' && m0 <= '9' && m1 >= '0' && m1 <= '9') {
            month = (m0 - 48) * 10 + (m1 - 48);
            if (month == 0 && year != 0 || month > 12) {
                throw new DateTimeParseException("illegal input", str, 0);
            }
        } else {
            throw new DateTimeParseException("illegal input", str, 0);
        }
        if (d0 >= '0' && d0 <= '9' && d1 >= '0' && d1 <= '9') {
            dom = (d0 - 48) * 10 + (d1 - 48);
            int max = 31;
            switch (month) {
                case 2: {
                    boolean leapYear = (year & 3) == 0 && (year % 100 != 0 || year % 400 == 0);
                    max = leapYear ? 29 : 28;
                    break;
                }
                case 4: 
                case 6: 
                case 9: 
                case 11: {
                    max = 30;
                }
            }
            if (dom == 0 && year != 0 || dom > max) {
                throw new DateTimeParseException("illegal input", str, 0);
            }
        } else {
            throw new DateTimeParseException("illegal input", str, 0);
        }
        if (h0 < '0' || h0 > '9' || h1 < '0' || h1 > '9') {
            throw new DateTimeParseException("illegal input", str, 0);
        }
        int hour = (h0 - 48) * 10 + (h1 - 48);
        if (i0 < '0' || i0 > '9' || i1 < '0' || i1 > '9') {
            throw new DateTimeParseException("illegal input", str, 0);
        }
        int minute = (i0 - 48) * 10 + (i1 - 48);
        if (s0 < '0' || s0 > '9' || s1 < '0' || s1 > '9') {
            throw new DateTimeParseException("illegal input", str, 0);
        }
        int second = (s0 - 48) * 10 + (s1 - 48);
        if (year == 0 && month == 0 && dom == 0) {
            year = 1970;
            month = 1;
            dom = 1;
        }
        long epochDay = DateUtils.calcEpochDay(year, month, dom);
        long utcSeconds = epochDay * 86400L + (long)(hour * 3600) + (long)(minute * 60) + (long)second;
        if (zoneId == null) {
            zoneId = DEFAULT_ZONE_ID;
        }
        boolean shanghai = zoneId == SHANGHAI_ZONE_ID || zoneId.getRules() == SHANGHAI_ZONE_RULES;
        long SECONDS_1991_09_15_02 = 684900000L;
        if (shanghai && utcSeconds >= SECONDS_1991_09_15_02) {
            zoneOffsetTotalSeconds = 28800;
        } else if (zoneId == ZoneOffset.UTC || "UTC".equals(zoneId.getId())) {
            zoneOffsetTotalSeconds = 0;
        } else {
            LocalDate localDate = LocalDate.of(year, month, dom);
            LocalTime localTime = LocalTime.of(hour, minute, second, 0);
            LocalDateTime ldt = LocalDateTime.of(localDate, localTime);
            ZoneOffset offset = zoneId.getRules().getOffset(ldt);
            zoneOffsetTotalSeconds = offset.getTotalSeconds();
        }
        return (utcSeconds - (long)zoneOffsetTotalSeconds) * 1000L;
    }

    static long parseMillis10(String str, ZoneId zoneId, DateTimeFormatPattern pattern) {
        int zoneOffsetTotalSeconds;
        int dom;
        int month;
        char d1;
        char d0;
        char m1;
        char m0;
        char y3;
        char y2;
        char y1;
        char y0;
        char c9;
        char c8;
        char c7;
        char c6;
        char c5;
        char c4;
        char c3;
        char c2;
        char c1;
        char c0;
        if (str == null || "null".equals(str)) {
            return 0L;
        }
        if (pattern.length != 10) {
            throw new UnsupportedOperationException();
        }
        if (JDKUtils.JVM_VERSION == 8) {
            char[] chars = JDKUtils.getCharArray(str);
            if (chars.length != 10) {
                throw new DateTimeParseException("illegal input " + str, str, 0);
            }
            c0 = chars[0];
            c1 = chars[1];
            c2 = chars[2];
            c3 = chars[3];
            c4 = chars[4];
            c5 = chars[5];
            c6 = chars[6];
            c7 = chars[7];
            c8 = chars[8];
            c9 = chars[9];
        } else if (JDKUtils.STRING_CODER != null && JDKUtils.STRING_VALUE != null && JDKUtils.STRING_CODER.applyAsInt(str) == 0) {
            byte[] bytes = JDKUtils.STRING_VALUE.apply(str);
            if (bytes.length != 10) {
                throw new DateTimeParseException("illegal input " + str, str, 0);
            }
            c0 = (char)bytes[0];
            c1 = (char)bytes[1];
            c2 = (char)bytes[2];
            c3 = (char)bytes[3];
            c4 = (char)bytes[4];
            c5 = (char)bytes[5];
            c6 = (char)bytes[6];
            c7 = (char)bytes[7];
            c8 = (char)bytes[8];
            c9 = (char)bytes[9];
        } else {
            if (str.length() != 10) {
                throw new DateTimeParseException("illegal input " + str, str, 0);
            }
            c0 = str.charAt(0);
            c1 = str.charAt(1);
            c2 = str.charAt(2);
            c3 = str.charAt(3);
            c4 = str.charAt(4);
            c5 = str.charAt(5);
            c6 = str.charAt(6);
            c7 = str.charAt(7);
            c8 = str.charAt(8);
            c9 = str.charAt(9);
        }
        switch (pattern.ordinal()) {
            case 0: {
                if (c4 != '-' || c7 != '-') {
                    throw new DateTimeParseException("illegal input", str, 0);
                }
                y0 = c0;
                y1 = c1;
                y2 = c2;
                y3 = c3;
                m0 = c5;
                m1 = c6;
                d0 = c8;
                d1 = c9;
                break;
            }
            case 1: {
                if (c4 != '/' || c7 != '/') {
                    throw new DateTimeParseException("illegal input", str, 0);
                }
                y0 = c0;
                y1 = c1;
                y2 = c2;
                y3 = c3;
                m0 = c5;
                m1 = c6;
                d0 = c8;
                d1 = c9;
                break;
            }
            default: {
                throw new DateTimeParseException("illegal input", str, 0);
            }
        }
        if (y0 < '0' || y0 > '9' || y1 < '0' || y1 > '9' || y2 < '0' || y2 > '9' || y3 < '0' || y3 > '9') {
            throw new DateTimeParseException("illegal input", str, 0);
        }
        int year = (y0 - 48) * 1000 + (y1 - 48) * 100 + (y2 - 48) * 10 + (y3 - 48);
        if (m0 >= '0' && m0 <= '9' && m1 >= '0' && m1 <= '9') {
            month = (m0 - 48) * 10 + (m1 - 48);
            if (month == 0 && year != 0 || month > 12) {
                throw new DateTimeParseException("illegal input", str, 0);
            }
        } else {
            throw new DateTimeParseException("illegal input", str, 0);
        }
        if (d0 >= '0' && d0 <= '9' && d1 >= '0' && d1 <= '9') {
            dom = (d0 - 48) * 10 + (d1 - 48);
            int max = 31;
            switch (month) {
                case 2: {
                    boolean leapYear = (year & 3) == 0 && (year % 100 != 0 || year % 400 == 0);
                    max = leapYear ? 29 : 28;
                    break;
                }
                case 4: 
                case 6: 
                case 9: 
                case 11: {
                    max = 30;
                }
            }
            if (dom == 0 && year != 0 || dom > max) {
                throw new DateTimeParseException("illegal input", str, 0);
            }
        } else {
            throw new DateTimeParseException("illegal input", str, 0);
        }
        if (year == 0 && month == 0 && dom == 0) {
            year = 1970;
            month = 1;
            dom = 1;
        }
        long epochDay = DateUtils.calcEpochDay(year, month, dom);
        long utcSeconds = epochDay * 86400L;
        boolean shanghai = zoneId == SHANGHAI_ZONE_ID || zoneId.getRules() == SHANGHAI_ZONE_RULES;
        long SECONDS_1991_09_15_02 = 684900000L;
        if (shanghai && utcSeconds >= SECONDS_1991_09_15_02) {
            zoneOffsetTotalSeconds = 28800;
        } else if (zoneId == ZoneOffset.UTC || "UTC".equals(zoneId.getId())) {
            zoneOffsetTotalSeconds = 0;
        } else {
            LocalDate localDate = LocalDate.of(year, month, dom);
            LocalDateTime ldt = LocalDateTime.of(localDate, LocalTime.MIN);
            ZoneOffset offset = zoneId.getRules().getOffset(ldt);
            zoneOffsetTotalSeconds = offset.getTotalSeconds();
        }
        return (utcSeconds - (long)zoneOffsetTotalSeconds) * 1000L;
    }

    /*
     * WARNING - void declaration
     */
    public static long parseMillis19(String str, ZoneId zoneId) {
        int zoneOffsetTotalSeconds;
        int dom;
        int month;
        int month2;
        char s1;
        int s0;
        char i1;
        int i0;
        char h1;
        int h0;
        int d1;
        int d0;
        char m1;
        char m0;
        void var7_15;
        int y3;
        int y2;
        void var4_9;
        int y1;
        int y0;
        char c18;
        int c17;
        char c16;
        char c15;
        int c14;
        char c13;
        char c12;
        int c11;
        char c10;
        int c9;
        int c8;
        char c7;
        char c6;
        char c4;
        char c3;
        int c1;
        int c0;
        Object[] chars;
        if (str == null) {
            throw new NullPointerException();
        }
        if (JDKUtils.JVM_VERSION == 8) {
            chars = JDKUtils.getCharArray(str);
            if (chars.length != 19) {
                throw new DateTimeParseException("illegal input " + str, str, 0);
            }
            c0 = chars[0];
            c1 = chars[1];
            char c = chars[2];
            c3 = chars[3];
            c4 = chars[4];
            char c2 = chars[5];
            c6 = chars[6];
            c7 = chars[7];
            c8 = chars[8];
            c9 = chars[9];
            c10 = chars[10];
            c11 = chars[11];
            c12 = chars[12];
            c13 = chars[13];
            c14 = chars[14];
            c15 = chars[15];
            c16 = chars[16];
            c17 = chars[17];
            c18 = chars[18];
        } else if (JDKUtils.STRING_CODER != null && JDKUtils.STRING_VALUE != null && JDKUtils.STRING_CODER.applyAsInt(str) == 0) {
            chars = JDKUtils.STRING_VALUE.apply(str);
            if (chars.length != 19) {
                throw new DateTimeParseException("illegal input " + str, str, 0);
            }
            c0 = chars[0];
            c1 = chars[1];
            char c = chars[2];
            c3 = chars[3];
            c4 = chars[4];
            char c5 = chars[5];
            c6 = chars[6];
            c7 = chars[7];
            c8 = chars[8];
            c9 = chars[9];
            c10 = chars[10];
            c11 = chars[11];
            c12 = chars[12];
            c13 = chars[13];
            c14 = chars[14];
            c15 = chars[15];
            c16 = chars[16];
            c17 = chars[17];
            c18 = chars[18];
        } else {
            if (str.length() != 19) {
                throw new DateTimeParseException("illegal input " + str, str, 0);
            }
            c0 = str.charAt(0);
            c1 = str.charAt(1);
            char c = str.charAt(2);
            c3 = str.charAt(3);
            c4 = str.charAt(4);
            char c19 = str.charAt(5);
            c6 = str.charAt(6);
            c7 = str.charAt(7);
            c8 = str.charAt(8);
            c9 = str.charAt(9);
            c10 = str.charAt(10);
            c11 = str.charAt(11);
            c12 = str.charAt(12);
            c13 = str.charAt(13);
            c14 = str.charAt(14);
            c15 = str.charAt(15);
            c16 = str.charAt(16);
            c17 = str.charAt(17);
            c18 = str.charAt(18);
        }
        if (c4 == '-' && c7 == '-' && (c10 == ' ' || c10 == 'T') && c13 == ':' && c16 == ':') {
            y0 = c0;
            y1 = c1;
            y2 = var4_9;
            y3 = c3;
            m0 = var7_15;
            m1 = c6;
            d0 = c8;
            d1 = c9;
            h0 = c11;
            h1 = c12;
            i0 = c14;
            i1 = c15;
            s0 = c17;
            s1 = c18;
        } else if (c4 == '/' && c7 == '/' && (c10 == ' ' || c10 == 'T') && c13 == ':' && c16 == ':') {
            y0 = c0;
            y1 = c1;
            y2 = var4_9;
            y3 = c3;
            m0 = var7_15;
            m1 = c6;
            d0 = c8;
            d1 = c9;
            h0 = c11;
            h1 = c12;
            i0 = c14;
            i1 = c15;
            s0 = c17;
            s1 = c18;
        } else if (var4_9 == 47 && var7_15 == 47 && c10 == ' ' && c13 == ':' && c16 == ':') {
            d0 = c0;
            d1 = c1;
            m0 = c3;
            m1 = c4;
            y0 = c6;
            y1 = c7;
            y2 = c8;
            y3 = c9;
            h0 = c11;
            h1 = c12;
            i0 = c14;
            i1 = c15;
            s0 = c17;
            s1 = c18;
        } else if (var4_9 == 46 && var7_15 == 46 && c10 == ' ' && c13 == ':' && c16 == ':') {
            d0 = c0;
            d1 = c1;
            m0 = c3;
            m1 = c4;
            y0 = c6;
            y1 = c7;
            y2 = c8;
            y3 = c9;
            h0 = c11;
            h1 = c12;
            i0 = c14;
            i1 = c15;
            s0 = c17;
            s1 = c18;
        } else if (c1 == 32 && var7_15 == 32 && c10 == ' ' && c13 == ':' && c16 == ':') {
            d0 = 48;
            d1 = c0;
            int month22 = DateUtils.month((char)var4_9, c3, c4);
            if (month22 <= 0) {
                throw new DateTimeParseException("illegal input " + str, str, 0);
            }
            m0 = (char)(48 + month22 / 10);
            m1 = (char)(48 + month22 % 10);
            y0 = c6;
            y1 = c7;
            y2 = c8;
            y3 = c9;
            h0 = c11;
            h1 = c12;
            i0 = c14;
            i1 = c15;
            s0 = c17;
            s1 = c18;
        } else if (var4_9 == 32 && c6 == ' ' && c11 == 32 && c13 == ':' && c16 == ':') {
            d0 = c0;
            d1 = c1;
            month2 = DateUtils.month(c3, c4, (char)var7_15);
            if (month2 <= 0) {
                throw new DateTimeParseException("illegal input " + str, str, 0);
            }
            m0 = (char)(48 + month2 / 10);
            m1 = (char)(48 + month2 % 10);
            y0 = c7;
            y1 = c8;
            y2 = c9;
            y3 = c10;
            h0 = 48;
            h1 = c12;
            i0 = c14;
            i1 = c15;
            s0 = c17;
            s1 = c18;
        } else if (var4_9 == 32 && c6 == ' ' && c11 == 32 && c14 == 58 && c16 == ':') {
            d0 = c0;
            d1 = c1;
            month2 = DateUtils.month(c3, c4, (char)var7_15);
            if (month2 <= 0) {
                throw new DateTimeParseException("illegal input " + str, str, 0);
            }
            m0 = (char)(48 + month2 / 10);
            m1 = (char)(48 + month2 % 10);
            y0 = c7;
            y1 = c8;
            y2 = c9;
            y3 = c10;
            h0 = c12;
            h1 = c13;
            i0 = 48;
            i1 = c15;
            s0 = c17;
            s1 = c18;
        } else if (var4_9 == 32 && c6 == ' ' && c11 == 32 && c14 == 58 && c17 == 58) {
            d0 = c0;
            d1 = c1;
            month2 = DateUtils.month(c3, c4, (char)var7_15);
            if (month2 <= 0) {
                throw new DateTimeParseException("illegal input " + str, str, 0);
            }
            m0 = (char)(48 + month2 / 10);
            m1 = (char)(48 + month2 % 10);
            y0 = c7;
            y1 = c8;
            y2 = c9;
            y3 = c10;
            h0 = c12;
            h1 = c13;
            i0 = c15;
            i1 = c16;
            s0 = 48;
            s1 = c18;
        } else {
            throw new DateTimeParseException("illegal input " + str, str, 0);
        }
        if (y0 < 48 || y0 > 57 || y1 < 48 || y1 > 57 || y2 < 48 || y2 > 57 || y3 < 48 || y3 > 57) {
            throw new DateTimeParseException("illegal input " + str, str, 0);
        }
        int year = (y0 - 48) * 1000 + (y1 - 48) * 100 + (y2 - 48) * 10 + (y3 - 48);
        if (m0 >= '0' && m0 <= '9' && m1 >= '0' && m1 <= '9') {
            month = (m0 - 48) * 10 + (m1 - 48);
            if (month == 0 && year != 0 || month > 12) {
                throw new DateTimeParseException("illegal input " + str, str, 0);
            }
        } else {
            throw new DateTimeParseException("illegal input " + str, str, 0);
        }
        if (d0 >= 48 && d0 <= 57 && d1 >= 48 && d1 <= 57) {
            dom = (d0 - 48) * 10 + (d1 - 48);
            int max = 31;
            switch (month) {
                case 2: {
                    boolean leapYear = (year & 3) == 0 && (year % 100 != 0 || year % 400 == 0);
                    max = leapYear ? 29 : 28;
                    break;
                }
                case 4: 
                case 6: 
                case 9: 
                case 11: {
                    max = 30;
                }
            }
            if (dom == 0 && year != 0 || dom > max) {
                throw new DateTimeParseException("illegal input " + str, str, 0);
            }
        } else {
            throw new DateTimeParseException("illegal input " + str, str, 0);
        }
        if (h0 < 48 || h0 > 57 || h1 < '0' || h1 > '9') {
            throw new DateTimeParseException("illegal input " + str, str, 0);
        }
        int hour = (h0 - 48) * 10 + (h1 - 48);
        if (i0 < 48 || i0 > 57 || i1 < '0' || i1 > '9') {
            throw new DateTimeParseException("illegal input " + str, str, 0);
        }
        int minute = (i0 - 48) * 10 + (i1 - 48);
        if (s0 < 48 || s0 > 57 || s1 < '0' || s1 > '9') {
            throw new DateTimeParseException("illegal input " + str, str, 0);
        }
        int second = (s0 - 48) * 10 + (s1 - 48);
        if (year == 0 && month == 0 && dom == 0) {
            year = 1970;
            month = 1;
            dom = 1;
        }
        long epochDay = DateUtils.calcEpochDay(year, month, dom);
        long utcSeconds = epochDay * 86400L + (long)(hour * 3600) + (long)(minute * 60) + (long)second;
        if (zoneId == null) {
            zoneId = DEFAULT_ZONE_ID;
        }
        boolean shanghai = zoneId == SHANGHAI_ZONE_ID || zoneId.getRules() == SHANGHAI_ZONE_RULES;
        long SECONDS_1991_09_15_02 = 684900000L;
        if (shanghai && utcSeconds >= SECONDS_1991_09_15_02) {
            zoneOffsetTotalSeconds = 28800;
        } else if (zoneId == ZoneOffset.UTC || "UTC".equals(zoneId.getId())) {
            zoneOffsetTotalSeconds = 0;
        } else {
            LocalDate localDate = LocalDate.of(year, month, dom);
            LocalTime localTime = LocalTime.of(hour, minute, second, 0);
            LocalDateTime ldt = LocalDateTime.of(localDate, localTime);
            ZoneOffset offset = zoneId.getRules().getOffset(ldt);
            zoneOffsetTotalSeconds = offset.getTotalSeconds();
        }
        return (utcSeconds - (long)zoneOffsetTotalSeconds) * 1000L;
    }

    public static long parseMillis19(byte[] bytes, int off, ZoneId zoneId) {
        int zoneOffsetTotalSeconds;
        int dom;
        int month;
        int month2;
        char s1;
        int s0;
        char i1;
        int i0;
        char h1;
        int h0;
        int d1;
        int d0;
        int m1;
        char m0;
        int y3;
        int y2;
        int y1;
        int y0;
        if (bytes == null) {
            throw new NullPointerException();
        }
        int c0 = bytes[off];
        int c1 = bytes[off + 1];
        char c = bytes[off + 2];
        char c3 = (char)bytes[off + 3];
        char c2 = bytes[off + 4];
        char c4 = bytes[off + 5];
        int c6 = bytes[off + 6];
        int c7 = bytes[off + 7];
        int c8 = bytes[off + 8];
        int c9 = bytes[off + 9];
        char c10 = (char)bytes[off + 10];
        int c11 = bytes[off + 11];
        char c12 = (char)bytes[off + 12];
        char c13 = (char)bytes[off + 13];
        int c14 = bytes[off + 14];
        char c15 = (char)bytes[off + 15];
        char c16 = (char)bytes[off + 16];
        int c17 = bytes[off + 17];
        char c18 = (char)bytes[off + 18];
        if (c2 == '-' && c7 == 45 && (c10 == ' ' || c10 == 'T') && c13 == ':' && c16 == ':') {
            y0 = c0;
            y1 = c1;
            y2 = c;
            y3 = c3;
            m0 = c4;
            m1 = c6;
            d0 = c8;
            d1 = c9;
            h0 = c11;
            h1 = c12;
            i0 = c14;
            i1 = c15;
            s0 = c17;
            s1 = c18;
        } else if (c2 == '/' && c7 == 47 && (c10 == ' ' || c10 == 'T') && c13 == ':' && c16 == ':') {
            y0 = c0;
            y1 = c1;
            y2 = c;
            y3 = c3;
            m0 = c4;
            m1 = c6;
            d0 = c8;
            d1 = c9;
            h0 = c11;
            h1 = c12;
            i0 = c14;
            i1 = c15;
            s0 = c17;
            s1 = c18;
        } else if ((c == '/' && c4 == '/' || c == '-' && c4 == '-' || c == '.' && c4 == '.') && c10 == ' ' && c13 == ':' && c16 == ':') {
            d0 = c0;
            d1 = c1;
            m0 = c3;
            m1 = c2;
            y0 = c6;
            y1 = c7;
            y2 = c8;
            y3 = c9;
            h0 = c11;
            h1 = c12;
            i0 = c14;
            i1 = c15;
            s0 = c17;
            s1 = c18;
        } else if (c1 == 32 && c4 == ' ' && c10 == ' ' && c13 == ':' && c16 == ':') {
            d0 = 48;
            d1 = c0;
            int month22 = DateUtils.month(c, c3, c2);
            if (month22 <= 0) {
                String str = new String(bytes, off, 19);
                throw new DateTimeParseException("illegal input " + str, str, 0);
            }
            m0 = (char)(48 + month22 / 10);
            m1 = (char)(48 + month22 % 10);
            y0 = c6;
            y1 = c7;
            y2 = c8;
            y3 = c9;
            h0 = c11;
            h1 = c12;
            i0 = c14;
            i1 = c15;
            s0 = c17;
            s1 = c18;
        } else if (c == ' ' && c6 == 32 && c11 == 32 && c13 == ':' && c16 == ':') {
            d0 = c0;
            d1 = c1;
            month2 = DateUtils.month(c3, c2, c4);
            if (month2 <= 0) {
                String str = new String(bytes, off, 19);
                throw new DateTimeParseException("illegal input " + str, str, 0);
            }
            m0 = (char)(48 + month2 / 10);
            m1 = (char)(48 + month2 % 10);
            y0 = c7;
            y1 = c8;
            y2 = c9;
            y3 = c10;
            h0 = 48;
            h1 = c12;
            i0 = c14;
            i1 = c15;
            s0 = c17;
            s1 = c18;
        } else if (c == ' ' && c6 == 32 && c11 == 32 && c14 == 58 && c16 == ':') {
            d0 = c0;
            d1 = c1;
            month2 = DateUtils.month(c3, c2, c4);
            if (month2 <= 0) {
                String str = new String(bytes, off, 19);
                throw new DateTimeParseException("illegal input " + str, str, 0);
            }
            m0 = (char)(48 + month2 / 10);
            m1 = (char)(48 + month2 % 10);
            y0 = c7;
            y1 = c8;
            y2 = c9;
            y3 = c10;
            h0 = c12;
            h1 = c13;
            i0 = 48;
            i1 = c15;
            s0 = c17;
            s1 = c18;
        } else if (c == ' ' && c6 == 32 && c11 == 32 && c14 == 58 && c17 == 58) {
            d0 = c0;
            d1 = c1;
            month2 = DateUtils.month(c3, c2, c4);
            if (month2 <= 0) {
                String str = new String(bytes, off, 19);
                throw new DateTimeParseException("illegal input " + str, str, 0);
            }
            m0 = (char)(48 + month2 / 10);
            m1 = (char)(48 + month2 % 10);
            y0 = c7;
            y1 = c8;
            y2 = c9;
            y3 = c10;
            h0 = c12;
            h1 = c13;
            i0 = c15;
            i1 = c16;
            s0 = 48;
            s1 = c18;
        } else {
            String str = new String(bytes, off, 19);
            throw new DateTimeParseException("illegal input " + str, str, 0);
        }
        if (y0 < 48 || y0 > 57 || y1 < 48 || y1 > 57 || y2 < 48 || y2 > 57 || y3 < 48 || y3 > 57) {
            String str = new String(bytes, off, 19);
            throw new DateTimeParseException("illegal input " + str, str, 0);
        }
        int year = (y0 - 48) * 1000 + (y1 - 48) * 100 + (y2 - 48) * 10 + (y3 - 48);
        if (m0 >= '0' && m0 <= '9' && m1 >= 48 && m1 <= 57) {
            month = (m0 - 48) * 10 + (m1 - 48);
            if (month == 0 && year != 0 || month > 12) {
                String str = new String(bytes, off, 19);
                throw new DateTimeParseException("illegal input " + str, str, 0);
            }
        } else {
            String str = new String(bytes, off, 19);
            throw new DateTimeParseException("illegal input " + str, str, 0);
        }
        if (d0 >= 48 && d0 <= 57 && d1 >= 48 && d1 <= 57) {
            dom = (d0 - 48) * 10 + (d1 - 48);
            int max = 31;
            switch (month) {
                case 2: {
                    boolean leapYear = (year & 3) == 0 && (year % 100 != 0 || year % 400 == 0);
                    max = leapYear ? 29 : 28;
                    break;
                }
                case 4: 
                case 6: 
                case 9: 
                case 11: {
                    max = 30;
                }
            }
            if (dom == 0 && year != 0 || dom > max) {
                String str = new String(bytes, off, 19);
                throw new DateTimeParseException("illegal input " + str, str, 0);
            }
        } else {
            String str = new String(bytes, off, 19);
            throw new DateTimeParseException("illegal input " + str, str, 0);
        }
        if (h0 < 48 || h0 > 57 || h1 < '0' || h1 > '9') {
            String str = new String(bytes, off, 19);
            throw new DateTimeParseException("illegal input " + str, str, 0);
        }
        int hour = (h0 - 48) * 10 + (h1 - 48);
        if (i0 < 48 || i0 > 57 || i1 < '0' || i1 > '9') {
            String str = new String(bytes, off, 19);
            throw new DateTimeParseException("illegal input " + str, str, 0);
        }
        int minute = (i0 - 48) * 10 + (i1 - 48);
        if (s0 < 48 || s0 > 57 || s1 < '0' || s1 > '9') {
            String str = new String(bytes, off, 19);
            throw new DateTimeParseException("illegal input " + str, str, 0);
        }
        int second = (s0 - 48) * 10 + (s1 - 48);
        if (year == 0 && month == 0 && dom == 0) {
            year = 1970;
            month = 1;
            dom = 1;
        }
        long epochDay = DateUtils.calcEpochDay(year, month, dom);
        long utcSeconds = epochDay * 86400L + (long)(hour * 3600) + (long)(minute * 60) + (long)second;
        if (zoneId == null) {
            zoneId = DEFAULT_ZONE_ID;
        }
        boolean shanghai = zoneId == SHANGHAI_ZONE_ID || zoneId.getRules() == SHANGHAI_ZONE_RULES;
        long SECONDS_1991_09_15_02 = 684900000L;
        if (shanghai && utcSeconds >= SECONDS_1991_09_15_02) {
            zoneOffsetTotalSeconds = 28800;
        } else if (zoneId == ZoneOffset.UTC || "UTC".equals(zoneId.getId())) {
            zoneOffsetTotalSeconds = 0;
        } else {
            LocalDate localDate = LocalDate.of(year, month, dom);
            LocalTime localTime = LocalTime.of(hour, minute, second, 0);
            LocalDateTime ldt = LocalDateTime.of(localDate, localTime);
            ZoneOffset offset = zoneId.getRules().getOffset(ldt);
            zoneOffsetTotalSeconds = offset.getTotalSeconds();
        }
        return (utcSeconds - (long)zoneOffsetTotalSeconds) * 1000L;
    }

    public static long parseMillis19(char[] bytes, int off, ZoneId zoneId) {
        int zoneOffsetTotalSeconds;
        int dom;
        int month;
        int month2;
        char s1;
        int s0;
        int i1;
        int i0;
        int h1;
        int h0;
        char d1;
        char d0;
        char m1;
        char m0;
        char y3;
        char y2;
        char y1;
        char y0;
        if (bytes == null) {
            throw new NullPointerException();
        }
        char c0 = bytes[off];
        char c1 = bytes[off + 1];
        char c2 = bytes[off + 2];
        char c3 = bytes[off + 3];
        char c4 = bytes[off + 4];
        char c5 = bytes[off + 5];
        char c6 = bytes[off + 6];
        char c7 = bytes[off + 7];
        char c8 = bytes[off + 8];
        char c9 = bytes[off + 9];
        char c10 = bytes[off + 10];
        int c11 = bytes[off + 11];
        int c12 = bytes[off + 12];
        int c13 = bytes[off + 13];
        int c14 = bytes[off + 14];
        int c15 = bytes[off + 15];
        int c16 = bytes[off + 16];
        int c17 = bytes[off + 17];
        char c18 = bytes[off + 18];
        if (c4 == '-' && c7 == '-' && (c10 == ' ' || c10 == 'T') && c13 == 58 && c16 == 58) {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = c5;
            m1 = c6;
            d0 = c8;
            d1 = c9;
            h0 = c11;
            h1 = c12;
            i0 = c14;
            i1 = c15;
            s0 = c17;
            s1 = c18;
        } else if (c4 == '/' && c7 == '/' && (c10 == ' ' || c10 == 'T') && c13 == 58 && c16 == 58) {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = c5;
            m1 = c6;
            d0 = c8;
            d1 = c9;
            h0 = c11;
            h1 = c12;
            i0 = c14;
            i1 = c15;
            s0 = c17;
            s1 = c18;
        } else if ((c2 == '/' && c5 == '/' || c2 == '-' && c5 == '-' || c2 == '.' && c5 == '.') && c10 == ' ' && c13 == 58 && c16 == 58) {
            d0 = c0;
            d1 = c1;
            m0 = c3;
            m1 = c4;
            y0 = c6;
            y1 = c7;
            y2 = c8;
            y3 = c9;
            h0 = c11;
            h1 = c12;
            i0 = c14;
            i1 = c15;
            s0 = c17;
            s1 = c18;
        } else if (c1 == ' ' && c5 == ' ' && c10 == ' ' && c13 == 58 && c16 == 58) {
            d0 = '0';
            d1 = c0;
            month2 = DateUtils.month(c2, c3, c4);
            if (month2 <= 0) {
                String str = new String(bytes, off, 19);
                throw new DateTimeParseException("illegal input " + str, str, 0);
            }
            m0 = (char)(48 + month2 / 10);
            m1 = (char)(48 + month2 % 10);
            y0 = c6;
            y1 = c7;
            y2 = c8;
            y3 = c9;
            h0 = c11;
            h1 = c12;
            i0 = c14;
            i1 = c15;
            s0 = c17;
            s1 = c18;
        } else if (c2 == ' ' && c6 == ' ' && c11 == 32 && c13 == 58 && c16 == 58) {
            d0 = c0;
            d1 = c1;
            month2 = DateUtils.month(c3, c4, c5);
            if (month2 <= 0) {
                String str = new String(bytes, off, 19);
                throw new DateTimeParseException("illegal input " + str, str, 0);
            }
            m0 = (char)(48 + month2 / 10);
            m1 = (char)(48 + month2 % 10);
            y0 = c7;
            y1 = c8;
            y2 = c9;
            y3 = c10;
            h0 = 48;
            h1 = c12;
            i0 = c14;
            i1 = c15;
            s0 = c17;
            s1 = c18;
        } else if (c2 == ' ' && c6 == ' ' && c11 == 32 && c14 == 58 && c16 == 58) {
            d0 = c0;
            d1 = c1;
            month2 = DateUtils.month(c3, c4, c5);
            if (month2 <= 0) {
                String str = new String(bytes, off, 19);
                throw new DateTimeParseException("illegal input " + str, str, 0);
            }
            m0 = (char)(48 + month2 / 10);
            m1 = (char)(48 + month2 % 10);
            y0 = c7;
            y1 = c8;
            y2 = c9;
            y3 = c10;
            h0 = c12;
            h1 = c13;
            i0 = 48;
            i1 = c15;
            s0 = c17;
            s1 = c18;
        } else if (c2 == ' ' && c6 == ' ' && c11 == 32 && c14 == 58 && c17 == 58) {
            d0 = c0;
            d1 = c1;
            month2 = DateUtils.month(c3, c4, c5);
            if (month2 <= 0) {
                String str = new String(bytes, off, 19);
                throw new DateTimeParseException("illegal input " + str, str, 0);
            }
            m0 = (char)(48 + month2 / 10);
            m1 = (char)(48 + month2 % 10);
            y0 = c7;
            y1 = c8;
            y2 = c9;
            y3 = c10;
            h0 = c12;
            h1 = c13;
            i0 = c15;
            i1 = c16;
            s0 = 48;
            s1 = c18;
        } else {
            String str = new String(bytes, off, 19);
            throw new DateTimeParseException("illegal input " + str, str, 0);
        }
        if (y0 < '0' || y0 > '9' || y1 < '0' || y1 > '9' || y2 < '0' || y2 > '9' || y3 < '0' || y3 > '9') {
            String str = new String(bytes, off, 19);
            throw new DateTimeParseException("illegal input " + str, str, 0);
        }
        int year = (y0 - 48) * 1000 + (y1 - 48) * 100 + (y2 - 48) * 10 + (y3 - 48);
        if (m0 >= '0' && m0 <= '9' && m1 >= '0' && m1 <= '9') {
            month = (m0 - 48) * 10 + (m1 - 48);
            if (month == 0 && year != 0 || month > 12) {
                String str = new String(bytes, off, 19);
                throw new DateTimeParseException("illegal input " + str, str, 0);
            }
        } else {
            String str = new String(bytes, off, 19);
            throw new DateTimeParseException("illegal input " + str, str, 0);
        }
        if (d0 >= '0' && d0 <= '9' && d1 >= '0' && d1 <= '9') {
            dom = (d0 - 48) * 10 + (d1 - 48);
            int max = 31;
            switch (month) {
                case 2: {
                    boolean leapYear = (year & 3) == 0 && (year % 100 != 0 || year % 400 == 0);
                    max = leapYear ? 29 : 28;
                    break;
                }
                case 4: 
                case 6: 
                case 9: 
                case 11: {
                    max = 30;
                }
            }
            if (dom == 0 && year != 0 || dom > max) {
                String str = new String(bytes, off, 19);
                throw new DateTimeParseException("illegal input " + str, str, 0);
            }
        } else {
            String str = new String(bytes, off, 19);
            throw new DateTimeParseException("illegal input " + str, str, 0);
        }
        if (h0 < 48 || h0 > 57 || h1 < 48 || h1 > 57) {
            String str = new String(bytes, off, 19);
            throw new DateTimeParseException("illegal input " + str, str, 0);
        }
        int hour = (h0 - 48) * 10 + (h1 - 48);
        if (i0 < 48 || i0 > 57 || i1 < 48 || i1 > 57) {
            String str = new String(bytes, off, 19);
            throw new DateTimeParseException("illegal input " + str, str, 0);
        }
        int minute = (i0 - 48) * 10 + (i1 - 48);
        if (s0 < 48 || s0 > 57 || s1 < '0' || s1 > '9') {
            String str = new String(bytes, off, 19);
            throw new DateTimeParseException("illegal input " + str, str, 0);
        }
        int second = (s0 - 48) * 10 + (s1 - 48);
        if (year == 0 && month == 0 && dom == 0) {
            year = 1970;
            month = 1;
            dom = 1;
        }
        long epochDay = DateUtils.calcEpochDay(year, month, dom);
        long utcSeconds = epochDay * 86400L + (long)(hour * 3600) + (long)(minute * 60) + (long)second;
        if (zoneId == null) {
            zoneId = DEFAULT_ZONE_ID;
        }
        boolean shanghai = zoneId == SHANGHAI_ZONE_ID || zoneId.getRules() == SHANGHAI_ZONE_RULES;
        long SECONDS_1991_09_15_02 = 684900000L;
        if (shanghai && utcSeconds >= SECONDS_1991_09_15_02) {
            zoneOffsetTotalSeconds = 28800;
        } else if (zoneId == ZoneOffset.UTC || "UTC".equals(zoneId.getId())) {
            zoneOffsetTotalSeconds = 0;
        } else {
            LocalDate localDate = LocalDate.of(year, month, dom);
            LocalTime localTime = LocalTime.of(hour, minute, second, 0);
            LocalDateTime ldt = LocalDateTime.of(localDate, localTime);
            ZoneOffset offset = zoneId.getRules().getOffset(ldt);
            zoneOffsetTotalSeconds = offset.getTotalSeconds();
        }
        return (utcSeconds - (long)zoneOffsetTotalSeconds) * 1000L;
    }

    public static LocalDateTime localDateTime(char y0, char y1, char y2, char y3, char m0, char m1, char d0, char d1, char h0, char h1, char i0, char i1, char s0, char s1) {
        if (y0 < '0' || y0 > '9' || y1 < '0' || y1 > '9' || y2 < '0' || y2 > '9' || y3 < '0' || y3 > '9') {
            return null;
        }
        int year = (y0 - 48) * 1000 + (y1 - 48) * 100 + (y2 - 48) * 10 + (y3 - 48);
        if (m0 < '0' || m0 > '9' || m1 < '0' || m1 > '9') {
            return null;
        }
        int month = (m0 - 48) * 10 + (m1 - 48);
        if (d0 < '0' || d0 > '9' || d1 < '0' || d1 > '9') {
            return null;
        }
        int dom = (d0 - 48) * 10 + (d1 - 48);
        if (h0 < '0' || h0 > '9' || h1 < '0' || h1 > '9') {
            return null;
        }
        int hour = (h0 - 48) * 10 + (h1 - 48);
        if (i0 < '0' || i0 > '9' || i1 < '0' || i1 > '9') {
            return null;
        }
        int minute = (i0 - 48) * 10 + (i1 - 48);
        if (s0 < '0' || s0 > '9' || s1 < '0' || s1 > '9') {
            return null;
        }
        int second = (s0 - 48) * 10 + (s1 - 48);
        if (year == 0 && month == 0 && dom == 0 && hour == 0 && minute == 0 && second == 0) {
            return null;
        }
        if (hour > 24 || minute > 60 || second > 60) {
            return null;
        }
        return LocalDateTime.of(year, month, dom, hour, minute, second, 0);
    }

    public static LocalDateTime localDateTime(char y0, char y1, char y2, char y3, char m0, char m1, char d0, char d1, char h0, char h1, char i0, char i1, char s0, char s1, char S0, char S1, char S2, char S3, char S4, char S5, char S6, char S7, char S8) {
        if (y0 < '0' || y0 > '9' || y1 < '0' || y1 > '9' || y2 < '0' || y2 > '9' || y3 < '0' || y3 > '9') {
            return null;
        }
        int year = (y0 - 48) * 1000 + (y1 - 48) * 100 + (y2 - 48) * 10 + (y3 - 48);
        if (m0 < '0' || m0 > '9' || m1 < '0' || m1 > '9') {
            return null;
        }
        int month = (m0 - 48) * 10 + (m1 - 48);
        if (d0 < '0' || d0 > '9' || d1 < '0' || d1 > '9') {
            return null;
        }
        int dom = (d0 - 48) * 10 + (d1 - 48);
        if (h0 < '0' || h0 > '9' || h1 < '0' || h1 > '9') {
            return null;
        }
        int hour = (h0 - 48) * 10 + (h1 - 48);
        if (i0 < '0' || i0 > '9' || i1 < '0' || i1 > '9') {
            return null;
        }
        int minute = (i0 - 48) * 10 + (i1 - 48);
        if (s0 < '0' || s0 > '9' || s1 < '0' || s1 > '9') {
            return null;
        }
        int second = (s0 - 48) * 10 + (s1 - 48);
        if (S0 < '0' || S0 > '9' || S1 < '0' || S1 > '9' || S2 < '0' || S2 > '9' || S3 < '0' || S3 > '9' || S4 < '0' || S4 > '9' || S5 < '0' || S5 > '9' || S6 < '0' || S6 > '9' || S7 < '0' || S7 > '9' || S8 < '0' || S8 > '9') {
            return null;
        }
        int nanos = (S0 - 48) * 100000000 + (S1 - 48) * 10000000 + (S2 - 48) * 1000000 + (S3 - 48) * 100000 + (S4 - 48) * 10000 + (S5 - 48) * 1000 + (S6 - 48) * 100 + (S7 - 48) * 10 + (S8 - 48);
        return LocalDateTime.of(year, month, dom, hour, minute, second, nanos);
    }

    public static long millis(LocalDateTime ldt) {
        return DateUtils.millis(null, ldt.getYear(), ldt.getMonthValue(), ldt.getDayOfMonth(), ldt.getHour(), ldt.getMinute(), ldt.getSecond(), ldt.getNano());
    }

    public static long millis(LocalDateTime ldt, ZoneId zoneId) {
        return DateUtils.millis(zoneId, ldt.getYear(), ldt.getMonthValue(), ldt.getDayOfMonth(), ldt.getHour(), ldt.getMinute(), ldt.getSecond(), ldt.getNano());
    }

    public static long millis(ZoneId zoneId, int year, int month, int dom, int hour, int minute, int second, int nanoOfSecond) {
        int zoneOffsetTotalSeconds;
        if (zoneId == null) {
            zoneId = DEFAULT_ZONE_ID;
        }
        long epochDay = DateUtils.calcEpochDay(year, month, dom);
        long utcSeconds = epochDay * 86400L + (long)(hour * 3600) + (long)(minute * 60) + (long)second;
        boolean shanghai = zoneId == SHANGHAI_ZONE_ID || zoneId.getRules() == SHANGHAI_ZONE_RULES;
        long SECONDS_1991_09_15_02 = 684900000L;
        if (shanghai && utcSeconds >= SECONDS_1991_09_15_02) {
            zoneOffsetTotalSeconds = 28800;
        } else if (zoneId == ZoneOffset.UTC || "UTC".equals(zoneId.getId())) {
            zoneOffsetTotalSeconds = 0;
        } else {
            LocalDate localDate = LocalDate.of(year, month, dom);
            LocalTime localTime = LocalTime.of(hour, minute, second, nanoOfSecond);
            LocalDateTime ldt = LocalDateTime.of(localDate, localTime);
            ZoneOffset offset = zoneId.getRules().getOffset(ldt);
            zoneOffsetTotalSeconds = offset.getTotalSeconds();
        }
        long millis = (utcSeconds - (long)zoneOffsetTotalSeconds) * 1000L;
        if (nanoOfSecond != 0) {
            millis += (long)(nanoOfSecond / 1000000);
        }
        return millis;
    }

    public static long utcSeconds(int year, int month, int dom, int hour, int minute, int second) {
        long epochDay = DateUtils.calcEpochDay(year, month, dom);
        return epochDay * 86400L + (long)(hour * 3600) + (long)(minute * 60) + (long)second;
    }

    public static String formatYMDHMS19(Date date) {
        return DateUtils.formatYMDHMS19(date, DEFAULT_ZONE_ID);
    }

    public static String formatYMDHMS19(Date date, ZoneId zoneId) {
        long yearEst;
        long doyEst;
        int offsetTotalSeconds;
        boolean shanghai;
        if (date == null) {
            return null;
        }
        long timeMillis = date.getTime();
        if (zoneId == null) {
            zoneId = DEFAULT_ZONE_ID;
        }
        long SECONDS_PER_DAY = 86400L;
        long epochSecond = Math.floorDiv(timeMillis, 1000L);
        long SECONDS_1991_09_15_02 = 684900000L;
        boolean bl = shanghai = zoneId == SHANGHAI_ZONE_ID || zoneId.getRules() == SHANGHAI_ZONE_RULES;
        if (shanghai && epochSecond > 684900000L) {
            offsetTotalSeconds = 28800;
        } else {
            Instant instant = Instant.ofEpochMilli(timeMillis);
            offsetTotalSeconds = zoneId.getRules().getOffset(instant).getTotalSeconds();
        }
        long localSecond = epochSecond + (long)offsetTotalSeconds;
        long localEpochDay = Math.floorDiv(localSecond, 86400L);
        int secsOfDay = (int)Math.floorMod(localSecond, 86400L);
        int DAYS_PER_CYCLE = 146097;
        long DAYS_0000_TO_1970 = 719528L;
        long zeroDay = localEpochDay + 719528L;
        long adjust = 0L;
        if ((zeroDay -= 60L) < 0L) {
            long adjustCycles = (zeroDay + 1L) / 146097L - 1L;
            adjust = adjustCycles * 400L;
            zeroDay += -adjustCycles * 146097L;
        }
        if ((doyEst = zeroDay - (365L * (yearEst = (400L * zeroDay + 591L) / 146097L) + yearEst / 4L - yearEst / 100L + yearEst / 400L)) < 0L) {
            doyEst = zeroDay - (365L * --yearEst + yearEst / 4L - yearEst / 100L + yearEst / 400L);
        }
        yearEst += adjust;
        int marchDoy0 = (int)doyEst;
        int marchMonth0 = (marchDoy0 * 5 + 2) / 153;
        int month = (marchMonth0 + 2) % 12 + 1;
        int dayOfMonth = marchDoy0 - (marchMonth0 * 306 + 5) / 10 + 1;
        if ((yearEst += (long)(marchMonth0 / 10)) < -999999999L || yearEst > 999999999L) {
            throw new DateTimeException("Invalid year " + yearEst);
        }
        int year = (int)yearEst;
        int MINUTES_PER_HOUR = 60;
        int SECONDS_PER_MINUTE = 60;
        int SECONDS_PER_HOUR = 3600;
        long secondOfDay = secsOfDay;
        if (secondOfDay < 0L || secondOfDay > 86399L) {
            throw new DateTimeException("Invalid secondOfDay " + secondOfDay);
        }
        int hours = (int)(secondOfDay / 3600L);
        int minutes = (int)((secondOfDay -= (long)(hours * 3600)) / 60L);
        int hour = hours;
        int minute = minutes;
        int second = (int)(secondOfDay -= (long)(minutes * 60));
        if (JDKUtils.STRING_CREATOR_JDK11 != null) {
            byte[] bytes = new byte[19];
            IOUtils.writeLocalDate(bytes, 0, year, month, dayOfMonth);
            bytes[10] = 32;
            IOUtils.writeLocalTime(bytes, 11, hour, minute, second);
            return JDKUtils.STRING_CREATOR_JDK11.apply(bytes, JDKUtils.LATIN1);
        }
        char[] chars = new char[19];
        IOUtils.writeLocalDate(chars, 0, year, month, dayOfMonth);
        chars[10] = 32;
        IOUtils.writeLocalTime(chars, 11, hour, minute, second);
        if (JDKUtils.STRING_CREATOR_JDK8 != null) {
            return JDKUtils.STRING_CREATOR_JDK8.apply(chars, Boolean.TRUE);
        }
        return new String(chars);
    }

    public static String formatYMD8(Date date) {
        if (date == null) {
            return null;
        }
        return DateUtils.formatYMD8(date.getTime(), DEFAULT_ZONE_ID);
    }

    public static String formatYMD8(long timeMillis, ZoneId zoneId) {
        String str;
        long yearEst;
        long doyEst;
        String str2;
        int offsetTotalSeconds;
        long SECONDS_PER_DAY = 86400L;
        long epochSecond = Math.floorDiv(timeMillis, 1000L);
        if (zoneId == null) {
            zoneId = DEFAULT_ZONE_ID;
        }
        if (zoneId == SHANGHAI_ZONE_ID || zoneId.getRules() == SHANGHAI_ZONE_RULES) {
            offsetTotalSeconds = DateUtils.getShanghaiZoneOffsetTotalSeconds(epochSecond);
        } else {
            Instant instant = Instant.ofEpochMilli(timeMillis);
            offsetTotalSeconds = zoneId.getRules().getOffset(instant).getTotalSeconds();
        }
        long localSecond = epochSecond + (long)offsetTotalSeconds;
        long localEpochDay = Math.floorDiv(localSecond, 86400L);
        int off = (int)(localEpochDay - (long)LOCAL_EPOCH_DAY + 128L);
        String[] cache = CacheDate8.CACHE;
        if (off >= 0 && off < cache.length && (str2 = cache[off]) != null) {
            return str2;
        }
        int DAYS_PER_CYCLE = 146097;
        long DAYS_0000_TO_1970 = 719528L;
        long zeroDay = localEpochDay + 719528L;
        long adjust = 0L;
        if ((zeroDay -= 60L) < 0L) {
            long adjustCycles = (zeroDay + 1L) / 146097L - 1L;
            adjust = adjustCycles * 400L;
            zeroDay += -adjustCycles * 146097L;
        }
        if ((doyEst = zeroDay - (365L * (yearEst = (400L * zeroDay + 591L) / 146097L) + yearEst / 4L - yearEst / 100L + yearEst / 400L)) < 0L) {
            doyEst = zeroDay - (365L * --yearEst + yearEst / 4L - yearEst / 100L + yearEst / 400L);
        }
        yearEst += adjust;
        int marchDoy0 = (int)doyEst;
        int marchMonth0 = (marchDoy0 * 5 + 2) / 153;
        int month = (marchMonth0 + 2) % 12 + 1;
        int dayOfMonth = marchDoy0 - (marchMonth0 * 306 + 5) / 10 + 1;
        if ((yearEst += (long)(marchMonth0 / 10)) < -999999999L || yearEst > 999999999L) {
            throw new DateTimeException("Invalid year " + yearEst);
        }
        int year = (int)yearEst;
        int y01 = year / 100;
        int y23 = year - y01 * 100;
        if (JDKUtils.STRING_CREATOR_JDK11 != null) {
            byte[] bytes = new byte[8];
            IOUtils.writeDigitPair(bytes, 0, y01);
            IOUtils.writeDigitPair(bytes, 2, y23);
            IOUtils.writeDigitPair(bytes, 4, month);
            IOUtils.writeDigitPair(bytes, 6, dayOfMonth);
            str = JDKUtils.STRING_CREATOR_JDK11.apply(bytes, JDKUtils.LATIN1);
        } else {
            char[] chars = new char[8];
            IOUtils.writeDigitPair(chars, 0, y01);
            IOUtils.writeDigitPair(chars, 2, y23);
            IOUtils.writeDigitPair(chars, 4, month);
            IOUtils.writeDigitPair(chars, 6, dayOfMonth);
            str = JDKUtils.STRING_CREATOR_JDK8 != null ? JDKUtils.STRING_CREATOR_JDK8.apply(chars, Boolean.TRUE) : new String(chars);
        }
        if (off >= 0 && off < cache.length) {
            cache[off] = str;
        }
        return str;
    }

    public static String formatYMD10(int year, int month, int dayOfMonth) {
        if (JDKUtils.STRING_CREATOR_JDK11 != null) {
            byte[] bytes = new byte[10];
            IOUtils.writeLocalDate(bytes, 0, year, month, dayOfMonth);
            return JDKUtils.STRING_CREATOR_JDK11.apply(bytes, JDKUtils.LATIN1);
        }
        char[] chars = new char[10];
        IOUtils.writeLocalDate(chars, 0, year, month, dayOfMonth);
        if (JDKUtils.STRING_CREATOR_JDK8 != null) {
            return JDKUtils.STRING_CREATOR_JDK8.apply(chars, Boolean.TRUE);
        }
        return new String(chars);
    }

    public static String formatYMD10(LocalDate date) {
        if (date == null) {
            return null;
        }
        return DateUtils.formatYMD10(date.getYear(), date.getMonthValue(), date.getDayOfMonth());
    }

    public static String formatYMD10(Date date) {
        if (date == null) {
            return null;
        }
        return DateUtils.formatYMD10(date.getTime(), DEFAULT_ZONE_ID);
    }

    public static String formatYMD8(LocalDate date) {
        String str;
        if (date == null) {
            return null;
        }
        int year = date.getYear();
        int month = date.getMonthValue();
        int dayOfMonth = date.getDayOfMonth();
        int y01 = year / 100;
        int y23 = year - y01 * 100;
        if (JDKUtils.STRING_CREATOR_JDK11 != null) {
            byte[] bytes = new byte[8];
            IOUtils.writeDigitPair(bytes, 0, y01);
            IOUtils.writeDigitPair(bytes, 2, y23);
            IOUtils.writeDigitPair(bytes, 4, month);
            IOUtils.writeDigitPair(bytes, 6, dayOfMonth);
            str = JDKUtils.STRING_CREATOR_JDK11.apply(bytes, JDKUtils.LATIN1);
        } else {
            char[] chars = new char[8];
            IOUtils.writeDigitPair(chars, 0, y01);
            IOUtils.writeDigitPair(chars, 2, y23);
            IOUtils.writeDigitPair(chars, 4, month);
            IOUtils.writeDigitPair(chars, 6, dayOfMonth);
            str = JDKUtils.STRING_CREATOR_JDK8 != null ? JDKUtils.STRING_CREATOR_JDK8.apply(chars, Boolean.TRUE) : new String(chars);
        }
        return str;
    }

    public static String formatYMD10(long timeMillis, ZoneId zoneId) {
        String str;
        long yearEst;
        long doyEst;
        String str2;
        int offsetTotalSeconds;
        if (zoneId == null) {
            zoneId = DEFAULT_ZONE_ID;
        }
        long SECONDS_PER_DAY = 86400L;
        long epochSecond = Math.floorDiv(timeMillis, 1000L);
        if (zoneId == SHANGHAI_ZONE_ID || zoneId.getRules() == SHANGHAI_ZONE_RULES) {
            offsetTotalSeconds = DateUtils.getShanghaiZoneOffsetTotalSeconds(epochSecond);
        } else {
            Instant instant = Instant.ofEpochMilli(timeMillis);
            offsetTotalSeconds = zoneId.getRules().getOffset(instant).getTotalSeconds();
        }
        long localSecond = epochSecond + (long)offsetTotalSeconds;
        long localEpochDay = Math.floorDiv(localSecond, 86400L);
        int off = (int)(localEpochDay - (long)LOCAL_EPOCH_DAY + 128L);
        String[] cache = CacheDate10.CACHE;
        if (off >= 0 && off < cache.length && (str2 = cache[off]) != null) {
            return str2;
        }
        int DAYS_PER_CYCLE = 146097;
        long DAYS_0000_TO_1970 = 719528L;
        long zeroDay = localEpochDay + 719528L;
        long adjust = 0L;
        if ((zeroDay -= 60L) < 0L) {
            long adjustCycles = (zeroDay + 1L) / 146097L - 1L;
            adjust = adjustCycles * 400L;
            zeroDay += -adjustCycles * 146097L;
        }
        if ((doyEst = zeroDay - (365L * (yearEst = (400L * zeroDay + 591L) / 146097L) + yearEst / 4L - yearEst / 100L + yearEst / 400L)) < 0L) {
            doyEst = zeroDay - (365L * --yearEst + yearEst / 4L - yearEst / 100L + yearEst / 400L);
        }
        yearEst += adjust;
        int marchDoy0 = (int)doyEst;
        int marchMonth0 = (marchDoy0 * 5 + 2) / 153;
        int month = (marchMonth0 + 2) % 12 + 1;
        int dayOfMonth = marchDoy0 - (marchMonth0 * 306 + 5) / 10 + 1;
        if ((yearEst += (long)(marchMonth0 / 10)) < -999999999L || yearEst > 999999999L) {
            throw new DateTimeException("Invalid year " + yearEst);
        }
        int year = (int)yearEst;
        if (JDKUtils.STRING_CREATOR_JDK11 != null) {
            byte[] bytes = new byte[10];
            IOUtils.writeLocalDate(bytes, 0, year, month, dayOfMonth);
            str = JDKUtils.STRING_CREATOR_JDK11.apply(bytes, JDKUtils.LATIN1);
        } else {
            char[] chars = new char[10];
            IOUtils.writeLocalDate(chars, 0, year, month, dayOfMonth);
            str = JDKUtils.STRING_CREATOR_JDK8 != null ? JDKUtils.STRING_CREATOR_JDK8.apply(chars, Boolean.TRUE) : new String(chars);
        }
        if (off >= 0 && off < cache.length) {
            cache[off] = str;
        }
        return str;
    }

    public static String format(Date date, String format) {
        if (date == null) {
            return null;
        }
        if (format == null) {
            return DateUtils.format(date);
        }
        switch (format) {
            case "yyyy-MM-dd HH:mm:ss": {
                return DateUtils.format(date.getTime(), DateTimeFormatPattern.DATE_TIME_FORMAT_19_DASH);
            }
            case "yyyy-MM-ddTHH:mm:ss": 
            case "yyyy-MM-dd'T'HH:mm:ss": {
                return DateUtils.format(date.getTime(), DateTimeFormatPattern.DATE_TIME_FORMAT_19_DASH_T);
            }
            case "dd.MM.yyyy HH:mm:ss": {
                return DateUtils.format(date.getTime(), DateTimeFormatPattern.DATE_TIME_FORMAT_19_DOT);
            }
            case "yyyyMMdd": {
                return DateUtils.formatYMD8(date.getTime(), DEFAULT_ZONE_ID);
            }
            case "yyyy-MM-dd": {
                return DateUtils.formatYMD10(date.getTime(), DEFAULT_ZONE_ID);
            }
            case "yyyy/MM/dd": {
                return DateUtils.format(date.getTime(), DateTimeFormatPattern.DATE_FORMAT_10_SLASH);
            }
            case "dd.MM.yyyy": {
                return DateUtils.format(date.getTime(), DateTimeFormatPattern.DATE_FORMAT_10_DOT);
            }
        }
        long epochMilli = date.getTime();
        Instant instant = Instant.ofEpochMilli(epochMilli);
        ZonedDateTime zdt = instant.atZone(DEFAULT_ZONE_ID);
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(format);
        return formatter.format(zdt);
    }

    public static String formatYMDHMS19(ZonedDateTime zdt) {
        if (zdt == null) {
            return null;
        }
        int year = zdt.getYear();
        int month = zdt.getMonthValue();
        int dayOfMonth = zdt.getDayOfMonth();
        int hour = zdt.getHour();
        int minute = zdt.getMinute();
        int second = zdt.getSecond();
        return DateUtils.format(year, month, dayOfMonth, hour, minute, second, DateTimeFormatPattern.DATE_TIME_FORMAT_19_DASH);
    }

    public static String format(ZonedDateTime zdt, String format) {
        if (zdt == null) {
            return null;
        }
        int year = zdt.getYear();
        int month = zdt.getMonthValue();
        int dayOfMonth = zdt.getDayOfMonth();
        switch (format) {
            case "yyyy-MM-dd HH:mm:ss": {
                int hour = zdt.getHour();
                int minute = zdt.getMinute();
                int second = zdt.getSecond();
                return DateUtils.format(year, month, dayOfMonth, hour, minute, second, DateTimeFormatPattern.DATE_TIME_FORMAT_19_DASH);
            }
            case "yyyy-MM-ddTHH:mm:ss": 
            case "yyyy-MM-dd'T'HH:mm:ss": {
                int hour = zdt.getHour();
                int minute = zdt.getMinute();
                int second = zdt.getSecond();
                return DateUtils.format(year, month, dayOfMonth, hour, minute, second, DateTimeFormatPattern.DATE_TIME_FORMAT_19_DASH_T);
            }
            case "yyyy-MM-dd": {
                return DateUtils.format(year, month, dayOfMonth, DateTimeFormatPattern.DATE_FORMAT_10_DASH);
            }
            case "yyyy/MM/dd": {
                return DateUtils.format(year, month, dayOfMonth, DateTimeFormatPattern.DATE_FORMAT_10_SLASH);
            }
            case "dd.MM.yyyy": {
                return DateUtils.format(year, month, dayOfMonth, DateTimeFormatPattern.DATE_FORMAT_10_DOT);
            }
        }
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(format);
        return formatter.format(zdt);
    }

    public static String formatYMDHMS19(LocalDateTime ldt) {
        if (ldt == null) {
            return null;
        }
        int year = ldt.getYear();
        int month = ldt.getMonthValue();
        int dayOfMonth = ldt.getDayOfMonth();
        int hour = ldt.getHour();
        int minute = ldt.getMinute();
        int second = ldt.getSecond();
        if (JDKUtils.STRING_CREATOR_JDK11 != null) {
            byte[] bytes = new byte[19];
            IOUtils.writeLocalDate(bytes, 0, year, month, dayOfMonth);
            bytes[10] = 32;
            IOUtils.writeLocalTime(bytes, 11, hour, minute, second);
            return JDKUtils.STRING_CREATOR_JDK11.apply(bytes, JDKUtils.LATIN1);
        }
        char[] chars = new char[19];
        IOUtils.writeLocalDate(chars, 0, year, month, dayOfMonth);
        chars[10] = 32;
        IOUtils.writeLocalTime(chars, 11, hour, minute, second);
        if (JDKUtils.STRING_CREATOR_JDK8 != null) {
            return JDKUtils.STRING_CREATOR_JDK8.apply(chars, Boolean.TRUE);
        }
        return new String(chars);
    }

    public static String format(LocalDateTime ldt, String format) {
        if (ldt == null) {
            return null;
        }
        int year = ldt.getYear();
        int month = ldt.getMonthValue();
        int dayOfMonth = ldt.getDayOfMonth();
        switch (format) {
            case "yyyy-MM-dd HH:mm:ss": {
                int hour = ldt.getHour();
                int minute = ldt.getMinute();
                int second = ldt.getSecond();
                return DateUtils.format(year, month, dayOfMonth, hour, minute, second, DateTimeFormatPattern.DATE_TIME_FORMAT_19_DASH);
            }
            case "yyyy-MM-ddTHH:mm:ss": 
            case "yyyy-MM-dd'T'HH:mm:ss": {
                int hour = ldt.getHour();
                int minute = ldt.getMinute();
                int second = ldt.getSecond();
                return DateUtils.format(year, month, dayOfMonth, hour, minute, second, DateTimeFormatPattern.DATE_TIME_FORMAT_19_DASH_T);
            }
            case "yyyy-MM-dd": {
                return DateUtils.formatYMD10(year, month, dayOfMonth);
            }
            case "yyyy/MM/dd": {
                return DateUtils.format(year, month, dayOfMonth, DateTimeFormatPattern.DATE_FORMAT_10_SLASH);
            }
            case "dd.MM.yyyy": {
                return DateUtils.format(year, month, dayOfMonth, DateTimeFormatPattern.DATE_FORMAT_10_DOT);
            }
        }
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(format);
        return formatter.format(ldt);
    }

    public static String formatYMDHMS19(LocalDate localDate) {
        if (localDate == null) {
            return null;
        }
        int year = localDate.getYear();
        int month = localDate.getMonthValue();
        int dayOfMonth = localDate.getDayOfMonth();
        if (JDKUtils.STRING_CREATOR_JDK11 != null) {
            byte[] bytes = new byte[19];
            IOUtils.writeLocalDate(bytes, 0, year, month, dayOfMonth);
            bytes[10] = 32;
            IOUtils.writeLocalTime(bytes, 11, 0, 0, 0);
            return JDKUtils.STRING_CREATOR_JDK11.apply(bytes, JDKUtils.LATIN1);
        }
        char[] chars = new char[19];
        IOUtils.writeLocalDate(chars, 0, year, month, dayOfMonth);
        chars[10] = 32;
        IOUtils.writeLocalTime(chars, 11, 0, 0, 0);
        if (JDKUtils.STRING_CREATOR_JDK8 != null) {
            return JDKUtils.STRING_CREATOR_JDK8.apply(chars, Boolean.TRUE);
        }
        return new String(chars);
    }

    public static String format(LocalDate localDate, String format) {
        if (localDate == null) {
            return null;
        }
        int year = localDate.getYear();
        int month = localDate.getMonthValue();
        int dayOfMonth = localDate.getDayOfMonth();
        switch (format) {
            case "yyyy-MM-dd HH:mm:ss": {
                return DateUtils.format(year, month, dayOfMonth, 0, 0, 0, DateTimeFormatPattern.DATE_TIME_FORMAT_19_DASH);
            }
            case "yyyy-MM-ddTHH:mm:ss": 
            case "yyyy-MM-dd'T'HH:mm:ss": {
                return DateUtils.format(year, month, dayOfMonth, 0, 0, 0, DateTimeFormatPattern.DATE_TIME_FORMAT_19_DASH_T);
            }
            case "yyyy-MM-dd": {
                return DateUtils.format(year, month, dayOfMonth, DateTimeFormatPattern.DATE_FORMAT_10_DASH);
            }
            case "yyyy/MM/dd": {
                return DateUtils.format(year, month, dayOfMonth, DateTimeFormatPattern.DATE_FORMAT_10_SLASH);
            }
            case "dd.MM.yyyy": {
                return DateUtils.format(year, month, dayOfMonth, DateTimeFormatPattern.DATE_FORMAT_10_DOT);
            }
        }
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(format);
        return formatter.format(localDate);
    }

    public static String format(int year, int month, int dayOfMonth) {
        return DateUtils.format(year, month, dayOfMonth, DateTimeFormatPattern.DATE_FORMAT_10_DASH);
    }

    public static String format(int year, int month, int dayOfMonth, DateTimeFormatPattern pattern) {
        int y01 = year / 100;
        int y23 = year - y01 * 100;
        if (JDKUtils.STRING_CREATOR_JDK11 != null) {
            byte[] bytes = new byte[10];
            if (pattern == DateTimeFormatPattern.DATE_FORMAT_10_DOT) {
                IOUtils.writeDigitPair(bytes, 0, dayOfMonth);
                bytes[2] = 46;
                IOUtils.writeDigitPair(bytes, 3, month);
                bytes[5] = 46;
                IOUtils.writeDigitPair(bytes, 6, y01);
                IOUtils.writeDigitPair(bytes, 8, y23);
            } else {
                byte separator = (byte)(pattern == DateTimeFormatPattern.DATE_FORMAT_10_DASH ? 45 : 47);
                IOUtils.writeDigitPair(bytes, 0, y01);
                IOUtils.writeDigitPair(bytes, 2, y23);
                bytes[4] = separator;
                IOUtils.writeDigitPair(bytes, 5, month);
                bytes[7] = separator;
                IOUtils.writeDigitPair(bytes, 8, dayOfMonth);
            }
            return JDKUtils.STRING_CREATOR_JDK11.apply(bytes, JDKUtils.LATIN1);
        }
        char[] chars = new char[10];
        if (pattern == DateTimeFormatPattern.DATE_FORMAT_10_DOT) {
            IOUtils.writeDigitPair(chars, 0, dayOfMonth);
            chars[2] = 46;
            IOUtils.writeDigitPair(chars, 3, month);
            chars[5] = 46;
            IOUtils.writeDigitPair(chars, 6, y01);
            IOUtils.writeDigitPair(chars, 8, y23);
        } else {
            int separator = pattern == DateTimeFormatPattern.DATE_FORMAT_10_DASH ? 45 : 47;
            IOUtils.writeDigitPair(chars, 0, y01);
            IOUtils.writeDigitPair(chars, 2, y23);
            chars[4] = separator;
            IOUtils.writeDigitPair(chars, 5, month);
            chars[7] = separator;
            IOUtils.writeDigitPair(chars, 8, dayOfMonth);
        }
        if (JDKUtils.STRING_CREATOR_JDK8 != null) {
            return JDKUtils.STRING_CREATOR_JDK8.apply(chars, Boolean.TRUE);
        }
        return new String(chars);
    }

    public static String format(long timeMillis) {
        return DateUtils.format(timeMillis, DateTimeFormatPattern.DATE_TIME_FORMAT_19_DASH);
    }

    public static String format(Date date) {
        if (date == null) {
            return null;
        }
        return DateUtils.format(date.getTime(), DateTimeFormatPattern.DATE_TIME_FORMAT_19_DASH);
    }

    public static String format(long timeMillis, DateTimeFormatPattern pattern) {
        long yearEst;
        long doyEst;
        int offsetTotalSeconds;
        ZoneId zoneId = DEFAULT_ZONE_ID;
        long SECONDS_PER_DAY = 86400L;
        long epochSecond = Math.floorDiv(timeMillis, 1000L);
        if (zoneId == SHANGHAI_ZONE_ID || zoneId.getRules() == SHANGHAI_ZONE_RULES) {
            offsetTotalSeconds = DateUtils.getShanghaiZoneOffsetTotalSeconds(epochSecond);
        } else {
            Instant instant = Instant.ofEpochMilli(timeMillis);
            offsetTotalSeconds = zoneId.getRules().getOffset(instant).getTotalSeconds();
        }
        long localSecond = epochSecond + (long)offsetTotalSeconds;
        long localEpochDay = Math.floorDiv(localSecond, 86400L);
        int secsOfDay = (int)Math.floorMod(localSecond, 86400L);
        int DAYS_PER_CYCLE = 146097;
        long DAYS_0000_TO_1970 = 719528L;
        long zeroDay = localEpochDay + 719528L;
        long adjust = 0L;
        if ((zeroDay -= 60L) < 0L) {
            long adjustCycles = (zeroDay + 1L) / 146097L - 1L;
            adjust = adjustCycles * 400L;
            zeroDay += -adjustCycles * 146097L;
        }
        if ((doyEst = zeroDay - (365L * (yearEst = (400L * zeroDay + 591L) / 146097L) + yearEst / 4L - yearEst / 100L + yearEst / 400L)) < 0L) {
            doyEst = zeroDay - (365L * --yearEst + yearEst / 4L - yearEst / 100L + yearEst / 400L);
        }
        yearEst += adjust;
        int marchDoy0 = (int)doyEst;
        int marchMonth0 = (marchDoy0 * 5 + 2) / 153;
        int month = (marchMonth0 + 2) % 12 + 1;
        int dayOfMonth = marchDoy0 - (marchMonth0 * 306 + 5) / 10 + 1;
        if ((yearEst += (long)(marchMonth0 / 10)) < -999999999L || yearEst > 999999999L) {
            throw new DateTimeException("Invalid year " + yearEst);
        }
        int year = (int)yearEst;
        if (pattern == DateTimeFormatPattern.DATE_FORMAT_10_DASH || pattern == DateTimeFormatPattern.DATE_FORMAT_10_SLASH || pattern == DateTimeFormatPattern.DATE_FORMAT_10_DOT) {
            return DateUtils.format(year, month, dayOfMonth, pattern);
        }
        int MINUTES_PER_HOUR = 60;
        int SECONDS_PER_MINUTE = 60;
        int SECONDS_PER_HOUR = 3600;
        long secondOfDay = secsOfDay;
        if (secondOfDay < 0L || secondOfDay > 86399L) {
            throw new DateTimeException("Invalid secondOfDay " + secondOfDay);
        }
        int hours = (int)(secondOfDay / 3600L);
        int minutes = (int)((secondOfDay -= (long)(hours * 3600)) / 60L);
        int hour = hours;
        int minute = minutes;
        int second = (int)(secondOfDay -= (long)(minutes * 60));
        return DateUtils.format(year, month, dayOfMonth, hour, minute, second, pattern);
    }

    public static String format(int year, int month, int dayOfMonth, int hour, int minute, int second) {
        return DateUtils.format(year, month, dayOfMonth, hour, minute, second, DateTimeFormatPattern.DATE_TIME_FORMAT_19_DASH);
    }

    static String format(int year, int month, int dayOfMonth, int hour, int minute, int second, DateTimeFormatPattern pattern) {
        int y01 = year / 100;
        int y23 = year - y01 * 100;
        if (JDKUtils.STRING_CREATOR_JDK11 != null) {
            byte[] bytes = new byte[19];
            if (pattern == DateTimeFormatPattern.DATE_TIME_FORMAT_19_DOT) {
                IOUtils.writeDigitPair(bytes, 0, dayOfMonth);
                bytes[2] = 46;
                IOUtils.writeDigitPair(bytes, 3, month);
                bytes[5] = 46;
                IOUtils.writeDigitPair(bytes, 6, y01);
                IOUtils.writeDigitPair(bytes, 8, y23);
                bytes[10] = 32;
            } else {
                int separator = pattern == DateTimeFormatPattern.DATE_TIME_FORMAT_19_DASH ? 32 : 84;
                byte dateSeparator = (byte)(pattern == DateTimeFormatPattern.DATE_TIME_FORMAT_19_SLASH ? 47 : 45);
                IOUtils.writeDigitPair(bytes, 0, y01);
                IOUtils.writeDigitPair(bytes, 2, y23);
                bytes[4] = dateSeparator;
                IOUtils.writeDigitPair(bytes, 5, month);
                bytes[7] = dateSeparator;
                IOUtils.writeDigitPair(bytes, 8, dayOfMonth);
                bytes[10] = (byte)separator;
            }
            IOUtils.writeLocalTime(bytes, 11, hour, minute, second);
            return JDKUtils.STRING_CREATOR_JDK11.apply(bytes, JDKUtils.LATIN1);
        }
        char[] chars = new char[19];
        if (pattern == DateTimeFormatPattern.DATE_TIME_FORMAT_19_DOT) {
            IOUtils.writeDigitPair(chars, 0, dayOfMonth);
            chars[2] = 46;
            IOUtils.writeDigitPair(chars, 3, month);
            chars[5] = 46;
            IOUtils.writeDigitPair(chars, 6, y01);
            IOUtils.writeDigitPair(chars, 8, y23);
            chars[10] = 32;
        } else {
            int separator = pattern == DateTimeFormatPattern.DATE_TIME_FORMAT_19_DASH ? 32 : 84;
            int dateSeparator = pattern == DateTimeFormatPattern.DATE_TIME_FORMAT_19_SLASH ? 47 : 45;
            IOUtils.writeDigitPair(chars, 0, y01);
            IOUtils.writeDigitPair(chars, 2, y23);
            chars[4] = dateSeparator;
            IOUtils.writeDigitPair(chars, 5, month);
            chars[7] = dateSeparator;
            IOUtils.writeDigitPair(chars, 8, dayOfMonth);
            chars[10] = separator;
        }
        IOUtils.writeLocalTime(chars, 11, hour, minute, second);
        if (JDKUtils.STRING_CREATOR_JDK8 != null) {
            return JDKUtils.STRING_CREATOR_JDK8.apply(chars, Boolean.TRUE);
        }
        return new String(chars);
    }

    public static String toString(Date date) {
        return DateUtils.toString(date.getTime(), false, DEFAULT_ZONE_ID);
    }

    public static String toString(long timeMillis, boolean timeZone, ZoneId zoneId) {
        int offsetAbs;
        int timeZoneOffset;
        int i;
        long yearEst;
        long doyEst;
        int offsetTotalSeconds;
        long SECONDS_PER_DAY = 86400L;
        long epochSecond = Math.floorDiv(timeMillis, 1000L);
        if (zoneId == SHANGHAI_ZONE_ID || zoneId.getRules() == SHANGHAI_ZONE_RULES) {
            offsetTotalSeconds = DateUtils.getShanghaiZoneOffsetTotalSeconds(epochSecond);
        } else {
            Instant instant = Instant.ofEpochMilli(timeMillis);
            offsetTotalSeconds = zoneId.getRules().getOffset(instant).getTotalSeconds();
        }
        long localSecond = epochSecond + (long)offsetTotalSeconds;
        long localEpochDay = Math.floorDiv(localSecond, 86400L);
        int secsOfDay = (int)Math.floorMod(localSecond, 86400L);
        int DAYS_PER_CYCLE = 146097;
        long DAYS_0000_TO_1970 = 719528L;
        long zeroDay = localEpochDay + 719528L;
        long adjust = 0L;
        if ((zeroDay -= 60L) < 0L) {
            long adjustCycles = (zeroDay + 1L) / 146097L - 1L;
            adjust = adjustCycles * 400L;
            zeroDay += -adjustCycles * 146097L;
        }
        if ((doyEst = zeroDay - (365L * (yearEst = (400L * zeroDay + 591L) / 146097L) + yearEst / 4L - yearEst / 100L + yearEst / 400L)) < 0L) {
            doyEst = zeroDay - (365L * --yearEst + yearEst / 4L - yearEst / 100L + yearEst / 400L);
        }
        yearEst += adjust;
        int marchDoy0 = (int)doyEst;
        int marchMonth0 = (marchDoy0 * 5 + 2) / 153;
        int month = (marchMonth0 + 2) % 12 + 1;
        int dayOfMonth = marchDoy0 - (marchMonth0 * 306 + 5) / 10 + 1;
        if ((yearEst += (long)(marchMonth0 / 10)) < -999999999L || yearEst > 999999999L) {
            throw new DateTimeException("Invalid year " + yearEst);
        }
        int year = (int)yearEst;
        int MINUTES_PER_HOUR = 60;
        int SECONDS_PER_MINUTE = 60;
        int SECONDS_PER_HOUR = 3600;
        long secondOfDay = secsOfDay;
        if (secondOfDay < 0L || secondOfDay > 86399L) {
            throw new DateTimeException("Invalid secondOfDay " + secondOfDay);
        }
        int hours = (int)(secondOfDay / 3600L);
        int minutes = (int)((secondOfDay -= (long)(hours * 3600)) / 60L);
        int hour = hours;
        int minute = minutes;
        int second = (int)(secondOfDay -= (long)(minutes * 60));
        int millis = (int)Math.floorMod(timeMillis, 1000L);
        int millislen = millis == 0 ? 0 : (millis < 10 ? 4 : (millis % 100 == 0 ? 2 : (millis % 10 == 0 ? 3 : 4)));
        int zonelen = timeZone ? (offsetTotalSeconds == 0 ? 1 : 6) : 0;
        int len = 19 + millislen + zonelen;
        if (JDKUtils.STRING_CREATOR_JDK8 != null) {
            char[] chars = new char[len];
            IOUtils.writeLocalDate(chars, 0, year, month, dayOfMonth);
            chars[10] = 32;
            IOUtils.writeLocalTime(chars, 11, hour, minute, second);
            if (millislen > 0) {
                chars[19] = 46;
                for (i = 20; i < len; ++i) {
                    chars[i] = 48;
                }
                if (millis < 10) {
                    IOUtils.getChars(millis, 19 + millislen, chars);
                } else if (millis % 100 == 0) {
                    IOUtils.getChars(millis / 100, 19 + millislen, chars);
                } else if (millis % 10 == 0) {
                    IOUtils.getChars(millis / 10, 19 + millislen, chars);
                } else {
                    IOUtils.getChars(millis, 19 + millislen, chars);
                }
            }
            if (timeZone) {
                timeZoneOffset = offsetTotalSeconds / 3600;
                if (offsetTotalSeconds == 0) {
                    chars[19 + millislen] = 90;
                } else {
                    offsetAbs = Math.abs(timeZoneOffset);
                    chars[19 + millislen] = timeZoneOffset >= 0 ? 43 : 45;
                    chars[19 + millislen + 1] = 48;
                    IOUtils.getChars(offsetAbs, 19 + millislen + 3, chars);
                    chars[19 + millislen + 3] = 58;
                    chars[19 + millislen + 4] = 48;
                    int offsetMinutes = (offsetTotalSeconds - timeZoneOffset * 3600) / 60;
                    if (offsetMinutes < 0) {
                        offsetMinutes = -offsetMinutes;
                    }
                    IOUtils.getChars(offsetMinutes, 19 + millislen + zonelen, chars);
                }
            }
            return JDKUtils.STRING_CREATOR_JDK8.apply(chars, Boolean.TRUE);
        }
        byte[] bytes = new byte[len];
        IOUtils.writeLocalDate(bytes, 0, year, month, dayOfMonth);
        bytes[10] = 32;
        IOUtils.writeLocalTime(bytes, 11, hour, minute, second);
        if (millislen > 0) {
            bytes[19] = 46;
            for (i = 20; i < len; ++i) {
                bytes[i] = 48;
            }
            if (millis < 10) {
                IOUtils.getChars(millis, 19 + millislen, bytes);
            } else if (millis % 100 == 0) {
                IOUtils.getChars(millis / 100, 19 + millislen, bytes);
            } else if (millis % 10 == 0) {
                IOUtils.getChars(millis / 10, 19 + millislen, bytes);
            } else {
                IOUtils.getChars(millis, 19 + millislen, bytes);
            }
        }
        if (timeZone) {
            timeZoneOffset = offsetTotalSeconds / 3600;
            if (offsetTotalSeconds == 0) {
                bytes[19 + millislen] = 90;
            } else {
                offsetAbs = Math.abs(timeZoneOffset);
                bytes[19 + millislen] = timeZoneOffset >= 0 ? 43 : 45;
                bytes[19 + millislen + 1] = 48;
                IOUtils.getChars(offsetAbs, 19 + millislen + 3, bytes);
                bytes[19 + millislen + 3] = 58;
                bytes[19 + millislen + 4] = 48;
                int offsetMinutes = (offsetTotalSeconds - timeZoneOffset * 3600) / 60;
                if (offsetMinutes < 0) {
                    offsetMinutes = -offsetMinutes;
                }
                IOUtils.getChars(offsetMinutes, 19 + millislen + zonelen, bytes);
            }
        }
        if (JDKUtils.STRING_CREATOR_JDK11 != null) {
            return JDKUtils.STRING_CREATOR_JDK11.apply(bytes, JDKUtils.LATIN1);
        }
        return new String(bytes, 0, bytes.length, StandardCharsets.ISO_8859_1);
    }

    private static int month(byte c0, byte c1, byte c2) {
        return DateUtils.month((char)c0, (char)c1, (char)c2);
    }

    public static int month(char c0, char c1, char c2) {
        int x = c0 << 16 | c1 << 8 | c2;
        switch (x) {
            case 4874606: {
                return 1;
            }
            case 4613474: {
                return 2;
            }
            case 5071218: {
                return 3;
            }
            case 4288626: {
                return 4;
            }
            case 5071225: {
                return 5;
            }
            case 4879726: {
                return 6;
            }
            case 4879724: {
                return 7;
            }
            case 4289895: {
                return 8;
            }
            case 5465456: {
                return 9;
            }
            case 5202804: {
                return 10;
            }
            case 5140342: {
                return 11;
            }
            case 4482403: {
                return 12;
            }
        }
        return -1;
    }

    public static int hourAfterNoon(char h0, char h1) {
        if (h0 == '0') {
            switch (h1) {
                case '0': {
                    h0 = (char)49;
                    h1 = (char)50;
                    break;
                }
                case '1': {
                    h0 = (char)49;
                    h1 = (char)51;
                    break;
                }
                case '2': {
                    h0 = (char)49;
                    h1 = (char)52;
                    break;
                }
                case '3': {
                    h0 = (char)49;
                    h1 = (char)53;
                    break;
                }
                case '4': {
                    h0 = (char)49;
                    h1 = (char)54;
                    break;
                }
                case '5': {
                    h0 = (char)49;
                    h1 = (char)55;
                    break;
                }
                case '6': {
                    h0 = (char)49;
                    h1 = (char)56;
                    break;
                }
                case '7': {
                    h0 = (char)49;
                    h1 = (char)57;
                    break;
                }
                case '8': {
                    h0 = (char)50;
                    h1 = (char)48;
                    break;
                }
                case '9': {
                    h0 = (char)50;
                    h1 = (char)49;
                    break;
                }
            }
        } else if (h0 == '1') {
            switch (h1) {
                case '0': {
                    h0 = (char)50;
                    h1 = (char)50;
                    break;
                }
                case '1': {
                    h0 = (char)50;
                    h1 = (char)51;
                    break;
                }
                case '2': {
                    h0 = (char)50;
                    h1 = (char)52;
                    break;
                }
            }
        }
        return h0 << 16 | h1;
    }

    public static int getShanghaiZoneOffsetTotalSeconds(long seconds) {
        long SECONDS_1991_09_15_02 = 684900000L;
        long SECONDS_1991_04_14_03 = 671598000L;
        long SECONDS_1990_09_16_02 = 653450400L;
        long SECONDS_1990_04_15_03 = 640148400L;
        long SECONDS_1989_09_17_02 = 622000800L;
        long SECONDS_1989_04_16_03 = 608698800L;
        long SECONDS_1988_09_11_02 = 589946400L;
        long SECONDS_1988_04_17_03 = 577249200L;
        long SECONDS_1987_09_13_02 = 558496800L;
        long SECONDS_1987_04_12_03 = 545194800L;
        long SECONDS_1986_09_14_02 = 527047200L;
        long SECONDS_1986_05_04_03 = 515559600L;
        long SECONDS_1949_05_28_00 = -649987200L;
        long SECONDS_1949_05_01_01 = -652316400L;
        long SECONDS_1948_10_01_00 = -670636800L;
        long SECONDS_1948_05_01_01 = -683852400L;
        long SECONDS_1947_11_01_00 = -699580800L;
        long SECONDS_1947_04_15_01 = -716857200L;
        long SECONDS_1946_10_01_00 = -733795200L;
        long SECONDS_1946_05_15_01 = -745801200L;
        long SECONDS_1945_09_02_00 = -767836800L;
        long SECONDS_1942_01_31_01 = -881017200L;
        long SECONDS_1941_11_02_00 = -888796800L;
        long SECONDS_1941_03_15_01 = -908838000L;
        long SECONDS_1940_10_13_00 = -922060800L;
        long SECONDS_1940_06_01_01 = -933634800L;
        long SECONDS_1919_10_01_00 = -1585872000L;
        long SECONDS_1919_04_13_01 = -1600642800L;
        long SECONDS_1901_01_01_00 = -2177452800L;
        int OFFSET_0900_TOTAL_SECONDS = 32400;
        int OFFSET_0800_TOTAL_SECONDS = 28800;
        int OFFSET_0543_TOTAL_SECONDS = 29143;
        int zoneOffsetTotalSeconds = seconds >= SECONDS_1991_09_15_02 ? 28800 : (seconds >= SECONDS_1991_04_14_03 ? 32400 : (seconds >= SECONDS_1990_09_16_02 ? 28800 : (seconds >= SECONDS_1990_04_15_03 ? 32400 : (seconds >= SECONDS_1989_09_17_02 ? 28800 : (seconds >= SECONDS_1989_04_16_03 ? 32400 : (seconds >= SECONDS_1988_09_11_02 ? 28800 : (seconds >= SECONDS_1988_04_17_03 ? 32400 : (seconds >= SECONDS_1987_09_13_02 ? 28800 : (seconds >= SECONDS_1987_04_12_03 ? 32400 : (seconds >= SECONDS_1986_09_14_02 ? 28800 : (seconds >= SECONDS_1986_05_04_03 ? 32400 : (seconds >= SECONDS_1949_05_28_00 ? 28800 : (seconds >= SECONDS_1949_05_01_01 ? 32400 : (seconds >= SECONDS_1948_10_01_00 ? 28800 : (seconds >= SECONDS_1948_05_01_01 ? 32400 : (seconds >= SECONDS_1947_11_01_00 ? 28800 : (seconds >= SECONDS_1947_04_15_01 ? 32400 : (seconds >= SECONDS_1946_10_01_00 ? 28800 : (seconds >= SECONDS_1946_05_15_01 ? 32400 : (seconds >= SECONDS_1945_09_02_00 ? 28800 : (seconds >= SECONDS_1942_01_31_01 ? 32400 : (seconds >= SECONDS_1941_11_02_00 ? 28800 : (seconds >= SECONDS_1941_03_15_01 ? 32400 : (seconds >= SECONDS_1940_10_13_00 ? 28800 : (seconds >= SECONDS_1940_06_01_01 ? 32400 : (seconds >= SECONDS_1919_10_01_00 ? 28800 : (seconds >= SECONDS_1919_04_13_01 ? 32400 : (seconds >= SECONDS_1901_01_01_00 ? 28800 : 29143))))))))))))))))))))))))))));
        return zoneOffsetTotalSeconds;
    }

    public static boolean isLocalDate(String str) {
        if (str == null || str.isEmpty()) {
            return false;
        }
        if (str.length() == 10 && str.charAt(4) == '-' && str.charAt(7) == '-') {
            char y0 = str.charAt(0);
            char y1 = str.charAt(1);
            char y2 = str.charAt(2);
            char y3 = str.charAt(3);
            char m0 = str.charAt(5);
            char m1 = str.charAt(6);
            char d0 = str.charAt(8);
            char d1 = str.charAt(9);
            int yyyy = (y0 - 48) * 1000 + (y1 - 48) * 100 + (y2 - 48) * 10 + (y3 - 48);
            int mm = (m0 - 48) * 10 + (m1 - 48);
            int dd = (d0 - 48) * 10 + (d1 - 48);
            if (mm > 12) {
                return false;
            }
            if (dd > 28) {
                int dom = 31;
                switch (mm) {
                    case 2: {
                        boolean isLeapYear = (yyyy & 0xF) == 0 ? (yyyy & 3) == 0 : (yyyy & 3) == 0 && yyyy % 100 != 0;
                        dom = isLeapYear ? 29 : 28;
                        break;
                    }
                    case 4: 
                    case 6: 
                    case 9: 
                    case 11: {
                        dom = 30;
                    }
                }
                return dd <= dom;
            }
            return true;
        }
        if (str.length() < 9 || str.length() > 40) {
            return false;
        }
        try {
            return DateUtils.parseLocalDate(str) != null;
        }
        catch (JSONException | DateTimeException ignored) {
            return false;
        }
    }

    public static boolean isDate(String str) {
        char c10;
        if (str == null || str.isEmpty()) {
            return false;
        }
        if (str.length() == 19 && str.charAt(4) == '-' && str.charAt(7) == '-' && ((c10 = str.charAt(10)) == ' ' || c10 == 'T') && str.charAt(13) == ':' && str.charAt(16) == ':') {
            char y0 = str.charAt(0);
            char y1 = str.charAt(1);
            char y2 = str.charAt(2);
            char y3 = str.charAt(3);
            char m0 = str.charAt(5);
            char m1 = str.charAt(6);
            char d0 = str.charAt(8);
            char d1 = str.charAt(9);
            char h0 = str.charAt(11);
            char h1 = str.charAt(12);
            char i0 = str.charAt(14);
            char i1 = str.charAt(15);
            char s0 = str.charAt(17);
            char s1 = str.charAt(18);
            if (y0 < '0' || y0 > '9' || y1 < '0' || y1 > '9' || y2 < '0' || y2 > '9' || y3 < '0' || y3 > '9' || m0 < '0' || m0 > '9' || m1 < '0' || m1 > '9' || d0 < '0' || d0 > '9' || d1 < '0' || d1 > '9' || h0 < '0' || h0 > '9' || h1 < '0' || h1 > '9' || i0 < '0' || i0 > '9' || i1 < '0' || i1 > '9' || s0 < '0' || s0 > '9' || s1 < '0' || s1 > '9') {
                return false;
            }
            int yyyy = (y0 - 48) * 1000 + (y1 - 48) * 100 + (y2 - 48) * 10 + (y3 - 48);
            int mm = (m0 - 48) * 10 + (m1 - 48);
            int dd = (d0 - 48) * 10 + (d1 - 48);
            int hh = (h0 - 48) * 10 + (h1 - 48);
            int ii = (i0 - 48) * 10 + (i1 - 48);
            int ss = (s0 - 48) * 10 + (s1 - 48);
            if (mm > 12) {
                return false;
            }
            if (dd > 28) {
                int dom = 31;
                switch (mm) {
                    case 2: {
                        boolean isLeapYear = (yyyy & 0xF) == 0 ? (yyyy & 3) == 0 : (yyyy & 3) == 0 && yyyy % 100 != 0;
                        dom = isLeapYear ? 29 : 28;
                        break;
                    }
                    case 4: 
                    case 6: 
                    case 9: 
                    case 11: {
                        dom = 30;
                    }
                }
                if (dd > dom) {
                    return false;
                }
            }
            if (hh > 24) {
                return false;
            }
            if (ii > 60) {
                return false;
            }
            return ss <= 61;
        }
        try {
            return DateUtils.parseMillis(str, DEFAULT_ZONE_ID) != 0L;
        }
        catch (JSONException | DateTimeException ignored) {
            return false;
        }
    }

    public static boolean isLocalTime(String str) {
        if (str == null || str.isEmpty()) {
            return false;
        }
        if (str.length() != 8 || str.charAt(2) != ':' || str.charAt(5) != ':') {
            try {
                LocalTime.parse(str);
                return true;
            }
            catch (DateTimeParseException ignored) {
                return false;
            }
        }
        char h0 = str.charAt(0);
        char h1 = str.charAt(1);
        char m0 = str.charAt(3);
        char m1 = str.charAt(4);
        char s0 = str.charAt(6);
        char s1 = str.charAt(7);
        if (h0 >= '0' && h0 <= '2' && h1 >= '0' && h1 <= '9' && m0 >= '0' && m0 <= '6' && m1 >= '0' && m1 <= '9' && s0 >= '0' && s0 <= '6' && s1 >= '0' && s1 <= '9') {
            int hh = (h0 - 48) * 10 + (h1 - 48);
            if (hh > 24) {
                return false;
            }
            int mm = (m0 - 48) * 10 + (m1 - 48);
            if (mm > 60) {
                return false;
            }
            int ss = (s0 - 48) * 10 + (s1 - 48);
            return ss <= 61;
        }
        return false;
    }

    public static int readNanos(char[] chars, int len, int offset) {
        int v = 0;
        for (int i = 0; i < len; ++i) {
            int d = chars[offset + i] - 48;
            if (d < 0 | d > 9) {
                return -1;
            }
            v = v * 10 + d;
        }
        return v *= POWERS[9 - len & 0xF];
    }

    public static int readNanos(byte[] bytes, int len, int offset) {
        int v = 0;
        for (int i = 0; i < len; ++i) {
            int d = bytes[offset + i] - 48;
            if (d < 0 | d > 9) {
                return -1;
            }
            v = v * 10 + d;
        }
        return v *= POWERS[9 - len & 0xF];
    }

    public static ZoneOffset zoneOffset(byte[] bytes, int start, int len) {
        return ZoneOffset.of(new String(bytes, start, len));
    }

    public static ZoneOffset zoneOffset(char[] bytes, int start, int len) {
        return ZoneOffset.of(new String(bytes, start, len));
    }

    public static int nanos(int value, int nanoSize) {
        return value * POWERS[9 - nanoSize & 0xF];
    }

    public static long hms(byte[] bytes, int off) {
        long d;
        long v = JDKUtils.UNSAFE.getLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)off);
        if (JDKUtils.BIG_ENDIAN) {
            v = Long.reverseBytes(v);
        }
        if (((v & 0xF0F0F0F0F0F0F0F0L) - 0x3030303030303030L | (d = v & 0xF0F0F0F0F0F0F0FL) + 0x606000606000606L & 0xF0F000F0F000F0F0L) != 0L || (d & 0xF00000F0000L) != 0xA00000A0000L) {
            return -1L;
        }
        return ((d & 0xF00000F00000FL) << 3) + ((d & 0xF00000F00000FL) << 1) + ((d & 0xF00000F00000F00L) >> 8);
    }

    public static long ymd(byte[] bytes, int off) {
        long d;
        long v = JDKUtils.UNSAFE.getLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)off);
        if (JDKUtils.BIG_ENDIAN) {
            v = Long.reverseBytes(v);
        }
        if ((v & 0xFF0000FF0000L) != 0x2D00002D0000L || ((v & 0xF0F000F0F000F0F0L) - 0x3030003030003030L | (d = v & 0xF0F000F0F000F0FL) + 0x606000606000606L & 0xF0F000F0F000F0F0L) != 0L) {
            return -1L;
        }
        return ((d & 0xF00000F00000FL) << 3) + ((d & 0xF00000F00000FL) << 1) + ((d & 0xF00000F00000F00L) >> 8);
    }

    public static int yy(byte[] bytes, int off) {
        int d;
        short x = JDKUtils.UNSAFE.getShort(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)off);
        if (JDKUtils.BIG_ENDIAN) {
            x = Short.reverseBytes(x);
        }
        if (((x & 0xF0F0) - 12336 | (d = x & 0xF0F) + 1542 & 0xF0F0) != 0) {
            return -1;
        }
        return (d & 0xF) * 1000 + (d >> 8) * 100;
    }

    static {
        int offsetTotalSeconds;
        DEFAULT_ZONE_ID = ZoneId.systemDefault();
        ZoneId zoneId = null;
        ZoneRules zoneRules = null;
        try {
            zoneId = SHANGHAI_ZONE_ID_NAME.equals(DEFAULT_ZONE_ID.getId()) ? DEFAULT_ZONE_ID : ZoneId.of(SHANGHAI_ZONE_ID_NAME);
            zoneRules = zoneId.getRules();
        }
        catch (Exception exception) {
            // empty catch block
        }
        SHANGHAI_ZONE_ID = zoneId;
        SHANGHAI_ZONE_RULES = zoneRules;
        OFFSET_8_ZONE_ID = ZoneId.of(OFFSET_8_ZONE_ID_NAME);
        LOCAL_DATE_19700101 = LocalDate.of(1970, 1, 1);
        long timeMillis = System.currentTimeMillis();
        ZoneId zoneId2 = DEFAULT_ZONE_ID;
        long SECONDS_PER_DAY = 86400L;
        long epochSecond = Math.floorDiv(timeMillis, 1000L);
        if (zoneId2 == SHANGHAI_ZONE_ID || zoneId2.getRules() == SHANGHAI_ZONE_RULES) {
            offsetTotalSeconds = DateUtils.getShanghaiZoneOffsetTotalSeconds(epochSecond);
        } else {
            Instant instant = Instant.ofEpochMilli(timeMillis);
            offsetTotalSeconds = zoneId2.getRules().getOffset(instant).getTotalSeconds();
        }
        long localSecond = epochSecond + (long)offsetTotalSeconds;
        LOCAL_EPOCH_DAY = (int)Math.floorDiv(localSecond, 86400L);
        POWERS = new int[]{1, 10, 100, 1000, 10000, 100000, 1000000, 10000000, 100000000, 1000000000, 0, 0, 0, 0, 0, 0};
    }

    public static enum DateTimeFormatPattern {
        DATE_FORMAT_10_DASH("yyyy-MM-dd", 10),
        DATE_FORMAT_10_SLASH("yyyy/MM/dd", 10),
        DATE_FORMAT_10_DOT("dd.MM.yyyy", 10),
        DATE_TIME_FORMAT_19_DASH("yyyy-MM-dd HH:mm:ss", 19),
        DATE_TIME_FORMAT_19_DASH_T("yyyy-MM-dd'T'HH:mm:ss", 19),
        DATE_TIME_FORMAT_19_SLASH("yyyy/MM/dd HH:mm:ss", 19),
        DATE_TIME_FORMAT_19_DOT("dd.MM.yyyy HH:mm:ss", 19);

        public final String pattern;
        public final int length;

        private DateTimeFormatPattern(String pattern, int length) {
            this.pattern = pattern;
            this.length = length;
        }
    }

    static class CacheDate8 {
        static final String[] CACHE = new String[1024];

        CacheDate8() {
        }
    }

    static class CacheDate10 {
        static final String[] CACHE = new String[1024];

        CacheDate10() {
        }
    }
}

