/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.cluster.api.async;

import io.lettuce.core.KeyScanCursor;
import io.lettuce.core.KeyValue;
import io.lettuce.core.RedisFuture;
import io.lettuce.core.ScanArgs;
import io.lettuce.core.ScanCursor;
import io.lettuce.core.StreamScanCursor;
import io.lettuce.core.cluster.api.StatefulRedisClusterConnection;
import io.lettuce.core.cluster.api.async.AsyncNodeSelection;
import io.lettuce.core.cluster.api.async.RedisClusterAsyncCommands;
import io.lettuce.core.cluster.models.partitions.RedisClusterNode;
import io.lettuce.core.output.KeyStreamingChannel;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;

public interface RedisAdvancedClusterAsyncCommands<K, V>
extends RedisClusterAsyncCommands<K, V> {
    public RedisClusterAsyncCommands<K, V> getConnection(String var1);

    public RedisClusterAsyncCommands<K, V> getConnection(String var1, int var2);

    public StatefulRedisClusterConnection<K, V> getStatefulConnection();

    default public AsyncNodeSelection<K, V> masters() {
        return this.nodes(redisClusterNode -> redisClusterNode.is(RedisClusterNode.NodeFlag.UPSTREAM));
    }

    default public AsyncNodeSelection<K, V> upstream() {
        return this.nodes(redisClusterNode -> redisClusterNode.is(RedisClusterNode.NodeFlag.UPSTREAM));
    }

    @Deprecated
    default public AsyncNodeSelection<K, V> slaves() {
        return this.readonly(redisClusterNode -> redisClusterNode.is(RedisClusterNode.NodeFlag.SLAVE));
    }

    @Deprecated
    default public AsyncNodeSelection<K, V> slaves(Predicate<RedisClusterNode> predicate) {
        return this.readonly(redisClusterNode -> predicate.test((RedisClusterNode)redisClusterNode) && redisClusterNode.is(RedisClusterNode.NodeFlag.REPLICA));
    }

    default public AsyncNodeSelection<K, V> replicas() {
        return this.readonly(redisClusterNode -> redisClusterNode.is(RedisClusterNode.NodeFlag.REPLICA));
    }

    default public AsyncNodeSelection<K, V> replicas(Predicate<RedisClusterNode> predicate) {
        return this.readonly(redisClusterNode -> predicate.test((RedisClusterNode)redisClusterNode) && redisClusterNode.is(RedisClusterNode.NodeFlag.REPLICA));
    }

    default public AsyncNodeSelection<K, V> all() {
        return this.nodes(redisClusterNode -> true);
    }

    public AsyncNodeSelection<K, V> readonly(Predicate<RedisClusterNode> var1);

    public AsyncNodeSelection<K, V> nodes(Predicate<RedisClusterNode> var1);

    public AsyncNodeSelection<K, V> nodes(Predicate<RedisClusterNode> var1, boolean var2);

    @Override
    public RedisFuture<Long> del(K ... var1);

    @Override
    public RedisFuture<Long> unlink(K ... var1);

    @Override
    public RedisFuture<Long> exists(K ... var1);

    @Override
    public RedisFuture<List<KeyValue<K, V>>> mget(K ... var1);

    @Override
    public RedisFuture<String> mset(Map<K, V> var1);

    @Override
    public RedisFuture<Boolean> msetnx(Map<K, V> var1);

    @Override
    public RedisFuture<String> clientSetname(K var1);

    @Override
    public RedisFuture<String> flushall();

    @Override
    public RedisFuture<String> flushallAsync();

    @Override
    public RedisFuture<String> flushdb();

    @Override
    public RedisFuture<Long> dbsize();

    @Override
    public RedisFuture<List<K>> keys(K var1);

    @Override
    public RedisFuture<Long> keys(KeyStreamingChannel<K> var1, K var2);

    @Override
    public RedisFuture<K> randomkey();

    @Override
    public RedisFuture<String> scriptFlush();

    @Override
    public RedisFuture<String> scriptKill();

    @Override
    public RedisFuture<String> scriptLoad(String var1);

    @Override
    public RedisFuture<String> scriptLoad(byte[] var1);

    @Override
    public void shutdown(boolean var1);

    @Override
    public RedisFuture<KeyScanCursor<K>> scan();

    @Override
    public RedisFuture<KeyScanCursor<K>> scan(ScanArgs var1);

    @Override
    public RedisFuture<KeyScanCursor<K>> scan(ScanCursor var1, ScanArgs var2);

    @Override
    public RedisFuture<KeyScanCursor<K>> scan(ScanCursor var1);

    @Override
    public RedisFuture<StreamScanCursor> scan(KeyStreamingChannel<K> var1);

    @Override
    public RedisFuture<StreamScanCursor> scan(KeyStreamingChannel<K> var1, ScanArgs var2);

    @Override
    public RedisFuture<StreamScanCursor> scan(KeyStreamingChannel<K> var1, ScanCursor var2, ScanArgs var3);

    @Override
    public RedisFuture<StreamScanCursor> scan(KeyStreamingChannel<K> var1, ScanCursor var2);

    @Override
    public RedisFuture<Long> touch(K ... var1);
}

