/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.lettuce;

import io.lettuce.core.ClientOptions;
import io.lettuce.core.ReadFrom;
import io.lettuce.core.resource.ClientResources;
import java.time.Duration;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.springframework.data.redis.connection.lettuce.DefaultLettucePoolingClientConfiguration;
import org.springframework.data.redis.connection.lettuce.LettuceClientConfiguration;
import org.springframework.util.Assert;

public interface LettucePoolingClientConfiguration
extends LettuceClientConfiguration {
    public GenericObjectPoolConfig getPoolConfig();

    public static LettucePoolingClientConfigurationBuilder builder() {
        return new LettucePoolingClientConfigurationBuilder();
    }

    public static LettucePoolingClientConfiguration defaultConfiguration() {
        return LettucePoolingClientConfiguration.builder().build();
    }

    public static class LettucePoolingSslClientConfigurationBuilder
    extends LettuceClientConfiguration.LettuceSslClientConfigurationBuilder {
        LettucePoolingSslClientConfigurationBuilder(LettucePoolingClientConfigurationBuilder delegate) {
            super(delegate);
        }

        @Override
        public LettucePoolingClientConfigurationBuilder and() {
            return (LettucePoolingClientConfigurationBuilder)super.and();
        }

        @Override
        public LettucePoolingSslClientConfigurationBuilder disablePeerVerification() {
            super.disablePeerVerification();
            return this;
        }

        @Override
        public LettucePoolingSslClientConfigurationBuilder startTls() {
            super.startTls();
            return this;
        }

        @Override
        public LettucePoolingClientConfiguration build() {
            return (LettucePoolingClientConfiguration)super.build();
        }
    }

    public static class LettucePoolingClientConfigurationBuilder
    extends LettuceClientConfiguration.LettuceClientConfigurationBuilder {
        GenericObjectPoolConfig poolConfig = new GenericObjectPoolConfig();

        LettucePoolingClientConfigurationBuilder() {
        }

        @Override
        public LettucePoolingSslClientConfigurationBuilder useSsl() {
            super.useSsl();
            return new LettucePoolingSslClientConfigurationBuilder(this);
        }

        @Override
        public LettucePoolingClientConfigurationBuilder clientResources(ClientResources clientResources) {
            super.clientResources(clientResources);
            return this;
        }

        @Override
        public LettucePoolingClientConfigurationBuilder clientOptions(ClientOptions clientOptions) {
            super.clientOptions(clientOptions);
            return this;
        }

        @Override
        public LettucePoolingClientConfigurationBuilder commandTimeout(Duration timeout) {
            super.commandTimeout(timeout);
            return this;
        }

        @Override
        public LettucePoolingClientConfigurationBuilder shutdownTimeout(Duration shutdownTimeout) {
            super.shutdownTimeout(shutdownTimeout);
            return this;
        }

        @Override
        public LettucePoolingClientConfigurationBuilder shutdownQuietPeriod(Duration shutdownQuietPeriod) {
            super.shutdownQuietPeriod(shutdownQuietPeriod);
            return this;
        }

        @Override
        public LettucePoolingClientConfigurationBuilder readFrom(ReadFrom readFrom) {
            super.readFrom(readFrom);
            return this;
        }

        @Override
        public LettucePoolingClientConfigurationBuilder clientName(String clientName) {
            super.clientName(clientName);
            return this;
        }

        public LettucePoolingClientConfigurationBuilder poolConfig(GenericObjectPoolConfig poolConfig) {
            Assert.notNull((Object)poolConfig, (String)"PoolConfig must not be null!");
            this.poolConfig = poolConfig;
            return this;
        }

        @Override
        public LettucePoolingClientConfiguration build() {
            return new DefaultLettucePoolingClientConfiguration(super.build(), this.poolConfig);
        }
    }
}

