/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2;

import com.alibaba.fastjson2.JSONB;
import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.JSONFactory;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.JSONWriter;
import com.alibaba.fastjson2.SymbolTable;
import com.alibaba.fastjson2.internal.trove.map.hash.TLongIntHashMap;
import com.alibaba.fastjson2.util.Fnv;
import com.alibaba.fastjson2.util.IOUtils;
import com.alibaba.fastjson2.util.JDKUtils;
import com.alibaba.fastjson2.util.TypeUtils;
import com.alibaba.fastjson2.writer.ObjectWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.DecimalFormat;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.UUID;

final class JSONWriterJSONB
extends JSONWriter {
    static final byte[] SHANGHAI_ZONE_ID_NAME_BYTES = JSONB.toBytes("Asia/Shanghai");
    static final byte[] OFFSET_8_ZONE_ID_NAME_BYTES = JSONB.toBytes("+08:00");
    private final JSONFactory.CacheItem cacheItem = JSONFactory.CACHE_ITEMS[System.identityHashCode(Thread.currentThread()) & JSONFactory.CACHE_ITEMS.length - 1];
    byte[] bytes;
    TLongIntHashMap symbols;
    int symbolIndex;
    private long rootTypeNameHash;

    JSONWriterJSONB(JSONWriter.Context ctx, SymbolTable symbolTable) {
        super(ctx, symbolTable, true, StandardCharsets.UTF_8);
        byte[] bytes = JSONFactory.BYTES_UPDATER.getAndSet(this.cacheItem, null);
        if (bytes == null) {
            bytes = new byte[8192];
        }
        this.bytes = bytes;
    }

    @Override
    public void close() {
        byte[] bytes = this.bytes;
        if (bytes.length < 0x800000) {
            JSONFactory.BYTES_UPDATER.lazySet(this.cacheItem, bytes);
        }
    }

    @Override
    public void writeAny(Object value) {
        if (value == null) {
            this.writeNull();
            return;
        }
        boolean fieldBased = (this.context.features & JSONWriter.Feature.FieldBased.mask) != 0L;
        Class<?> valueClass = value.getClass();
        ObjectWriter objectWriter = this.context.provider.getObjectWriter(valueClass, valueClass, fieldBased);
        if (this.isBeanToArray()) {
            objectWriter.writeArrayMappingJSONB(this, value, null, null, 0L);
        } else {
            objectWriter.writeJSONB(this, value, null, null, 0L);
        }
    }

    @Override
    public void startObject() {
        if (++this.level > this.context.maxLevel) {
            this.overflowLevel();
        }
        this.writeRaw((byte)-90);
    }

    @Override
    public void endObject() {
        --this.level;
        this.writeRaw((byte)-91);
    }

    @Override
    public void startArray() {
        throw new JSONException("unsupported operation");
    }

    @Override
    public void startArray(Object array, int size) {
        if (this.isWriteTypeInfo(array)) {
            this.writeTypeName(array.getClass().getName());
        }
        this.startArray(size);
    }

    @Override
    public void startArray(int size) {
        int off = this.off;
        byte[] bytes = this.bytes;
        if (off + 6 > bytes.length) {
            bytes = this.grow(off + 6);
        }
        this.off = JSONB.IO.startArray(bytes, off, size);
    }

    @Override
    public void startArray0() {
        this.writeRaw((byte)-108);
    }

    @Override
    public void startArray1() {
        this.writeRaw((byte)-107);
    }

    @Override
    public void startArray2() {
        this.writeRaw((byte)-106);
    }

    @Override
    public void startArray3() {
        this.writeRaw((byte)-105);
    }

    @Override
    public void startArray4() {
        this.writeRaw((byte)-104);
    }

    @Override
    public void startArray5() {
        this.writeRaw((byte)-103);
    }

    @Override
    public void startArray6() {
        this.writeRaw((byte)-102);
    }

    @Override
    public void startArray7() {
        this.writeRaw((byte)-101);
    }

    @Override
    public void startArray8() {
        this.writeRaw((byte)-100);
    }

    @Override
    public void startArray9() {
        this.writeRaw((byte)-99);
    }

    @Override
    public void startArray10() {
        this.writeRaw((byte)-98);
    }

    @Override
    public void startArray11() {
        this.writeRaw((byte)-97);
    }

    @Override
    public void startArray12() {
        this.writeRaw((byte)-96);
    }

    @Override
    public void startArray13() {
        this.writeRaw((byte)-95);
    }

    @Override
    public void startArray14() {
        this.writeRaw((byte)-94);
    }

    @Override
    public void startArray15() {
        this.writeRaw((byte)-93);
    }

    @Override
    public void writeRaw(byte b) {
        int off = this.off;
        this.grow1((int)off)[off] = b;
        this.off = off + 1;
    }

    @Override
    public void writeChar(char ch) {
        int off = this.off;
        byte[] bytes = this.bytes;
        if (off + 6 > bytes.length) {
            bytes = this.grow(off + 6);
        }
        bytes[off] = -112;
        this.off = JSONB.IO.writeInt32(bytes, off + 1, ch);
    }

    @Override
    public void writeName(String name) {
        this.writeString(name);
    }

    @Override
    public void writeNull() {
        this.writeRaw((byte)-81);
    }

    @Override
    public void writeStringNull() {
        this.writeRaw((byte)-81);
    }

    @Override
    public void endArray() {
    }

    @Override
    public void writeComma() {
        throw new JSONException("unsupported operation");
    }

    @Override
    protected void write0(char ch) {
        throw new JSONException("unsupported operation");
    }

    @Override
    public void writeString(boolean value) {
        this.writeString(Boolean.toString(value));
    }

    @Override
    public void writeString(byte value) {
        this.writeString(Integer.toString(value));
    }

    @Override
    public void writeString(short value) {
        this.writeString(Integer.toString(value));
    }

    @Override
    public void writeString(int value) {
        this.writeString(Integer.toString(value));
    }

    @Override
    public void writeString(long value) {
        this.writeString(Long.toString(value));
    }

    @Override
    public void writeString(boolean[] value) {
        if (value == null) {
            this.writeArrayNull();
            return;
        }
        this.startArray(value.length);
        for (int i = 0; i < value.length; ++i) {
            this.writeString(value[i]);
        }
    }

    @Override
    public void writeString(byte[] value) {
        if (value == null) {
            this.writeArrayNull();
            return;
        }
        this.startArray(value.length);
        for (int i = 0; i < value.length; ++i) {
            this.writeString(value[i]);
        }
    }

    @Override
    public void writeString(short[] value) {
        if (value == null) {
            this.writeArrayNull();
            return;
        }
        this.startArray(value.length);
        for (int i = 0; i < value.length; ++i) {
            this.writeString(value[i]);
        }
    }

    @Override
    public void writeString(int[] value) {
        if (value == null) {
            this.writeArrayNull();
            return;
        }
        this.startArray(value.length);
        for (int i = 0; i < value.length; ++i) {
            this.writeString(value[i]);
        }
    }

    @Override
    public void writeString(long[] value) {
        if (value == null) {
            this.writeArrayNull();
            return;
        }
        this.startArray(value.length);
        for (int i = 0; i < value.length; ++i) {
            this.writeString(value[i]);
        }
    }

    @Override
    public void writeString(float[] value) {
        if (value == null) {
            this.writeArrayNull();
            return;
        }
        this.startArray(value.length);
        for (int i = 0; i < value.length; ++i) {
            this.writeString(value[i]);
        }
    }

    @Override
    public void writeString(double[] value) {
        if (value == null) {
            this.writeArrayNull();
            return;
        }
        this.startArray(value.length);
        for (int i = 0; i < value.length; ++i) {
            this.writeString(value[i]);
        }
    }

    @Override
    public void writeString(char[] chars, int coff, int len, boolean quote) {
        if (chars == null) {
            this.writeNull();
            return;
        }
        boolean ascii = true;
        for (int i = 0; i < len; ++i) {
            if (chars[i + coff] <= '\u00ff') continue;
            ascii = false;
            break;
        }
        if (ascii) {
            int off = this.off;
            byte[] bytes = this.bytes;
            if (len <= 47) {
                bytes[off++] = (byte)(len + 73);
            } else {
                bytes[off] = 121;
                off = JSONB.IO.writeInt32(bytes, off + 1, len);
            }
            for (int i = 0; i < len; ++i) {
                bytes[off++] = (byte)chars[coff + i];
            }
            this.off = off;
            return;
        }
        this.writeString(new String(chars, coff, len));
    }

    @Override
    public void writeStringLatin1(byte[] value) {
        int off = this.off;
        int minCapacity = off + value.length + 6;
        byte[] bytes = this.bytes;
        if (minCapacity - bytes.length > 0) {
            bytes = this.grow(minCapacity);
        }
        this.off = JSONB.IO.writeStringLatin1(bytes, off, value);
    }

    @Override
    public void writeString(char[] chars) {
        if (chars == null) {
            this.writeNull();
            return;
        }
        this.writeString0(chars, 0, chars.length);
    }

    @Override
    public void writeString(char[] chars, int charsOff, int len) {
        if (chars == null) {
            this.writeNull();
            return;
        }
        this.writeString0(chars, charsOff, len);
    }

    private void writeString0(char[] chars, int coff, int strlen) {
        int minCapacity;
        int off = this.off;
        byte[] bytes = this.bytes;
        boolean ascii = true;
        if (strlen < 47) {
            minCapacity = off + 1 + strlen;
            if (minCapacity > bytes.length) {
                bytes = this.grow(minCapacity);
            }
            bytes[off++] = (byte)(strlen + 73);
            int end = coff + strlen;
            for (int i = coff; i < end; ++i) {
                char ch = chars[i];
                if (ch > '\u00ff') {
                    ascii = false;
                    break;
                }
                bytes[off++] = (byte)ch;
            }
            if (ascii) {
                this.off = off;
                return;
            }
            off = this.off;
        } else {
            ascii = IOUtils.isLatin1(chars, coff, strlen);
        }
        minCapacity = (ascii ? strlen : strlen * 3) + off + 6;
        if (minCapacity > bytes.length) {
            bytes = this.grow(minCapacity);
        }
        off = ascii ? JSONWriterJSONB.writeStringLatin1(bytes, off, chars, coff, strlen) : JSONWriterJSONB.writeUTF8(bytes, off, chars, coff, strlen);
        this.off = off;
    }

    private static int writeStringLatin1(byte[] bytes, int off, char[] chars, int coff, int strlen) {
        if (strlen <= 47) {
            bytes[off++] = (byte)(strlen + 73);
        } else {
            bytes[off] = 121;
            if (strlen <= 2047) {
                IOUtils.putShortBE(bytes, off + 1, (short)(14336 + strlen));
                off += 3;
            } else {
                off = JSONB.IO.writeInt32(bytes, off + 1, strlen);
            }
        }
        for (int i = 0; i < strlen; ++i) {
            bytes[off++] = (byte)chars[coff + i];
        }
        return off;
    }

    private static int writeUTF8(byte[] bytes, int off, char[] chars, int coff, int strlen) {
        int result;
        int utf8len;
        int utf8lenByteCnt;
        int maxSize = strlen * 3;
        int lenByteCnt = JSONWriterJSONB.sizeOfInt(maxSize);
        if (lenByteCnt != (utf8lenByteCnt = JSONWriterJSONB.sizeOfInt(utf8len = (result = IOUtils.encodeUTF8(chars, coff, strlen, bytes, off + lenByteCnt + 1)) - off - lenByteCnt - 1))) {
            System.arraycopy(bytes, off + lenByteCnt + 1, bytes, off + utf8lenByteCnt + 1, utf8len);
        }
        bytes[off] = 122;
        return JSONB.IO.writeInt32(bytes, off + 1, utf8len) + utf8len;
    }

    @Override
    public void writeString(String[] strings) {
        if (strings == null) {
            this.writeArrayNull();
            return;
        }
        this.startArray(strings.length);
        for (int i = 0; i < strings.length; ++i) {
            String item = strings[i];
            if (item == null) {
                this.writeStringNull();
                continue;
            }
            this.writeString(item);
        }
    }

    @Override
    public void writeSymbol(String str) {
        int ordinal;
        if (str == null) {
            this.writeNull();
            return;
        }
        if (this.symbolTable != null && (ordinal = this.symbolTable.getOrdinal(str)) >= 0) {
            this.writeRaw((byte)127);
            this.writeInt32(-ordinal);
            return;
        }
        this.writeString(str);
    }

    @Override
    public void writeTypeName(String typeName) {
        int off = this.off;
        byte[] bytes = this.grow1(off);
        bytes[off++] = -110;
        long hash = Fnv.hashCode64(typeName);
        int symbol = -1;
        if (this.symbolTable != null) {
            symbol = this.symbolTable.getOrdinalByHashCode(hash);
            if (symbol == -1 && this.symbols != null) {
                symbol = this.symbols.get(hash);
            }
        } else if (this.symbols != null) {
            symbol = this.symbols.get(hash);
        }
        if (symbol == -1) {
            if (this.symbols == null) {
                this.symbols = new TLongIntHashMap();
            }
        } else {
            if (off == bytes.length) {
                bytes = this.grow(off + 1);
            }
            this.off = JSONB.IO.writeInt32(bytes, off, symbol);
            return;
        }
        symbol = this.symbolIndex++;
        this.symbols.put(hash, symbol);
        this.off = off;
        this.writeString(typeName);
        this.writeInt32(symbol);
    }

    @Override
    public boolean writeTypeName(byte[] typeName, long hash) {
        int symbol;
        int symbol2;
        if (this.symbolTable != null && (symbol2 = this.symbolTable.getOrdinalByHashCode(hash)) != -1) {
            return this.writeTypeNameSymbol(symbol2);
        }
        boolean symbolExists = false;
        if (this.rootTypeNameHash == hash) {
            symbolExists = true;
            symbol = 0;
        } else if (this.symbols != null) {
            symbol = this.symbols.putIfAbsent(hash, this.symbolIndex);
            if (symbol != this.symbolIndex) {
                symbolExists = true;
            } else {
                ++this.symbolIndex;
            }
        } else {
            if ((symbol = this.symbolIndex++) == 0) {
                this.rootTypeNameHash = hash;
            }
            if (symbol != 0 || (this.context.features & JSONWriter.Feature.WriteNameAsSymbol.mask) != 0L) {
                this.symbols = new TLongIntHashMap(hash, symbol);
            }
        }
        if (symbolExists) {
            this.writeTypeNameSymbol(-symbol);
            return false;
        }
        int off = this.off;
        int minCapacity = off + 2 + typeName.length;
        byte[] bytes = this.bytes;
        if (minCapacity > bytes.length) {
            bytes = this.grow(minCapacity);
        }
        bytes[off] = -110;
        System.arraycopy(typeName, 0, bytes, off + 1, typeName.length);
        off += typeName.length + 1;
        if (symbol >= -16 && symbol <= 47) {
            bytes[off++] = (byte)symbol;
        } else {
            off = JSONB.IO.writeInt32(bytes, off, symbol);
        }
        this.off = off;
        return false;
    }

    private boolean writeTypeNameSymbol(int symbol) {
        int off = this.off;
        byte[] bytes = this.bytes;
        if (off + 7 > bytes.length) {
            bytes = this.grow(off + 7);
        }
        bytes[off] = -110;
        this.off = JSONB.IO.writeInt32(bytes, off + 1, -symbol);
        return false;
    }

    static int sizeOfInt(int i) {
        if (i >= -16 && i <= 47) {
            return 1;
        }
        if (i >= -2048 && i <= 2047) {
            return 2;
        }
        if (i >= -262144 && i <= 262143) {
            return 3;
        }
        return 5;
    }

    @Override
    public void writeString(List<String> list) {
        if (list == null) {
            this.writeArrayNull();
            return;
        }
        int size = list.size();
        this.startArray(size);
        if (JDKUtils.STRING_VALUE != null && JDKUtils.STRING_CODER != null) {
            int off = this.off;
            byte[] bytes = this.bytes;
            boolean LATIN = false;
            boolean latinAll = true;
            for (int i = 0; i < size; ++i) {
                String str = list.get(i);
                if (str == null) {
                    if (off == bytes.length) {
                        bytes = this.grow(off + 1);
                    }
                    bytes[off++] = -81;
                    continue;
                }
                int coder = JDKUtils.STRING_CODER.applyAsInt(str);
                if (coder != 0) {
                    latinAll = false;
                    break;
                }
                byte[] value = JDKUtils.STRING_VALUE.apply(str);
                if (off + value.length + 6 >= bytes.length) {
                    bytes = this.grow(off + value.length + 6);
                }
                off = JSONB.IO.writeStringLatin1(bytes, off, value);
            }
            if (latinAll) {
                this.off = off;
                return;
            }
        }
        for (int i = 0; i < size; ++i) {
            this.writeString(list.get(i));
        }
    }

    @Override
    public void writeString(String str) {
        if (str == null) {
            this.writeNull();
            return;
        }
        if (JDKUtils.STRING_VALUE != null) {
            byte[] value = JDKUtils.STRING_VALUE.apply(str);
            if (JDKUtils.STRING_CODER.applyAsInt(str) == 0) {
                this.writeStringLatin1(value);
                return;
            }
            if (this.tryWriteStringUTF16(value)) {
                return;
            }
        }
        this.writeString(JDKUtils.getCharArray(str));
    }

    @Override
    public void writeStringUTF16(byte[] value) {
        int off = this.off;
        int strlen = value.length;
        int minCapacity = off + strlen + 6;
        byte[] bytes = this.bytes;
        if (minCapacity > bytes.length) {
            bytes = this.grow(minCapacity);
        }
        this.off = JSONB.IO.writeStringUTF16(bytes, off, value);
    }

    boolean tryWriteStringUTF16(byte[] value) {
        int check_cnt = 128;
        if (check_cnt > value.length) {
            check_cnt = value.length;
        }
        if ((check_cnt & 1) == 1) {
            --check_cnt;
        }
        int asciiCount = 0;
        int i = 0;
        while (i + 2 <= check_cnt) {
            byte b0 = value[i];
            byte b1 = value[i + 1];
            if (b0 == 0 || b1 == 0) {
                ++asciiCount;
            }
            i += 2;
        }
        boolean utf16 = value.length != 0 && (asciiCount == 0 || (check_cnt >> 1) / asciiCount >= 3);
        int off = this.off;
        int minCapacity = off + 6 + value.length * 2 + 1;
        byte[] bytes = this.bytes;
        if (minCapacity > bytes.length) {
            bytes = this.grow(minCapacity);
        }
        if (!utf16) {
            int maxSize = value.length + (value.length >> 2);
            int lenByteCnt = JSONWriterJSONB.sizeOfInt(maxSize);
            int result = IOUtils.encodeUTF8(value, 0, value.length, bytes, off + lenByteCnt + 1);
            int utf8len = result - off - lenByteCnt - 1;
            if (utf8len > value.length) {
                utf16 = true;
            } else if (result != -1) {
                this.off = off + JSONWriterJSONB.writeUTF8(bytes, off, value, utf8len, asciiCount, lenByteCnt);
                return true;
            }
        }
        if (utf16) {
            this.off = off + JSONWriterJSONB.writeUTF16(bytes, off, value);
            return true;
        }
        return false;
    }

    private static int writeUTF8(byte[] bytes, int off, byte[] value, int utf8len, int asciiCount, int lenByteCnt) {
        int strtype;
        if (utf8len * 2 == value.length) {
            if (asciiCount <= 47) {
                bytes[off] = (byte)(73 + utf8len);
                System.arraycopy(bytes, off + 1 + lenByteCnt, bytes, off + 1, utf8len);
                return utf8len + 1;
            }
            strtype = 121;
        } else {
            strtype = 122;
        }
        int utf8lenByteCnt = JSONWriterJSONB.sizeOfInt(utf8len);
        if (lenByteCnt != utf8lenByteCnt) {
            System.arraycopy(bytes, off + lenByteCnt + 1, bytes, off + utf8lenByteCnt + 1, utf8len);
        }
        int start = off;
        bytes[off] = strtype;
        off = JSONB.IO.writeInt32(bytes, off + 1, utf8len);
        return off - start + utf8len;
    }

    private static int writeUTF16(byte[] bytes, int off, byte[] value) {
        int start = off;
        bytes[off] = JDKUtils.BIG_ENDIAN ? 125 : 124;
        off = JSONB.IO.writeInt32(bytes, off + 1, value.length);
        System.arraycopy(value, 0, bytes, off, value.length);
        return value.length + off - start;
    }

    @Override
    public final Object ensureCapacity(int minCapacity) {
        byte[] bytes = this.bytes;
        if (minCapacity >= bytes.length) {
            this.bytes = bytes = Arrays.copyOf(bytes, this.newCapacity(minCapacity, bytes.length));
        }
        return bytes;
    }

    private byte[] grow1(int off) {
        byte[] bytes = this.bytes;
        if (off == bytes.length) {
            bytes = this.grow(off + 1);
        }
        return bytes;
    }

    private byte[] grow(int minCapacity) {
        this.grow0(minCapacity);
        return this.bytes;
    }

    private void grow0(int minCapacity) {
        this.bytes = Arrays.copyOf(this.bytes, this.newCapacity(minCapacity, this.bytes.length));
    }

    @Override
    public void writeMillis(long millis) {
        int off = this.off;
        int minCapacity = off + 9;
        byte[] bytes = this.bytes;
        if (minCapacity > bytes.length) {
            bytes = this.grow(minCapacity);
        }
        if (millis % 1000L == 0L) {
            long minutes;
            long seconds = millis / 1000L;
            if (seconds >= Integer.MIN_VALUE && seconds <= Integer.MAX_VALUE) {
                int secondsInt = (int)seconds;
                bytes[off] = -84;
                IOUtils.putIntBE(bytes, off + 1, secondsInt);
                this.off = off + 5;
                return;
            }
            if (seconds % 60L == 0L && (minutes = seconds / 60L) >= Integer.MIN_VALUE && minutes <= Integer.MAX_VALUE) {
                int minutesInt = (int)minutes;
                bytes[off] = -83;
                IOUtils.putIntBE(bytes, off + 1, minutesInt);
                this.off = off + 5;
                return;
            }
        }
        bytes[off] = -85;
        IOUtils.putLongBE(bytes, off + 1, millis);
        this.off = off + 9;
    }

    @Override
    public void writeInt64(Long i) {
        int minCapacity = this.off + 9;
        byte[] bytes = this.bytes;
        if (minCapacity > bytes.length) {
            bytes = this.grow(minCapacity);
        }
        this.off = JSONB.IO.writeInt64(bytes, this.off, i, this.context.features);
    }

    @Override
    public void writeInt64(long val) {
        int minCapacity = this.off + 9;
        byte[] bytes = this.bytes;
        if (minCapacity > bytes.length) {
            bytes = this.grow(minCapacity);
        }
        this.off = JSONB.IO.writeInt64(bytes, this.off, val);
    }

    @Override
    public void writeInt64(long[] value) {
        if (value == null) {
            this.writeArrayNull();
            return;
        }
        int off = this.off;
        int size = value.length;
        int minCapacity = off + size * 9 + 5;
        byte[] bytes = this.bytes;
        if (minCapacity > bytes.length) {
            bytes = this.grow(minCapacity);
        }
        if (size <= 15) {
            bytes[off++] = (byte)(-108 + size);
        } else {
            bytes[off] = -92;
            off = JSONB.IO.writeInt32(bytes, off + 1, size);
        }
        for (int i = 0; i < value.length; ++i) {
            off = JSONB.IO.writeInt64(bytes, off, value[i]);
        }
        this.off = off;
    }

    @Override
    public void writeListInt64(List<Long> values) {
        byte[] bytes;
        if (values == null) {
            this.writeArrayNull();
            return;
        }
        int off = this.off;
        int size = values.size();
        int minCapacity = off + size * 9 + 5;
        if (minCapacity > (bytes = this.bytes).length) {
            bytes = this.grow(minCapacity);
        }
        if (size <= 15) {
            bytes[off++] = (byte)(-108 + size);
        } else {
            bytes[off] = -92;
            off = JSONB.IO.writeInt32(bytes, off + 1, size);
        }
        for (int i = 0; i < size; ++i) {
            Long item = values.get(i);
            if (item == null) {
                bytes[off++] = -81;
                continue;
            }
            off = JSONB.IO.writeInt64(bytes, off, item);
        }
        this.off = off;
    }

    @Override
    public void writeFloat(float value) {
        int off = this.off;
        int minCapacity = off + 5;
        byte[] bytes = this.bytes;
        if (minCapacity > bytes.length) {
            bytes = this.grow(minCapacity);
        }
        this.off = JSONB.IO.writeFloat(bytes, off, value);
    }

    @Override
    public void writeFloat(float[] values) {
        byte[] bytes;
        int off = this.off;
        int minCapacity = off + (values == null ? 1 : 5 + values.length * 5);
        if (minCapacity > (bytes = this.bytes).length) {
            bytes = this.grow(minCapacity);
        }
        this.off = JSONB.IO.writeFloat(bytes, off, values);
    }

    @Override
    public void writeDouble(double value) {
        int off = this.off;
        byte[] bytes = this.bytes;
        if (off + 9 > bytes.length) {
            bytes = this.grow(off + 9);
        }
        this.off = JSONB.IO.writeDouble(bytes, off, value);
    }

    @Override
    public void writeDouble(double[] values) {
        byte[] bytes;
        int off = this.off;
        int minCapacity = off + (values == null ? 1 : 5 + values.length * 9);
        if (minCapacity > (bytes = this.bytes).length) {
            bytes = this.grow(minCapacity);
        }
        this.off = JSONB.IO.writeDouble(bytes, off, values);
    }

    @Override
    public void writeInt16(short[] values) {
        if (values == null) {
            this.writeNull();
            return;
        }
        this.startArray(values.length);
        for (int i = 0; i < values.length; ++i) {
            this.writeInt32(values[i]);
        }
        this.endArray();
    }

    @Override
    public void writeInt32(int[] values) {
        if (values == null) {
            this.writeArrayNull();
            return;
        }
        int off = this.off;
        byte[] bytes = this.bytes;
        int size = values.length;
        int minCapacity = off + 6 + values.length * 5;
        if (minCapacity > bytes.length) {
            bytes = this.grow(minCapacity);
        }
        if (size <= 15) {
            bytes[off++] = (byte)(-108 + size);
        } else {
            bytes[off] = -92;
            off = JSONB.IO.writeInt32(bytes, off + 1, size);
        }
        for (int i = 0; i < values.length; ++i) {
            off = JSONB.IO.writeInt32(bytes, off, values[i]);
        }
        this.off = off;
    }

    @Override
    public void writeInt8(byte[] values) {
        if (values == null) {
            this.writeArrayNull();
            return;
        }
        int off = this.off;
        int size = values.length;
        int minCapacity = off + 6 + values.length * 2;
        byte[] bytes = this.bytes;
        if (minCapacity > bytes.length) {
            bytes = this.grow(minCapacity);
        }
        if (size <= 15) {
            bytes[off++] = (byte)(-108 + size);
        } else {
            bytes[off] = -92;
            off = JSONB.IO.writeInt32(bytes, off + 1, size);
        }
        for (byte val : values) {
            if (val < -16 || val > 47) {
                bytes[off++] = (byte)(56 + (val >> 8));
            }
            bytes[off++] = val;
        }
        this.off = off;
    }

    @Override
    public void writeInt8(byte val) {
        int off = this.off;
        byte[] bytes = this.bytes;
        if (off + 2 > bytes.length) {
            bytes = this.grow(off + 2);
        }
        this.off = JSONB.IO.writeInt8(bytes, off, val);
    }

    @Override
    public void writeInt16(short val) {
        int off = this.off;
        byte[] bytes = this.bytes;
        if (off + 3 > bytes.length) {
            bytes = this.grow(off + 3);
        }
        this.off = JSONB.IO.writeInt16(bytes, off, val);
    }

    @Override
    public void writeEnum(Enum e) {
        if (e == null) {
            this.writeNull();
            return;
        }
        if ((this.context.features & 0x6000L) != 0L) {
            this.writeString((this.context.features & JSONWriter.Feature.WriteEnumUsingToString.mask) != 0L ? e.toString() : e.name());
        } else {
            int ordinal = e.ordinal();
            int off = this.off;
            byte[] bytes = this.bytes;
            if (off + 5 > bytes.length) {
                bytes = this.grow(off + 5);
            }
            this.off = JSONB.IO.writeInt32(bytes, off, ordinal);
        }
    }

    @Override
    public void writeInt32(Integer i) {
        int off = this.off;
        int minCapacity = off + 5;
        byte[] bytes = this.bytes;
        if (minCapacity > bytes.length) {
            bytes = this.grow(minCapacity);
        }
        this.off = JSONB.IO.writeInt32(bytes, off, i, this.context.features);
    }

    @Override
    public void writeInt32(int val) {
        int off = this.off;
        int minCapacity = off + 5;
        byte[] bytes = this.bytes;
        if (minCapacity > bytes.length) {
            bytes = this.grow(minCapacity);
        }
        this.off = JSONB.IO.writeInt32(bytes, off, val);
    }

    @Override
    public void writeListInt32(List<Integer> values) {
        byte[] bytes;
        if (values == null) {
            this.writeArrayNull();
            return;
        }
        int off = this.off;
        int size = values.size();
        int minCapacity = off + size * 5 + 5;
        if (minCapacity > (bytes = this.bytes).length) {
            bytes = this.grow(minCapacity);
        }
        if (size <= 15) {
            bytes[off++] = (byte)(-108 + size);
        } else {
            bytes[off] = -92;
            off = JSONB.IO.writeInt32(bytes, off + 1, size);
        }
        for (int i = 0; i < size; ++i) {
            Integer item = values.get(i);
            if (item == null) {
                bytes[off++] = -81;
                continue;
            }
            off = JSONB.IO.writeInt32(bytes, off, item);
        }
        this.off = off;
    }

    @Override
    public void writeArrayNull() {
        this.writeRaw((this.context.features & WRITE_ARRAY_NULL_MASK) != 0L ? (byte)-108 : -81);
    }

    @Override
    public void writeArrayNull(long features) {
        this.writeRaw((features & WRITE_ARRAY_NULL_MASK) != 0L ? (byte)-108 : -81);
    }

    @Override
    public void writeRaw(String str) {
        throw new JSONException("unsupported operation");
    }

    @Override
    public void writeRaw(byte[] raw) {
        int off = this.off;
        int minCapacity = off + raw.length;
        byte[] bytes = this.bytes;
        if (minCapacity > bytes.length) {
            bytes = this.grow(minCapacity);
        }
        System.arraycopy(raw, 0, bytes, off, raw.length);
        this.off = off + raw.length;
    }

    @Override
    public void writeSymbol(int symbol) {
        int off = this.off;
        int minCapacity = off + 6;
        byte[] bytes = this.bytes;
        if (minCapacity > bytes.length) {
            bytes = this.grow(minCapacity);
        }
        bytes[off++] = 127;
        if (symbol >= -16 && symbol <= 47) {
            bytes[off++] = (byte)symbol;
        } else if (symbol >= -2048 && symbol <= 2047) {
            IOUtils.putShortBE(bytes, off, (short)(14336 + symbol));
            off += 2;
        } else {
            off = JSONB.IO.writeInt32(bytes, off, symbol);
        }
        this.off = off;
    }

    @Override
    public void writeNameRaw(byte[] name, long nameHash) {
        int symbol;
        int off = this.off;
        int minCapacity = off + 6 + name.length;
        byte[] bytes = this.bytes;
        if (minCapacity > bytes.length) {
            bytes = this.grow(minCapacity);
        }
        if (this.symbolTable == null || (symbol = this.symbolTable.getOrdinalByHashCode(nameHash)) == -1) {
            if ((this.context.features & JSONWriter.Feature.WriteNameAsSymbol.mask) == 0L) {
                System.arraycopy(name, 0, bytes, off, name.length);
                this.off = off + name.length;
                return;
            }
            boolean symbolExists = false;
            if (this.symbols != null) {
                symbol = this.symbols.putIfAbsent(nameHash, this.symbolIndex);
                if (symbol != this.symbolIndex) {
                    symbolExists = true;
                } else {
                    ++this.symbolIndex;
                }
            } else {
                this.symbols = new TLongIntHashMap();
                symbol = this.symbolIndex++;
                this.symbols.put(nameHash, symbol);
            }
            if (!symbolExists) {
                bytes[off++] = 127;
                System.arraycopy(name, 0, bytes, off, name.length);
                off += name.length;
                if (symbol >= -16 && symbol <= 47) {
                    bytes[off++] = (byte)symbol;
                } else {
                    off = JSONB.IO.writeInt32(bytes, off, symbol);
                }
                this.off = off;
                return;
            }
            symbol = -symbol;
        }
        bytes[off++] = 127;
        int intValue = -symbol;
        if (intValue >= -16 && intValue <= 47) {
            bytes[off++] = (byte)intValue;
        } else {
            off = JSONB.IO.writeInt32(bytes, off, intValue);
        }
        this.off = off;
    }

    @Override
    public void writeLocalDate(LocalDate date) {
        int off = this.off;
        byte[] bytes = this.bytes;
        if (off + 5 > bytes.length) {
            bytes = this.grow(off + 5);
        }
        this.off = JSONB.IO.writeLocalDate(bytes, off, date);
    }

    @Override
    public void writeLocalTime(LocalTime time) {
        int off = this.off;
        byte[] bytes = this.bytes;
        if (off + 9 > bytes.length) {
            bytes = this.grow(off + 9);
        }
        this.off = JSONB.IO.writeLocalTime(bytes, off, time);
    }

    @Override
    public void writeLocalDateTime(LocalDateTime dateTime) {
        int off = this.off;
        byte[] bytes = this.bytes;
        if (off + 13 > bytes.length) {
            bytes = this.grow(off + 13);
        }
        this.off = JSONB.IO.writeLocalDateTime(bytes, off, dateTime);
    }

    @Override
    public void writeZonedDateTime(ZonedDateTime dateTime) {
        if (dateTime == null) {
            this.writeNull();
            return;
        }
        int off = this.off;
        byte[] bytes = this.bytes;
        if (off + 13 > bytes.length) {
            bytes = this.grow(off + 13);
        }
        IOUtils.putIntBE(bytes, off, 0xAA000000 | dateTime.getYear() << 8 | dateTime.getMonthValue());
        IOUtils.putIntBE(bytes, off + 4, dateTime.getDayOfMonth() << 24 | dateTime.getHour() << 16 | dateTime.getMinute() << 8 | dateTime.getSecond());
        this.off = JSONB.IO.writeInt32(bytes, off + 8, dateTime.getNano());
        String zoneIdStr = dateTime.getZone().getId();
        if (zoneIdStr.equals("Asia/Shanghai")) {
            this.writeRaw(SHANGHAI_ZONE_ID_NAME_BYTES);
        } else {
            this.writeString(zoneIdStr);
        }
    }

    @Override
    public void writeOffsetDateTime(OffsetDateTime dateTime) {
        int off = this.off;
        int minCapacity = off + 21;
        byte[] bytes = this.bytes;
        if (minCapacity > bytes.length) {
            bytes = this.grow(minCapacity);
        }
        this.off = JSONB.IO.writeOffsetDateTime(bytes, off, dateTime);
    }

    @Override
    public void writeOffsetTime(OffsetTime offsetTime) {
        int off = this.off;
        int minCapacity = off + 21;
        byte[] bytes = this.bytes;
        if (minCapacity > bytes.length) {
            bytes = this.grow(minCapacity);
        }
        this.off = JSONB.IO.writeOffsetTime(bytes, off, offsetTime);
    }

    @Override
    public void writeInstant(Instant instant) {
        int off = this.off;
        byte[] bytes = this.bytes;
        if (off + 15 > bytes.length) {
            bytes = this.grow(off + 15);
        }
        this.off = JSONB.IO.writeInstant(bytes, off, instant);
    }

    @Override
    public void writeUUID(UUID value) {
        int off = this.off;
        byte[] bytes = this.bytes;
        if (off + 18 > bytes.length) {
            bytes = this.grow(off + 18);
        }
        this.off = JSONB.IO.writeUUID(bytes, off, value);
    }

    @Override
    public void writeBigInt(BigInteger value, long features) {
        if (value == null) {
            this.writeNull();
            return;
        }
        int off = this.off;
        byte[] bytes = this.bytes;
        if (TypeUtils.isInt64(value)) {
            if (off + 10 > bytes.length) {
                bytes = this.grow(off + 10);
            }
            bytes[off] = -70;
            this.off = JSONB.IO.writeInt64(bytes, off + 1, value.longValue());
            return;
        }
        byte[] valueBytes = value.toByteArray();
        int minCapacity = off + 5 + valueBytes.length;
        if (minCapacity > bytes.length) {
            bytes = this.grow(minCapacity);
        }
        bytes[off] = -69;
        off = JSONB.IO.writeInt32(bytes, off + 1, valueBytes.length);
        System.arraycopy(valueBytes, 0, bytes, off, valueBytes.length);
        this.off = off + valueBytes.length;
    }

    @Override
    public void writeBinary(byte[] binary) {
        if (binary == null) {
            this.writeNull();
            return;
        }
        int off = this.off;
        int len = binary.length;
        int minCapacity = off + 6 + len;
        byte[] bytes = this.bytes;
        if (minCapacity > bytes.length) {
            bytes = this.grow(minCapacity);
        }
        bytes[off] = -111;
        off = JSONB.IO.writeInt32(bytes, off + 1, len);
        System.arraycopy(binary, 0, bytes, off, len);
        this.off = off + len;
    }

    @Override
    public void writeDecimal(BigDecimal value, long features, DecimalFormat format) {
        if (value == null) {
            this.writeNull();
            return;
        }
        int precision = value.precision();
        int scale = value.scale();
        int off = this.off;
        byte[] bytes = this.bytes;
        if (off + 15 > bytes.length) {
            bytes = this.grow(off + 15);
        }
        if (precision < 19 && JDKUtils.FIELD_DECIMAL_INT_COMPACT_OFFSET != -1L) {
            long intCompact = JDKUtils.UNSAFE.getLong(value, JDKUtils.FIELD_DECIMAL_INT_COMPACT_OFFSET);
            if (scale == 0) {
                bytes[off] = -72;
                this.off = JSONB.IO.writeInt64(bytes, off + 1, intCompact);
                return;
            }
            bytes[off] = -71;
            off = JSONB.IO.writeInt32(bytes, off + 1, scale);
            off = intCompact >= Integer.MIN_VALUE && intCompact <= Integer.MAX_VALUE ? JSONB.IO.writeInt32(bytes, off, (int)intCompact) : JSONB.IO.writeInt64(bytes, off, intCompact);
            this.off = off;
            return;
        }
        BigInteger unscaledValue = value.unscaledValue();
        if (scale == 0 && TypeUtils.isInt64(unscaledValue)) {
            bytes[off] = -72;
            this.off = JSONB.IO.writeInt64(bytes, off + 1, unscaledValue.longValue());
            return;
        }
        bytes[off] = -71;
        off = JSONB.IO.writeInt32(bytes, off + 1, scale);
        if (TypeUtils.isInt32(unscaledValue)) {
            off = JSONB.IO.writeInt32(bytes, off, unscaledValue.intValue());
        } else if (TypeUtils.isInt64(unscaledValue)) {
            off = JSONB.IO.writeInt64(bytes, off, unscaledValue.longValue());
        } else {
            this.off = off;
            this.writeBigInt(unscaledValue, 0L);
            return;
        }
        this.off = off;
    }

    @Override
    public void writeBool(boolean value) {
        this.writeRaw(value ? (byte)-79 : -80);
    }

    @Override
    public void writeBool(boolean[] values) {
        byte[] bytes;
        int off = this.off;
        int minCapacity = off + (values == null ? 1 : 5 + values.length);
        if (minCapacity > (bytes = this.bytes).length) {
            bytes = this.grow(minCapacity);
        }
        this.off = JSONB.IO.writeBoolean(bytes, off, values);
    }

    @Override
    public void writeReference(String path) {
        int off = this.off;
        this.grow1((int)off)[off] = -109;
        this.off = off + 1;
        this.writeString(path == this.lastReference ? "#-1" : path);
        this.lastReference = path;
    }

    @Override
    public void writeDateTime14(int year, int month, int dayOfMonth, int hour, int minute, int second) {
        int off = this.off;
        byte[] bytes = this.bytes;
        if (off + 9 > bytes.length) {
            bytes = this.grow(off + 9);
        }
        IOUtils.putIntBE(bytes, off, 0xA8000000 | (year & 0xFFFF) << 8 | month);
        IOUtils.putIntBE(bytes, off + 4, dayOfMonth << 24 | hour << 16 | minute << 8 | second);
        bytes[off + 8] = 0;
        this.off = off + 9;
    }

    @Override
    public void writeDateTime19(int year, int month, int dayOfMonth, int hour, int minute, int second) {
        this.writeDateTime14(year, month, dayOfMonth, hour, minute, second);
    }

    @Override
    public void writeDateTimeISO8601(int year, int month, int dayOfMonth, int hour, int minute, int second, int millis, int offsetSeconds, boolean timeZone) {
        throw new JSONException("unsupported operation");
    }

    @Override
    public void writeDateYYYMMDD8(int year, int month, int dayOfMonth) {
        int off = this.off;
        byte[] bytes = this.bytes;
        if (off + 5 > bytes.length) {
            bytes = this.grow(off + 5);
        }
        bytes[off] = -87;
        IOUtils.putIntBE(bytes, off + 1, year << 16 | month << 8 | dayOfMonth);
        this.off = off + 5;
    }

    @Override
    public void writeDateYYYMMDD10(int year, int month, int dayOfMonth) {
        this.writeDateYYYMMDD8(year, month, dayOfMonth);
    }

    @Override
    public void writeTimeHHMMSS8(int hour, int minute, int second) {
        throw new JSONException("unsupported operation");
    }

    @Override
    public void writeBase64(byte[] bytes) {
        throw new JSONException("UnsupportedOperation");
    }

    @Override
    public void writeHex(byte[] bytes) {
        this.writeBinary(bytes);
    }

    @Override
    public void writeRaw(char ch) {
        throw new JSONException("UnsupportedOperation");
    }

    @Override
    public void writeNameRaw(byte[] bytes) {
        this.writeRaw(bytes);
    }

    @Override
    public void writeName2Raw(long name) {
        int off = this.off;
        byte[] bytes = this.bytes;
        if (off + 8 > bytes.length) {
            bytes = this.grow(off + 8);
        }
        JDKUtils.UNSAFE.putLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)off, name);
        this.off = off + 2;
    }

    @Override
    public void writeName3Raw(long name) {
        int off = this.off;
        byte[] bytes = this.bytes;
        if (off + 8 > bytes.length) {
            bytes = this.grow(off + 8);
        }
        JDKUtils.UNSAFE.putLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)off, name);
        this.off = off + 3;
    }

    @Override
    public void writeName4Raw(long name) {
        int off = this.off;
        byte[] bytes = this.bytes;
        if (off + 8 > bytes.length) {
            bytes = this.grow(off + 8);
        }
        JDKUtils.UNSAFE.putLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)off, name);
        this.off = off + 4;
    }

    @Override
    public void writeName5Raw(long name) {
        int off = this.off;
        byte[] bytes = this.bytes;
        if (off + 8 > bytes.length) {
            bytes = this.grow(off + 8);
        }
        JDKUtils.UNSAFE.putLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)off, name);
        this.off = off + 5;
    }

    @Override
    public void writeName6Raw(long name) {
        int off = this.off;
        byte[] bytes = this.bytes;
        if (off + 8 > bytes.length) {
            bytes = this.grow(off + 8);
        }
        JDKUtils.UNSAFE.putLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)off, name);
        this.off = off + 6;
    }

    @Override
    public void writeName7Raw(long name) {
        int off = this.off;
        byte[] bytes = this.bytes;
        if (off + 8 > bytes.length) {
            bytes = this.grow(off + 8);
        }
        JDKUtils.UNSAFE.putLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)off, name);
        this.off = off + 7;
    }

    @Override
    public void writeName8Raw(long name) {
        int off = this.off;
        byte[] bytes = this.bytes;
        if (off + 8 > bytes.length) {
            bytes = this.grow(off + 8);
        }
        JDKUtils.UNSAFE.putLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)off, name);
        this.off = off + 8;
    }

    @Override
    public void writeName9Raw(long name0, int name1) {
        int off = this.off;
        byte[] bytes = this.bytes;
        if (off + 12 > bytes.length) {
            bytes = this.grow(off + 12);
        }
        JDKUtils.UNSAFE.putLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)off, name0);
        JDKUtils.UNSAFE.putInt(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)off + 8L, name1);
        this.off = off + 9;
    }

    @Override
    public void writeName10Raw(long name0, long name1) {
        int off = this.off;
        byte[] bytes = this.bytes;
        if (off + 16 > bytes.length) {
            bytes = this.grow(off + 16);
        }
        JDKUtils.UNSAFE.putLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)off, name0);
        JDKUtils.UNSAFE.putLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)off + 8L, name1);
        this.off = off + 10;
    }

    @Override
    public void writeName11Raw(long name0, long name1) {
        int off = this.off;
        byte[] bytes = this.bytes;
        if (off + 16 > bytes.length) {
            bytes = this.grow(off + 16);
        }
        JDKUtils.UNSAFE.putLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)off, name0);
        JDKUtils.UNSAFE.putLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)off + 8L, name1);
        this.off = off + 11;
    }

    @Override
    public void writeName12Raw(long name0, long name1) {
        int off = this.off;
        byte[] bytes = this.bytes;
        if (off + 16 > bytes.length) {
            bytes = this.grow(off + 16);
        }
        JDKUtils.UNSAFE.putLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)off, name0);
        JDKUtils.UNSAFE.putLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)off + 8L, name1);
        this.off = off + 12;
    }

    @Override
    public void writeName13Raw(long name0, long name1) {
        int off = this.off;
        byte[] bytes = this.bytes;
        if (off + 16 > bytes.length) {
            bytes = this.grow(off + 16);
        }
        JDKUtils.UNSAFE.putLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)off, name0);
        JDKUtils.UNSAFE.putLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)off + 8L, name1);
        this.off = off + 13;
    }

    @Override
    public void writeName14Raw(long name0, long name1) {
        int off = this.off;
        byte[] bytes = this.bytes;
        if (off + 16 > bytes.length) {
            bytes = this.grow(off + 16);
        }
        JDKUtils.UNSAFE.putLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)off, name0);
        JDKUtils.UNSAFE.putLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)off + 8L, name1);
        this.off = off + 14;
    }

    @Override
    public void writeName15Raw(long name0, long name1) {
        int off = this.off;
        byte[] bytes = this.bytes;
        if (off + 16 > bytes.length) {
            bytes = this.grow(off + 16);
        }
        JDKUtils.UNSAFE.putLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)off, name0);
        JDKUtils.UNSAFE.putLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)off + 8L, name1);
        this.off = off + 15;
    }

    @Override
    public void writeName16Raw(long name0, long name1) {
        int off = this.off;
        byte[] bytes = this.bytes;
        if (off + 16 > bytes.length) {
            bytes = this.grow(off + 16);
        }
        JDKUtils.UNSAFE.putLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)off, name0);
        JDKUtils.UNSAFE.putLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)off + 8L, name1);
        this.off = off + 16;
    }

    @Override
    public void writeNameRaw(char[] chars) {
        throw new JSONException("UnsupportedOperation");
    }

    @Override
    public void writeNameRaw(char[] bytes, int offset, int len) {
        throw new JSONException("UnsupportedOperation");
    }

    @Override
    public void writeColon() {
        throw new JSONException("UnsupportedOperation");
    }

    @Override
    public void write(List array) {
        if (array == null) {
            this.writeArrayNull();
            return;
        }
        int size = array.size();
        this.startArray(size);
        for (int i = 0; i < array.size(); ++i) {
            Object item = array.get(i);
            this.writeAny(item);
        }
    }

    public void write(Map map) {
        if (map == null) {
            this.writeNull();
            return;
        }
        this.startObject();
        for (Map.Entry entry : map.entrySet()) {
            this.writeAny(entry.getKey());
            this.writeAny(entry.getValue());
        }
        this.endObject();
    }

    @Override
    public byte[] getBytes() {
        return Arrays.copyOf(this.bytes, this.off);
    }

    @Override
    public int size() {
        return this.off;
    }

    @Override
    public byte[] getBytes(Charset charset) {
        throw new JSONException("not support operator");
    }

    @Override
    public int flushTo(OutputStream to) throws IOException {
        int len = this.off;
        to.write(this.bytes, 0, this.off);
        this.off = 0;
        return len;
    }

    @Override
    public int flushTo(OutputStream out, Charset charset) {
        throw new JSONException("UnsupportedOperation");
    }

    public String toString() {
        if (this.off == 0) {
            return "<empty>";
        }
        byte[] jsonbBytes = this.getBytes();
        JSONReader reader = JSONReader.ofJSONB(jsonbBytes);
        JSONWriter writer = JSONWriter.of();
        try {
            Object object = reader.readAny();
            writer.writeAny(object);
            return writer.toString();
        }
        catch (Exception ex) {
            return JSONB.typeName(this.bytes[0]) + ", bytes length " + this.off;
        }
    }

    @Override
    public void println() {
    }
}

