/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.StringJoiner;
import springfox.documentation.service.Header;
import springfox.documentation.service.ParameterStyle;
import springfox.documentation.service.VendorExtension;

public class Encoding {
    private final String propertyRef;
    private final String contentType;
    private final ParameterStyle style;
    private final Boolean explode;
    private final Boolean allowReserved;
    private final Set<Header> headers = new HashSet<Header>();
    private final List<VendorExtension> extensions = new ArrayList<VendorExtension>();

    public Encoding(String propertyRef, String contentType, ParameterStyle style, Boolean explode, Boolean allowReserved, Set<Header> headers, Collection<VendorExtension> vendorExtensions) {
        this.contentType = contentType;
        this.style = style;
        this.explode = explode;
        this.allowReserved = allowReserved;
        this.propertyRef = propertyRef;
        this.headers.addAll(headers);
        this.extensions.addAll(vendorExtensions);
    }

    public String getContentType() {
        return this.contentType;
    }

    public ParameterStyle getStyle() {
        return this.style;
    }

    public Boolean getExplode() {
        return this.explode;
    }

    public Boolean getAllowReserved() {
        return this.allowReserved;
    }

    public Collection<Header> getHeaders() {
        return this.headers;
    }

    public Collection<VendorExtension> getExtensions() {
        return this.extensions;
    }

    public String getPropertyRef() {
        return this.propertyRef;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Encoding encoding = (Encoding)o;
        return Objects.equals(this.propertyRef, encoding.propertyRef) && Objects.equals(this.contentType, encoding.contentType) && this.style == encoding.style && Objects.equals(this.explode, encoding.explode) && Objects.equals(this.allowReserved, encoding.allowReserved) && Objects.equals(this.headers, encoding.headers) && Objects.equals(this.extensions, encoding.extensions);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.propertyRef, this.contentType, this.style, this.explode, this.allowReserved, this.headers, this.extensions});
    }

    public String toString() {
        return new StringJoiner(", ", Encoding.class.getSimpleName() + "[", "]").add("contentType='" + this.contentType + "'").add("style=" + (Object)((Object)this.style)).add("explode=" + this.explode).add("allowReserved=" + this.allowReserved).add("headers=" + this.headers).add("extensions=" + this.extensions).toString();
    }
}

