/*
 * Decompiled with CFR 0.152.
 */
package springfox.bean.validators.plugins.parameter;

import java.util.Optional;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import springfox.bean.validators.plugins.RangeAnnotations;
import springfox.documentation.common.Compatibility;
import springfox.documentation.schema.ElementFacet;
import springfox.documentation.schema.NumericElementFacet;
import springfox.documentation.service.AllowableRangeValues;
import springfox.documentation.service.AllowableValues;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spi.service.ExpandedParameterBuilderPlugin;
import springfox.documentation.spi.service.contexts.ParameterExpansionContext;

@Component
@Order(value=-2147483148)
public class ExpandedParameterMinMaxAnnotationPlugin
implements ExpandedParameterBuilderPlugin {
    private static final Logger LOG = LoggerFactory.getLogger(ExpandedParameterMinMaxAnnotationPlugin.class);

    public boolean supports(DocumentationType delimiter) {
        return true;
    }

    public void apply(ParameterExpansionContext context) {
        Optional min = context.findAnnotation(Min.class);
        Optional max = context.findAnnotation(Max.class);
        if (min.isPresent() || max.isPresent()) {
            Compatibility<AllowableRangeValues, NumericElementFacet> values = RangeAnnotations.allowableRange(min, max);
            LOG.debug("Adding allowable range: min({}) - max({}}", (Object)values.getLegacy().map(AllowableRangeValues::getMin).orElse("<empty>"), (Object)values.getLegacy().map(AllowableRangeValues::getMax).orElse("<empty>"));
            context.getParameterBuilder().allowableValues((AllowableValues)values.getLegacy().orElse(null));
            LOG.debug("Adding numeric element facet: {}", (Object)values.getModern().map(NumericElementFacet::toString).orElse("<empty>"));
            context.getRequestParameterBuilder().query(q -> q.numericFacet(c -> c.copyOf((ElementFacet)values.getModern().orElse(null))));
        }
    }
}

