/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.dialect.db2.parser;

import com.alibaba.druid.DbType;
import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLObject;
import com.alibaba.druid.sql.ast.SQLOrderBy;
import com.alibaba.druid.sql.ast.statement.SQLSelectGroupByClause;
import com.alibaba.druid.sql.ast.statement.SQLSelectQuery;
import com.alibaba.druid.sql.ast.statement.SQLSelectQueryBlock;
import com.alibaba.druid.sql.dialect.db2.ast.stmt.DB2SelectQueryBlock;
import com.alibaba.druid.sql.dialect.db2.parser.DB2ExprParser;
import com.alibaba.druid.sql.parser.Lexer;
import com.alibaba.druid.sql.parser.ParserException;
import com.alibaba.druid.sql.parser.SQLExprParser;
import com.alibaba.druid.sql.parser.SQLSelectListCache;
import com.alibaba.druid.sql.parser.SQLSelectParser;
import com.alibaba.druid.sql.parser.Token;
import com.alibaba.druid.util.FnvHash;

public class DB2SelectParser
extends SQLSelectParser {
    public DB2SelectParser(SQLExprParser exprParser) {
        super(exprParser);
        this.dbType = DbType.db2;
    }

    public DB2SelectParser(SQLExprParser exprParser, SQLSelectListCache selectListCache) {
        super(exprParser, selectListCache);
        this.dbType = DbType.db2;
    }

    public DB2SelectParser(String sql) {
        this(new DB2ExprParser(sql));
    }

    protected SQLExprParser createExprParser() {
        return new DB2ExprParser(this.lexer);
    }

    @Override
    public SQLSelectQuery query(SQLObject parent, boolean acceptUnion) {
        DB2SelectQueryBlock queryBlock;
        block25: {
            if (this.lexer.token() == Token.LPAREN) {
                this.lexer.nextToken();
                SQLSelectQuery select = this.query();
                this.accept(Token.RPAREN);
                return this.queryRest(select, acceptUnion);
            }
            this.accept(Token.SELECT);
            if (this.lexer.token() == Token.COMMENT) {
                this.lexer.nextToken();
            }
            queryBlock = new DB2SelectQueryBlock();
            if (this.lexer.token() == Token.DISTINCT) {
                queryBlock.setDistionOption(2);
                this.lexer.nextToken();
            } else if (this.lexer.token() == Token.UNIQUE) {
                queryBlock.setDistionOption(3);
                this.lexer.nextToken();
            } else if (this.lexer.token() == Token.ALL) {
                queryBlock.setDistionOption(1);
                this.lexer.nextToken();
            }
            this.parseSelectList(queryBlock);
            if (this.lexer.token() == Token.INTO) {
                this.lexer.nextToken();
                SQLExpr expr = this.expr();
                if (this.lexer.token() != Token.COMMA) {
                    queryBlock.setInto(expr);
                }
            }
            this.parseFrom(queryBlock);
            this.parseWhere(queryBlock);
            this.parseHierachical(queryBlock);
            this.parseGroupBy(queryBlock);
            if (this.lexer.token() == Token.ORDER) {
                SQLOrderBy orderBy = this.parseOrderBy();
                queryBlock.setOrderBy(orderBy);
            }
            while (true) {
                if (this.lexer.token() == Token.FETCH) {
                    this.lexer.nextToken();
                    this.accept(Token.FIRST);
                    SQLExpr first = this.exprParser.primary();
                    queryBlock.setFirst(first);
                    if (this.lexer.identifierEquals("ROW") || this.lexer.identifierEquals("ROWS")) {
                        this.lexer.nextToken();
                    }
                    this.accept(Token.ONLY);
                    continue;
                }
                if (this.lexer.token() == Token.WITH) {
                    this.lexer.nextToken();
                    if (this.lexer.identifierEquals("RR")) {
                        queryBlock.setIsolation(DB2SelectQueryBlock.Isolation.RR);
                        this.parseLockRequest(queryBlock);
                    } else if (this.lexer.identifierEquals("RS")) {
                        queryBlock.setIsolation(DB2SelectQueryBlock.Isolation.RS);
                        this.parseLockRequest(queryBlock);
                    } else if (this.lexer.identifierEquals("CS")) {
                        queryBlock.setIsolation(DB2SelectQueryBlock.Isolation.CS);
                    } else if (this.lexer.identifierEquals("UR")) {
                        queryBlock.setIsolation(DB2SelectQueryBlock.Isolation.UR);
                    } else {
                        throw new ParserException("TODO. " + this.lexer.info());
                    }
                    this.lexer.nextToken();
                    continue;
                }
                if (this.lexer.token() != Token.FOR) break;
                this.lexer.nextToken();
                if (this.lexer.token() == Token.UPDATE) {
                    queryBlock.setForUpdate(true);
                    this.lexer.nextToken();
                    continue;
                }
                this.acceptIdentifier("READ");
                this.accept(Token.ONLY);
                queryBlock.setForReadOnly(true);
            }
            if (this.lexer.token() != Token.OPTIMIZE) break block25;
            this.lexer.nextToken();
            this.accept(Token.FOR);
            queryBlock.setOptimizeFor(this.expr());
            if (this.lexer.identifierEquals("ROW")) {
                this.lexer.nextToken();
            } else {
                this.acceptIdentifier("ROWS");
            }
        }
        return this.queryRest(queryBlock, acceptUnion);
    }

    private void parseLockRequest(DB2SelectQueryBlock queryBlock) {
        this.lexer.nextToken();
        this.accept(Token.USE);
        this.accept(Token.AND);
        if (!this.lexer.identifierEquals("KEEP")) {
            throw new ParserException("TODO. " + this.lexer.info());
        }
        this.lexer.nextToken();
        DB2SelectQueryBlock.LockRequest lockRequest = null;
        switch (this.lexer.token()) {
            case SHARE: {
                lockRequest = DB2SelectQueryBlock.LockRequest.SHARE;
                break;
            }
            case UPDATE: {
                lockRequest = DB2SelectQueryBlock.LockRequest.UPDATE;
                break;
            }
            case EXCLUSIVE: {
                lockRequest = DB2SelectQueryBlock.LockRequest.EXCLUSIVE;
                break;
            }
            default: {
                throw new ParserException("TODO. " + this.lexer.info());
            }
        }
        this.lexer.nextToken();
        if (!this.lexer.identifierEquals("LOCKS")) {
            throw new ParserException("TODO. " + this.lexer.info());
        }
        queryBlock.setLockRequest(lockRequest);
    }

    @Override
    protected void parseOrderByWith(SQLSelectGroupByClause groupBy, SQLSelectQueryBlock queryBlock) {
        Lexer.SavePoint mark = this.lexer.mark();
        this.lexer.nextToken();
        if (this.lexer.identifierEquals(FnvHash.Constants.CUBE)) {
            this.lexer.nextToken();
            groupBy.setWithCube(true);
        } else if (this.lexer.identifierEquals(FnvHash.Constants.ROLLUP)) {
            this.lexer.nextToken();
            groupBy.setWithRollUp(true);
        } else if (this.lexer.identifierEquals(FnvHash.Constants.RS)) {
            this.lexer.nextToken();
            ((DB2SelectQueryBlock)queryBlock).setIsolation(DB2SelectQueryBlock.Isolation.RS);
        } else if (this.lexer.identifierEquals(FnvHash.Constants.RR)) {
            this.lexer.nextToken();
            ((DB2SelectQueryBlock)queryBlock).setIsolation(DB2SelectQueryBlock.Isolation.RR);
        } else if (this.lexer.identifierEquals(FnvHash.Constants.CS)) {
            this.lexer.nextToken();
            ((DB2SelectQueryBlock)queryBlock).setIsolation(DB2SelectQueryBlock.Isolation.CS);
        } else if (this.lexer.identifierEquals(FnvHash.Constants.UR)) {
            this.lexer.nextToken();
            ((DB2SelectQueryBlock)queryBlock).setIsolation(DB2SelectQueryBlock.Isolation.UR);
        } else {
            this.lexer.reset(mark);
        }
    }
}

