/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.writer;

import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.JSONWriter;
import com.alibaba.fastjson2.util.JDKUtils;
import com.alibaba.fastjson2.writer.FieldWriter;
import java.lang.reflect.Field;
import java.lang.reflect.Type;

class FieldWriterFloatField<T>
extends FieldWriter<T> {
    protected FieldWriterFloatField(String name, int ordinal, long features, String format, String label, Field field) {
        super(name, ordinal, features, format, null, label, (Type)((Object)Float.class), Float.class, field, null);
    }

    @Override
    public Object getFieldValue(Object object) {
        if (object == null) {
            throw new JSONException("field.get error, " + this.fieldName);
        }
        try {
            Object value = this.fieldOffset != -1L && !this.fieldClass.isPrimitive() ? JDKUtils.UNSAFE.getObject(object, this.fieldOffset) : this.field.get(object);
            return value;
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new JSONException("field.get error, " + this.fieldName, e);
        }
    }

    @Override
    public boolean write(JSONWriter jsonWriter, T object) {
        Float value = (Float)this.getFieldValue((Object)object);
        if (value == null) {
            return this.writeFloatNull(jsonWriter);
        }
        this.writeFieldName(jsonWriter);
        float floatValue = value.floatValue();
        if (this.decimalFormat != null) {
            jsonWriter.writeFloat(floatValue, this.decimalFormat);
        } else {
            jsonWriter.writeFloat(floatValue);
        }
        return true;
    }

    @Override
    public void writeValue(JSONWriter jsonWriter, T object) {
        Float value = (Float)this.getFieldValue((Object)object);
        if (value == null) {
            jsonWriter.writeNumberNull();
        } else {
            float floatValue = value.floatValue();
            if (this.decimalFormat != null) {
                jsonWriter.writeFloat(floatValue, this.decimalFormat);
            } else {
                jsonWriter.writeFloat(floatValue);
            }
        }
    }
}

