/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.builders;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import springfox.documentation.builders.ElementFacetBuilder;
import springfox.documentation.schema.ElementFacet;
import springfox.documentation.schema.EnumerationFacet;
import springfox.documentation.service.AllowableListValues;
import springfox.documentation.service.AllowableValues;

public class EnumerationElementFacetBuilder
implements ElementFacetBuilder {
    private final Set<String> allowedValues = new HashSet<String>();

    public EnumerationElementFacetBuilder allowedValues(Collection<String> allowedValues) {
        this.allowedValues.addAll(allowedValues);
        return this;
    }

    public EnumerationElementFacetBuilder allowedValues(AllowableValues allowedValues) {
        if (!EnumerationElementFacetBuilder.from(allowedValues).isEmpty()) {
            this.allowedValues.clear();
            this.allowedValues.addAll(EnumerationElementFacetBuilder.from(allowedValues));
        }
        return this;
    }

    @Override
    public EnumerationFacet build() {
        if (this.allowedValues.isEmpty()) {
            return null;
        }
        return new EnumerationFacet(this.allowedValues);
    }

    @Override
    public EnumerationElementFacetBuilder copyOf(ElementFacet facet) {
        if (!(facet instanceof EnumerationFacet)) {
            return this;
        }
        EnumerationFacet other = (EnumerationFacet)facet;
        return this.allowedValues(other.getAllowedValues());
    }

    public static Set<String> from(AllowableValues allowableValues) {
        if (allowableValues instanceof AllowableListValues) {
            return new HashSet<String>(((AllowableListValues)allowableValues).getValues());
        }
        return new HashSet<String>();
    }
}

