/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jsqlparser.expression;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.ExpressionVisitor;
import net.sf.jsqlparser.parser.ASTNodeAccessImpl;

public final class StringValue
extends ASTNodeAccessImpl
implements Expression {
    private String value = "";
    private String prefix = null;
    public static final List<String> ALLOWED_PREFIXES = Arrays.asList("N", "U", "E", "R", "B", "RB", "_utf8");

    public StringValue() {
    }

    public StringValue(String escapedValue) {
        if (escapedValue.length() >= 2 && escapedValue.startsWith("'") && escapedValue.endsWith("'")) {
            this.value = escapedValue.substring(1, escapedValue.length() - 1);
            return;
        }
        if (escapedValue.length() > 2) {
            for (String p : ALLOWED_PREFIXES) {
                if (escapedValue.length() <= p.length() || !escapedValue.substring(0, p.length()).equalsIgnoreCase(p) || escapedValue.charAt(p.length()) != '\'') continue;
                this.prefix = p;
                this.value = escapedValue.substring(p.length() + 1, escapedValue.length() - 1);
                return;
            }
        }
        this.value = escapedValue;
    }

    public String getValue() {
        return this.value;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getNotExcapedValue() {
        StringBuilder buffer = new StringBuilder(this.value);
        int index = 0;
        int deletesNum = 0;
        while ((index = this.value.indexOf("''", index)) != -1) {
            buffer.deleteCharAt(index - deletesNum);
            index += 2;
            ++deletesNum;
        }
        return buffer.toString();
    }

    public void setValue(String string) {
        this.value = string;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    @Override
    public void accept(ExpressionVisitor expressionVisitor) {
        expressionVisitor.visit(this);
    }

    public String toString() {
        return (this.prefix != null ? this.prefix : "") + "'" + this.value + "'";
    }

    public StringValue withPrefix(String prefix) {
        this.setPrefix(prefix);
        return this;
    }

    public StringValue withValue(String value) {
        this.setValue(value);
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StringValue that = (StringValue)o;
        return Objects.equals(this.value, that.value) && Objects.equals(this.prefix, that.prefix);
    }

    public int hashCode() {
        return Objects.hash(this.value, this.prefix);
    }
}

