/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.spring.web.plugins;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import springfox.documentation.spi.service.DocumentationPlugin;

class DuplicateGroupsDetector {
    private DuplicateGroupsDetector() {
        throw new UnsupportedOperationException();
    }

    public static void ensureNoDuplicateGroups(List<DocumentationPlugin> allPlugins) throws IllegalStateException {
        Map plugins = allPlugins.stream().collect(Collectors.groupingBy(input -> Optional.ofNullable(input.getGroupName()).orElse("default"), LinkedHashMap::new, Collectors.toList()));
        Iterable duplicateGroups = plugins.entrySet().stream().filter(input -> ((List)input.getValue()).size() > 1).map(Map.Entry::getKey).collect(Collectors.toList());
        if (StreamSupport.stream(duplicateGroups.spliterator(), false).count() > 0L) {
            throw new IllegalStateException(String.format("Multiple Dockets with the same group name are not supported. The following duplicate groups were discovered. %s", String.join((CharSequence)",", duplicateGroups)));
        }
    }
}

