/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2;

import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.JSONFactory;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONWriter;
import com.alibaba.fastjson2.util.IOUtils;
import com.alibaba.fastjson2.util.JDKUtils;
import com.alibaba.fastjson2.util.NumberUtils;
import com.alibaba.fastjson2.util.StringUtils;
import com.alibaba.fastjson2.util.TypeUtils;
import com.alibaba.fastjson2.writer.ObjectWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.DecimalFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.UUID;

final class JSONWriterUTF8
extends JSONWriter {
    static final long REF;
    static final short QUOTE2_COLON;
    static final short QUOTE_COLON;
    final JSONFactory.CacheItem cacheItem;
    byte[] bytes;
    private final long byteVectorQuote;

    JSONWriterUTF8(JSONWriter.Context ctx) {
        super(ctx, null, false, StandardCharsets.UTF_8);
        int cacheIndex = System.identityHashCode(Thread.currentThread()) & JSONFactory.CACHE_ITEMS.length - 1;
        this.cacheItem = JSONFactory.CACHE_ITEMS[cacheIndex];
        byte[] bytes = JSONFactory.BYTES_UPDATER.getAndSet(this.cacheItem, null);
        if (bytes == null) {
            bytes = new byte[8192];
        }
        this.bytes = bytes;
        this.byteVectorQuote = this.useSingleQuote ? -2821266740684990248L : -2459565876494606883L;
    }

    @Override
    public final void writeNull() {
        int off = this.off;
        byte[] bytes = this.bytes;
        if (off + 4 > bytes.length) {
            bytes = this.grow(off + 4);
        }
        IOUtils.putNULL(bytes, off);
        this.off = off + 4;
    }

    @Override
    public final void writeReference(String path) {
        this.lastReference = path;
        int off = this.off;
        byte[] bytes = this.bytes;
        if (off + 8 > bytes.length) {
            bytes = this.grow(off + 8);
        }
        JDKUtils.UNSAFE.putLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)off, REF);
        this.off = off + 8;
        this.writeString(path);
        this.writeRaw((byte)125);
    }

    @Override
    public final void writeBase64(byte[] value) {
        int i;
        int off = this.off;
        int charsLen = (value.length - 1) / 3 + 1 << 2;
        int minCapacity = off + charsLen + 2;
        byte[] bytes = this.bytes;
        if (minCapacity > bytes.length) {
            bytes = this.grow(minCapacity);
        }
        bytes[off++] = (byte)this.quote;
        int eLen = value.length / 3 * 3;
        int s = 0;
        while (s < eLen) {
            i = (value[s++] & 0xFF) << 16 | (value[s++] & 0xFF) << 8 | value[s++] & 0xFF;
            bytes[off] = (byte)JSONFactory.CA[i >>> 18 & 0x3F];
            bytes[off + 1] = (byte)JSONFactory.CA[i >>> 12 & 0x3F];
            bytes[off + 2] = (byte)JSONFactory.CA[i >>> 6 & 0x3F];
            bytes[off + 3] = (byte)JSONFactory.CA[i & 0x3F];
            off += 4;
        }
        int left = value.length - eLen;
        if (left > 0) {
            i = (value[eLen] & 0xFF) << 10 | (left == 2 ? (value[value.length - 1] & 0xFF) << 2 : 0);
            bytes[off] = (byte)JSONFactory.CA[i >> 12];
            bytes[off + 1] = (byte)JSONFactory.CA[i >>> 6 & 0x3F];
            bytes[off + 2] = left == 2 ? (int)JSONFactory.CA[i & 0x3F] : 61;
            bytes[off + 3] = 61;
            off += 4;
        }
        bytes[off] = (byte)this.quote;
        this.off = off + 1;
    }

    @Override
    public final void writeHex(byte[] values) {
        if (values == null) {
            this.writeNull();
            return;
        }
        int off = this.off;
        int charsLen = values.length * 2 + 3;
        int minCapacity = off + charsLen + 2;
        byte[] bytes = this.bytes;
        if (minCapacity > bytes.length) {
            bytes = this.grow(minCapacity);
        }
        IOUtils.putShortLE(bytes, off, (short)10104);
        off += 2;
        for (int i = 0; i < values.length; ++i) {
            IOUtils.putShortLE(bytes, off, IOUtils.hex2U(values[i]));
            off += 2;
        }
        bytes[off] = 39;
        this.off = off + 1;
    }

    @Override
    public final void close() {
        byte[] bytes = this.bytes;
        if (bytes.length > 0x800000) {
            return;
        }
        JSONFactory.BYTES_UPDATER.lazySet(this.cacheItem, bytes);
    }

    @Override
    public final int size() {
        return this.off;
    }

    @Override
    public final byte[] getBytes() {
        return Arrays.copyOf(this.bytes, this.off);
    }

    @Override
    public final byte[] getBytes(Charset charset) {
        if (charset == StandardCharsets.UTF_8) {
            return Arrays.copyOf(this.bytes, this.off);
        }
        return this.toString().getBytes(charset);
    }

    @Override
    public final int flushTo(OutputStream to) throws IOException {
        int off = this.off;
        if (off > 0) {
            to.write(this.bytes, 0, off);
            this.off = 0;
        }
        return off;
    }

    @Override
    protected final void write0(char c) {
        int off = this.off;
        if (off == this.bytes.length) {
            this.grow0(off + 1);
        }
        this.bytes[off] = (byte)c;
        this.off = off + 1;
    }

    @Override
    public final void writeColon() {
        int off = this.off;
        this.grow1((int)off)[off] = 58;
        this.off = off + 1;
    }

    @Override
    public final void startObject() {
        if (++this.level > this.context.maxLevel) {
            this.overflowLevel();
        }
        this.startObject = true;
        int off = this.off;
        int minCapacity = off + 3 + this.pretty * this.level;
        byte[] bytes = this.bytes;
        if (minCapacity > bytes.length) {
            bytes = this.grow(minCapacity);
        }
        bytes[off++] = 123;
        if (this.pretty != 0) {
            off = this.indent(bytes, off);
        }
        this.off = off;
    }

    @Override
    public final void endObject() {
        byte[] bytes;
        --this.level;
        int off = this.off;
        int minCapacity = off + 1 + (this.pretty == 0 ? 0 : this.pretty * this.level + 1);
        if (minCapacity > (bytes = this.bytes).length) {
            bytes = this.grow(minCapacity);
        }
        if (this.pretty != 0) {
            off = this.indent(bytes, off);
        }
        bytes[off] = 125;
        this.off = off + 1;
        this.startObject = false;
    }

    @Override
    public final void writeComma() {
        this.startObject = false;
        int off = this.off;
        int minCapacity = off + 2 + this.pretty * this.level;
        byte[] bytes = this.bytes;
        if (minCapacity > bytes.length) {
            bytes = this.grow(minCapacity);
        }
        bytes[off++] = 44;
        if (this.pretty != 0) {
            off = this.indent(bytes, off);
        }
        this.off = off;
    }

    @Override
    public final void startArray() {
        byte[] bytes;
        int off;
        int minCapacity;
        if (++this.level > this.context.maxLevel) {
            this.overflowLevel();
        }
        if ((minCapacity = (off = this.off) + 3 + this.pretty * this.level) > (bytes = this.bytes).length) {
            bytes = this.grow(minCapacity);
        }
        bytes[off++] = 91;
        if (this.pretty != 0) {
            off = this.indent(bytes, off);
        }
        this.off = off;
    }

    @Override
    public final void endArray() {
        byte[] bytes;
        --this.level;
        int off = this.off;
        int minCapacity = off + 1 + (this.pretty == 0 ? 0 : this.pretty * this.level + 1);
        if (minCapacity > (bytes = this.bytes).length) {
            bytes = this.grow(minCapacity);
        }
        if (this.pretty != 0) {
            off = this.indent(bytes, off);
        }
        bytes[off] = 93;
        this.off = off + 1;
        this.startObject = false;
    }

    @Override
    public final void writeString(String[] strings) {
        if (this.pretty != 0 || strings == null) {
            super.writeString(strings);
            return;
        }
        int off = this.off;
        byte[] bytes = this.grow1(off);
        bytes[off] = 91;
        this.off = off + 1;
        for (int i = 0; i < strings.length; ++i) {
            if (i != 0) {
                off = this.off;
                bytes = this.grow1(off);
                bytes[off] = 44;
                this.off = off + 1;
            }
            this.writeString(strings[i]);
        }
        off = this.off;
        bytes = this.grow1(off);
        bytes[off] = 93;
        this.off = off + 1;
    }

    @Override
    public final void writeString(List<String> list) {
        if (this.pretty != 0) {
            super.writeString(list);
            return;
        }
        int off = this.off;
        byte[] bytes = this.grow1(off);
        bytes[off] = 91;
        this.off = off + 1;
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            String str;
            if (i != 0) {
                off = this.off;
                bytes = this.grow1(off);
                bytes[off] = 44;
                this.off = off + 1;
            }
            if ((str = list.get(i)) == null) {
                this.writeStringNull();
                continue;
            }
            if (JDKUtils.STRING_VALUE != null) {
                byte[] value = JDKUtils.STRING_VALUE.apply(str);
                if (JDKUtils.STRING_CODER.applyAsInt(str) == 0) {
                    this.writeStringLatin1(value);
                    continue;
                }
                this.writeStringUTF16(value);
                continue;
            }
            this.writeStringJDK8(str);
        }
        off = this.off;
        bytes = this.grow1(off);
        bytes[off] = 93;
        this.off = off + 1;
    }

    @Override
    public final void writeString(boolean value) {
        byte quote = (byte)this.quote;
        this.bytes[this.off++] = quote;
        this.writeBool(value);
        this.bytes[this.off++] = quote;
    }

    @Override
    public final void writeString(byte value) {
        boolean writeAsString;
        boolean bl = writeAsString = (this.context.features & JSONWriter.Feature.WriteNonStringValueAsString.mask) == 0L;
        if (writeAsString) {
            this.writeQuote();
        }
        this.writeInt8(value);
        if (writeAsString) {
            this.writeQuote();
        }
    }

    @Override
    public final void writeString(short value) {
        boolean writeAsString;
        boolean bl = writeAsString = (this.context.features & JSONWriter.Feature.WriteNonStringValueAsString.mask) == 0L;
        if (writeAsString) {
            this.writeQuote();
        }
        this.writeInt16(value);
        if (writeAsString) {
            this.writeQuote();
        }
    }

    @Override
    public final void writeString(int value) {
        boolean writeAsString;
        boolean bl = writeAsString = (this.context.features & JSONWriter.Feature.WriteNonStringValueAsString.mask) == 0L;
        if (writeAsString) {
            this.writeQuote();
        }
        this.writeInt32(value);
        if (writeAsString) {
            this.writeQuote();
        }
    }

    @Override
    public final void writeString(long value) {
        boolean writeAsString;
        boolean bl = writeAsString = (this.context.features & (JSONWriter.Feature.WriteNonStringValueAsString.mask | JSONWriter.Feature.WriteLongAsString.mask)) == 0L;
        if (writeAsString) {
            this.writeQuote();
        }
        this.writeInt64(value);
        if (writeAsString) {
            this.writeQuote();
        }
    }

    private void writeQuote() {
        this.writeRaw((byte)this.quote);
    }

    @Override
    public void writeString(String str) {
        if (str == null) {
            this.writeStringNull();
            return;
        }
        if (JDKUtils.STRING_VALUE != null) {
            byte[] value = JDKUtils.STRING_VALUE.apply(str);
            if (JDKUtils.STRING_CODER.applyAsInt(str) == 0) {
                this.writeStringLatin1(value);
            } else {
                this.writeStringUTF16(value);
            }
        } else {
            this.writeStringJDK8(str);
        }
    }

    private void writeStringJDK8(String str) {
        char c0;
        int i;
        byte[] bytes;
        char[] chars = JDKUtils.getCharArray(str);
        boolean browserSecure = (this.context.features & JSONWriter.Feature.BrowserSecure.mask) != 0L;
        boolean escapeNoneAscii = (this.context.features & JSONWriter.Feature.EscapeNoneAscii.mask) != 0L;
        int off = this.off;
        int minCapacity = off + chars.length * 3 + 2;
        if (escapeNoneAscii || browserSecure) {
            minCapacity += chars.length * 3;
        }
        if (minCapacity > (bytes = this.bytes).length) {
            bytes = this.grow(minCapacity);
        }
        bytes[off++] = (byte)this.quote;
        for (i = 0; i < chars.length && (c0 = chars[i]) != this.quote && c0 != '\\' && c0 >= ' ' && c0 <= '\u007f' && (!browserSecure || c0 != '<' && c0 != '>' && c0 != '(' && c0 != ')'); ++i) {
            bytes[off++] = (byte)c0;
        }
        if (i == chars.length) {
            bytes[off] = (byte)this.quote;
            this.off = off + 1;
            return;
        }
        this.off = off;
        if (i < chars.length) {
            this.writeStringEscapedRest(chars, chars.length, browserSecure, escapeNoneAscii, i);
        }
        this.bytes[this.off++] = (byte)this.quote;
    }

    @Override
    public final void writeStringLatin1(byte[] value) {
        if ((this.context.features & 0x800000000L) != 0L) {
            this.writeStringLatin1BrowserSecure(value);
            return;
        }
        byte quote = (byte)this.quote;
        if (StringUtils.escaped(value, quote, this.byteVectorQuote)) {
            this.writeStringEscaped(value);
            return;
        }
        int off = this.off;
        int minCapacity = off + value.length + 2;
        byte[] bytes = this.bytes;
        if (minCapacity > bytes.length) {
            bytes = this.grow(minCapacity);
        }
        this.off = StringUtils.writeLatin1(bytes, off, value, quote);
    }

    protected final void writeStringLatin1BrowserSecure(byte[] value) {
        byte c;
        int i;
        byte quote = (byte)this.quote;
        for (i = 0; i < value.length && (c = value[i]) != quote && c != 92 && c >= 32 && c != 60 && c != 62 && c != 40 && c != 41; ++i) {
        }
        int off = this.off;
        if (i == value.length) {
            int minCapacity = off + value.length + 2;
            byte[] bytes = this.bytes;
            if (minCapacity > bytes.length) {
                bytes = this.grow(minCapacity);
            }
            bytes[off] = quote;
            System.arraycopy(value, 0, bytes, off + 1, value.length);
            bytes[off += value.length + 1] = quote;
            this.off = off + 1;
            return;
        }
        this.writeStringEscaped(value);
    }

    @Override
    public final void writeStringUTF16(byte[] value) {
        if (value == null) {
            this.writeStringNull();
            return;
        }
        int off = this.off;
        int minCapacity = off + value.length * 6 + 2;
        byte[] bytes = this.bytes;
        if (minCapacity > bytes.length) {
            bytes = this.grow(minCapacity);
        }
        this.off = StringUtils.writeUTF16(bytes, off, value, (byte)this.quote, this.context.features);
    }

    @Override
    public final void writeString(char[] chars) {
        char c;
        int i;
        byte[] bytes;
        if (chars == null) {
            this.writeStringNull();
            return;
        }
        boolean browserSecure = (this.context.features & JSONWriter.Feature.BrowserSecure.mask) != 0L;
        boolean escapeNoneAscii = (this.context.features & JSONWriter.Feature.EscapeNoneAscii.mask) != 0L;
        int off = this.off;
        int minCapacity = off + chars.length * 3 + 2;
        if (escapeNoneAscii || browserSecure) {
            minCapacity += chars.length * 3;
        }
        if (minCapacity > (bytes = this.bytes).length) {
            bytes = this.grow(minCapacity);
        }
        bytes[off++] = (byte)this.quote;
        for (i = 0; i < chars.length && (c = chars[i]) != this.quote && c != '\\' && c >= ' ' && c <= '\u007f' && (!browserSecure || c != '<' && c != '>' && c != '(' && c != ')'); ++i) {
            bytes[off++] = (byte)c;
        }
        this.off = off;
        if (i < chars.length) {
            this.writeStringEscapedRest(chars, chars.length, browserSecure, escapeNoneAscii, i);
        }
        this.bytes[this.off++] = (byte)this.quote;
    }

    @Override
    public final void writeString(char[] chars, int stroff, int strlen) {
        char c0;
        int i;
        byte[] bytes;
        if (chars == null) {
            if (this.isEnabled(JSONWriter.Feature.NullAsDefaultValue.mask | JSONWriter.Feature.WriteNullStringAsEmpty.mask)) {
                this.writeString("");
                return;
            }
            this.writeNull();
            return;
        }
        int end = stroff + strlen;
        boolean browserSecure = (this.context.features & JSONWriter.Feature.BrowserSecure.mask) != 0L;
        boolean escapeNoneAscii = (this.context.features & JSONWriter.Feature.EscapeNoneAscii.mask) != 0L;
        int off = this.off;
        int minCapacity = off + strlen * 3 + 2;
        if (escapeNoneAscii || browserSecure) {
            minCapacity += strlen * 3;
        }
        if (minCapacity > (bytes = this.bytes).length) {
            bytes = this.grow(minCapacity);
        }
        bytes[off++] = (byte)this.quote;
        for (i = stroff; i < end && (c0 = chars[i]) != this.quote && c0 != '\\' && c0 >= ' ' && c0 <= '\u007f' && (!browserSecure || c0 != '<' && c0 != '>' && c0 != '(' && c0 != ')'); ++i) {
            bytes[off++] = (byte)c0;
        }
        this.off = off;
        if (i < end) {
            this.writeStringEscapedRest(chars, end, browserSecure, escapeNoneAscii, i);
        }
        this.bytes[this.off++] = (byte)this.quote;
    }

    protected final void writeStringEscaped(byte[] values) {
        int minCapacity = this.off + values.length * 6 + 2;
        byte[] bytes = this.bytes;
        if (minCapacity > bytes.length) {
            bytes = this.grow(minCapacity);
        }
        this.off = StringUtils.writeLatin1Escaped(bytes, this.off, values, (byte)this.quote, this.context.features);
    }

    protected final void writeStringEscapedRest(char[] chars, int end, boolean browserSecure, boolean escapeNoneAscii, int i) {
        int rest = chars.length - i;
        int minCapacity = this.off + rest * 6 + 2;
        byte[] bytes = this.bytes;
        if (minCapacity > bytes.length) {
            bytes = this.grow(minCapacity);
        }
        int off = this.off;
        while (i < end) {
            block14: {
                char ch;
                block16: {
                    int uc;
                    block19: {
                        block17: {
                            block20: {
                                block18: {
                                    block15: {
                                        block13: {
                                            ch = chars[i];
                                            if (ch > '\u007f') break block13;
                                            switch (ch) {
                                                case '\b': 
                                                case '\t': 
                                                case '\n': 
                                                case '\f': 
                                                case '\r': 
                                                case '\\': {
                                                    StringUtils.writeEscapedChar(bytes, off, (int)ch);
                                                    off += 2;
                                                    break;
                                                }
                                                case '\u0000': 
                                                case '\u0001': 
                                                case '\u0002': 
                                                case '\u0003': 
                                                case '\u0004': 
                                                case '\u0005': 
                                                case '\u0006': 
                                                case '\u0007': 
                                                case '\u000b': 
                                                case '\u000e': 
                                                case '\u000f': 
                                                case '\u0010': 
                                                case '\u0011': 
                                                case '\u0012': 
                                                case '\u0013': 
                                                case '\u0014': 
                                                case '\u0015': 
                                                case '\u0016': 
                                                case '\u0017': 
                                                case '\u0018': 
                                                case '\u0019': 
                                                case '\u001a': 
                                                case '\u001b': 
                                                case '\u001c': 
                                                case '\u001d': 
                                                case '\u001e': 
                                                case '\u001f': {
                                                    StringUtils.writeU4Hex2(bytes, off, (int)ch);
                                                    off += 6;
                                                    break;
                                                }
                                                case '(': 
                                                case ')': 
                                                case '<': 
                                                case '>': {
                                                    if (browserSecure) {
                                                        StringUtils.writeU4HexU(bytes, off, (int)ch);
                                                        off += 6;
                                                        break;
                                                    }
                                                    bytes[off++] = (byte)ch;
                                                    break;
                                                }
                                                default: {
                                                    if (ch == this.quote) {
                                                        bytes[off] = 92;
                                                        bytes[off + 1] = (byte)this.quote;
                                                        off += 2;
                                                        break;
                                                    }
                                                    bytes[off++] = (byte)ch;
                                                    break;
                                                }
                                            }
                                            break block14;
                                        }
                                        if (!escapeNoneAscii) break block15;
                                        StringUtils.writeU4HexU(bytes, off, (int)ch);
                                        off += 6;
                                        break block14;
                                    }
                                    if (ch < '\ud800' || ch >= '\ue000') break block16;
                                    if (ch >= '\udc00') break block17;
                                    if (chars.length - i >= 2) break block18;
                                    uc = -1;
                                    break block19;
                                }
                                char d = chars[i + 1];
                                if (d < '\udc00' || d >= '\ue000') break block20;
                                uc = (ch << 10) + d + -56613888;
                                break block19;
                            }
                            bytes[off++] = 63;
                            break block14;
                        }
                        bytes[off++] = 63;
                        break block14;
                    }
                    if (uc < 0) {
                        bytes[off++] = 63;
                    } else {
                        bytes[off] = (byte)(0xF0 | uc >> 18);
                        bytes[off + 1] = (byte)(0x80 | uc >> 12 & 0x3F);
                        bytes[off + 2] = (byte)(0x80 | uc >> 6 & 0x3F);
                        bytes[off + 3] = (byte)(0x80 | uc & 0x3F);
                        off += 4;
                        ++i;
                    }
                    break block14;
                }
                if (ch > '\u07ff') {
                    bytes[off] = (byte)(0xE0 | ch >> 12 & 0xF);
                    bytes[off + 1] = (byte)(0x80 | ch >> 6 & 0x3F);
                    bytes[off + 2] = (byte)(0x80 | ch & 0x3F);
                    off += 3;
                } else {
                    bytes[off] = (byte)(0xC0 | ch >> 6 & 0x1F);
                    bytes[off + 1] = (byte)(0x80 | ch & 0x3F);
                    off += 2;
                }
            }
            ++i;
        }
        this.off = off;
    }

    @Override
    public final void writeString(char[] chars, int offset, int len, boolean quoted) {
        char c0;
        int i;
        byte[] bytes;
        boolean escapeNoneAscii = (this.context.features & JSONWriter.Feature.EscapeNoneAscii.mask) != 0L;
        int minCapacity = this.off + chars.length * 3 + 2;
        if (escapeNoneAscii) {
            minCapacity += len * 3;
        }
        if (minCapacity > (bytes = this.bytes).length) {
            bytes = this.grow(minCapacity);
        }
        int off = this.off;
        if (quoted) {
            bytes[off++] = (byte)this.quote;
        }
        int end = offset + len;
        for (i = offset; i < end && (c0 = chars[i]) != this.quote && c0 != '\\' && c0 >= ' ' && c0 <= '\u007f'; ++i) {
            bytes[off++] = (byte)c0;
        }
        if (i == end) {
            if (quoted) {
                bytes[off++] = (byte)this.quote;
            }
            this.off = off;
            return;
        }
        while (i < end) {
            block18: {
                char ch;
                block20: {
                    int uc;
                    block23: {
                        block21: {
                            block24: {
                                block22: {
                                    block19: {
                                        block17: {
                                            ch = chars[i];
                                            if (ch > '\u007f') break block17;
                                            switch (ch) {
                                                case '\b': 
                                                case '\t': 
                                                case '\n': 
                                                case '\f': 
                                                case '\r': 
                                                case '\\': {
                                                    StringUtils.writeEscapedChar(bytes, off, (int)ch);
                                                    off += 2;
                                                    break;
                                                }
                                                case '\u0000': 
                                                case '\u0001': 
                                                case '\u0002': 
                                                case '\u0003': 
                                                case '\u0004': 
                                                case '\u0005': 
                                                case '\u0006': 
                                                case '\u0007': 
                                                case '\u000b': 
                                                case '\u000e': 
                                                case '\u000f': 
                                                case '\u0010': 
                                                case '\u0011': 
                                                case '\u0012': 
                                                case '\u0013': 
                                                case '\u0014': 
                                                case '\u0015': 
                                                case '\u0016': 
                                                case '\u0017': 
                                                case '\u0018': 
                                                case '\u0019': 
                                                case '\u001a': 
                                                case '\u001b': 
                                                case '\u001c': 
                                                case '\u001d': 
                                                case '\u001e': 
                                                case '\u001f': {
                                                    StringUtils.writeU4Hex2(bytes, off, (int)ch);
                                                    off += 6;
                                                    break;
                                                }
                                                default: {
                                                    if (ch == this.quote) {
                                                        bytes[off] = 92;
                                                        bytes[off + 1] = (byte)this.quote;
                                                        off += 2;
                                                        break;
                                                    }
                                                    bytes[off++] = (byte)ch;
                                                    break;
                                                }
                                            }
                                            break block18;
                                        }
                                        if (!escapeNoneAscii) break block19;
                                        StringUtils.writeU4HexU(bytes, off, (int)ch);
                                        off += 6;
                                        break block18;
                                    }
                                    if (ch < '\ud800' || ch >= '\ue000') break block20;
                                    if (ch >= '\udc00') break block21;
                                    if (chars.length - i >= 2) break block22;
                                    uc = -1;
                                    break block23;
                                }
                                char d = chars[i + 1];
                                if (d < '\udc00' || d >= '\ue000') break block24;
                                uc = (ch << 10) + d + -56613888;
                                break block23;
                            }
                            bytes[off++] = 63;
                            break block18;
                        }
                        bytes[off++] = 63;
                        break block18;
                    }
                    if (uc < 0) {
                        bytes[off++] = 63;
                    } else {
                        bytes[off] = (byte)(0xF0 | uc >> 18);
                        bytes[off + 1] = (byte)(0x80 | uc >> 12 & 0x3F);
                        bytes[off + 2] = (byte)(0x80 | uc >> 6 & 0x3F);
                        bytes[off + 3] = (byte)(0x80 | uc & 0x3F);
                        off += 4;
                        ++i;
                    }
                    break block18;
                }
                if (ch > '\u07ff') {
                    bytes[off] = (byte)(0xE0 | ch >> 12 & 0xF);
                    bytes[off + 1] = (byte)(0x80 | ch >> 6 & 0x3F);
                    bytes[off + 2] = (byte)(0x80 | ch & 0x3F);
                    off += 3;
                } else {
                    bytes[off] = (byte)(0xC0 | ch >> 6 & 0x1F);
                    bytes[off + 1] = (byte)(0x80 | ch & 0x3F);
                    off += 2;
                }
            }
            ++i;
        }
        if (quoted) {
            bytes[off++] = (byte)this.quote;
        }
        this.off = off;
    }

    @Override
    public final void writeChar(char ch) {
        int off = this.off;
        byte[] bytes = this.bytes;
        if (off + 8 > bytes.length) {
            bytes = this.grow(off + 8);
        }
        bytes[off++] = (byte)this.quote;
        if (ch <= '\u007f') {
            switch (ch) {
                case '\b': 
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': 
                case '\\': {
                    StringUtils.writeEscapedChar(bytes, off, (int)ch);
                    off += 2;
                    break;
                }
                case '\u0000': 
                case '\u0001': 
                case '\u0002': 
                case '\u0003': 
                case '\u0004': 
                case '\u0005': 
                case '\u0006': 
                case '\u0007': 
                case '\u000b': 
                case '\u000e': 
                case '\u000f': 
                case '\u0010': 
                case '\u0011': 
                case '\u0012': 
                case '\u0013': 
                case '\u0014': 
                case '\u0015': 
                case '\u0016': 
                case '\u0017': 
                case '\u0018': 
                case '\u0019': 
                case '\u001a': 
                case '\u001b': 
                case '\u001c': 
                case '\u001d': 
                case '\u001e': 
                case '\u001f': {
                    StringUtils.writeU4Hex2(bytes, off, (int)ch);
                    off += 6;
                    break;
                }
                default: {
                    if (ch == this.quote) {
                        bytes[off] = 92;
                        bytes[off + 1] = (byte)this.quote;
                        off += 2;
                        break;
                    }
                    bytes[off++] = (byte)ch;
                    break;
                }
            }
        } else {
            if (ch >= '\ud800' && ch < '\ue000') {
                throw new JSONException("illegal char " + ch);
            }
            if (ch > '\u07ff') {
                bytes[off] = (byte)(0xE0 | ch >> 12 & 0xF);
                bytes[off + 1] = (byte)(0x80 | ch >> 6 & 0x3F);
                bytes[off + 2] = (byte)(0x80 | ch & 0x3F);
                off += 3;
            } else {
                bytes[off] = (byte)(0xC0 | ch >> 6 & 0x1F);
                bytes[off + 1] = (byte)(0x80 | ch & 0x3F);
                off += 2;
            }
        }
        bytes[off] = (byte)this.quote;
        this.off = off + 1;
    }

    @Override
    public final void writeUUID(UUID value) {
        if (value == null) {
            this.writeNull();
            return;
        }
        int off = this.off;
        int minCapacity = off + 38;
        byte[] bytes = this.bytes;
        if (minCapacity > bytes.length) {
            bytes = this.grow(minCapacity);
        }
        byte quote = (byte)this.quote;
        long base = JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)off;
        JDKUtils.UNSAFE.putByte(bytes, base, quote);
        JDKUtils.UNSAFE.putByte(bytes, base + 9L, (byte)45);
        JDKUtils.UNSAFE.putByte(bytes, base + 14L, (byte)45);
        JDKUtils.UNSAFE.putByte(bytes, base + 19L, (byte)45);
        JDKUtils.UNSAFE.putByte(bytes, base + 24L, (byte)45);
        JDKUtils.UNSAFE.putByte(bytes, base + 37L, quote);
        long msb = value.getMostSignificantBits();
        long lsb = value.getLeastSignificantBits();
        long x = msb;
        long x0 = JSONWriterUTF8.hex8(x >>> 32);
        long x1 = JSONWriterUTF8.hex8(x);
        JDKUtils.UNSAFE.putLong(bytes, base + 1L, x0);
        JDKUtils.UNSAFE.putInt(bytes, base + 10L, (int)x1);
        JDKUtils.UNSAFE.putInt(bytes, base + 15L, (int)(x1 >>> 32));
        x = lsb;
        x0 = JSONWriterUTF8.hex8(x >>> 32);
        x1 = JSONWriterUTF8.hex8(x);
        JDKUtils.UNSAFE.putInt(bytes, base + 20L, (int)x0);
        JDKUtils.UNSAFE.putInt(bytes, base + 25L, (int)(x0 >>> 32));
        JDKUtils.UNSAFE.putLong(bytes, base + 29L, x1);
        this.off += 38;
    }

    private static long hex8(long i) {
        i = JSONWriterUTF8.expand(i);
        long m = i + 0x606060606060606L & 0x1010101010101010L;
        long v = (m << 1) + (m >> 1) - (m >> 4) + 0x3030303030303030L + i;
        if (!JDKUtils.BIG_ENDIAN) {
            v = Long.reverseBytes(v);
        }
        return v;
    }

    private static long expand(long i) {
        long t = i << 16;
        i = i & 0xFFFF0000FFFFFFFFL | t & 0xFFFF00000000L;
        t = i << 8;
        i = i & 0xFF00FFFFFF00FFFFL | t & 0xFF000000FF0000L;
        t = i << 4;
        i = i & 0xF0FFF0FFF0FFF0FFL | t & 0xF000F000F000F00L;
        return i & 0xF0F0F0F0F0F0F0FL;
    }

    @Override
    public final void writeRaw(String str) {
        byte[] bytes;
        int off = this.off;
        char[] chars = JDKUtils.getCharArray(str);
        int minCapacity = off + chars.length * 3;
        if (minCapacity > (bytes = this.bytes).length) {
            bytes = this.grow(minCapacity);
        }
        for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            if (c >= '\u0001' && c <= '\u007f') {
                bytes[off++] = (byte)c;
                continue;
            }
            if (c > '\u07ff') {
                bytes[off] = (byte)(0xE0 | c >> 12 & 0xF);
                bytes[off + 1] = (byte)(0x80 | c >> 6 & 0x3F);
                bytes[off + 2] = (byte)(0x80 | c & 0x3F);
                off += 3;
                continue;
            }
            bytes[off] = (byte)(0xC0 | c >> 6 & 0x1F);
            bytes[off + 1] = (byte)(0x80 | c & 0x3F);
            off += 2;
        }
        this.off = off;
    }

    @Override
    public final void writeRaw(byte[] raw) {
        int off = this.off;
        int minCapacity = off + raw.length;
        if (minCapacity > this.bytes.length) {
            this.grow(minCapacity);
        }
        System.arraycopy(raw, 0, this.bytes, off, raw.length);
        this.off = off + raw.length;
    }

    @Override
    public final void writeNameRaw(byte[] name) {
        int off = this.off;
        int minCapacity = off + name.length + 2 + this.pretty * this.level;
        byte[] bytes = this.bytes;
        if (minCapacity > bytes.length) {
            bytes = this.grow(minCapacity);
        }
        if (this.startObject) {
            this.startObject = false;
        } else {
            bytes[off++] = 44;
            if (this.pretty != 0) {
                off = this.indent(bytes, off);
            }
        }
        System.arraycopy(name, 0, bytes, off, name.length);
        this.off = off + name.length;
    }

    @Override
    public final void writeName2Raw(long name) {
        int off = this.off;
        int minCapacity = off + 10 + this.pretty * this.level;
        byte[] bytes = this.bytes;
        if (minCapacity > bytes.length) {
            bytes = this.grow(minCapacity);
        }
        if (this.startObject) {
            this.startObject = false;
        } else {
            bytes[off++] = 44;
            if (this.pretty != 0) {
                off = this.indent(bytes, off);
            }
        }
        JDKUtils.UNSAFE.putLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)off, name);
        this.off = off + 5;
    }

    private int indent(byte[] bytes, int off) {
        bytes[off] = 10;
        int toIndex = off + 1 + this.pretty * this.level;
        Arrays.fill(bytes, off + 1, toIndex, this.pretty == 1 ? (byte)9 : 32);
        return toIndex;
    }

    @Override
    public final void writeName3Raw(long name) {
        int off = this.off;
        int minCapacity = off + 10 + this.pretty * this.level;
        byte[] bytes = this.bytes;
        if (minCapacity > bytes.length) {
            bytes = this.grow(minCapacity);
        }
        if (this.startObject) {
            this.startObject = false;
        } else {
            bytes[off++] = 44;
            if (this.pretty != 0) {
                off = this.indent(bytes, off);
            }
        }
        JDKUtils.UNSAFE.putLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)off, name);
        this.off = off + 6;
    }

    @Override
    public final void writeName4Raw(long name) {
        int off = this.off;
        int minCapacity = off + 10 + this.pretty * this.level;
        byte[] bytes = this.bytes;
        if (minCapacity > bytes.length) {
            bytes = this.grow(minCapacity);
        }
        if (this.startObject) {
            this.startObject = false;
        } else {
            bytes[off++] = 44;
            if (this.pretty != 0) {
                off = this.indent(bytes, off);
            }
        }
        JDKUtils.UNSAFE.putLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)off, name);
        this.off = off + 7;
    }

    @Override
    public final void writeName5Raw(long name) {
        int off = this.off;
        int minCapacity = off + 10 + this.pretty * this.level;
        byte[] bytes = this.bytes;
        if (minCapacity > bytes.length) {
            bytes = this.grow(minCapacity);
        }
        if (this.startObject) {
            this.startObject = false;
        } else {
            bytes[off++] = 44;
            if (this.pretty != 0) {
                off = this.indent(bytes, off);
            }
        }
        JDKUtils.UNSAFE.putLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)off, name);
        this.off = off + 8;
    }

    @Override
    public final void writeName6Raw(long name) {
        int off = this.off;
        int minCapacity = off + 11 + this.pretty * this.level;
        byte[] bytes = this.bytes;
        if (minCapacity > bytes.length) {
            bytes = this.grow(minCapacity);
        }
        if (this.startObject) {
            this.startObject = false;
        } else {
            bytes[off++] = 44;
            if (this.pretty != 0) {
                off = this.indent(bytes, off);
            }
        }
        JDKUtils.UNSAFE.putLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)off, name);
        bytes[off + 8] = 58;
        this.off = off + 9;
    }

    @Override
    public final void writeName7Raw(long name) {
        int off = this.off;
        int minCapacity = off + 12 + this.pretty * this.level;
        byte[] bytes = this.bytes;
        if (minCapacity > bytes.length) {
            bytes = this.grow(minCapacity);
        }
        if (this.startObject) {
            this.startObject = false;
        } else {
            bytes[off++] = 44;
            if (this.pretty != 0) {
                off = this.indent(bytes, off);
            }
        }
        JDKUtils.UNSAFE.putLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)off, name);
        bytes[off + 8] = (byte)this.quote;
        bytes[off + 9] = 58;
        this.off = off + 10;
    }

    @Override
    public void writeName8Raw(long name) {
        int off = this.off;
        int minCapacity = off + 13 + this.pretty * this.level;
        byte[] bytes = this.bytes;
        if (minCapacity > bytes.length) {
            bytes = this.grow(minCapacity);
        }
        if (this.startObject) {
            this.startObject = false;
        } else {
            bytes[off++] = 44;
            if (this.pretty != 0) {
                off = this.indent(bytes, off);
            }
        }
        bytes[off] = (byte)this.quote;
        JDKUtils.UNSAFE.putLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)off + 1L, name);
        JDKUtils.UNSAFE.putShort(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)off + 9L, this.useSingleQuote ? QUOTE_COLON : QUOTE2_COLON);
        this.off = off + 11;
    }

    @Override
    public final void writeName9Raw(long name0, int name1) {
        int off = this.off;
        int minCapacity = off + 14 + this.pretty * this.level;
        byte[] bytes = this.bytes;
        if (minCapacity > bytes.length) {
            bytes = this.grow(minCapacity);
        }
        if (this.startObject) {
            this.startObject = false;
        } else {
            bytes[off++] = 44;
            if (this.pretty != 0) {
                off = this.indent(bytes, off);
            }
        }
        JDKUtils.UNSAFE.putLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)off, name0);
        JDKUtils.UNSAFE.putInt(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)off + 8L, name1);
        this.off = off + 12;
    }

    @Override
    public final void writeName10Raw(long name0, long name1) {
        int off = this.off;
        int minCapacity = off + 18 + this.pretty * this.level;
        byte[] bytes = this.bytes;
        if (minCapacity > bytes.length) {
            bytes = this.grow(minCapacity);
        }
        if (this.startObject) {
            this.startObject = false;
        } else {
            bytes[off++] = 44;
            if (this.pretty != 0) {
                off = this.indent(bytes, off);
            }
        }
        JDKUtils.UNSAFE.putLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)off, name0);
        JDKUtils.UNSAFE.putLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)off + 8L, name1);
        this.off = off + 13;
    }

    @Override
    public final void writeName11Raw(long name0, long name1) {
        int off = this.off;
        int minCapacity = off + 18 + this.pretty * this.level;
        byte[] bytes = this.bytes;
        if (minCapacity > bytes.length) {
            bytes = this.grow(minCapacity);
        }
        if (this.startObject) {
            this.startObject = false;
        } else {
            bytes[off++] = 44;
            if (this.pretty != 0) {
                off = this.indent(bytes, off);
            }
        }
        JDKUtils.UNSAFE.putLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)off, name0);
        JDKUtils.UNSAFE.putLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)off + 8L, name1);
        this.off = off + 14;
    }

    @Override
    public final void writeName12Raw(long name0, long name1) {
        int off = this.off;
        int minCapacity = off + 18 + this.pretty * this.level;
        byte[] bytes = this.bytes;
        if (minCapacity > bytes.length) {
            bytes = this.grow(minCapacity);
        }
        if (this.startObject) {
            this.startObject = false;
        } else {
            bytes[off++] = 44;
            if (this.pretty != 0) {
                off = this.indent(bytes, off);
            }
        }
        JDKUtils.UNSAFE.putLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)off, name0);
        JDKUtils.UNSAFE.putLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)off + 8L, name1);
        this.off = off + 15;
    }

    @Override
    public final void writeName13Raw(long name0, long name1) {
        int off = this.off;
        int minCapacity = off + 18 + this.pretty * this.level;
        byte[] bytes = this.bytes;
        if (minCapacity > bytes.length) {
            bytes = this.grow(minCapacity);
        }
        if (this.startObject) {
            this.startObject = false;
        } else {
            bytes[off++] = 44;
            if (this.pretty != 0) {
                off = this.indent(bytes, off);
            }
        }
        JDKUtils.UNSAFE.putLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)off, name0);
        JDKUtils.UNSAFE.putLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)off + 8L, name1);
        this.off = off + 16;
    }

    @Override
    public final void writeName14Raw(long name0, long name1) {
        int off = this.off;
        int minCapacity = off + 19 + this.pretty * this.level;
        byte[] bytes = this.bytes;
        if (minCapacity > bytes.length) {
            bytes = this.grow(minCapacity);
        }
        if (this.startObject) {
            this.startObject = false;
        } else {
            bytes[off++] = 44;
            if (this.pretty != 0) {
                off = this.indent(bytes, off);
            }
        }
        JDKUtils.UNSAFE.putLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)off, name0);
        JDKUtils.UNSAFE.putLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)off + 8L, name1);
        bytes[off + 16] = 58;
        this.off = off + 17;
    }

    @Override
    public final void writeName15Raw(long name0, long name1) {
        int off = this.off;
        int minCapacity = off + 20 + this.pretty * this.level;
        byte[] bytes = this.bytes;
        if (minCapacity > bytes.length) {
            bytes = this.grow(minCapacity);
        }
        if (this.startObject) {
            this.startObject = false;
        } else {
            bytes[off++] = 44;
            if (this.pretty != 0) {
                off = this.indent(bytes, off);
            }
        }
        JDKUtils.UNSAFE.putLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)off, name0);
        JDKUtils.UNSAFE.putLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)off + 8L, name1);
        JDKUtils.UNSAFE.putShort(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)off + 16L, this.useSingleQuote ? QUOTE_COLON : QUOTE2_COLON);
        this.off = off + 18;
    }

    @Override
    public final void writeName16Raw(long name0, long name1) {
        int off = this.off;
        int minCapacity = off + 21 + this.pretty * this.level;
        byte[] bytes = this.bytes;
        if (minCapacity > bytes.length) {
            bytes = this.grow(minCapacity);
        }
        if (this.startObject) {
            this.startObject = false;
        } else {
            bytes[off++] = 44;
            if (this.pretty != 0) {
                off = this.indent(bytes, off);
            }
        }
        bytes[off++] = (byte)this.quote;
        JDKUtils.UNSAFE.putLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)off, name0);
        JDKUtils.UNSAFE.putLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)off + 8L, name1);
        JDKUtils.UNSAFE.putShort(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)off + 16L, this.useSingleQuote ? QUOTE_COLON : QUOTE2_COLON);
        this.off = off + 18;
    }

    @Override
    public final void writeRaw(byte b) {
        int off = this.off;
        this.grow1((int)off)[off] = b;
        this.off = off + 1;
    }

    @Override
    public final void writeRaw(char ch) {
        if (ch > '\u0080') {
            throw new JSONException("not support " + ch);
        }
        if (this.off == this.bytes.length) {
            this.grow0(this.off + 1);
        }
        this.bytes[this.off++] = (byte)ch;
    }

    @Override
    public final void writeRaw(char c0, char c1) {
        if (c0 > '\u0080' || c1 > '\u0080') {
            throw new JSONException("not support " + c0 + ", " + c1);
        }
        int off = this.off;
        byte[] bytes = this.bytes;
        if (off + 2 > bytes.length) {
            bytes = this.grow(off + 2);
        }
        bytes[off] = (byte)c0;
        bytes[off + 1] = (byte)c1;
        this.off = off + 2;
    }

    @Override
    public final void writeNameRaw(byte[] name, int coff, int len) {
        int off = this.off;
        int minCapacity = off + len + 2 + this.pretty * this.level;
        byte[] bytes = this.bytes;
        if (minCapacity > bytes.length) {
            bytes = this.grow(minCapacity);
        }
        if (!this.startObject) {
            bytes[off++] = 44;
            if (this.pretty != 0) {
                off = this.indent(bytes, off);
            }
        }
        this.startObject = false;
        System.arraycopy(name, coff, bytes, off, len);
        this.off = off + len;
    }

    @Override
    public final Object ensureCapacity(int minCapacity) {
        byte[] bytes = this.bytes;
        if (minCapacity >= bytes.length) {
            this.bytes = bytes = Arrays.copyOf(bytes, this.newCapacity(minCapacity, bytes.length));
        }
        return bytes;
    }

    private byte[] grow(int minCapacity) {
        this.grow0(minCapacity);
        return this.bytes;
    }

    private byte[] grow1(int off) {
        byte[] bytes = this.bytes;
        if (off == bytes.length) {
            bytes = this.grow(off + 1);
        }
        return bytes;
    }

    private void grow0(int minCapacity) {
        this.bytes = Arrays.copyOf(this.bytes, this.newCapacity(minCapacity, this.bytes.length));
    }

    @Override
    public final void writeInt32(int[] values) {
        if (values == null) {
            this.writeNull();
            return;
        }
        boolean writeAsString = (this.context.features & 0x100L) != 0L;
        int off = this.off;
        int minCapacity = off + values.length * 13 + 2;
        byte[] bytes = this.bytes;
        if (minCapacity > bytes.length) {
            bytes = this.grow(minCapacity);
        }
        bytes[off++] = 91;
        for (int i = 0; i < values.length; ++i) {
            if (i != 0) {
                bytes[off++] = 44;
            }
            if (writeAsString) {
                bytes[off++] = (byte)this.quote;
            }
            off = IOUtils.writeInt32(bytes, off, (long)values[i]);
            if (!writeAsString) continue;
            bytes[off++] = (byte)this.quote;
        }
        bytes[off] = 93;
        this.off = off + 1;
    }

    @Override
    public final void writeInt8(byte i) {
        boolean writeAsString = (this.context.features & 0x100L) != 0L;
        int off = this.off;
        int minCapacity = off + 5;
        byte[] bytes = this.bytes;
        if (minCapacity > bytes.length) {
            bytes = this.grow(minCapacity);
        }
        if (writeAsString) {
            bytes[off++] = (byte)this.quote;
        }
        off = IOUtils.writeInt8(bytes, off, i);
        if (writeAsString) {
            bytes[off++] = (byte)this.quote;
        }
        this.off = off;
    }

    @Override
    public final void writeInt8(byte[] values) {
        if (values == null) {
            this.writeNull();
            return;
        }
        boolean writeAsString = (this.context.features & 0x100L) != 0L;
        int off = this.off;
        int minCapacity = off + values.length * 5 + 2;
        byte[] bytes = this.bytes;
        if (minCapacity > bytes.length) {
            bytes = this.grow(minCapacity);
        }
        bytes[off++] = 91;
        for (int i = 0; i < values.length; ++i) {
            if (i != 0) {
                bytes[off++] = 44;
            }
            if (writeAsString) {
                bytes[off++] = (byte)this.quote;
            }
            off = IOUtils.writeInt8(bytes, off, values[i]);
            if (!writeAsString) continue;
            bytes[off++] = (byte)this.quote;
        }
        bytes[off] = 93;
        this.off = off + 1;
    }

    @Override
    public final void writeInt16(short i) {
        boolean writeAsString = (this.context.features & JSONWriter.Feature.WriteNonStringValueAsString.mask) != 0L;
        int off = this.off;
        int minCapacity = off + 7;
        byte[] bytes = this.bytes;
        if (minCapacity > bytes.length) {
            bytes = this.grow(minCapacity);
        }
        if (writeAsString) {
            bytes[off++] = (byte)this.quote;
        }
        off = IOUtils.writeInt16(bytes, off, i);
        if (writeAsString) {
            bytes[off++] = (byte)this.quote;
        }
        this.off = off;
    }

    @Override
    public final void writeInt32(Integer i) {
        if (i == null) {
            this.writeNumberNull();
        } else {
            this.writeInt32((int)i);
        }
    }

    @Override
    public final void writeInt32(int i) {
        boolean writeAsString = (this.context.features & 0x100L) != 0L;
        int off = this.off;
        int minCapacity = off + 13;
        byte[] bytes = this.bytes;
        if (minCapacity > bytes.length) {
            bytes = this.grow(minCapacity);
        }
        if (writeAsString) {
            bytes[off++] = (byte)this.quote;
        }
        off = IOUtils.writeInt32(bytes, off, (long)i);
        if (writeAsString) {
            bytes[off++] = (byte)this.quote;
        }
        this.off = off;
    }

    @Override
    public final void writeListInt32(List<Integer> values) {
        if (values == null) {
            this.writeNull();
            return;
        }
        int size = values.size();
        boolean writeAsString = (this.context.features & 0x100L) != 0L;
        int off = this.off;
        int minCapacity = off + 2 + size * 23;
        byte[] bytes = this.bytes;
        if (minCapacity > bytes.length) {
            bytes = this.grow(minCapacity);
        }
        bytes[off++] = 91;
        for (int i = 0; i < size; ++i) {
            Number item;
            if (i != 0) {
                bytes[off++] = 44;
            }
            if ((item = (Number)values.get(i)) == null) {
                IOUtils.putNULL(bytes, off);
                off += 4;
                continue;
            }
            int v = item.intValue();
            if (writeAsString) {
                bytes[off++] = (byte)this.quote;
            }
            off = IOUtils.writeInt32(bytes, off, (long)v);
            if (!writeAsString) continue;
            bytes[off++] = (byte)this.quote;
        }
        bytes[off] = 93;
        this.off = off + 1;
    }

    @Override
    public final void writeInt64(long[] values) {
        if (values == null) {
            this.writeNull();
            return;
        }
        int off = this.off;
        int minCapacity = off + 2 + values.length * 23;
        byte[] bytes = this.bytes;
        if (minCapacity > bytes.length) {
            bytes = this.grow(minCapacity);
        }
        bytes[off++] = 91;
        for (int i = 0; i < values.length; ++i) {
            long v;
            boolean writeAsString;
            if (i != 0) {
                bytes[off++] = 44;
            }
            if (writeAsString = JSONWriterUTF8.isWriteAsString(v = values[i], this.context.features)) {
                bytes[off++] = (byte)this.quote;
            }
            off = IOUtils.writeInt64(bytes, off, v);
            if (!writeAsString) continue;
            bytes[off++] = (byte)this.quote;
        }
        bytes[off] = 93;
        this.off = off + 1;
    }

    @Override
    public final void writeListInt64(List<Long> values) {
        byte[] bytes;
        if (values == null) {
            this.writeNull();
            return;
        }
        int off = this.off;
        int size = values.size();
        int minCapacity = off + 2 + size * 23;
        if (minCapacity > (bytes = this.bytes).length) {
            bytes = this.grow(minCapacity);
        }
        bytes[off++] = 91;
        for (int i = 0; i < size; ++i) {
            Long item;
            if (i != 0) {
                bytes[off++] = 44;
            }
            if ((item = values.get(i)) == null) {
                IOUtils.putNULL(bytes, off);
                off += 4;
                continue;
            }
            long v = item;
            boolean writeAsString = JSONWriterUTF8.isWriteAsString(v, this.context.features);
            if (writeAsString) {
                bytes[off++] = (byte)this.quote;
            }
            off = IOUtils.writeInt64(bytes, off, v);
            if (!writeAsString) continue;
            bytes[off++] = (byte)this.quote;
        }
        bytes[off] = 93;
        this.off = off + 1;
    }

    @Override
    public final void writeInt64(long i) {
        boolean writeAsString;
        long features = this.context.features;
        int off = this.off;
        int minCapacity = off + 23;
        byte[] bytes = this.bytes;
        if (minCapacity > bytes.length) {
            bytes = this.grow(minCapacity);
        }
        if (writeAsString = JSONWriterUTF8.isWriteAsString(i, features)) {
            bytes[off++] = (byte)this.quote;
        }
        off = IOUtils.writeInt64(bytes, off, i);
        if (writeAsString) {
            bytes[off++] = (byte)this.quote;
        } else if ((features & 0x200L) != 0L && (features & 0x10000000000L) == 0L && i >= Integer.MIN_VALUE && i <= Integer.MAX_VALUE) {
            bytes[off++] = 76;
        }
        this.off = off;
    }

    @Override
    public final void writeInt64(Long i) {
        if (i == null) {
            this.writeNumberNull();
        } else {
            this.writeInt64((long)i);
        }
    }

    @Override
    public final void writeFloat(float value) {
        boolean writeAsString = (this.context.features & 0x100L) != 0L;
        int off = this.off;
        int minCapacity = off + 17;
        byte[] bytes = this.bytes;
        if (minCapacity > bytes.length) {
            bytes = this.grow(minCapacity);
        }
        if (writeAsString) {
            bytes[off++] = 34;
        }
        off = NumberUtils.writeFloat(bytes, off, value, true);
        if (writeAsString) {
            bytes[off++] = 34;
        }
        this.off = off;
    }

    @Override
    public final void writeDouble(double value) {
        boolean writeAsString = (this.context.features & 0x100L) != 0L;
        int off = this.off;
        int minCapacity = off + 26;
        byte[] bytes = this.bytes;
        if (minCapacity > bytes.length) {
            bytes = this.grow(minCapacity);
        }
        if (writeAsString) {
            bytes[off++] = 34;
        }
        off = NumberUtils.writeDouble(bytes, off, value, true);
        if (writeAsString) {
            bytes[off++] = 34;
        }
        this.off = off;
    }

    @Override
    public final void writeFloat(float[] values) {
        byte[] bytes;
        if (values == null) {
            this.writeArrayNull();
            return;
        }
        int off = this.off;
        boolean writeAsString = (this.context.features & 0x100L) != 0L;
        int minCapacity = off + values.length * (writeAsString ? 16 : 18) + 1;
        if (minCapacity > (bytes = this.bytes).length) {
            bytes = this.grow(minCapacity);
        }
        bytes[off++] = 91;
        for (int i = 0; i < values.length; ++i) {
            if (i != 0) {
                bytes[off++] = 44;
            }
            if (writeAsString) {
                bytes[off++] = 34;
            }
            off = NumberUtils.writeFloat(bytes, off, values[i], true);
            if (!writeAsString) continue;
            bytes[off++] = 34;
        }
        bytes[off] = 93;
        this.off = off + 1;
    }

    @Override
    public final void writeDouble(double[] values) {
        if (values == null) {
            this.writeNull();
            return;
        }
        boolean writeAsString = (this.context.features & JSONWriter.Feature.WriteNonStringValueAsString.mask) != 0L;
        int off = this.off;
        int minCapacity = off + values.length * 27 + 1;
        byte[] bytes = this.bytes;
        if (minCapacity > bytes.length) {
            bytes = this.grow(minCapacity);
        }
        bytes[off++] = 91;
        for (int i = 0; i < values.length; ++i) {
            if (i != 0) {
                bytes[off++] = 44;
            }
            if (writeAsString) {
                bytes[off++] = 34;
            }
            off = NumberUtils.writeDouble(bytes, off, values[i], true);
            if (!writeAsString) continue;
            bytes[off++] = 34;
        }
        bytes[off] = 93;
        this.off = off + 1;
    }

    @Override
    public final void writeDateTime14(int year, int month, int dayOfMonth, int hour, int minute, int second) {
        int off = this.off;
        int minCapacity = off + 16;
        byte[] bytes = this.bytes;
        if (minCapacity > bytes.length) {
            bytes = this.grow(minCapacity);
        }
        bytes[off] = (byte)this.quote;
        if (year < 0 || year > 9999) {
            throw JSONWriterUTF8.illegalYear(year);
        }
        int y01 = year / 100;
        int y23 = year - y01 * 100;
        IOUtils.writeDigitPair(bytes, off + 1, y01);
        IOUtils.writeDigitPair(bytes, off + 3, y23);
        IOUtils.writeDigitPair(bytes, off + 5, month);
        IOUtils.writeDigitPair(bytes, off + 7, dayOfMonth);
        IOUtils.writeDigitPair(bytes, off + 9, hour);
        IOUtils.writeDigitPair(bytes, off + 11, minute);
        IOUtils.writeDigitPair(bytes, off + 13, second);
        bytes[off + 15] = (byte)this.quote;
        this.off = off + 16;
    }

    @Override
    public final void writeDateTime19(int year, int month, int dayOfMonth, int hour, int minute, int second) {
        int off = this.off;
        int minCapacity = off + 21;
        byte[] bytes = this.bytes;
        if (minCapacity > bytes.length) {
            bytes = this.grow(minCapacity);
        }
        bytes[off] = (byte)this.quote;
        off = IOUtils.writeLocalDate(bytes, off + 1, year, month, dayOfMonth);
        bytes[off] = 32;
        IOUtils.writeLocalTime(bytes, off + 1, hour, minute, second);
        bytes[off + 9] = (byte)this.quote;
        this.off = off + 10;
    }

    @Override
    public final void writeLocalDate(LocalDate date) {
        if (date == null) {
            this.writeNull();
            return;
        }
        if (this.context.dateFormat != null && this.writeLocalDateWithFormat(date)) {
            return;
        }
        int off = this.off;
        int minCapacity = off + 18;
        byte[] bytes = this.bytes;
        if (minCapacity > bytes.length) {
            bytes = this.grow(minCapacity);
        }
        bytes[off++] = (byte)this.quote;
        off = IOUtils.writeLocalDate(bytes, off, date.getYear(), date.getMonthValue(), date.getDayOfMonth());
        bytes[off] = (byte)this.quote;
        this.off = off + 1;
    }

    @Override
    public final void writeLocalDateTime(LocalDateTime dateTime) {
        int off = this.off;
        int minCapacity = off + 38;
        byte[] bytes = this.bytes;
        if (minCapacity > bytes.length) {
            bytes = this.grow(minCapacity);
        }
        bytes[off++] = (byte)this.quote;
        LocalDate localDate = dateTime.toLocalDate();
        off = IOUtils.writeLocalDate(bytes, off, localDate.getYear(), localDate.getMonthValue(), localDate.getDayOfMonth());
        bytes[off++] = 32;
        off = IOUtils.writeLocalTime(bytes, off, dateTime.toLocalTime());
        bytes[off] = (byte)this.quote;
        this.off = off + 1;
    }

    @Override
    public final void writeDateYYYMMDD8(int year, int month, int dayOfMonth) {
        int off = this.off;
        int minCapacity = off + 10;
        byte[] bytes = this.bytes;
        if (minCapacity > bytes.length) {
            bytes = this.grow(minCapacity);
        }
        bytes[off] = (byte)this.quote;
        if (year < 0 || year > 9999) {
            throw JSONWriterUTF8.illegalYear(year);
        }
        int y01 = year / 100;
        int y23 = year - y01 * 100;
        IOUtils.writeDigitPair(bytes, off + 1, y01);
        IOUtils.writeDigitPair(bytes, off + 3, y23);
        IOUtils.writeDigitPair(bytes, off + 5, month);
        IOUtils.writeDigitPair(bytes, off + 7, dayOfMonth);
        bytes[off + 9] = (byte)this.quote;
        this.off = off + 10;
    }

    @Override
    public final void writeDateYYYMMDD10(int year, int month, int dayOfMonth) {
        int off = this.off;
        int minCapacity = off + 13;
        byte[] bytes = this.bytes;
        if (minCapacity > bytes.length) {
            bytes = this.grow(minCapacity);
        }
        bytes[off++] = (byte)this.quote;
        off = IOUtils.writeLocalDate(bytes, off, year, month, dayOfMonth);
        bytes[off] = (byte)this.quote;
        this.off = off + 1;
    }

    @Override
    public final void writeTimeHHMMSS8(int hour, int minute, int second) {
        int off = this.off;
        int minCapacity = off + 10;
        byte[] bytes = this.bytes;
        if (minCapacity > bytes.length) {
            bytes = this.grow(minCapacity);
        }
        bytes[off] = (byte)this.quote;
        IOUtils.writeLocalTime(bytes, off + 1, hour, minute, second);
        bytes[off + 9] = (byte)this.quote;
        this.off = off + 10;
    }

    @Override
    public final void writeLocalTime(LocalTime time) {
        int off = this.off;
        int minCapacity = off + 20;
        byte[] bytes = this.bytes;
        if (minCapacity > bytes.length) {
            bytes = this.grow(minCapacity);
        }
        bytes[off++] = (byte)this.quote;
        off = IOUtils.writeLocalTime(bytes, off, time);
        bytes[off] = (byte)this.quote;
        this.off = off + 1;
    }

    @Override
    public final void writeZonedDateTime(ZonedDateTime dateTime) {
        int zoneSize;
        if (dateTime == null) {
            this.writeNull();
            return;
        }
        ZoneId zone = dateTime.getZone();
        String zoneId = zone.getId();
        int zoneIdLength = zoneId.length();
        char firstZoneChar = '\u0000';
        if (ZoneOffset.UTC == zone || zoneIdLength <= 3 && ("UTC".equals(zoneId) || "Z".equals(zoneId))) {
            zoneId = "Z";
            zoneSize = 1;
        } else {
            zoneSize = zoneIdLength != 0 && ((firstZoneChar = zoneId.charAt(0)) == '+' || firstZoneChar == '-') ? zoneIdLength : 2 + zoneIdLength;
        }
        int off = this.off;
        int minCapacity = off + zoneSize + 38;
        byte[] bytes = this.bytes;
        if (minCapacity > bytes.length) {
            bytes = this.grow(minCapacity);
        }
        bytes[off] = (byte)this.quote;
        LocalDate localDate = dateTime.toLocalDate();
        off = IOUtils.writeLocalDate(bytes, off + 1, localDate.getYear(), localDate.getMonthValue(), localDate.getDayOfMonth());
        bytes[off] = 84;
        off = IOUtils.writeLocalTime(bytes, off + 1, dateTime.toLocalTime());
        if (zoneSize == 1) {
            bytes[off++] = 90;
        } else if (firstZoneChar == '+' || firstZoneChar == '-') {
            zoneId.getBytes(0, zoneIdLength, bytes, off);
            off += zoneIdLength;
        } else {
            bytes[off++] = 91;
            zoneId.getBytes(0, zoneIdLength, bytes, off);
            off += zoneIdLength;
            bytes[off++] = 93;
        }
        bytes[off] = (byte)this.quote;
        this.off = off + 1;
    }

    @Override
    public final void writeOffsetDateTime(OffsetDateTime dateTime) {
        if (dateTime == null) {
            this.writeNull();
            return;
        }
        int off = this.off;
        int minCapacity = off + 45;
        byte[] bytes = this.bytes;
        if (minCapacity > bytes.length) {
            bytes = this.grow(minCapacity);
        }
        bytes[off] = (byte)this.quote;
        LocalDateTime ldt = dateTime.toLocalDateTime();
        LocalDate date = ldt.toLocalDate();
        off = IOUtils.writeLocalDate(bytes, off + 1, date.getYear(), date.getMonthValue(), date.getDayOfMonth());
        bytes[off] = 84;
        off = IOUtils.writeLocalTime(bytes, off + 1, ldt.toLocalTime());
        ZoneOffset offset = dateTime.getOffset();
        if (offset.getTotalSeconds() == 0) {
            bytes[off++] = 90;
        } else {
            String zoneId = offset.getId();
            zoneId.getBytes(0, zoneId.length(), bytes, off);
            off += zoneId.length();
        }
        bytes[off] = (byte)this.quote;
        this.off = off + 1;
    }

    @Override
    public final void writeOffsetTime(OffsetTime time) {
        if (time == null) {
            this.writeNull();
            return;
        }
        int off = this.off;
        int minCapacity = off + 28;
        byte[] bytes = this.bytes;
        if (minCapacity > bytes.length) {
            bytes = this.grow(minCapacity);
        }
        bytes[off] = (byte)this.quote;
        off = IOUtils.writeLocalTime(bytes, off + 1, time.toLocalTime());
        ZoneOffset offset = time.getOffset();
        if (offset.getTotalSeconds() == 0) {
            bytes[off++] = 90;
        } else {
            String zoneId = offset.getId();
            zoneId.getBytes(0, zoneId.length(), bytes, off);
            off += zoneId.length();
        }
        bytes[off] = (byte)this.quote;
        this.off = off + 1;
    }

    @Override
    public final void writeBigInt(BigInteger value, long features) {
        byte[] bytes;
        if (value == null) {
            this.writeNumberNull();
            return;
        }
        if (TypeUtils.isInt64(value) && features == 0L) {
            this.writeInt64(value.longValue());
            return;
        }
        String str = value.toString(10);
        boolean writeAsString = JSONWriterUTF8.isWriteAsString(value, this.context.features | features);
        int off = this.off;
        int strlen = str.length();
        int minCapacity = off + strlen + (writeAsString ? 2 : 0);
        if (minCapacity > (bytes = this.bytes).length) {
            bytes = this.grow(minCapacity);
        }
        if (writeAsString) {
            bytes[off++] = 34;
        }
        str.getBytes(0, strlen, bytes, off);
        off += strlen;
        if (writeAsString) {
            bytes[off++] = 34;
        }
        this.off = off;
    }

    @Override
    public final void writeDateTimeISO8601(int year, int month, int dayOfMonth, int hour, int minute, int second, int millis, int offsetSeconds, boolean timeZone) {
        byte[] bytes;
        int off = this.off;
        int zonelen = timeZone ? (offsetSeconds == 0 ? 1 : 6) : 0;
        int minCapacity = off + 25 + zonelen;
        if (minCapacity > (bytes = this.bytes).length) {
            bytes = this.grow(minCapacity);
        }
        bytes[off] = (byte)this.quote;
        off = IOUtils.writeLocalDate(bytes, off + 1, year, month, dayOfMonth);
        bytes[off] = (byte)(timeZone ? 84 : 32);
        IOUtils.writeLocalTime(bytes, off + 1, hour, minute, second);
        off += 9;
        if (millis > 0) {
            int div = millis / 10;
            int div2 = div / 10;
            int rem1 = millis - div * 10;
            if (rem1 != 0) {
                IOUtils.putIntLE(bytes, off, IOUtils.DIGITS_K_32[millis & 0x3FF] & 0xFFFFFF00 | 0x2E);
                off += 4;
            } else {
                bytes[off++] = 46;
                int rem2 = div - div2 * 10;
                if (rem2 != 0) {
                    IOUtils.writeDigitPair(bytes, off, div);
                    off += 2;
                } else {
                    bytes[off++] = (byte)(div2 + 48);
                }
            }
        }
        if (timeZone) {
            int offset = offsetSeconds / 3600;
            if (offsetSeconds == 0) {
                bytes[off++] = 90;
            } else {
                int offsetAbs = Math.abs(offset);
                bytes[off] = offset >= 0 ? 43 : 45;
                IOUtils.writeDigitPair(bytes, off + 1, offsetAbs);
                bytes[off + 3] = 58;
                int offsetMinutes = (offsetSeconds - offset * 3600) / 60;
                if (offsetMinutes < 0) {
                    offsetMinutes = -offsetMinutes;
                }
                IOUtils.writeDigitPair(bytes, off + 4, offsetMinutes);
                off += 6;
            }
        }
        bytes[off] = (byte)this.quote;
        this.off = off + 1;
    }

    @Override
    public final void writeDecimal(BigDecimal value, long features, DecimalFormat format) {
        long unscaleValue;
        int scale;
        boolean asPlain;
        byte[] bytes;
        if (value == null) {
            this.writeDecimalNull();
            return;
        }
        if (format != null) {
            String str = format.format(value);
            this.writeRaw(str);
            return;
        }
        int precision = value.precision();
        boolean writeAsString = JSONWriterUTF8.isWriteAsString(value, features |= this.context.features);
        int off = this.off;
        int minCapacity = off + precision + Math.abs(value.scale()) + 7;
        if (minCapacity > (bytes = this.bytes).length) {
            bytes = this.grow(minCapacity);
        }
        if (writeAsString) {
            bytes[off++] = 34;
        }
        boolean bl = asPlain = (features & JSONWriter.Feature.WriteBigDecimalAsPlain.mask) != 0L;
        if (precision < 19 && (scale = value.scale()) >= 0 && JDKUtils.FIELD_DECIMAL_INT_COMPACT_OFFSET != -1L && (unscaleValue = JDKUtils.UNSAFE.getLong(value, JDKUtils.FIELD_DECIMAL_INT_COMPACT_OFFSET)) != Long.MIN_VALUE && !asPlain) {
            off = IOUtils.writeDecimal(bytes, off, unscaleValue, scale);
        } else {
            String str = asPlain ? value.toPlainString() : value.toString();
            str.getBytes(0, str.length(), bytes, off);
            off += str.length();
        }
        if (writeAsString) {
            bytes[off++] = 34;
        }
        this.off = off;
    }

    @Override
    public final void writeNameRaw(char[] chars) {
        throw new JSONException("UnsupportedOperation");
    }

    @Override
    public final void writeNameRaw(char[] bytes, int offset, int len) {
        throw new JSONException("UnsupportedOperation");
    }

    @Override
    public final void write(Map<?, ?> map) {
        if (this.pretty != 0) {
            super.write(map);
            return;
        }
        if (map == null) {
            this.writeNull();
            return;
        }
        long features = this.context.features;
        if ((features & NONE_DIRECT_FEATURES) != 0L) {
            ObjectWriter<?> objectWriter = this.context.getObjectWriter(map.getClass());
            objectWriter.write(this, map, null, null, 0L);
            return;
        }
        if (this.off == this.bytes.length) {
            this.grow(this.off + 1);
        }
        this.bytes[this.off++] = 123;
        boolean first = true;
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            Object value = entry.getValue();
            if (value == null && (features & 0x10L) == 0L) continue;
            if (!first) {
                if (this.off == this.bytes.length) {
                    this.grow0(this.off + 1);
                }
                this.bytes[this.off++] = 44;
            }
            first = false;
            Object key = entry.getKey();
            if (key instanceof String) {
                this.writeString((String)key);
            } else {
                this.writeAny(key);
            }
            if (this.off == this.bytes.length) {
                this.grow0(this.off + 1);
            }
            this.bytes[this.off++] = 58;
            if (value == null) {
                this.writeNull();
                continue;
            }
            Class<?> valueClass = value.getClass();
            if (valueClass == String.class) {
                this.writeString((String)value);
                continue;
            }
            if (valueClass == Integer.class) {
                this.writeInt32((Integer)value);
                continue;
            }
            if (valueClass == Long.class) {
                this.writeInt64((Long)value);
                continue;
            }
            if (valueClass == Boolean.class) {
                this.writeBool((Boolean)value);
                continue;
            }
            if (valueClass == BigDecimal.class) {
                this.writeDecimal((BigDecimal)value, 0L, null);
                continue;
            }
            if (valueClass == JSONArray.class) {
                this.write((JSONArray)value);
                continue;
            }
            if (valueClass == JSONObject.class) {
                this.write((JSONObject)value);
                continue;
            }
            ObjectWriter<?> objectWriter = this.context.getObjectWriter(valueClass, valueClass);
            objectWriter.write(this, value, null, null, 0L);
        }
        if (this.off == this.bytes.length) {
            this.grow(this.off + 1);
        }
        this.bytes[this.off++] = 125;
    }

    @Override
    public final void write(List array) {
        if (array == null) {
            this.writeArrayNull();
            return;
        }
        if ((this.context.features & 0x4031000L) != 0L) {
            ObjectWriter<?> objectWriter = this.context.getObjectWriter(array.getClass());
            objectWriter.write(this, array, null, null, 0L);
            return;
        }
        if (this.off == this.bytes.length) {
            this.grow(this.off + 1);
        }
        this.bytes[this.off++] = 91;
        boolean first = true;
        for (int i = 0; i < array.size(); ++i) {
            Object o = array.get(i);
            if (!first) {
                if (this.off == this.bytes.length) {
                    this.grow(this.off + 1);
                }
                this.bytes[this.off++] = 44;
            }
            first = false;
            if (o == null) {
                this.writeNull();
                continue;
            }
            Class<?> valueClass = o.getClass();
            if (valueClass == String.class) {
                this.writeString((String)o);
                continue;
            }
            if (valueClass == Integer.class) {
                this.writeInt32((Integer)o);
                continue;
            }
            if (valueClass == Long.class) {
                this.writeInt64((Long)o);
                continue;
            }
            if (valueClass == Boolean.class) {
                this.writeBool((Boolean)o);
                continue;
            }
            if (valueClass == BigDecimal.class) {
                this.writeDecimal((BigDecimal)o, 0L, null);
                continue;
            }
            if (valueClass == JSONArray.class) {
                this.write((JSONArray)o);
                continue;
            }
            if (valueClass == JSONObject.class) {
                this.write((JSONObject)o);
                continue;
            }
            ObjectWriter<?> objectWriter = this.context.getObjectWriter(valueClass, valueClass);
            objectWriter.write(this, o, null, null, 0L);
        }
        if (this.off == this.bytes.length) {
            this.grow(this.off + 1);
        }
        this.bytes[this.off++] = 93;
    }

    @Override
    public void writeBool(boolean value) {
        int minCapacity = this.off + 5;
        byte[] bytes = this.bytes;
        if (minCapacity > bytes.length) {
            bytes = this.grow(minCapacity);
        }
        int off = this.off;
        if ((this.context.features & 0x80L) != 0L) {
            bytes[off++] = (byte)(value ? 49 : 48);
        } else {
            off = IOUtils.putBoolean(bytes, off, value);
        }
        this.off = off;
    }

    public final String toString() {
        return new String(this.bytes, 0, this.off, StandardCharsets.UTF_8);
    }

    @Override
    public final int flushTo(OutputStream out, Charset charset) throws IOException {
        if (this.off == 0) {
            return 0;
        }
        if (charset == null || charset == StandardCharsets.UTF_8 || charset == StandardCharsets.US_ASCII) {
            int len = this.off;
            out.write(this.bytes, 0, this.off);
            this.off = 0;
            return len;
        }
        if (charset == StandardCharsets.ISO_8859_1) {
            boolean hasNegative = false;
            if (JDKUtils.METHOD_HANDLE_HAS_NEGATIVE != null) {
                try {
                    hasNegative = JDKUtils.METHOD_HANDLE_HAS_NEGATIVE.invoke(this.bytes, 0, this.bytes.length);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            if (!hasNegative) {
                int len = this.off;
                out.write(this.bytes, 0, this.off);
                this.off = 0;
                return len;
            }
        }
        String str = new String(this.bytes, 0, this.off);
        byte[] encodedBytes = str.getBytes(charset);
        out.write(encodedBytes);
        return encodedBytes.length;
    }

    static {
        byte[] chars = new byte[]{123, 34, 36, 114, 101, 102, 34, 58};
        REF = JDKUtils.UNSAFE.getLong(chars, JDKUtils.ARRAY_CHAR_BASE_OFFSET);
        QUOTE2_COLON = JDKUtils.UNSAFE.getShort(chars, JDKUtils.ARRAY_CHAR_BASE_OFFSET + 6L);
        chars[6] = 39;
        QUOTE_COLON = JDKUtils.UNSAFE.getShort(chars, JDKUtils.ARRAY_CHAR_BASE_OFFSET + 6L);
    }
}

