/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.core;

import java.nio.ByteBuffer;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.reactivestreams.Publisher;
import org.springframework.data.redis.connection.ReactiveListCommands;
import org.springframework.data.redis.connection.ReactiveRedisConnection;
import org.springframework.data.redis.connection.RedisListCommands;
import org.springframework.data.redis.core.ReactiveListOperations;
import org.springframework.data.redis.core.ReactiveRedisTemplate;
import org.springframework.data.redis.serializer.RedisSerializationContext;
import org.springframework.util.Assert;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

class DefaultReactiveListOperations<K, V>
implements ReactiveListOperations<K, V> {
    private final ReactiveRedisTemplate<?, ?> template;
    private final RedisSerializationContext<K, V> serializationContext;

    DefaultReactiveListOperations(ReactiveRedisTemplate<?, ?> template, RedisSerializationContext<K, V> serializationContext) {
        this.template = template;
        this.serializationContext = serializationContext;
    }

    @Override
    public Flux<V> range(K key, long start, long end) {
        Assert.notNull(key, (String)"Key must not be null!");
        return this.createFlux(connection -> connection.lRange(this.rawKey(key), start, end).map(this::readValue));
    }

    @Override
    public Mono<Boolean> trim(K key, long start, long end) {
        Assert.notNull(key, (String)"Key must not be null!");
        return this.createMono(connection -> connection.lTrim(this.rawKey(key), start, end));
    }

    @Override
    public Mono<Long> size(K key) {
        Assert.notNull(key, (String)"Key must not be null!");
        return this.createMono(connection -> connection.lLen(this.rawKey(key)));
    }

    @Override
    public Mono<Long> leftPush(K key, V value) {
        return this.leftPushAll(key, value);
    }

    @Override
    @SafeVarargs
    public final Mono<Long> leftPushAll(K key, V ... values) {
        Assert.notEmpty((Object[])values, (String)"Values must not be null or empty!");
        return this.leftPushAll(key, (Collection<V>)Arrays.asList(values));
    }

    @Override
    public Mono<Long> leftPushAll(K key, Collection<V> values) {
        Assert.notNull(key, (String)"Key must not be null!");
        Assert.notEmpty(values, (String)"Values must not be null or empty!");
        return this.createMono(connection -> Flux.fromIterable((Iterable)values).map(this::rawValue).collectList().flatMap(serialized -> connection.lPush(this.rawKey(key), (List<ByteBuffer>)serialized)));
    }

    @Override
    public Mono<Long> leftPushIfPresent(K key, V value) {
        Assert.notNull(key, (String)"Key must not be null!");
        return this.createMono(connection -> connection.lPushX(this.rawKey(key), this.rawValue(value)));
    }

    @Override
    public Mono<Long> leftPush(K key, V pivot, V value) {
        Assert.notNull(key, (String)"Key must not be null!");
        return this.createMono(connection -> connection.lInsert(this.rawKey(key), RedisListCommands.Position.BEFORE, this.rawValue(pivot), this.rawValue(value)));
    }

    @Override
    public Mono<Long> rightPush(K key, V value) {
        return this.rightPushAll(key, value);
    }

    @Override
    @SafeVarargs
    public final Mono<Long> rightPushAll(K key, V ... values) {
        Assert.notNull(values, (String)"Values must not be null!");
        return this.rightPushAll(key, (Collection<V>)Arrays.asList(values));
    }

    @Override
    public Mono<Long> rightPushAll(K key, Collection<V> values) {
        Assert.notNull(key, (String)"Key must not be null!");
        Assert.notEmpty(values, (String)"Values must not be null or empty!");
        return this.createMono(connection -> Flux.fromIterable((Iterable)values).map(this::rawValue).collectList().flatMap(serialized -> connection.rPush(this.rawKey(key), (List<ByteBuffer>)serialized)));
    }

    @Override
    public Mono<Long> rightPushIfPresent(K key, V value) {
        Assert.notNull(key, (String)"Key must not be null!");
        return this.createMono(connection -> connection.rPushX(this.rawKey(key), this.rawValue(value)));
    }

    @Override
    public Mono<Long> rightPush(K key, V pivot, V value) {
        Assert.notNull(key, (String)"Key must not be null!");
        return this.createMono(connection -> connection.lInsert(this.rawKey(key), RedisListCommands.Position.AFTER, this.rawValue(pivot), this.rawValue(value)));
    }

    @Override
    public Mono<Boolean> set(K key, long index, V value) {
        Assert.notNull(key, (String)"Key must not be null!");
        return this.createMono(connection -> connection.lSet(this.rawKey(key), index, this.rawValue(value)));
    }

    @Override
    public Mono<Long> remove(K key, long count, Object value) {
        Assert.notNull(key, (String)"Key must not be null!");
        return this.createMono(connection -> connection.lRem(this.rawKey(key), count, this.rawValue(value)));
    }

    @Override
    public Mono<V> index(K key, long index) {
        Assert.notNull(key, (String)"Key must not be null!");
        return this.createMono(connection -> connection.lIndex(this.rawKey(key), index).map(this::readValue));
    }

    @Override
    public Mono<Long> indexOf(K key, V value) {
        Assert.notNull(key, (String)"Key must not be null!");
        return this.createMono(connection -> connection.lPos(this.rawKey(key), this.rawValue(value)));
    }

    @Override
    public Mono<Long> lastIndexOf(K key, V value) {
        Assert.notNull(key, (String)"Key must not be null!");
        return this.createMono(connection -> connection.lPos(ReactiveListCommands.LPosCommand.lPosOf(this.rawValue(value)).from(this.rawKey(key)).rank(-1)));
    }

    @Override
    public Mono<V> leftPop(K key) {
        Assert.notNull(key, (String)"Key must not be null!");
        return this.createMono(connection -> connection.lPop(this.rawKey(key)).map(this::readValue));
    }

    @Override
    public Mono<V> leftPop(K key, Duration timeout) {
        Assert.notNull(key, (String)"Key must not be null!");
        Assert.notNull((Object)timeout, (String)"Duration must not be null!");
        Assert.isTrue((boolean)this.isZeroOrGreater1Second(timeout), (String)"Duration must be either zero or greater or equal to 1 second!");
        return this.createMono(connection -> connection.blPop(Collections.singletonList(this.rawKey(key)), timeout).map(popResult -> this.readValue(popResult.getValue())));
    }

    @Override
    public Mono<V> rightPop(K key) {
        Assert.notNull(key, (String)"Key must not be null!");
        return this.createMono(connection -> connection.rPop(this.rawKey(key)).map(this::readValue));
    }

    @Override
    public Mono<V> rightPop(K key, Duration timeout) {
        Assert.notNull(key, (String)"Key must not be null!");
        Assert.notNull((Object)timeout, (String)"Duration must not be null!");
        Assert.isTrue((boolean)this.isZeroOrGreater1Second(timeout), (String)"Duration must be either zero or greater or equal to 1 second!");
        return this.createMono(connection -> connection.brPop(Collections.singletonList(this.rawKey(key)), timeout).map(popResult -> this.readValue(popResult.getValue())));
    }

    @Override
    public Mono<V> rightPopAndLeftPush(K sourceKey, K destinationKey) {
        Assert.notNull(sourceKey, (String)"Source key must not be null!");
        Assert.notNull(destinationKey, (String)"Destination key must not be null!");
        return this.createMono(connection -> connection.rPopLPush(this.rawKey(sourceKey), this.rawKey(destinationKey)).map(this::readValue));
    }

    @Override
    public Mono<V> rightPopAndLeftPush(K sourceKey, K destinationKey, Duration timeout) {
        Assert.notNull(sourceKey, (String)"Source key must not be null!");
        Assert.notNull(destinationKey, (String)"Destination key must not be null!");
        Assert.notNull((Object)timeout, (String)"Duration must not be null!");
        Assert.isTrue((boolean)this.isZeroOrGreater1Second(timeout), (String)"Duration must be either zero or greater or equal to 1 second!");
        return this.createMono(connection -> connection.bRPopLPush(this.rawKey(sourceKey), this.rawKey(destinationKey), timeout).map(this::readValue));
    }

    @Override
    public Mono<Boolean> delete(K key) {
        Assert.notNull(key, (String)"Key must not be null!");
        return this.template.createMono((ReactiveRedisConnection connection) -> connection.keyCommands().del(this.rawKey(key))).map(l -> l != 0L);
    }

    private <T> Mono<T> createMono(Function<ReactiveListCommands, Publisher<T>> function) {
        Assert.notNull(function, (String)"Function must not be null!");
        return this.template.createMono((ReactiveRedisConnection connection) -> (Publisher)function.apply(connection.listCommands()));
    }

    private <T> Flux<T> createFlux(Function<ReactiveListCommands, Publisher<T>> function) {
        Assert.notNull(function, (String)"Function must not be null!");
        return this.template.createFlux((ReactiveRedisConnection connection) -> (Publisher)function.apply(connection.listCommands()));
    }

    private boolean isZeroOrGreater1Second(Duration timeout) {
        return timeout.isZero() || (long)timeout.getNano() % TimeUnit.NANOSECONDS.convert(1L, TimeUnit.SECONDS) == 0L;
    }

    private ByteBuffer rawKey(K key) {
        return this.serializationContext.getKeySerializationPair().write(key);
    }

    private ByteBuffer rawValue(V value) {
        return this.serializationContext.getValueSerializationPair().write(value);
    }

    private V readValue(ByteBuffer buffer) {
        return this.serializationContext.getValueSerializationPair().read(buffer);
    }
}

