-- ----------------------------
-- Table structure for watershed_model
-- ----------------------------
DROP TABLE IF EXISTS "WATERSHED_MODEL";
CREATE TABLE "WATERSHED_MODEL" (
  "model_id" BIGINT NOT NULL IDENTITY(1,1),
  "model_name" VARCHAR(100) NOT NULL,
  "model_type" VARCHAR(50) NOT NULL,
  "model_format" VARCHAR(20) NOT NULL,
  "file_path" VARCHAR(255),
  "file_size" BIGINT,
  "upload_unit" VARCHAR(100),
  "status" CHAR(1) NOT NULL DEFAULT '0',
  "Model_Coordinates" VARCHAR(50),
  "create_by" VARCHAR(64) DEFAULT '',
  "create_time" DATETIME,
  "update_by" VARCHAR(64) DEFAULT '',
  "update_time" DATETIME,
  "remark" VARCHAR(500) DEFAULT NULL,
  PRIMARY KEY ("model_id")
);

-- ----------------------------
-- Records of watershed_model
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Checks for WATERSHED_MODEL
-- ----------------------------
ALTER TABLE "WATERSHED_MODEL" ADD CONSTRAINT "watershed_model_check_1" CHECK ("status" IN ('0','1','2'));

-- ----------------------------
-- Comments for WATERSHED_MODEL
-- ----------------------------
COMMENT ON TABLE "WATERSHED_MODEL" IS '水利工程模型表';
COMMENT ON COLUMN "WATERSHED_MODEL"."model_id" IS '模型ID';
COMMENT ON COLUMN "WATERSHED_MODEL"."model_name" IS '模型名称';
COMMENT ON COLUMN "WATERSHED_MODEL"."model_type" IS '模型类型';
COMMENT ON COLUMN "WATERSHED_MODEL"."model_format" IS '模型格式';
COMMENT ON COLUMN "WATERSHED_MODEL"."file_path" IS '文件路径';
COMMENT ON COLUMN "WATERSHED_MODEL"."file_size" IS '文件大小';
COMMENT ON COLUMN "WATERSHED_MODEL"."upload_unit" IS '上传单位';
COMMENT ON COLUMN "WATERSHED_MODEL"."status" IS '模型状态（0正常 1维护中 2已删除）';
COMMENT ON COLUMN "WATERSHED_MODEL"."Model_Coordinates" IS '模型经纬度';
COMMENT ON COLUMN "WATERSHED_MODEL"."create_by" IS '创建者';
COMMENT ON COLUMN "WATERSHED_MODEL"."create_time" IS '创建时间';
COMMENT ON COLUMN "WATERSHED_MODEL"."update_by" IS '更新者';
COMMENT ON COLUMN "WATERSHED_MODEL"."update_time" IS '更新时间';
COMMENT ON COLUMN "WATERSHED_MODEL"."remark" IS '备注';