/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.util;

import com.alibaba.druid.pool.DruidDataSource;
import com.alibaba.druid.support.logging.Log;
import com.alibaba.druid.support.logging.LogFactory;
import com.alibaba.druid.util.Utils;
import java.lang.reflect.Method;
import java.sql.SQLException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.management.ObjectName;

public class DruidDataSourceUtils {
    private static final Log LOG = LogFactory.getLog(DruidDataSourceUtils.class);

    public static String getUrl(Object druidDataSource) {
        if (druidDataSource.getClass() == DruidDataSource.class) {
            return ((DruidDataSource)druidDataSource).getUrl();
        }
        try {
            Method method = druidDataSource.getClass().getMethod("getUrl", new Class[0]);
            Object obj = method.invoke(druidDataSource, new Object[0]);
            return (String)obj;
        }
        catch (Exception e) {
            LOG.error("getUrl error", e);
            return null;
        }
    }

    public static long getID(Object druidDataSource) {
        if (druidDataSource.getClass() == DruidDataSource.class) {
            return ((DruidDataSource)druidDataSource).getID();
        }
        try {
            Method method = druidDataSource.getClass().getMethod("getID", new Class[0]);
            Object obj = method.invoke(druidDataSource, new Object[0]);
            return (Long)obj;
        }
        catch (Exception e) {
            LOG.error("getID error", e);
            return -1L;
        }
    }

    public static String getName(Object druidDataSource) {
        if (druidDataSource.getClass() == DruidDataSource.class) {
            return ((DruidDataSource)druidDataSource).getName();
        }
        try {
            Method method = druidDataSource.getClass().getMethod("getName", new Class[0]);
            Object obj = method.invoke(druidDataSource, new Object[0]);
            return (String)obj;
        }
        catch (Exception e) {
            LOG.error("getUrl error", e);
            return null;
        }
    }

    public static ObjectName getObjectName(Object druidDataSource) {
        if (druidDataSource.getClass() == DruidDataSource.class) {
            return ((DruidDataSource)druidDataSource).getObjectName();
        }
        try {
            Method method = druidDataSource.getClass().getMethod("getObjectName", new Class[0]);
            Object obj = method.invoke(druidDataSource, new Object[0]);
            return (ObjectName)obj;
        }
        catch (Exception e) {
            LOG.error("getObjectName error", e);
            return null;
        }
    }

    public static Object getSqlStat(Object druidDataSource, int sqlId) {
        if (druidDataSource.getClass() == DruidDataSource.class) {
            return ((DruidDataSource)druidDataSource).getSqlStat(sqlId);
        }
        try {
            Method method = druidDataSource.getClass().getMethod("getSqlStat", Integer.TYPE);
            return method.invoke(druidDataSource, sqlId);
        }
        catch (Exception e) {
            LOG.error("getSqlStat error", e);
            return null;
        }
    }

    public static boolean isRemoveAbandoned(Object druidDataSource) {
        if (druidDataSource.getClass() == DruidDataSource.class) {
            return ((DruidDataSource)druidDataSource).isRemoveAbandoned();
        }
        try {
            Method method = druidDataSource.getClass().getMethod("isRemoveAbandoned", new Class[0]);
            Object obj = method.invoke(druidDataSource, new Object[0]);
            return (Boolean)obj;
        }
        catch (Exception e) {
            LOG.error("isRemoveAbandoned error", e);
            return false;
        }
    }

    public static Map<String, Object> getStatDataForMBean(Object druidDataSource) {
        if (druidDataSource.getClass() == DruidDataSource.class) {
            return ((DruidDataSource)druidDataSource).getStatDataForMBean();
        }
        try {
            Method method = druidDataSource.getClass().getMethod("getStatDataForMBean", new Class[0]);
            Object obj = method.invoke(druidDataSource, new Object[0]);
            return (Map)obj;
        }
        catch (Exception e) {
            LOG.error("getStatDataForMBean error", e);
            return null;
        }
    }

    public static Map<String, Object> getStatData(Object druidDataSource) {
        if (druidDataSource.getClass() == DruidDataSource.class) {
            return ((DruidDataSource)druidDataSource).getStatData();
        }
        try {
            Method method = druidDataSource.getClass().getMethod("getStatData", new Class[0]);
            Object obj = method.invoke(druidDataSource, new Object[0]);
            return (Map)obj;
        }
        catch (Exception e) {
            LOG.error("getStatData error", e);
            return null;
        }
    }

    public static Map getSqlStatMap(Object druidDataSource) {
        if (druidDataSource.getClass() == DruidDataSource.class) {
            return ((DruidDataSource)druidDataSource).getSqlStatMap();
        }
        try {
            Method method = druidDataSource.getClass().getMethod("getSqlStatMap", new Class[0]);
            Object obj = method.invoke(druidDataSource, new Object[0]);
            return (Map)obj;
        }
        catch (Exception e) {
            LOG.error("getSqlStatMap error", e);
            return null;
        }
    }

    public static Map<String, Object> getWallStatMap(Object druidDataSource) {
        if (druidDataSource.getClass() == DruidDataSource.class) {
            return ((DruidDataSource)druidDataSource).getWallStatMap();
        }
        try {
            Method method = druidDataSource.getClass().getMethod("getWallStatMap", new Class[0]);
            Object obj = method.invoke(druidDataSource, new Object[0]);
            return (Map)obj;
        }
        catch (Exception e) {
            LOG.error("getWallStatMap error", e);
            return null;
        }
    }

    public static List<Map<String, Object>> getPoolingConnectionInfo(Object druidDataSource) {
        if (druidDataSource.getClass() == DruidDataSource.class) {
            return ((DruidDataSource)druidDataSource).getPoolingConnectionInfo();
        }
        try {
            Method method = druidDataSource.getClass().getMethod("getPoolingConnectionInfo", new Class[0]);
            Object obj = method.invoke(druidDataSource, new Object[0]);
            return (List)obj;
        }
        catch (Exception e) {
            LOG.error("getPoolingConnectionInfo error", e);
            return null;
        }
    }

    public static List<String> getActiveConnectionStackTrace(Object druidDataSource) {
        if (druidDataSource.getClass() == DruidDataSource.class) {
            return ((DruidDataSource)druidDataSource).getActiveConnectionStackTrace();
        }
        try {
            Method method = druidDataSource.getClass().getMethod("getActiveConnectionStackTrace", new Class[0]);
            Object obj = method.invoke(druidDataSource, new Object[0]);
            return (List)obj;
        }
        catch (Exception e) {
            LOG.error("getActiveConnectionStackTrace error", e);
            return null;
        }
    }

    public static Integer getPropertyInt(Properties properties, String key) {
        String value = properties.getProperty(key);
        if (value != null) {
            try {
                return Integer.parseInt(value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    public static void configFromProperties(DruidDataSource druidDataSource, Properties properties) {
        Utils.trySetStringProperty(properties, "druid.name", druidDataSource::setName);
        Utils.trySetStringProperty(properties, "druid.url", druidDataSource::setUrl);
        Utils.trySetStringProperty(properties, "druid.username", druidDataSource::setUsername);
        Utils.trySetStringProperty(properties, "druid.password", druidDataSource::setPassword);
        Utils.trySetBooleanProperty(properties, "druid.testWhileIdle", druidDataSource::setTestWhileIdle);
        Utils.trySetBooleanProperty(properties, "druid.testOnBorrow", druidDataSource::setTestOnBorrow);
        String property = properties.getProperty("druid.validationQuery");
        if (property != null && property.length() > 0) {
            druidDataSource.setValidationQuery(property);
        }
        Utils.trySetBooleanProperty(properties, "druid.useGlobalDataSourceStat", druidDataSource::setUseGlobalDataSourceStat);
        Utils.trySetBooleanProperty(properties, "druid.useGloalDataSourceStat", druidDataSource::setUseGlobalDataSourceStat);
        Utils.trySetBooleanProperty(properties, "druid.asyncInit", druidDataSource::setAsyncInit);
        property = properties.getProperty("druid.filters");
        if (property != null && property.length() > 0) {
            try {
                druidDataSource.setFilters(property);
            }
            catch (SQLException e) {
                LOG.error("setFilters error", e);
            }
        }
        Utils.trySetLongProperty(properties, "druid.timeBetweenLogStatsMillis", druidDataSource::setTimeBetweenLogStatsMillis);
        property = properties.getProperty("druid.stat.sql.MaxSize");
        if (property != null && property.length() > 0) {
            try {
                int value = Integer.parseInt(property);
                if (druidDataSource.getDataSourceStat() != null) {
                    druidDataSource.getDataSourceStat().setMaxSqlSize(value);
                }
            }
            catch (NumberFormatException e) {
                LOG.error("illegal property 'druid.stat.sql.MaxSize'", e);
            }
        }
        Utils.trySetBooleanProperty(properties, "druid.clearFiltersEnable", druidDataSource::setClearFiltersEnable);
        Utils.trySetBooleanProperty(properties, "druid.resetStatEnable", druidDataSource::setResetStatEnable);
        Utils.trySetIntProperty(properties, "druid.notFullTimeoutRetryCount", druidDataSource::setNotFullTimeoutRetryCount);
        Utils.trySetLongProperty(properties, "druid.timeBetweenEvictionRunsMillis", druidDataSource::setTimeBetweenEvictionRunsMillis);
        Utils.trySetIntProperty(properties, "druid.maxWaitThreadCount", druidDataSource::setMaxWaitThreadCount);
        Utils.trySetIntProperty(properties, "druid.maxWait", druidDataSource::setMaxWait);
        Utils.trySetBooleanProperty(properties, "druid.failFast", druidDataSource::setFailFast);
        Utils.trySetLongProperty(properties, "druid.phyTimeoutMillis", druidDataSource::setPhyTimeoutMillis);
        Utils.trySetLongProperty(properties, "druid.phyMaxUseCount", druidDataSource::setPhyMaxUseCount);
        Utils.trySetLongProperty(properties, "druid.minEvictableIdleTimeMillis", druidDataSource::setMinEvictableIdleTimeMillis);
        Utils.trySetLongProperty(properties, "druid.maxEvictableIdleTimeMillis", druidDataSource::setMaxEvictableIdleTimeMillis);
        Utils.trySetBooleanProperty(properties, "druid.keepAlive", druidDataSource::setKeepAlive);
        Utils.trySetLongProperty(properties, "druid.keepAliveBetweenTimeMillis", druidDataSource::setKeepAliveBetweenTimeMillis);
        Utils.trySetBooleanProperty(properties, "druid.poolPreparedStatements", druidDataSource::setPoolPreparedStatements);
        Utils.trySetBooleanProperty(properties, "druid.initVariants", druidDataSource::setInitVariants);
        Utils.trySetBooleanProperty(properties, "druid.initGlobalVariants", druidDataSource::setInitGlobalVariants);
        Utils.trySetBooleanProperty(properties, "druid.useUnfairLock", druidDataSource::setUseUnfairLock);
        Utils.trySetStringProperty(properties, "druid.driverClassName", druidDataSource::setDriverClassName);
        Utils.trySetIntProperty(properties, "druid.initialSize", druidDataSource::setInitialSize);
        Utils.trySetIntProperty(properties, "druid.minIdle", druidDataSource::setMinIdle);
        Utils.trySetIntProperty(properties, "druid.maxActive", druidDataSource::setMaxActive);
        Utils.trySetBooleanProperty(properties, "druid.killWhenSocketReadTimeout", druidDataSource::setKillWhenSocketReadTimeout);
        Utils.trySetStringProperty(properties, "druid.connectProperties", druidDataSource::setConnectionProperties);
        Utils.trySetIntProperty(properties, "druid.maxPoolPreparedStatementPerConnectionSize", druidDataSource::setMaxPoolPreparedStatementPerConnectionSize);
        property = properties.getProperty("druid.initConnectionSqls");
        if (property != null && property.length() > 0) {
            try {
                StringTokenizer tokenizer = new StringTokenizer(property, ";");
                druidDataSource.setConnectionInitSqls(Collections.list(tokenizer));
            }
            catch (NumberFormatException e) {
                LOG.error("illegal property 'druid.initConnectionSqls'", e);
            }
        }
        if ((property = System.getProperty("druid.load.spifilter.skip")) != null && !"false".equals(property)) {
            druidDataSource.setLoadSpifilterSkip(true);
        }
        if ((property = System.getProperty("druid.checkExecuteTime")) != null && !"false".equals(property)) {
            druidDataSource.setCheckExecuteTime(true);
        }
        Utils.trySetIntProperty(properties, "druid.connectionErrorRetryAttempts", druidDataSource::setConnectionErrorRetryAttempts);
        Utils.trySetLongProperty(properties, "druid.timeBetweenConnectErrorMillis", druidDataSource::setTimeBetweenConnectErrorMillis);
        Utils.trySetBooleanProperty(properties, "druid.breakAfterAcquireFailure", druidDataSource::setBreakAfterAcquireFailure);
        Utils.trySetBooleanProperty(properties, "druid.testOnReturn", druidDataSource::setTestOnReturn);
        Utils.trySetBooleanProperty(properties, "druid.removeAbandoned", druidDataSource::setRemoveAbandoned);
        Utils.trySetBooleanProperty(properties, "druid.logAbandoned", druidDataSource::setLogAbandoned);
        Utils.trySetLongProperty(properties, "druid.removeAbandonedTimeoutMillis", druidDataSource::setRemoveAbandonedTimeoutMillis);
        Utils.trySetIntProperty(properties, "druid.validationQueryTimeout", druidDataSource::setValidationQueryTimeout);
        Utils.trySetIntProperty(properties, "druid.queryTimeout", druidDataSource::setQueryTimeout);
        Utils.trySetIntProperty(properties, "druid.connectTimeout", druidDataSource::setConnectTimeout);
        Utils.trySetIntProperty(properties, "druid.socketTimeout", druidDataSource::setSocketTimeout);
        Utils.trySetIntProperty(properties, "druid.transactionQueryTimeout", druidDataSource::setTransactionQueryTimeout);
        Utils.trySetIntProperty(properties, "druid.loginTimeout", druidDataSource::setLoginTimeout);
    }
}

