/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.common.filter;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class RefererFilter
implements Filter {
    public List<String> allowedDomains;

    public void init(FilterConfig filterConfig) throws ServletException {
        String domains = filterConfig.getInitParameter("allowedDomains");
        this.allowedDomains = Arrays.asList(domains.split(","));
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse resp = (HttpServletResponse)response;
        String referer = req.getHeader("Referer");
        if (referer == null || referer.isEmpty()) {
            resp.sendError(403, "Access denied: Referer header is required");
            return;
        }
        boolean allowed = false;
        for (String domain : this.allowedDomains) {
            if (!referer.contains(domain)) continue;
            allowed = true;
            break;
        }
        if (allowed) {
            chain.doFilter(request, response);
        } else {
            resp.sendError(403, "Access denied: Referer '" + referer + "' is not allowed");
        }
    }

    public void destroy() {
    }
}

