/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.ast.expr;

import com.alibaba.druid.sql.ast.SQLDataTypeImpl;
import com.alibaba.druid.sql.ast.SQLObject;
import com.alibaba.druid.sql.ast.expr.SQLNumericLiteralExpr;
import com.alibaba.druid.sql.ast.expr.SQLValuableExpr;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.List;

public class SQLDecimalExpr
extends SQLNumericLiteralExpr
implements SQLValuableExpr,
Comparable<SQLDecimalExpr> {
    public SQLDecimalExpr() {
        super(new SQLDataTypeImpl("DECIMAL"));
    }

    public SQLDecimalExpr(BigDecimal value) {
        this();
        this.value = value;
    }

    public SQLDecimalExpr(String value) {
        this();
        this.value = new BigDecimal(value);
    }

    @Override
    public SQLDecimalExpr clone() {
        return new SQLDecimalExpr(this.getValue());
    }

    @Override
    public List<SQLObject> getChildren() {
        return Collections.emptyList();
    }

    @Override
    public Number getNumber() {
        return this.getValue();
    }

    @Override
    public BigDecimal getValue() {
        return (BigDecimal)this.value;
    }

    public void setValue(BigDecimal value) {
        this.value = value;
    }

    @Override
    protected void accept0(SQLASTVisitor visitor) {
        visitor.visit(this);
        visitor.endVisit(this);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SQLDecimalExpr other = (SQLDecimalExpr)obj;
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    @Override
    public void setNumber(Number number) {
        if (number == null) {
            this.value = null;
            return;
        }
        this.setValue((BigDecimal)number);
    }

    @Override
    public int compareTo(SQLDecimalExpr o) {
        return this.getValue().compareTo(o.getValue());
    }

    public SQLDecimalExpr negative() {
        return new SQLDecimalExpr(this.getValue().negate());
    }
}

