/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.writer;

import com.alibaba.fastjson2.JSONWriter;
import com.alibaba.fastjson2.writer.FieldWriter;
import com.alibaba.fastjson2.writer.ObjectWriter;
import com.alibaba.fastjson2.writer.ObjectWriterImplBoolean;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Arrays;

abstract class FieldWriterBoolean
extends FieldWriter {
    final byte[] utf8ValueTrue;
    final byte[] utf8ValueFalse;
    final byte[] utf8Value1;
    final byte[] utf8Value0;
    final char[] utf16ValueTrue;
    final char[] utf16ValueFalse;
    final char[] utf16Value1;
    final char[] utf16Value0;

    FieldWriterBoolean(String name, int ordinal, long features, String format, String label, Type fieldType, Class fieldClass, Field field, Method method) {
        super(name, ordinal, features, format, null, label, fieldType, fieldClass, field, method);
        byte[] bytes = Arrays.copyOf(this.nameWithColonUTF8, this.nameWithColonUTF8.length + 4);
        bytes[this.nameWithColonUTF8.length] = 116;
        bytes[this.nameWithColonUTF8.length + 1] = 114;
        bytes[this.nameWithColonUTF8.length + 2] = 117;
        bytes[this.nameWithColonUTF8.length + 3] = 101;
        this.utf8ValueTrue = bytes;
        bytes = Arrays.copyOf(this.nameWithColonUTF8, this.nameWithColonUTF8.length + 5);
        bytes[this.nameWithColonUTF8.length] = 102;
        bytes[this.nameWithColonUTF8.length + 1] = 97;
        bytes[this.nameWithColonUTF8.length + 2] = 108;
        bytes[this.nameWithColonUTF8.length + 3] = 115;
        bytes[this.nameWithColonUTF8.length + 4] = 101;
        this.utf8ValueFalse = bytes;
        bytes = Arrays.copyOf(this.nameWithColonUTF8, this.nameWithColonUTF8.length + 1);
        bytes[this.nameWithColonUTF8.length] = 49;
        this.utf8Value1 = bytes;
        bytes = Arrays.copyOf(this.nameWithColonUTF8, this.nameWithColonUTF8.length + 1);
        bytes[this.nameWithColonUTF8.length] = 48;
        this.utf8Value0 = bytes;
        char[] chars = Arrays.copyOf(this.nameWithColonUTF16, this.nameWithColonUTF16.length + 4);
        chars[this.nameWithColonUTF16.length] = 116;
        chars[this.nameWithColonUTF16.length + 1] = 114;
        chars[this.nameWithColonUTF16.length + 2] = 117;
        chars[this.nameWithColonUTF16.length + 3] = 101;
        this.utf16ValueTrue = chars;
        chars = Arrays.copyOf(this.nameWithColonUTF16, this.nameWithColonUTF16.length + 5);
        chars[this.nameWithColonUTF16.length] = 102;
        chars[this.nameWithColonUTF16.length + 1] = 97;
        chars[this.nameWithColonUTF16.length + 2] = 108;
        chars[this.nameWithColonUTF16.length + 3] = 115;
        chars[this.nameWithColonUTF16.length + 4] = 101;
        this.utf16ValueFalse = chars;
        chars = Arrays.copyOf(this.nameWithColonUTF16, this.nameWithColonUTF16.length + 1);
        chars[this.nameWithColonUTF16.length] = 49;
        this.utf16Value1 = chars;
        chars = Arrays.copyOf(this.nameWithColonUTF16, this.nameWithColonUTF16.length + 1);
        chars[this.nameWithColonUTF16.length] = 48;
        this.utf16Value0 = chars;
    }

    public void writeValue(JSONWriter jsonWriter, Object object) {
        Boolean value = (Boolean)this.getFieldValue(object);
        if (value == null) {
            jsonWriter.writeNull();
            return;
        }
        jsonWriter.writeBool(value);
    }

    @Override
    public final void writeBool(JSONWriter jsonWriter, boolean value) {
        long features = jsonWriter.getFeatures(this.features);
        if ((features & JSONWriter.Feature.WriteNonStringValueAsString.mask) != 0L) {
            this.writeFieldName(jsonWriter);
            jsonWriter.writeString(value ? "true" : "false");
            return;
        }
        if (jsonWriter.utf8) {
            jsonWriter.writeNameRaw((features & JSONWriter.Feature.WriteBooleanAsNumber.mask) != 0L ? (value ? this.utf8Value1 : this.utf8Value0) : (value ? this.utf8ValueTrue : this.utf8ValueFalse));
            return;
        }
        if (jsonWriter.utf16) {
            jsonWriter.writeNameRaw((features & JSONWriter.Feature.WriteBooleanAsNumber.mask) != 0L ? (value ? this.utf16Value1 : this.utf16Value0) : (value ? this.utf16ValueTrue : this.utf16ValueFalse));
            return;
        }
        this.writeFieldName(jsonWriter);
        jsonWriter.writeBool(value);
    }

    public boolean write(JSONWriter jsonWriter, Object object) {
        Boolean value;
        try {
            value = (Boolean)this.getFieldValue(object);
        }
        catch (RuntimeException error) {
            if (jsonWriter.isIgnoreErrorGetter()) {
                return false;
            }
            throw error;
        }
        if (value == null) {
            long features = this.features | jsonWriter.getFeatures();
            if ((features & (JSONWriter.Feature.WriteNulls.mask | JSONWriter.Feature.NullAsDefaultValue.mask | JSONWriter.Feature.WriteNullBooleanAsFalse.mask)) == 0L) {
                return false;
            }
            this.writeFieldName(jsonWriter);
            if ((features & JSONWriter.Feature.WriteNullBooleanAsFalse.mask) != 0L) {
                jsonWriter.writeBool(false);
            } else {
                jsonWriter.writeBooleanNull();
            }
            return true;
        }
        if (this.fieldClass == Boolean.TYPE && !value.booleanValue() && (jsonWriter.getFeatures(this.features) & JSONWriter.Feature.NotWriteDefaultValue.mask) != 0L) {
            return false;
        }
        this.writeBool(jsonWriter, value);
        return true;
    }

    @Override
    public ObjectWriter getObjectWriter(JSONWriter jsonWriter, Class valueClass) {
        if (valueClass == this.fieldClass) {
            return ObjectWriterImplBoolean.INSTANCE;
        }
        return jsonWriter.getObjectWriter(valueClass);
    }
}

