/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.builders;

import java.util.Comparator;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import springfox.documentation.builders.BuilderDefaults;
import springfox.documentation.service.ApiDescription;
import springfox.documentation.service.Operation;

public class ApiDescriptionBuilder {
    private String groupName;
    private String path;
    private String summary;
    private String description;
    private List<Operation> operations;
    private Boolean hidden;
    private Function<String, String> pathDecorator = Function.identity();
    private final Comparator<Operation> operationOrdering;

    public ApiDescriptionBuilder(Comparator<Operation> operationOrdering) {
        this.operationOrdering = operationOrdering;
    }

    public ApiDescriptionBuilder path(String path) {
        this.path = BuilderDefaults.defaultIfAbsent(path, this.path);
        return this;
    }

    public ApiDescriptionBuilder description(String description) {
        this.description = BuilderDefaults.defaultIfAbsent(description, this.description);
        return this;
    }

    public ApiDescriptionBuilder operations(List<Operation> operations) {
        if (operations != null) {
            this.operations = operations.stream().sorted(this.operationOrdering).collect(Collectors.toList());
        }
        return this;
    }

    public ApiDescriptionBuilder hidden(boolean hidden) {
        this.hidden = hidden;
        return this;
    }

    public ApiDescriptionBuilder pathDecorator(Function<String, String> pathDecorator) {
        this.pathDecorator = BuilderDefaults.defaultIfAbsent(pathDecorator, this.pathDecorator);
        return this;
    }

    public ApiDescriptionBuilder groupName(String groupName) {
        this.groupName = BuilderDefaults.defaultIfAbsent(groupName, this.groupName);
        return this;
    }

    public ApiDescriptionBuilder summary(String summary) {
        this.summary = summary;
        return this;
    }

    public ApiDescription build() {
        return new ApiDescription(this.groupName, this.pathDecorator.apply(this.path), this.summary, this.description, this.operations, this.hidden);
    }
}

