/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.filter.reconnect;

import dm.jdbc.desc.DmProperties;
import dm.jdbc.driver.DBError;
import dm.jdbc.driver.DmDriver;
import dm.jdbc.driver.DmdbBlob;
import dm.jdbc.driver.DmdbCallableStatement;
import dm.jdbc.driver.DmdbClob;
import dm.jdbc.driver.DmdbConnection;
import dm.jdbc.driver.DmdbDatabaseMetaData;
import dm.jdbc.driver.DmdbIntervalDT;
import dm.jdbc.driver.DmdbIntervalYM;
import dm.jdbc.driver.DmdbParameterMetaData;
import dm.jdbc.driver.DmdbPreparedStatement;
import dm.jdbc.driver.DmdbResultSet;
import dm.jdbc.driver.DmdbResultSetMetaData;
import dm.jdbc.driver.DmdbStatement;
import dm.jdbc.driver.DmdbTimestamp;
import dm.jdbc.filter.Filter;
import dm.jdbc.filter.FilterChain;
import dm.jdbc.filter.reconnect.ReconnectController;
import dm.jdbc.filter.reconnect.ReconnectFilter$ReconnectFilterThreadHolder;
import dm.jdbc.rw.RWUtil2;
import dm.jdbc.util.CacheQueue;
import dm.jdbc.util.DriverUtil;
import dm.jdbc.util.StringUtil;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.RowIdLifetime;
import java.sql.SQLException;
import java.sql.SQLType;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;

public class ReconnectFilter
implements Filter {
    private static ReconnectController controller;

    private ReconnectFilter() {
    }

    public static ReconnectFilter getInstance() {
        return ReconnectFilter$ReconnectFilterThreadHolder.access$0();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addConnection(DmdbConnection dmdbConnection) {
        if (dmdbConnection.epGroup == null || (dmdbConnection.epGroup.reconnect & 4) == 0 && (dmdbConnection.epGroup.reconnect & 2) == 0) {
            return;
        }
        CacheQueue cacheQueue = ReconnectController.connQueue;
        synchronized (cacheQueue) {
            if (controller == null) {
                controller = new ReconnectController();
                controller.start();
            }
            ReconnectController.connQueue.put(dmdbConnection);
        }
    }

    private boolean whenError(DmdbConnection dmdbConnection, SQLException sQLException) {
        if (sQLException == null) {
            return false;
        }
        if (dmdbConnection.epGroup == null || !dmdbConnection.epGroup.isReconnectWhenError()) {
            throw sQLException;
        }
        if (sQLException.getErrorCode() == DBError.EC_SWITCH_TO_EP_SEQNO.errCode) {
            block11: {
                String string = sQLException.getMessage();
                int n2 = string.lastIndexOf("_");
                String string2 = StringUtil.trimToEmpty(string.substring(n2 + 1));
                try {
                    dmdbConnection.switchToEpSeqno = Integer.parseInt(string2);
                }
                catch (Exception exception) {
                    int n3 = -1;
                    n3 = string2.lastIndexOf(":");
                    if (n3 == -1) break block11;
                    dmdbConnection.switchToHost = StringUtil.trimToEmpty(string2.substring(0, n3));
                    dmdbConnection.switchToPort = Integer.parseInt(StringUtil.trimToEmpty(string2.substring(n3 + 1, string2.length())));
                }
            }
            if (dmdbConnection.trxFinish) {
                dmdbConnection.do_reconnect();
                return true;
            }
            dmdbConnection.do_reconnect();
            DBError.ECJDBC_CONNECTION_SWITCHED.throwz(sQLException.getMessage());
        }
        if (sQLException.getErrorCode() == DBError.ECJDBC_COMMUNITION_ERROR.errCode || sQLException.getErrorCode() == DBError.ECJDBC_CONNECTION_CLOSED.errCode) {
            try {
                if (dmdbConnection.rwSeparate > 0) {
                    RWUtil2.reconnect(dmdbConnection);
                } else {
                    dmdbConnection.do_reconnect();
                }
            }
            catch (Throwable throwable) {
                DBError.ECJDBC_CONNECTION_SWITCH_FAILED.throwz(sQLException.getMessage());
            }
            DBError.ECJDBC_CONNECTION_SWITCHED.throwz(sQLException.getMessage());
        }
        throw sQLException;
    }

    private void afterCommitRollback(DmdbConnection dmdbConnection) {
        if (!dmdbConnection.trxFinish || dmdbConnection.switchToEpSeqno < 0 && StringUtil.isEmpty(dmdbConnection.switchToHost)) {
            return;
        }
        dmdbConnection.do_reconnect();
        if (dmdbConnection.epGroup.cluster == 3) {
            DriverUtil.execute(dmdbConnection, "alter session set 'DSC_TABLESPACE_BALANCE'=0;");
        }
    }

    private void beforeExecute(DmdbConnection dmdbConnection) {
        if (!dmdbConnection.trxFinish || dmdbConnection.switchToEpSeqno < 0 && StringUtil.isEmpty(dmdbConnection.switchToHost)) {
            return;
        }
        dmdbConnection.do_reconnect();
        if (dmdbConnection.epGroup.cluster == 3) {
            DriverUtil.execute(dmdbConnection, "alter session set 'DSC_TABLESPACE_BALANCE'=0;");
        }
    }

    @Override
    public long Blob_length(FilterChain filterChain, DmdbBlob dmdbBlob) {
        try {
            return filterChain.Blob_length(dmdbBlob);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbBlob.connection, sQLException);
            return 0L;
        }
    }

    @Override
    public byte[] Blob_getBytes(FilterChain filterChain, DmdbBlob dmdbBlob, long l2, int n2) {
        try {
            return filterChain.Blob_getBytes(dmdbBlob, l2, n2);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbBlob.connection, sQLException);
            return null;
        }
    }

    @Override
    public InputStream Blob_getBinaryStream(FilterChain filterChain, DmdbBlob dmdbBlob) {
        try {
            return filterChain.Blob_getBinaryStream(dmdbBlob);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbBlob.connection, sQLException);
            return null;
        }
    }

    @Override
    public long Blob_position(FilterChain filterChain, DmdbBlob dmdbBlob, byte[] byArray, long l2) {
        try {
            return filterChain.Blob_position(dmdbBlob, byArray, l2);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbBlob.connection, sQLException);
            return 0L;
        }
    }

    @Override
    public long Blob_position(FilterChain filterChain, DmdbBlob dmdbBlob, Blob blob, long l2) {
        try {
            return filterChain.Blob_position(dmdbBlob, blob, l2);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbBlob.connection, sQLException);
            return 0L;
        }
    }

    @Override
    public int Blob_setBytes(FilterChain filterChain, DmdbBlob dmdbBlob, long l2, byte[] byArray) {
        try {
            return filterChain.Blob_setBytes(dmdbBlob, l2, byArray);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbBlob.connection, sQLException);
            return 0;
        }
    }

    @Override
    public int Blob_setBytes(FilterChain filterChain, DmdbBlob dmdbBlob, long l2, byte[] byArray, int n2, int n3) {
        try {
            return filterChain.Blob_setBytes(dmdbBlob, l2, byArray, n2, n3);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbBlob.connection, sQLException);
            return 0;
        }
    }

    @Override
    public OutputStream Blob_setBinaryStream(FilterChain filterChain, DmdbBlob dmdbBlob, long l2) {
        try {
            return filterChain.Blob_setBinaryStream(dmdbBlob, l2);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbBlob.connection, sQLException);
            return null;
        }
    }

    @Override
    public void Blob_truncate(FilterChain filterChain, DmdbBlob dmdbBlob, long l2) {
        try {
            filterChain.Blob_truncate(dmdbBlob, l2);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbBlob.connection, sQLException);
        }
    }

    @Override
    public void Blob_free(FilterChain filterChain, DmdbBlob dmdbBlob) {
        try {
            filterChain.Blob_free(dmdbBlob);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbBlob.connection, sQLException);
        }
    }

    @Override
    public InputStream Blob_getBinaryStream(FilterChain filterChain, DmdbBlob dmdbBlob, long l2, long l3) {
        try {
            return filterChain.Blob_getBinaryStream(dmdbBlob, l2, l3);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbBlob.connection, sQLException);
            return null;
        }
    }

    @Override
    public void CallableStatement_registerOutParameter(FilterChain filterChain, DmdbCallableStatement dmdbCallableStatement, int n2, int n3) {
        try {
            filterChain.CallableStatement_registerOutParameter(dmdbCallableStatement, n2, n3);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbCallableStatement.connection, sQLException);
        }
    }

    @Override
    public void CallableStatement_registerOutParameter(FilterChain filterChain, DmdbCallableStatement dmdbCallableStatement, int n2, int n3, int n4) {
        try {
            filterChain.CallableStatement_registerOutParameter(dmdbCallableStatement, n2, n3, n4);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbCallableStatement.connection, sQLException);
        }
    }

    @Override
    public boolean CallableStatement_wasNull(FilterChain filterChain, DmdbCallableStatement dmdbCallableStatement) {
        try {
            return filterChain.CallableStatement_wasNull(dmdbCallableStatement);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbCallableStatement.connection, sQLException);
            return false;
        }
    }

    @Override
    public String CallableStatement_getString(FilterChain filterChain, DmdbCallableStatement dmdbCallableStatement, int n2) {
        try {
            return filterChain.CallableStatement_getString(dmdbCallableStatement, n2);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbCallableStatement.connection, sQLException);
            return null;
        }
    }

    @Override
    public boolean CallableStatement_getBoolean(FilterChain filterChain, DmdbCallableStatement dmdbCallableStatement, int n2) {
        try {
            return filterChain.CallableStatement_getBoolean(dmdbCallableStatement, n2);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbCallableStatement.connection, sQLException);
            return false;
        }
    }

    @Override
    public byte CallableStatement_getByte(FilterChain filterChain, DmdbCallableStatement dmdbCallableStatement, int n2) {
        try {
            return filterChain.CallableStatement_getByte(dmdbCallableStatement, n2);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbCallableStatement.connection, sQLException);
            return 0;
        }
    }

    @Override
    public short CallableStatement_getShort(FilterChain filterChain, DmdbCallableStatement dmdbCallableStatement, int n2) {
        try {
            return filterChain.CallableStatement_getShort(dmdbCallableStatement, n2);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbCallableStatement.connection, sQLException);
            return 0;
        }
    }

    @Override
    public int CallableStatement_getInt(FilterChain filterChain, DmdbCallableStatement dmdbCallableStatement, int n2) {
        try {
            return filterChain.CallableStatement_getInt(dmdbCallableStatement, n2);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbCallableStatement.connection, sQLException);
            return 0;
        }
    }

    @Override
    public long CallableStatement_getLong(FilterChain filterChain, DmdbCallableStatement dmdbCallableStatement, int n2) {
        try {
            return filterChain.CallableStatement_getLong(dmdbCallableStatement, n2);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbCallableStatement.connection, sQLException);
            return 0L;
        }
    }

    @Override
    public float CallableStatement_getFloat(FilterChain filterChain, DmdbCallableStatement dmdbCallableStatement, int n2) {
        try {
            return filterChain.CallableStatement_getFloat(dmdbCallableStatement, n2);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbCallableStatement.connection, sQLException);
            return 0.0f;
        }
    }

    @Override
    public double CallableStatement_getDouble(FilterChain filterChain, DmdbCallableStatement dmdbCallableStatement, int n2) {
        try {
            return filterChain.CallableStatement_getDouble(dmdbCallableStatement, n2);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbCallableStatement.connection, sQLException);
            return 0.0;
        }
    }

    @Override
    public BigDecimal CallableStatement_getBigDecimal(FilterChain filterChain, DmdbCallableStatement dmdbCallableStatement, int n2, int n3) {
        try {
            return filterChain.CallableStatement_getBigDecimal(dmdbCallableStatement, n2, n3);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbCallableStatement.connection, sQLException);
            return null;
        }
    }

    @Override
    public byte[] CallableStatement_getBytes(FilterChain filterChain, DmdbCallableStatement dmdbCallableStatement, int n2) {
        try {
            return filterChain.CallableStatement_getBytes(dmdbCallableStatement, n2);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbCallableStatement.connection, sQLException);
            return null;
        }
    }

    @Override
    public Date CallableStatement_getDate(FilterChain filterChain, DmdbCallableStatement dmdbCallableStatement, int n2) {
        try {
            return filterChain.CallableStatement_getDate(dmdbCallableStatement, n2);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbCallableStatement.connection, sQLException);
            return null;
        }
    }

    @Override
    public Time CallableStatement_getTime(FilterChain filterChain, DmdbCallableStatement dmdbCallableStatement, int n2) {
        try {
            return filterChain.CallableStatement_getTime(dmdbCallableStatement, n2);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbCallableStatement.connection, sQLException);
            return null;
        }
    }

    @Override
    public Timestamp CallableStatement_getTimestamp(FilterChain filterChain, DmdbCallableStatement dmdbCallableStatement, int n2) {
        try {
            return filterChain.CallableStatement_getTimestamp(dmdbCallableStatement, n2);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbCallableStatement.connection, sQLException);
            return null;
        }
    }

    @Override
    public Object CallableStatement_getObject(FilterChain filterChain, DmdbCallableStatement dmdbCallableStatement, int n2) {
        try {
            return filterChain.CallableStatement_getObject(dmdbCallableStatement, n2);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbCallableStatement.connection, sQLException);
            return null;
        }
    }

    @Override
    public BigDecimal CallableStatement_getBigDecimal(FilterChain filterChain, DmdbCallableStatement dmdbCallableStatement, int n2) {
        try {
            return filterChain.CallableStatement_getBigDecimal(dmdbCallableStatement, n2);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbCallableStatement.connection, sQLException);
            return null;
        }
    }

    @Override
    public Object CallableStatement_getObject(FilterChain filterChain, DmdbCallableStatement dmdbCallableStatement, int n2, Map map) {
        try {
            return filterChain.CallableStatement_getObject(dmdbCallableStatement, n2, map);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbCallableStatement.connection, sQLException);
            return null;
        }
    }

    @Override
    public Ref CallableStatement_getRef(FilterChain filterChain, DmdbCallableStatement dmdbCallableStatement, int n2) {
        try {
            return filterChain.CallableStatement_getRef(dmdbCallableStatement, n2);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbCallableStatement.connection, sQLException);
            return null;
        }
    }

    @Override
    public Blob CallableStatement_getBlob(FilterChain filterChain, DmdbCallableStatement dmdbCallableStatement, int n2) {
        try {
            return filterChain.CallableStatement_getBlob(dmdbCallableStatement, n2);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbCallableStatement.connection, sQLException);
            return null;
        }
    }

    @Override
    public Clob CallableStatement_getClob(FilterChain filterChain, DmdbCallableStatement dmdbCallableStatement, int n2) {
        try {
            return filterChain.CallableStatement_getClob(dmdbCallableStatement, n2);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbCallableStatement.connection, sQLException);
            return null;
        }
    }

    @Override
    public Array CallableStatement_getArray(FilterChain filterChain, DmdbCallableStatement dmdbCallableStatement, int n2) {
        try {
            return filterChain.CallableStatement_getArray(dmdbCallableStatement, n2);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbCallableStatement.connection, sQLException);
            return null;
        }
    }

    @Override
    public Date CallableStatement_getDate(FilterChain filterChain, DmdbCallableStatement dmdbCallableStatement, int n2, Calendar calendar) {
        try {
            return filterChain.CallableStatement_getDate(dmdbCallableStatement, n2, calendar);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbCallableStatement.connection, sQLException);
            return null;
        }
    }

    @Override
    public Time CallableStatement_getTime(FilterChain filterChain, DmdbCallableStatement dmdbCallableStatement, int n2, Calendar calendar) {
        try {
            return filterChain.CallableStatement_getTime(dmdbCallableStatement, n2, calendar);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbCallableStatement.connection, sQLException);
            return null;
        }
    }

    @Override
    public Timestamp CallableStatement_getTimestamp(FilterChain filterChain, DmdbCallableStatement dmdbCallableStatement, int n2, Calendar calendar) {
        try {
            return filterChain.CallableStatement_getTimestamp(dmdbCallableStatement, n2, calendar);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbCallableStatement.connection, sQLException);
            return null;
        }
    }

    @Override
    public void CallableStatement_registerOutParameter(FilterChain filterChain, DmdbCallableStatement dmdbCallableStatement, int n2, int n3, String string) {
        try {
            filterChain.CallableStatement_registerOutParameter(dmdbCallableStatement, n2, n3, string);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbCallableStatement.connection, sQLException);
        }
    }

    @Override
    public void CallableStatement_registerOutParameter(FilterChain filterChain, DmdbCallableStatement dmdbCallableStatement, String string, int n2) {
        try {
            filterChain.CallableStatement_registerOutParameter(dmdbCallableStatement, string, n2);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbCallableStatement.connection, sQLException);
        }
    }

    @Override
    public void CallableStatement_registerOutParameter(FilterChain filterChain, DmdbCallableStatement dmdbCallableStatement, String string, int n2, int n3) {
        try {
            filterChain.CallableStatement_registerOutParameter(dmdbCallableStatement, string, n2, n3);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbCallableStatement.connection, sQLException);
        }
    }

    @Override
    public void CallableStatement_registerOutParameter(FilterChain filterChain, DmdbCallableStatement dmdbCallableStatement, String string, int n2, String string2) {
        try {
            filterChain.CallableStatement_registerOutParameter(dmdbCallableStatement, string, n2, string2);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbCallableStatement.connection, sQLException);
        }
    }

    @Override
    public URL CallableStatement_getURL(FilterChain filterChain, DmdbCallableStatement dmdbCallableStatement, int n2) {
        try {
            return filterChain.CallableStatement_getURL(dmdbCallableStatement, n2);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbCallableStatement.connection, sQLException);
            return null;
        }
    }

    @Override
    public void CallableStatement_setURL(FilterChain filterChain, DmdbCallableStatement dmdbCallableStatement, String string, URL uRL) {
        try {
            filterChain.CallableStatement_setURL(dmdbCallableStatement, string, uRL);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbCallableStatement.connection, sQLException);
        }
    }

    @Override
    public void CallableStatement_setNull(FilterChain filterChain, DmdbCallableStatement dmdbCallableStatement, String string, int n2) {
        try {
            filterChain.CallableStatement_setNull(dmdbCallableStatement, string, n2);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbCallableStatement.connection, sQLException);
        }
    }

    @Override
    public void CallableStatement_setBoolean(FilterChain filterChain, DmdbCallableStatement dmdbCallableStatement, String string, boolean bl) {
        try {
            filterChain.CallableStatement_setBoolean(dmdbCallableStatement, string, bl);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbCallableStatement.connection, sQLException);
        }
    }

    @Override
    public void CallableStatement_setByte(FilterChain filterChain, DmdbCallableStatement dmdbCallableStatement, String string, byte by) {
        try {
            filterChain.CallableStatement_setByte(dmdbCallableStatement, string, by);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbCallableStatement.connection, sQLException);
        }
    }

    @Override
    public void CallableStatement_setShort(FilterChain filterChain, DmdbCallableStatement dmdbCallableStatement, String string, short s2) {
        try {
            filterChain.CallableStatement_setShort(dmdbCallableStatement, string, s2);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbCallableStatement.connection, sQLException);
        }
    }

    @Override
    public void CallableStatement_setInt(FilterChain filterChain, DmdbCallableStatement dmdbCallableStatement, String string, int n2) {
        try {
            filterChain.CallableStatement_setInt(dmdbCallableStatement, string, n2);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbCallableStatement.connection, sQLException);
        }
    }

    @Override
    public void CallableStatement_setLong(FilterChain filterChain, DmdbCallableStatement dmdbCallableStatement, String string, long l2) {
        try {
            filterChain.CallableStatement_setLong(dmdbCallableStatement, string, l2);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbCallableStatement.connection, sQLException);
        }
    }

    @Override
    public void CallableStatement_setFloat(FilterChain filterChain, DmdbCallableStatement dmdbCallableStatement, String string, float f2) {
        try {
            filterChain.CallableStatement_setFloat(dmdbCallableStatement, string, f2);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbCallableStatement.connection, sQLException);
        }
    }

    @Override
    public void CallableStatement_setDouble(FilterChain filterChain, DmdbCallableStatement dmdbCallableStatement, String string, double d2) {
        try {
            filterChain.CallableStatement_setDouble(dmdbCallableStatement, string, d2);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbCallableStatement.connection, sQLException);
        }
    }

    @Override
    public void CallableStatement_setBigDecimal(FilterChain filterChain, DmdbCallableStatement dmdbCallableStatement, String string, BigDecimal bigDecimal) {
        try {
            filterChain.CallableStatement_setBigDecimal(dmdbCallableStatement, string, bigDecimal);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbCallableStatement.connection, sQLException);
        }
    }

    @Override
    public void CallableStatement_setString(FilterChain filterChain, DmdbCallableStatement dmdbCallableStatement, String string, String string2) {
        try {
            filterChain.CallableStatement_setString(dmdbCallableStatement, string, string2);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbCallableStatement.connection, sQLException);
        }
    }

    @Override
    public void CallableStatement_setBytes(FilterChain filterChain, DmdbCallableStatement dmdbCallableStatement, String string, byte[] byArray) {
        try {
            filterChain.CallableStatement_setBytes(dmdbCallableStatement, string, byArray);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbCallableStatement.connection, sQLException);
        }
    }

    @Override
    public void CallableStatement_setDate(FilterChain filterChain, DmdbCallableStatement dmdbCallableStatement, String string, Date date) {
        try {
            filterChain.CallableStatement_setDate(dmdbCallableStatement, string, date);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbCallableStatement.connection, sQLException);
        }
    }

    @Override
    public void CallableStatement_setTime(FilterChain filterChain, DmdbCallableStatement dmdbCallableStatement, String string, Time time) {
        try {
            filterChain.CallableStatement_setTime(dmdbCallableStatement, string, time);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbCallableStatement.connection, sQLException);
        }
    }

    @Override
    public void CallableStatement_setTimestamp(FilterChain filterChain, DmdbCallableStatement dmdbCallableStatement, String string, Timestamp timestamp) {
        try {
            filterChain.CallableStatement_setTimestamp(dmdbCallableStatement, string, timestamp);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbCallableStatement.connection, sQLException);
        }
    }

    @Override
    public void CallableStatement_setAsciiStream(FilterChain filterChain, DmdbCallableStatement dmdbCallableStatement, String string, InputStream inputStream, int n2) {
        try {
            filterChain.CallableStatement_setAsciiStream(dmdbCallableStatement, string, inputStream, n2);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbCallableStatement.connection, sQLException);
        }
    }

    @Override
    public void CallableStatement_setBinaryStream(FilterChain filterChain, DmdbCallableStatement dmdbCallableStatement, String string, InputStream inputStream, int n2) {
        try {
            filterChain.CallableStatement_setBinaryStream(dmdbCallableStatement, string, inputStream, n2);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbCallableStatement.connection, sQLException);
        }
    }

    @Override
    public void CallableStatement_setObject(FilterChain filterChain, DmdbCallableStatement dmdbCallableStatement, String string, Object object, int n2, int n3) {
        try {
            filterChain.CallableStatement_setObject(dmdbCallableStatement, string, object, n2, n3);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbCallableStatement.connection, sQLException);
        }
    }

    @Override
    public void CallableStatement_setObject(FilterChain filterChain, DmdbCallableStatement dmdbCallableStatement, String string, Object object, int n2) {
        try {
            filterChain.CallableStatement_setObject(dmdbCallableStatement, string, object, n2);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbCallableStatement.connection, sQLException);
        }
    }

    @Override
    public void CallableStatement_setObject(FilterChain filterChain, DmdbCallableStatement dmdbCallableStatement, String string, Object object) {
        try {
            filterChain.CallableStatement_setObject(dmdbCallableStatement, string, object);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbCallableStatement.connection, sQLException);
        }
    }

    @Override
    public void CallableStatement_setCharacterStream(FilterChain filterChain, DmdbCallableStatement dmdbCallableStatement, String string, Reader reader, int n2) {
        try {
            filterChain.CallableStatement_setCharacterStream(dmdbCallableStatement, string, reader, n2);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbCallableStatement.connection, sQLException);
        }
    }

    @Override
    public void CallableStatement_setDate(FilterChain filterChain, DmdbCallableStatement dmdbCallableStatement, String string, Date date, Calendar calendar) {
        try {
            filterChain.CallableStatement_setDate(dmdbCallableStatement, string, date, calendar);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbCallableStatement.connection, sQLException);
        }
    }

    @Override
    public void CallableStatement_setTime(FilterChain filterChain, DmdbCallableStatement dmdbCallableStatement, String string, Time time, Calendar calendar) {
        try {
            filterChain.CallableStatement_setTime(dmdbCallableStatement, string, time, calendar);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbCallableStatement.connection, sQLException);
        }
    }

    @Override
    public void CallableStatement_setTimestamp(FilterChain filterChain, DmdbCallableStatement dmdbCallableStatement, String string, Timestamp timestamp, Calendar calendar) {
        try {
            filterChain.CallableStatement_setTimestamp(dmdbCallableStatement, string, timestamp, calendar);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbCallableStatement.connection, sQLException);
        }
    }

    @Override
    public void CallableStatement_setNull(FilterChain filterChain, DmdbCallableStatement dmdbCallableStatement, String string, int n2, String string2) {
        try {
            filterChain.CallableStatement_setNull(dmdbCallableStatement, string, n2, string2);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbCallableStatement.connection, sQLException);
        }
    }

    @Override
    public String CallableStatement_getString(FilterChain filterChain, DmdbCallableStatement dmdbCallableStatement, String string) {
        try {
            return filterChain.CallableStatement_getString(dmdbCallableStatement, string);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbCallableStatement.connection, sQLException);
            return null;
        }
    }

    @Override
    public boolean CallableStatement_getBoolean(FilterChain filterChain, DmdbCallableStatement dmdbCallableStatement, String string) {
        try {
            return filterChain.CallableStatement_getBoolean(dmdbCallableStatement, string);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbCallableStatement.connection, sQLException);
            return false;
        }
    }

    @Override
    public byte CallableStatement_getByte(FilterChain filterChain, DmdbCallableStatement dmdbCallableStatement, String string) {
        try {
            return filterChain.CallableStatement_getByte(dmdbCallableStatement, string);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbCallableStatement.connection, sQLException);
            return 0;
        }
    }

    @Override
    public short CallableStatement_getShort(FilterChain filterChain, DmdbCallableStatement dmdbCallableStatement, String string) {
        try {
            return filterChain.CallableStatement_getShort(dmdbCallableStatement, string);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbCallableStatement.connection, sQLException);
            return 0;
        }
    }

    @Override
    public int CallableStatement_getInt(FilterChain filterChain, DmdbCallableStatement dmdbCallableStatement, String string) {
        try {
            return filterChain.CallableStatement_getInt(dmdbCallableStatement, string);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbCallableStatement.connection, sQLException);
            return 0;
        }
    }

    @Override
    public long CallableStatement_getLong(FilterChain filterChain, DmdbCallableStatement dmdbCallableStatement, String string) {
        try {
            return filterChain.CallableStatement_getLong(dmdbCallableStatement, string);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbCallableStatement.connection, sQLException);
            return 0L;
        }
    }

    @Override
    public float CallableStatement_getFloat(FilterChain filterChain, DmdbCallableStatement dmdbCallableStatement, String string) {
        try {
            return filterChain.CallableStatement_getFloat(dmdbCallableStatement, string);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbCallableStatement.connection, sQLException);
            return 0.0f;
        }
    }

    @Override
    public double CallableStatement_getDouble(FilterChain filterChain, DmdbCallableStatement dmdbCallableStatement, String string) {
        try {
            return filterChain.CallableStatement_getDouble(dmdbCallableStatement, string);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbCallableStatement.connection, sQLException);
            return 0.0;
        }
    }

    @Override
    public byte[] CallableStatement_getBytes(FilterChain filterChain, DmdbCallableStatement dmdbCallableStatement, String string) {
        try {
            return filterChain.CallableStatement_getBytes(dmdbCallableStatement, string);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbCallableStatement.connection, sQLException);
            return null;
        }
    }

    @Override
    public Date CallableStatement_getDate(FilterChain filterChain, DmdbCallableStatement dmdbCallableStatement, String string) {
        try {
            return filterChain.CallableStatement_getDate(dmdbCallableStatement, string);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbCallableStatement.connection, sQLException);
            return null;
        }
    }

    @Override
    public Time CallableStatement_getTime(FilterChain filterChain, DmdbCallableStatement dmdbCallableStatement, String string) {
        try {
            return filterChain.CallableStatement_getTime(dmdbCallableStatement, string);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbCallableStatement.connection, sQLException);
            return null;
        }
    }

    @Override
    public Timestamp CallableStatement_getTimestamp(FilterChain filterChain, DmdbCallableStatement dmdbCallableStatement, String string) {
        try {
            return filterChain.CallableStatement_getTimestamp(dmdbCallableStatement, string);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbCallableStatement.connection, sQLException);
            return null;
        }
    }

    @Override
    public Object CallableStatement_getObject(FilterChain filterChain, DmdbCallableStatement dmdbCallableStatement, String string) {
        try {
            return filterChain.CallableStatement_getObject(dmdbCallableStatement, string);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbCallableStatement.connection, sQLException);
            return null;
        }
    }

    @Override
    public BigDecimal CallableStatement_getBigDecimal(FilterChain filterChain, DmdbCallableStatement dmdbCallableStatement, String string) {
        try {
            return filterChain.CallableStatement_getBigDecimal(dmdbCallableStatement, string);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbCallableStatement.connection, sQLException);
            return null;
        }
    }

    @Override
    public Object CallableStatement_getObject(FilterChain filterChain, DmdbCallableStatement dmdbCallableStatement, String string, Map map) {
        try {
            return filterChain.CallableStatement_getObject(dmdbCallableStatement, string, map);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbCallableStatement.connection, sQLException);
            return null;
        }
    }

    @Override
    public Ref CallableStatement_getRef(FilterChain filterChain, DmdbCallableStatement dmdbCallableStatement, String string) {
        try {
            return filterChain.CallableStatement_getRef(dmdbCallableStatement, string);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbCallableStatement.connection, sQLException);
            return null;
        }
    }

    @Override
    public Blob CallableStatement_getBlob(FilterChain filterChain, DmdbCallableStatement dmdbCallableStatement, String string) {
        try {
            return filterChain.CallableStatement_getBlob(dmdbCallableStatement, string);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbCallableStatement.connection, sQLException);
            return null;
        }
    }

    @Override
    public Clob CallableStatement_getClob(FilterChain filterChain, DmdbCallableStatement dmdbCallableStatement, String string) {
        try {
            return filterChain.CallableStatement_getClob(dmdbCallableStatement, string);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbCallableStatement.connection, sQLException);
            return null;
        }
    }

    @Override
    public Array CallableStatement_getArray(FilterChain filterChain, DmdbCallableStatement dmdbCallableStatement, String string) {
        try {
            return filterChain.CallableStatement_getArray(dmdbCallableStatement, string);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbCallableStatement.connection, sQLException);
            return null;
        }
    }

    @Override
    public Date CallableStatement_getDate(FilterChain filterChain, DmdbCallableStatement dmdbCallableStatement, String string, Calendar calendar) {
        try {
            return filterChain.CallableStatement_getDate(dmdbCallableStatement, string, calendar);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbCallableStatement.connection, sQLException);
            return null;
        }
    }

    @Override
    public Time CallableStatement_getTime(FilterChain filterChain, DmdbCallableStatement dmdbCallableStatement, String string, Calendar calendar) {
        try {
            return filterChain.CallableStatement_getTime(dmdbCallableStatement, string, calendar);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbCallableStatement.connection, sQLException);
            return null;
        }
    }

    @Override
    public Timestamp CallableStatement_getTimestamp(FilterChain filterChain, DmdbCallableStatement dmdbCallableStatement, String string, Calendar calendar) {
        try {
            return filterChain.CallableStatement_getTimestamp(dmdbCallableStatement, string, calendar);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbCallableStatement.connection, sQLException);
            return null;
        }
    }

    @Override
    public URL CallableStatement_getURL(FilterChain filterChain, DmdbCallableStatement dmdbCallableStatement, String string) {
        try {
            return filterChain.CallableStatement_getURL(dmdbCallableStatement, string);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbCallableStatement.connection, sQLException);
            return null;
        }
    }

    @Override
    public RowId CallableStatement_getRowId(FilterChain filterChain, DmdbCallableStatement dmdbCallableStatement, int n2) {
        try {
            return filterChain.CallableStatement_getRowId(dmdbCallableStatement, n2);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbCallableStatement.connection, sQLException);
            return null;
        }
    }

    @Override
    public RowId CallableStatement_getRowId(FilterChain filterChain, DmdbCallableStatement dmdbCallableStatement, String string) {
        try {
            return filterChain.CallableStatement_getRowId(dmdbCallableStatement, string);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbCallableStatement.connection, sQLException);
            return null;
        }
    }

    @Override
    public void CallableStatement_setRowId(FilterChain filterChain, DmdbCallableStatement dmdbCallableStatement, String string, RowId rowId) {
        try {
            filterChain.CallableStatement_setRowId(dmdbCallableStatement, string, rowId);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbCallableStatement.connection, sQLException);
        }
    }

    @Override
    public void CallableStatement_setNString(FilterChain filterChain, DmdbCallableStatement dmdbCallableStatement, String string, String string2) {
        try {
            filterChain.CallableStatement_setNString(dmdbCallableStatement, string, string2);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbCallableStatement.connection, sQLException);
        }
    }

    @Override
    public void CallableStatement_setNCharacterStream(FilterChain filterChain, DmdbCallableStatement dmdbCallableStatement, String string, Reader reader, long l2) {
        try {
            filterChain.CallableStatement_setNCharacterStream(dmdbCallableStatement, string, reader, l2);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbCallableStatement.connection, sQLException);
        }
    }

    @Override
    public void CallableStatement_setNClob(FilterChain filterChain, DmdbCallableStatement dmdbCallableStatement, String string, NClob nClob) {
        try {
            filterChain.CallableStatement_setNClob(dmdbCallableStatement, string, nClob);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbCallableStatement.connection, sQLException);
        }
    }

    @Override
    public void CallableStatement_setClob(FilterChain filterChain, DmdbCallableStatement dmdbCallableStatement, String string, Reader reader, long l2) {
        try {
            filterChain.CallableStatement_setClob(dmdbCallableStatement, string, reader, l2);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbCallableStatement.connection, sQLException);
        }
    }

    @Override
    public void CallableStatement_setBlob(FilterChain filterChain, DmdbCallableStatement dmdbCallableStatement, String string, InputStream inputStream, long l2) {
        try {
            filterChain.CallableStatement_setBlob(dmdbCallableStatement, string, inputStream, l2);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbCallableStatement.connection, sQLException);
        }
    }

    @Override
    public void CallableStatement_setNClob(FilterChain filterChain, DmdbCallableStatement dmdbCallableStatement, String string, Reader reader, long l2) {
        try {
            filterChain.CallableStatement_setNClob(dmdbCallableStatement, string, reader, l2);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbCallableStatement.connection, sQLException);
        }
    }

    @Override
    public NClob CallableStatement_getNClob(FilterChain filterChain, DmdbCallableStatement dmdbCallableStatement, int n2) {
        try {
            return filterChain.CallableStatement_getNClob(dmdbCallableStatement, n2);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbCallableStatement.connection, sQLException);
            return null;
        }
    }

    @Override
    public NClob CallableStatement_getNClob(FilterChain filterChain, DmdbCallableStatement dmdbCallableStatement, String string) {
        try {
            return filterChain.CallableStatement_getNClob(dmdbCallableStatement, string);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbCallableStatement.connection, sQLException);
            return null;
        }
    }

    @Override
    public void CallableStatement_setSQLXML(FilterChain filterChain, DmdbCallableStatement dmdbCallableStatement, String string, SQLXML sQLXML) {
        try {
            filterChain.CallableStatement_setSQLXML(dmdbCallableStatement, string, sQLXML);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbCallableStatement.connection, sQLException);
        }
    }

    @Override
    public SQLXML CallableStatement_getSQLXML(FilterChain filterChain, DmdbCallableStatement dmdbCallableStatement, int n2) {
        try {
            return filterChain.CallableStatement_getSQLXML(dmdbCallableStatement, n2);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbCallableStatement.connection, sQLException);
            return null;
        }
    }

    @Override
    public SQLXML CallableStatement_getSQLXML(FilterChain filterChain, DmdbCallableStatement dmdbCallableStatement, String string) {
        try {
            return filterChain.CallableStatement_getSQLXML(dmdbCallableStatement, string);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbCallableStatement.connection, sQLException);
            return null;
        }
    }

    @Override
    public String CallableStatement_getNString(FilterChain filterChain, DmdbCallableStatement dmdbCallableStatement, int n2) {
        try {
            return filterChain.CallableStatement_getNString(dmdbCallableStatement, n2);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbCallableStatement.connection, sQLException);
            return null;
        }
    }

    @Override
    public String CallableStatement_getNString(FilterChain filterChain, DmdbCallableStatement dmdbCallableStatement, String string) {
        try {
            return filterChain.CallableStatement_getNString(dmdbCallableStatement, string);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbCallableStatement.connection, sQLException);
            return null;
        }
    }

    @Override
    public Reader CallableStatement_getNCharacterStream(FilterChain filterChain, DmdbCallableStatement dmdbCallableStatement, int n2) {
        try {
            return filterChain.CallableStatement_getNCharacterStream(dmdbCallableStatement, n2);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbCallableStatement.connection, sQLException);
            return null;
        }
    }

    @Override
    public Reader CallableStatement_getNCharacterStream(FilterChain filterChain, DmdbCallableStatement dmdbCallableStatement, String string) {
        try {
            return filterChain.CallableStatement_getNCharacterStream(dmdbCallableStatement, string);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbCallableStatement.connection, sQLException);
            return null;
        }
    }

    @Override
    public Reader CallableStatement_getCharacterStream(FilterChain filterChain, DmdbCallableStatement dmdbCallableStatement, int n2) {
        try {
            return filterChain.CallableStatement_getCharacterStream(dmdbCallableStatement, n2);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbCallableStatement.connection, sQLException);
            return null;
        }
    }

    @Override
    public Reader CallableStatement_getCharacterStream(FilterChain filterChain, DmdbCallableStatement dmdbCallableStatement, String string) {
        try {
            return filterChain.CallableStatement_getCharacterStream(dmdbCallableStatement, string);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbCallableStatement.connection, sQLException);
            return null;
        }
    }

    @Override
    public void CallableStatement_setBlob(FilterChain filterChain, DmdbCallableStatement dmdbCallableStatement, String string, Blob blob) {
        try {
            filterChain.CallableStatement_setBlob(dmdbCallableStatement, string, blob);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbCallableStatement.connection, sQLException);
        }
    }

    @Override
    public void CallableStatement_setClob(FilterChain filterChain, DmdbCallableStatement dmdbCallableStatement, String string, Clob clob) {
        try {
            filterChain.CallableStatement_setClob(dmdbCallableStatement, string, clob);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbCallableStatement.connection, sQLException);
        }
    }

    @Override
    public void CallableStatement_setAsciiStream(FilterChain filterChain, DmdbCallableStatement dmdbCallableStatement, String string, InputStream inputStream, long l2) {
        try {
            filterChain.CallableStatement_setAsciiStream(dmdbCallableStatement, string, inputStream, l2);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbCallableStatement.connection, sQLException);
        }
    }

    @Override
    public void CallableStatement_setBinaryStream(FilterChain filterChain, DmdbCallableStatement dmdbCallableStatement, String string, InputStream inputStream, long l2) {
        try {
            filterChain.CallableStatement_setBinaryStream(dmdbCallableStatement, string, inputStream, l2);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbCallableStatement.connection, sQLException);
        }
    }

    @Override
    public void CallableStatement_setCharacterStream(FilterChain filterChain, DmdbCallableStatement dmdbCallableStatement, String string, Reader reader, long l2) {
        try {
            filterChain.CallableStatement_setCharacterStream(dmdbCallableStatement, string, reader, l2);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbCallableStatement.connection, sQLException);
        }
    }

    @Override
    public void CallableStatement_setAsciiStream(FilterChain filterChain, DmdbCallableStatement dmdbCallableStatement, String string, InputStream inputStream) {
        try {
            filterChain.CallableStatement_setAsciiStream(dmdbCallableStatement, string, inputStream);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbCallableStatement.connection, sQLException);
        }
    }

    @Override
    public void CallableStatement_setBinaryStream(FilterChain filterChain, DmdbCallableStatement dmdbCallableStatement, String string, InputStream inputStream) {
        try {
            filterChain.CallableStatement_setBinaryStream(dmdbCallableStatement, string, inputStream);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbCallableStatement.connection, sQLException);
        }
    }

    @Override
    public void CallableStatement_setCharacterStream(FilterChain filterChain, DmdbCallableStatement dmdbCallableStatement, String string, Reader reader) {
        try {
            filterChain.CallableStatement_setCharacterStream(dmdbCallableStatement, string, reader);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbCallableStatement.connection, sQLException);
        }
    }

    @Override
    public void CallableStatement_setNCharacterStream(FilterChain filterChain, DmdbCallableStatement dmdbCallableStatement, String string, Reader reader) {
        try {
            filterChain.CallableStatement_setNCharacterStream(dmdbCallableStatement, string, reader);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbCallableStatement.connection, sQLException);
        }
    }

    @Override
    public void CallableStatement_setClob(FilterChain filterChain, DmdbCallableStatement dmdbCallableStatement, String string, Reader reader) {
        try {
            filterChain.CallableStatement_setClob(dmdbCallableStatement, string, reader);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbCallableStatement.connection, sQLException);
        }
    }

    @Override
    public void CallableStatement_setBlob(FilterChain filterChain, DmdbCallableStatement dmdbCallableStatement, String string, InputStream inputStream) {
        try {
            filterChain.CallableStatement_setBlob(dmdbCallableStatement, string, inputStream);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbCallableStatement.connection, sQLException);
        }
    }

    @Override
    public void CallableStatement_setNClob(FilterChain filterChain, DmdbCallableStatement dmdbCallableStatement, String string, Reader reader) {
        try {
            filterChain.CallableStatement_setNClob(dmdbCallableStatement, string, reader);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbCallableStatement.connection, sQLException);
        }
    }

    @Override
    public Object CallableStatement_getObject(FilterChain filterChain, DmdbCallableStatement dmdbCallableStatement, int n2, Class clazz) {
        try {
            return filterChain.CallableStatement_getObject(dmdbCallableStatement, n2, clazz);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbCallableStatement.connection, sQLException);
            return null;
        }
    }

    @Override
    public Object CallableStatement_getObject(FilterChain filterChain, DmdbCallableStatement dmdbCallableStatement, String string, Class clazz) {
        try {
            return filterChain.CallableStatement_getObject(dmdbCallableStatement, string, clazz);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbCallableStatement.connection, sQLException);
            return null;
        }
    }

    @Override
    public void CallableStatement_setObject(FilterChain filterChain, DmdbCallableStatement dmdbCallableStatement, String string, Object object, SQLType sQLType, int n2) {
        try {
            filterChain.CallableStatement_setObject(dmdbCallableStatement, string, object, sQLType, n2);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbCallableStatement.connection, sQLException);
        }
    }

    @Override
    public void CallableStatement_setObject(FilterChain filterChain, DmdbCallableStatement dmdbCallableStatement, String string, Object object, SQLType sQLType) {
        try {
            filterChain.CallableStatement_setObject(dmdbCallableStatement, string, object, sQLType);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbCallableStatement.connection, sQLException);
        }
    }

    @Override
    public void CallableStatement_registerOutParameter(FilterChain filterChain, DmdbCallableStatement dmdbCallableStatement, int n2, SQLType sQLType) {
        try {
            filterChain.CallableStatement_registerOutParameter(dmdbCallableStatement, n2, sQLType);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbCallableStatement.connection, sQLException);
        }
    }

    @Override
    public void CallableStatement_registerOutParameter(FilterChain filterChain, DmdbCallableStatement dmdbCallableStatement, int n2, SQLType sQLType, int n3) {
        try {
            filterChain.CallableStatement_registerOutParameter(dmdbCallableStatement, n2, sQLType, n3);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbCallableStatement.connection, sQLException);
        }
    }

    @Override
    public void CallableStatement_registerOutParameter(FilterChain filterChain, DmdbCallableStatement dmdbCallableStatement, int n2, SQLType sQLType, String string) {
        try {
            filterChain.CallableStatement_registerOutParameter(dmdbCallableStatement, n2, sQLType, string);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbCallableStatement.connection, sQLException);
        }
    }

    @Override
    public void CallableStatement_registerOutParameter(FilterChain filterChain, DmdbCallableStatement dmdbCallableStatement, String string, SQLType sQLType) {
        try {
            filterChain.CallableStatement_registerOutParameter(dmdbCallableStatement, string, sQLType);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbCallableStatement.connection, sQLException);
        }
    }

    @Override
    public void CallableStatement_registerOutParameter(FilterChain filterChain, DmdbCallableStatement dmdbCallableStatement, String string, SQLType sQLType, int n2) {
        try {
            filterChain.CallableStatement_registerOutParameter(dmdbCallableStatement, string, sQLType, n2);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbCallableStatement.connection, sQLException);
        }
    }

    @Override
    public void CallableStatement_registerOutParameter(FilterChain filterChain, DmdbCallableStatement dmdbCallableStatement, String string, SQLType sQLType, String string2) {
        try {
            filterChain.CallableStatement_registerOutParameter(dmdbCallableStatement, string, sQLType, string2);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbCallableStatement.connection, sQLException);
        }
    }

    @Override
    public long Clob_length(FilterChain filterChain, DmdbClob dmdbClob) {
        try {
            return filterChain.Clob_length(dmdbClob);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbClob.connection, sQLException);
            return 0L;
        }
    }

    @Override
    public String Clob_getSubString(FilterChain filterChain, DmdbClob dmdbClob, long l2, int n2) {
        try {
            return filterChain.Clob_getSubString(dmdbClob, l2, n2);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbClob.connection, sQLException);
            return null;
        }
    }

    @Override
    public Reader Clob_getCharacterStream(FilterChain filterChain, DmdbClob dmdbClob) {
        try {
            return filterChain.Clob_getCharacterStream(dmdbClob);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbClob.connection, sQLException);
            return null;
        }
    }

    @Override
    public InputStream Clob_getAsciiStream(FilterChain filterChain, DmdbClob dmdbClob) {
        try {
            return filterChain.Clob_getAsciiStream(dmdbClob);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbClob.connection, sQLException);
            return null;
        }
    }

    @Override
    public long Clob_position(FilterChain filterChain, DmdbClob dmdbClob, String string, long l2) {
        try {
            return filterChain.Clob_position(dmdbClob, string, l2);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbClob.connection, sQLException);
            return 0L;
        }
    }

    @Override
    public long Clob_position(FilterChain filterChain, DmdbClob dmdbClob, Clob clob, long l2) {
        try {
            return filterChain.Clob_position(dmdbClob, clob, l2);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbClob.connection, sQLException);
            return 0L;
        }
    }

    @Override
    public int Clob_setString(FilterChain filterChain, DmdbClob dmdbClob, long l2, String string) {
        try {
            return filterChain.Clob_setString(dmdbClob, l2, string);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbClob.connection, sQLException);
            return 0;
        }
    }

    @Override
    public int Clob_setString(FilterChain filterChain, DmdbClob dmdbClob, long l2, String string, int n2, int n3) {
        try {
            return filterChain.Clob_setString(dmdbClob, l2, string, n2, n3);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbClob.connection, sQLException);
            return 0;
        }
    }

    @Override
    public OutputStream Clob_setAsciiStream(FilterChain filterChain, DmdbClob dmdbClob, long l2) {
        try {
            return filterChain.Clob_setAsciiStream(dmdbClob, l2);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbClob.connection, sQLException);
            return null;
        }
    }

    @Override
    public Writer Clob_setCharacterStream(FilterChain filterChain, DmdbClob dmdbClob, long l2) {
        try {
            return filterChain.Clob_setCharacterStream(dmdbClob, l2);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbClob.connection, sQLException);
            return null;
        }
    }

    @Override
    public void Clob_truncate(FilterChain filterChain, DmdbClob dmdbClob, long l2) {
        try {
            filterChain.Clob_truncate(dmdbClob, l2);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbClob.connection, sQLException);
        }
    }

    @Override
    public void Clob_free(FilterChain filterChain, DmdbClob dmdbClob) {
        try {
            filterChain.Clob_free(dmdbClob);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbClob.connection, sQLException);
        }
    }

    @Override
    public Reader Clob_getCharacterStream(FilterChain filterChain, DmdbClob dmdbClob, long l2, long l3) {
        try {
            return filterChain.Clob_getCharacterStream(dmdbClob, l2, l3);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbClob.connection, sQLException);
            return null;
        }
    }

    @Override
    public void Connection_reconnect(FilterChain filterChain, DmdbConnection dmdbConnection) {
        try {
            filterChain.Connection_reconnect(dmdbConnection);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbConnection, sQLException);
        }
    }

    @Override
    public Statement Connection_createStatement(FilterChain filterChain, DmdbConnection dmdbConnection) {
        try {
            return filterChain.Connection_createStatement(dmdbConnection);
        }
        catch (SQLException sQLException) {
            if (this.whenError(dmdbConnection, sQLException)) {
                dmdbConnection.do_createStatement();
            }
            return null;
        }
    }

    @Override
    public PreparedStatement Connection_prepareStatement(FilterChain filterChain, DmdbConnection dmdbConnection, String string) {
        try {
            return filterChain.Connection_prepareStatement(dmdbConnection, string);
        }
        catch (SQLException sQLException) {
            if (this.whenError(dmdbConnection, sQLException)) {
                dmdbConnection.do_prepareStatement(string);
            }
            return null;
        }
    }

    @Override
    public CallableStatement Connection_prepareCall(FilterChain filterChain, DmdbConnection dmdbConnection, String string) {
        try {
            return filterChain.Connection_prepareCall(dmdbConnection, string);
        }
        catch (SQLException sQLException) {
            if (this.whenError(dmdbConnection, sQLException)) {
                dmdbConnection.do_prepareCall(string);
            }
            return null;
        }
    }

    @Override
    public String Connection_nativeSQL(FilterChain filterChain, DmdbConnection dmdbConnection, String string) {
        try {
            return filterChain.Connection_nativeSQL(dmdbConnection, string);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbConnection, sQLException);
            return null;
        }
    }

    @Override
    public void Connection_setAutoCommit(FilterChain filterChain, DmdbConnection dmdbConnection, boolean bl) {
        try {
            filterChain.Connection_setAutoCommit(dmdbConnection, bl);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbConnection, sQLException);
        }
    }

    @Override
    public boolean Connection_getAutoCommit(FilterChain filterChain, DmdbConnection dmdbConnection) {
        try {
            return filterChain.Connection_getAutoCommit(dmdbConnection);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbConnection, sQLException);
            return false;
        }
    }

    @Override
    public void Connection_commit(FilterChain filterChain, DmdbConnection dmdbConnection) {
        block2: {
            try {
                filterChain.Connection_commit(dmdbConnection);
                this.afterCommitRollback(dmdbConnection);
            }
            catch (SQLException sQLException) {
                if (!this.whenError(dmdbConnection, sQLException)) break block2;
                dmdbConnection.do_commit();
            }
        }
    }

    @Override
    public void Connection_rollback(FilterChain filterChain, DmdbConnection dmdbConnection) {
        block2: {
            try {
                filterChain.Connection_rollback(dmdbConnection);
                this.afterCommitRollback(dmdbConnection);
            }
            catch (SQLException sQLException) {
                if (!this.whenError(dmdbConnection, sQLException)) break block2;
                dmdbConnection.do_rollback();
            }
        }
    }

    @Override
    public void Connection_close(FilterChain filterChain, DmdbConnection dmdbConnection) {
        try {
            filterChain.Connection_close(dmdbConnection);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbConnection, sQLException);
        }
    }

    @Override
    public boolean Connection_isClosed(FilterChain filterChain, DmdbConnection dmdbConnection) {
        try {
            return filterChain.Connection_isClosed(dmdbConnection);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbConnection, sQLException);
            return false;
        }
    }

    @Override
    public DatabaseMetaData Connection_getMetaData(FilterChain filterChain, DmdbConnection dmdbConnection) {
        try {
            return filterChain.Connection_getMetaData(dmdbConnection);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbConnection, sQLException);
            return null;
        }
    }

    @Override
    public void Connection_setReadOnly(FilterChain filterChain, DmdbConnection dmdbConnection, boolean bl) {
        try {
            filterChain.Connection_setReadOnly(dmdbConnection, bl);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbConnection, sQLException);
        }
    }

    @Override
    public boolean Connection_isReadOnly(FilterChain filterChain, DmdbConnection dmdbConnection) {
        try {
            return filterChain.Connection_isReadOnly(dmdbConnection);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbConnection, sQLException);
            return false;
        }
    }

    @Override
    public void Connection_setCatalog(FilterChain filterChain, DmdbConnection dmdbConnection, String string) {
        try {
            filterChain.Connection_setCatalog(dmdbConnection, string);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbConnection, sQLException);
        }
    }

    @Override
    public String Connection_getCatalog(FilterChain filterChain, DmdbConnection dmdbConnection) {
        try {
            return filterChain.Connection_getCatalog(dmdbConnection);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbConnection, sQLException);
            return null;
        }
    }

    @Override
    public void Connection_setTransactionIsolation(FilterChain filterChain, DmdbConnection dmdbConnection, int n2) {
        try {
            filterChain.Connection_setTransactionIsolation(dmdbConnection, n2);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbConnection, sQLException);
        }
    }

    @Override
    public int Connection_getTransactionIsolation(FilterChain filterChain, DmdbConnection dmdbConnection) {
        try {
            return filterChain.Connection_getTransactionIsolation(dmdbConnection);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbConnection, sQLException);
            return 0;
        }
    }

    @Override
    public SQLWarning Connection_getWarnings(FilterChain filterChain, DmdbConnection dmdbConnection) {
        try {
            return filterChain.Connection_getWarnings(dmdbConnection);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbConnection, sQLException);
            return null;
        }
    }

    @Override
    public void Connection_clearWarnings(FilterChain filterChain, DmdbConnection dmdbConnection) {
        try {
            filterChain.Connection_clearWarnings(dmdbConnection);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbConnection, sQLException);
        }
    }

    @Override
    public Statement Connection_createStatement(FilterChain filterChain, DmdbConnection dmdbConnection, int n2, int n3) {
        try {
            return filterChain.Connection_createStatement(dmdbConnection, n2, n3);
        }
        catch (SQLException sQLException) {
            if (this.whenError(dmdbConnection, sQLException)) {
                dmdbConnection.do_createStatement(n2, n3);
            }
            return null;
        }
    }

    @Override
    public PreparedStatement Connection_prepareStatement(FilterChain filterChain, DmdbConnection dmdbConnection, String string, int n2, int n3) {
        try {
            return filterChain.Connection_prepareStatement(dmdbConnection, string, n2, n3);
        }
        catch (SQLException sQLException) {
            if (this.whenError(dmdbConnection, sQLException)) {
                dmdbConnection.do_prepareStatement(string, n2, n3);
            }
            return null;
        }
    }

    @Override
    public CallableStatement Connection_prepareCall(FilterChain filterChain, DmdbConnection dmdbConnection, String string, int n2, int n3) {
        try {
            return filterChain.Connection_prepareCall(dmdbConnection, string, n2, n3);
        }
        catch (SQLException sQLException) {
            if (this.whenError(dmdbConnection, sQLException)) {
                dmdbConnection.do_prepareCall(string, n2, n3);
            }
            return null;
        }
    }

    @Override
    public Map Connection_getTypeMap(FilterChain filterChain, DmdbConnection dmdbConnection) {
        try {
            return filterChain.Connection_getTypeMap(dmdbConnection);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbConnection, sQLException);
            return null;
        }
    }

    @Override
    public void Connection_setTypeMap(FilterChain filterChain, DmdbConnection dmdbConnection, Map map) {
        try {
            filterChain.Connection_setTypeMap(dmdbConnection, map);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbConnection, sQLException);
        }
    }

    @Override
    public void Connection_setHoldability(FilterChain filterChain, DmdbConnection dmdbConnection, int n2) {
        try {
            filterChain.Connection_setHoldability(dmdbConnection, n2);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbConnection, sQLException);
        }
    }

    @Override
    public int Connection_getHoldability(FilterChain filterChain, DmdbConnection dmdbConnection) {
        try {
            return filterChain.Connection_getHoldability(dmdbConnection);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbConnection, sQLException);
            return 0;
        }
    }

    @Override
    public Savepoint Connection_setSavepoint(FilterChain filterChain, DmdbConnection dmdbConnection) {
        try {
            return filterChain.Connection_setSavepoint(dmdbConnection);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbConnection, sQLException);
            return null;
        }
    }

    @Override
    public Savepoint Connection_setSavepoint(FilterChain filterChain, DmdbConnection dmdbConnection, String string) {
        try {
            return filterChain.Connection_setSavepoint(dmdbConnection, string);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbConnection, sQLException);
            return null;
        }
    }

    @Override
    public void Connection_rollback(FilterChain filterChain, DmdbConnection dmdbConnection, Savepoint savepoint) {
        try {
            filterChain.Connection_rollback(dmdbConnection, savepoint);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbConnection, sQLException);
        }
    }

    @Override
    public void Connection_releaseSavepoint(FilterChain filterChain, DmdbConnection dmdbConnection, Savepoint savepoint) {
        try {
            filterChain.Connection_releaseSavepoint(dmdbConnection, savepoint);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbConnection, sQLException);
        }
    }

    @Override
    public Statement Connection_createStatement(FilterChain filterChain, DmdbConnection dmdbConnection, int n2, int n3, int n4) {
        try {
            return filterChain.Connection_createStatement(dmdbConnection, n2, n3, n4);
        }
        catch (SQLException sQLException) {
            if (this.whenError(dmdbConnection, sQLException)) {
                dmdbConnection.do_createStatement(n2, n3, n4);
            }
            return null;
        }
    }

    @Override
    public PreparedStatement Connection_prepareStatement(FilterChain filterChain, DmdbConnection dmdbConnection, String string, int n2, int n3, int n4) {
        try {
            return filterChain.Connection_prepareStatement(dmdbConnection, string, n2, n3, n4);
        }
        catch (SQLException sQLException) {
            if (this.whenError(dmdbConnection, sQLException)) {
                dmdbConnection.do_prepareStatement(string, n2, n3, n4);
            }
            return null;
        }
    }

    @Override
    public CallableStatement Connection_prepareCall(FilterChain filterChain, DmdbConnection dmdbConnection, String string, int n2, int n3, int n4) {
        try {
            return filterChain.Connection_prepareCall(dmdbConnection, string, n2, n3, n4);
        }
        catch (SQLException sQLException) {
            if (this.whenError(dmdbConnection, sQLException)) {
                dmdbConnection.do_prepareCall(string, n2, n3, n4);
            }
            return null;
        }
    }

    @Override
    public PreparedStatement Connection_prepareStatement(FilterChain filterChain, DmdbConnection dmdbConnection, String string, int n2) {
        try {
            return filterChain.Connection_prepareStatement(dmdbConnection, string, n2);
        }
        catch (SQLException sQLException) {
            if (this.whenError(dmdbConnection, sQLException)) {
                dmdbConnection.do_prepareStatement(string, n2);
            }
            return null;
        }
    }

    @Override
    public PreparedStatement Connection_prepareStatement(FilterChain filterChain, DmdbConnection dmdbConnection, String string, int[] nArray) {
        try {
            return filterChain.Connection_prepareStatement(dmdbConnection, string, nArray);
        }
        catch (SQLException sQLException) {
            if (this.whenError(dmdbConnection, sQLException)) {
                dmdbConnection.do_prepareStatement(string, nArray);
            }
            return null;
        }
    }

    @Override
    public PreparedStatement Connection_prepareStatement(FilterChain filterChain, DmdbConnection dmdbConnection, String string, String[] stringArray) {
        try {
            return filterChain.Connection_prepareStatement(dmdbConnection, string, stringArray);
        }
        catch (SQLException sQLException) {
            if (this.whenError(dmdbConnection, sQLException)) {
                dmdbConnection.do_prepareStatement(string, stringArray);
            }
            return null;
        }
    }

    @Override
    public Clob Connection_createClob(FilterChain filterChain, DmdbConnection dmdbConnection) {
        try {
            return filterChain.Connection_createClob(dmdbConnection);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbConnection, sQLException);
            return null;
        }
    }

    @Override
    public Blob Connection_createBlob(FilterChain filterChain, DmdbConnection dmdbConnection) {
        try {
            return filterChain.Connection_createBlob(dmdbConnection);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbConnection, sQLException);
            return null;
        }
    }

    @Override
    public NClob Connection_createNClob(FilterChain filterChain, DmdbConnection dmdbConnection) {
        try {
            return filterChain.Connection_createNClob(dmdbConnection);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbConnection, sQLException);
            return null;
        }
    }

    @Override
    public SQLXML Connection_createSQLXML(FilterChain filterChain, DmdbConnection dmdbConnection) {
        try {
            return filterChain.Connection_createSQLXML(dmdbConnection);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbConnection, sQLException);
            return null;
        }
    }

    @Override
    public boolean Connection_isValid(FilterChain filterChain, DmdbConnection dmdbConnection, int n2) {
        try {
            return filterChain.Connection_isValid(dmdbConnection, n2);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbConnection, sQLException);
            return false;
        }
    }

    @Override
    public void Connection_setClientInfo(FilterChain filterChain, DmdbConnection dmdbConnection, String string, String string2) {
        filterChain.Connection_setClientInfo(dmdbConnection, string, string2);
    }

    @Override
    public void Connection_setClientInfo(FilterChain filterChain, DmdbConnection dmdbConnection, Properties properties) {
        filterChain.Connection_setClientInfo(dmdbConnection, properties);
    }

    @Override
    public String Connection_getClientInfo(FilterChain filterChain, DmdbConnection dmdbConnection, String string) {
        try {
            return filterChain.Connection_getClientInfo(dmdbConnection, string);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbConnection, sQLException);
            return null;
        }
    }

    @Override
    public Properties Connection_getClientInfo(FilterChain filterChain, DmdbConnection dmdbConnection) {
        try {
            return filterChain.Connection_getClientInfo(dmdbConnection);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbConnection, sQLException);
            return null;
        }
    }

    @Override
    public Array Connection_createArrayOf(FilterChain filterChain, DmdbConnection dmdbConnection, String string, Object[] objectArray) {
        try {
            return filterChain.Connection_createArrayOf(dmdbConnection, string, objectArray);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbConnection, sQLException);
            return null;
        }
    }

    @Override
    public Struct Connection_createStruct(FilterChain filterChain, DmdbConnection dmdbConnection, String string, Object[] objectArray) {
        try {
            return filterChain.Connection_createStruct(dmdbConnection, string, objectArray);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbConnection, sQLException);
            return null;
        }
    }

    @Override
    public void Connection_setSchema(FilterChain filterChain, DmdbConnection dmdbConnection, String string) {
        try {
            filterChain.Connection_setSchema(dmdbConnection, string);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbConnection, sQLException);
        }
    }

    @Override
    public String Connection_getSchema(FilterChain filterChain, DmdbConnection dmdbConnection) {
        try {
            return filterChain.Connection_getSchema(dmdbConnection);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbConnection, sQLException);
            return null;
        }
    }

    @Override
    public void Connection_abort(FilterChain filterChain, DmdbConnection dmdbConnection, Executor executor) {
        try {
            filterChain.Connection_abort(dmdbConnection, executor);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbConnection, sQLException);
        }
    }

    @Override
    public void Connection_setNetworkTimeout(FilterChain filterChain, DmdbConnection dmdbConnection, Executor executor, int n2) {
        try {
            filterChain.Connection_setNetworkTimeout(dmdbConnection, executor, n2);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbConnection, sQLException);
        }
    }

    @Override
    public int Connection_getNetworkTimeout(FilterChain filterChain, DmdbConnection dmdbConnection) {
        try {
            return filterChain.Connection_getNetworkTimeout(dmdbConnection);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbConnection, sQLException);
            return 0;
        }
    }

    @Override
    public boolean DatabaseMetaData_allProceduresAreCallable(FilterChain filterChain, DmdbDatabaseMetaData dmdbDatabaseMetaData) {
        try {
            return filterChain.DatabaseMetaData_allProceduresAreCallable(dmdbDatabaseMetaData);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbDatabaseMetaData.connection, sQLException);
            return false;
        }
    }

    @Override
    public boolean DatabaseMetaData_allTablesAreSelectable(FilterChain filterChain, DmdbDatabaseMetaData dmdbDatabaseMetaData) {
        try {
            return filterChain.DatabaseMetaData_allTablesAreSelectable(dmdbDatabaseMetaData);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbDatabaseMetaData.connection, sQLException);
            return false;
        }
    }

    @Override
    public String DatabaseMetaData_getURL(FilterChain filterChain, DmdbDatabaseMetaData dmdbDatabaseMetaData) {
        try {
            return filterChain.DatabaseMetaData_getURL(dmdbDatabaseMetaData);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbDatabaseMetaData.connection, sQLException);
            return null;
        }
    }

    @Override
    public String DatabaseMetaData_getUserName(FilterChain filterChain, DmdbDatabaseMetaData dmdbDatabaseMetaData) {
        try {
            return filterChain.DatabaseMetaData_getUserName(dmdbDatabaseMetaData);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbDatabaseMetaData.connection, sQLException);
            return null;
        }
    }

    @Override
    public boolean DatabaseMetaData_isReadOnly(FilterChain filterChain, DmdbDatabaseMetaData dmdbDatabaseMetaData) {
        try {
            return filterChain.DatabaseMetaData_isReadOnly(dmdbDatabaseMetaData);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbDatabaseMetaData.connection, sQLException);
            return false;
        }
    }

    @Override
    public boolean DatabaseMetaData_nullsAreSortedHigh(FilterChain filterChain, DmdbDatabaseMetaData dmdbDatabaseMetaData) {
        try {
            return filterChain.DatabaseMetaData_nullsAreSortedHigh(dmdbDatabaseMetaData);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbDatabaseMetaData.connection, sQLException);
            return false;
        }
    }

    @Override
    public boolean DatabaseMetaData_nullsAreSortedLow(FilterChain filterChain, DmdbDatabaseMetaData dmdbDatabaseMetaData) {
        try {
            return filterChain.DatabaseMetaData_nullsAreSortedLow(dmdbDatabaseMetaData);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbDatabaseMetaData.connection, sQLException);
            return false;
        }
    }

    @Override
    public boolean DatabaseMetaData_nullsAreSortedAtStart(FilterChain filterChain, DmdbDatabaseMetaData dmdbDatabaseMetaData) {
        try {
            return filterChain.DatabaseMetaData_nullsAreSortedAtStart(dmdbDatabaseMetaData);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbDatabaseMetaData.connection, sQLException);
            return false;
        }
    }

    @Override
    public boolean DatabaseMetaData_nullsAreSortedAtEnd(FilterChain filterChain, DmdbDatabaseMetaData dmdbDatabaseMetaData) {
        try {
            return filterChain.DatabaseMetaData_nullsAreSortedAtEnd(dmdbDatabaseMetaData);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbDatabaseMetaData.connection, sQLException);
            return false;
        }
    }

    @Override
    public String DatabaseMetaData_getDatabaseProductName(FilterChain filterChain, DmdbDatabaseMetaData dmdbDatabaseMetaData) {
        try {
            return filterChain.DatabaseMetaData_getDatabaseProductName(dmdbDatabaseMetaData);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbDatabaseMetaData.connection, sQLException);
            return null;
        }
    }

    @Override
    public String DatabaseMetaData_getDatabaseProductVersion(FilterChain filterChain, DmdbDatabaseMetaData dmdbDatabaseMetaData) {
        try {
            return filterChain.DatabaseMetaData_getDatabaseProductVersion(dmdbDatabaseMetaData);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbDatabaseMetaData.connection, sQLException);
            return null;
        }
    }

    @Override
    public String DatabaseMetaData_getDriverName(FilterChain filterChain, DmdbDatabaseMetaData dmdbDatabaseMetaData) {
        try {
            return filterChain.DatabaseMetaData_getDriverName(dmdbDatabaseMetaData);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbDatabaseMetaData.connection, sQLException);
            return null;
        }
    }

    @Override
    public String DatabaseMetaData_getDriverVersion(FilterChain filterChain, DmdbDatabaseMetaData dmdbDatabaseMetaData) {
        try {
            return filterChain.DatabaseMetaData_getDriverVersion(dmdbDatabaseMetaData);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbDatabaseMetaData.connection, sQLException);
            return null;
        }
    }

    @Override
    public int DatabaseMetaData_getDriverMajorVersion(FilterChain filterChain, DmdbDatabaseMetaData dmdbDatabaseMetaData) {
        return filterChain.DatabaseMetaData_getDriverMajorVersion(dmdbDatabaseMetaData);
    }

    @Override
    public int DatabaseMetaData_getDriverMinorVersion(FilterChain filterChain, DmdbDatabaseMetaData dmdbDatabaseMetaData) {
        return filterChain.DatabaseMetaData_getDriverMinorVersion(dmdbDatabaseMetaData);
    }

    @Override
    public boolean DatabaseMetaData_usesLocalFiles(FilterChain filterChain, DmdbDatabaseMetaData dmdbDatabaseMetaData) {
        try {
            return filterChain.DatabaseMetaData_usesLocalFiles(dmdbDatabaseMetaData);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbDatabaseMetaData.connection, sQLException);
            return false;
        }
    }

    @Override
    public boolean DatabaseMetaData_usesLocalFilePerTable(FilterChain filterChain, DmdbDatabaseMetaData dmdbDatabaseMetaData) {
        try {
            return filterChain.DatabaseMetaData_usesLocalFilePerTable(dmdbDatabaseMetaData);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbDatabaseMetaData.connection, sQLException);
            return false;
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsMixedCaseIdentifiers(FilterChain filterChain, DmdbDatabaseMetaData dmdbDatabaseMetaData) {
        try {
            return filterChain.DatabaseMetaData_supportsMixedCaseIdentifiers(dmdbDatabaseMetaData);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbDatabaseMetaData.connection, sQLException);
            return false;
        }
    }

    @Override
    public boolean DatabaseMetaData_storesUpperCaseIdentifiers(FilterChain filterChain, DmdbDatabaseMetaData dmdbDatabaseMetaData) {
        try {
            return filterChain.DatabaseMetaData_storesUpperCaseIdentifiers(dmdbDatabaseMetaData);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbDatabaseMetaData.connection, sQLException);
            return false;
        }
    }

    @Override
    public boolean DatabaseMetaData_storesLowerCaseIdentifiers(FilterChain filterChain, DmdbDatabaseMetaData dmdbDatabaseMetaData) {
        try {
            return filterChain.DatabaseMetaData_storesLowerCaseIdentifiers(dmdbDatabaseMetaData);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbDatabaseMetaData.connection, sQLException);
            return false;
        }
    }

    @Override
    public boolean DatabaseMetaData_storesMixedCaseIdentifiers(FilterChain filterChain, DmdbDatabaseMetaData dmdbDatabaseMetaData) {
        try {
            return filterChain.DatabaseMetaData_storesMixedCaseIdentifiers(dmdbDatabaseMetaData);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbDatabaseMetaData.connection, sQLException);
            return false;
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsMixedCaseQuotedIdentifiers(FilterChain filterChain, DmdbDatabaseMetaData dmdbDatabaseMetaData) {
        try {
            return filterChain.DatabaseMetaData_supportsMixedCaseIdentifiers(dmdbDatabaseMetaData);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbDatabaseMetaData.connection, sQLException);
            return false;
        }
    }

    @Override
    public boolean DatabaseMetaData_storesUpperCaseQuotedIdentifiers(FilterChain filterChain, DmdbDatabaseMetaData dmdbDatabaseMetaData) {
        try {
            return filterChain.DatabaseMetaData_storesUpperCaseQuotedIdentifiers(dmdbDatabaseMetaData);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbDatabaseMetaData.connection, sQLException);
            return false;
        }
    }

    @Override
    public boolean DatabaseMetaData_storesLowerCaseQuotedIdentifiers(FilterChain filterChain, DmdbDatabaseMetaData dmdbDatabaseMetaData) {
        try {
            return filterChain.DatabaseMetaData_storesLowerCaseQuotedIdentifiers(dmdbDatabaseMetaData);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbDatabaseMetaData.connection, sQLException);
            return false;
        }
    }

    @Override
    public boolean DatabaseMetaData_storesMixedCaseQuotedIdentifiers(FilterChain filterChain, DmdbDatabaseMetaData dmdbDatabaseMetaData) {
        try {
            return filterChain.DatabaseMetaData_storesMixedCaseQuotedIdentifiers(dmdbDatabaseMetaData);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbDatabaseMetaData.connection, sQLException);
            return false;
        }
    }

    @Override
    public String DatabaseMetaData_getIdentifierQuoteString(FilterChain filterChain, DmdbDatabaseMetaData dmdbDatabaseMetaData) {
        try {
            return filterChain.DatabaseMetaData_getIdentifierQuoteString(dmdbDatabaseMetaData);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbDatabaseMetaData.connection, sQLException);
            return null;
        }
    }

    @Override
    public String DatabaseMetaData_getSQLKeywords(FilterChain filterChain, DmdbDatabaseMetaData dmdbDatabaseMetaData) {
        try {
            return filterChain.DatabaseMetaData_getSQLKeywords(dmdbDatabaseMetaData);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbDatabaseMetaData.connection, sQLException);
            return null;
        }
    }

    @Override
    public String DatabaseMetaData_getNumericFunctions(FilterChain filterChain, DmdbDatabaseMetaData dmdbDatabaseMetaData) {
        try {
            return filterChain.DatabaseMetaData_getNumericFunctions(dmdbDatabaseMetaData);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbDatabaseMetaData.connection, sQLException);
            return null;
        }
    }

    @Override
    public String DatabaseMetaData_getStringFunctions(FilterChain filterChain, DmdbDatabaseMetaData dmdbDatabaseMetaData) {
        try {
            return filterChain.DatabaseMetaData_getStringFunctions(dmdbDatabaseMetaData);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbDatabaseMetaData.connection, sQLException);
            return null;
        }
    }

    @Override
    public String DatabaseMetaData_getSystemFunctions(FilterChain filterChain, DmdbDatabaseMetaData dmdbDatabaseMetaData) {
        try {
            return filterChain.DatabaseMetaData_getSystemFunctions(dmdbDatabaseMetaData);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbDatabaseMetaData.connection, sQLException);
            return null;
        }
    }

    @Override
    public String DatabaseMetaData_getTimeDateFunctions(FilterChain filterChain, DmdbDatabaseMetaData dmdbDatabaseMetaData) {
        try {
            return filterChain.DatabaseMetaData_getTimeDateFunctions(dmdbDatabaseMetaData);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbDatabaseMetaData.connection, sQLException);
            return null;
        }
    }

    @Override
    public String DatabaseMetaData_getSearchStringEscape(FilterChain filterChain, DmdbDatabaseMetaData dmdbDatabaseMetaData) {
        try {
            return filterChain.DatabaseMetaData_getSearchStringEscape(dmdbDatabaseMetaData);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbDatabaseMetaData.connection, sQLException);
            return null;
        }
    }

    @Override
    public String DatabaseMetaData_getExtraNameCharacters(FilterChain filterChain, DmdbDatabaseMetaData dmdbDatabaseMetaData) {
        try {
            return filterChain.DatabaseMetaData_getExtraNameCharacters(dmdbDatabaseMetaData);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbDatabaseMetaData.connection, sQLException);
            return null;
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsAlterTableWithAddColumn(FilterChain filterChain, DmdbDatabaseMetaData dmdbDatabaseMetaData) {
        try {
            return filterChain.DatabaseMetaData_supportsAlterTableWithAddColumn(dmdbDatabaseMetaData);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbDatabaseMetaData.connection, sQLException);
            return false;
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsAlterTableWithDropColumn(FilterChain filterChain, DmdbDatabaseMetaData dmdbDatabaseMetaData) {
        try {
            return filterChain.DatabaseMetaData_supportsAlterTableWithDropColumn(dmdbDatabaseMetaData);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbDatabaseMetaData.connection, sQLException);
            return false;
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsColumnAliasing(FilterChain filterChain, DmdbDatabaseMetaData dmdbDatabaseMetaData) {
        try {
            return filterChain.DatabaseMetaData_supportsColumnAliasing(dmdbDatabaseMetaData);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbDatabaseMetaData.connection, sQLException);
            return false;
        }
    }

    @Override
    public boolean DatabaseMetaData_nullPlusNonNullIsNull(FilterChain filterChain, DmdbDatabaseMetaData dmdbDatabaseMetaData) {
        try {
            return filterChain.DatabaseMetaData_nullPlusNonNullIsNull(dmdbDatabaseMetaData);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbDatabaseMetaData.connection, sQLException);
            return false;
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsConvert(FilterChain filterChain, DmdbDatabaseMetaData dmdbDatabaseMetaData) {
        try {
            return filterChain.DatabaseMetaData_supportsConvert(dmdbDatabaseMetaData);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbDatabaseMetaData.connection, sQLException);
            return false;
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsConvert(FilterChain filterChain, DmdbDatabaseMetaData dmdbDatabaseMetaData, int n2, int n3) {
        try {
            return filterChain.DatabaseMetaData_supportsConvert(dmdbDatabaseMetaData, n2, n3);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbDatabaseMetaData.connection, sQLException);
            return false;
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsTableCorrelationNames(FilterChain filterChain, DmdbDatabaseMetaData dmdbDatabaseMetaData) {
        try {
            return filterChain.DatabaseMetaData_supportsTableCorrelationNames(dmdbDatabaseMetaData);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbDatabaseMetaData.connection, sQLException);
            return false;
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsDifferentTableCorrelationNames(FilterChain filterChain, DmdbDatabaseMetaData dmdbDatabaseMetaData) {
        try {
            return filterChain.DatabaseMetaData_supportsDifferentTableCorrelationNames(dmdbDatabaseMetaData);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbDatabaseMetaData.connection, sQLException);
            return false;
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsExpressionsInOrderBy(FilterChain filterChain, DmdbDatabaseMetaData dmdbDatabaseMetaData) {
        try {
            return filterChain.DatabaseMetaData_supportsExpressionsInOrderBy(dmdbDatabaseMetaData);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbDatabaseMetaData.connection, sQLException);
            return false;
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsOrderByUnrelated(FilterChain filterChain, DmdbDatabaseMetaData dmdbDatabaseMetaData) {
        try {
            return filterChain.DatabaseMetaData_supportsOrderByUnrelated(dmdbDatabaseMetaData);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbDatabaseMetaData.connection, sQLException);
            return false;
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsGroupBy(FilterChain filterChain, DmdbDatabaseMetaData dmdbDatabaseMetaData) {
        try {
            return filterChain.DatabaseMetaData_supportsGroupBy(dmdbDatabaseMetaData);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbDatabaseMetaData.connection, sQLException);
            return false;
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsGroupByUnrelated(FilterChain filterChain, DmdbDatabaseMetaData dmdbDatabaseMetaData) {
        try {
            return filterChain.DatabaseMetaData_supportsGroupByUnrelated(dmdbDatabaseMetaData);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbDatabaseMetaData.connection, sQLException);
            return false;
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsGroupByBeyondSelect(FilterChain filterChain, DmdbDatabaseMetaData dmdbDatabaseMetaData) {
        try {
            return filterChain.DatabaseMetaData_supportsGroupByBeyondSelect(dmdbDatabaseMetaData);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbDatabaseMetaData.connection, sQLException);
            return false;
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsLikeEscapeClause(FilterChain filterChain, DmdbDatabaseMetaData dmdbDatabaseMetaData) {
        try {
            return filterChain.DatabaseMetaData_supportsLikeEscapeClause(dmdbDatabaseMetaData);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbDatabaseMetaData.connection, sQLException);
            return false;
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsMultipleResultSets(FilterChain filterChain, DmdbDatabaseMetaData dmdbDatabaseMetaData) {
        try {
            return filterChain.DatabaseMetaData_supportsMultipleResultSets(dmdbDatabaseMetaData);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbDatabaseMetaData.connection, sQLException);
            return false;
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsMultipleTransactions(FilterChain filterChain, DmdbDatabaseMetaData dmdbDatabaseMetaData) {
        try {
            return filterChain.DatabaseMetaData_supportsMultipleTransactions(dmdbDatabaseMetaData);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbDatabaseMetaData.connection, sQLException);
            return false;
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsNonNullableColumns(FilterChain filterChain, DmdbDatabaseMetaData dmdbDatabaseMetaData) {
        try {
            return filterChain.DatabaseMetaData_supportsNonNullableColumns(dmdbDatabaseMetaData);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbDatabaseMetaData.connection, sQLException);
            return false;
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsMinimumSQLGrammar(FilterChain filterChain, DmdbDatabaseMetaData dmdbDatabaseMetaData) {
        try {
            return filterChain.DatabaseMetaData_supportsMinimumSQLGrammar(dmdbDatabaseMetaData);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbDatabaseMetaData.connection, sQLException);
            return false;
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsCoreSQLGrammar(FilterChain filterChain, DmdbDatabaseMetaData dmdbDatabaseMetaData) {
        try {
            return filterChain.DatabaseMetaData_supportsCoreSQLGrammar(dmdbDatabaseMetaData);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbDatabaseMetaData.connection, sQLException);
            return false;
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsExtendedSQLGrammar(FilterChain filterChain, DmdbDatabaseMetaData dmdbDatabaseMetaData) {
        try {
            return filterChain.DatabaseMetaData_supportsExtendedSQLGrammar(dmdbDatabaseMetaData);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbDatabaseMetaData.connection, sQLException);
            return false;
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsANSI92EntryLevelSQL(FilterChain filterChain, DmdbDatabaseMetaData dmdbDatabaseMetaData) {
        try {
            return filterChain.DatabaseMetaData_supportsANSI92EntryLevelSQL(dmdbDatabaseMetaData);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbDatabaseMetaData.connection, sQLException);
            return false;
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsANSI92IntermediateSQL(FilterChain filterChain, DmdbDatabaseMetaData dmdbDatabaseMetaData) {
        try {
            return filterChain.DatabaseMetaData_supportsANSI92IntermediateSQL(dmdbDatabaseMetaData);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbDatabaseMetaData.connection, sQLException);
            return false;
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsANSI92FullSQL(FilterChain filterChain, DmdbDatabaseMetaData dmdbDatabaseMetaData) {
        try {
            return filterChain.DatabaseMetaData_supportsANSI92FullSQL(dmdbDatabaseMetaData);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbDatabaseMetaData.connection, sQLException);
            return false;
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsIntegrityEnhancementFacility(FilterChain filterChain, DmdbDatabaseMetaData dmdbDatabaseMetaData) {
        try {
            return filterChain.DatabaseMetaData_supportsIntegrityEnhancementFacility(dmdbDatabaseMetaData);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbDatabaseMetaData.connection, sQLException);
            return false;
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsOuterJoins(FilterChain filterChain, DmdbDatabaseMetaData dmdbDatabaseMetaData) {
        try {
            return filterChain.DatabaseMetaData_supportsOuterJoins(dmdbDatabaseMetaData);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbDatabaseMetaData.connection, sQLException);
            return false;
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsFullOuterJoins(FilterChain filterChain, DmdbDatabaseMetaData dmdbDatabaseMetaData) {
        try {
            return filterChain.DatabaseMetaData_supportsFullOuterJoins(dmdbDatabaseMetaData);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbDatabaseMetaData.connection, sQLException);
            return false;
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsLimitedOuterJoins(FilterChain filterChain, DmdbDatabaseMetaData dmdbDatabaseMetaData) {
        try {
            return filterChain.DatabaseMetaData_supportsLimitedOuterJoins(dmdbDatabaseMetaData);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbDatabaseMetaData.connection, sQLException);
            return false;
        }
    }

    @Override
    public String DatabaseMetaData_getSchemaTerm(FilterChain filterChain, DmdbDatabaseMetaData dmdbDatabaseMetaData) {
        try {
            return filterChain.DatabaseMetaData_getSchemaTerm(dmdbDatabaseMetaData);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbDatabaseMetaData.connection, sQLException);
            return null;
        }
    }

    @Override
    public String DatabaseMetaData_getProcedureTerm(FilterChain filterChain, DmdbDatabaseMetaData dmdbDatabaseMetaData) {
        try {
            return filterChain.DatabaseMetaData_getProcedureTerm(dmdbDatabaseMetaData);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbDatabaseMetaData.connection, sQLException);
            return null;
        }
    }

    @Override
    public String DatabaseMetaData_getCatalogTerm(FilterChain filterChain, DmdbDatabaseMetaData dmdbDatabaseMetaData) {
        try {
            return filterChain.DatabaseMetaData_getCatalogTerm(dmdbDatabaseMetaData);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbDatabaseMetaData.connection, sQLException);
            return null;
        }
    }

    @Override
    public boolean DatabaseMetaData_isCatalogAtStart(FilterChain filterChain, DmdbDatabaseMetaData dmdbDatabaseMetaData) {
        try {
            return filterChain.DatabaseMetaData_isCatalogAtStart(dmdbDatabaseMetaData);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbDatabaseMetaData.connection, sQLException);
            return false;
        }
    }

    @Override
    public String DatabaseMetaData_getCatalogSeparator(FilterChain filterChain, DmdbDatabaseMetaData dmdbDatabaseMetaData) {
        try {
            return filterChain.DatabaseMetaData_getCatalogSeparator(dmdbDatabaseMetaData);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbDatabaseMetaData.connection, sQLException);
            return null;
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsSchemasInDataManipulation(FilterChain filterChain, DmdbDatabaseMetaData dmdbDatabaseMetaData) {
        try {
            return filterChain.DatabaseMetaData_supportsSchemasInDataManipulation(dmdbDatabaseMetaData);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbDatabaseMetaData.connection, sQLException);
            return false;
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsSchemasInProcedureCalls(FilterChain filterChain, DmdbDatabaseMetaData dmdbDatabaseMetaData) {
        try {
            return filterChain.DatabaseMetaData_supportsSchemasInProcedureCalls(dmdbDatabaseMetaData);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbDatabaseMetaData.connection, sQLException);
            return false;
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsSchemasInTableDefinitions(FilterChain filterChain, DmdbDatabaseMetaData dmdbDatabaseMetaData) {
        try {
            return filterChain.DatabaseMetaData_supportsSchemasInTableDefinitions(dmdbDatabaseMetaData);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbDatabaseMetaData.connection, sQLException);
            return false;
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsSchemasInIndexDefinitions(FilterChain filterChain, DmdbDatabaseMetaData dmdbDatabaseMetaData) {
        try {
            return filterChain.DatabaseMetaData_supportsSchemasInIndexDefinitions(dmdbDatabaseMetaData);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbDatabaseMetaData.connection, sQLException);
            return false;
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsSchemasInPrivilegeDefinitions(FilterChain filterChain, DmdbDatabaseMetaData dmdbDatabaseMetaData) {
        try {
            return filterChain.DatabaseMetaData_supportsSchemasInPrivilegeDefinitions(dmdbDatabaseMetaData);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbDatabaseMetaData.connection, sQLException);
            return false;
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsCatalogsInDataManipulation(FilterChain filterChain, DmdbDatabaseMetaData dmdbDatabaseMetaData) {
        try {
            return filterChain.DatabaseMetaData_supportsCatalogsInDataManipulation(dmdbDatabaseMetaData);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbDatabaseMetaData.connection, sQLException);
            return false;
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsCatalogsInProcedureCalls(FilterChain filterChain, DmdbDatabaseMetaData dmdbDatabaseMetaData) {
        try {
            return filterChain.DatabaseMetaData_supportsCatalogsInProcedureCalls(dmdbDatabaseMetaData);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbDatabaseMetaData.connection, sQLException);
            return false;
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsCatalogsInTableDefinitions(FilterChain filterChain, DmdbDatabaseMetaData dmdbDatabaseMetaData) {
        try {
            return filterChain.DatabaseMetaData_supportsCatalogsInTableDefinitions(dmdbDatabaseMetaData);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbDatabaseMetaData.connection, sQLException);
            return false;
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsCatalogsInIndexDefinitions(FilterChain filterChain, DmdbDatabaseMetaData dmdbDatabaseMetaData) {
        try {
            return filterChain.DatabaseMetaData_supportsCatalogsInIndexDefinitions(dmdbDatabaseMetaData);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbDatabaseMetaData.connection, sQLException);
            return false;
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsCatalogsInPrivilegeDefinitions(FilterChain filterChain, DmdbDatabaseMetaData dmdbDatabaseMetaData) {
        try {
            return filterChain.DatabaseMetaData_supportsCatalogsInPrivilegeDefinitions(dmdbDatabaseMetaData);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbDatabaseMetaData.connection, sQLException);
            return false;
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsPositionedDelete(FilterChain filterChain, DmdbDatabaseMetaData dmdbDatabaseMetaData) {
        try {
            return filterChain.DatabaseMetaData_supportsPositionedDelete(dmdbDatabaseMetaData);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbDatabaseMetaData.connection, sQLException);
            return false;
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsPositionedUpdate(FilterChain filterChain, DmdbDatabaseMetaData dmdbDatabaseMetaData) {
        try {
            return filterChain.DatabaseMetaData_supportsPositionedUpdate(dmdbDatabaseMetaData);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbDatabaseMetaData.connection, sQLException);
            return false;
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsSelectForUpdate(FilterChain filterChain, DmdbDatabaseMetaData dmdbDatabaseMetaData) {
        try {
            return filterChain.DatabaseMetaData_supportsSelectForUpdate(dmdbDatabaseMetaData);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbDatabaseMetaData.connection, sQLException);
            return false;
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsStoredProcedures(FilterChain filterChain, DmdbDatabaseMetaData dmdbDatabaseMetaData) {
        try {
            return filterChain.DatabaseMetaData_supportsStoredProcedures(dmdbDatabaseMetaData);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbDatabaseMetaData.connection, sQLException);
            return false;
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsSubqueriesInComparisons(FilterChain filterChain, DmdbDatabaseMetaData dmdbDatabaseMetaData) {
        try {
            return filterChain.DatabaseMetaData_supportsSubqueriesInComparisons(dmdbDatabaseMetaData);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbDatabaseMetaData.connection, sQLException);
            return false;
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsSubqueriesInExists(FilterChain filterChain, DmdbDatabaseMetaData dmdbDatabaseMetaData) {
        try {
            return filterChain.DatabaseMetaData_supportsSubqueriesInExists(dmdbDatabaseMetaData);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbDatabaseMetaData.connection, sQLException);
            return false;
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsSubqueriesInIns(FilterChain filterChain, DmdbDatabaseMetaData dmdbDatabaseMetaData) {
        try {
            return filterChain.DatabaseMetaData_supportsSubqueriesInIns(dmdbDatabaseMetaData);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbDatabaseMetaData.connection, sQLException);
            return false;
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsSubqueriesInQuantifieds(FilterChain filterChain, DmdbDatabaseMetaData dmdbDatabaseMetaData) {
        try {
            return filterChain.DatabaseMetaData_supportsSubqueriesInQuantifieds(dmdbDatabaseMetaData);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbDatabaseMetaData.connection, sQLException);
            return false;
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsCorrelatedSubqueries(FilterChain filterChain, DmdbDatabaseMetaData dmdbDatabaseMetaData) {
        try {
            return filterChain.DatabaseMetaData_supportsCorrelatedSubqueries(dmdbDatabaseMetaData);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbDatabaseMetaData.connection, sQLException);
            return false;
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsUnion(FilterChain filterChain, DmdbDatabaseMetaData dmdbDatabaseMetaData) {
        try {
            return filterChain.DatabaseMetaData_supportsUnion(dmdbDatabaseMetaData);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbDatabaseMetaData.connection, sQLException);
            return false;
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsUnionAll(FilterChain filterChain, DmdbDatabaseMetaData dmdbDatabaseMetaData) {
        try {
            return filterChain.DatabaseMetaData_supportsUnionAll(dmdbDatabaseMetaData);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbDatabaseMetaData.connection, sQLException);
            return false;
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsOpenCursorsAcrossCommit(FilterChain filterChain, DmdbDatabaseMetaData dmdbDatabaseMetaData) {
        try {
            return filterChain.DatabaseMetaData_supportsOpenCursorsAcrossCommit(dmdbDatabaseMetaData);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbDatabaseMetaData.connection, sQLException);
            return false;
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsOpenCursorsAcrossRollback(FilterChain filterChain, DmdbDatabaseMetaData dmdbDatabaseMetaData) {
        try {
            return filterChain.DatabaseMetaData_supportsOpenCursorsAcrossRollback(dmdbDatabaseMetaData);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbDatabaseMetaData.connection, sQLException);
            return false;
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsOpenStatementsAcrossCommit(FilterChain filterChain, DmdbDatabaseMetaData dmdbDatabaseMetaData) {
        try {
            return filterChain.DatabaseMetaData_supportsOpenStatementsAcrossCommit(dmdbDatabaseMetaData);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbDatabaseMetaData.connection, sQLException);
            return false;
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsOpenStatementsAcrossRollback(FilterChain filterChain, DmdbDatabaseMetaData dmdbDatabaseMetaData) {
        try {
            return filterChain.DatabaseMetaData_supportsOpenStatementsAcrossRollback(dmdbDatabaseMetaData);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbDatabaseMetaData.connection, sQLException);
            return false;
        }
    }

    @Override
    public int DatabaseMetaData_getMaxBinaryLiteralLength(FilterChain filterChain, DmdbDatabaseMetaData dmdbDatabaseMetaData) {
        try {
            return filterChain.DatabaseMetaData_getMaxBinaryLiteralLength(dmdbDatabaseMetaData);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbDatabaseMetaData.connection, sQLException);
            return 0;
        }
    }

    @Override
    public int DatabaseMetaData_getMaxCharLiteralLength(FilterChain filterChain, DmdbDatabaseMetaData dmdbDatabaseMetaData) {
        try {
            return filterChain.DatabaseMetaData_getMaxCharLiteralLength(dmdbDatabaseMetaData);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbDatabaseMetaData.connection, sQLException);
            return 0;
        }
    }

    @Override
    public int DatabaseMetaData_getMaxColumnNameLength(FilterChain filterChain, DmdbDatabaseMetaData dmdbDatabaseMetaData) {
        try {
            return filterChain.DatabaseMetaData_getMaxColumnNameLength(dmdbDatabaseMetaData);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbDatabaseMetaData.connection, sQLException);
            return 0;
        }
    }

    @Override
    public int DatabaseMetaData_getMaxColumnsInGroupBy(FilterChain filterChain, DmdbDatabaseMetaData dmdbDatabaseMetaData) {
        try {
            return filterChain.DatabaseMetaData_getMaxColumnsInGroupBy(dmdbDatabaseMetaData);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbDatabaseMetaData.connection, sQLException);
            return 0;
        }
    }

    @Override
    public int DatabaseMetaData_getMaxColumnsInIndex(FilterChain filterChain, DmdbDatabaseMetaData dmdbDatabaseMetaData) {
        try {
            return filterChain.DatabaseMetaData_getMaxColumnsInIndex(dmdbDatabaseMetaData);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbDatabaseMetaData.connection, sQLException);
            return 0;
        }
    }

    @Override
    public int DatabaseMetaData_getMaxColumnsInOrderBy(FilterChain filterChain, DmdbDatabaseMetaData dmdbDatabaseMetaData) {
        try {
            return filterChain.DatabaseMetaData_getMaxColumnsInOrderBy(dmdbDatabaseMetaData);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbDatabaseMetaData.connection, sQLException);
            return 0;
        }
    }

    @Override
    public int DatabaseMetaData_getMaxColumnsInSelect(FilterChain filterChain, DmdbDatabaseMetaData dmdbDatabaseMetaData) {
        try {
            return filterChain.DatabaseMetaData_getMaxColumnsInSelect(dmdbDatabaseMetaData);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbDatabaseMetaData.connection, sQLException);
            return 0;
        }
    }

    @Override
    public int DatabaseMetaData_getMaxColumnsInTable(FilterChain filterChain, DmdbDatabaseMetaData dmdbDatabaseMetaData) {
        try {
            return filterChain.DatabaseMetaData_getMaxColumnsInTable(dmdbDatabaseMetaData);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbDatabaseMetaData.connection, sQLException);
            return 0;
        }
    }

    @Override
    public int DatabaseMetaData_getMaxConnections(FilterChain filterChain, DmdbDatabaseMetaData dmdbDatabaseMetaData) {
        try {
            return filterChain.DatabaseMetaData_getMaxConnections(dmdbDatabaseMetaData);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbDatabaseMetaData.connection, sQLException);
            return 0;
        }
    }

    @Override
    public int DatabaseMetaData_getMaxCursorNameLength(FilterChain filterChain, DmdbDatabaseMetaData dmdbDatabaseMetaData) {
        try {
            return filterChain.DatabaseMetaData_getMaxCursorNameLength(dmdbDatabaseMetaData);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbDatabaseMetaData.connection, sQLException);
            return 0;
        }
    }

    @Override
    public int DatabaseMetaData_getMaxIndexLength(FilterChain filterChain, DmdbDatabaseMetaData dmdbDatabaseMetaData) {
        try {
            return filterChain.DatabaseMetaData_getMaxIndexLength(dmdbDatabaseMetaData);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbDatabaseMetaData.connection, sQLException);
            return 0;
        }
    }

    @Override
    public int DatabaseMetaData_getMaxSchemaNameLength(FilterChain filterChain, DmdbDatabaseMetaData dmdbDatabaseMetaData) {
        try {
            return filterChain.DatabaseMetaData_getMaxSchemaNameLength(dmdbDatabaseMetaData);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbDatabaseMetaData.connection, sQLException);
            return 0;
        }
    }

    @Override
    public int DatabaseMetaData_getMaxProcedureNameLength(FilterChain filterChain, DmdbDatabaseMetaData dmdbDatabaseMetaData) {
        try {
            return filterChain.DatabaseMetaData_getMaxProcedureNameLength(dmdbDatabaseMetaData);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbDatabaseMetaData.connection, sQLException);
            return 0;
        }
    }

    @Override
    public int DatabaseMetaData_getMaxCatalogNameLength(FilterChain filterChain, DmdbDatabaseMetaData dmdbDatabaseMetaData) {
        try {
            return filterChain.DatabaseMetaData_getMaxCatalogNameLength(dmdbDatabaseMetaData);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbDatabaseMetaData.connection, sQLException);
            return 0;
        }
    }

    @Override
    public int DatabaseMetaData_getMaxRowSize(FilterChain filterChain, DmdbDatabaseMetaData dmdbDatabaseMetaData) {
        try {
            return filterChain.DatabaseMetaData_getMaxRowSize(dmdbDatabaseMetaData);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbDatabaseMetaData.connection, sQLException);
            return 0;
        }
    }

    @Override
    public boolean DatabaseMetaData_doesMaxRowSizeIncludeBlobs(FilterChain filterChain, DmdbDatabaseMetaData dmdbDatabaseMetaData) {
        try {
            return filterChain.DatabaseMetaData_doesMaxRowSizeIncludeBlobs(dmdbDatabaseMetaData);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbDatabaseMetaData.connection, sQLException);
            return false;
        }
    }

    @Override
    public int DatabaseMetaData_getMaxStatementLength(FilterChain filterChain, DmdbDatabaseMetaData dmdbDatabaseMetaData) {
        try {
            return filterChain.DatabaseMetaData_getMaxStatementLength(dmdbDatabaseMetaData);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbDatabaseMetaData.connection, sQLException);
            return 0;
        }
    }

    @Override
    public int DatabaseMetaData_getMaxStatements(FilterChain filterChain, DmdbDatabaseMetaData dmdbDatabaseMetaData) {
        try {
            return filterChain.DatabaseMetaData_getMaxStatements(dmdbDatabaseMetaData);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbDatabaseMetaData.connection, sQLException);
            return 0;
        }
    }

    @Override
    public int DatabaseMetaData_getMaxTableNameLength(FilterChain filterChain, DmdbDatabaseMetaData dmdbDatabaseMetaData) {
        try {
            return filterChain.DatabaseMetaData_getMaxTableNameLength(dmdbDatabaseMetaData);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbDatabaseMetaData.connection, sQLException);
            return 0;
        }
    }

    @Override
    public int DatabaseMetaData_getMaxTablesInSelect(FilterChain filterChain, DmdbDatabaseMetaData dmdbDatabaseMetaData) {
        try {
            return filterChain.DatabaseMetaData_getMaxTablesInSelect(dmdbDatabaseMetaData);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbDatabaseMetaData.connection, sQLException);
            return 0;
        }
    }

    @Override
    public int DatabaseMetaData_getMaxUserNameLength(FilterChain filterChain, DmdbDatabaseMetaData dmdbDatabaseMetaData) {
        try {
            return filterChain.DatabaseMetaData_getMaxUserNameLength(dmdbDatabaseMetaData);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbDatabaseMetaData.connection, sQLException);
            return 0;
        }
    }

    @Override
    public int DatabaseMetaData_getDefaultTransactionIsolation(FilterChain filterChain, DmdbDatabaseMetaData dmdbDatabaseMetaData) {
        try {
            return filterChain.DatabaseMetaData_getDefaultTransactionIsolation(dmdbDatabaseMetaData);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbDatabaseMetaData.connection, sQLException);
            return 0;
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsTransactions(FilterChain filterChain, DmdbDatabaseMetaData dmdbDatabaseMetaData) {
        try {
            return filterChain.DatabaseMetaData_supportsTransactions(dmdbDatabaseMetaData);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbDatabaseMetaData.connection, sQLException);
            return false;
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsTransactionIsolationLevel(FilterChain filterChain, DmdbDatabaseMetaData dmdbDatabaseMetaData, int n2) {
        try {
            return filterChain.DatabaseMetaData_supportsTransactionIsolationLevel(dmdbDatabaseMetaData, n2);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbDatabaseMetaData.connection, sQLException);
            return false;
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsDataDefinitionAndDataManipulationTransactions(FilterChain filterChain, DmdbDatabaseMetaData dmdbDatabaseMetaData) {
        try {
            return filterChain.DatabaseMetaData_supportsDataDefinitionAndDataManipulationTransactions(dmdbDatabaseMetaData);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbDatabaseMetaData.connection, sQLException);
            return false;
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsDataManipulationTransactionsOnly(FilterChain filterChain, DmdbDatabaseMetaData dmdbDatabaseMetaData) {
        try {
            return filterChain.DatabaseMetaData_supportsDataManipulationTransactionsOnly(dmdbDatabaseMetaData);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbDatabaseMetaData.connection, sQLException);
            return false;
        }
    }

    @Override
    public boolean DatabaseMetaData_dataDefinitionCausesTransactionCommit(FilterChain filterChain, DmdbDatabaseMetaData dmdbDatabaseMetaData) {
        try {
            return filterChain.DatabaseMetaData_dataDefinitionCausesTransactionCommit(dmdbDatabaseMetaData);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbDatabaseMetaData.connection, sQLException);
            return false;
        }
    }

    @Override
    public boolean DatabaseMetaData_dataDefinitionIgnoredInTransactions(FilterChain filterChain, DmdbDatabaseMetaData dmdbDatabaseMetaData) {
        try {
            return filterChain.DatabaseMetaData_dataDefinitionIgnoredInTransactions(dmdbDatabaseMetaData);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbDatabaseMetaData.connection, sQLException);
            return false;
        }
    }

    @Override
    public ResultSet DatabaseMetaData_getProcedures(FilterChain filterChain, DmdbDatabaseMetaData dmdbDatabaseMetaData, String string, String string2, String string3) {
        try {
            return filterChain.DatabaseMetaData_getProcedures(dmdbDatabaseMetaData, string, string2, string3);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbDatabaseMetaData.connection, sQLException);
            return null;
        }
    }

    @Override
    public ResultSet DatabaseMetaData_getProcedureColumns(FilterChain filterChain, DmdbDatabaseMetaData dmdbDatabaseMetaData, String string, String string2, String string3, String string4) {
        try {
            return filterChain.DatabaseMetaData_getProcedureColumns(dmdbDatabaseMetaData, string, string2, string3, string4);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbDatabaseMetaData.connection, sQLException);
            return null;
        }
    }

    @Override
    public ResultSet DatabaseMetaData_getTables(FilterChain filterChain, DmdbDatabaseMetaData dmdbDatabaseMetaData, String string, String string2, String string3, String[] stringArray) {
        try {
            return filterChain.DatabaseMetaData_getTables(dmdbDatabaseMetaData, string, string2, string3, stringArray);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbDatabaseMetaData.connection, sQLException);
            return null;
        }
    }

    @Override
    public ResultSet DatabaseMetaData_getSchemas(FilterChain filterChain, DmdbDatabaseMetaData dmdbDatabaseMetaData) {
        try {
            return filterChain.DatabaseMetaData_getSchemas(dmdbDatabaseMetaData);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbDatabaseMetaData.connection, sQLException);
            return null;
        }
    }

    @Override
    public ResultSet DatabaseMetaData_getCatalogs(FilterChain filterChain, DmdbDatabaseMetaData dmdbDatabaseMetaData) {
        try {
            return filterChain.DatabaseMetaData_getCatalogs(dmdbDatabaseMetaData);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbDatabaseMetaData.connection, sQLException);
            return null;
        }
    }

    @Override
    public ResultSet DatabaseMetaData_getTableTypes(FilterChain filterChain, DmdbDatabaseMetaData dmdbDatabaseMetaData) {
        try {
            return filterChain.DatabaseMetaData_getTableTypes(dmdbDatabaseMetaData);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbDatabaseMetaData.connection, sQLException);
            return null;
        }
    }

    @Override
    public ResultSet DatabaseMetaData_getColumns(FilterChain filterChain, DmdbDatabaseMetaData dmdbDatabaseMetaData, String string, String string2, String string3, String string4) {
        try {
            return filterChain.DatabaseMetaData_getColumns(dmdbDatabaseMetaData, string, string2, string3, string4);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbDatabaseMetaData.connection, sQLException);
            return null;
        }
    }

    @Override
    public ResultSet DatabaseMetaData_getColumnPrivileges(FilterChain filterChain, DmdbDatabaseMetaData dmdbDatabaseMetaData, String string, String string2, String string3, String string4) {
        try {
            return filterChain.DatabaseMetaData_getColumnPrivileges(dmdbDatabaseMetaData, string, string2, string3, string4);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbDatabaseMetaData.connection, sQLException);
            return null;
        }
    }

    @Override
    public ResultSet DatabaseMetaData_getTablePrivileges(FilterChain filterChain, DmdbDatabaseMetaData dmdbDatabaseMetaData, String string, String string2, String string3) {
        try {
            return filterChain.DatabaseMetaData_getTablePrivileges(dmdbDatabaseMetaData, string, string2, string3);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbDatabaseMetaData.connection, sQLException);
            return null;
        }
    }

    @Override
    public ResultSet DatabaseMetaData_getBestRowIdentifier(FilterChain filterChain, DmdbDatabaseMetaData dmdbDatabaseMetaData, String string, String string2, String string3, int n2, boolean bl) {
        try {
            return filterChain.DatabaseMetaData_getBestRowIdentifier(dmdbDatabaseMetaData, string, string2, string3, n2, bl);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbDatabaseMetaData.connection, sQLException);
            return null;
        }
    }

    @Override
    public ResultSet DatabaseMetaData_getVersionColumns(FilterChain filterChain, DmdbDatabaseMetaData dmdbDatabaseMetaData, String string, String string2, String string3) {
        try {
            return filterChain.DatabaseMetaData_getVersionColumns(dmdbDatabaseMetaData, string, string2, string3);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbDatabaseMetaData.connection, sQLException);
            return null;
        }
    }

    @Override
    public ResultSet DatabaseMetaData_getPrimaryKeys(FilterChain filterChain, DmdbDatabaseMetaData dmdbDatabaseMetaData, String string, String string2, String string3) {
        try {
            return filterChain.DatabaseMetaData_getPrimaryKeys(dmdbDatabaseMetaData, string, string2, string3);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbDatabaseMetaData.connection, sQLException);
            return null;
        }
    }

    @Override
    public ResultSet DatabaseMetaData_getImportedKeys(FilterChain filterChain, DmdbDatabaseMetaData dmdbDatabaseMetaData, String string, String string2, String string3) {
        try {
            return filterChain.DatabaseMetaData_getImportedKeys(dmdbDatabaseMetaData, string, string2, string3);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbDatabaseMetaData.connection, sQLException);
            return null;
        }
    }

    @Override
    public ResultSet DatabaseMetaData_getExportedKeys(FilterChain filterChain, DmdbDatabaseMetaData dmdbDatabaseMetaData, String string, String string2, String string3) {
        try {
            return filterChain.DatabaseMetaData_getExportedKeys(dmdbDatabaseMetaData, string, string2, string3);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbDatabaseMetaData.connection, sQLException);
            return null;
        }
    }

    @Override
    public ResultSet DatabaseMetaData_getCrossReference(FilterChain filterChain, DmdbDatabaseMetaData dmdbDatabaseMetaData, String string, String string2, String string3, String string4, String string5, String string6) {
        try {
            return filterChain.DatabaseMetaData_getCrossReference(dmdbDatabaseMetaData, string, string2, string3, string4, string5, string6);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbDatabaseMetaData.connection, sQLException);
            return null;
        }
    }

    @Override
    public ResultSet DatabaseMetaData_getTypeInfo(FilterChain filterChain, DmdbDatabaseMetaData dmdbDatabaseMetaData) {
        try {
            return filterChain.DatabaseMetaData_getTypeInfo(dmdbDatabaseMetaData);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbDatabaseMetaData.connection, sQLException);
            return null;
        }
    }

    @Override
    public ResultSet DatabaseMetaData_getIndexInfo(FilterChain filterChain, DmdbDatabaseMetaData dmdbDatabaseMetaData, String string, String string2, String string3, boolean bl, boolean bl2) {
        try {
            return filterChain.DatabaseMetaData_getIndexInfo(dmdbDatabaseMetaData, string, string2, string3, bl, bl2);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbDatabaseMetaData.connection, sQLException);
            return null;
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsResultSetType(FilterChain filterChain, DmdbDatabaseMetaData dmdbDatabaseMetaData, int n2) {
        try {
            return filterChain.DatabaseMetaData_supportsResultSetType(dmdbDatabaseMetaData, n2);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbDatabaseMetaData.connection, sQLException);
            return false;
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsResultSetConcurrency(FilterChain filterChain, DmdbDatabaseMetaData dmdbDatabaseMetaData, int n2, int n3) {
        try {
            return filterChain.DatabaseMetaData_supportsResultSetConcurrency(dmdbDatabaseMetaData, n2, n3);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbDatabaseMetaData.connection, sQLException);
            return false;
        }
    }

    @Override
    public boolean DatabaseMetaData_ownUpdatesAreVisible(FilterChain filterChain, DmdbDatabaseMetaData dmdbDatabaseMetaData, int n2) {
        try {
            return filterChain.DatabaseMetaData_ownUpdatesAreVisible(dmdbDatabaseMetaData, n2);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbDatabaseMetaData.connection, sQLException);
            return false;
        }
    }

    @Override
    public boolean DatabaseMetaData_ownDeletesAreVisible(FilterChain filterChain, DmdbDatabaseMetaData dmdbDatabaseMetaData, int n2) {
        try {
            return filterChain.DatabaseMetaData_ownDeletesAreVisible(dmdbDatabaseMetaData, n2);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbDatabaseMetaData.connection, sQLException);
            return false;
        }
    }

    @Override
    public boolean DatabaseMetaData_ownInsertsAreVisible(FilterChain filterChain, DmdbDatabaseMetaData dmdbDatabaseMetaData, int n2) {
        try {
            return filterChain.DatabaseMetaData_ownInsertsAreVisible(dmdbDatabaseMetaData, n2);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbDatabaseMetaData.connection, sQLException);
            return false;
        }
    }

    @Override
    public boolean DatabaseMetaData_othersUpdatesAreVisible(FilterChain filterChain, DmdbDatabaseMetaData dmdbDatabaseMetaData, int n2) {
        try {
            return filterChain.DatabaseMetaData_othersUpdatesAreVisible(dmdbDatabaseMetaData, n2);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbDatabaseMetaData.connection, sQLException);
            return false;
        }
    }

    @Override
    public boolean DatabaseMetaData_othersDeletesAreVisible(FilterChain filterChain, DmdbDatabaseMetaData dmdbDatabaseMetaData, int n2) {
        try {
            return filterChain.DatabaseMetaData_othersDeletesAreVisible(dmdbDatabaseMetaData, n2);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbDatabaseMetaData.connection, sQLException);
            return false;
        }
    }

    @Override
    public boolean DatabaseMetaData_othersInsertsAreVisible(FilterChain filterChain, DmdbDatabaseMetaData dmdbDatabaseMetaData, int n2) {
        try {
            return filterChain.DatabaseMetaData_othersInsertsAreVisible(dmdbDatabaseMetaData, n2);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbDatabaseMetaData.connection, sQLException);
            return false;
        }
    }

    @Override
    public boolean DatabaseMetaData_updatesAreDetected(FilterChain filterChain, DmdbDatabaseMetaData dmdbDatabaseMetaData, int n2) {
        try {
            return filterChain.DatabaseMetaData_updatesAreDetected(dmdbDatabaseMetaData, n2);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbDatabaseMetaData.connection, sQLException);
            return false;
        }
    }

    @Override
    public boolean DatabaseMetaData_deletesAreDetected(FilterChain filterChain, DmdbDatabaseMetaData dmdbDatabaseMetaData, int n2) {
        try {
            return filterChain.DatabaseMetaData_deletesAreDetected(dmdbDatabaseMetaData, n2);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbDatabaseMetaData.connection, sQLException);
            return false;
        }
    }

    @Override
    public boolean DatabaseMetaData_insertsAreDetected(FilterChain filterChain, DmdbDatabaseMetaData dmdbDatabaseMetaData, int n2) {
        try {
            return filterChain.DatabaseMetaData_insertsAreDetected(dmdbDatabaseMetaData, n2);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbDatabaseMetaData.connection, sQLException);
            return false;
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsBatchUpdates(FilterChain filterChain, DmdbDatabaseMetaData dmdbDatabaseMetaData) {
        try {
            return filterChain.DatabaseMetaData_supportsBatchUpdates(dmdbDatabaseMetaData);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbDatabaseMetaData.connection, sQLException);
            return false;
        }
    }

    @Override
    public ResultSet DatabaseMetaData_getUDTs(FilterChain filterChain, DmdbDatabaseMetaData dmdbDatabaseMetaData, String string, String string2, String string3, int[] nArray) {
        try {
            return filterChain.DatabaseMetaData_getUDTs(dmdbDatabaseMetaData, string, string2, string3, nArray);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbDatabaseMetaData.connection, sQLException);
            return null;
        }
    }

    @Override
    public Connection DatabaseMetaData_getConnection(FilterChain filterChain, DmdbDatabaseMetaData dmdbDatabaseMetaData) {
        try {
            return filterChain.DatabaseMetaData_getConnection(dmdbDatabaseMetaData);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbDatabaseMetaData.connection, sQLException);
            return null;
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsSavepoints(FilterChain filterChain, DmdbDatabaseMetaData dmdbDatabaseMetaData) {
        try {
            return filterChain.DatabaseMetaData_supportsSavepoints(dmdbDatabaseMetaData);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbDatabaseMetaData.connection, sQLException);
            return false;
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsNamedParameters(FilterChain filterChain, DmdbDatabaseMetaData dmdbDatabaseMetaData) {
        try {
            return filterChain.DatabaseMetaData_supportsNamedParameters(dmdbDatabaseMetaData);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbDatabaseMetaData.connection, sQLException);
            return false;
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsMultipleOpenResults(FilterChain filterChain, DmdbDatabaseMetaData dmdbDatabaseMetaData) {
        try {
            return filterChain.DatabaseMetaData_supportsMultipleOpenResults(dmdbDatabaseMetaData);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbDatabaseMetaData.connection, sQLException);
            return false;
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsGetGeneratedKeys(FilterChain filterChain, DmdbDatabaseMetaData dmdbDatabaseMetaData) {
        try {
            return filterChain.DatabaseMetaData_supportsGetGeneratedKeys(dmdbDatabaseMetaData);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbDatabaseMetaData.connection, sQLException);
            return false;
        }
    }

    @Override
    public ResultSet DatabaseMetaData_getSuperTypes(FilterChain filterChain, DmdbDatabaseMetaData dmdbDatabaseMetaData, String string, String string2, String string3) {
        try {
            return filterChain.DatabaseMetaData_getSuperTypes(dmdbDatabaseMetaData, string, string2, string3);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbDatabaseMetaData.connection, sQLException);
            return null;
        }
    }

    @Override
    public ResultSet DatabaseMetaData_getSuperTables(FilterChain filterChain, DmdbDatabaseMetaData dmdbDatabaseMetaData, String string, String string2, String string3) {
        try {
            return filterChain.DatabaseMetaData_getSuperTables(dmdbDatabaseMetaData, string, string2, string3);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbDatabaseMetaData.connection, sQLException);
            return null;
        }
    }

    @Override
    public ResultSet DatabaseMetaData_getAttributes(FilterChain filterChain, DmdbDatabaseMetaData dmdbDatabaseMetaData, String string, String string2, String string3, String string4) {
        try {
            return filterChain.DatabaseMetaData_getAttributes(dmdbDatabaseMetaData, string, string2, string3, string4);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbDatabaseMetaData.connection, sQLException);
            return null;
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsResultSetHoldability(FilterChain filterChain, DmdbDatabaseMetaData dmdbDatabaseMetaData, int n2) {
        try {
            return filterChain.DatabaseMetaData_supportsResultSetHoldability(dmdbDatabaseMetaData, n2);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbDatabaseMetaData.connection, sQLException);
            return false;
        }
    }

    @Override
    public int DatabaseMetaData_getResultSetHoldability(FilterChain filterChain, DmdbDatabaseMetaData dmdbDatabaseMetaData) {
        try {
            return filterChain.DatabaseMetaData_getResultSetHoldability(dmdbDatabaseMetaData);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbDatabaseMetaData.connection, sQLException);
            return 0;
        }
    }

    @Override
    public int DatabaseMetaData_getDatabaseMajorVersion(FilterChain filterChain, DmdbDatabaseMetaData dmdbDatabaseMetaData) {
        try {
            return filterChain.DatabaseMetaData_getDatabaseMajorVersion(dmdbDatabaseMetaData);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbDatabaseMetaData.connection, sQLException);
            return 0;
        }
    }

    @Override
    public int DatabaseMetaData_getDatabaseMinorVersion(FilterChain filterChain, DmdbDatabaseMetaData dmdbDatabaseMetaData) {
        try {
            return filterChain.DatabaseMetaData_getDatabaseMinorVersion(dmdbDatabaseMetaData);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbDatabaseMetaData.connection, sQLException);
            return 0;
        }
    }

    @Override
    public int DatabaseMetaData_getJDBCMajorVersion(FilterChain filterChain, DmdbDatabaseMetaData dmdbDatabaseMetaData) {
        try {
            return filterChain.DatabaseMetaData_getJDBCMajorVersion(dmdbDatabaseMetaData);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbDatabaseMetaData.connection, sQLException);
            return 0;
        }
    }

    @Override
    public int DatabaseMetaData_getJDBCMinorVersion(FilterChain filterChain, DmdbDatabaseMetaData dmdbDatabaseMetaData) {
        try {
            return filterChain.DatabaseMetaData_getJDBCMinorVersion(dmdbDatabaseMetaData);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbDatabaseMetaData.connection, sQLException);
            return 0;
        }
    }

    @Override
    public int DatabaseMetaData_getSQLStateType(FilterChain filterChain, DmdbDatabaseMetaData dmdbDatabaseMetaData) {
        try {
            return filterChain.DatabaseMetaData_getSQLStateType(dmdbDatabaseMetaData);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbDatabaseMetaData.connection, sQLException);
            return 0;
        }
    }

    @Override
    public boolean DatabaseMetaData_locatorsUpdateCopy(FilterChain filterChain, DmdbDatabaseMetaData dmdbDatabaseMetaData) {
        try {
            return filterChain.DatabaseMetaData_locatorsUpdateCopy(dmdbDatabaseMetaData);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbDatabaseMetaData.connection, sQLException);
            return false;
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsStatementPooling(FilterChain filterChain, DmdbDatabaseMetaData dmdbDatabaseMetaData) {
        try {
            return filterChain.DatabaseMetaData_supportsStatementPooling(dmdbDatabaseMetaData);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbDatabaseMetaData.connection, sQLException);
            return false;
        }
    }

    @Override
    public RowIdLifetime DatabaseMetaData_getRowIdLifetime(FilterChain filterChain, DmdbDatabaseMetaData dmdbDatabaseMetaData) {
        try {
            return filterChain.DatabaseMetaData_getRowIdLifetime(dmdbDatabaseMetaData);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbDatabaseMetaData.connection, sQLException);
            return null;
        }
    }

    @Override
    public ResultSet DatabaseMetaData_getSchemas(FilterChain filterChain, DmdbDatabaseMetaData dmdbDatabaseMetaData, String string, String string2) {
        try {
            return filterChain.DatabaseMetaData_getSchemas(dmdbDatabaseMetaData, string, string2);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbDatabaseMetaData.connection, sQLException);
            return null;
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsStoredFunctionsUsingCallSyntax(FilterChain filterChain, DmdbDatabaseMetaData dmdbDatabaseMetaData) {
        try {
            return filterChain.DatabaseMetaData_supportsStoredFunctionsUsingCallSyntax(dmdbDatabaseMetaData);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbDatabaseMetaData.connection, sQLException);
            return false;
        }
    }

    @Override
    public boolean DatabaseMetaData_autoCommitFailureClosesAllResultSets(FilterChain filterChain, DmdbDatabaseMetaData dmdbDatabaseMetaData) {
        try {
            return filterChain.DatabaseMetaData_autoCommitFailureClosesAllResultSets(dmdbDatabaseMetaData);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbDatabaseMetaData.connection, sQLException);
            return false;
        }
    }

    @Override
    public ResultSet DatabaseMetaData_getClientInfoProperties(FilterChain filterChain, DmdbDatabaseMetaData dmdbDatabaseMetaData) {
        try {
            return filterChain.DatabaseMetaData_getClientInfoProperties(dmdbDatabaseMetaData);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbDatabaseMetaData.connection, sQLException);
            return null;
        }
    }

    @Override
    public ResultSet DatabaseMetaData_getFunctions(FilterChain filterChain, DmdbDatabaseMetaData dmdbDatabaseMetaData, String string, String string2, String string3) {
        try {
            return filterChain.DatabaseMetaData_getFunctions(dmdbDatabaseMetaData, string, string2, string3);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbDatabaseMetaData.connection, sQLException);
            return null;
        }
    }

    @Override
    public ResultSet DatabaseMetaData_getFunctionColumns(FilterChain filterChain, DmdbDatabaseMetaData dmdbDatabaseMetaData, String string, String string2, String string3, String string4) {
        try {
            return filterChain.DatabaseMetaData_getFunctionColumns(dmdbDatabaseMetaData, string, string2, string3, string4);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbDatabaseMetaData.connection, sQLException);
            return null;
        }
    }

    @Override
    public ResultSet DatabaseMetaData_getPseudoColumns(FilterChain filterChain, DmdbDatabaseMetaData dmdbDatabaseMetaData, String string, String string2, String string3, String string4) {
        try {
            return filterChain.DatabaseMetaData_getPseudoColumns(dmdbDatabaseMetaData, string, string2, string3, string4);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbDatabaseMetaData.connection, sQLException);
            return null;
        }
    }

    @Override
    public boolean DatabaseMetaData_generatedKeyAlwaysReturned(FilterChain filterChain, DmdbDatabaseMetaData dmdbDatabaseMetaData) {
        try {
            return filterChain.DatabaseMetaData_generatedKeyAlwaysReturned(dmdbDatabaseMetaData);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbDatabaseMetaData.connection, sQLException);
            return false;
        }
    }

    @Override
    public long DatabaseMetaData_getMaxLogicalLobSize(FilterChain filterChain, DmdbDatabaseMetaData dmdbDatabaseMetaData) {
        try {
            return filterChain.DatabaseMetaData_getMaxLogicalLobSize(dmdbDatabaseMetaData);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbDatabaseMetaData.connection, sQLException);
            return 0L;
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsRefCursors(FilterChain filterChain, DmdbDatabaseMetaData dmdbDatabaseMetaData) {
        try {
            return filterChain.DatabaseMetaData_supportsRefCursors(dmdbDatabaseMetaData);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbDatabaseMetaData.connection, sQLException);
            return false;
        }
    }

    @Override
    public Connection Driver_connect(FilterChain filterChain, DmDriver dmDriver, DmProperties dmProperties) {
        Connection connection = filterChain.Driver_connect(dmDriver, dmProperties);
        this.addConnection((DmdbConnection)connection);
        return connection;
    }

    @Override
    public int ParameterMetaData_getParameterCount(FilterChain filterChain, DmdbParameterMetaData dmdbParameterMetaData) {
        try {
            return filterChain.ParameterMetaData_getParameterCount(dmdbParameterMetaData);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbParameterMetaData.connection, sQLException);
            return 0;
        }
    }

    @Override
    public int ParameterMetaData_isNullable(FilterChain filterChain, DmdbParameterMetaData dmdbParameterMetaData, int n2) {
        try {
            return filterChain.ParameterMetaData_isNullable(dmdbParameterMetaData, n2);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbParameterMetaData.connection, sQLException);
            return 0;
        }
    }

    @Override
    public boolean ParameterMetaData_isSigned(FilterChain filterChain, DmdbParameterMetaData dmdbParameterMetaData, int n2) {
        try {
            return filterChain.ParameterMetaData_isSigned(dmdbParameterMetaData, n2);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbParameterMetaData.connection, sQLException);
            return false;
        }
    }

    @Override
    public int ParameterMetaData_getPrecision(FilterChain filterChain, DmdbParameterMetaData dmdbParameterMetaData, int n2) {
        try {
            return filterChain.ParameterMetaData_getPrecision(dmdbParameterMetaData, n2);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbParameterMetaData.connection, sQLException);
            return 0;
        }
    }

    @Override
    public int ParameterMetaData_getScale(FilterChain filterChain, DmdbParameterMetaData dmdbParameterMetaData, int n2) {
        try {
            return filterChain.ParameterMetaData_getScale(dmdbParameterMetaData, n2);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbParameterMetaData.connection, sQLException);
            return 0;
        }
    }

    @Override
    public int ParameterMetaData_getParameterType(FilterChain filterChain, DmdbParameterMetaData dmdbParameterMetaData, int n2) {
        try {
            return filterChain.ParameterMetaData_getParameterType(dmdbParameterMetaData, n2);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbParameterMetaData.connection, sQLException);
            return 0;
        }
    }

    @Override
    public String ParameterMetaData_getParameterTypeName(FilterChain filterChain, DmdbParameterMetaData dmdbParameterMetaData, int n2) {
        try {
            return filterChain.ParameterMetaData_getParameterTypeName(dmdbParameterMetaData, n2);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbParameterMetaData.connection, sQLException);
            return null;
        }
    }

    @Override
    public String ParameterMetaData_getParameterClassName(FilterChain filterChain, DmdbParameterMetaData dmdbParameterMetaData, int n2) {
        try {
            return filterChain.ParameterMetaData_getParameterClassName(dmdbParameterMetaData, n2);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbParameterMetaData.connection, sQLException);
            return null;
        }
    }

    @Override
    public int ParameterMetaData_getParameterMode(FilterChain filterChain, DmdbParameterMetaData dmdbParameterMetaData, int n2) {
        try {
            return filterChain.ParameterMetaData_getParameterMode(dmdbParameterMetaData, n2);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbParameterMetaData.connection, sQLException);
            return 0;
        }
    }

    @Override
    public ResultSet PreparedStatement_executeQuery(FilterChain filterChain, DmdbPreparedStatement dmdbPreparedStatement) {
        try {
            this.beforeExecute(dmdbPreparedStatement.connection);
            return filterChain.PreparedStatement_executeQuery(dmdbPreparedStatement);
        }
        catch (SQLException sQLException) {
            if (this.whenError(dmdbPreparedStatement.connection, sQLException)) {
                return dmdbPreparedStatement.do_executeQuery();
            }
            return null;
        }
    }

    @Override
    public int PreparedStatement_executeUpdate(FilterChain filterChain, DmdbPreparedStatement dmdbPreparedStatement) {
        try {
            this.beforeExecute(dmdbPreparedStatement.connection);
            return filterChain.PreparedStatement_executeUpdate(dmdbPreparedStatement);
        }
        catch (SQLException sQLException) {
            if (this.whenError(dmdbPreparedStatement.connection, sQLException)) {
                return dmdbPreparedStatement.do_executeUpdate();
            }
            return 0;
        }
    }

    @Override
    public int[] PreparedStatement_executeBatch(FilterChain filterChain, DmdbPreparedStatement dmdbPreparedStatement) {
        try {
            this.beforeExecute(dmdbPreparedStatement.connection);
            dmdbPreparedStatement.clearBatch = false;
            int[] nArray = filterChain.PreparedStatement_executeBatch(dmdbPreparedStatement);
            return nArray;
        }
        catch (SQLException sQLException) {
            if (this.whenError(dmdbPreparedStatement.connection, sQLException)) {
                int[] nArray = dmdbPreparedStatement.do_executeBatch();
                return nArray;
            }
            return null;
        }
        finally {
            dmdbPreparedStatement.clearBatch = true;
            dmdbPreparedStatement.do_clearBatch();
        }
    }

    @Override
    public long[] PreparedStatement_executeLargeBatch(FilterChain filterChain, DmdbPreparedStatement dmdbPreparedStatement) {
        try {
            this.beforeExecute(dmdbPreparedStatement.connection);
            dmdbPreparedStatement.clearBatch = false;
            long[] lArray = filterChain.PreparedStatement_executeLargeBatch(dmdbPreparedStatement);
            return lArray;
        }
        catch (SQLException sQLException) {
            if (this.whenError(dmdbPreparedStatement.connection, sQLException)) {
                long[] lArray = dmdbPreparedStatement.do_executeLargeBatch();
                return lArray;
            }
            return null;
        }
        finally {
            dmdbPreparedStatement.clearBatch = true;
            dmdbPreparedStatement.do_clearBatch();
        }
    }

    @Override
    public void PreparedStatement_setNull(FilterChain filterChain, DmdbPreparedStatement dmdbPreparedStatement, int n2, int n3) {
        try {
            filterChain.PreparedStatement_setNull(dmdbPreparedStatement, n2, n3);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbPreparedStatement.connection, sQLException);
        }
    }

    @Override
    public void PreparedStatement_setBoolean(FilterChain filterChain, DmdbPreparedStatement dmdbPreparedStatement, int n2, boolean bl) {
        try {
            filterChain.PreparedStatement_setBoolean(dmdbPreparedStatement, n2, bl);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbPreparedStatement.connection, sQLException);
        }
    }

    @Override
    public void PreparedStatement_setByte(FilterChain filterChain, DmdbPreparedStatement dmdbPreparedStatement, int n2, byte by) {
        try {
            filterChain.PreparedStatement_setByte(dmdbPreparedStatement, n2, by);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbPreparedStatement.connection, sQLException);
        }
    }

    @Override
    public void PreparedStatement_setShort(FilterChain filterChain, DmdbPreparedStatement dmdbPreparedStatement, int n2, short s2) {
        try {
            filterChain.PreparedStatement_setShort(dmdbPreparedStatement, n2, s2);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbPreparedStatement.connection, sQLException);
        }
    }

    @Override
    public void PreparedStatement_setInt(FilterChain filterChain, DmdbPreparedStatement dmdbPreparedStatement, int n2, int n3) {
        try {
            filterChain.PreparedStatement_setInt(dmdbPreparedStatement, n2, n3);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbPreparedStatement.connection, sQLException);
        }
    }

    @Override
    public void PreparedStatement_setLong(FilterChain filterChain, DmdbPreparedStatement dmdbPreparedStatement, int n2, long l2) {
        try {
            filterChain.PreparedStatement_setLong(dmdbPreparedStatement, n2, l2);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbPreparedStatement.connection, sQLException);
        }
    }

    @Override
    public void PreparedStatement_setFloat(FilterChain filterChain, DmdbPreparedStatement dmdbPreparedStatement, int n2, float f2) {
        try {
            filterChain.PreparedStatement_setFloat(dmdbPreparedStatement, n2, f2);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbPreparedStatement.connection, sQLException);
        }
    }

    @Override
    public void PreparedStatement_setDouble(FilterChain filterChain, DmdbPreparedStatement dmdbPreparedStatement, int n2, double d2) {
        try {
            filterChain.PreparedStatement_setDouble(dmdbPreparedStatement, n2, d2);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbPreparedStatement.connection, sQLException);
        }
    }

    @Override
    public void PreparedStatement_setBigDecimal(FilterChain filterChain, DmdbPreparedStatement dmdbPreparedStatement, int n2, BigDecimal bigDecimal) {
        try {
            filterChain.PreparedStatement_setBigDecimal(dmdbPreparedStatement, n2, bigDecimal);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbPreparedStatement.connection, sQLException);
        }
    }

    @Override
    public void PreparedStatement_setString(FilterChain filterChain, DmdbPreparedStatement dmdbPreparedStatement, int n2, String string) {
        try {
            filterChain.PreparedStatement_setString(dmdbPreparedStatement, n2, string);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbPreparedStatement.connection, sQLException);
        }
    }

    @Override
    public void PreparedStatement_setBytes(FilterChain filterChain, DmdbPreparedStatement dmdbPreparedStatement, int n2, byte[] byArray) {
        try {
            filterChain.PreparedStatement_setBytes(dmdbPreparedStatement, n2, byArray);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbPreparedStatement.connection, sQLException);
        }
    }

    @Override
    public void PreparedStatement_setDate(FilterChain filterChain, DmdbPreparedStatement dmdbPreparedStatement, int n2, Date date) {
        try {
            filterChain.PreparedStatement_setDate(dmdbPreparedStatement, n2, date);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbPreparedStatement.connection, sQLException);
        }
    }

    @Override
    public void PreparedStatement_setTime(FilterChain filterChain, DmdbPreparedStatement dmdbPreparedStatement, int n2, Time time) {
        try {
            filterChain.PreparedStatement_setTime(dmdbPreparedStatement, n2, time);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbPreparedStatement.connection, sQLException);
        }
    }

    @Override
    public void PreparedStatement_setTimestamp(FilterChain filterChain, DmdbPreparedStatement dmdbPreparedStatement, int n2, Timestamp timestamp) {
        try {
            filterChain.PreparedStatement_setTimestamp(dmdbPreparedStatement, n2, timestamp);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbPreparedStatement.connection, sQLException);
        }
    }

    @Override
    public void PreparedStatement_setAsciiStream(FilterChain filterChain, DmdbPreparedStatement dmdbPreparedStatement, int n2, InputStream inputStream, int n3) {
        try {
            filterChain.PreparedStatement_setAsciiStream(dmdbPreparedStatement, n2, inputStream, n3);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbPreparedStatement.connection, sQLException);
        }
    }

    @Override
    public void PreparedStatement_setUnicodeStream(FilterChain filterChain, DmdbPreparedStatement dmdbPreparedStatement, int n2, InputStream inputStream, int n3) {
        try {
            filterChain.PreparedStatement_setUnicodeStream(dmdbPreparedStatement, n2, inputStream, n3);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbPreparedStatement.connection, sQLException);
        }
    }

    @Override
    public void PreparedStatement_setBinaryStream(FilterChain filterChain, DmdbPreparedStatement dmdbPreparedStatement, int n2, InputStream inputStream, int n3) {
        try {
            filterChain.PreparedStatement_setBinaryStream(dmdbPreparedStatement, n2, inputStream, n3);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbPreparedStatement.connection, sQLException);
        }
    }

    @Override
    public void PreparedStatement_clearParameters(FilterChain filterChain, DmdbPreparedStatement dmdbPreparedStatement) {
        try {
            filterChain.PreparedStatement_clearParameters(dmdbPreparedStatement);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbPreparedStatement.connection, sQLException);
        }
    }

    @Override
    public void PreparedStatement_setObject(FilterChain filterChain, DmdbPreparedStatement dmdbPreparedStatement, int n2, Object object, int n3) {
        try {
            filterChain.PreparedStatement_setObject(dmdbPreparedStatement, n2, object, n3);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbPreparedStatement.connection, sQLException);
        }
    }

    @Override
    public void PreparedStatement_setObject(FilterChain filterChain, DmdbPreparedStatement dmdbPreparedStatement, int n2, Object object) {
        try {
            filterChain.PreparedStatement_setObject(dmdbPreparedStatement, n2, object);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbPreparedStatement.connection, sQLException);
        }
    }

    @Override
    public boolean PreparedStatement_execute(FilterChain filterChain, DmdbPreparedStatement dmdbPreparedStatement) {
        try {
            this.beforeExecute(dmdbPreparedStatement.connection);
            return filterChain.PreparedStatement_execute(dmdbPreparedStatement);
        }
        catch (SQLException sQLException) {
            if (this.whenError(dmdbPreparedStatement.connection, sQLException)) {
                return dmdbPreparedStatement.do_execute();
            }
            return false;
        }
    }

    @Override
    public void PreparedStatement_addBatch(FilterChain filterChain, DmdbPreparedStatement dmdbPreparedStatement) {
        try {
            filterChain.PreparedStatement_addBatch(dmdbPreparedStatement);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbPreparedStatement.connection, sQLException);
        }
    }

    @Override
    public void PreparedStatement_setCharacterStream(FilterChain filterChain, DmdbPreparedStatement dmdbPreparedStatement, int n2, Reader reader, int n3) {
        try {
            filterChain.PreparedStatement_setCharacterStream(dmdbPreparedStatement, n2, reader, n3);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbPreparedStatement.connection, sQLException);
        }
    }

    @Override
    public void PreparedStatement_setRef(FilterChain filterChain, DmdbPreparedStatement dmdbPreparedStatement, int n2, Ref ref) {
        try {
            filterChain.PreparedStatement_setRef(dmdbPreparedStatement, n2, ref);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbPreparedStatement.connection, sQLException);
        }
    }

    @Override
    public void PreparedStatement_setBlob(FilterChain filterChain, DmdbPreparedStatement dmdbPreparedStatement, int n2, Blob blob) {
        try {
            filterChain.PreparedStatement_setBlob(dmdbPreparedStatement, n2, blob);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbPreparedStatement.connection, sQLException);
        }
    }

    @Override
    public void PreparedStatement_setClob(FilterChain filterChain, DmdbPreparedStatement dmdbPreparedStatement, int n2, Clob clob) {
        try {
            filterChain.PreparedStatement_setClob(dmdbPreparedStatement, n2, clob);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbPreparedStatement.connection, sQLException);
        }
    }

    @Override
    public void PreparedStatement_setArray(FilterChain filterChain, DmdbPreparedStatement dmdbPreparedStatement, int n2, Array array) {
        try {
            filterChain.PreparedStatement_setArray(dmdbPreparedStatement, n2, array);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbPreparedStatement.connection, sQLException);
        }
    }

    @Override
    public ResultSetMetaData PreparedStatement_getMetaData(FilterChain filterChain, DmdbPreparedStatement dmdbPreparedStatement) {
        try {
            return filterChain.PreparedStatement_getMetaData(dmdbPreparedStatement);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbPreparedStatement.connection, sQLException);
            return null;
        }
    }

    @Override
    public void PreparedStatement_setDate(FilterChain filterChain, DmdbPreparedStatement dmdbPreparedStatement, int n2, Date date, Calendar calendar) {
        try {
            filterChain.PreparedStatement_setDate(dmdbPreparedStatement, n2, date, calendar);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbPreparedStatement.connection, sQLException);
        }
    }

    @Override
    public void PreparedStatement_setTime(FilterChain filterChain, DmdbPreparedStatement dmdbPreparedStatement, int n2, Time time, Calendar calendar) {
        try {
            filterChain.PreparedStatement_setTime(dmdbPreparedStatement, n2, time, calendar);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbPreparedStatement.connection, sQLException);
        }
    }

    @Override
    public void PreparedStatement_setTimestamp(FilterChain filterChain, DmdbPreparedStatement dmdbPreparedStatement, int n2, Timestamp timestamp, Calendar calendar) {
        try {
            filterChain.PreparedStatement_setTimestamp(dmdbPreparedStatement, n2, timestamp, calendar);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbPreparedStatement.connection, sQLException);
        }
    }

    @Override
    public void PreparedStatement_setNull(FilterChain filterChain, DmdbPreparedStatement dmdbPreparedStatement, int n2, int n3, String string) {
        try {
            filterChain.PreparedStatement_setNull(dmdbPreparedStatement, n2, n3, string);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbPreparedStatement.connection, sQLException);
        }
    }

    @Override
    public void PreparedStatement_setURL(FilterChain filterChain, DmdbPreparedStatement dmdbPreparedStatement, int n2, URL uRL) {
        try {
            filterChain.PreparedStatement_setURL(dmdbPreparedStatement, n2, uRL);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbPreparedStatement.connection, sQLException);
        }
    }

    @Override
    public ParameterMetaData PreparedStatement_getParameterMetaData(FilterChain filterChain, DmdbPreparedStatement dmdbPreparedStatement) {
        try {
            return filterChain.PreparedStatement_getParameterMetaData(dmdbPreparedStatement);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbPreparedStatement.connection, sQLException);
            return null;
        }
    }

    @Override
    public void PreparedStatement_setRowId(FilterChain filterChain, DmdbPreparedStatement dmdbPreparedStatement, int n2, RowId rowId) {
        try {
            filterChain.PreparedStatement_setRowId(dmdbPreparedStatement, n2, rowId);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbPreparedStatement.connection, sQLException);
        }
    }

    @Override
    public void PreparedStatement_setNString(FilterChain filterChain, DmdbPreparedStatement dmdbPreparedStatement, int n2, String string) {
        try {
            filterChain.PreparedStatement_setNString(dmdbPreparedStatement, n2, string);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbPreparedStatement.connection, sQLException);
        }
    }

    @Override
    public void PreparedStatement_setNCharacterStream(FilterChain filterChain, DmdbPreparedStatement dmdbPreparedStatement, int n2, Reader reader, long l2) {
        try {
            filterChain.PreparedStatement_setNCharacterStream(dmdbPreparedStatement, n2, reader, l2);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbPreparedStatement.connection, sQLException);
        }
    }

    @Override
    public void PreparedStatement_setNClob(FilterChain filterChain, DmdbPreparedStatement dmdbPreparedStatement, int n2, NClob nClob) {
        try {
            filterChain.PreparedStatement_setNClob(dmdbPreparedStatement, n2, nClob);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbPreparedStatement.connection, sQLException);
        }
    }

    @Override
    public void PreparedStatement_setClob(FilterChain filterChain, DmdbPreparedStatement dmdbPreparedStatement, int n2, Reader reader, long l2) {
        try {
            filterChain.PreparedStatement_setClob(dmdbPreparedStatement, n2, reader, l2);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbPreparedStatement.connection, sQLException);
        }
    }

    @Override
    public void PreparedStatement_setBlob(FilterChain filterChain, DmdbPreparedStatement dmdbPreparedStatement, int n2, InputStream inputStream, long l2) {
        try {
            filterChain.PreparedStatement_setBlob(dmdbPreparedStatement, n2, inputStream, l2);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbPreparedStatement.connection, sQLException);
        }
    }

    @Override
    public void PreparedStatement_setNClob(FilterChain filterChain, DmdbPreparedStatement dmdbPreparedStatement, int n2, Reader reader, long l2) {
        try {
            filterChain.PreparedStatement_setNClob(dmdbPreparedStatement, n2, reader, l2);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbPreparedStatement.connection, sQLException);
        }
    }

    @Override
    public void PreparedStatement_setSQLXML(FilterChain filterChain, DmdbPreparedStatement dmdbPreparedStatement, int n2, SQLXML sQLXML) {
        try {
            filterChain.PreparedStatement_setSQLXML(dmdbPreparedStatement, n2, sQLXML);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbPreparedStatement.connection, sQLException);
        }
    }

    @Override
    public void PreparedStatement_setObject(FilterChain filterChain, DmdbPreparedStatement dmdbPreparedStatement, int n2, Object object, int n3, int n4) {
        try {
            filterChain.PreparedStatement_setObject(dmdbPreparedStatement, n2, object, n3, n4);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbPreparedStatement.connection, sQLException);
        }
    }

    @Override
    public void PreparedStatement_setAsciiStream(FilterChain filterChain, DmdbPreparedStatement dmdbPreparedStatement, int n2, InputStream inputStream, long l2) {
        try {
            filterChain.PreparedStatement_setAsciiStream(dmdbPreparedStatement, n2, inputStream, l2);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbPreparedStatement.connection, sQLException);
        }
    }

    @Override
    public void PreparedStatement_setBinaryStream(FilterChain filterChain, DmdbPreparedStatement dmdbPreparedStatement, int n2, InputStream inputStream, long l2) {
        try {
            filterChain.PreparedStatement_setBinaryStream(dmdbPreparedStatement, n2, inputStream, l2);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbPreparedStatement.connection, sQLException);
        }
    }

    @Override
    public void PreparedStatement_setCharacterStream(FilterChain filterChain, DmdbPreparedStatement dmdbPreparedStatement, int n2, Reader reader, long l2) {
        try {
            filterChain.PreparedStatement_setCharacterStream(dmdbPreparedStatement, n2, reader, l2);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbPreparedStatement.connection, sQLException);
        }
    }

    @Override
    public void PreparedStatement_setAsciiStream(FilterChain filterChain, DmdbPreparedStatement dmdbPreparedStatement, int n2, InputStream inputStream) {
        try {
            filterChain.PreparedStatement_setAsciiStream(dmdbPreparedStatement, n2, inputStream);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbPreparedStatement.connection, sQLException);
        }
    }

    @Override
    public void PreparedStatement_setBinaryStream(FilterChain filterChain, DmdbPreparedStatement dmdbPreparedStatement, int n2, InputStream inputStream) {
        try {
            filterChain.PreparedStatement_setBinaryStream(dmdbPreparedStatement, n2, inputStream);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbPreparedStatement.connection, sQLException);
        }
    }

    @Override
    public void PreparedStatement_setCharacterStream(FilterChain filterChain, DmdbPreparedStatement dmdbPreparedStatement, int n2, Reader reader) {
        try {
            filterChain.PreparedStatement_setCharacterStream(dmdbPreparedStatement, n2, reader);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbPreparedStatement.connection, sQLException);
        }
    }

    @Override
    public void PreparedStatement_setNCharacterStream(FilterChain filterChain, DmdbPreparedStatement dmdbPreparedStatement, int n2, Reader reader) {
        try {
            filterChain.PreparedStatement_setNCharacterStream(dmdbPreparedStatement, n2, reader);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbPreparedStatement.connection, sQLException);
        }
    }

    @Override
    public void PreparedStatement_setClob(FilterChain filterChain, DmdbPreparedStatement dmdbPreparedStatement, int n2, Reader reader) {
        try {
            filterChain.PreparedStatement_setClob(dmdbPreparedStatement, n2, reader);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbPreparedStatement.connection, sQLException);
        }
    }

    @Override
    public void PreparedStatement_setBlob(FilterChain filterChain, DmdbPreparedStatement dmdbPreparedStatement, int n2, InputStream inputStream) {
        try {
            filterChain.PreparedStatement_setBlob(dmdbPreparedStatement, n2, inputStream);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbPreparedStatement.connection, sQLException);
        }
    }

    @Override
    public void PreparedStatement_setNClob(FilterChain filterChain, DmdbPreparedStatement dmdbPreparedStatement, int n2, Reader reader) {
        try {
            filterChain.PreparedStatement_setNClob(dmdbPreparedStatement, n2, reader);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbPreparedStatement.connection, sQLException);
        }
    }

    @Override
    public void PreparedStatement_setObject(FilterChain filterChain, DmdbPreparedStatement dmdbPreparedStatement, int n2, Object object, SQLType sQLType, int n3) {
        try {
            filterChain.PreparedStatement_setObject(dmdbPreparedStatement, n2, object, sQLType, n3);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbPreparedStatement.connection, sQLException);
        }
    }

    @Override
    public void PreparedStatement_setObject(FilterChain filterChain, DmdbPreparedStatement dmdbPreparedStatement, int n2, Object object, SQLType sQLType) {
        try {
            filterChain.PreparedStatement_setObject(dmdbPreparedStatement, n2, object, sQLType);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbPreparedStatement.connection, sQLException);
        }
    }

    @Override
    public long PreparedStatement_executeLargeUpdate(FilterChain filterChain, DmdbPreparedStatement dmdbPreparedStatement) {
        try {
            this.beforeExecute(dmdbPreparedStatement.connection);
            return filterChain.PreparedStatement_executeLargeUpdate(dmdbPreparedStatement);
        }
        catch (SQLException sQLException) {
            if (this.whenError(dmdbPreparedStatement.connection, sQLException)) {
                return dmdbPreparedStatement.do_executeLargeUpdate();
            }
            return 0L;
        }
    }

    @Override
    public void PreparedStatement_preCompile(FilterChain filterChain, DmdbPreparedStatement dmdbPreparedStatement, String string) {
        try {
            filterChain.PreparedStatement_preCompile(dmdbPreparedStatement, string);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbPreparedStatement.connection, sQLException);
        }
    }

    @Override
    public void PreparedStatement_setTIMESTAMP(FilterChain filterChain, DmdbPreparedStatement dmdbPreparedStatement, int n2, DmdbTimestamp dmdbTimestamp) {
        try {
            filterChain.PreparedStatement_setTIMESTAMP(dmdbPreparedStatement, n2, dmdbTimestamp);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbPreparedStatement.connection, sQLException);
        }
    }

    @Override
    public void PreparedStatement_setINTERVALYM(FilterChain filterChain, DmdbPreparedStatement dmdbPreparedStatement, int n2, DmdbIntervalYM dmdbIntervalYM) {
        try {
            filterChain.PreparedStatement_setINTERVALYM(dmdbPreparedStatement, n2, dmdbIntervalYM);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbPreparedStatement.connection, sQLException);
        }
    }

    @Override
    public void PreparedStatement_setINTERVALDT(FilterChain filterChain, DmdbPreparedStatement dmdbPreparedStatement, int n2, DmdbIntervalDT dmdbIntervalDT) {
        try {
            filterChain.PreparedStatement_setINTERVALDT(dmdbPreparedStatement, n2, dmdbIntervalDT);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbPreparedStatement.connection, sQLException);
        }
    }

    @Override
    public boolean ResultSet_next(FilterChain filterChain, DmdbResultSet dmdbResultSet) {
        try {
            return filterChain.ResultSet_next(dmdbResultSet);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbResultSet.connection, sQLException);
            return false;
        }
    }

    @Override
    public void ResultSet_close(FilterChain filterChain, DmdbResultSet dmdbResultSet) {
        try {
            filterChain.ResultSet_close(dmdbResultSet);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbResultSet.connection, sQLException);
        }
    }

    @Override
    public boolean ResultSet_wasNull(FilterChain filterChain, DmdbResultSet dmdbResultSet) {
        try {
            return filterChain.ResultSet_wasNull(dmdbResultSet);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbResultSet.connection, sQLException);
            return false;
        }
    }

    @Override
    public String ResultSet_getString(FilterChain filterChain, DmdbResultSet dmdbResultSet, int n2) {
        try {
            return filterChain.ResultSet_getString(dmdbResultSet, n2);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbResultSet.connection, sQLException);
            return null;
        }
    }

    @Override
    public boolean ResultSet_getBoolean(FilterChain filterChain, DmdbResultSet dmdbResultSet, int n2) {
        try {
            return filterChain.ResultSet_getBoolean(dmdbResultSet, n2);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbResultSet.connection, sQLException);
            return false;
        }
    }

    @Override
    public byte ResultSet_getByte(FilterChain filterChain, DmdbResultSet dmdbResultSet, int n2) {
        try {
            return filterChain.ResultSet_getByte(dmdbResultSet, n2);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbResultSet.connection, sQLException);
            return 0;
        }
    }

    @Override
    public short ResultSet_getShort(FilterChain filterChain, DmdbResultSet dmdbResultSet, int n2) {
        try {
            return filterChain.ResultSet_getShort(dmdbResultSet, n2);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbResultSet.connection, sQLException);
            return 0;
        }
    }

    @Override
    public int ResultSet_getInt(FilterChain filterChain, DmdbResultSet dmdbResultSet, int n2) {
        try {
            return filterChain.ResultSet_getInt(dmdbResultSet, n2);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbResultSet.connection, sQLException);
            return 0;
        }
    }

    @Override
    public long ResultSet_getLong(FilterChain filterChain, DmdbResultSet dmdbResultSet, int n2) {
        try {
            return filterChain.ResultSet_getLong(dmdbResultSet, n2);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbResultSet.connection, sQLException);
            return 0L;
        }
    }

    @Override
    public float ResultSet_getFloat(FilterChain filterChain, DmdbResultSet dmdbResultSet, int n2) {
        try {
            return filterChain.ResultSet_getFloat(dmdbResultSet, n2);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbResultSet.connection, sQLException);
            return 0.0f;
        }
    }

    @Override
    public double ResultSet_getDouble(FilterChain filterChain, DmdbResultSet dmdbResultSet, int n2) {
        try {
            return filterChain.ResultSet_getDouble(dmdbResultSet, n2);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbResultSet.connection, sQLException);
            return 0.0;
        }
    }

    @Override
    public BigDecimal ResultSet_getBigDecimal(FilterChain filterChain, DmdbResultSet dmdbResultSet, int n2, int n3) {
        try {
            return filterChain.ResultSet_getBigDecimal(dmdbResultSet, n2);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbResultSet.connection, sQLException);
            return null;
        }
    }

    @Override
    public byte[] ResultSet_getBytes(FilterChain filterChain, DmdbResultSet dmdbResultSet, int n2) {
        try {
            return filterChain.ResultSet_getBytes(dmdbResultSet, n2);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbResultSet.connection, sQLException);
            return null;
        }
    }

    @Override
    public Date ResultSet_getDate(FilterChain filterChain, DmdbResultSet dmdbResultSet, int n2) {
        try {
            return filterChain.ResultSet_getDate(dmdbResultSet, n2);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbResultSet.connection, sQLException);
            return null;
        }
    }

    @Override
    public Time ResultSet_getTime(FilterChain filterChain, DmdbResultSet dmdbResultSet, int n2) {
        try {
            return filterChain.ResultSet_getTime(dmdbResultSet, n2);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbResultSet.connection, sQLException);
            return null;
        }
    }

    @Override
    public Timestamp ResultSet_getTimestamp(FilterChain filterChain, DmdbResultSet dmdbResultSet, int n2) {
        try {
            return filterChain.ResultSet_getTimestamp(dmdbResultSet, n2);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbResultSet.connection, sQLException);
            return null;
        }
    }

    @Override
    public InputStream ResultSet_getAsciiStream(FilterChain filterChain, DmdbResultSet dmdbResultSet, int n2) {
        try {
            return filterChain.ResultSet_getAsciiStream(dmdbResultSet, n2);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbResultSet.connection, sQLException);
            return null;
        }
    }

    @Override
    public InputStream ResultSet_getUnicodeStream(FilterChain filterChain, DmdbResultSet dmdbResultSet, int n2) {
        try {
            return filterChain.ResultSet_getUnicodeStream(dmdbResultSet, n2);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbResultSet.connection, sQLException);
            return null;
        }
    }

    @Override
    public InputStream ResultSet_getBinaryStream(FilterChain filterChain, DmdbResultSet dmdbResultSet, int n2) {
        try {
            return filterChain.ResultSet_getBinaryStream(dmdbResultSet, n2);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbResultSet.connection, sQLException);
            return null;
        }
    }

    @Override
    public String ResultSet_getString(FilterChain filterChain, DmdbResultSet dmdbResultSet, String string) {
        try {
            return filterChain.ResultSet_getString(dmdbResultSet, string);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbResultSet.connection, sQLException);
            return null;
        }
    }

    @Override
    public boolean ResultSet_getBoolean(FilterChain filterChain, DmdbResultSet dmdbResultSet, String string) {
        try {
            return filterChain.ResultSet_getBoolean(dmdbResultSet, string);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbResultSet.connection, sQLException);
            return false;
        }
    }

    @Override
    public byte ResultSet_getByte(FilterChain filterChain, DmdbResultSet dmdbResultSet, String string) {
        try {
            return filterChain.ResultSet_getByte(dmdbResultSet, string);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbResultSet.connection, sQLException);
            return 0;
        }
    }

    @Override
    public short ResultSet_getShort(FilterChain filterChain, DmdbResultSet dmdbResultSet, String string) {
        try {
            return filterChain.ResultSet_getShort(dmdbResultSet, string);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbResultSet.connection, sQLException);
            return 0;
        }
    }

    @Override
    public int ResultSet_getInt(FilterChain filterChain, DmdbResultSet dmdbResultSet, String string) {
        try {
            return filterChain.ResultSet_getInt(dmdbResultSet, string);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbResultSet.connection, sQLException);
            return 0;
        }
    }

    @Override
    public long ResultSet_getLong(FilterChain filterChain, DmdbResultSet dmdbResultSet, String string) {
        try {
            return filterChain.ResultSet_getLong(dmdbResultSet, string);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbResultSet.connection, sQLException);
            return 0L;
        }
    }

    @Override
    public float ResultSet_getFloat(FilterChain filterChain, DmdbResultSet dmdbResultSet, String string) {
        try {
            return filterChain.ResultSet_getFloat(dmdbResultSet, string);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbResultSet.connection, sQLException);
            return 0.0f;
        }
    }

    @Override
    public double ResultSet_getDouble(FilterChain filterChain, DmdbResultSet dmdbResultSet, String string) {
        try {
            return filterChain.ResultSet_getDouble(dmdbResultSet, string);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbResultSet.connection, sQLException);
            return 0.0;
        }
    }

    @Override
    public BigDecimal ResultSet_getBigDecimal(FilterChain filterChain, DmdbResultSet dmdbResultSet, String string, int n2) {
        try {
            return filterChain.ResultSet_getBigDecimal(dmdbResultSet, string, n2);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbResultSet.connection, sQLException);
            return null;
        }
    }

    @Override
    public byte[] ResultSet_getBytes(FilterChain filterChain, DmdbResultSet dmdbResultSet, String string) {
        try {
            return filterChain.ResultSet_getBytes(dmdbResultSet, string);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbResultSet.connection, sQLException);
            return null;
        }
    }

    @Override
    public Date ResultSet_getDate(FilterChain filterChain, DmdbResultSet dmdbResultSet, String string) {
        try {
            return filterChain.ResultSet_getDate(dmdbResultSet, string);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbResultSet.connection, sQLException);
            return null;
        }
    }

    @Override
    public Time ResultSet_getTime(FilterChain filterChain, DmdbResultSet dmdbResultSet, String string) {
        try {
            return filterChain.ResultSet_getTime(dmdbResultSet, string);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbResultSet.connection, sQLException);
            return null;
        }
    }

    @Override
    public Timestamp ResultSet_getTimestamp(FilterChain filterChain, DmdbResultSet dmdbResultSet, String string) {
        try {
            return filterChain.ResultSet_getTimestamp(dmdbResultSet, string);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbResultSet.connection, sQLException);
            return null;
        }
    }

    @Override
    public InputStream ResultSet_getAsciiStream(FilterChain filterChain, DmdbResultSet dmdbResultSet, String string) {
        try {
            return filterChain.ResultSet_getAsciiStream(dmdbResultSet, string);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbResultSet.connection, sQLException);
            return null;
        }
    }

    @Override
    public InputStream ResultSet_getUnicodeStream(FilterChain filterChain, DmdbResultSet dmdbResultSet, String string) {
        try {
            return filterChain.ResultSet_getUnicodeStream(dmdbResultSet, string);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbResultSet.connection, sQLException);
            return null;
        }
    }

    @Override
    public InputStream ResultSet_getBinaryStream(FilterChain filterChain, DmdbResultSet dmdbResultSet, String string) {
        try {
            return filterChain.ResultSet_getBinaryStream(dmdbResultSet, string);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbResultSet.connection, sQLException);
            return null;
        }
    }

    @Override
    public SQLWarning ResultSet_getWarnings(FilterChain filterChain, DmdbResultSet dmdbResultSet) {
        try {
            return filterChain.ResultSet_getWarnings(dmdbResultSet);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbResultSet.connection, sQLException);
            return null;
        }
    }

    @Override
    public void ResultSet_clearWarnings(FilterChain filterChain, DmdbResultSet dmdbResultSet) {
        try {
            filterChain.ResultSet_clearWarnings(dmdbResultSet);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbResultSet.connection, sQLException);
        }
    }

    @Override
    public String ResultSet_getCursorName(FilterChain filterChain, DmdbResultSet dmdbResultSet) {
        try {
            return filterChain.ResultSet_getCursorName(dmdbResultSet);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbResultSet.connection, sQLException);
            return null;
        }
    }

    @Override
    public ResultSetMetaData ResultSet_getMetaData(FilterChain filterChain, DmdbResultSet dmdbResultSet) {
        try {
            return filterChain.ResultSet_getMetaData(dmdbResultSet);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbResultSet.connection, sQLException);
            return null;
        }
    }

    @Override
    public Object ResultSet_getObject(FilterChain filterChain, DmdbResultSet dmdbResultSet, int n2) {
        try {
            return filterChain.ResultSet_getObject(dmdbResultSet, n2);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbResultSet.connection, sQLException);
            return null;
        }
    }

    @Override
    public Object ResultSet_getObject(FilterChain filterChain, DmdbResultSet dmdbResultSet, String string) {
        try {
            return filterChain.ResultSet_getObject(dmdbResultSet, string);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbResultSet.connection, sQLException);
            return null;
        }
    }

    @Override
    public int ResultSet_findColumn(FilterChain filterChain, DmdbResultSet dmdbResultSet, String string) {
        try {
            return filterChain.ResultSet_findColumn(dmdbResultSet, string);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbResultSet.connection, sQLException);
            return 0;
        }
    }

    @Override
    public Reader ResultSet_getCharacterStream(FilterChain filterChain, DmdbResultSet dmdbResultSet, int n2) {
        try {
            return filterChain.ResultSet_getCharacterStream(dmdbResultSet, n2);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbResultSet.connection, sQLException);
            return null;
        }
    }

    @Override
    public Reader ResultSet_getCharacterStream(FilterChain filterChain, DmdbResultSet dmdbResultSet, String string) {
        try {
            return filterChain.ResultSet_getCharacterStream(dmdbResultSet, string);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbResultSet.connection, sQLException);
            return null;
        }
    }

    @Override
    public BigDecimal ResultSet_getBigDecimal(FilterChain filterChain, DmdbResultSet dmdbResultSet, int n2) {
        try {
            return filterChain.ResultSet_getBigDecimal(dmdbResultSet, n2);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbResultSet.connection, sQLException);
            return null;
        }
    }

    @Override
    public BigDecimal ResultSet_getBigDecimal(FilterChain filterChain, DmdbResultSet dmdbResultSet, String string) {
        try {
            return filterChain.ResultSet_getBigDecimal(dmdbResultSet, string);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbResultSet.connection, sQLException);
            return null;
        }
    }

    @Override
    public boolean ResultSet_isBeforeFirst(FilterChain filterChain, DmdbResultSet dmdbResultSet) {
        try {
            return filterChain.ResultSet_isBeforeFirst(dmdbResultSet);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbResultSet.connection, sQLException);
            return false;
        }
    }

    @Override
    public boolean ResultSet_isAfterLast(FilterChain filterChain, DmdbResultSet dmdbResultSet) {
        try {
            return filterChain.ResultSet_isAfterLast(dmdbResultSet);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbResultSet.connection, sQLException);
            return false;
        }
    }

    @Override
    public boolean ResultSet_isFirst(FilterChain filterChain, DmdbResultSet dmdbResultSet) {
        try {
            return filterChain.ResultSet_isFirst(dmdbResultSet);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbResultSet.connection, sQLException);
            return false;
        }
    }

    @Override
    public boolean ResultSet_isLast(FilterChain filterChain, DmdbResultSet dmdbResultSet) {
        try {
            return filterChain.ResultSet_isLast(dmdbResultSet);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbResultSet.connection, sQLException);
            return false;
        }
    }

    @Override
    public void ResultSet_beforeFirst(FilterChain filterChain, DmdbResultSet dmdbResultSet) {
        try {
            filterChain.ResultSet_beforeFirst(dmdbResultSet);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbResultSet.connection, sQLException);
        }
    }

    @Override
    public void ResultSet_afterLast(FilterChain filterChain, DmdbResultSet dmdbResultSet) {
        try {
            filterChain.ResultSet_afterLast(dmdbResultSet);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbResultSet.connection, sQLException);
        }
    }

    @Override
    public boolean ResultSet_first(FilterChain filterChain, DmdbResultSet dmdbResultSet) {
        try {
            return filterChain.ResultSet_first(dmdbResultSet);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbResultSet.connection, sQLException);
            return false;
        }
    }

    @Override
    public boolean ResultSet_last(FilterChain filterChain, DmdbResultSet dmdbResultSet) {
        try {
            return filterChain.ResultSet_last(dmdbResultSet);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbResultSet.connection, sQLException);
            return false;
        }
    }

    @Override
    public int ResultSet_getRow(FilterChain filterChain, DmdbResultSet dmdbResultSet) {
        try {
            return filterChain.ResultSet_getRow(dmdbResultSet);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbResultSet.connection, sQLException);
            return 0;
        }
    }

    @Override
    public boolean ResultSet_absolute(FilterChain filterChain, DmdbResultSet dmdbResultSet, int n2) {
        try {
            return filterChain.ResultSet_absolute(dmdbResultSet, n2);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbResultSet.connection, sQLException);
            return false;
        }
    }

    @Override
    public boolean ResultSet_relative(FilterChain filterChain, DmdbResultSet dmdbResultSet, int n2) {
        try {
            return filterChain.ResultSet_relative(dmdbResultSet, n2);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbResultSet.connection, sQLException);
            return false;
        }
    }

    @Override
    public boolean ResultSet_previous(FilterChain filterChain, DmdbResultSet dmdbResultSet) {
        try {
            return filterChain.ResultSet_previous(dmdbResultSet);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbResultSet.connection, sQLException);
            return false;
        }
    }

    @Override
    public void ResultSet_setFetchDirection(FilterChain filterChain, DmdbResultSet dmdbResultSet, int n2) {
        try {
            filterChain.ResultSet_setFetchDirection(dmdbResultSet, n2);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbResultSet.connection, sQLException);
        }
    }

    @Override
    public int ResultSet_getFetchDirection(FilterChain filterChain, DmdbResultSet dmdbResultSet) {
        try {
            return filterChain.ResultSet_getFetchDirection(dmdbResultSet);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbResultSet.connection, sQLException);
            return 0;
        }
    }

    @Override
    public void ResultSet_setFetchSize(FilterChain filterChain, DmdbResultSet dmdbResultSet, int n2) {
        try {
            filterChain.ResultSet_setFetchSize(dmdbResultSet, n2);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbResultSet.connection, sQLException);
        }
    }

    @Override
    public int ResultSet_getFetchSize(FilterChain filterChain, DmdbResultSet dmdbResultSet) {
        try {
            return filterChain.ResultSet_getFetchSize(dmdbResultSet);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbResultSet.connection, sQLException);
            return 0;
        }
    }

    @Override
    public int ResultSet_getType(FilterChain filterChain, DmdbResultSet dmdbResultSet) {
        try {
            return filterChain.ResultSet_getType(dmdbResultSet);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbResultSet.connection, sQLException);
            return 0;
        }
    }

    @Override
    public int ResultSet_getConcurrency(FilterChain filterChain, DmdbResultSet dmdbResultSet) {
        try {
            return filterChain.ResultSet_getConcurrency(dmdbResultSet);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbResultSet.connection, sQLException);
            return 0;
        }
    }

    @Override
    public boolean ResultSet_rowUpdated(FilterChain filterChain, DmdbResultSet dmdbResultSet) {
        try {
            return filterChain.ResultSet_rowUpdated(dmdbResultSet);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbResultSet.connection, sQLException);
            return false;
        }
    }

    @Override
    public boolean ResultSet_rowInserted(FilterChain filterChain, DmdbResultSet dmdbResultSet) {
        try {
            return filterChain.ResultSet_rowInserted(dmdbResultSet);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbResultSet.connection, sQLException);
            return false;
        }
    }

    @Override
    public boolean ResultSet_rowDeleted(FilterChain filterChain, DmdbResultSet dmdbResultSet) {
        try {
            return filterChain.ResultSet_rowDeleted(dmdbResultSet);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbResultSet.connection, sQLException);
            return false;
        }
    }

    @Override
    public void ResultSet_updateNull(FilterChain filterChain, DmdbResultSet dmdbResultSet, int n2) {
        try {
            filterChain.ResultSet_updateNull(dmdbResultSet, n2);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbResultSet.connection, sQLException);
        }
    }

    @Override
    public void ResultSet_updateBoolean(FilterChain filterChain, DmdbResultSet dmdbResultSet, int n2, boolean bl) {
        try {
            filterChain.ResultSet_updateBoolean(dmdbResultSet, n2, bl);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbResultSet.connection, sQLException);
        }
    }

    @Override
    public void ResultSet_updateByte(FilterChain filterChain, DmdbResultSet dmdbResultSet, int n2, byte by) {
        try {
            filterChain.ResultSet_updateByte(dmdbResultSet, n2, by);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbResultSet.connection, sQLException);
        }
    }

    @Override
    public void ResultSet_updateShort(FilterChain filterChain, DmdbResultSet dmdbResultSet, int n2, short s2) {
        try {
            filterChain.ResultSet_updateShort(dmdbResultSet, n2, s2);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbResultSet.connection, sQLException);
        }
    }

    @Override
    public void ResultSet_updateInt(FilterChain filterChain, DmdbResultSet dmdbResultSet, int n2, int n3) {
        try {
            filterChain.ResultSet_updateInt(dmdbResultSet, n2, n3);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbResultSet.connection, sQLException);
        }
    }

    @Override
    public void ResultSet_updateLong(FilterChain filterChain, DmdbResultSet dmdbResultSet, int n2, long l2) {
        try {
            filterChain.ResultSet_updateLong(dmdbResultSet, n2, l2);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbResultSet.connection, sQLException);
        }
    }

    @Override
    public void ResultSet_updateFloat(FilterChain filterChain, DmdbResultSet dmdbResultSet, int n2, float f2) {
        try {
            filterChain.ResultSet_updateFloat(dmdbResultSet, n2, f2);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbResultSet.connection, sQLException);
        }
    }

    @Override
    public void ResultSet_updateDouble(FilterChain filterChain, DmdbResultSet dmdbResultSet, int n2, double d2) {
        try {
            filterChain.ResultSet_updateDouble(dmdbResultSet, n2, d2);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbResultSet.connection, sQLException);
        }
    }

    @Override
    public void ResultSet_updateBigDecimal(FilterChain filterChain, DmdbResultSet dmdbResultSet, int n2, BigDecimal bigDecimal) {
        try {
            filterChain.ResultSet_updateBigDecimal(dmdbResultSet, n2, bigDecimal);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbResultSet.connection, sQLException);
        }
    }

    @Override
    public void ResultSet_updateString(FilterChain filterChain, DmdbResultSet dmdbResultSet, int n2, String string) {
        try {
            filterChain.ResultSet_updateString(dmdbResultSet, n2, string);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbResultSet.connection, sQLException);
        }
    }

    @Override
    public void ResultSet_updateBytes(FilterChain filterChain, DmdbResultSet dmdbResultSet, int n2, byte[] byArray) {
        try {
            filterChain.ResultSet_updateBytes(dmdbResultSet, n2, byArray);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbResultSet.connection, sQLException);
        }
    }

    @Override
    public void ResultSet_updateDate(FilterChain filterChain, DmdbResultSet dmdbResultSet, int n2, Date date) {
        try {
            filterChain.ResultSet_updateDate(dmdbResultSet, n2, date);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbResultSet.connection, sQLException);
        }
    }

    @Override
    public void ResultSet_updateTime(FilterChain filterChain, DmdbResultSet dmdbResultSet, int n2, Time time) {
        try {
            filterChain.ResultSet_updateTime(dmdbResultSet, n2, time);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbResultSet.connection, sQLException);
        }
    }

    @Override
    public void ResultSet_updateTimestamp(FilterChain filterChain, DmdbResultSet dmdbResultSet, int n2, Timestamp timestamp) {
        try {
            filterChain.ResultSet_updateTimestamp(dmdbResultSet, n2, timestamp);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbResultSet.connection, sQLException);
        }
    }

    @Override
    public void ResultSet_updateAsciiStream(FilterChain filterChain, DmdbResultSet dmdbResultSet, int n2, InputStream inputStream, int n3) {
        try {
            filterChain.ResultSet_updateAsciiStream(dmdbResultSet, n2, inputStream, n3);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbResultSet.connection, sQLException);
        }
    }

    @Override
    public void ResultSet_updateBinaryStream(FilterChain filterChain, DmdbResultSet dmdbResultSet, int n2, InputStream inputStream, int n3) {
        try {
            filterChain.ResultSet_updateBinaryStream(dmdbResultSet, n2, inputStream, n3);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbResultSet.connection, sQLException);
        }
    }

    @Override
    public void ResultSet_updateCharacterStream(FilterChain filterChain, DmdbResultSet dmdbResultSet, int n2, Reader reader, int n3) {
        try {
            filterChain.ResultSet_updateCharacterStream(dmdbResultSet, n2, reader, n3);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbResultSet.connection, sQLException);
        }
    }

    @Override
    public void ResultSet_updateObject(FilterChain filterChain, DmdbResultSet dmdbResultSet, int n2, Object object, int n3) {
        try {
            filterChain.ResultSet_updateObject(dmdbResultSet, n2, object, n3);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbResultSet.connection, sQLException);
        }
    }

    @Override
    public void ResultSet_updateObject(FilterChain filterChain, DmdbResultSet dmdbResultSet, int n2, Object object) {
        try {
            filterChain.ResultSet_updateObject(dmdbResultSet, n2, object);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbResultSet.connection, sQLException);
        }
    }

    @Override
    public void ResultSet_updateNull(FilterChain filterChain, DmdbResultSet dmdbResultSet, String string) {
        try {
            filterChain.ResultSet_updateNull(dmdbResultSet, string);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbResultSet.connection, sQLException);
        }
    }

    @Override
    public void ResultSet_updateBoolean(FilterChain filterChain, DmdbResultSet dmdbResultSet, String string, boolean bl) {
        try {
            filterChain.ResultSet_updateBoolean(dmdbResultSet, string, bl);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbResultSet.connection, sQLException);
        }
    }

    @Override
    public void ResultSet_updateByte(FilterChain filterChain, DmdbResultSet dmdbResultSet, String string, byte by) {
        try {
            filterChain.ResultSet_updateByte(dmdbResultSet, string, by);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbResultSet.connection, sQLException);
        }
    }

    @Override
    public void ResultSet_updateShort(FilterChain filterChain, DmdbResultSet dmdbResultSet, String string, short s2) {
        try {
            filterChain.ResultSet_updateShort(dmdbResultSet, string, s2);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbResultSet.connection, sQLException);
        }
    }

    @Override
    public void ResultSet_updateInt(FilterChain filterChain, DmdbResultSet dmdbResultSet, String string, int n2) {
        try {
            filterChain.ResultSet_updateInt(dmdbResultSet, string, n2);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbResultSet.connection, sQLException);
        }
    }

    @Override
    public void ResultSet_updateLong(FilterChain filterChain, DmdbResultSet dmdbResultSet, String string, long l2) {
        try {
            filterChain.ResultSet_updateLong(dmdbResultSet, string, l2);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbResultSet.connection, sQLException);
        }
    }

    @Override
    public void ResultSet_updateFloat(FilterChain filterChain, DmdbResultSet dmdbResultSet, String string, float f2) {
        try {
            filterChain.ResultSet_updateFloat(dmdbResultSet, string, f2);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbResultSet.connection, sQLException);
        }
    }

    @Override
    public void ResultSet_updateDouble(FilterChain filterChain, DmdbResultSet dmdbResultSet, String string, double d2) {
        try {
            filterChain.ResultSet_updateDouble(dmdbResultSet, string, d2);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbResultSet.connection, sQLException);
        }
    }

    @Override
    public void ResultSet_updateBigDecimal(FilterChain filterChain, DmdbResultSet dmdbResultSet, String string, BigDecimal bigDecimal) {
        try {
            filterChain.ResultSet_updateBigDecimal(dmdbResultSet, string, bigDecimal);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbResultSet.connection, sQLException);
        }
    }

    @Override
    public void ResultSet_updateString(FilterChain filterChain, DmdbResultSet dmdbResultSet, String string, String string2) {
        try {
            filterChain.ResultSet_updateString(dmdbResultSet, string, string2);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbResultSet.connection, sQLException);
        }
    }

    @Override
    public void ResultSet_updateBytes(FilterChain filterChain, DmdbResultSet dmdbResultSet, String string, byte[] byArray) {
        try {
            filterChain.ResultSet_updateBytes(dmdbResultSet, string, byArray);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbResultSet.connection, sQLException);
        }
    }

    @Override
    public void ResultSet_updateDate(FilterChain filterChain, DmdbResultSet dmdbResultSet, String string, Date date) {
        try {
            filterChain.ResultSet_updateDate(dmdbResultSet, string, date);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbResultSet.connection, sQLException);
        }
    }

    @Override
    public void ResultSet_updateTime(FilterChain filterChain, DmdbResultSet dmdbResultSet, String string, Time time) {
        try {
            filterChain.ResultSet_updateTime(dmdbResultSet, string, time);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbResultSet.connection, sQLException);
        }
    }

    @Override
    public void ResultSet_updateTimestamp(FilterChain filterChain, DmdbResultSet dmdbResultSet, String string, Timestamp timestamp) {
        try {
            filterChain.ResultSet_updateTimestamp(dmdbResultSet, string, timestamp);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbResultSet.connection, sQLException);
        }
    }

    @Override
    public void ResultSet_updateAsciiStream(FilterChain filterChain, DmdbResultSet dmdbResultSet, String string, InputStream inputStream, int n2) {
        try {
            filterChain.ResultSet_updateAsciiStream(dmdbResultSet, string, inputStream);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbResultSet.connection, sQLException);
        }
    }

    @Override
    public void ResultSet_updateBinaryStream(FilterChain filterChain, DmdbResultSet dmdbResultSet, String string, InputStream inputStream, int n2) {
        try {
            filterChain.ResultSet_updateBinaryStream(dmdbResultSet, string, inputStream);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbResultSet.connection, sQLException);
        }
    }

    @Override
    public void ResultSet_updateCharacterStream(FilterChain filterChain, DmdbResultSet dmdbResultSet, String string, Reader reader, int n2) {
        try {
            filterChain.ResultSet_updateCharacterStream(dmdbResultSet, string, reader, n2);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbResultSet.connection, sQLException);
        }
    }

    @Override
    public void ResultSet_updateObject(FilterChain filterChain, DmdbResultSet dmdbResultSet, String string, Object object, int n2) {
        try {
            filterChain.ResultSet_updateObject(dmdbResultSet, string, object, n2);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbResultSet.connection, sQLException);
        }
    }

    @Override
    public void ResultSet_updateObject(FilterChain filterChain, DmdbResultSet dmdbResultSet, String string, Object object) {
        try {
            filterChain.ResultSet_updateObject(dmdbResultSet, string, object);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbResultSet.connection, sQLException);
        }
    }

    @Override
    public void ResultSet_insertRow(FilterChain filterChain, DmdbResultSet dmdbResultSet) {
        try {
            filterChain.ResultSet_insertRow(dmdbResultSet);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbResultSet.connection, sQLException);
        }
    }

    @Override
    public void ResultSet_updateRow(FilterChain filterChain, DmdbResultSet dmdbResultSet) {
        try {
            filterChain.ResultSet_updateRow(dmdbResultSet);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbResultSet.connection, sQLException);
        }
    }

    @Override
    public void ResultSet_deleteRow(FilterChain filterChain, DmdbResultSet dmdbResultSet) {
        try {
            filterChain.ResultSet_deleteRow(dmdbResultSet);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbResultSet.connection, sQLException);
        }
    }

    @Override
    public void ResultSet_refreshRow(FilterChain filterChain, DmdbResultSet dmdbResultSet) {
        try {
            filterChain.ResultSet_refreshRow(dmdbResultSet);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbResultSet.connection, sQLException);
        }
    }

    @Override
    public void ResultSet_cancelRowUpdates(FilterChain filterChain, DmdbResultSet dmdbResultSet) {
        try {
            filterChain.ResultSet_cancelRowUpdates(dmdbResultSet);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbResultSet.connection, sQLException);
        }
    }

    @Override
    public void ResultSet_moveToInsertRow(FilterChain filterChain, DmdbResultSet dmdbResultSet) {
        try {
            filterChain.ResultSet_moveToInsertRow(dmdbResultSet);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbResultSet.connection, sQLException);
        }
    }

    @Override
    public void ResultSet_moveToCurrentRow(FilterChain filterChain, DmdbResultSet dmdbResultSet) {
        try {
            filterChain.ResultSet_moveToCurrentRow(dmdbResultSet);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbResultSet.connection, sQLException);
        }
    }

    @Override
    public Statement ResultSet_getStatement(FilterChain filterChain, DmdbResultSet dmdbResultSet) {
        try {
            return filterChain.ResultSet_getStatement(dmdbResultSet);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbResultSet.connection, sQLException);
            return null;
        }
    }

    @Override
    public Object ResultSet_getObject(FilterChain filterChain, DmdbResultSet dmdbResultSet, int n2, Map map) {
        try {
            return filterChain.ResultSet_getObject(dmdbResultSet, n2, map);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbResultSet.connection, sQLException);
            return null;
        }
    }

    @Override
    public Ref ResultSet_getRef(FilterChain filterChain, DmdbResultSet dmdbResultSet, int n2) {
        try {
            return filterChain.ResultSet_getRef(dmdbResultSet, n2);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbResultSet.connection, sQLException);
            return null;
        }
    }

    @Override
    public Blob ResultSet_getBlob(FilterChain filterChain, DmdbResultSet dmdbResultSet, int n2) {
        try {
            return filterChain.ResultSet_getBlob(dmdbResultSet, n2);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbResultSet.connection, sQLException);
            return null;
        }
    }

    @Override
    public Clob ResultSet_getClob(FilterChain filterChain, DmdbResultSet dmdbResultSet, int n2) {
        try {
            return filterChain.ResultSet_getClob(dmdbResultSet, n2);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbResultSet.connection, sQLException);
            return null;
        }
    }

    @Override
    public Array ResultSet_getArray(FilterChain filterChain, DmdbResultSet dmdbResultSet, int n2) {
        try {
            return filterChain.ResultSet_getArray(dmdbResultSet, n2);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbResultSet.connection, sQLException);
            return null;
        }
    }

    @Override
    public Object ResultSet_getObject(FilterChain filterChain, DmdbResultSet dmdbResultSet, String string, Map map) {
        try {
            return filterChain.ResultSet_getObject(dmdbResultSet, string, map);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbResultSet.connection, sQLException);
            return null;
        }
    }

    @Override
    public Ref ResultSet_getRef(FilterChain filterChain, DmdbResultSet dmdbResultSet, String string) {
        try {
            return filterChain.ResultSet_getRef(dmdbResultSet, string);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbResultSet.connection, sQLException);
            return null;
        }
    }

    @Override
    public Blob ResultSet_getBlob(FilterChain filterChain, DmdbResultSet dmdbResultSet, String string) {
        try {
            return filterChain.ResultSet_getBlob(dmdbResultSet, string);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbResultSet.connection, sQLException);
            return null;
        }
    }

    @Override
    public Clob ResultSet_getClob(FilterChain filterChain, DmdbResultSet dmdbResultSet, String string) {
        try {
            return filterChain.ResultSet_getClob(dmdbResultSet, string);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbResultSet.connection, sQLException);
            return null;
        }
    }

    @Override
    public Array ResultSet_getArray(FilterChain filterChain, DmdbResultSet dmdbResultSet, String string) {
        try {
            return filterChain.ResultSet_getArray(dmdbResultSet, string);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbResultSet.connection, sQLException);
            return null;
        }
    }

    @Override
    public Date ResultSet_getDate(FilterChain filterChain, DmdbResultSet dmdbResultSet, int n2, Calendar calendar) {
        try {
            return filterChain.ResultSet_getDate(dmdbResultSet, n2, calendar);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbResultSet.connection, sQLException);
            return null;
        }
    }

    @Override
    public Date ResultSet_getDate(FilterChain filterChain, DmdbResultSet dmdbResultSet, String string, Calendar calendar) {
        try {
            return filterChain.ResultSet_getDate(dmdbResultSet, string, calendar);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbResultSet.connection, sQLException);
            return null;
        }
    }

    @Override
    public Time ResultSet_getTime(FilterChain filterChain, DmdbResultSet dmdbResultSet, int n2, Calendar calendar) {
        try {
            return filterChain.ResultSet_getTime(dmdbResultSet, n2, calendar);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbResultSet.connection, sQLException);
            return null;
        }
    }

    @Override
    public Time ResultSet_getTime(FilterChain filterChain, DmdbResultSet dmdbResultSet, String string, Calendar calendar) {
        try {
            return filterChain.ResultSet_getTime(dmdbResultSet, string, calendar);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbResultSet.connection, sQLException);
            return null;
        }
    }

    @Override
    public Timestamp ResultSet_getTimestamp(FilterChain filterChain, DmdbResultSet dmdbResultSet, int n2, Calendar calendar) {
        try {
            return filterChain.ResultSet_getTimestamp(dmdbResultSet, n2, calendar);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbResultSet.connection, sQLException);
            return null;
        }
    }

    @Override
    public Timestamp ResultSet_getTimestamp(FilterChain filterChain, DmdbResultSet dmdbResultSet, String string, Calendar calendar) {
        try {
            return filterChain.ResultSet_getTimestamp(dmdbResultSet, string, calendar);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbResultSet.connection, sQLException);
            return null;
        }
    }

    @Override
    public URL ResultSet_getURL(FilterChain filterChain, DmdbResultSet dmdbResultSet, int n2) {
        try {
            return filterChain.ResultSet_getURL(dmdbResultSet, n2);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbResultSet.connection, sQLException);
            return null;
        }
    }

    @Override
    public URL ResultSet_getURL(FilterChain filterChain, DmdbResultSet dmdbResultSet, String string) {
        try {
            return filterChain.ResultSet_getURL(dmdbResultSet, string);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbResultSet.connection, sQLException);
            return null;
        }
    }

    @Override
    public void ResultSet_updateRef(FilterChain filterChain, DmdbResultSet dmdbResultSet, int n2, Ref ref) {
        try {
            filterChain.ResultSet_updateRef(dmdbResultSet, n2, ref);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbResultSet.connection, sQLException);
        }
    }

    @Override
    public void ResultSet_updateRef(FilterChain filterChain, DmdbResultSet dmdbResultSet, String string, Ref ref) {
        try {
            filterChain.ResultSet_updateRef(dmdbResultSet, string, ref);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbResultSet.connection, sQLException);
        }
    }

    @Override
    public void ResultSet_updateBlob(FilterChain filterChain, DmdbResultSet dmdbResultSet, int n2, Blob blob) {
        try {
            filterChain.ResultSet_updateBlob(dmdbResultSet, n2, blob);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbResultSet.connection, sQLException);
        }
    }

    @Override
    public void ResultSet_updateBlob(FilterChain filterChain, DmdbResultSet dmdbResultSet, String string, Blob blob) {
        try {
            filterChain.ResultSet_updateBlob(dmdbResultSet, string, blob);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbResultSet.connection, sQLException);
        }
    }

    @Override
    public void ResultSet_updateClob(FilterChain filterChain, DmdbResultSet dmdbResultSet, int n2, Clob clob) {
        try {
            filterChain.ResultSet_updateClob(dmdbResultSet, n2, clob);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbResultSet.connection, sQLException);
        }
    }

    @Override
    public void ResultSet_updateClob(FilterChain filterChain, DmdbResultSet dmdbResultSet, String string, Clob clob) {
        try {
            filterChain.ResultSet_updateClob(dmdbResultSet, string, clob);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbResultSet.connection, sQLException);
        }
    }

    @Override
    public void ResultSet_updateArray(FilterChain filterChain, DmdbResultSet dmdbResultSet, int n2, Array array) {
        try {
            filterChain.ResultSet_updateArray(dmdbResultSet, n2, array);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbResultSet.connection, sQLException);
        }
    }

    @Override
    public void ResultSet_updateArray(FilterChain filterChain, DmdbResultSet dmdbResultSet, String string, Array array) {
        try {
            filterChain.ResultSet_updateArray(dmdbResultSet, string, array);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbResultSet.connection, sQLException);
        }
    }

    @Override
    public RowId ResultSet_getRowId(FilterChain filterChain, DmdbResultSet dmdbResultSet, int n2) {
        try {
            return filterChain.ResultSet_getRowId(dmdbResultSet, n2);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbResultSet.connection, sQLException);
            return null;
        }
    }

    @Override
    public RowId ResultSet_getRowId(FilterChain filterChain, DmdbResultSet dmdbResultSet, String string) {
        try {
            return filterChain.ResultSet_getRowId(dmdbResultSet, string);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbResultSet.connection, sQLException);
            return null;
        }
    }

    @Override
    public void ResultSet_updateRowId(FilterChain filterChain, DmdbResultSet dmdbResultSet, int n2, RowId rowId) {
        try {
            filterChain.ResultSet_updateRowId(dmdbResultSet, n2, rowId);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbResultSet.connection, sQLException);
        }
    }

    @Override
    public void ResultSet_updateRowId(FilterChain filterChain, DmdbResultSet dmdbResultSet, String string, RowId rowId) {
        try {
            filterChain.ResultSet_updateRowId(dmdbResultSet, string, rowId);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbResultSet.connection, sQLException);
        }
    }

    @Override
    public int ResultSet_getHoldability(FilterChain filterChain, DmdbResultSet dmdbResultSet) {
        try {
            return filterChain.ResultSet_getHoldability(dmdbResultSet);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbResultSet.connection, sQLException);
            return 0;
        }
    }

    @Override
    public boolean ResultSet_isClosed(FilterChain filterChain, DmdbResultSet dmdbResultSet) {
        try {
            return filterChain.ResultSet_isClosed(dmdbResultSet);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbResultSet.connection, sQLException);
            return false;
        }
    }

    @Override
    public void ResultSet_updateNString(FilterChain filterChain, DmdbResultSet dmdbResultSet, int n2, String string) {
        try {
            filterChain.ResultSet_updateNString(dmdbResultSet, n2, string);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbResultSet.connection, sQLException);
        }
    }

    @Override
    public void ResultSet_updateNString(FilterChain filterChain, DmdbResultSet dmdbResultSet, String string, String string2) {
        try {
            filterChain.ResultSet_updateNString(dmdbResultSet, string, string2);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbResultSet.connection, sQLException);
        }
    }

    @Override
    public void ResultSet_updateNClob(FilterChain filterChain, DmdbResultSet dmdbResultSet, int n2, NClob nClob) {
        try {
            filterChain.ResultSet_updateNClob(dmdbResultSet, n2, nClob);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbResultSet.connection, sQLException);
        }
    }

    @Override
    public void ResultSet_updateNClob(FilterChain filterChain, DmdbResultSet dmdbResultSet, String string, NClob nClob) {
        try {
            filterChain.ResultSet_updateNClob(dmdbResultSet, string, nClob);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbResultSet.connection, sQLException);
        }
    }

    @Override
    public NClob ResultSet_getNClob(FilterChain filterChain, DmdbResultSet dmdbResultSet, int n2) {
        try {
            return filterChain.ResultSet_getNClob(dmdbResultSet, n2);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbResultSet.connection, sQLException);
            return null;
        }
    }

    @Override
    public NClob ResultSet_getNClob(FilterChain filterChain, DmdbResultSet dmdbResultSet, String string) {
        try {
            return filterChain.ResultSet_getNClob(dmdbResultSet, string);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbResultSet.connection, sQLException);
            return null;
        }
    }

    @Override
    public SQLXML ResultSet_getSQLXML(FilterChain filterChain, DmdbResultSet dmdbResultSet, int n2) {
        try {
            return filterChain.ResultSet_getSQLXML(dmdbResultSet, n2);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbResultSet.connection, sQLException);
            return null;
        }
    }

    @Override
    public SQLXML ResultSet_getSQLXML(FilterChain filterChain, DmdbResultSet dmdbResultSet, String string) {
        try {
            return filterChain.ResultSet_getSQLXML(dmdbResultSet, string);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbResultSet.connection, sQLException);
            return null;
        }
    }

    @Override
    public void ResultSet_updateSQLXML(FilterChain filterChain, DmdbResultSet dmdbResultSet, int n2, SQLXML sQLXML) {
        try {
            filterChain.ResultSet_updateSQLXML(dmdbResultSet, n2, sQLXML);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbResultSet.connection, sQLException);
        }
    }

    @Override
    public void ResultSet_updateSQLXML(FilterChain filterChain, DmdbResultSet dmdbResultSet, String string, SQLXML sQLXML) {
        try {
            filterChain.ResultSet_updateSQLXML(dmdbResultSet, string, sQLXML);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbResultSet.connection, sQLException);
        }
    }

    @Override
    public String ResultSet_getNString(FilterChain filterChain, DmdbResultSet dmdbResultSet, int n2) {
        try {
            return filterChain.ResultSet_getNString(dmdbResultSet, n2);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbResultSet.connection, sQLException);
            return null;
        }
    }

    @Override
    public String ResultSet_getNString(FilterChain filterChain, DmdbResultSet dmdbResultSet, String string) {
        try {
            return filterChain.ResultSet_getNString(dmdbResultSet, string);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbResultSet.connection, sQLException);
            return null;
        }
    }

    @Override
    public Reader ResultSet_getNCharacterStream(FilterChain filterChain, DmdbResultSet dmdbResultSet, int n2) {
        try {
            return filterChain.ResultSet_getNCharacterStream(dmdbResultSet, n2);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbResultSet.connection, sQLException);
            return null;
        }
    }

    @Override
    public Reader ResultSet_getNCharacterStream(FilterChain filterChain, DmdbResultSet dmdbResultSet, String string) {
        try {
            return filterChain.ResultSet_getNCharacterStream(dmdbResultSet, string);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbResultSet.connection, sQLException);
            return null;
        }
    }

    @Override
    public void ResultSet_updateNCharacterStream(FilterChain filterChain, DmdbResultSet dmdbResultSet, int n2, Reader reader, long l2) {
        try {
            filterChain.ResultSet_updateNCharacterStream(dmdbResultSet, n2, reader, l2);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbResultSet.connection, sQLException);
        }
    }

    @Override
    public void ResultSet_updateNCharacterStream(FilterChain filterChain, DmdbResultSet dmdbResultSet, String string, Reader reader, long l2) {
        try {
            filterChain.ResultSet_updateNCharacterStream(dmdbResultSet, string, reader, l2);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbResultSet.connection, sQLException);
        }
    }

    @Override
    public void ResultSet_updateAsciiStream(FilterChain filterChain, DmdbResultSet dmdbResultSet, int n2, InputStream inputStream, long l2) {
        try {
            filterChain.ResultSet_updateAsciiStream(dmdbResultSet, n2, inputStream, l2);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbResultSet.connection, sQLException);
        }
    }

    @Override
    public void ResultSet_updateBinaryStream(FilterChain filterChain, DmdbResultSet dmdbResultSet, int n2, InputStream inputStream, long l2) {
        try {
            filterChain.ResultSet_updateBinaryStream(dmdbResultSet, n2, inputStream, l2);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbResultSet.connection, sQLException);
        }
    }

    @Override
    public void ResultSet_updateCharacterStream(FilterChain filterChain, DmdbResultSet dmdbResultSet, int n2, Reader reader, long l2) {
        try {
            filterChain.ResultSet_updateCharacterStream(dmdbResultSet, n2, reader, l2);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbResultSet.connection, sQLException);
        }
    }

    @Override
    public void ResultSet_updateAsciiStream(FilterChain filterChain, DmdbResultSet dmdbResultSet, String string, InputStream inputStream, long l2) {
        try {
            filterChain.ResultSet_updateAsciiStream(dmdbResultSet, string, inputStream, l2);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbResultSet.connection, sQLException);
        }
    }

    @Override
    public void ResultSet_updateBinaryStream(FilterChain filterChain, DmdbResultSet dmdbResultSet, String string, InputStream inputStream, long l2) {
        try {
            filterChain.ResultSet_updateBinaryStream(dmdbResultSet, string, inputStream, l2);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbResultSet.connection, sQLException);
        }
    }

    @Override
    public void ResultSet_updateCharacterStream(FilterChain filterChain, DmdbResultSet dmdbResultSet, String string, Reader reader, long l2) {
        try {
            filterChain.ResultSet_updateCharacterStream(dmdbResultSet, string, reader, l2);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbResultSet.connection, sQLException);
        }
    }

    @Override
    public void ResultSet_updateBlob(FilterChain filterChain, DmdbResultSet dmdbResultSet, int n2, InputStream inputStream, long l2) {
        try {
            filterChain.ResultSet_updateBlob(dmdbResultSet, n2, inputStream, l2);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbResultSet.connection, sQLException);
        }
    }

    @Override
    public void ResultSet_updateBlob(FilterChain filterChain, DmdbResultSet dmdbResultSet, String string, InputStream inputStream, long l2) {
        try {
            filterChain.ResultSet_updateBlob(dmdbResultSet, string, inputStream, l2);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbResultSet.connection, sQLException);
        }
    }

    @Override
    public void ResultSet_updateClob(FilterChain filterChain, DmdbResultSet dmdbResultSet, int n2, Reader reader, long l2) {
        try {
            filterChain.ResultSet_updateClob(dmdbResultSet, n2, reader, l2);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbResultSet.connection, sQLException);
        }
    }

    @Override
    public void ResultSet_updateClob(FilterChain filterChain, DmdbResultSet dmdbResultSet, String string, Reader reader, long l2) {
        try {
            filterChain.ResultSet_updateClob(dmdbResultSet, string, reader, l2);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbResultSet.connection, sQLException);
        }
    }

    @Override
    public void ResultSet_updateNClob(FilterChain filterChain, DmdbResultSet dmdbResultSet, int n2, Reader reader, long l2) {
        try {
            filterChain.ResultSet_updateNClob(dmdbResultSet, n2, reader, l2);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbResultSet.connection, sQLException);
        }
    }

    @Override
    public void ResultSet_updateNClob(FilterChain filterChain, DmdbResultSet dmdbResultSet, String string, Reader reader, long l2) {
        try {
            filterChain.ResultSet_updateNClob(dmdbResultSet, string, reader, l2);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbResultSet.connection, sQLException);
        }
    }

    @Override
    public void ResultSet_updateNCharacterStream(FilterChain filterChain, DmdbResultSet dmdbResultSet, int n2, Reader reader) {
        try {
            filterChain.ResultSet_updateNCharacterStream(dmdbResultSet, n2, reader);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbResultSet.connection, sQLException);
        }
    }

    @Override
    public void ResultSet_updateNCharacterStream(FilterChain filterChain, DmdbResultSet dmdbResultSet, String string, Reader reader) {
        try {
            filterChain.ResultSet_updateNCharacterStream(dmdbResultSet, string, reader);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbResultSet.connection, sQLException);
        }
    }

    @Override
    public void ResultSet_updateAsciiStream(FilterChain filterChain, DmdbResultSet dmdbResultSet, int n2, InputStream inputStream) {
        try {
            filterChain.ResultSet_updateAsciiStream(dmdbResultSet, n2, inputStream);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbResultSet.connection, sQLException);
        }
    }

    @Override
    public void ResultSet_updateBinaryStream(FilterChain filterChain, DmdbResultSet dmdbResultSet, int n2, InputStream inputStream) {
        try {
            filterChain.ResultSet_updateBinaryStream(dmdbResultSet, n2, inputStream);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbResultSet.connection, sQLException);
        }
    }

    @Override
    public void ResultSet_updateCharacterStream(FilterChain filterChain, DmdbResultSet dmdbResultSet, int n2, Reader reader) {
        try {
            filterChain.ResultSet_updateCharacterStream(dmdbResultSet, n2, reader);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbResultSet.connection, sQLException);
        }
    }

    @Override
    public void ResultSet_updateAsciiStream(FilterChain filterChain, DmdbResultSet dmdbResultSet, String string, InputStream inputStream) {
        try {
            filterChain.ResultSet_updateAsciiStream(dmdbResultSet, string, inputStream);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbResultSet.connection, sQLException);
        }
    }

    @Override
    public void ResultSet_updateBinaryStream(FilterChain filterChain, DmdbResultSet dmdbResultSet, String string, InputStream inputStream) {
        try {
            filterChain.ResultSet_updateBinaryStream(dmdbResultSet, string, inputStream);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbResultSet.connection, sQLException);
        }
    }

    @Override
    public void ResultSet_updateCharacterStream(FilterChain filterChain, DmdbResultSet dmdbResultSet, String string, Reader reader) {
        try {
            filterChain.ResultSet_updateCharacterStream(dmdbResultSet, string, reader);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbResultSet.connection, sQLException);
        }
    }

    @Override
    public void ResultSet_updateBlob(FilterChain filterChain, DmdbResultSet dmdbResultSet, int n2, InputStream inputStream) {
        try {
            filterChain.ResultSet_updateBlob(dmdbResultSet, n2, inputStream);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbResultSet.connection, sQLException);
        }
    }

    @Override
    public void ResultSet_updateBlob(FilterChain filterChain, DmdbResultSet dmdbResultSet, String string, InputStream inputStream) {
        try {
            filterChain.ResultSet_updateBlob(dmdbResultSet, string, inputStream);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbResultSet.connection, sQLException);
        }
    }

    @Override
    public void ResultSet_updateClob(FilterChain filterChain, DmdbResultSet dmdbResultSet, int n2, Reader reader) {
        try {
            filterChain.ResultSet_updateClob(dmdbResultSet, n2, reader);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbResultSet.connection, sQLException);
        }
    }

    @Override
    public void ResultSet_updateClob(FilterChain filterChain, DmdbResultSet dmdbResultSet, String string, Reader reader) {
        try {
            filterChain.ResultSet_updateClob(dmdbResultSet, string, reader);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbResultSet.connection, sQLException);
        }
    }

    @Override
    public void ResultSet_updateNClob(FilterChain filterChain, DmdbResultSet dmdbResultSet, int n2, Reader reader) {
        try {
            filterChain.ResultSet_updateNClob(dmdbResultSet, n2, reader);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbResultSet.connection, sQLException);
        }
    }

    @Override
    public void ResultSet_updateNClob(FilterChain filterChain, DmdbResultSet dmdbResultSet, String string, Reader reader) {
        try {
            filterChain.ResultSet_updateNClob(dmdbResultSet, string, reader);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbResultSet.connection, sQLException);
        }
    }

    @Override
    public Object ResultSet_getObject(FilterChain filterChain, DmdbResultSet dmdbResultSet, int n2, Class clazz) {
        try {
            return filterChain.ResultSet_getObject(dmdbResultSet, n2, clazz);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbResultSet.connection, sQLException);
            return null;
        }
    }

    @Override
    public Object ResultSet_getObject(FilterChain filterChain, DmdbResultSet dmdbResultSet, String string, Class clazz) {
        try {
            return filterChain.ResultSet_getObject(dmdbResultSet, string, clazz);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbResultSet.connection, sQLException);
            return null;
        }
    }

    @Override
    public void ResultSet_updateObject(FilterChain filterChain, DmdbResultSet dmdbResultSet, int n2, Object object, SQLType sQLType, int n3) {
        try {
            filterChain.ResultSet_updateObject(dmdbResultSet, n2, object, sQLType, n3);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbResultSet.connection, sQLException);
        }
    }

    @Override
    public void ResultSet_updateObject(FilterChain filterChain, DmdbResultSet dmdbResultSet, String string, Object object, SQLType sQLType, int n2) {
        try {
            filterChain.ResultSet_updateObject(dmdbResultSet, string, object, sQLType, n2);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbResultSet.connection, sQLException);
        }
    }

    @Override
    public void ResultSet_updateObject(FilterChain filterChain, DmdbResultSet dmdbResultSet, int n2, Object object, SQLType sQLType) {
        try {
            filterChain.ResultSet_updateObject(dmdbResultSet, n2, object, sQLType);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbResultSet.connection, sQLException);
        }
    }

    @Override
    public void ResultSet_updateObject(FilterChain filterChain, DmdbResultSet dmdbResultSet, String string, Object object, SQLType sQLType) {
        try {
            filterChain.ResultSet_updateObject(dmdbResultSet, string, object, sQLType);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbResultSet.connection, sQLException);
        }
    }

    @Override
    public int ResultSetMetaData_getColumnCount(FilterChain filterChain, DmdbResultSetMetaData dmdbResultSetMetaData) {
        try {
            return filterChain.ResultSetMetaData_getColumnCount(dmdbResultSetMetaData);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbResultSetMetaData.connection, sQLException);
            return 0;
        }
    }

    @Override
    public boolean ResultSetMetaData_isAutoIncrement(FilterChain filterChain, DmdbResultSetMetaData dmdbResultSetMetaData, int n2) {
        try {
            return filterChain.ResultSetMetaData_isAutoIncrement(dmdbResultSetMetaData, n2);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbResultSetMetaData.connection, sQLException);
            return false;
        }
    }

    @Override
    public boolean ResultSetMetaData_isCaseSensitive(FilterChain filterChain, DmdbResultSetMetaData dmdbResultSetMetaData, int n2) {
        try {
            return filterChain.ResultSetMetaData_isCaseSensitive(dmdbResultSetMetaData, n2);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbResultSetMetaData.connection, sQLException);
            return false;
        }
    }

    @Override
    public boolean ResultSetMetaData_isSearchable(FilterChain filterChain, DmdbResultSetMetaData dmdbResultSetMetaData, int n2) {
        try {
            return filterChain.ResultSetMetaData_isSearchable(dmdbResultSetMetaData, n2);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbResultSetMetaData.connection, sQLException);
            return false;
        }
    }

    @Override
    public boolean ResultSetMetaData_isCurrency(FilterChain filterChain, DmdbResultSetMetaData dmdbResultSetMetaData, int n2) {
        try {
            return filterChain.ResultSetMetaData_isCurrency(dmdbResultSetMetaData, n2);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbResultSetMetaData.connection, sQLException);
            return false;
        }
    }

    @Override
    public int ResultSetMetaData_isNullable(FilterChain filterChain, DmdbResultSetMetaData dmdbResultSetMetaData, int n2) {
        try {
            return filterChain.ResultSetMetaData_isNullable(dmdbResultSetMetaData, n2);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbResultSetMetaData.connection, sQLException);
            return 0;
        }
    }

    @Override
    public boolean ResultSetMetaData_isSigned(FilterChain filterChain, DmdbResultSetMetaData dmdbResultSetMetaData, int n2) {
        try {
            return filterChain.ResultSetMetaData_isSigned(dmdbResultSetMetaData, n2);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbResultSetMetaData.connection, sQLException);
            return false;
        }
    }

    @Override
    public int ResultSetMetaData_getColumnDisplaySize(FilterChain filterChain, DmdbResultSetMetaData dmdbResultSetMetaData, int n2) {
        try {
            return filterChain.ResultSetMetaData_getColumnDisplaySize(dmdbResultSetMetaData, n2);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbResultSetMetaData.connection, sQLException);
            return 0;
        }
    }

    @Override
    public String ResultSetMetaData_getColumnLabel(FilterChain filterChain, DmdbResultSetMetaData dmdbResultSetMetaData, int n2) {
        try {
            return filterChain.ResultSetMetaData_getColumnLabel(dmdbResultSetMetaData, n2);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbResultSetMetaData.connection, sQLException);
            return null;
        }
    }

    @Override
    public String ResultSetMetaData_getColumnName(FilterChain filterChain, DmdbResultSetMetaData dmdbResultSetMetaData, int n2) {
        try {
            return filterChain.ResultSetMetaData_getColumnName(dmdbResultSetMetaData, n2);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbResultSetMetaData.connection, sQLException);
            return null;
        }
    }

    @Override
    public String ResultSetMetaData_getSchemaName(FilterChain filterChain, DmdbResultSetMetaData dmdbResultSetMetaData, int n2) {
        try {
            return filterChain.ResultSetMetaData_getSchemaName(dmdbResultSetMetaData, n2);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbResultSetMetaData.connection, sQLException);
            return null;
        }
    }

    @Override
    public int ResultSetMetaData_getPrecision(FilterChain filterChain, DmdbResultSetMetaData dmdbResultSetMetaData, int n2) {
        try {
            return filterChain.ResultSetMetaData_getPrecision(dmdbResultSetMetaData, n2);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbResultSetMetaData.connection, sQLException);
            return 0;
        }
    }

    @Override
    public int ResultSetMetaData_getScale(FilterChain filterChain, DmdbResultSetMetaData dmdbResultSetMetaData, int n2) {
        try {
            return filterChain.ResultSetMetaData_getScale(dmdbResultSetMetaData, n2);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbResultSetMetaData.connection, sQLException);
            return 0;
        }
    }

    @Override
    public String ResultSetMetaData_getTableName(FilterChain filterChain, DmdbResultSetMetaData dmdbResultSetMetaData, int n2) {
        try {
            return filterChain.ResultSetMetaData_getTableName(dmdbResultSetMetaData, n2);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbResultSetMetaData.connection, sQLException);
            return null;
        }
    }

    @Override
    public String ResultSetMetaData_getCatalogName(FilterChain filterChain, DmdbResultSetMetaData dmdbResultSetMetaData, int n2) {
        try {
            return filterChain.ResultSetMetaData_getCatalogName(dmdbResultSetMetaData, n2);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbResultSetMetaData.connection, sQLException);
            return null;
        }
    }

    @Override
    public int ResultSetMetaData_getColumnType(FilterChain filterChain, DmdbResultSetMetaData dmdbResultSetMetaData, int n2) {
        try {
            return filterChain.ResultSetMetaData_getColumnType(dmdbResultSetMetaData, n2);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbResultSetMetaData.connection, sQLException);
            return 0;
        }
    }

    @Override
    public String ResultSetMetaData_getColumnTypeName(FilterChain filterChain, DmdbResultSetMetaData dmdbResultSetMetaData, int n2) {
        try {
            return filterChain.ResultSetMetaData_getColumnTypeName(dmdbResultSetMetaData, n2);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbResultSetMetaData.connection, sQLException);
            return null;
        }
    }

    @Override
    public boolean ResultSetMetaData_isReadOnly(FilterChain filterChain, DmdbResultSetMetaData dmdbResultSetMetaData, int n2) {
        try {
            return filterChain.ResultSetMetaData_isReadOnly(dmdbResultSetMetaData, n2);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbResultSetMetaData.connection, sQLException);
            return false;
        }
    }

    @Override
    public boolean ResultSetMetaData_isWritable(FilterChain filterChain, DmdbResultSetMetaData dmdbResultSetMetaData, int n2) {
        try {
            return filterChain.ResultSetMetaData_isWritable(dmdbResultSetMetaData, n2);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbResultSetMetaData.connection, sQLException);
            return false;
        }
    }

    @Override
    public boolean ResultSetMetaData_isDefinitelyWritable(FilterChain filterChain, DmdbResultSetMetaData dmdbResultSetMetaData, int n2) {
        try {
            return filterChain.ResultSetMetaData_isDefinitelyWritable(dmdbResultSetMetaData, n2);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbResultSetMetaData.connection, sQLException);
            return false;
        }
    }

    @Override
    public String ResultSetMetaData_getColumnClassName(FilterChain filterChain, DmdbResultSetMetaData dmdbResultSetMetaData, int n2) {
        try {
            return filterChain.ResultSetMetaData_getColumnClassName(dmdbResultSetMetaData, n2);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbResultSetMetaData.connection, sQLException);
            return null;
        }
    }

    @Override
    public ResultSet Statement_executeQuery(FilterChain filterChain, DmdbStatement dmdbStatement, String string) {
        try {
            this.beforeExecute(dmdbStatement.connection);
            return filterChain.Statement_executeQuery(dmdbStatement, string);
        }
        catch (SQLException sQLException) {
            if (this.whenError(dmdbStatement.connection, sQLException)) {
                return dmdbStatement.do_executeQuery(string);
            }
            return null;
        }
    }

    @Override
    public int Statement_executeUpdate(FilterChain filterChain, DmdbStatement dmdbStatement, String string) {
        try {
            this.beforeExecute(dmdbStatement.connection);
            return filterChain.Statement_executeUpdate(dmdbStatement, string);
        }
        catch (SQLException sQLException) {
            if (this.whenError(dmdbStatement.connection, sQLException)) {
                return dmdbStatement.do_executeUpdate(string);
            }
            return 0;
        }
    }

    @Override
    public void Statement_close(FilterChain filterChain, DmdbStatement dmdbStatement) {
        try {
            filterChain.Statement_close(dmdbStatement);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbStatement.connection, sQLException);
        }
    }

    @Override
    public int Statement_getMaxFieldSize(FilterChain filterChain, DmdbStatement dmdbStatement) {
        try {
            return filterChain.Statement_getMaxFieldSize(dmdbStatement);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbStatement.connection, sQLException);
            return 0;
        }
    }

    @Override
    public void Statement_setMaxFieldSize(FilterChain filterChain, DmdbStatement dmdbStatement, int n2) {
        try {
            filterChain.Statement_setMaxFieldSize(dmdbStatement, n2);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbStatement.connection, sQLException);
        }
    }

    @Override
    public int Statement_getMaxRows(FilterChain filterChain, DmdbStatement dmdbStatement) {
        try {
            return filterChain.Statement_getMaxRows(dmdbStatement);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbStatement.connection, sQLException);
            return 0;
        }
    }

    @Override
    public void Statement_setMaxRows(FilterChain filterChain, DmdbStatement dmdbStatement, int n2) {
        try {
            filterChain.Statement_setMaxRows(dmdbStatement, n2);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbStatement.connection, sQLException);
        }
    }

    @Override
    public void Statement_setEscapeProcessing(FilterChain filterChain, DmdbStatement dmdbStatement, boolean bl) {
        try {
            filterChain.Statement_setEscapeProcessing(dmdbStatement, bl);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbStatement.connection, sQLException);
        }
    }

    @Override
    public int Statement_getQueryTimeout(FilterChain filterChain, DmdbStatement dmdbStatement) {
        try {
            return filterChain.Statement_getQueryTimeout(dmdbStatement);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbStatement.connection, sQLException);
            return 0;
        }
    }

    @Override
    public void Statement_setQueryTimeout(FilterChain filterChain, DmdbStatement dmdbStatement, int n2) {
        try {
            filterChain.Statement_setQueryTimeout(dmdbStatement, n2);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbStatement.connection, sQLException);
        }
    }

    @Override
    public void Statement_cancel(FilterChain filterChain, DmdbStatement dmdbStatement) {
        try {
            filterChain.Statement_cancel(dmdbStatement);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbStatement.connection, sQLException);
        }
    }

    @Override
    public SQLWarning Statement_getWarnings(FilterChain filterChain, DmdbStatement dmdbStatement) {
        try {
            return filterChain.Statement_getWarnings(dmdbStatement);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbStatement.connection, sQLException);
            return null;
        }
    }

    @Override
    public void Statement_clearWarnings(FilterChain filterChain, DmdbStatement dmdbStatement) {
        try {
            filterChain.Statement_clearWarnings(dmdbStatement);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbStatement.connection, sQLException);
        }
    }

    @Override
    public void Statement_setCursorName(FilterChain filterChain, DmdbStatement dmdbStatement, String string) {
        try {
            filterChain.Statement_setCursorName(dmdbStatement, string);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbStatement.connection, sQLException);
        }
    }

    @Override
    public boolean Statement_execute(FilterChain filterChain, DmdbStatement dmdbStatement, String string) {
        try {
            this.beforeExecute(dmdbStatement.connection);
            return filterChain.Statement_execute(dmdbStatement, string);
        }
        catch (SQLException sQLException) {
            if (this.whenError(dmdbStatement.connection, sQLException)) {
                return dmdbStatement.do_execute(string);
            }
            return false;
        }
    }

    @Override
    public ResultSet Statement_getResultSet(FilterChain filterChain, DmdbStatement dmdbStatement) {
        try {
            return filterChain.Statement_getResultSet(dmdbStatement);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbStatement.connection, sQLException);
            return null;
        }
    }

    @Override
    public int Statement_getUpdateCount(FilterChain filterChain, DmdbStatement dmdbStatement) {
        try {
            return filterChain.Statement_getUpdateCount(dmdbStatement);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbStatement.connection, sQLException);
            return 0;
        }
    }

    @Override
    public boolean Statement_getMoreResults(FilterChain filterChain, DmdbStatement dmdbStatement) {
        try {
            return filterChain.Statement_getMoreResults(dmdbStatement);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbStatement.connection, sQLException);
            return false;
        }
    }

    @Override
    public void Statement_setFetchDirection(FilterChain filterChain, DmdbStatement dmdbStatement, int n2) {
        try {
            filterChain.Statement_setFetchDirection(dmdbStatement, n2);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbStatement.connection, sQLException);
        }
    }

    @Override
    public int Statement_getFetchDirection(FilterChain filterChain, DmdbStatement dmdbStatement) {
        try {
            return filterChain.Statement_getFetchDirection(dmdbStatement);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbStatement.connection, sQLException);
            return 0;
        }
    }

    @Override
    public void Statement_setFetchSize(FilterChain filterChain, DmdbStatement dmdbStatement, int n2) {
        try {
            filterChain.Statement_setFetchSize(dmdbStatement, n2);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbStatement.connection, sQLException);
        }
    }

    @Override
    public int Statement_getFetchSize(FilterChain filterChain, DmdbStatement dmdbStatement) {
        try {
            return filterChain.Statement_getFetchSize(dmdbStatement);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbStatement.connection, sQLException);
            return 0;
        }
    }

    @Override
    public int Statement_getResultSetConcurrency(FilterChain filterChain, DmdbStatement dmdbStatement) {
        try {
            return filterChain.Statement_getResultSetConcurrency(dmdbStatement);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbStatement.connection, sQLException);
            return 0;
        }
    }

    @Override
    public int Statement_getResultSetType(FilterChain filterChain, DmdbStatement dmdbStatement) {
        try {
            return filterChain.Statement_getResultSetType(dmdbStatement);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbStatement.connection, sQLException);
            return 0;
        }
    }

    @Override
    public void Statement_addBatch(FilterChain filterChain, DmdbStatement dmdbStatement, String string) {
        try {
            filterChain.Statement_addBatch(dmdbStatement, string);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbStatement.connection, sQLException);
        }
    }

    @Override
    public void Statement_clearBatch(FilterChain filterChain, DmdbStatement dmdbStatement) {
        try {
            filterChain.Statement_clearBatch(dmdbStatement);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbStatement.connection, sQLException);
        }
    }

    @Override
    public int[] Statement_executeBatch(FilterChain filterChain, DmdbStatement dmdbStatement) {
        try {
            this.beforeExecute(dmdbStatement.connection);
            dmdbStatement.clearBatch = false;
            int[] nArray = filterChain.Statement_executeBatch(dmdbStatement);
            return nArray;
        }
        catch (SQLException sQLException) {
            if (this.whenError(dmdbStatement.connection, sQLException)) {
                int[] nArray = dmdbStatement.do_executeBatch();
                return nArray;
            }
            return null;
        }
        finally {
            dmdbStatement.clearBatch = true;
            dmdbStatement.do_clearBatch();
        }
    }

    @Override
    public Connection Statement_getConnection(FilterChain filterChain, DmdbStatement dmdbStatement) {
        try {
            return filterChain.Statement_getConnection(dmdbStatement);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbStatement.connection, sQLException);
            return null;
        }
    }

    @Override
    public boolean Statement_getMoreResults(FilterChain filterChain, DmdbStatement dmdbStatement, int n2) {
        try {
            return filterChain.Statement_getMoreResults(dmdbStatement, n2);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbStatement.connection, sQLException);
            return false;
        }
    }

    @Override
    public ResultSet Statement_getGeneratedKeys(FilterChain filterChain, DmdbStatement dmdbStatement) {
        try {
            return filterChain.Statement_getGeneratedKeys(dmdbStatement);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbStatement.connection, sQLException);
            return null;
        }
    }

    @Override
    public int Statement_executeUpdate(FilterChain filterChain, DmdbStatement dmdbStatement, String string, int n2) {
        try {
            this.beforeExecute(dmdbStatement.connection);
            return filterChain.Statement_executeUpdate(dmdbStatement, string, n2);
        }
        catch (SQLException sQLException) {
            if (this.whenError(dmdbStatement.connection, sQLException)) {
                return dmdbStatement.do_executeUpdate(string, n2);
            }
            return 0;
        }
    }

    @Override
    public int Statement_executeUpdate(FilterChain filterChain, DmdbStatement dmdbStatement, String string, int[] nArray) {
        try {
            this.beforeExecute(dmdbStatement.connection);
            return filterChain.Statement_executeUpdate(dmdbStatement, string, nArray);
        }
        catch (SQLException sQLException) {
            if (this.whenError(dmdbStatement.connection, sQLException)) {
                return dmdbStatement.do_executeUpdate(string, nArray);
            }
            return 0;
        }
    }

    @Override
    public int Statement_executeUpdate(FilterChain filterChain, DmdbStatement dmdbStatement, String string, String[] stringArray) {
        try {
            this.beforeExecute(dmdbStatement.connection);
            return filterChain.Statement_executeUpdate(dmdbStatement, string, stringArray);
        }
        catch (SQLException sQLException) {
            if (this.whenError(dmdbStatement.connection, sQLException)) {
                return dmdbStatement.do_executeUpdate(string, stringArray);
            }
            return 0;
        }
    }

    @Override
    public boolean Statement_execute(FilterChain filterChain, DmdbStatement dmdbStatement, String string, int n2) {
        try {
            this.beforeExecute(dmdbStatement.connection);
            return filterChain.Statement_execute(dmdbStatement, string, n2);
        }
        catch (SQLException sQLException) {
            if (this.whenError(dmdbStatement.connection, sQLException)) {
                return dmdbStatement.do_execute(string, n2);
            }
            return false;
        }
    }

    @Override
    public boolean Statement_execute(FilterChain filterChain, DmdbStatement dmdbStatement, String string, int[] nArray) {
        try {
            this.beforeExecute(dmdbStatement.connection);
            return filterChain.Statement_execute(dmdbStatement, string, nArray);
        }
        catch (SQLException sQLException) {
            if (this.whenError(dmdbStatement.connection, sQLException)) {
                return dmdbStatement.do_execute(string, nArray);
            }
            return false;
        }
    }

    @Override
    public boolean Statement_execute(FilterChain filterChain, DmdbStatement dmdbStatement, String string, String[] stringArray) {
        try {
            this.beforeExecute(dmdbStatement.connection);
            return filterChain.Statement_execute(dmdbStatement, string, stringArray);
        }
        catch (SQLException sQLException) {
            if (this.whenError(dmdbStatement.connection, sQLException)) {
                return dmdbStatement.do_execute(string, stringArray);
            }
            return false;
        }
    }

    @Override
    public int Statement_getResultSetHoldability(FilterChain filterChain, DmdbStatement dmdbStatement) {
        try {
            return filterChain.Statement_getResultSetHoldability(dmdbStatement);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbStatement.connection, sQLException);
            return 0;
        }
    }

    @Override
    public boolean Statement_isClosed(FilterChain filterChain, DmdbStatement dmdbStatement) {
        try {
            return filterChain.Statement_isClosed(dmdbStatement);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbStatement.connection, sQLException);
            return false;
        }
    }

    @Override
    public void Statement_setPoolable(FilterChain filterChain, DmdbStatement dmdbStatement, boolean bl) {
        try {
            filterChain.Statement_setPoolable(dmdbStatement, bl);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbStatement.connection, sQLException);
        }
    }

    @Override
    public boolean Statement_isPoolable(FilterChain filterChain, DmdbStatement dmdbStatement) {
        try {
            return filterChain.Statement_isPoolable(dmdbStatement);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbStatement.connection, sQLException);
            return false;
        }
    }

    @Override
    public void Statement_closeOnCompletion(FilterChain filterChain, DmdbStatement dmdbStatement) {
        try {
            filterChain.Statement_closeOnCompletion(dmdbStatement);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbStatement.connection, sQLException);
        }
    }

    @Override
    public boolean Statement_isCloseOnCompletion(FilterChain filterChain, DmdbStatement dmdbStatement) {
        try {
            return filterChain.Statement_isCloseOnCompletion(dmdbStatement);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbStatement.connection, sQLException);
            return false;
        }
    }

    @Override
    public long Statement_getLargeUpdateCount(FilterChain filterChain, DmdbStatement dmdbStatement) {
        try {
            return filterChain.Statement_getLargeUpdateCount(dmdbStatement);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbStatement.connection, sQLException);
            return 0L;
        }
    }

    @Override
    public void Statement_setLargeMaxRows(FilterChain filterChain, DmdbStatement dmdbStatement, long l2) {
        try {
            filterChain.Statement_setLargeMaxRows(dmdbStatement, l2);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbStatement.connection, sQLException);
        }
    }

    @Override
    public long Statement_getLargeMaxRows(FilterChain filterChain, DmdbStatement dmdbStatement) {
        try {
            return filterChain.Statement_getLargeMaxRows(dmdbStatement);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbStatement.connection, sQLException);
            return 0L;
        }
    }

    @Override
    public long[] Statement_executeLargeBatch(FilterChain filterChain, DmdbStatement dmdbStatement) {
        try {
            this.beforeExecute(dmdbStatement.connection);
            dmdbStatement.clearBatch = false;
            long[] lArray = filterChain.Statement_executeLargeBatch(dmdbStatement);
            return lArray;
        }
        catch (SQLException sQLException) {
            if (this.whenError(dmdbStatement.connection, sQLException)) {
                long[] lArray = dmdbStatement.do_executeLargeBatch();
                return lArray;
            }
            return null;
        }
        finally {
            dmdbStatement.clearBatch = true;
            dmdbStatement.do_clearBatch();
        }
    }

    @Override
    public long Statement_executeLargeUpdate(FilterChain filterChain, DmdbStatement dmdbStatement, String string) {
        try {
            this.beforeExecute(dmdbStatement.connection);
            return filterChain.Statement_executeLargeUpdate(dmdbStatement, string);
        }
        catch (SQLException sQLException) {
            if (this.whenError(dmdbStatement.connection, sQLException)) {
                return dmdbStatement.do_executeLargeUpdate(string);
            }
            return 0L;
        }
    }

    @Override
    public long Statement_executeLargeUpdate(FilterChain filterChain, DmdbStatement dmdbStatement, String string, int n2) {
        try {
            this.beforeExecute(dmdbStatement.connection);
            return filterChain.Statement_executeLargeUpdate(dmdbStatement, string, n2);
        }
        catch (SQLException sQLException) {
            if (this.whenError(dmdbStatement.connection, sQLException)) {
                return dmdbStatement.do_executeLargeUpdate(string, n2);
            }
            return 0L;
        }
    }

    @Override
    public long Statement_executeLargeUpdate(FilterChain filterChain, DmdbStatement dmdbStatement, String string, int[] nArray) {
        try {
            this.beforeExecute(dmdbStatement.connection);
            return filterChain.Statement_executeLargeUpdate(dmdbStatement, string, nArray);
        }
        catch (SQLException sQLException) {
            if (this.whenError(dmdbStatement.connection, sQLException)) {
                return dmdbStatement.do_executeLargeUpdate(string, nArray);
            }
            return 0L;
        }
    }

    @Override
    public long Statement_executeLargeUpdate(FilterChain filterChain, DmdbStatement dmdbStatement, String string, String[] stringArray) {
        try {
            this.beforeExecute(dmdbStatement.connection);
            return filterChain.Statement_executeLargeUpdate(dmdbStatement, string, stringArray);
        }
        catch (SQLException sQLException) {
            if (this.whenError(dmdbStatement.connection, sQLException)) {
                return dmdbStatement.do_executeLargeUpdate(string, stringArray);
            }
            return 0L;
        }
    }

    @Override
    public long Statement_getExecuteId(FilterChain filterChain, DmdbStatement dmdbStatement) {
        try {
            return filterChain.Statement_getExecuteId(dmdbStatement);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbStatement.connection, sQLException);
            return 0L;
        }
    }

    @Override
    public String Statement_getPrintMsg(FilterChain filterChain, DmdbStatement dmdbStatement) {
        try {
            return filterChain.Statement_getPrintMsg(dmdbStatement);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbStatement.connection, sQLException);
            return null;
        }
    }

    @Override
    public int Statement_getSqlType(FilterChain filterChain, DmdbStatement dmdbStatement) {
        try {
            return filterChain.Statement_getSqlType(dmdbStatement);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbStatement.connection, sQLException);
            return 0;
        }
    }

    @Override
    public RowId Statement_getRowId(FilterChain filterChain, DmdbStatement dmdbStatement) {
        try {
            return filterChain.Statement_getRowId(dmdbStatement);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbStatement.connection, sQLException);
            return null;
        }
    }

    @Override
    public ResultSet[] Statement_getResultSets(FilterChain filterChain, DmdbStatement dmdbStatement) {
        try {
            return filterChain.Statement_getResultSets(dmdbStatement);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbStatement.connection, sQLException);
            return null;
        }
    }

    @Override
    public DmdbIntervalYM CallableStatement_getINTERVALYM(FilterChain filterChain, DmdbCallableStatement dmdbCallableStatement, int n2) {
        try {
            return filterChain.CallableStatement_getINTERVALYM(dmdbCallableStatement, n2);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbCallableStatement.connection, sQLException);
            return null;
        }
    }

    @Override
    public DmdbIntervalDT CallableStatement_getINTERVALDT(FilterChain filterChain, DmdbCallableStatement dmdbCallableStatement, int n2) {
        try {
            return filterChain.CallableStatement_getINTERVALDT(dmdbCallableStatement, n2);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbCallableStatement.connection, sQLException);
            return null;
        }
    }

    @Override
    public DmdbTimestamp CallableStatement_getTIMESTAMP(FilterChain filterChain, DmdbCallableStatement dmdbCallableStatement, int n2) {
        try {
            return filterChain.CallableStatement_getTIMESTAMP(dmdbCallableStatement, n2);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbCallableStatement.connection, sQLException);
            return null;
        }
    }

    @Override
    public ResultSet CallableStatement_getCursor(FilterChain filterChain, DmdbCallableStatement dmdbCallableStatement, int n2) {
        try {
            return filterChain.CallableStatement_getCursor(dmdbCallableStatement, n2);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbCallableStatement.connection, sQLException);
            return null;
        }
    }

    @Override
    public void Connection_reset(FilterChain filterChain, DmdbConnection dmdbConnection) {
        try {
            filterChain.Connection_reset(dmdbConnection);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbConnection, sQLException);
        }
    }

    @Override
    public String Statement_getExplain(FilterChain filterChain, DmdbStatement dmdbStatement) {
        return filterChain.Statement_getExplain(dmdbStatement);
    }

    @Override
    public ResultSet CallableStatement_getCursor(FilterChain filterChain, DmdbCallableStatement dmdbCallableStatement, String string) {
        try {
            return filterChain.CallableStatement_getCursor(dmdbCallableStatement, string);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbCallableStatement.connection, sQLException);
            return null;
        }
    }

    @Override
    public void CallableStatement_setINTERVALDT(FilterChain filterChain, DmdbCallableStatement dmdbCallableStatement, String string, DmdbIntervalDT dmdbIntervalDT) {
        try {
            filterChain.CallableStatement_setINTERVALDT(dmdbCallableStatement, string, dmdbIntervalDT);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbCallableStatement.connection, sQLException);
        }
    }

    @Override
    public void CallableStatement_setINTERVALYM(FilterChain filterChain, DmdbCallableStatement dmdbCallableStatement, String string, DmdbIntervalYM dmdbIntervalYM) {
        try {
            filterChain.CallableStatement_setINTERVALYM(dmdbCallableStatement, string, dmdbIntervalYM);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbCallableStatement.connection, sQLException);
        }
    }

    @Override
    public void CallableStatement_setTIMESTAMP(FilterChain filterChain, DmdbCallableStatement dmdbCallableStatement, String string, DmdbTimestamp dmdbTimestamp) {
        try {
            filterChain.CallableStatement_setTIMESTAMP(dmdbCallableStatement, string, dmdbTimestamp);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbCallableStatement.connection, sQLException);
        }
    }

    @Override
    public DmdbTimestamp CallableStatement_getTIMESTAMP(FilterChain filterChain, DmdbCallableStatement dmdbCallableStatement, String string) {
        try {
            return filterChain.CallableStatement_getTIMESTAMP(dmdbCallableStatement, string);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbCallableStatement.connection, sQLException);
            return null;
        }
    }

    @Override
    public DmdbIntervalDT CallableStatement_getINTERVALDT(FilterChain filterChain, DmdbCallableStatement dmdbCallableStatement, String string) {
        try {
            return filterChain.CallableStatement_getINTERVALDT(dmdbCallableStatement, string);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbCallableStatement.connection, sQLException);
            return null;
        }
    }

    @Override
    public DmdbIntervalYM CallableStatement_getINTERVALYM(FilterChain filterChain, DmdbCallableStatement dmdbCallableStatement, String string) {
        try {
            return filterChain.CallableStatement_getINTERVALYM(dmdbCallableStatement, string);
        }
        catch (SQLException sQLException) {
            this.whenError(dmdbCallableStatement.connection, sQLException);
            return null;
        }
    }

    /* synthetic */ ReconnectFilter(ReconnectFilter reconnectFilter) {
        this();
    }
}

