/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.common.utils;

import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONReader;
import com.ruoyi.common.core.domain.entity.SysDictData;
import com.ruoyi.common.core.redis.RedisCache;
import com.ruoyi.common.utils.StringUtils;
import com.ruoyi.common.utils.spring.SpringUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DictUtils {
    public static final String SEPARATOR = ",";

    public static void setDictCache(String key, List<SysDictData> dictDatas) {
        SpringUtils.getBean(RedisCache.class).setCacheObject(DictUtils.getCacheKey(key), dictDatas);
    }

    public static List<SysDictData> getDictCache(String key) {
        JSONArray arrayCache = (JSONArray)SpringUtils.getBean(RedisCache.class).getCacheObject(DictUtils.getCacheKey(key));
        if (StringUtils.isNotNull(arrayCache)) {
            return arrayCache.toList(SysDictData.class, new JSONReader.Feature[0]);
        }
        return null;
    }

    public static String getDictLabel(String dictType, String dictValue) {
        if (StringUtils.isEmpty(dictValue)) {
            return "";
        }
        return DictUtils.getDictLabel(dictType, dictValue, SEPARATOR);
    }

    public static String getDictValue(String dictType, String dictLabel) {
        if (StringUtils.isEmpty(dictLabel)) {
            return "";
        }
        return DictUtils.getDictValue(dictType, dictLabel, SEPARATOR);
    }

    public static String getDictLabel(String dictType, String dictValue, String separator) {
        List<SysDictData> datas = DictUtils.getDictCache(dictType);
        if (StringUtils.isNull(datas) || StringUtils.isEmpty(dictValue)) {
            return "";
        }
        Map dictMap = datas.stream().collect(HashMap::new, (map, dict) -> map.put(dict.getDictValue(), dict.getDictLabel()), Map::putAll);
        if (!StringUtils.contains((CharSequence)dictValue, (CharSequence)separator)) {
            return dictMap.getOrDefault(dictValue, "");
        }
        StringBuilder labelBuilder = new StringBuilder();
        for (String seperatedValue : dictValue.split(separator)) {
            if (!dictMap.containsKey(seperatedValue)) continue;
            labelBuilder.append((String)dictMap.get(seperatedValue)).append(separator);
        }
        return StringUtils.removeEnd((String)labelBuilder.toString(), (String)separator);
    }

    public static String getDictValue(String dictType, String dictLabel, String separator) {
        List<SysDictData> datas = DictUtils.getDictCache(dictType);
        if (StringUtils.isNull(datas) || StringUtils.isEmpty(dictLabel)) {
            return "";
        }
        Map dictMap = datas.stream().collect(HashMap::new, (map, dict) -> map.put(dict.getDictLabel(), dict.getDictValue()), Map::putAll);
        if (!StringUtils.contains((CharSequence)dictLabel, (CharSequence)separator)) {
            return dictMap.getOrDefault(dictLabel, "");
        }
        StringBuilder valueBuilder = new StringBuilder();
        for (String seperatedValue : dictLabel.split(separator)) {
            if (!dictMap.containsKey(seperatedValue)) continue;
            valueBuilder.append((String)dictMap.get(seperatedValue)).append(separator);
        }
        return StringUtils.removeEnd((String)valueBuilder.toString(), (String)separator);
    }

    public static String getDictValues(String dictType) {
        StringBuilder propertyString = new StringBuilder();
        List<SysDictData> datas = DictUtils.getDictCache(dictType);
        if (StringUtils.isNull(datas)) {
            return "";
        }
        for (SysDictData dict : datas) {
            propertyString.append(dict.getDictValue()).append(SEPARATOR);
        }
        return StringUtils.stripEnd((String)propertyString.toString(), (String)SEPARATOR);
    }

    public static String getDictLabels(String dictType) {
        StringBuilder propertyString = new StringBuilder();
        List<SysDictData> datas = DictUtils.getDictCache(dictType);
        if (StringUtils.isNull(datas)) {
            return "";
        }
        for (SysDictData dict : datas) {
            propertyString.append(dict.getDictLabel()).append(SEPARATOR);
        }
        return StringUtils.stripEnd((String)propertyString.toString(), (String)SEPARATOR);
    }

    public static void removeDictCache(String key) {
        SpringUtils.getBean(RedisCache.class).deleteObject(DictUtils.getCacheKey(key));
    }

    public static void clearDictCache() {
        Collection<String> keys = SpringUtils.getBean(RedisCache.class).keys("sys_dict:*");
        SpringUtils.getBean(RedisCache.class).deleteObject(keys);
    }

    public static String getCacheKey(String configKey) {
        return "sys_dict:" + configKey;
    }
}

