/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.parser;

import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLName;
import com.alibaba.druid.sql.ast.SQLPartitionBy;
import com.alibaba.druid.sql.ast.SQLPartitionOf;
import com.alibaba.druid.sql.ast.statement.SQLColumnDefinition;
import com.alibaba.druid.sql.ast.statement.SQLConstraint;
import com.alibaba.druid.sql.ast.statement.SQLCreateTableStatement;
import com.alibaba.druid.sql.ast.statement.SQLExprTableSource;
import com.alibaba.druid.sql.ast.statement.SQLSelect;
import com.alibaba.druid.sql.ast.statement.SQLTableElement;
import com.alibaba.druid.sql.ast.statement.SQLTableLike;
import com.alibaba.druid.sql.parser.DialectFeature;
import com.alibaba.druid.sql.parser.Lexer;
import com.alibaba.druid.sql.parser.ParserException;
import com.alibaba.druid.sql.parser.SQLDDLParser;
import com.alibaba.druid.sql.parser.SQLExprParser;
import com.alibaba.druid.sql.parser.SQLParserFeature;
import com.alibaba.druid.sql.parser.Token;
import com.alibaba.druid.sql.template.SQLSelectQueryTemplate;
import com.alibaba.druid.util.FnvHash;
import java.util.List;

public class SQLCreateTableParser
extends SQLDDLParser {
    public SQLCreateTableParser(String sql) {
        super(sql);
    }

    public SQLCreateTableParser(SQLExprParser exprParser) {
        super(exprParser);
        this.dbType = exprParser.dbType;
    }

    @Override
    public SQLCreateTableStatement parseCreateTable() {
        List<String> comments = null;
        if (this.lexer.isKeepComments() && this.lexer.hasComment()) {
            comments = this.lexer.readAndResetComments();
        }
        SQLCreateTableStatement createTable = this.newCreateStatement();
        if (comments != null) {
            createTable.addBeforeComment(comments);
        }
        createTable.setDbType(this.dbType);
        if (this.lexer.hasComment() && this.lexer.isKeepComments()) {
            createTable.addBeforeComment(this.lexer.readAndResetComments());
        }
        this.accept(Token.CREATE);
        this.createTableBefore(createTable);
        if (this.lexer.token == Token.TABLE || this.lexer.identifierEquals(FnvHash.Constants.TABLE)) {
            this.lexer.nextToken();
        } else {
            this.setErrorEndPos(this.lexer.pos());
            this.printError(this.lexer.token);
        }
        this.createTableBeforeName(createTable);
        createTable.setName(this.exprParser.name());
        this.createTableAfterName(createTable);
        this.createTableBody(createTable);
        this.parseCreateTableRest(createTable);
        this.createTableQuery(createTable);
        return createTable;
    }

    protected SQLSelect createTableQueryRest() {
        return this.createSQLSelectParser().select();
    }

    protected void createTableQuery(SQLCreateTableStatement createTable) {
        if (this.lexer.nextIf(Token.AS)) {
            SQLSelect select;
            if ((this.lexer.token == Token.IDENTIFIER || this.lexer.token == Token.VARIANT) && this.lexer.isEnabled(SQLParserFeature.Template) && this.lexer.stringVal.startsWith("$")) {
                select = new SQLSelect(new SQLSelectQueryTemplate(this.lexer.stringVal));
                this.lexer.nextToken();
            } else {
                select = this.createTableQueryRest();
            }
            createTable.setSelect(select);
        }
    }

    protected void createTableBody(SQLCreateTableStatement createTable) {
        if (this.lexer.nextIf(Token.LPAREN)) {
            do {
                this.createTableBodyItem(createTable);
            } while (this.lexer.nextIf(Token.COMMA) && this.lexer.token != Token.RPAREN);
            this.accept(Token.RPAREN);
            this.createTableAfter(createTable);
        }
    }

    protected void createTableBodyItem(SQLCreateTableStatement createTable) {
        Token token = this.lexer.token;
        if (this.lexer.identifierEquals(FnvHash.Constants.SUPPLEMENTAL) && this.dialectFeatureEnabled(DialectFeature.ParserFeature.CreateTableBodySupplemental)) {
            SQLTableElement element = this.parseCreateTableSupplementalLoggingProps();
            element.setParent(createTable);
            createTable.getTableElementList().add(element);
        } else if (token == Token.IDENTIFIER || token == Token.LITERAL_ALIAS) {
            SQLColumnDefinition column = this.exprParser.parseColumn(createTable);
            column.setParent(createTable);
            createTable.getTableElementList().add(column);
        } else if (token == Token.PRIMARY || token == Token.UNIQUE || token == Token.CHECK || token == Token.CONSTRAINT || token == Token.FOREIGN) {
            SQLConstraint constraint = this.exprParser.parseConstraint();
            constraint.setParent(createTable);
            createTable.getTableElementList().add((SQLTableElement)((Object)constraint));
        } else {
            if (token == Token.TABLESPACE) {
                throw new ParserException("TODO " + this.lexer.info());
            }
            if (this.lexer.token() == Token.LIKE) {
                this.lexer.nextToken();
                SQLTableLike tableLike = new SQLTableLike();
                tableLike.setTable(new SQLExprTableSource(this.exprParser.name()));
                tableLike.setParent(createTable);
                createTable.getTableElementList().add(tableLike);
                if (this.lexer.identifierEquals(FnvHash.Constants.INCLUDING)) {
                    this.lexer.nextToken();
                    if (this.lexer.nextIfIdentifier(FnvHash.Constants.PROPERTIES)) {
                        tableLike.setIncludeProperties(true);
                    } else if (this.lexer.nextIfIdentifier("DISTRIBUTION")) {
                        tableLike.setIncludeDistribution(true);
                    }
                } else if (this.lexer.identifierEquals(FnvHash.Constants.EXCLUDING)) {
                    this.lexer.nextToken();
                    if (this.lexer.nextIfIdentifier(FnvHash.Constants.PROPERTIES)) {
                        tableLike.setExcludeProperties(true);
                    } else if (this.lexer.nextIfIdentifier("DISTRIBUTION")) {
                        tableLike.setExcludeDistribution(true);
                    }
                }
            } else if (this.lexer.token() == Token.INDEX) {
                this.parseIndex(createTable);
            } else {
                SQLColumnDefinition column = this.exprParser.parseColumn();
                createTable.getTableElementList().add(column);
            }
        }
    }

    protected void parseIndex(SQLCreateTableStatement createTable) {
        SQLColumnDefinition column = this.exprParser.parseColumn();
        createTable.getTableElementList().add(column);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void createTableBefore(SQLCreateTableStatement createTable) {
        if (this.lexer.nextIfIdentifier("GLOBAL")) {
            createTable.config(SQLCreateTableStatement.Feature.Global);
            if (!this.lexer.nextIfIdentifier("TEMPORARY") && !this.lexer.nextIfIdentifier("TEMP")) throw new ParserException("syntax error " + this.lexer.info());
            createTable.config(SQLCreateTableStatement.Feature.Temporary);
        } else if (this.lexer.nextIfIdentifier("LOCAL") || this.lexer.nextIf(Token.LOCAL)) {
            createTable.config(SQLCreateTableStatement.Feature.Local);
            if (!this.lexer.nextIfIdentifier("TEMPORARY") && !this.lexer.nextIfIdentifier("TEMP")) throw new ParserException("syntax error. " + this.lexer.info());
            createTable.config(SQLCreateTableStatement.Feature.Temporary);
        }
        if (!this.lexer.nextIfIdentifier(FnvHash.Constants.DIMENSION)) return;
        createTable.config(SQLCreateTableStatement.Feature.Dimension);
    }

    protected void createTableBeforeName(SQLCreateTableStatement createTable) {
        if (this.lexer.nextIf(Token.IF) || this.lexer.nextIfIdentifier("IF")) {
            this.accept(Token.NOT);
            this.accept(Token.EXISTS);
            createTable.setIfNotExists(true);
        }
    }

    protected void createTableAfterName(SQLCreateTableStatement createTable) {
    }

    protected void createTableAfter(SQLCreateTableStatement stmt) {
        if (this.lexer.nextIfIdentifier(FnvHash.Constants.INHERITS)) {
            this.accept(Token.LPAREN);
            SQLName inherits = this.exprParser.name();
            stmt.setInherits(new SQLExprTableSource(inherits));
            this.accept(Token.RPAREN);
        }
    }

    protected void parseCreateTableRest(SQLCreateTableStatement stmt) {
        if (this.lexer.token() == Token.PARTITION) {
            Lexer.SavePoint mark = this.lexer.mark();
            this.lexer.nextToken();
            if (Token.OF.equals((Object)this.lexer.token())) {
                this.lexer.reset(mark);
                SQLPartitionOf partitionOf = this.parsePartitionOf();
                stmt.setPartitionOf(partitionOf);
            } else if (Token.BY.equals((Object)this.lexer.token())) {
                this.lexer.reset(mark);
                SQLPartitionBy partitionClause = this.parsePartitionBy();
                stmt.setPartitionBy(partitionClause);
            }
        }
        if (this.lexer.nextIf(Token.TABLESPACE)) {
            stmt.setTablespace(this.exprParser.name());
        }
    }

    public SQLPartitionBy parsePartitionBy() {
        return null;
    }

    public SQLPartitionOf parsePartitionOf() {
        return null;
    }

    protected SQLTableElement parseCreateTableSupplementalLoggingProps() {
        throw new ParserException("TODO " + this.lexer.info());
    }

    @Override
    protected SQLCreateTableStatement newCreateStatement() {
        return new SQLCreateTableStatement(this.getDbType());
    }

    protected void parseOptions(SQLCreateTableStatement stmt) {
        this.lexer.nextToken();
        this.accept(Token.LPAREN);
        do {
            String name = this.lexer.stringVal();
            this.lexer.nextToken();
            this.accept(Token.EQ);
            SQLExpr value = this.exprParser.primary();
            stmt.addOption(name, value);
            if (this.lexer.token() != Token.COMMA) break;
            this.lexer.nextToken();
        } while (this.lexer.token() != Token.RPAREN);
        this.accept(Token.RPAREN);
    }
}

