/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jsqlparser.expression;

import java.util.Objects;

public class JsonKeyValuePair {
    private final String key;
    private boolean usingKeyKeyword = false;
    private final Object value;
    private boolean usingValueKeyword = false;
    private boolean usingFormatJson = false;

    public JsonKeyValuePair(String key, Object value, boolean usingKeyKeyword, boolean usingValueKeyword) {
        this.key = Objects.requireNonNull(key, "The KEY of the Pair must not be null");
        this.value = value;
        this.usingKeyKeyword = usingKeyKeyword;
        this.usingValueKeyword = usingValueKeyword;
    }

    public boolean isUsingKeyKeyword() {
        return this.usingKeyKeyword;
    }

    public void setUsingKeyKeyword(boolean usingKeyKeyword) {
        this.usingKeyKeyword = usingKeyKeyword;
    }

    public JsonKeyValuePair withUsingKeyKeyword(boolean usingKeyKeyword) {
        this.setUsingKeyKeyword(usingKeyKeyword);
        return this;
    }

    public boolean isUsingValueKeyword() {
        return this.usingValueKeyword;
    }

    public void setUsingValueKeyword(boolean usingValueKeyword) {
        this.usingValueKeyword = usingValueKeyword;
    }

    public JsonKeyValuePair withUsingValueKeyword(boolean usingValueKeyword) {
        this.setUsingValueKeyword(usingValueKeyword);
        return this;
    }

    public boolean isUsingFormatJson() {
        return this.usingFormatJson;
    }

    public void setUsingFormatJson(boolean usingFormatJson) {
        this.usingFormatJson = usingFormatJson;
    }

    public JsonKeyValuePair withUsingFormatJson(boolean usingFormatJson) {
        this.setUsingFormatJson(usingFormatJson);
        return this;
    }

    public int hashCode() {
        int hash = 7;
        hash = 83 * hash + Objects.hashCode(this.key);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        JsonKeyValuePair other = (JsonKeyValuePair)obj;
        return Objects.equals(this.key, other.key);
    }

    public String getKey() {
        return this.key;
    }

    public Object getValue() {
        return this.value;
    }

    public StringBuilder append(StringBuilder builder) {
        if (this.isUsingValueKeyword()) {
            if (this.isUsingKeyKeyword()) {
                builder.append("KEY ");
            }
            builder.append(this.getKey()).append(" VALUE ").append(this.getValue());
        } else {
            builder.append(this.getKey()).append(":").append(this.getValue());
        }
        if (this.isUsingFormatJson()) {
            builder.append(" FORMAT JSON");
        }
        return builder;
    }

    public String toString() {
        return this.append(new StringBuilder()).toString();
    }
}

