/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.parse.useragent.clienthints;

import com.esotericsoftware.kryo.Kryo;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import lombok.Generated;
import nl.basjes.collections.PrefixMap;
import nl.basjes.collections.prefixmap.StringPrefixMap;
import nl.basjes.parse.useragent.AgentField;
import nl.basjes.parse.useragent.UserAgent;
import nl.basjes.parse.useragent.classify.DeviceClass;
import nl.basjes.parse.useragent.clienthints.ClientHints;
import nl.basjes.parse.useragent.clienthints.ClientHintsHeadersParser;
import nl.basjes.parse.useragent.config.AnalyzerConfigHolder;
import nl.basjes.parse.useragent.utils.VersionSplitter;

public class ClientHintsAnalyzer
extends ClientHintsHeadersParser {
    private static final PrefixMap<OSFields> WINDOWS_VERSION_MAPPING = new StringPrefixMap(false);
    private static final List<String> GENERIC_DEVICE_NAMES;
    private static final Pattern DOT_SPLITTER;
    private static final Map<String, String> BROWSER_ANCESTORS;
    private static final Set<String> CHROMIUMNAMES;
    private static final Map<String, Set<String>> EXTRA_FIELD_DEPENDENCIES;

    public static void configureKryo(Object kryoInstance) {
        Kryo kryo = (Kryo)kryoInstance;
        kryo.register(ClientHintsAnalyzer.class);
        ClientHintsHeadersParser.configureKryo(kryoInstance);
    }

    public UserAgent.MutableUserAgent merge(AnalyzerConfigHolder config, UserAgent.MutableUserAgent userAgent, ClientHints clientHints) {
        this.setCHBrandVersionsList(userAgent, "UAClientHintBrands", clientHints.getBrands());
        this.setCHString(userAgent, "UAClientHintArchitecture", clientHints.getArchitecture());
        this.setCHString(userAgent, "UAClientHintBitness", clientHints.getBitness());
        this.setCHStringList(userAgent, "UAClientHintFormFactors", clientHints.getFormFactors());
        this.setCHString(userAgent, "UAClientHintFullVersion", clientHints.getFullVersion());
        this.setCHBrandVersionsList(userAgent, "UAClientHintFullVersionList", clientHints.getFullVersionList());
        this.setCHBoolean(userAgent, "UAClientHintMobile", clientHints.getMobile());
        this.setCHString(userAgent, "UAClientHintModel", clientHints.getModel());
        this.setCHString(userAgent, "UAClientHintPlatform", clientHints.getPlatform());
        this.setCHString(userAgent, "UAClientHintPlatformVersion", clientHints.getPlatformVersion());
        this.setCHBoolean(userAgent, "UAClientHintWow64", clientHints.getWow64());
        this.improveOperatingSystem(userAgent, clientHints);
        this.improveMobileDeviceClass(userAgent, clientHints);
        this.improveDeviceBrandName(userAgent, clientHints);
        this.improveDeviceCPU(userAgent, clientHints);
        this.improveLayoutEngineAndAgentInfo(config, userAgent, clientHints);
        this.improveUsingBrandLookups(config, userAgent, clientHints);
        return userAgent;
    }

    private void setCHBrandVersionsList(UserAgent.MutableUserAgent userAgent, String baseFieldName, ArrayList<ClientHints.Brand> brands) {
        if (brands != null) {
            int i = 0;
            for (ClientHints.Brand brand : brands) {
                userAgent.set(baseFieldName + '_' + i + "_Brand", brand.getName(), 1L);
                userAgent.set(baseFieldName + '_' + i + "_Version", brand.getVersion(), 1L);
                ++i;
            }
        }
    }

    private void setCHStringList(UserAgent.MutableUserAgent userAgent, String baseFieldName, ArrayList<String> values) {
        if (values != null) {
            int i = 0;
            for (String value : values) {
                userAgent.set(baseFieldName + '_' + i, value, 1L);
                ++i;
            }
        }
    }

    private void setCHString(UserAgent.MutableUserAgent userAgent, String fieldName, String value) {
        if (value != null) {
            userAgent.set(fieldName, value, 1L);
        }
    }

    private void setCHBoolean(UserAgent.MutableUserAgent userAgent, String fieldName, Boolean value) {
        if (value != null) {
            userAgent.set(fieldName, Boolean.TRUE.equals(value) ? "true" : "false", 1L);
        }
    }

    public void improveMobileDeviceClass(UserAgent.MutableUserAgent userAgent, ClientHints clientHints) {
        if (clientHints.getMobile() != null) {
            AgentField.MutableAgentField deviceClass = userAgent.get("DeviceClass");
            if (DeviceClass.MOBILE.getValue().equals(deviceClass.getValue())) {
                if (Boolean.TRUE.equals(clientHints.getMobile())) {
                    deviceClass.setValue(DeviceClass.PHONE.getValue(), deviceClass.getConfidence() + 1L);
                } else {
                    deviceClass.setValue(DeviceClass.TABLET.getValue(), deviceClass.getConfidence() + 1L);
                }
            }
        }
    }

    public void improveDeviceBrandName(UserAgent.MutableUserAgent userAgent, ClientHints clientHints) {
        AgentField.MutableAgentField deviceName;
        if (clientHints.getModel() != null && GENERIC_DEVICE_NAMES.contains((deviceName = userAgent.get("DeviceName")).getValue())) {
            this.overrideValue(deviceName, clientHints.getModel());
            this.overrideValue(userAgent.get("DeviceBrand"), "<<<null>>>");
        }
    }

    public void improveDeviceCPU(UserAgent.MutableUserAgent userAgent, ClientHints clientHints) {
        String architecture = clientHints.getArchitecture();
        String bitness = clientHints.getBitness();
        if (bitness != null && !bitness.isEmpty()) {
            this.overrideValue(userAgent.get("DeviceCpuBits"), bitness);
        }
        if (architecture != null) {
            String newArchitecture;
            switch (architecture) {
                case "x86": {
                    newArchitecture = "Intel x86_64";
                    if (!"32".equals(bitness)) break;
                    newArchitecture = "Intel x86";
                    break;
                }
                case "arm": {
                    newArchitecture = "ARM";
                    break;
                }
                default: {
                    newArchitecture = architecture;
                }
            }
            AgentField.MutableAgentField deviceCpu = userAgent.get("DeviceCpu");
            this.overrideValue(deviceCpu, newArchitecture);
        }
    }

    public void improveOperatingSystem(UserAgent.MutableUserAgent userAgent, ClientHints clientHints) {
        String platform = clientHints.getPlatform();
        String platformVersion = clientHints.getPlatformVersion();
        if (platform != null && platformVersion != null && !platform.trim().isEmpty() && !platformVersion.trim().isEmpty()) {
            String majorVersion = VersionSplitter.getInstance().getSingleSplit(platformVersion, 1);
            switch (platform) {
                case "macOS": 
                case "Mac OS X": {
                    this.overrideValue(userAgent.get("DeviceBrand"), "Apple");
                    this.overrideValue(userAgent.get("DeviceClass"), DeviceClass.DESKTOP.getValue());
                    this.overrideValue(userAgent.get("OperatingSystemClass"), DeviceClass.DESKTOP.getValue());
                    this.overrideValue(userAgent.get("LayoutEngineClass"), "Browser");
                    this.overrideValue(userAgent.get("AgentClass"), "Browser");
                    break;
                }
                case "iOS": {
                    this.overrideValue(userAgent.get("DeviceClass"), DeviceClass.MOBILE.getValue());
                    this.overrideValue(userAgent.get("DeviceBrand"), "Apple");
                    break;
                }
                case "Android": 
                case "Fuchsia": {
                    this.overrideValue(userAgent.get("DeviceClass"), DeviceClass.MOBILE.getValue());
                    this.overrideValue(userAgent.get("DeviceBrand"), "<<<null>>>");
                    break;
                }
                case "Linux": {
                    this.overrideValue(userAgent.get("DeviceClass"), DeviceClass.DESKTOP.getValue());
                    this.overrideValue(userAgent.get("DeviceName"), "Linux Desktop");
                    this.overrideValue(userAgent.get("DeviceBrand"), "<<<null>>>");
                    this.overrideValue(userAgent.get("DeviceVersion"), "<<<null>>>");
                    this.overrideValue(userAgent.get("DeviceFirmwareVersion"), "<<<null>>>");
                    this.overrideValue(userAgent.get("OperatingSystemClass"), DeviceClass.DESKTOP.getValue());
                    this.overrideValue(userAgent.get("LayoutEngineClass"), "Browser");
                    this.overrideValue(userAgent.get("AgentClass"), "Browser");
                    break;
                }
                case "Chrome OS": 
                case "Windows": {
                    this.overrideValue(userAgent.get("DeviceName"), DeviceClass.DESKTOP.getValue());
                    this.overrideValue(userAgent.get("DeviceClass"), DeviceClass.DESKTOP.getValue());
                    this.overrideValue(userAgent.get("DeviceBrand"), "<<<null>>>");
                    this.overrideValue(userAgent.get("LayoutEngineClass"), "Browser");
                    this.overrideValue(userAgent.get("OperatingSystemClass"), DeviceClass.DESKTOP.getValue());
                    this.overrideValue(userAgent.get("AgentClass"), "Browser");
                    break;
                }
                default: {
                    this.overrideValue(userAgent.get("DeviceClass"), DeviceClass.DESKTOP.getValue());
                    this.overrideValue(userAgent.get("DeviceBrand"), "<<<null>>>");
                    this.overrideValue(userAgent.get("LayoutEngineClass"), "Browser");
                    this.overrideValue(userAgent.get("OperatingSystemClass"), DeviceClass.DESKTOP.getValue());
                    this.overrideValue(userAgent.get("AgentClass"), "Browser");
                }
            }
            switch (platform) {
                case "macOS": 
                case "Mac OS X": {
                    platform = "Mac OS";
                    this.overrideValue(userAgent.get("OperatingSystemName"), platform);
                    this.overrideValue(userAgent.get("OperatingSystemVersion"), platformVersion);
                    this.overrideValue(userAgent.get("OperatingSystemVersionMajor"), majorVersion);
                    this.overrideValue(userAgent.get("OperatingSystemNameVersion"), platform + " " + platformVersion);
                    this.overrideValue(userAgent.get("OperatingSystemNameVersionMajor"), platform + " " + majorVersion);
                    break;
                }
                case "Android": 
                case "Fuchsia": 
                case "Chrome OS": 
                case "iOS": 
                case "Linux": {
                    this.overrideValue(userAgent.get("OperatingSystemName"), platform);
                    this.overrideValue(userAgent.get("OperatingSystemVersion"), platformVersion);
                    this.overrideValue(userAgent.get("OperatingSystemVersionMajor"), majorVersion);
                    this.overrideValue(userAgent.get("OperatingSystemNameVersion"), platform + " " + platformVersion);
                    this.overrideValue(userAgent.get("OperatingSystemNameVersionMajor"), platform + " " + majorVersion);
                    break;
                }
                case "Windows": {
                    OSFields betterOsVersion = (OSFields)WINDOWS_VERSION_MAPPING.getLongestMatch(platformVersion);
                    if (betterOsVersion == null) break;
                    this.overrideValue(userAgent.get("DeviceClass"), DeviceClass.DESKTOP.getValue());
                    this.overrideValue(userAgent.get("DeviceBrand"), "<<<null>>>");
                    this.overrideValue(userAgent.get("OperatingSystemName"), betterOsVersion.getName());
                    this.overrideValue(userAgent.get("OperatingSystemVersion"), betterOsVersion.getVersion());
                    this.overrideValue(userAgent.get("OperatingSystemVersionMajor"), betterOsVersion.getVersionMajor());
                    this.overrideValue(userAgent.get("OperatingSystemNameVersion"), betterOsVersion.getNameVersion());
                    this.overrideValue(userAgent.get("OperatingSystemNameVersionMajor"), betterOsVersion.getNameVersionMajor());
                    break;
                }
                default: {
                    platform = userAgent.getValue("OperatingSystemName");
                    this.overrideValue(userAgent.get("OperatingSystemVersion"), platformVersion);
                    this.overrideValue(userAgent.get("OperatingSystemVersionMajor"), majorVersion);
                    this.overrideValue(userAgent.get("OperatingSystemNameVersion"), platform + " " + platformVersion);
                    this.overrideValue(userAgent.get("OperatingSystemNameVersionMajor"), platform + " " + majorVersion);
                }
            }
        }
    }

    private boolean newVersionIsBetter(AgentField.MutableAgentField currentVersion, String version) {
        boolean currentVersionHasMinor = currentVersion.getValue().indexOf(46) >= 0;
        boolean versionHasMinor = version.indexOf(46) >= 0;
        return currentVersion.isDefaultValue() || !versionHasMinor && !currentVersionHasMinor || versionHasMinor;
    }

    public void improveLayoutEngineAndAgentInfo(AnalyzerConfigHolder config, UserAgent.MutableUserAgent userAgent, ClientHints clientHints) {
        String betterValue;
        Optional firstBrand;
        boolean versionIsMajorVersionOnly;
        boolean versionFieldValueHasDot;
        AgentField.MutableAgentField currentAgent;
        ArrayList<ClientHints.Brand> versionList = clientHints.getFullVersionList();
        if (versionList == null) {
            versionList = clientHints.getBrands();
        }
        if (versionList == null) {
            return;
        }
        TreeMap versionMap = new TreeMap();
        versionList.forEach(v -> versionMap.put(v.getName(), v));
        ClientHints.Brand chromium = (ClientHints.Brand)versionMap.get("Chromium");
        if (chromium != null) {
            AgentField.MutableAgentField engineName;
            String version = chromium.getVersion();
            String[] versionSplits = DOT_SPLITTER.split(version);
            String majorVersion = versionSplits[0];
            if (versionSplits.length == 4 && !"0".equals(versionSplits[1])) {
                version = versionSplits[1] + ".0." + versionSplits[2] + '.' + versionSplits[3];
                majorVersion = versionSplits[1];
            }
            if ((engineName = userAgent.get("LayoutEngineName")).isDefaultValue() || !"Blink".equals(engineName.getValue())) {
                this.overrideValue(engineName, "Blink");
            }
            AgentField.MutableAgentField engineVersion = userAgent.get("LayoutEngineVersion");
            AgentField.MutableAgentField engineMajorVersion = userAgent.get("LayoutEngineVersionMajor");
            String blinkVersion = majorVersion;
            if (versionSplits.length > 1) {
                blinkVersion = majorVersion + ".0";
            }
            if (this.newVersionIsBetter(engineVersion, blinkVersion)) {
                this.overrideValue(engineVersion, blinkVersion);
                this.overrideValue(engineMajorVersion, majorVersion);
            }
            this.overrideValue(userAgent.get("LayoutEngineNameVersion"), engineName.getValue() + " " + engineVersion.getValue());
            this.overrideValue(userAgent.get("LayoutEngineNameVersionMajor"), engineName.getValue() + " " + engineMajorVersion.getValue());
            if (versionList.size() == 1 && CHROMIUMNAMES.contains(userAgent.getValue("AgentName"))) {
                AgentField.MutableAgentField currentVersion = userAgent.get("AgentVersion");
                if (this.newVersionIsBetter(currentVersion, version)) {
                    this.overrideValue(userAgent.get("AgentName"), "Chromium");
                    this.overrideValue(userAgent.get("AgentVersion"), version);
                    this.overrideValue(userAgent.get("AgentNameVersion"), "Chromium " + version);
                    this.overrideValue(userAgent.get("AgentVersionMajor"), majorVersion);
                    this.overrideValue(userAgent.get("AgentNameVersionMajor"), "Chromium " + majorVersion);
                } else if ("Chrome".equals(userAgent.getValue("AgentName"))) {
                    this.overrideValue(userAgent.get("AgentName"), "Chromium");
                    this.overrideValue(userAgent.get("AgentNameVersion"), "Chromium " + currentVersion.getValue());
                    String currentMajorVersion = userAgent.getValue("AgentVersionMajor");
                    this.overrideValue(userAgent.get("AgentNameVersionMajor"), "Chromium " + currentMajorVersion);
                }
                return;
            }
            versionMap.remove("Chromium");
        }
        BROWSER_ANCESTORS.forEach((wanted, unwanted) -> {
            if (versionMap.containsKey(wanted)) {
                versionMap.remove(unwanted);
            }
        });
        versionMap.remove("Android WebView");
        ClientHints.Brand chrome = (ClientHints.Brand)versionMap.get("Chrome");
        if (chrome == null) {
            chrome = (ClientHints.Brand)versionMap.get("Google Chrome");
        }
        if (chrome != null) {
            if (versionMap.size() == 1) {
                AgentField.MutableAgentField currentVersion = userAgent.get("AgentVersion");
                String version = chrome.getVersion();
                String[] versionSplits = DOT_SPLITTER.split(version);
                String majorVersion = versionSplits[0];
                if (versionSplits.length == 4 && !"0".equals(versionSplits[1])) {
                    version = versionSplits[1] + ".0." + versionSplits[2] + '.' + versionSplits[3];
                    majorVersion = versionSplits[1];
                }
                if (this.newVersionIsBetter(currentVersion, version)) {
                    this.overrideValue(userAgent.get("AgentName"), "Chrome");
                    this.overrideValue(currentVersion, version);
                    this.overrideValue(userAgent.get("AgentNameVersion"), "Chrome " + version);
                    this.overrideValue(userAgent.get("AgentVersionMajor"), majorVersion);
                    this.overrideValue(userAgent.get("AgentNameVersionMajor"), "Chrome " + majorVersion);
                    return;
                }
            }
            versionMap.remove("Chrome");
            versionMap.remove("Google Chrome");
        }
        if ("Opera".equals((currentAgent = userAgent.get("AgentName")).getValue())) {
            String currentVersion = userAgent.get("AgentVersion").getValue();
            String currentMajorVersion = DOT_SPLITTER.split(currentVersion, 2)[0];
            try {
                int currentMajorVersionInt = Integer.parseInt(currentMajorVersion);
                if (currentMajorVersionInt < 98) {
                    versionMap.remove("Opera");
                }
            }
            catch (NumberFormatException currentMajorVersionInt) {
                // empty catch block
            }
        }
        TreeMap<String, ClientHints.Brand> sortedBrands = new TreeMap<String, ClientHints.Brand>();
        int originalPosition = 0;
        for (ClientHints.Brand brand : versionMap.values()) {
            ++originalPosition;
            String version = brand.getVersion();
            versionFieldValueHasDot = version.indexOf(46) >= 0;
            boolean bl = versionIsMajorVersionOnly = !versionFieldValueHasDot;
            if (versionFieldValueHasDot) {
                versionIsMajorVersionOnly = version.endsWith(".0.0.0");
            }
            sortedBrands.put((versionIsMajorVersionOnly ? "1" : "0") + "_" + originalPosition + "_" + brand.getName(), brand);
        }
        AgentField.MutableAgentField agentNameField = userAgent.get("AgentName");
        AgentField.MutableAgentField agentVersionField = userAgent.get("AgentVersion");
        String versionFieldValue = agentVersionField.getValue();
        versionFieldValueHasDot = versionFieldValue.indexOf(46) >= 0;
        boolean bl = versionIsMajorVersionOnly = !versionFieldValueHasDot;
        if (versionFieldValueHasDot) {
            versionIsMajorVersionOnly = versionFieldValue.endsWith(".0.0.0");
        }
        if (!(firstBrand = sortedBrands.entrySet().stream().findFirst()).isPresent()) {
            return;
        }
        Map.Entry brandEntry = (Map.Entry)firstBrand.get();
        ClientHints.Brand brand = (ClientHints.Brand)brandEntry.getValue();
        String agentName = brand.getName();
        Map<String, String> clientHintTagMapping = config.getLookups().get("ClientHintTagToNameMapping");
        if (clientHintTagMapping != null && (betterValue = clientHintTagMapping.get(agentName.toLowerCase(Locale.ROOT))) != null) {
            agentName = betterValue;
        }
        String newVersion = brand.getVersion();
        String newMajorVersion = DOT_SPLITTER.split(newVersion, 2)[0];
        String setVersion = versionFieldValue;
        String setMajorVersion = DOT_SPLITTER.split(versionFieldValue, 2)[0];
        if (versionIsMajorVersionOnly) {
            setVersion = newVersion;
            setMajorVersion = newMajorVersion;
        } else if (!setMajorVersion.equals(newMajorVersion)) {
            setVersion = newVersion;
            setMajorVersion = newMajorVersion;
        }
        this.overrideValue(agentNameField, agentName);
        this.overrideValue(userAgent.get("AgentVersion"), setVersion);
        this.overrideValue(userAgent.get("AgentNameVersion"), agentName + " " + setVersion);
        this.overrideValue(userAgent.get("AgentVersionMajor"), setMajorVersion);
        this.overrideValue(userAgent.get("AgentNameVersionMajor"), agentName + " " + setMajorVersion);
    }

    public void improveUsingBrandLookups(AnalyzerConfigHolder config, UserAgent.MutableUserAgent userAgent, ClientHints clientHints) {
        String model = clientHints.getModel();
        if (model == null || model.isEmpty()) {
            return;
        }
        Map<String, String> amazonDeviceTags = config.getLookups().get("AmazonDeviceTags");
        if (amazonDeviceTags == null || amazonDeviceTags.isEmpty()) {
            return;
        }
        String betterValue = amazonDeviceTags.get(model.toLowerCase(Locale.ROOT));
        if (betterValue != null) {
            String[] split = betterValue.split("\\|", 3);
            this.overrideValue(userAgent.get("DeviceClass"), split[0]);
            this.overrideValue(userAgent.get("DeviceBrand"), split[1]);
            this.overrideValue(userAgent.get("DeviceName"), split[2]);
        }
    }

    private static Set<String> setOfStrings(String ... values) {
        return new HashSet<String>(Arrays.asList(values));
    }

    public static Set<String> extraDependenciesNeededByClientCalculator(@Nonnull Set<String> wantedFieldNames) {
        HashSet<String> result = new HashSet<String>();
        for (String wantedFieldName : wantedFieldNames) {
            Set<String> extraDependencies = EXTRA_FIELD_DEPENDENCIES.get(wantedFieldName);
            if (extraDependencies == null) continue;
            result.addAll(extraDependencies);
        }
        return result;
    }

    private void overrideValue(AgentField.MutableAgentField field, String newValue) {
        field.setValue(newValue, field.getConfidence() + 1L);
    }

    static {
        WINDOWS_VERSION_MAPPING.put("0.1", (Serializable)new OSFields("Windows NT", "7", "7", "Windows 7", "Windows 7"));
        WINDOWS_VERSION_MAPPING.put("0.2", (Serializable)new OSFields("Windows NT", "8", "8", "Windows 8", "Windows 8"));
        WINDOWS_VERSION_MAPPING.put("0.3", (Serializable)new OSFields("Windows NT", "8.1", "8", "Windows 8.1", "Windows 8"));
        WINDOWS_VERSION_MAPPING.put("1", (Serializable)new OSFields("Windows NT", "10", "10", "Windows 10", "Windows 10"));
        WINDOWS_VERSION_MAPPING.put("2", (Serializable)new OSFields("Windows NT", "10", "10", "Windows 10", "Windows 10"));
        WINDOWS_VERSION_MAPPING.put("3", (Serializable)new OSFields("Windows NT", "10", "10", "Windows 10", "Windows 10"));
        WINDOWS_VERSION_MAPPING.put("4", (Serializable)new OSFields("Windows NT", "10", "10", "Windows 10", "Windows 10"));
        WINDOWS_VERSION_MAPPING.put("5", (Serializable)new OSFields("Windows NT", "10", "10", "Windows 10", "Windows 10"));
        WINDOWS_VERSION_MAPPING.put("6", (Serializable)new OSFields("Windows NT", "10", "10", "Windows 10", "Windows 10"));
        WINDOWS_VERSION_MAPPING.put("7", (Serializable)new OSFields("Windows NT", "10", "10", "Windows 10", "Windows 10"));
        WINDOWS_VERSION_MAPPING.put("8", (Serializable)new OSFields("Windows NT", "10", "10", "Windows 10", "Windows 10"));
        WINDOWS_VERSION_MAPPING.put("9", (Serializable)new OSFields("Windows NT", "10", "10", "Windows 10", "Windows 10"));
        WINDOWS_VERSION_MAPPING.put("10", (Serializable)new OSFields("Windows NT", "10", "10", "Windows 10", "Windows 10"));
        WINDOWS_VERSION_MAPPING.put("13", (Serializable)new OSFields("Windows NT", "11", "11", "Windows 11", "Windows 11"));
        WINDOWS_VERSION_MAPPING.put("14", (Serializable)new OSFields("Windows NT", "11", "11", "Windows 11", "Windows 11"));
        WINDOWS_VERSION_MAPPING.put("15", (Serializable)new OSFields("Windows NT", "11", "11", "Windows 11", "Windows 11"));
        WINDOWS_VERSION_MAPPING.put("16", (Serializable)new OSFields("Windows NT", "11", "11", "Windows 11", "Windows 11"));
        WINDOWS_VERSION_MAPPING.put("17", (Serializable)new OSFields("Windows NT", "11", "11", "Windows 11", "Windows 11"));
        WINDOWS_VERSION_MAPPING.put("18", (Serializable)new OSFields("Windows NT", "11", "11", "Windows 11", "Windows 11"));
        WINDOWS_VERSION_MAPPING.put("19", (Serializable)new OSFields("Windows NT", "11", "11", "Windows 11", "Windows 11"));
        GENERIC_DEVICE_NAMES = Arrays.asList("Unknown", "Android Mobile", "Fuchsia Mobile", "Fuchsia Device", "iOS Device", "Desktop", "Linux Desktop", "Unknown Set-top box", "Samsung Phone", "Samsung Tablet");
        DOT_SPLITTER = Pattern.compile("\\.");
        BROWSER_ANCESTORS = new TreeMap<String, String>();
        BROWSER_ANCESTORS.put("Google Chrome", "Chromium");
        BROWSER_ANCESTORS.put("Chrome", "Chromium");
        BROWSER_ANCESTORS.put("OperaMobile", "Opera");
        CHROMIUMNAMES = new HashSet<String>();
        CHROMIUMNAMES.add("Chromium");
        CHROMIUMNAMES.add("Chrome");
        EXTRA_FIELD_DEPENDENCIES = new TreeMap<String, Set<String>>();
        EXTRA_FIELD_DEPENDENCIES.put("AgentClass", ClientHintsAnalyzer.setOfStrings("AgentName", "AgentVersion"));
        EXTRA_FIELD_DEPENDENCIES.put("AgentName", ClientHintsAnalyzer.setOfStrings("AgentVersion"));
        EXTRA_FIELD_DEPENDENCIES.put("AgentVersion", ClientHintsAnalyzer.setOfStrings("AgentName"));
        EXTRA_FIELD_DEPENDENCIES.put("AgentNameVersion", ClientHintsAnalyzer.setOfStrings("AgentName"));
        EXTRA_FIELD_DEPENDENCIES.put("AgentVersionMajor", ClientHintsAnalyzer.setOfStrings("AgentName"));
        EXTRA_FIELD_DEPENDENCIES.put("AgentNameVersionMajor", ClientHintsAnalyzer.setOfStrings("AgentName"));
    }

    private static final class OSFields
    implements Serializable {
        String name;
        String version;
        String versionMajor;
        String nameVersion;
        String nameVersionMajor;

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public String getVersion() {
            return this.version;
        }

        @Generated
        public String getVersionMajor() {
            return this.versionMajor;
        }

        @Generated
        public String getNameVersion() {
            return this.nameVersion;
        }

        @Generated
        public String getNameVersionMajor() {
            return this.nameVersionMajor;
        }

        @Generated
        public OSFields(String name, String version, String versionMajor, String nameVersion, String nameVersionMajor) {
            this.name = name;
            this.version = version;
            this.versionMajor = versionMajor;
            this.nameVersion = nameVersion;
            this.nameVersionMajor = nameVersionMajor;
        }
    }
}

