/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.util;

import com.alibaba.fastjson2.util.ED;
import com.alibaba.fastjson2.util.ED5;
import com.alibaba.fastjson2.util.EF;
import com.alibaba.fastjson2.util.IOUtils;
import com.alibaba.fastjson2.util.JDKUtils;
import com.alibaba.fastjson2.util.Scientific;
import java.lang.invoke.CallSite;
import java.lang.invoke.LambdaMetafactory;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;

public final class NumberUtils {
    static final LongBiFunction MULTIPLY_HIGH;
    static final long INFI;
    static final long NITY;
    static final long INFINITY;
    static final double[] POSITIVE_DECIMAL_POWER;
    static final double[] NEGATIVE_DECIMAL_POWER;
    static final long[] POW10_LONG_VALUES;
    static final long[] POW5_LONG_VALUES;
    static final BigInteger[] POW5_BI_VALUES;
    static final int MOD_DOUBLE_EXP = 2047;
    static final long MOD_DOUBLE_MANTISSA = 0xFFFFFFFFFFFFFL;
    static final char[][] POSITIVE_DECIMAL_POWER_CHARS;
    static final char[][] NEGATIVE_DECIMAL_POWER_CHARS;
    static final int MOD_FLOAT_EXP = 255;
    static final int MOD_FLOAT_MANTISSA = 0x7FFFFF;
    static final int[] TWO_DIGITS_32_BITS;
    static final short[] TWO_DIGITS_16_BITS;

    static long multiplyHigh(long x, long y) {
        long x1 = x >> 32;
        long x2 = x & 0xFFFFFFFFL;
        long y1 = y >> 32;
        long y2 = y & 0xFFFFFFFFL;
        long z2 = x2 * y2;
        long t = x1 * y2 + (z2 >>> 32);
        long z1 = t & 0xFFFFFFFFL;
        long z0 = t >> 32;
        return x1 * y1 + z0 + ((z1 += x2 * y1) >> 32);
    }

    private NumberUtils() {
    }

    static long multiplyHighAndShift(long x, long y, int shift) {
        long H = MULTIPLY_HIGH.multiplyHigh(x, y);
        if (shift >= 64) {
            int sr = shift - 64;
            return H >>> sr;
        }
        long L = x * y;
        return H << 64 - shift | L >>> shift;
    }

    static long multiplyHighAndShift(long x, long y, long y32, int s) {
        int sr = s - 64;
        long H = MULTIPLY_HIGH.multiplyHigh(x, y);
        long L = x * y;
        long H1 = MULTIPLY_HIGH.multiplyHigh(x, y32);
        long L1 = x * y32;
        long carry = (H1 << 32) + (L1 >>> 32);
        long L2 = L + carry;
        if ((L | carry) < 0L && ((L & carry) < 0L || L2 >= 0L)) {
            ++H;
        }
        L = L2;
        if (sr >= 0) {
            return H >>> sr;
        }
        return H << -sr | L >>> s;
    }

    public static Scientific doubleToScientific(double doubleValue) {
        long output;
        long rawOutput;
        long d4;
        long d3;
        int adl;
        int e10;
        int e52;
        boolean flagForDown;
        if (doubleValue == Double.MIN_VALUE) {
            return Scientific.DOUBLE_MIN;
        }
        long bits = Double.doubleToRawLongBits(doubleValue);
        int e2 = (int)(bits >> 52) & 0x7FF;
        long mantissa0 = bits & 0xFFFFFFFFFFFFFL;
        boolean bl = flagForDown = mantissa0 > 0L;
        if (e2 > 0) {
            if (e2 == 2047) {
                return Scientific.SCIENTIFIC_NULL;
            }
            mantissa0 = 0x10000000000000L | mantissa0;
            e52 = e2 - 1075;
        } else {
            if (mantissa0 == 0L) {
                return bits == 0L ? Scientific.ZERO : Scientific.NEGATIVE_ZERO;
            }
            int lz52 = Long.numberOfLeadingZeros(mantissa0) - 11;
            mantissa0 <<= lz52;
            e52 = -1074 - lz52;
        }
        boolean accurate = false;
        if (e52 >= 0) {
            ED d = ED.E2_D_A[e52];
            e10 = d.e10;
            adl = d.adl;
            d3 = d.d3;
            d4 = d.d4;
            if (d.b && mantissa0 >= d.bv) {
                if (mantissa0 > d.bv) {
                    ++e10;
                    ++adl;
                } else if (doubleValue == POSITIVE_DECIMAL_POWER[e10 + 1]) {
                    return new Scientific(e10 + 1, true);
                }
            }
            int o5 = d.o5;
            int sb = e52 + o5;
            if (o5 < 0) {
                ED5 d5 = ED5.ED5_A[-o5];
                int rb = sb - 10 - d5.ob;
                rawOutput = NumberUtils.multiplyHighAndShift(mantissa0 << 10, d5.oy, d5.of, 32 - rb);
                accurate = o5 == -1 && sb < 11;
            } else {
                rawOutput = mantissa0 * POW5_LONG_VALUES[o5] << sb;
                accurate = true;
            }
        } else {
            int o5;
            int sb;
            int e5 = -e52;
            ED d = ED.E5_D_A[e5];
            e10 = d.e10;
            adl = d.adl;
            d3 = d.d3;
            d4 = d.d4;
            if (d.b && mantissa0 >= d.bv) {
                if (mantissa0 > d.bv) {
                    ++e10;
                    ++adl;
                } else {
                    if (e10 >= -1 && doubleValue == POSITIVE_DECIMAL_POWER[e10 + 1]) {
                        return new Scientific(e10 + 1, true);
                    }
                    if (e10 < -1 && doubleValue == NEGATIVE_DECIMAL_POWER[-e10 - 1]) {
                        return new Scientific(e10 + 1, true);
                    }
                }
            }
            if ((sb = (o5 = d.o5) + e52) < 0) {
                if (o5 < POW5_LONG_VALUES.length) {
                    rawOutput = NumberUtils.multiplyHighAndShift(mantissa0, POW5_LONG_VALUES[o5], -sb);
                } else if (o5 < POW5_LONG_VALUES.length + 4) {
                    rawOutput = NumberUtils.multiplyHighAndShift(mantissa0 * POW5_LONG_VALUES[o5 - POW5_LONG_VALUES.length + 1], POW5_LONG_VALUES[POW5_LONG_VALUES.length - 1], -sb);
                } else {
                    ED5 ed5 = ED5.ED5_A[o5];
                    rawOutput = NumberUtils.multiplyHighAndShift(mantissa0 << 10, ed5.y, ed5.f, -(ed5.dfb + sb) + 10);
                }
            } else {
                rawOutput = POW5_LONG_VALUES[o5] * mantissa0 << sb;
            }
        }
        if (accurate) {
            rawOutput /= 10L;
            if (adl == 16) {
                --adl;
                rawOutput = (rawOutput + 5L) / 10L;
            }
            return new Scientific(rawOutput, adl + 2, e10);
        }
        long div = rawOutput / 1000L;
        long rem = rawOutput - div * 1000L;
        long remUp = 10001L - rem * 10L << 1;
        boolean up = remUp <= d4;
        if (up || rem + 1L << (flagForDown ? 1 : 2) <= d3) {
            output = div + (long)(up ? 1 : 0);
            --adl;
        } else if (flagForDown) {
            output = (rawOutput + 50L) / 100L;
        } else {
            output = (rawOutput + 5L) / 10L;
            ++adl;
        }
        return new Scientific(output, adl + 1, e10);
    }

    public static int writeDouble(byte[] buf, int off, double doubleValue, boolean json) {
        char[] chars;
        boolean sign;
        if (doubleValue == 0.0) {
            long bits = Double.doubleToLongBits(doubleValue);
            if (bits == Long.MIN_VALUE) {
                buf[off++] = 45;
            }
            buf[off] = 48;
            IOUtils.putShortUnaligned(buf, off + 1, IOUtils.DOT_ZERO_16);
            return off + 3;
        }
        boolean bl = sign = doubleValue < 0.0;
        if (sign) {
            if (!json || doubleValue != Double.NEGATIVE_INFINITY) {
                buf[off++] = 45;
            }
            doubleValue = -doubleValue;
        }
        if (doubleValue == (double)((long)doubleValue)) {
            long output = (long)doubleValue;
            int numLength = IOUtils.stringSize(output);
            return NumberUtils.writeDecimal(output, numLength, numLength - 1, buf, off);
        }
        Scientific scientific = NumberUtils.doubleToScientific(doubleValue);
        int e10 = scientific.e10;
        if (!scientific.b) {
            return NumberUtils.writeDecimal(scientific.output, scientific.count, scientific.e10, buf, off);
        }
        if (scientific == Scientific.SCIENTIFIC_NULL) {
            if (json) {
                IOUtils.putIntUnaligned(buf, off, IOUtils.NULL_32);
                return off + 4;
            }
            if (doubleValue == Double.POSITIVE_INFINITY) {
                IOUtils.putLongUnaligned(buf, off, INFINITY);
                return off + 8;
            }
            buf[off] = 78;
            buf[off + 1] = 97;
            buf[off + 2] = 78;
            return off + 3;
        }
        if (e10 >= 0) {
            char[] chars2;
            for (char c : chars2 = POSITIVE_DECIMAL_POWER_CHARS[e10]) {
                buf[off++] = (byte)c;
            }
            return off;
        }
        for (char c : chars = NEGATIVE_DECIMAL_POWER_CHARS[-e10]) {
            buf[off++] = (byte)c;
        }
        return off;
    }

    public static int writeDouble(char[] buf, int off, double doubleValue, boolean json) {
        boolean sign;
        if (doubleValue == 0.0) {
            long bits = Double.doubleToLongBits(doubleValue);
            if (bits == Long.MIN_VALUE) {
                buf[off++] = 45;
            }
            buf[off] = 48;
            IOUtils.putIntUnaligned(buf, off + 1, IOUtils.DOT_ZERO_32);
            return off + 3;
        }
        boolean bl = sign = doubleValue < 0.0;
        if (sign) {
            if (!json || doubleValue != Double.NEGATIVE_INFINITY) {
                buf[off++] = 45;
            }
            doubleValue = -doubleValue;
        }
        if (doubleValue == (double)((long)doubleValue)) {
            long output = (long)doubleValue;
            int numLength = IOUtils.stringSize(output);
            return NumberUtils.writeDecimal(output, numLength, numLength - 1, buf, off);
        }
        Scientific scientific = NumberUtils.doubleToScientific(doubleValue);
        int e10 = scientific.e10;
        if (!scientific.b) {
            return NumberUtils.writeDecimal(scientific.output, scientific.count, e10, buf, off);
        }
        if (scientific == Scientific.SCIENTIFIC_NULL) {
            if (json) {
                IOUtils.putLongUnaligned(buf, off, IOUtils.NULL_64);
                return off + 4;
            }
            if (doubleValue == Double.POSITIVE_INFINITY) {
                IOUtils.putLongUnaligned(buf, off, INFI);
                IOUtils.putLongUnaligned(buf, off + 4, NITY);
                return off + 8;
            }
            buf[off] = 78;
            buf[off + 1] = 97;
            buf[off + 2] = 78;
            return off + 3;
        }
        if (e10 >= 0) {
            char[] chars = POSITIVE_DECIMAL_POWER_CHARS[e10];
            System.arraycopy(chars, 0, buf, off, chars.length);
            return off + chars.length;
        }
        char[] chars = NEGATIVE_DECIMAL_POWER_CHARS[-e10];
        System.arraycopy(chars, 0, buf, off, chars.length);
        return off + chars.length;
    }

    public static int writeFloat(byte[] buf, int off, float floatValue, boolean json) {
        boolean sign;
        if (Float.isNaN(floatValue) || floatValue == Float.POSITIVE_INFINITY || floatValue == Float.NEGATIVE_INFINITY) {
            return NumberUtils.writeSpecial(buf, off, floatValue, json);
        }
        if (floatValue == 0.0f) {
            int bits = Float.floatToIntBits(floatValue);
            if (bits == Integer.MIN_VALUE) {
                buf[off++] = 45;
            }
            buf[off] = 48;
            IOUtils.putShortUnaligned(buf, off + 1, IOUtils.DOT_ZERO_16);
            return off + 3;
        }
        boolean bl = sign = floatValue < 0.0f;
        if (sign) {
            buf[off++] = 45;
            floatValue = -floatValue;
        }
        Scientific scientific = NumberUtils.floatToScientific(floatValue);
        return NumberUtils.writeDecimal(scientific.output, scientific.count, scientific.e10, buf, off);
    }

    public static int writeFloat(char[] buf, int off, float floatValue, boolean json) {
        boolean sign;
        if (Float.isNaN(floatValue) || floatValue == Float.POSITIVE_INFINITY || floatValue == Float.NEGATIVE_INFINITY) {
            return NumberUtils.writeSpecial(buf, off, floatValue, json);
        }
        if (floatValue == 0.0f) {
            int bits = Float.floatToIntBits(floatValue);
            if (bits == Integer.MIN_VALUE) {
                buf[off++] = 45;
            }
            buf[off] = 48;
            IOUtils.putIntUnaligned(buf, off + 1, IOUtils.DOT_ZERO_32);
            return off + 3;
        }
        boolean bl = sign = floatValue < 0.0f;
        if (sign) {
            buf[off++] = 45;
            floatValue = -floatValue;
        }
        Scientific scientific = NumberUtils.floatToScientific(floatValue);
        return NumberUtils.writeDecimal(scientific.output, scientific.count, scientific.e10, buf, off);
    }

    private static int writeSpecial(byte[] buf, int off, float floatValue, boolean json) {
        if (json) {
            IOUtils.putIntUnaligned(buf, off, IOUtils.NULL_32);
            return off + 4;
        }
        if (Float.isNaN(floatValue)) {
            buf[off] = 78;
            buf[off + 1] = 97;
            buf[off + 2] = 78;
            return off + 3;
        }
        if (floatValue == Float.NEGATIVE_INFINITY) {
            buf[off++] = 45;
        }
        IOUtils.putLongUnaligned(buf, off, INFINITY);
        return off + 8;
    }

    private static int writeSpecial(char[] buf, int off, float floatValue, boolean json) {
        if (json) {
            IOUtils.putLongUnaligned(buf, off, IOUtils.NULL_64);
            return off + 4;
        }
        if (Float.isNaN(floatValue)) {
            buf[off] = 78;
            buf[off + 1] = 97;
            buf[off + 2] = 78;
            return off + 3;
        }
        if (floatValue == Float.NEGATIVE_INFINITY) {
            buf[off++] = 45;
        }
        IOUtils.putLongUnaligned(buf, off, INFI);
        IOUtils.putLongUnaligned(buf, off + 4, NITY);
        return off + 8;
    }

    public static Scientific floatToScientific(float floatValue) {
        long output;
        boolean up;
        long rawOutput;
        long d4;
        int adl;
        int e10;
        int e23;
        int bits = Float.floatToRawIntBits(floatValue);
        int e2 = bits >> 23 & 0xFF;
        int mantissa0 = bits & 0x7FFFFF;
        boolean nonZeroFlag = mantissa0 > 0;
        boolean accurate = false;
        if (e2 > 0) {
            if (e2 == 255) {
                return Scientific.SCIENTIFIC_NULL;
            }
            mantissa0 = 0x800000 | mantissa0;
            e23 = e2 - 150;
        } else {
            if (mantissa0 == 0) {
                return bits == 0 ? Scientific.ZERO : Scientific.NEGATIVE_ZERO;
            }
            int l = Integer.numberOfLeadingZeros(mantissa0) - 8;
            mantissa0 <<= l;
            e23 = -149 - l;
        }
        if (e23 >= 0) {
            ED d = EF.E2_F_A[e23];
            e10 = d.e10;
            adl = d.adl;
            d4 = d.d4;
            if (d.b && (long)mantissa0 > d.bv) {
                ++e10;
                ++adl;
            }
            int o5 = d.o5 + 6;
            int sb = e23 + o5;
            if (o5 < 0) {
                if (sb < 40) {
                    rawOutput = ((long)mantissa0 << sb) / POW5_LONG_VALUES[-o5];
                } else {
                    ED5 d5 = ED5.ED5_A[-o5];
                    rawOutput = NumberUtils.multiplyHighAndShift((long)mantissa0 << 39, d5.oy, d5.of, 71 + d5.ob - sb);
                }
            } else {
                rawOutput = (long)mantissa0 * POW5_LONG_VALUES[o5] << sb;
                accurate = true;
            }
        } else {
            int o5;
            int sb;
            int e5 = -e23;
            ED d = EF.E5_F_A[e5];
            e10 = d.e10;
            adl = d.adl;
            d4 = d.d4;
            if (d.b && (long)mantissa0 > d.bv) {
                ++e10;
                ++adl;
            }
            if ((sb = (o5 = d.o5 + 6) + e23) < 0) {
                if (o5 < 17) {
                    rawOutput = (long)mantissa0 * POW5_LONG_VALUES[o5] >> -sb;
                } else if (o5 < POW5_LONG_VALUES.length) {
                    rawOutput = NumberUtils.multiplyHighAndShift(mantissa0, POW5_LONG_VALUES[o5], -sb);
                } else if (o5 < POW5_LONG_VALUES.length + 4) {
                    rawOutput = NumberUtils.multiplyHighAndShift((long)mantissa0 * POW5_LONG_VALUES[o5 - POW5_LONG_VALUES.length + 1], POW5_LONG_VALUES[POW5_LONG_VALUES.length - 1], -sb);
                } else {
                    ED5 ed5 = ED5.ED5_A[o5];
                    rawOutput = NumberUtils.multiplyHighAndShift((long)mantissa0 << 39, ed5.y, ed5.f, -(ed5.dfb + sb) + 39);
                }
            } else {
                rawOutput = POW5_LONG_VALUES[o5] * (long)mantissa0 << sb;
                accurate = true;
            }
        }
        if (accurate) {
            // empty if block
        }
        if (rawOutput < 1000000000L) {
            return new Scientific(MULTIPLY_HIGH.multiplyHigh(rawOutput, 7737125245533626719L) >> 22, 2, e10);
        }
        long div = MULTIPLY_HIGH.multiplyHigh(rawOutput, 4951760157141521100L) >> 28;
        long rem = rawOutput - div * 1000000000L;
        long remUp = 1000000001L - rem << 1;
        boolean bl = up = remUp <= d4;
        if (up || rem + 1L << (nonZeroFlag ? 1 : 2) <= d4) {
            output = div + (long)(up ? 1 : 0);
            if (up && POW10_LONG_VALUES[--adl] == output) {
                ++e10;
                output = 1L;
                adl = 0;
            }
        } else if (nonZeroFlag) {
            long div0 = MULTIPLY_HIGH.multiplyHigh(rawOutput, 6189700196426901375L) >> 25;
            output = div0 + (long)(rem % 100000000L >= 50000000L ? 1 : 0);
        } else {
            long div0 = MULTIPLY_HIGH.multiplyHigh(rawOutput, 7737125245533626719L) >> 22;
            output = div0 + (long)(rem % 10000000L >= 5000000L ? 1 : 0);
            ++adl;
        }
        return new Scientific(output, adl + 1, e10);
    }

    private static int writeDecimal(long value, int digitCnt, int e10, byte[] buf, int off) {
        boolean useScientific;
        if ((value & 1L) == 0L && value % 5L == 0L) {
            while (value % 100L == 0L) {
                value /= 100L;
                if ((digitCnt -= 2) != 1) continue;
            }
            if ((value & 1L) == 0L && value % 5L == 0L && value > 0L) {
                --digitCnt;
                value /= 10L;
            }
        }
        boolean bl = useScientific = e10 < -3 || e10 >= 7;
        if (useScientific) {
            if (digitCnt == 1) {
                buf[off] = (byte)(value + 48L);
                IOUtils.putShortUnaligned(buf, off + 1, IOUtils.DOT_ZERO_16);
                off += 3;
            } else {
                int pos = digitCnt - 2;
                long tl = POW10_LONG_VALUES[pos];
                int fd = (int)(value / tl);
                buf[off] = (byte)(fd + 48);
                buf[off + 1] = 46;
                off += 2;
                long pointAfter = value - (long)fd * tl;
                while (--pos > -1 && pointAfter < POW10_LONG_VALUES[pos]) {
                    buf[off++] = 48;
                }
                off = IOUtils.writeInt64(buf, off, pointAfter);
            }
            buf[off++] = 69;
            if (e10 < 0) {
                buf[off++] = 45;
                e10 = -e10;
            }
            if (e10 > 99) {
                int n = (int)((long)e10 * 1374389535L >> 37);
                buf[off] = (byte)(n + 48);
                IOUtils.putShortUnaligned(buf, off + 1, TWO_DIGITS_16_BITS[e10 -= n * 100]);
                off += 3;
            } else if (e10 > 9) {
                IOUtils.putShortUnaligned(buf, off, TWO_DIGITS_16_BITS[e10]);
                off += 2;
            } else {
                buf[off++] = (byte)(e10 + 48);
            }
        } else if (e10 < 0) {
            IOUtils.putShortUnaligned(buf, off, IOUtils.ZERO_DOT_16);
            off += 2;
            if (e10 == -2) {
                buf[off++] = 48;
            } else if (e10 == -3) {
                IOUtils.putShortUnaligned(buf, off, (short)12336);
                off += 2;
            }
            off = IOUtils.writeInt64(buf, off, value);
        } else {
            int decimalPointPos = digitCnt - 1 - e10;
            if (decimalPointPos > 0) {
                int pos = decimalPointPos - 1;
                long tl = POW10_LONG_VALUES[pos];
                int pointBefore = (int)(value / tl);
                off = IOUtils.writeInt32(buf, off, (long)pointBefore);
                buf[off++] = 46;
                long pointAfter = value - (long)pointBefore * tl;
                while (--pos > -1 && pointAfter < POW10_LONG_VALUES[pos]) {
                    buf[off++] = 48;
                }
                off = IOUtils.writeInt64(buf, off, pointAfter);
            } else {
                off = IOUtils.writeInt64(buf, off, value);
                int zeroCnt = -decimalPointPos;
                if (zeroCnt > 0) {
                    for (int i = 0; i < zeroCnt; ++i) {
                        buf[off++] = 48;
                    }
                }
                IOUtils.putShortUnaligned(buf, off, IOUtils.DOT_ZERO_16);
                off += 2;
            }
        }
        return off;
    }

    private static int writeDecimal(long value, int digitCnt, int e10, char[] buf, int off) {
        boolean useScientific;
        if ((value & 1L) == 0L && value % 5L == 0L) {
            while (value % 100L == 0L) {
                value /= 100L;
                if ((digitCnt -= 2) != 1) continue;
            }
            if ((value & 1L) == 0L && value % 5L == 0L && value > 0L) {
                --digitCnt;
                value /= 10L;
            }
        }
        boolean bl = useScientific = e10 < -3 || e10 >= 7;
        if (useScientific) {
            if (digitCnt == 1) {
                buf[off] = (char)(value + 48L);
                IOUtils.putIntUnaligned(buf, off + 1, IOUtils.DOT_ZERO_32);
                off += 3;
            } else {
                int pos = digitCnt - 2;
                long tl = POW10_LONG_VALUES[pos];
                int fd = (int)(value / tl);
                buf[off] = (char)(fd + 48);
                buf[off + 1] = 46;
                off += 2;
                long pointAfter = value - (long)fd * tl;
                while (--pos > -1 && pointAfter < POW10_LONG_VALUES[pos]) {
                    buf[off++] = 48;
                }
                off = IOUtils.writeInt64(buf, off, pointAfter);
            }
            buf[off++] = 69;
            if (e10 < 0) {
                buf[off++] = 45;
                e10 = -e10;
            }
            if (e10 > 99) {
                int n = (int)((long)e10 * 1374389535L >> 37);
                buf[off] = (char)(n + 48);
                IOUtils.putIntUnaligned(buf, off + 1, TWO_DIGITS_32_BITS[e10 -= n * 100]);
                off += 3;
            } else if (e10 > 9) {
                IOUtils.putIntUnaligned(buf, off, TWO_DIGITS_32_BITS[e10]);
                off += 2;
            } else {
                buf[off++] = (char)(e10 + 48);
            }
        } else if (e10 < 0) {
            IOUtils.putIntUnaligned(buf, off, IOUtils.ZERO_DOT_32);
            off += 2;
            if (e10 == -2) {
                buf[off++] = 48;
            } else if (e10 == -3) {
                IOUtils.putIntUnaligned(buf, off, 0x300030);
                off += 2;
            }
            off = IOUtils.writeInt64(buf, off, value);
        } else {
            int decimalPointPos = digitCnt - 1 - e10;
            if (decimalPointPos > 0) {
                int pos = decimalPointPos - 1;
                long tl = POW10_LONG_VALUES[pos];
                int pointBefore = (int)(value / tl);
                off = IOUtils.writeInt64(buf, off, (long)pointBefore);
                buf[off++] = 46;
                long pointAfter = value - (long)pointBefore * tl;
                while (--pos > -1 && pointAfter < POW10_LONG_VALUES[pos]) {
                    buf[off++] = 48;
                }
                off = IOUtils.writeInt64(buf, off, pointAfter);
            } else {
                off = IOUtils.writeInt64(buf, off, value);
                int zeroCnt = -decimalPointPos;
                if (zeroCnt > 0) {
                    for (int i = 0; i < zeroCnt; ++i) {
                        buf[off++] = 48;
                    }
                }
                IOUtils.putIntUnaligned(buf, off, IOUtils.DOT_ZERO_32);
                off += 2;
            }
        }
        return off;
    }

    static {
        LongBiFunction function = null;
        if (JDKUtils.JVM_VERSION > 8 && !JDKUtils.ANDROID) {
            try {
                MethodHandles.Lookup lookup = JDKUtils.trustedLookup(NumberUtils.class);
                MethodType methodType = MethodType.methodType(Long.TYPE, Long.TYPE, Long.TYPE);
                MethodHandle methodHandle = lookup.findStatic(Math.class, "multiplyHigh", methodType);
                CallSite callSite = LambdaMetafactory.metafactory(lookup, "multiplyHigh", MethodType.methodType(LongBiFunction.class), methodType, methodHandle, methodType);
                function = callSite.getTarget().invokeExact();
            }
            catch (Throwable lookup) {
                // empty catch block
            }
        }
        if (function == null) {
            function = NumberUtils::multiplyHigh;
        }
        MULTIPLY_HIGH = function;
        String str = "Infinity";
        INFINITY = IOUtils.getLongUnaligned(str.getBytes(StandardCharsets.ISO_8859_1), 0);
        char[] chars = str.toCharArray();
        INFI = IOUtils.getLongUnaligned(chars, 0);
        NITY = IOUtils.getLongUnaligned(chars, 4);
        POSITIVE_DECIMAL_POWER = new double[325];
        NEGATIVE_DECIMAL_POWER = new double[325];
        POW10_LONG_VALUES = new long[]{10L, 100L, 1000L, 10000L, 100000L, 1000000L, 10000000L, 100000000L, 1000000000L, 10000000000L, 100000000000L, 1000000000000L, 10000000000000L, 100000000000000L, 1000000000000000L, 10000000000000000L, 100000000000000000L, 1000000000000000000L, Long.MAX_VALUE};
        POW5_LONG_VALUES = new long[27];
        POW5_BI_VALUES = new BigInteger[343];
        int len = POSITIVE_DECIMAL_POWER.length;
        for (int i = 0; i < len; ++i) {
            NumberUtils.POSITIVE_DECIMAL_POWER[i] = Double.valueOf("1.0E" + i);
            NumberUtils.NEGATIVE_DECIMAL_POWER[i] = Double.valueOf("1.0E-" + i);
        }
        NumberUtils.NEGATIVE_DECIMAL_POWER[NumberUtils.NEGATIVE_DECIMAL_POWER.length - 1] = Double.MIN_VALUE;
        long val = 1L;
        for (int i = 0; i < POW5_LONG_VALUES.length; ++i) {
            NumberUtils.POW5_LONG_VALUES[i] = val;
            val *= 5L;
        }
        BigInteger five = BigInteger.valueOf(5L);
        NumberUtils.POW5_BI_VALUES[0] = BigInteger.ONE;
        for (int i = 1; i < POW5_BI_VALUES.length; ++i) {
            BigInteger pow5Value;
            NumberUtils.POW5_BI_VALUES[i] = pow5Value = five.pow(i);
        }
        POSITIVE_DECIMAL_POWER_CHARS = new char[325][];
        NEGATIVE_DECIMAL_POWER_CHARS = new char[325][];
        len = POSITIVE_DECIMAL_POWER_CHARS.length;
        for (int i = 0; i < len; ++i) {
            String positive = "1.0E" + i;
            String negative = "1.0E-" + i;
            NumberUtils.POSITIVE_DECIMAL_POWER_CHARS[i] = positive.toCharArray();
            NumberUtils.NEGATIVE_DECIMAL_POWER_CHARS[i] = negative.toCharArray();
        }
        NumberUtils.NEGATIVE_DECIMAL_POWER_CHARS[NumberUtils.NEGATIVE_DECIMAL_POWER_CHARS.length - 1] = "4.9E-324".toCharArray();
        TWO_DIGITS_32_BITS = new int[100];
        TWO_DIGITS_16_BITS = new short[100];
        for (long d1 = 0L; d1 < 10L; ++d1) {
            for (long d2 = 0L; d2 < 10L; ++d2) {
                int intVal32;
                long intVal64;
                if (JDKUtils.BIG_ENDIAN) {
                    intVal64 = d1 + 48L << 16 | d2 + 48L;
                    intVal32 = (int)d1 + 48 << 8 | (int)d2 + 48;
                } else {
                    intVal64 = d2 + 48L << 16 | d1 + 48L;
                    intVal32 = (int)d2 + 48 << 8 | (int)d1 + 48;
                }
                int k = (int)(d1 * 10L + d2);
                NumberUtils.TWO_DIGITS_32_BITS[k] = (int)intVal64;
                NumberUtils.TWO_DIGITS_16_BITS[k] = (short)intVal32;
            }
        }
    }

    @FunctionalInterface
    static interface LongBiFunction {
        public long multiplyHigh(long var1, long var3);
    }
}

