/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.schema;

import com.fasterxml.classmate.ResolvedType;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import springfox.documentation.schema.ModelKeyBuilder;
import springfox.documentation.schema.QualifiedModelName;

public class ModelKey {
    private final QualifiedModelName qualifiedModelName;
    private final ResolvedType viewDiscriminator;
    private final Set<ResolvedType> validationGroupDiscriminators = new HashSet<ResolvedType>();
    private final boolean isResponse;

    public ModelKey(QualifiedModelName qualifiedModelName, ResolvedType viewDiscriminator, Collection<ResolvedType> validationGroupDiscriminators, boolean isResponse) {
        this.qualifiedModelName = qualifiedModelName;
        this.viewDiscriminator = viewDiscriminator;
        this.validationGroupDiscriminators.addAll(validationGroupDiscriminators);
        this.isResponse = isResponse;
    }

    public QualifiedModelName getQualifiedModelName() {
        return this.qualifiedModelName;
    }

    public Optional<ResolvedType> getViewDiscriminator() {
        return Optional.ofNullable(this.viewDiscriminator);
    }

    public Set<ResolvedType> getValidationGroupDiscriminators() {
        return this.validationGroupDiscriminators;
    }

    public boolean isResponse() {
        return this.isResponse;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ModelKey modelKey = (ModelKey)o;
        return this.isResponse == modelKey.isResponse && Objects.equals(this.qualifiedModelName, modelKey.qualifiedModelName) && Objects.equals(this.viewDiscriminator, modelKey.viewDiscriminator) && Objects.equals(this.validationGroupDiscriminators, modelKey.validationGroupDiscriminators);
    }

    public int hashCode() {
        return Objects.hash(this.qualifiedModelName, this.viewDiscriminator, this.validationGroupDiscriminators, this.isResponse);
    }

    public String toString() {
        return "ModelKey{qualifiedModelName=" + this.qualifiedModelName + ", viewDiscriminator=" + this.viewDiscriminator + ", validationGroupDiscriminators=" + this.validationGroupDiscriminators + ", isResponse=" + this.isResponse + '}';
    }

    public ModelKey flippedResponse() {
        return new ModelKeyBuilder().copyOf(this).isResponse(!this.isResponse).build();
    }
}

