/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.nt;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.nio.channels.SocketChannel;
import java.util.Hashtable;
import java.util.Properties;
import oracle.jdbc.driver.DMSFactory;
import oracle.jdbc.internal.Monitor;
import oracle.jdbc.logging.annotations.Blind;
import oracle.jdbc.logging.annotations.DisableTrace;
import oracle.jdbc.logging.annotations.PropertiesBlinder;
import oracle.net.jdbc.nl.NLException;
import oracle.net.jdbc.nl.NVFactory;
import oracle.net.jdbc.nl.NVNavigator;
import oracle.net.jdbc.nl.NVPair;
import oracle.net.ns.NetException;
import oracle.net.nt.DownHostsCache;
import oracle.net.nt.NTAdapter;

public class SdpNTAdapter
implements NTAdapter {
    static final boolean DEBUG = false;
    static final String SDP_SOCKET_CLASS_NAME = "com.oracle.net.Sdp";
    static Method OPEN_SOCKET = null;
    static Method OPEN_SOCKET_CHANNEL = null;
    private SocketChannel socketChannel;
    InetAddress[] inetAddresses = null;
    int count;
    int attempts;
    int port;
    String host;
    protected Socket socket;
    protected int sockTimeout;
    protected Properties socketOptions;
    private static Hashtable<String, InetAddress[]> inetaddressesCache = new Hashtable();
    private static Hashtable<String, Integer> circularOffsets = new Hashtable();
    private static final Monitor CIRCULAR_OFFSETS_MONITOR = Monitor.newInstance();

    private static Socket getSDPSocket() throws IOException {
        if (OPEN_SOCKET == null) {
            try {
                Class<?> clazz = Class.forName(SDP_SOCKET_CLASS_NAME);
                OPEN_SOCKET = clazz.getMethod("openSocket", new Class[0]);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new IOException("SDP enabled, but SDP socket class not in classpath", classNotFoundException);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw new IOException("SDP enabled but unable to get SDP socket class", noSuchMethodException);
            }
        }
        try {
            return (Socket)OPEN_SOCKET.invoke(null, new Object[0]);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IOException("SDP enabled, but SDP.openSocket could not be accessed", illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new IOException("SDP enabled, but SDP.openSocket raised an exception", invocationTargetException);
        }
    }

    private static SocketChannel getSDPSocketChannel() throws IOException {
        if (OPEN_SOCKET_CHANNEL == null) {
            try {
                Class<?> clazz = Class.forName(SDP_SOCKET_CLASS_NAME);
                OPEN_SOCKET_CHANNEL = clazz.getMethod("openSocketChannel", new Class[0]);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new IOException("SDP enabled, but SDP socket class not in classpath", classNotFoundException);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw new IOException("SDP enabled but unable to get SDP socket class", noSuchMethodException);
            }
        }
        try {
            return (SocketChannel)OPEN_SOCKET_CHANNEL.invoke(null, new Object[0]);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IOException("SDP enabled, but SDP.openSocket could not be accessed", illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new IOException("SDP enabled, but SDP.openSocket raised an exception", invocationTargetException);
        }
    }

    public SdpNTAdapter(String string, @Blind(value=PropertiesBlinder.class) Properties properties) throws NLException {
        this.socketOptions = properties;
        NVNavigator nVNavigator = new NVNavigator();
        NVPair nVPair = new NVFactory().createNVPair(string);
        NVPair nVPair2 = nVNavigator.findNVPair(nVPair, "HOST");
        NVPair nVPair3 = nVNavigator.findNVPair(nVPair, "PORT");
        if (nVPair2 == null) {
            throw new NLException("NoNVPair-04614", "HOST");
        }
        this.host = nVPair2.getAtom();
        if (nVPair3 != null) {
            try {
                this.port = Integer.parseInt(nVPair3.getAtom());
            }
            catch (Exception exception) {
                throw (NLException)new NLException(new NetException(116).getMessage()).initCause(exception);
            }
        } else {
            this.port = 1521;
        }
        if (this.port < 0 || this.port > 65535) {
            throw new NLException(new NetException(116).getMessage());
        }
    }

    @Override
    public void connect(DMSFactory.DMSNoun dMSNoun) throws IOException {
        String string = (String)this.socketOptions.get(2);
        boolean bl = Boolean.parseBoolean((String)this.socketOptions.get(18));
        Boolean bl2 = Boolean.parseBoolean((String)this.socketOptions.get(20));
        if (this.inetAddresses == null) {
            this.inetAddresses = InetAddress.getAllByName(this.host);
            if (bl && this.inetAddresses.length > 1) {
                this.inetAddresses = SdpNTAdapter.getAddressesInCircularOrder(this.host, this.inetAddresses);
            }
            DownHostsCache.getInstance().reorderAddresses(this.inetAddresses, this.port);
            this.attempts = this.inetAddresses.length;
            this.count = 0;
        }
        while (true) {
            InetAddress inetAddress = this.inetAddresses[this.count];
            ++this.count;
            --this.attempts;
            long l2 = System.currentTimeMillis();
            if (!bl2.booleanValue()) {
                this.socket = SdpNTAdapter.getSDPSocket();
            }
            try {
                if (bl2.booleanValue()) {
                    this.socketChannel = SdpNTAdapter.getSDPSocketChannel();
                    this.socket = this.socketChannel.socket();
                }
                this.socket.connect(new InetSocketAddress(inetAddress, this.port), Integer.parseInt(string));
            }
            catch (IOException iOException) {
                DownHostsCache.getInstance().markDownHost(inetAddress, this.port);
                try {
                    if (this.socket != null) {
                        this.socket.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (this.attempts > 0) continue;
                this.resetInetAddress();
                String string2 = String.format("%s, socket connect lapse %d ms. %s %d %s %d %s", iOException.getMessage(), System.currentTimeMillis() - l2, inetAddress.toString(), this.port, string, this.count, bl2);
                IOException iOException2 = new IOException(string2, iOException);
                throw iOException2;
                if (this.count < this.inetAddresses.length) continue;
            }
            break;
        }
        this.setOption(3, string);
        this.setSocketOptions();
    }

    @Override
    public boolean hasMoreInetAddresses() {
        return this.inetAddresses != null && this.count < this.inetAddresses.length;
    }

    @Override
    public void resetInetAddress() {
        this.inetAddresses = null;
    }

    public void setSocketOptions() throws IOException {
        String string = (String)this.socketOptions.get(0);
        if (string != null) {
            this.setOption(0, string);
        }
        if ((string = (String)this.socketOptions.get(1)) != null) {
            this.setOption(1, string);
        }
    }

    @Override
    public void disconnect() throws IOException {
        try {
            if (this.socket != null && !this.socket.isClosed()) {
                this.socket.close();
            }
        }
        finally {
            this.socket = null;
        }
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.socket.getInputStream();
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        return this.socket.getOutputStream();
    }

    @Override
    public void setOption(int n2, Object object) throws IOException, NetException {
        switch (n2) {
            case 0: {
                String string = (String)object;
                this.socket.setTcpNoDelay(string.equals("YES"));
                break;
            }
            case 1: {
                String string = (String)object;
                if (!string.equals("YES")) break;
                this.socket.setKeepAlive(true);
                break;
            }
            case 3: {
                this.sockTimeout = Integer.parseInt((String)object);
                this.socket.setSoTimeout(this.sockTimeout);
                break;
            }
        }
    }

    @Override
    public Object getOption(int n2) throws IOException, NetException {
        switch (n2) {
            case 101: {
                return "" + this.sockTimeout;
            }
        }
        return null;
    }

    @Override
    public void abort() throws NetException, IOException {
        try {
            this.socket.setSoLinger(true, 0);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.socket.close();
    }

    @Override
    public void sendUrgentByte(int n2) throws IOException {
        this.socket.sendUrgentData(n2);
    }

    @Override
    public boolean isCharacteristicUrgentSupported() throws IOException {
        try {
            return !this.socket.getOOBInline();
        }
        catch (IOException iOException) {
            return false;
        }
    }

    @Override
    public void setReadTimeoutIfRequired(@Blind(value=PropertiesBlinder.class) Properties properties) throws IOException, NetException {
        String string = (String)properties.get("oracle.net.READ_TIMEOUT");
        if (string == null) {
            string = "0";
        }
        this.setOption(3, string);
    }

    @DisableTrace
    public String toString() {
        return "host=" + this.host + ", port=" + this.port + "\n    socket_timeout=" + this.sockTimeout + ", socketOptions=" + this.socketOptions.toString() + "\n    socket=" + this.socket;
    }

    private static final InetAddress[] getAddressesInCircularOrder(String string, InetAddress[] inetAddressArray) {
        try (Monitor.CloseableLock closeableLock = CIRCULAR_OFFSETS_MONITOR.acquireCloseableLock();){
            InetAddress[] inetAddressArray2 = inetaddressesCache.get(string);
            Integer n2 = circularOffsets.get(string);
            if (inetAddressArray2 == null || !SdpNTAdapter.areEquals(inetAddressArray2, inetAddressArray)) {
                n2 = new Integer(0);
                inetAddressArray2 = inetAddressArray;
                inetaddressesCache.put(string, inetAddressArray);
                circularOffsets.put(string, n2);
            }
            InetAddress[] inetAddressArray3 = SdpNTAdapter.getCopyAddresses(inetAddressArray2, n2);
            circularOffsets.put(string, new Integer((n2 + 1) % inetAddressArray2.length));
            InetAddress[] inetAddressArray4 = inetAddressArray3;
            return inetAddressArray4;
        }
    }

    private static final boolean areEquals(InetAddress[] inetAddressArray, InetAddress[] inetAddressArray2) {
        if (inetAddressArray.length != inetAddressArray2.length) {
            return false;
        }
        for (int i2 = 0; i2 < inetAddressArray.length; ++i2) {
            if (inetAddressArray[i2].equals(inetAddressArray2[i2])) continue;
            return false;
        }
        return true;
    }

    private static final InetAddress[] getCopyAddresses(InetAddress[] inetAddressArray, int n2) {
        InetAddress[] inetAddressArray2 = new InetAddress[inetAddressArray.length];
        for (int i2 = 0; i2 < inetAddressArray.length; ++i2) {
            inetAddressArray2[i2] = inetAddressArray[(i2 + n2) % inetAddressArray.length];
        }
        return inetAddressArray2;
    }

    @Override
    public boolean isConnectionSocketKeepAlive() throws SocketException {
        return this.socket.getKeepAlive();
    }

    @Override
    public InetAddress getInetAddress() {
        return this.socket.getInetAddress();
    }

    @Override
    public SocketChannel getSocketChannel() {
        return this.socketChannel;
    }

    @Override
    public NTAdapter.NetworkAdapterType getNetworkAdapterType() {
        return NTAdapter.NetworkAdapterType.SDP;
    }
}

