/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.collections.prefixmap;

import java.io.Serializable;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.PrimitiveIterator;
import java.util.TreeMap;
import nl.basjes.collections.prefixmap.PrefixTrie;

class StringPrefixTrie<V extends Serializable>
implements PrefixTrie<V> {
    private final boolean caseSensitive;
    private final int charIndex;
    private TreeMap<Integer, StringPrefixTrie<V>> childNodes;
    private V theValue;

    StringPrefixTrie(boolean caseSensitive) {
        this(caseSensitive, 0);
    }

    StringPrefixTrie(boolean caseSensitive, int charIndex) {
        this.caseSensitive = caseSensitive;
        this.charIndex = charIndex;
    }

    @Override
    public V add(PrimitiveIterator.OfInt prefix, V value) {
        V previousValue = this.theValue;
        if (!prefix.hasNext()) {
            this.theValue = value;
            return previousValue;
        }
        int myChar = prefix.nextInt();
        if (this.childNodes == null) {
            this.childNodes = new TreeMap();
        }
        if (this.caseSensitive) {
            PrefixTrie child = this.childNodes.computeIfAbsent(myChar, c -> new StringPrefixTrie<V>(true, this.charIndex + 1));
            previousValue = child.add(prefix, value);
        } else {
            int lower = Character.toLowerCase(myChar);
            int upper = Character.toUpperCase(myChar);
            StringPrefixTrie child = this.childNodes.computeIfAbsent(lower, c -> new StringPrefixTrie<V>(false, this.charIndex + 1));
            previousValue = child.add(prefix, value);
            this.childNodes.put(upper, child);
        }
        return previousValue;
    }

    @Override
    public V remove(PrimitiveIterator.OfInt prefix) {
        PrefixTrie child;
        if (!prefix.hasNext()) {
            V previousValue = this.theValue;
            this.theValue = null;
            return previousValue;
        }
        if (this.childNodes == null) {
            return null;
        }
        int myChar = prefix.nextInt();
        if (!this.caseSensitive) {
            myChar = Character.toLowerCase(myChar);
        }
        if ((child = (PrefixTrie)this.childNodes.get(myChar)) == null) {
            return null;
        }
        return child.remove(prefix);
    }

    @Override
    public V get(PrimitiveIterator.OfInt prefix) {
        if (!prefix.hasNext()) {
            return this.theValue;
        }
        if (this.childNodes == null) {
            return null;
        }
        int myChar = prefix.nextInt();
        PrefixTrie child = this.childNodes.get(myChar);
        if (child == null) {
            return null;
        }
        return child.get(prefix);
    }

    @Override
    public V getShortestMatch(PrimitiveIterator.OfInt input) {
        if (this.theValue != null || !input.hasNext() || this.childNodes == null) {
            return this.theValue;
        }
        int myChar = input.nextInt();
        PrefixTrie child = this.childNodes.get(myChar);
        if (child == null) {
            return null;
        }
        return child.getShortestMatch(input);
    }

    @Override
    public V getLongestMatch(PrimitiveIterator.OfInt input) {
        if (!input.hasNext() || this.childNodes == null) {
            return this.theValue;
        }
        int myChar = input.nextInt();
        PrefixTrie child = this.childNodes.get(myChar);
        if (child == null) {
            return this.theValue;
        }
        Object returnValue = child.getLongestMatch(input);
        return returnValue == null ? this.theValue : returnValue;
    }

    @Override
    public Iterator<V> getAllMatches(PrimitiveIterator.OfInt input) {
        return new StringTrieIterator(input, this);
    }

    @Override
    public void clear() {
        this.childNodes = null;
        this.theValue = null;
    }

    @Override
    public boolean caseSensitive() {
        return this.caseSensitive;
    }

    public static class StringTrieIterator<V extends Serializable>
    implements Iterator<V> {
        private V next;
        private final PrimitiveIterator.OfInt input;
        private StringPrefixTrie<V> node;

        StringTrieIterator(PrimitiveIterator.OfInt input, StringPrefixTrie<V> node) {
            this.input = input;
            this.node = node;
            this.next = this.getNext();
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public V next() {
            if (this.next == null) {
                throw new NoSuchElementException("Trying next() when hasNext() is false.");
            }
            V result = this.next;
            this.next = this.getNext();
            return result;
        }

        private V getNext() {
            if (this.node == null) {
                return null;
            }
            Serializable theValue = ((StringPrefixTrie)this.node).theValue;
            if (!this.input.hasNext() || ((StringPrefixTrie)this.node).childNodes == null) {
                this.node = null;
                return (V)theValue;
            }
            int myChar = this.input.nextInt();
            StringPrefixTrie child = (StringPrefixTrie)((StringPrefixTrie)this.node).childNodes.get(myChar);
            if (child == null) {
                this.node = null;
                return (V)theValue;
            }
            this.node = child;
            if (theValue == null) {
                return this.getNext();
            }
            return (V)theValue;
        }
    }
}

