/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.jedis;

import java.util.function.Supplier;
import org.springframework.core.convert.converter.Converter;
import org.springframework.data.redis.connection.FutureResult;
import org.springframework.lang.Nullable;
import redis.clients.jedis.Response;

class JedisResult<T, R>
extends FutureResult<Response<?>> {
    private final boolean convertPipelineAndTxResults;

    JedisResult(Response<T> resultHolder) {
        this(resultHolder, false, null);
    }

    JedisResult(Response<T> resultHolder, boolean convertPipelineAndTxResults, @Nullable Converter<T, ?> converter) {
        this(resultHolder, () -> null, convertPipelineAndTxResults, converter);
    }

    JedisResult(Response<T> resultHolder, Supplier<R> defaultReturnValue, boolean convertPipelineAndTxResults, @Nullable Converter<T, ?> converter) {
        super(resultHolder, converter, defaultReturnValue);
        this.convertPipelineAndTxResults = convertPipelineAndTxResults;
    }

    @Override
    @Nullable
    public T get() {
        return (T)((Response)this.getResultHolder()).get();
    }

    @Override
    public boolean conversionRequired() {
        return this.convertPipelineAndTxResults;
    }

    static class JedisResultBuilder<T, R> {
        private final Response<T> response;
        private Converter<T, R> converter;
        private boolean convertPipelineAndTxResults = false;
        private Supplier<R> nullValueDefault = () -> null;

        JedisResultBuilder(Response<T> response) {
            this.response = response;
            this.converter = source -> source;
        }

        static <T, R> JedisResultBuilder<T, R> forResponse(Response<T> response) {
            return new JedisResultBuilder<T, R>(response);
        }

        JedisResultBuilder<T, R> mappedWith(Converter<T, R> converter) {
            this.converter = converter;
            return this;
        }

        JedisResultBuilder<T, R> mapNullTo(Supplier<R> supplier) {
            this.nullValueDefault = supplier;
            return this;
        }

        JedisResultBuilder<T, R> convertPipelineAndTxResults(boolean flag) {
            this.convertPipelineAndTxResults = flag;
            return this;
        }

        JedisResult<T, R> build() {
            return new JedisResult<T, R>(this.response, this.nullValueDefault, this.convertPipelineAndTxResults, this.converter);
        }

        JedisStatusResult<T, R> buildStatusResult() {
            return new JedisStatusResult<T, R>(this.response, this.converter);
        }
    }

    static class JedisStatusResult<T, R>
    extends JedisResult<T, R> {
        JedisStatusResult(Response<T> resultHolder, Converter<T, R> converter) {
            super(resultHolder, false, converter);
            this.setStatus(true);
        }
    }
}

