/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.framework.web.service;

import com.ruoyi.common.core.domain.entity.SysRole;
import com.ruoyi.common.core.domain.model.LoginUser;
import com.ruoyi.common.utils.SecurityUtils;
import com.ruoyi.common.utils.StringUtils;
import com.ruoyi.framework.security.context.PermissionContextHolder;
import java.util.Collection;
import java.util.Set;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="ss")
public class PermissionService {
    public boolean hasPermi(String permission) {
        if (StringUtils.isEmpty((String)permission)) {
            return false;
        }
        LoginUser loginUser = SecurityUtils.getLoginUser();
        if (StringUtils.isNull((Object)loginUser) || CollectionUtils.isEmpty((Collection)loginUser.getPermissions())) {
            return false;
        }
        PermissionContextHolder.setContext(permission);
        return this.hasPermissions(loginUser.getPermissions(), permission);
    }

    public boolean lacksPermi(String permission) {
        return !this.hasPermi(permission);
    }

    public boolean hasAnyPermi(String permissions) {
        if (StringUtils.isEmpty((String)permissions)) {
            return false;
        }
        LoginUser loginUser = SecurityUtils.getLoginUser();
        if (StringUtils.isNull((Object)loginUser) || CollectionUtils.isEmpty((Collection)loginUser.getPermissions())) {
            return false;
        }
        PermissionContextHolder.setContext(permissions);
        Set authorities = loginUser.getPermissions();
        String[] stringArray = permissions.split(",");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String permission = stringArray[n2];
            if (permission != null && this.hasPermissions(authorities, permission)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public boolean hasRole(String role) {
        if (StringUtils.isEmpty((String)role)) {
            return false;
        }
        LoginUser loginUser = SecurityUtils.getLoginUser();
        if (StringUtils.isNull((Object)loginUser) || CollectionUtils.isEmpty((Collection)loginUser.getUser().getRoles())) {
            return false;
        }
        for (SysRole sysRole : loginUser.getUser().getRoles()) {
            String roleKey = sysRole.getRoleKey();
            if (!"admin".equals(roleKey) && !roleKey.equals(StringUtils.trim((String)role))) continue;
            return true;
        }
        return false;
    }

    public boolean lacksRole(String role) {
        return !this.hasRole(role);
    }

    public boolean hasAnyRoles(String roles) {
        if (StringUtils.isEmpty((String)roles)) {
            return false;
        }
        LoginUser loginUser = SecurityUtils.getLoginUser();
        if (StringUtils.isNull((Object)loginUser) || CollectionUtils.isEmpty((Collection)loginUser.getUser().getRoles())) {
            return false;
        }
        String[] stringArray = roles.split(",");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String role = stringArray[n2];
            if (this.hasRole(role)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private boolean hasPermissions(Set<String> permissions, String permission) {
        return permissions.contains("*:*:*") || permissions.contains(StringUtils.trim((String)permission));
    }
}

