/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.driver;

import dm.jdbc.desc.MetaSQL;
import dm.jdbc.desc.MetaSQL2Gateway;
import dm.jdbc.driver.DBError;
import dm.jdbc.driver.DmDriver;
import dm.jdbc.driver.DmdbConnection;
import dm.jdbc.driver.DmdbResultSet;
import dm.jdbc.filter.Filterable;
import dm.jdbc.util.DriverUtil;
import dm.jdbc.util.StringUtil;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.RowIdLifetime;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.concurrent.atomic.AtomicLong;

public class DmdbDatabaseMetaData
extends Filterable
implements DatabaseMetaData {
    public DmdbConnection connection = null;
    private MetaSQL sqlBuilder;
    public static AtomicLong IDGenerator = new AtomicLong(0L);

    @Override
    public long getID() {
        if (this.ID < 0L) {
            this.ID = IDGenerator.incrementAndGet();
        }
        return this.ID;
    }

    public DmdbDatabaseMetaData(DmdbConnection dmdbConnection) {
        super(dmdbConnection, null);
        this.connection = dmdbConnection;
        this.sqlBuilder = dmdbConnection.serverSeries == Integer.MAX_VALUE ? new MetaSQL2Gateway(dmdbConnection.do_getSchema(), dmdbConnection.compatibleOracle()) : new MetaSQL(dmdbConnection.do_getSchema(), dmdbConnection.compatibleOracle());
    }

    public DmdbResultSet do_getCatalogs() {
        String string = this.sqlBuilder.getCatalogs();
        return DriverUtil.executeQuery(this.connection, string);
    }

    public DmdbResultSet do_getSchemas() {
        String string = this.sqlBuilder.getSchemas();
        return DriverUtil.executeQuery(this.connection, string);
    }

    public DmdbResultSet do_getSchemas(String string, String string2) {
        if (StringUtil.isEmpty(string) && StringUtil.isEmpty(string2)) {
            return this.do_getSchemas();
        }
        ArrayList arrayList = new ArrayList();
        String string3 = this.sqlBuilder.getSchemas(arrayList, string, string2);
        return DriverUtil.executeQueryWithConst(this.connection, string3, arrayList.toArray());
    }

    public DmdbResultSet do_getTableTypes() {
        String string = this.sqlBuilder.getTableTypes();
        return DriverUtil.executeQuery(this.connection, string);
    }

    public DmdbResultSet do_getTypeInfo() {
        String string = this.sqlBuilder.getTypeInfo();
        return DriverUtil.executeQuery(this.connection, string);
    }

    public DmdbResultSet do_getAttributes(String string, String string2, String string3, String string4) {
        ArrayList arrayList = new ArrayList();
        String string5 = this.sqlBuilder.getAttributes(arrayList, string, string2, string3, string4);
        return DriverUtil.executeQueryWithConst(this.connection, string5, arrayList.toArray());
    }

    public DmdbResultSet do_getBestRowIdentifier(String string, String string2, String string3, int n2, boolean bl) {
        DmdbResultSet dmdbResultSet = this.do_getPrimaryKeys(string, string2, string3);
        LinkedList<String> linkedList = new LinkedList<String>();
        LinkedList<String> linkedList2 = new LinkedList<String>();
        while (dmdbResultSet.next()) {
            linkedList.add(dmdbResultSet.getString("TABID"));
            linkedList2.add(dmdbResultSet.getString("COLID"));
        }
        ArrayList arrayList = new ArrayList();
        String string4 = null;
        string4 = linkedList2.size() > 0 ? this.sqlBuilder.getBestRowIdentifier(arrayList, linkedList, linkedList2, n2) : this.sqlBuilder.getBestRowIdentifier(arrayList, string, string2, string3, n2, bl);
        return DriverUtil.executeQueryWithConst(this.connection, string4.toString(), arrayList.toArray());
    }

    public DmdbResultSet do_getTables(String string, String string2, String string3, String[] stringArray) {
        ArrayList arrayList = new ArrayList();
        String string4 = this.sqlBuilder.getTables(arrayList, string, string2, string3, stringArray);
        return DriverUtil.executeQueryWithConst(this.connection, string4, arrayList.toArray());
    }

    public DmdbResultSet do_getTablePrivileges(String string, String string2, String string3) {
        ArrayList arrayList = new ArrayList();
        String string4 = this.sqlBuilder.getTablePrivileges(arrayList, string, string2, string3);
        return DriverUtil.executeQueryWithConst(this.connection, string4.toString(), arrayList.toArray());
    }

    public DmdbResultSet do_getColumns(String string, String string2, String string3, String string4) {
        ArrayList arrayList = new ArrayList();
        String string5 = this.sqlBuilder.getColumns(arrayList, string, string2, string3, string4);
        return DriverUtil.executeQueryWithConst(this.connection, string5, arrayList.toArray());
    }

    public DmdbResultSet do_getColumnPrivileges(String string, String string2, String string3, String string4) {
        ArrayList arrayList = new ArrayList();
        String string5 = this.sqlBuilder.getColumnPrivileges(arrayList, string, string2, string3, string4);
        return DriverUtil.executeQueryWithConst(this.connection, string5, arrayList.toArray());
    }

    public DmdbResultSet do_getVersionColumns(String string, String string2, String string3) {
        ArrayList arrayList = new ArrayList();
        String string4 = this.sqlBuilder.getVersionColumns(arrayList, string, string2, string3);
        return DriverUtil.executeQueryWithConst(this.connection, string4, arrayList.toArray());
    }

    public DmdbResultSet do_getPrimaryKeys(String string, String string2, String string3) {
        ArrayList arrayList = new ArrayList();
        String string4 = this.sqlBuilder.getPrimaryKeys(arrayList, string, string2, string3);
        return DriverUtil.executeQueryWithConst(this.connection, string4, arrayList.toArray());
    }

    public DmdbResultSet do_getImportedKeys(String string, String string2, String string3) {
        ArrayList arrayList = new ArrayList();
        String string4 = this.sqlBuilder.getImportedKeys(arrayList, string, string2, string3);
        return DriverUtil.executeQueryWithConst(this.connection, string4, arrayList.toArray());
    }

    public DmdbResultSet do_getExportedKeys(String string, String string2, String string3) {
        ArrayList arrayList = new ArrayList();
        String string4 = this.sqlBuilder.getExportedKeys(arrayList, string, string2, string3);
        return DriverUtil.executeQueryWithConst(this.connection, string4, arrayList.toArray());
    }

    public DmdbResultSet do_getCrossReference(String string, String string2, String string3, String string4, String string5, String string6) {
        ArrayList arrayList = new ArrayList();
        String string7 = this.sqlBuilder.getCrossReference(arrayList, string, string2, string3, string4, string5, string6);
        return DriverUtil.executeQueryWithConst(this.connection, string7, arrayList.toArray());
    }

    public DmdbResultSet do_getIndexInfo(String string, String string2, String string3, boolean bl, boolean bl2) {
        ArrayList arrayList = new ArrayList();
        String string4 = this.sqlBuilder.getIndexInfo(arrayList, string, string2, string3, bl, bl2);
        return DriverUtil.executeQueryWithConst(this.connection, string4, arrayList.toArray());
    }

    public DmdbResultSet do_getUDTs(String string, String string2, String string3, int[] nArray) {
        ArrayList arrayList = new ArrayList();
        String string4 = this.sqlBuilder.getUDTs(arrayList, string, string2, string3, nArray);
        return DriverUtil.executeQueryWithConst(this.connection, string4, arrayList.toArray());
    }

    public DmdbResultSet do_getSuperTypes(String string, String string2, String string3) {
        ArrayList arrayList = new ArrayList();
        String string4 = this.sqlBuilder.getSuperTypes(arrayList, string, string2, string3);
        return DriverUtil.executeQueryWithConst(this.connection, string4, arrayList.toArray());
    }

    public DmdbResultSet do_getSuperTables(String string, String string2, String string3) {
        ArrayList arrayList = new ArrayList();
        String string4 = this.sqlBuilder.getSuperTables(arrayList, string, string2, string3);
        return DriverUtil.executeQueryWithConst(this.connection, string4, arrayList.toArray());
    }

    public DmdbResultSet do_getProcedures(String string, String string2, String string3) {
        if (this.connection.compatibleOracle() && StringUtil.isNotEmpty(string)) {
            return this.do_getPkgProcedures(string2, string, string3, 0);
        }
        ArrayList arrayList = new ArrayList();
        String string4 = this.sqlBuilder.getProcedures(arrayList, string, string2, string3);
        return DriverUtil.executeQueryWithConst(this.connection, string4.toString(), arrayList.toArray());
    }

    public DmdbResultSet do_getPkgProcedures(String string, String string2, String string3, int n2) {
        ArrayList arrayList = new ArrayList();
        String string4 = this.sqlBuilder.getPkgProcedures(arrayList, string, string2, string3, n2);
        return DriverUtil.executeQueryWithConst(this.connection, string4.toString(), arrayList.toArray());
    }

    public DmdbResultSet do_getProcedureColumns(String string, String string2, String string3, String string4) {
        ArrayList arrayList = new ArrayList();
        String string5 = this.sqlBuilder.getProcedureColumns(arrayList, string, string2, string3, string4);
        return DriverUtil.executeQueryWithConst(this.connection, string5, arrayList.toArray());
    }

    public DmdbResultSet do_getFunctions(String string, String string2, String string3) {
        if (this.connection.compatibleOracle() && StringUtil.isNotEmpty(string)) {
            return this.do_getPkgProcedures(string2, string, string3, 2);
        }
        ArrayList arrayList = new ArrayList();
        String string4 = this.sqlBuilder.getFunctions(arrayList, string, string2, string3);
        return DriverUtil.executeQueryWithConst(this.connection, string4.toString(), arrayList.toArray());
    }

    public DmdbResultSet do_getFunctionColumns(String string, String string2, String string3, String string4) {
        ArrayList arrayList = new ArrayList();
        String string5 = this.sqlBuilder.getFunctionColumns(arrayList, string, string2, string3, string4);
        return DriverUtil.executeQueryWithConst(this.connection, string5, arrayList.toArray());
    }

    public DmdbResultSet do_getClientInfoProperties() {
        String string = this.sqlBuilder.getClientInfoProperties();
        return DriverUtil.executeQuery(this.connection, string);
    }

    public boolean do_allProceduresAreCallable() {
        return true;
    }

    public boolean do_allTablesAreSelectable() {
        return true;
    }

    public boolean do_autoCommitFailureClosesAllResultSets() {
        return false;
    }

    public boolean do_dataDefinitionCausesTransactionCommit() {
        return this.connection.ddlAutoCommit;
    }

    public boolean do_dataDefinitionIgnoredInTransactions() {
        return !this.connection.ddlAutoCommit;
    }

    public String do_getDatabaseProductName() {
        if (StringUtil.isNotEmpty(this.connection.databaseProductName)) {
            return this.connection.databaseProductName;
        }
        if (this.connection.compatibleOracle()) {
            return "Oracle";
        }
        return "DM DBMS";
    }

    public String do_getDatabaseProductVersion() {
        return this.connection.do_getClientInfo("serverVersion");
    }

    public int do_getDatabaseMajorVersion() {
        if (this.connection.compatibleOracle()) {
            return 11;
        }
        String[] stringArray = this.connection.do_getClientInfo("serverVersion").split("\\.");
        return Integer.parseInt(stringArray[0]);
    }

    public int do_getDatabaseMinorVersion() {
        if (this.connection.compatibleOracle()) {
            return 1;
        }
        String[] stringArray = this.connection.do_getClientInfo("serverVersion").split("\\.");
        return Integer.parseInt(stringArray[1]);
    }

    public String do_getDriverName() {
        return DmDriver.class.getName();
    }

    public String do_getDriverVersion() {
        return "8.1.2.192";
    }

    public int do_getDriverMajorVersion() {
        String[] stringArray = this.do_getDriverVersion().split("\\.");
        return Integer.valueOf(stringArray[0]);
    }

    public int do_getDriverMinorVersion() {
        String[] stringArray = this.do_getDriverVersion().split("\\.");
        return Integer.valueOf(stringArray[1]);
    }

    public int do_getJDBCMajorVersion() {
        String[] stringArray = "4.0".split("\\.");
        return Integer.valueOf(stringArray[0]);
    }

    public int do_getJDBCMinorVersion() {
        String[] stringArray = "4.0".split("\\.");
        return Integer.valueOf(stringArray[1]);
    }

    public String do_getURL() {
        return this.connection.url;
    }

    public String do_getUserName() {
        return this.connection.user;
    }

    public DmdbConnection do_getConnection() {
        return this.connection;
    }

    public int do_getResultSetHoldability() {
        return 1;
    }

    public int do_getSQLStateType() {
        return 1;
    }

    public String do_getIdentifierQuoteString() {
        return "\"";
    }

    public String do_getSQLKeywords() {
        StringBuffer stringBuffer = new StringBuffer("");
        stringBuffer.append("BREAK,BROWSE,BULK,CHECKPOINT,CLUSTERED,COMMITTED,COMPUTE,");
        stringBuffer.append(" CONFIRM,CONTROLROW,DATABASE,DBCC,DISK,DISTRIBUTED,DUMMY,");
        stringBuffer.append(" DUMP,ERRLVL,ERROREXIT,EXIT,FILE,FILLFACTOR,FLOPPY,HOLDLOCK,");
        stringBuffer.append(" IDENTITY_INSERT,IDENTITYCOL,IF,KILL,LINENO,LOAD,MIRROREXIT,");
        stringBuffer.append("NONCLUSTERED,OFF,OFFSETS,ONCE,OVER,PERCENT,PERM,PERMANENT,PLAN, PRINT,");
        stringBuffer.append("AFTER,ASSIGN,AUDIT,BEFORE,BITMAP,CACHE,CALL,CHAIN,CLUSTER,CYCLE,");
        stringBuffer.append(" DATABASE, DATAFILE, DEBUG, #DECODE, #DELETING, DISABLE,");
        stringBuffer.append(" EACH,ELSEIF,END,EXCLUSIVE, EXIT,FILLFACTOR, FUNCTION,");
        stringBuffer.append(" HEXTORAW,IDENTIFIED,IF, IFNULL,INCREASE, INDEX, ");
        stringBuffer.append(" INITIAL,INTENTION,ISNULL,ISOPEN,MAXVALUE,");
        stringBuffer.append(" MINVALUE,MODIFY,NATURAL,NEW, NEXT, NOAUDIT, NOCACHE,NOCYCLE,");
        stringBuffer.append(" NOTFOUND,  NVL, OFF, OLD, OUT,PENDANT, PERCENT, PRINT, PRIOR,");
        stringBuffer.append("RAISE,RAWTOHEX,READ,RENAME,RETURN,REVERSE,ROLE,ROWCOUNT,ROWNUM,SAVEPOINT,SERIALIZABLE,");
        stringBuffer.append(" SEQUENCE, SHARE, STATEMENT,TIES, TIMESTAMPADD, TIMESTAMPDIFF,");
        stringBuffer.append("TOP,TRIGGER,TRIGGERS,TRUNCATE,TYPECAST,UNCOMMITTED,UNTIL,VSIZE,WHILE,LOGIN,");
        stringBuffer.append("EXTERNALLY,SESSION_PER_USER,CONNECT_IDLE_TIME,FAILED_LOGIN_ATTEMPS,");
        stringBuffer.append("PASSWORD_LIFE_TIME,PASSWORD_REUSE_TIME,PASSWORD_REUSE_MAX,");
        stringBuffer.append("PASSWORD_LOCK_TIME,PASSWORD_GRACE_TIME,POLICY,CATEGORY,UNLIMITED");
        return stringBuffer.toString();
    }

    public String do_getNumericFunctions() {
        return "ABS,ACOS,ASIN,ATAN,ATAN2,CEILING,COS,COT,DEGREES,EXP,FLOOR,LOG,LOG10,MOD,PI,POWER,RADIANS,RAND,ROUND,SIGN,SIN,SQRT,TAN,TRUNCATE,CEIL,COSH,LN,SINH,TANH";
    }

    public String do_getStringFunctions() {
        return "ASCII,CHAR,CONCAT,DIFFERENCE,INSERT,LCASE,LEFT,LENGTH,LOCATE,LTRIM,REPEAT,REPLACE,RIGHT,RTRIM,SOUNDEX,SPACE,UCASE,BIT_LENGTH,CHAR_LENGTH,CHARACTER_LENGTH,CHR,INITCAP,INSSTR,INSTR,INSTRB,LEFTSTR,LENGTHB,OCTET_LENGTH,LOWER,LPAD,POSITION,REPEATSTR,REVERSE,RIGHTSTR,RPAD,SUBSTR,SUBSTRB,TO_CHAR,TRANSLATE,TRIM,UPPER";
    }

    public String do_getSystemFunctions() {
        return "IFNULL,USER,CUR_DATABASE,DBID,EXTENT,PAGE,SESSID,UID,TABLEDEF,VSIZE,SET_TABLE_OPTION,SET_INDEX_OPTION,CFALGORITHMSENCRYPT,CFALGORITHMSDECRYPT,BFALGORITHMSENCRYPT,BFALGORITHMSDECRYPT,LABEL_TO_CHAR,LABEL_FROM_CHAR,LABEL_CMP,LABEL_STR_CMP";
    }

    public String do_getTimeDateFunctions() {
        return "CURDATE,CURTIME,DAYNAME,DAYOFMONTH,DAYOFWEEK,DAYOFYEAR,HOUR,MINUTE,MONTH,MONTHNAME,NOW,QUARTER,SECOND,TIMESTAMPADD,TIMESTAMPDIFF,WEEK,YEAR,ADD_DAYS,ADD_MONTHS,ADD_WEEKS,CURRENT_DATE,CURRENT_TIME,CURRENT_TIMESTAMP,DATEADD,DATEDIFF,DATEPART,DAYS_BETWEEN,EXTRACT,GETDATE,LAST_DAY,MONTHS_BETWEEN,NEXT_DAY,ROUND,SYSDATE,TO_DATE,TRUNC,WEEKDAY,YEARS_BETWEEN";
    }

    public String do_getSearchStringEscape() {
        return "!";
    }

    public String do_getExtraNameCharacters() {
        return "";
    }

    public int do_getMaxBinaryLiteralLength() {
        return Integer.MAX_VALUE;
    }

    public int do_getMaxCharLiteralLength() {
        return this.connection.maxRowSize;
    }

    public int do_getMaxColumnNameLength() {
        return 128;
    }

    public int do_getMaxColumnsInGroupBy() {
        return 64;
    }

    public int do_getMaxColumnsInIndex() {
        return 16;
    }

    public int do_getMaxColumnsInOrderBy() {
        return 64;
    }

    public int do_getMaxColumnsInSelect() {
        return 1024;
    }

    public int do_getMaxColumnsInTable() {
        return 1024;
    }

    public int do_getMaxConnections() {
        return this.connection.maxSession;
    }

    public int do_getMaxCursorNameLength() {
        return 128;
    }

    public int do_getMaxIndexLength() {
        return 1020;
    }

    public int do_getMaxSchemaNameLength() {
        return 128;
    }

    public int do_getMaxProcedureNameLength() {
        return 128;
    }

    public int do_getMaxCatalogNameLength() {
        return 0;
    }

    public int do_getMaxRowSize() {
        return 0;
    }

    public int do_getMaxStatementLength() {
        return 8000;
    }

    public int do_getMaxStatements() {
        return 128;
    }

    public int do_getMaxTableNameLength() {
        return 128;
    }

    public int do_getMaxTablesInSelect() {
        return 50;
    }

    public int do_getMaxUserNameLength() {
        return 128;
    }

    public int do_getDefaultTransactionIsolation() {
        return 2;
    }

    public String do_getSchemaTerm() {
        return "SCHEMA";
    }

    public String do_getProcedureTerm() {
        return "PROCEDURE";
    }

    public String do_getCatalogTerm() {
        return "CATALOG";
    }

    public String do_getCatalogSeparator() {
        return "";
    }

    public boolean do_isCatalogAtStart() {
        return false;
    }

    public boolean do_isReadOnly() {
        return this.connection.readOnly;
    }

    public boolean do_locatorsUpdateCopy() {
        return false;
    }

    public boolean do_nullsAreSortedHigh() {
        return false;
    }

    public boolean do_nullsAreSortedLow() {
        return true;
    }

    public boolean do_nullsAreSortedAtStart() {
        return false;
    }

    public boolean do_nullsAreSortedAtEnd() {
        return false;
    }

    public boolean do_nullPlusNonNullIsNull() {
        return true;
    }

    public boolean do_usesLocalFiles() {
        return false;
    }

    public boolean do_usesLocalFilePerTable() {
        return false;
    }

    public boolean do_storesUpperCaseIdentifiers() {
        return true;
    }

    public boolean do_storesLowerCaseIdentifiers() {
        return false;
    }

    public boolean do_storesMixedCaseIdentifiers() {
        return false;
    }

    public boolean do_storesUpperCaseQuotedIdentifiers() {
        return false;
    }

    public boolean do_storesLowerCaseQuotedIdentifiers() {
        return false;
    }

    public boolean do_storesMixedCaseQuotedIdentifiers() {
        return true;
    }

    public boolean do_supportsAlterTableWithAddColumn() {
        return true;
    }

    public boolean do_supportsAlterTableWithDropColumn() {
        return true;
    }

    public boolean do_supportsColumnAliasing() {
        return true;
    }

    public boolean do_supportsMixedCaseIdentifiers() {
        return false;
    }

    public boolean do_supportsMixedCaseQuotedIdentifiers() {
        return true;
    }

    public boolean do_supportsConvert() {
        return true;
    }

    public boolean do_supportsConvert(int n2, int n3) {
        boolean bl = false;
        if (n3 == 3 || n3 == 2 || n3 == -6 || n3 == 4 || n3 == 6 || n3 == 8 || n3 == 7 || n3 == 5 || n3 == -5 || n3 == 1 || n3 == 12 || n3 == -7 || n3 == 16 || n3 == -1) {
            switch (n2) {
                case -7: 
                case -6: 
                case -5: 
                case -1: 
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 12: 
                case 16: {
                    bl = true;
                    break;
                }
            }
            return bl;
        }
        if (n3 == 91) {
            switch (n2) {
                case -1: 
                case 0: 
                case 1: 
                case 12: 
                case 91: 
                case 93: 
                case 2005: {
                    bl = true;
                    break;
                }
            }
            return bl;
        }
        if (n3 == 92) {
            switch (n2) {
                case -1: 
                case 0: 
                case 1: 
                case 12: 
                case 92: 
                case 93: 
                case 2005: {
                    bl = true;
                    break;
                }
            }
            return bl;
        }
        if (n3 == 93) {
            switch (n2) {
                case -1: 
                case 0: 
                case 1: 
                case 12: 
                case 91: 
                case 92: 
                case 93: 
                case 2005: {
                    bl = true;
                    break;
                }
            }
            return bl;
        }
        if (n3 == 2004) {
            switch (n2) {
                case -4: 
                case 2004: {
                    bl = true;
                    break;
                }
            }
            return bl;
        }
        if (n3 == 2005) {
            switch (n2) {
                case -1: 
                case 2005: {
                    bl = true;
                    break;
                }
            }
            return bl;
        }
        return bl;
    }

    public boolean do_supportsTableCorrelationNames() {
        return true;
    }

    public boolean do_supportsDifferentTableCorrelationNames() {
        return true;
    }

    public boolean do_supportsExpressionsInOrderBy() {
        return true;
    }

    public boolean do_supportsOrderByUnrelated() {
        return true;
    }

    public boolean do_supportsGroupBy() {
        return true;
    }

    public boolean do_supportsGroupByUnrelated() {
        return true;
    }

    public boolean do_supportsGroupByBeyondSelect() {
        return true;
    }

    public boolean do_supportsLikeEscapeClause() {
        return true;
    }

    public boolean do_supportsMultipleResultSets() {
        return true;
    }

    public boolean do_supportsMultipleTransactions() {
        return true;
    }

    public boolean do_supportsNonNullableColumns() {
        return true;
    }

    public boolean do_supportsMinimumSQLGrammar() {
        return true;
    }

    public boolean do_supportsCoreSQLGrammar() {
        return true;
    }

    public boolean do_supportsExtendedSQLGrammar() {
        return true;
    }

    public boolean do_supportsANSI92EntryLevelSQL() {
        return true;
    }

    public boolean do_supportsANSI92IntermediateSQL() {
        return true;
    }

    public boolean do_supportsANSI92FullSQL() {
        return false;
    }

    public boolean do_supportsIntegrityEnhancementFacility() {
        return true;
    }

    public boolean do_supportsOuterJoins() {
        return true;
    }

    public boolean do_supportsFullOuterJoins() {
        return true;
    }

    public boolean do_supportsLimitedOuterJoins() {
        return true;
    }

    public boolean do_supportsSchemasInDataManipulation() {
        return true;
    }

    public boolean do_supportsSchemasInProcedureCalls() {
        return true;
    }

    public boolean do_supportsSchemasInTableDefinitions() {
        return true;
    }

    public boolean do_supportsSchemasInIndexDefinitions() {
        return true;
    }

    public boolean do_supportsSchemasInPrivilegeDefinitions() {
        return true;
    }

    public boolean do_supportsCatalogsInDataManipulation() {
        return false;
    }

    public boolean do_supportsCatalogsInProcedureCalls() {
        return false;
    }

    public boolean do_supportsCatalogsInTableDefinitions() {
        return false;
    }

    public boolean do_supportsCatalogsInIndexDefinitions() {
        return false;
    }

    public boolean do_supportsCatalogsInPrivilegeDefinitions() {
        return false;
    }

    public boolean do_supportsPositionedDelete() {
        return true;
    }

    public boolean do_supportsPositionedUpdate() {
        return true;
    }

    public boolean do_supportsSelectForUpdate() {
        return true;
    }

    public boolean do_supportsStoredProcedures() {
        return true;
    }

    public boolean do_supportsSubqueriesInComparisons() {
        return true;
    }

    public boolean do_supportsSubqueriesInExists() {
        return true;
    }

    public boolean do_supportsSubqueriesInIns() {
        return true;
    }

    public boolean do_supportsSubqueriesInQuantifieds() {
        return true;
    }

    public boolean do_supportsCorrelatedSubqueries() {
        return true;
    }

    public boolean do_supportsUnion() {
        return true;
    }

    public boolean do_supportsUnionAll() {
        return true;
    }

    public boolean do_supportsOpenCursorsAcrossCommit() {
        return true;
    }

    public boolean do_supportsOpenCursorsAcrossRollback() {
        return true;
    }

    public boolean do_supportsOpenStatementsAcrossCommit() {
        return true;
    }

    public boolean do_supportsOpenStatementsAcrossRollback() {
        return true;
    }

    public boolean do_supportsTransactions() {
        return true;
    }

    public boolean do_supportsTransactionIsolationLevel(int n2) {
        return n2 == 2 || n2 == 1 || n2 == 4 || n2 == 8;
    }

    public boolean do_supportsDataDefinitionAndDataManipulationTransactions() {
        return !this.connection.ddlAutoCommit;
    }

    public boolean do_supportsDataManipulationTransactionsOnly() {
        return this.connection.ddlAutoCommit;
    }

    public boolean do_supportsResultSetType(int n2) {
        return n2 == 1003 || n2 == 1004;
    }

    public boolean do_supportsResultSetConcurrency(int n2, int n3) {
        return true;
    }

    public boolean do_supportsBatchUpdates() {
        return true;
    }

    public boolean do_supportsSavepoints() {
        return true;
    }

    public boolean do_supportsNamedParameters() {
        return true;
    }

    public boolean do_supportsMultipleOpenResults() {
        return false;
    }

    public boolean do_supportsGetGeneratedKeys() {
        return true;
    }

    public boolean do_supportsResultSetHoldability(int n2) {
        return n2 == 2 || n2 == 1;
    }

    public boolean do_supportsStatementPooling() {
        return true;
    }

    public boolean do_supportsStoredFunctionsUsingCallSyntax() {
        return true;
    }

    public boolean do_ownUpdatesAreVisible(int n2) {
        return false;
    }

    public boolean do_ownDeletesAreVisible(int n2) {
        return false;
    }

    public boolean do_ownInsertsAreVisible(int n2) {
        return false;
    }

    public boolean do_othersUpdatesAreVisible(int n2) {
        return false;
    }

    public boolean do_othersDeletesAreVisible(int n2) {
        return false;
    }

    public boolean do_othersInsertsAreVisible(int n2) {
        return false;
    }

    public boolean do_updatesAreDetected(int n2) {
        return false;
    }

    public boolean do_deletesAreDetected(int n2) {
        return false;
    }

    public boolean do_insertsAreDetected(int n2) {
        return false;
    }

    public boolean do_doesMaxRowSizeIncludeBlobs() {
        return false;
    }

    public DmdbResultSet do_getPseudoColumns(String string, String string2, String string3, String string4) {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwz(new Object[0]);
        return null;
    }

    public boolean do_generatedKeyAlwaysReturned() {
        return false;
    }

    public long do_getMaxLogicalLobSize() {
        return Integer.MAX_VALUE;
    }

    public boolean do_supportsRefCursors() {
        return true;
    }

    public RowIdLifetime do_getRowIdLifetime() {
        return RowIdLifetime.ROWID_VALID_FOREVER;
    }

    @Override
    public boolean allProceduresAreCallable() {
        if (this.filterChain == null) {
            return this.do_allProceduresAreCallable();
        }
        return this.filterChain.reset().DatabaseMetaData_allProceduresAreCallable(this);
    }

    @Override
    public boolean allTablesAreSelectable() {
        if (this.filterChain == null) {
            return this.do_allTablesAreSelectable();
        }
        return this.filterChain.reset().DatabaseMetaData_allTablesAreSelectable(this);
    }

    @Override
    public String getURL() {
        if (this.filterChain == null) {
            return this.do_getURL();
        }
        return this.filterChain.reset().DatabaseMetaData_getURL(this);
    }

    @Override
    public String getUserName() {
        if (this.filterChain == null) {
            return this.do_getUserName();
        }
        return this.filterChain.reset().DatabaseMetaData_getUserName(this);
    }

    @Override
    public boolean isReadOnly() {
        if (this.filterChain == null) {
            return this.do_isReadOnly();
        }
        return this.filterChain.reset().DatabaseMetaData_isReadOnly(this);
    }

    @Override
    public boolean nullsAreSortedHigh() {
        if (this.filterChain == null) {
            return this.do_nullsAreSortedHigh();
        }
        return this.filterChain.reset().DatabaseMetaData_nullsAreSortedHigh(this);
    }

    @Override
    public boolean nullsAreSortedLow() {
        if (this.filterChain == null) {
            return this.do_nullsAreSortedLow();
        }
        return this.filterChain.reset().DatabaseMetaData_nullsAreSortedLow(this);
    }

    @Override
    public boolean nullsAreSortedAtStart() {
        if (this.filterChain == null) {
            return this.do_nullsAreSortedAtStart();
        }
        return this.filterChain.reset().DatabaseMetaData_nullsAreSortedAtStart(this);
    }

    @Override
    public boolean nullsAreSortedAtEnd() {
        if (this.filterChain == null) {
            return this.do_nullsAreSortedAtEnd();
        }
        return this.filterChain.reset().DatabaseMetaData_nullsAreSortedAtEnd(this);
    }

    @Override
    public String getDatabaseProductName() {
        if (this.filterChain == null) {
            return this.do_getDatabaseProductName();
        }
        return this.filterChain.reset().DatabaseMetaData_getDatabaseProductName(this);
    }

    @Override
    public String getDatabaseProductVersion() {
        if (this.filterChain == null) {
            return this.do_getDatabaseProductVersion();
        }
        return this.filterChain.reset().DatabaseMetaData_getDatabaseProductVersion(this);
    }

    @Override
    public String getDriverName() {
        if (this.filterChain == null) {
            return this.do_getDriverName();
        }
        return this.filterChain.reset().DatabaseMetaData_getDriverName(this);
    }

    @Override
    public String getDriverVersion() {
        if (this.filterChain == null) {
            return this.do_getDriverVersion();
        }
        return this.filterChain.reset().DatabaseMetaData_getDriverVersion(this);
    }

    @Override
    public int getDriverMajorVersion() {
        if (this.filterChain == null) {
            return this.do_getDriverMajorVersion();
        }
        return this.filterChain.reset().DatabaseMetaData_getDriverMajorVersion(this);
    }

    @Override
    public int getDriverMinorVersion() {
        if (this.filterChain == null) {
            return this.do_getDriverMinorVersion();
        }
        return this.filterChain.reset().DatabaseMetaData_getDriverMinorVersion(this);
    }

    @Override
    public boolean usesLocalFiles() {
        if (this.filterChain == null) {
            return this.do_usesLocalFiles();
        }
        return this.filterChain.reset().DatabaseMetaData_usesLocalFiles(this);
    }

    @Override
    public boolean usesLocalFilePerTable() {
        if (this.filterChain == null) {
            return this.do_usesLocalFilePerTable();
        }
        return this.filterChain.reset().DatabaseMetaData_usesLocalFilePerTable(this);
    }

    @Override
    public boolean supportsMixedCaseIdentifiers() {
        if (this.filterChain == null) {
            return this.do_supportsMixedCaseIdentifiers();
        }
        return this.filterChain.reset().DatabaseMetaData_supportsMixedCaseIdentifiers(this);
    }

    @Override
    public boolean storesUpperCaseIdentifiers() {
        if (this.filterChain == null) {
            return this.do_storesUpperCaseIdentifiers();
        }
        return this.filterChain.reset().DatabaseMetaData_storesUpperCaseIdentifiers(this);
    }

    @Override
    public boolean storesLowerCaseIdentifiers() {
        if (this.filterChain == null) {
            return this.do_storesLowerCaseIdentifiers();
        }
        return this.filterChain.reset().DatabaseMetaData_storesLowerCaseIdentifiers(this);
    }

    @Override
    public boolean storesMixedCaseIdentifiers() {
        if (this.filterChain == null) {
            return this.do_storesMixedCaseIdentifiers();
        }
        return this.filterChain.reset().DatabaseMetaData_storesMixedCaseIdentifiers(this);
    }

    @Override
    public boolean supportsMixedCaseQuotedIdentifiers() {
        if (this.filterChain == null) {
            return this.do_supportsMixedCaseQuotedIdentifiers();
        }
        return this.filterChain.reset().DatabaseMetaData_supportsMixedCaseQuotedIdentifiers(this);
    }

    @Override
    public boolean storesUpperCaseQuotedIdentifiers() {
        if (this.filterChain == null) {
            return this.do_storesUpperCaseQuotedIdentifiers();
        }
        return this.filterChain.reset().DatabaseMetaData_storesUpperCaseQuotedIdentifiers(this);
    }

    @Override
    public boolean storesLowerCaseQuotedIdentifiers() {
        if (this.filterChain == null) {
            return this.do_storesLowerCaseQuotedIdentifiers();
        }
        return this.filterChain.reset().DatabaseMetaData_storesLowerCaseQuotedIdentifiers(this);
    }

    @Override
    public boolean storesMixedCaseQuotedIdentifiers() {
        if (this.filterChain == null) {
            return this.do_storesMixedCaseQuotedIdentifiers();
        }
        return this.filterChain.reset().DatabaseMetaData_storesMixedCaseQuotedIdentifiers(this);
    }

    @Override
    public String getIdentifierQuoteString() {
        if (this.filterChain == null) {
            return this.do_getIdentifierQuoteString();
        }
        return this.filterChain.reset().DatabaseMetaData_getIdentifierQuoteString(this);
    }

    @Override
    public String getSQLKeywords() {
        if (this.filterChain == null) {
            return this.do_getSQLKeywords();
        }
        return this.filterChain.reset().DatabaseMetaData_getSQLKeywords(this);
    }

    @Override
    public String getNumericFunctions() {
        if (this.filterChain == null) {
            return this.do_getNumericFunctions();
        }
        return this.filterChain.reset().DatabaseMetaData_getNumericFunctions(this);
    }

    @Override
    public String getStringFunctions() {
        if (this.filterChain == null) {
            return this.do_getStringFunctions();
        }
        return this.filterChain.reset().DatabaseMetaData_getStringFunctions(this);
    }

    @Override
    public String getSystemFunctions() {
        if (this.filterChain == null) {
            return this.do_getSystemFunctions();
        }
        return this.filterChain.reset().DatabaseMetaData_getSystemFunctions(this);
    }

    @Override
    public String getTimeDateFunctions() {
        if (this.filterChain == null) {
            return this.do_getTimeDateFunctions();
        }
        return this.filterChain.reset().DatabaseMetaData_getTimeDateFunctions(this);
    }

    @Override
    public String getSearchStringEscape() {
        if (this.filterChain == null) {
            return this.do_getSearchStringEscape();
        }
        return this.filterChain.reset().DatabaseMetaData_getSearchStringEscape(this);
    }

    @Override
    public String getExtraNameCharacters() {
        if (this.filterChain == null) {
            return this.do_getExtraNameCharacters();
        }
        return this.filterChain.reset().DatabaseMetaData_getExtraNameCharacters(this);
    }

    @Override
    public boolean supportsAlterTableWithAddColumn() {
        if (this.filterChain == null) {
            return this.do_supportsAlterTableWithAddColumn();
        }
        return this.filterChain.reset().DatabaseMetaData_supportsAlterTableWithAddColumn(this);
    }

    @Override
    public boolean supportsAlterTableWithDropColumn() {
        if (this.filterChain == null) {
            return this.do_supportsAlterTableWithDropColumn();
        }
        return this.filterChain.reset().DatabaseMetaData_supportsAlterTableWithDropColumn(this);
    }

    @Override
    public boolean supportsColumnAliasing() {
        if (this.filterChain == null) {
            return this.do_supportsColumnAliasing();
        }
        return this.filterChain.reset().DatabaseMetaData_supportsColumnAliasing(this);
    }

    @Override
    public boolean nullPlusNonNullIsNull() {
        if (this.filterChain == null) {
            return this.do_nullPlusNonNullIsNull();
        }
        return this.filterChain.reset().DatabaseMetaData_nullPlusNonNullIsNull(this);
    }

    @Override
    public boolean supportsConvert() {
        if (this.filterChain == null) {
            return this.do_supportsConvert();
        }
        return this.filterChain.reset().DatabaseMetaData_supportsConvert(this);
    }

    @Override
    public boolean supportsConvert(int n2, int n3) {
        if (this.filterChain == null) {
            return this.do_supportsConvert(n2, n3);
        }
        return this.filterChain.reset().DatabaseMetaData_supportsConvert(this, n2, n3);
    }

    @Override
    public boolean supportsTableCorrelationNames() {
        if (this.filterChain == null) {
            return this.do_supportsTableCorrelationNames();
        }
        return this.filterChain.reset().DatabaseMetaData_supportsTableCorrelationNames(this);
    }

    @Override
    public boolean supportsDifferentTableCorrelationNames() {
        if (this.filterChain == null) {
            return this.do_supportsDifferentTableCorrelationNames();
        }
        return this.filterChain.reset().DatabaseMetaData_supportsDifferentTableCorrelationNames(this);
    }

    @Override
    public boolean supportsExpressionsInOrderBy() {
        if (this.filterChain == null) {
            return this.do_supportsExpressionsInOrderBy();
        }
        return this.filterChain.reset().DatabaseMetaData_supportsExpressionsInOrderBy(this);
    }

    @Override
    public boolean supportsOrderByUnrelated() {
        if (this.filterChain == null) {
            return this.do_supportsOrderByUnrelated();
        }
        return this.filterChain.reset().DatabaseMetaData_supportsOrderByUnrelated(this);
    }

    @Override
    public boolean supportsGroupBy() {
        if (this.filterChain == null) {
            return this.do_supportsGroupBy();
        }
        return this.filterChain.reset().DatabaseMetaData_supportsGroupBy(this);
    }

    @Override
    public boolean supportsGroupByUnrelated() {
        if (this.filterChain == null) {
            return this.do_supportsGroupByUnrelated();
        }
        return this.filterChain.reset().DatabaseMetaData_supportsGroupByUnrelated(this);
    }

    @Override
    public boolean supportsGroupByBeyondSelect() {
        if (this.filterChain == null) {
            return this.do_supportsGroupByBeyondSelect();
        }
        return this.filterChain.reset().DatabaseMetaData_supportsGroupByBeyondSelect(this);
    }

    @Override
    public boolean supportsLikeEscapeClause() {
        if (this.filterChain == null) {
            return this.do_supportsLikeEscapeClause();
        }
        return this.filterChain.reset().DatabaseMetaData_supportsLikeEscapeClause(this);
    }

    @Override
    public boolean supportsMultipleResultSets() {
        if (this.filterChain == null) {
            return this.do_supportsMultipleResultSets();
        }
        return this.filterChain.reset().DatabaseMetaData_supportsMultipleResultSets(this);
    }

    @Override
    public boolean supportsMultipleTransactions() {
        if (this.filterChain == null) {
            return this.do_supportsMultipleTransactions();
        }
        return this.filterChain.reset().DatabaseMetaData_supportsMultipleTransactions(this);
    }

    @Override
    public boolean supportsNonNullableColumns() {
        if (this.filterChain == null) {
            return this.do_supportsNonNullableColumns();
        }
        return this.filterChain.reset().DatabaseMetaData_supportsNonNullableColumns(this);
    }

    @Override
    public boolean supportsMinimumSQLGrammar() {
        if (this.filterChain == null) {
            return this.do_supportsMinimumSQLGrammar();
        }
        return this.filterChain.reset().DatabaseMetaData_supportsMinimumSQLGrammar(this);
    }

    @Override
    public boolean supportsCoreSQLGrammar() {
        if (this.filterChain == null) {
            return this.do_supportsCoreSQLGrammar();
        }
        return this.filterChain.reset().DatabaseMetaData_supportsCoreSQLGrammar(this);
    }

    @Override
    public boolean supportsExtendedSQLGrammar() {
        if (this.filterChain == null) {
            return this.do_supportsExtendedSQLGrammar();
        }
        return this.filterChain.reset().DatabaseMetaData_supportsExtendedSQLGrammar(this);
    }

    @Override
    public boolean supportsANSI92EntryLevelSQL() {
        if (this.filterChain == null) {
            return this.do_supportsANSI92EntryLevelSQL();
        }
        return this.filterChain.reset().DatabaseMetaData_supportsANSI92EntryLevelSQL(this);
    }

    @Override
    public boolean supportsANSI92IntermediateSQL() {
        if (this.filterChain == null) {
            return this.do_supportsANSI92IntermediateSQL();
        }
        return this.filterChain.reset().DatabaseMetaData_supportsANSI92IntermediateSQL(this);
    }

    @Override
    public boolean supportsANSI92FullSQL() {
        if (this.filterChain == null) {
            return this.do_supportsANSI92FullSQL();
        }
        return this.filterChain.reset().DatabaseMetaData_supportsANSI92FullSQL(this);
    }

    @Override
    public boolean supportsIntegrityEnhancementFacility() {
        if (this.filterChain == null) {
            return this.do_supportsIntegrityEnhancementFacility();
        }
        return this.filterChain.reset().DatabaseMetaData_supportsIntegrityEnhancementFacility(this);
    }

    @Override
    public boolean supportsOuterJoins() {
        if (this.filterChain == null) {
            return this.do_supportsOuterJoins();
        }
        return this.filterChain.reset().DatabaseMetaData_supportsOuterJoins(this);
    }

    @Override
    public boolean supportsFullOuterJoins() {
        if (this.filterChain == null) {
            return this.do_supportsFullOuterJoins();
        }
        return this.filterChain.reset().DatabaseMetaData_supportsFullOuterJoins(this);
    }

    @Override
    public boolean supportsLimitedOuterJoins() {
        if (this.filterChain == null) {
            return this.do_supportsLimitedOuterJoins();
        }
        return this.filterChain.reset().DatabaseMetaData_supportsLimitedOuterJoins(this);
    }

    @Override
    public String getSchemaTerm() {
        if (this.filterChain == null) {
            return this.do_getSchemaTerm();
        }
        return this.filterChain.reset().DatabaseMetaData_getSchemaTerm(this);
    }

    @Override
    public String getProcedureTerm() {
        if (this.filterChain == null) {
            return this.do_getProcedureTerm();
        }
        return this.filterChain.reset().DatabaseMetaData_getProcedureTerm(this);
    }

    @Override
    public String getCatalogTerm() {
        if (this.filterChain == null) {
            return this.do_getCatalogTerm();
        }
        return this.filterChain.reset().DatabaseMetaData_getCatalogTerm(this);
    }

    @Override
    public boolean isCatalogAtStart() {
        if (this.filterChain == null) {
            return this.do_isCatalogAtStart();
        }
        return this.filterChain.reset().DatabaseMetaData_isCatalogAtStart(this);
    }

    @Override
    public String getCatalogSeparator() {
        if (this.filterChain == null) {
            return this.do_getCatalogSeparator();
        }
        return this.filterChain.reset().DatabaseMetaData_getCatalogSeparator(this);
    }

    @Override
    public boolean supportsSchemasInDataManipulation() {
        if (this.filterChain == null) {
            return this.do_supportsSchemasInDataManipulation();
        }
        return this.filterChain.reset().DatabaseMetaData_supportsSchemasInDataManipulation(this);
    }

    @Override
    public boolean supportsSchemasInProcedureCalls() {
        if (this.filterChain == null) {
            return this.do_supportsSchemasInProcedureCalls();
        }
        return this.filterChain.reset().DatabaseMetaData_supportsSchemasInProcedureCalls(this);
    }

    @Override
    public boolean supportsSchemasInTableDefinitions() {
        if (this.filterChain == null) {
            return this.do_supportsSchemasInTableDefinitions();
        }
        return this.filterChain.reset().DatabaseMetaData_supportsSchemasInTableDefinitions(this);
    }

    @Override
    public boolean supportsSchemasInIndexDefinitions() {
        if (this.filterChain == null) {
            return this.do_supportsSchemasInIndexDefinitions();
        }
        return this.filterChain.reset().DatabaseMetaData_supportsSchemasInIndexDefinitions(this);
    }

    @Override
    public boolean supportsSchemasInPrivilegeDefinitions() {
        if (this.filterChain == null) {
            return this.do_supportsSchemasInPrivilegeDefinitions();
        }
        return this.filterChain.reset().DatabaseMetaData_supportsSchemasInPrivilegeDefinitions(this);
    }

    @Override
    public boolean supportsCatalogsInDataManipulation() {
        if (this.filterChain == null) {
            return this.do_supportsCatalogsInDataManipulation();
        }
        return this.filterChain.reset().DatabaseMetaData_supportsCatalogsInDataManipulation(this);
    }

    @Override
    public boolean supportsCatalogsInProcedureCalls() {
        if (this.filterChain == null) {
            return this.do_supportsCatalogsInProcedureCalls();
        }
        return this.filterChain.reset().DatabaseMetaData_supportsCatalogsInProcedureCalls(this);
    }

    @Override
    public boolean supportsCatalogsInTableDefinitions() {
        if (this.filterChain == null) {
            return this.do_supportsCatalogsInTableDefinitions();
        }
        return this.filterChain.reset().DatabaseMetaData_supportsCatalogsInTableDefinitions(this);
    }

    @Override
    public boolean supportsCatalogsInIndexDefinitions() {
        if (this.filterChain == null) {
            return this.do_supportsCatalogsInIndexDefinitions();
        }
        return this.filterChain.reset().DatabaseMetaData_supportsCatalogsInIndexDefinitions(this);
    }

    @Override
    public boolean supportsCatalogsInPrivilegeDefinitions() {
        if (this.filterChain == null) {
            return this.do_supportsCatalogsInPrivilegeDefinitions();
        }
        return this.filterChain.reset().DatabaseMetaData_supportsCatalogsInPrivilegeDefinitions(this);
    }

    @Override
    public boolean supportsPositionedDelete() {
        if (this.filterChain == null) {
            return this.do_supportsPositionedDelete();
        }
        return this.filterChain.reset().DatabaseMetaData_supportsPositionedDelete(this);
    }

    @Override
    public boolean supportsPositionedUpdate() {
        if (this.filterChain == null) {
            return this.do_supportsPositionedUpdate();
        }
        return this.filterChain.reset().DatabaseMetaData_supportsPositionedUpdate(this);
    }

    @Override
    public boolean supportsSelectForUpdate() {
        if (this.filterChain == null) {
            return this.do_supportsSelectForUpdate();
        }
        return this.filterChain.reset().DatabaseMetaData_supportsSelectForUpdate(this);
    }

    @Override
    public boolean supportsStoredProcedures() {
        if (this.filterChain == null) {
            return this.do_supportsStoredProcedures();
        }
        return this.filterChain.reset().DatabaseMetaData_supportsStoredProcedures(this);
    }

    @Override
    public boolean supportsSubqueriesInComparisons() {
        if (this.filterChain == null) {
            return this.do_supportsSubqueriesInComparisons();
        }
        return this.filterChain.reset().DatabaseMetaData_supportsSubqueriesInComparisons(this);
    }

    @Override
    public boolean supportsSubqueriesInExists() {
        if (this.filterChain == null) {
            return this.do_supportsSubqueriesInExists();
        }
        return this.filterChain.reset().DatabaseMetaData_supportsSubqueriesInExists(this);
    }

    @Override
    public boolean supportsSubqueriesInIns() {
        if (this.filterChain == null) {
            return this.do_supportsSubqueriesInIns();
        }
        return this.filterChain.reset().DatabaseMetaData_supportsSubqueriesInIns(this);
    }

    @Override
    public boolean supportsSubqueriesInQuantifieds() {
        if (this.filterChain == null) {
            return this.do_supportsSubqueriesInQuantifieds();
        }
        return this.filterChain.reset().DatabaseMetaData_supportsSubqueriesInQuantifieds(this);
    }

    @Override
    public boolean supportsCorrelatedSubqueries() {
        if (this.filterChain == null) {
            return this.do_supportsCorrelatedSubqueries();
        }
        return this.filterChain.reset().DatabaseMetaData_supportsCorrelatedSubqueries(this);
    }

    @Override
    public boolean supportsUnion() {
        if (this.filterChain == null) {
            return this.do_supportsUnion();
        }
        return this.filterChain.reset().DatabaseMetaData_supportsUnion(this);
    }

    @Override
    public boolean supportsUnionAll() {
        if (this.filterChain == null) {
            return this.do_supportsUnionAll();
        }
        return this.filterChain.reset().DatabaseMetaData_supportsUnionAll(this);
    }

    @Override
    public boolean supportsOpenCursorsAcrossCommit() {
        if (this.filterChain == null) {
            return this.do_supportsOpenCursorsAcrossCommit();
        }
        return this.filterChain.reset().DatabaseMetaData_supportsOpenCursorsAcrossCommit(this);
    }

    @Override
    public boolean supportsOpenCursorsAcrossRollback() {
        if (this.filterChain == null) {
            return this.do_supportsOpenCursorsAcrossRollback();
        }
        return this.filterChain.reset().DatabaseMetaData_supportsOpenCursorsAcrossRollback(this);
    }

    @Override
    public boolean supportsOpenStatementsAcrossCommit() {
        if (this.filterChain == null) {
            return this.do_supportsOpenStatementsAcrossCommit();
        }
        return this.filterChain.reset().DatabaseMetaData_supportsOpenStatementsAcrossCommit(this);
    }

    @Override
    public boolean supportsOpenStatementsAcrossRollback() {
        if (this.filterChain == null) {
            return this.do_supportsOpenStatementsAcrossRollback();
        }
        return this.filterChain.reset().DatabaseMetaData_supportsOpenStatementsAcrossRollback(this);
    }

    @Override
    public int getMaxBinaryLiteralLength() {
        if (this.filterChain == null) {
            return this.do_getMaxBinaryLiteralLength();
        }
        return this.filterChain.reset().DatabaseMetaData_getMaxBinaryLiteralLength(this);
    }

    @Override
    public int getMaxCharLiteralLength() {
        if (this.filterChain == null) {
            return this.do_getMaxCharLiteralLength();
        }
        return this.filterChain.reset().DatabaseMetaData_getMaxCharLiteralLength(this);
    }

    @Override
    public int getMaxColumnNameLength() {
        if (this.filterChain == null) {
            return this.do_getMaxColumnNameLength();
        }
        return this.filterChain.reset().DatabaseMetaData_getMaxColumnNameLength(this);
    }

    @Override
    public int getMaxColumnsInGroupBy() {
        if (this.filterChain == null) {
            return this.do_getMaxColumnsInGroupBy();
        }
        return this.filterChain.reset().DatabaseMetaData_getMaxColumnsInGroupBy(this);
    }

    @Override
    public int getMaxColumnsInIndex() {
        if (this.filterChain == null) {
            return this.do_getMaxColumnsInIndex();
        }
        return this.filterChain.reset().DatabaseMetaData_getMaxColumnsInIndex(this);
    }

    @Override
    public int getMaxColumnsInOrderBy() {
        if (this.filterChain == null) {
            return this.do_getMaxColumnsInOrderBy();
        }
        return this.filterChain.reset().DatabaseMetaData_getMaxColumnsInOrderBy(this);
    }

    @Override
    public int getMaxColumnsInSelect() {
        if (this.filterChain == null) {
            return this.do_getMaxColumnsInSelect();
        }
        return this.filterChain.reset().DatabaseMetaData_getMaxColumnsInSelect(this);
    }

    @Override
    public int getMaxColumnsInTable() {
        if (this.filterChain == null) {
            return this.do_getMaxColumnsInTable();
        }
        return this.filterChain.reset().DatabaseMetaData_getMaxColumnsInTable(this);
    }

    @Override
    public int getMaxConnections() {
        if (this.filterChain == null) {
            return this.do_getMaxConnections();
        }
        return this.filterChain.reset().DatabaseMetaData_getMaxConnections(this);
    }

    @Override
    public int getMaxCursorNameLength() {
        if (this.filterChain == null) {
            return this.do_getMaxCursorNameLength();
        }
        return this.filterChain.reset().DatabaseMetaData_getMaxCursorNameLength(this);
    }

    @Override
    public int getMaxIndexLength() {
        if (this.filterChain == null) {
            return this.do_getMaxIndexLength();
        }
        return this.filterChain.reset().DatabaseMetaData_getMaxIndexLength(this);
    }

    @Override
    public int getMaxSchemaNameLength() {
        if (this.filterChain == null) {
            return this.do_getMaxSchemaNameLength();
        }
        return this.filterChain.reset().DatabaseMetaData_getMaxSchemaNameLength(this);
    }

    @Override
    public int getMaxProcedureNameLength() {
        if (this.filterChain == null) {
            return this.do_getMaxProcedureNameLength();
        }
        return this.filterChain.reset().DatabaseMetaData_getMaxProcedureNameLength(this);
    }

    @Override
    public int getMaxCatalogNameLength() {
        if (this.filterChain == null) {
            return this.do_getMaxCatalogNameLength();
        }
        return this.filterChain.reset().DatabaseMetaData_getMaxCatalogNameLength(this);
    }

    @Override
    public int getMaxRowSize() {
        if (this.filterChain == null) {
            return this.do_getMaxRowSize();
        }
        return this.filterChain.reset().DatabaseMetaData_getMaxRowSize(this);
    }

    @Override
    public boolean doesMaxRowSizeIncludeBlobs() {
        if (this.filterChain == null) {
            return this.do_doesMaxRowSizeIncludeBlobs();
        }
        return this.filterChain.reset().DatabaseMetaData_doesMaxRowSizeIncludeBlobs(this);
    }

    @Override
    public int getMaxStatementLength() {
        if (this.filterChain == null) {
            return this.do_getMaxStatementLength();
        }
        return this.filterChain.reset().DatabaseMetaData_getMaxStatementLength(this);
    }

    @Override
    public int getMaxStatements() {
        if (this.filterChain == null) {
            return this.do_getMaxStatements();
        }
        return this.filterChain.reset().DatabaseMetaData_getMaxStatements(this);
    }

    @Override
    public int getMaxTableNameLength() {
        if (this.filterChain == null) {
            return this.do_getMaxTableNameLength();
        }
        return this.filterChain.reset().DatabaseMetaData_getMaxTableNameLength(this);
    }

    @Override
    public int getMaxTablesInSelect() {
        if (this.filterChain == null) {
            return this.do_getMaxTablesInSelect();
        }
        return this.filterChain.reset().DatabaseMetaData_getMaxTablesInSelect(this);
    }

    @Override
    public int getMaxUserNameLength() {
        if (this.filterChain == null) {
            return this.do_getMaxUserNameLength();
        }
        return this.filterChain.reset().DatabaseMetaData_getMaxUserNameLength(this);
    }

    @Override
    public int getDefaultTransactionIsolation() {
        if (this.filterChain == null) {
            return this.do_getDefaultTransactionIsolation();
        }
        return this.filterChain.reset().DatabaseMetaData_getDefaultTransactionIsolation(this);
    }

    @Override
    public boolean supportsTransactions() {
        if (this.filterChain == null) {
            return this.do_supportsTransactions();
        }
        return this.filterChain.reset().DatabaseMetaData_supportsTransactions(this);
    }

    @Override
    public boolean supportsTransactionIsolationLevel(int n2) {
        if (this.filterChain == null) {
            return this.do_supportsTransactionIsolationLevel(n2);
        }
        return this.filterChain.reset().DatabaseMetaData_supportsTransactionIsolationLevel(this, n2);
    }

    @Override
    public boolean supportsDataDefinitionAndDataManipulationTransactions() {
        if (this.filterChain == null) {
            return this.do_supportsDataDefinitionAndDataManipulationTransactions();
        }
        return this.filterChain.reset().DatabaseMetaData_supportsDataDefinitionAndDataManipulationTransactions(this);
    }

    @Override
    public boolean supportsDataManipulationTransactionsOnly() {
        if (this.filterChain == null) {
            return this.do_supportsDataManipulationTransactionsOnly();
        }
        return this.filterChain.reset().DatabaseMetaData_supportsDataManipulationTransactionsOnly(this);
    }

    @Override
    public boolean dataDefinitionCausesTransactionCommit() {
        if (this.filterChain == null) {
            return this.do_dataDefinitionCausesTransactionCommit();
        }
        return this.filterChain.reset().DatabaseMetaData_dataDefinitionCausesTransactionCommit(this);
    }

    @Override
    public boolean dataDefinitionIgnoredInTransactions() {
        if (this.filterChain == null) {
            return this.do_dataDefinitionIgnoredInTransactions();
        }
        return this.filterChain.reset().DatabaseMetaData_dataDefinitionIgnoredInTransactions(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getProcedures(String string, String string2, String string3) {
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getProcedures(string, string2, string3);
            }
            return this.filterChain.reset().DatabaseMetaData_getProcedures(this, string, string2, string3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getProcedureColumns(String string, String string2, String string3, String string4) {
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getProcedureColumns(string, string2, string3, string4);
            }
            return this.filterChain.reset().DatabaseMetaData_getProcedureColumns(this, string, string2, string3, string4);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getTables(String string, String string2, String string3, String[] stringArray) {
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getTables(string, string2, string3, stringArray);
            }
            return this.filterChain.reset().DatabaseMetaData_getTables(this, string, string2, string3, stringArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getSchemas() {
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getSchemas();
            }
            return this.filterChain.reset().DatabaseMetaData_getSchemas(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getCatalogs() {
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getCatalogs();
            }
            return this.filterChain.reset().DatabaseMetaData_getCatalogs(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getTableTypes() {
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getTableTypes();
            }
            return this.filterChain.reset().DatabaseMetaData_getTableTypes(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getColumns(String string, String string2, String string3, String string4) {
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getColumns(string, string2, string3, string4);
            }
            return this.filterChain.reset().DatabaseMetaData_getColumns(this, string, string2, string3, string4);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getColumnPrivileges(String string, String string2, String string3, String string4) {
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getColumnPrivileges(string, string2, string3, string4);
            }
            return this.filterChain.reset().DatabaseMetaData_getColumnPrivileges(this, string, string2, string3, string4);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getTablePrivileges(String string, String string2, String string3) {
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getTablePrivileges(string, string2, string3);
            }
            return this.filterChain.reset().DatabaseMetaData_getTablePrivileges(this, string, string2, string3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getBestRowIdentifier(String string, String string2, String string3, int n2, boolean bl) {
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            DmdbConnection dmdbConnection2 = this.connection;
            synchronized (dmdbConnection2) {
                if (this.filterChain == null) {
                    return this.do_getBestRowIdentifier(string, string2, string3, n2, bl);
                }
                return this.filterChain.reset().DatabaseMetaData_getBestRowIdentifier(this, string, string2, string3, n2, bl);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getVersionColumns(String string, String string2, String string3) {
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getVersionColumns(string, string2, string3);
            }
            return this.filterChain.reset().DatabaseMetaData_getVersionColumns(this, string, string2, string3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getPrimaryKeys(String string, String string2, String string3) {
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getPrimaryKeys(string, string2, string3);
            }
            return this.filterChain.reset().DatabaseMetaData_getPrimaryKeys(this, string, string2, string3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getImportedKeys(String string, String string2, String string3) {
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getImportedKeys(string, string2, string3);
            }
            return this.filterChain.reset().DatabaseMetaData_getImportedKeys(this, string, string2, string3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getExportedKeys(String string, String string2, String string3) {
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getExportedKeys(string, string2, string3);
            }
            return this.filterChain.reset().DatabaseMetaData_getExportedKeys(this, string, string2, string3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getCrossReference(String string, String string2, String string3, String string4, String string5, String string6) {
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getCrossReference(string, string2, string3, string4, string5, string6);
            }
            return this.filterChain.reset().DatabaseMetaData_getCrossReference(this, string, string2, string3, string4, string5, string6);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getTypeInfo() {
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getTypeInfo();
            }
            return this.filterChain.reset().DatabaseMetaData_getTypeInfo(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getIndexInfo(String string, String string2, String string3, boolean bl, boolean bl2) {
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getIndexInfo(string, string2, string3, bl, bl2);
            }
            return this.filterChain.reset().DatabaseMetaData_getIndexInfo(this, string, string2, string3, bl, bl2);
        }
    }

    @Override
    public boolean supportsResultSetType(int n2) {
        if (this.filterChain == null) {
            return this.do_supportsResultSetType(n2);
        }
        return this.filterChain.reset().DatabaseMetaData_supportsResultSetType(this, n2);
    }

    @Override
    public boolean supportsResultSetConcurrency(int n2, int n3) {
        if (this.filterChain == null) {
            return this.do_supportsResultSetConcurrency(n2, n3);
        }
        return this.filterChain.reset().DatabaseMetaData_supportsResultSetConcurrency(this, n2, n3);
    }

    @Override
    public boolean ownUpdatesAreVisible(int n2) {
        if (this.filterChain == null) {
            return this.do_ownUpdatesAreVisible(n2);
        }
        return this.filterChain.reset().DatabaseMetaData_ownUpdatesAreVisible(this, n2);
    }

    @Override
    public boolean ownDeletesAreVisible(int n2) {
        if (this.filterChain == null) {
            return this.do_ownDeletesAreVisible(n2);
        }
        return this.filterChain.reset().DatabaseMetaData_ownDeletesAreVisible(this, n2);
    }

    @Override
    public boolean ownInsertsAreVisible(int n2) {
        if (this.filterChain == null) {
            return this.do_ownInsertsAreVisible(n2);
        }
        return this.filterChain.reset().DatabaseMetaData_ownInsertsAreVisible(this, n2);
    }

    @Override
    public boolean othersUpdatesAreVisible(int n2) {
        if (this.filterChain == null) {
            return this.do_othersUpdatesAreVisible(n2);
        }
        return this.filterChain.reset().DatabaseMetaData_othersUpdatesAreVisible(this, n2);
    }

    @Override
    public boolean othersDeletesAreVisible(int n2) {
        if (this.filterChain == null) {
            return this.do_othersDeletesAreVisible(n2);
        }
        return this.filterChain.reset().DatabaseMetaData_othersDeletesAreVisible(this, n2);
    }

    @Override
    public boolean othersInsertsAreVisible(int n2) {
        if (this.filterChain == null) {
            return this.do_othersInsertsAreVisible(n2);
        }
        return this.filterChain.reset().DatabaseMetaData_othersInsertsAreVisible(this, n2);
    }

    @Override
    public boolean updatesAreDetected(int n2) {
        if (this.filterChain == null) {
            return this.do_updatesAreDetected(n2);
        }
        return this.filterChain.reset().DatabaseMetaData_updatesAreDetected(this, n2);
    }

    @Override
    public boolean deletesAreDetected(int n2) {
        if (this.filterChain == null) {
            return this.do_deletesAreDetected(n2);
        }
        return this.filterChain.reset().DatabaseMetaData_deletesAreDetected(this, n2);
    }

    @Override
    public boolean insertsAreDetected(int n2) {
        if (this.filterChain == null) {
            return this.do_insertsAreDetected(n2);
        }
        return this.filterChain.reset().DatabaseMetaData_insertsAreDetected(this, n2);
    }

    @Override
    public boolean supportsBatchUpdates() {
        if (this.filterChain == null) {
            return this.do_supportsBatchUpdates();
        }
        return this.filterChain.reset().DatabaseMetaData_supportsBatchUpdates(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getUDTs(String string, String string2, String string3, int[] nArray) {
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getUDTs(string, string2, string3, nArray);
            }
            return this.filterChain.reset().DatabaseMetaData_getUDTs(this, string, string2, string3, nArray);
        }
    }

    @Override
    public Connection getConnection() {
        if (this.filterChain == null) {
            return this.do_getConnection();
        }
        return this.filterChain.reset().DatabaseMetaData_getConnection(this);
    }

    @Override
    public boolean supportsSavepoints() {
        if (this.filterChain == null) {
            return this.do_supportsSavepoints();
        }
        return this.filterChain.reset().DatabaseMetaData_supportsSavepoints(this);
    }

    @Override
    public boolean supportsNamedParameters() {
        if (this.filterChain == null) {
            return this.do_supportsNamedParameters();
        }
        return this.filterChain.reset().DatabaseMetaData_supportsNamedParameters(this);
    }

    @Override
    public boolean supportsMultipleOpenResults() {
        if (this.filterChain == null) {
            return this.do_supportsMultipleOpenResults();
        }
        return this.filterChain.reset().DatabaseMetaData_supportsMultipleOpenResults(this);
    }

    @Override
    public boolean supportsGetGeneratedKeys() {
        if (this.filterChain == null) {
            return this.do_supportsGetGeneratedKeys();
        }
        return this.filterChain.reset().DatabaseMetaData_supportsGetGeneratedKeys(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getSuperTypes(String string, String string2, String string3) {
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getSuperTypes(string, string2, string3);
            }
            return this.filterChain.reset().DatabaseMetaData_getSuperTypes(this, string, string2, string3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getSuperTables(String string, String string2, String string3) {
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getSuperTables(string, string2, string3);
            }
            return this.filterChain.reset().DatabaseMetaData_getSuperTables(this, string, string2, string3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getAttributes(String string, String string2, String string3, String string4) {
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getAttributes(string, string2, string3, string4);
            }
            return this.filterChain.reset().DatabaseMetaData_getAttributes(this, string, string2, string3, string4);
        }
    }

    @Override
    public boolean supportsResultSetHoldability(int n2) {
        if (this.filterChain == null) {
            return this.do_supportsResultSetHoldability(n2);
        }
        return this.filterChain.reset().DatabaseMetaData_supportsResultSetHoldability(this, n2);
    }

    @Override
    public int getResultSetHoldability() {
        if (this.filterChain == null) {
            return this.do_getResultSetHoldability();
        }
        return this.filterChain.reset().DatabaseMetaData_getResultSetHoldability(this);
    }

    @Override
    public int getDatabaseMajorVersion() {
        if (this.filterChain == null) {
            return this.do_getDatabaseMajorVersion();
        }
        return this.filterChain.reset().DatabaseMetaData_getDatabaseMajorVersion(this);
    }

    @Override
    public int getDatabaseMinorVersion() {
        if (this.filterChain == null) {
            return this.do_getDatabaseMinorVersion();
        }
        return this.filterChain.reset().DatabaseMetaData_getDatabaseMinorVersion(this);
    }

    @Override
    public int getJDBCMajorVersion() {
        if (this.filterChain == null) {
            return this.do_getJDBCMajorVersion();
        }
        return this.filterChain.reset().DatabaseMetaData_getJDBCMajorVersion(this);
    }

    @Override
    public int getJDBCMinorVersion() {
        if (this.filterChain == null) {
            return this.do_getJDBCMinorVersion();
        }
        return this.filterChain.reset().DatabaseMetaData_getJDBCMinorVersion(this);
    }

    @Override
    public int getSQLStateType() {
        if (this.filterChain == null) {
            return this.do_getSQLStateType();
        }
        return this.filterChain.reset().DatabaseMetaData_getSQLStateType(this);
    }

    @Override
    public boolean locatorsUpdateCopy() {
        if (this.filterChain == null) {
            return this.do_locatorsUpdateCopy();
        }
        return this.filterChain.reset().DatabaseMetaData_locatorsUpdateCopy(this);
    }

    @Override
    public boolean supportsStatementPooling() {
        if (this.filterChain == null) {
            return this.do_supportsStatementPooling();
        }
        return this.filterChain.reset().DatabaseMetaData_supportsStatementPooling(this);
    }

    @Override
    public RowIdLifetime getRowIdLifetime() {
        if (this.filterChain == null) {
            return this.do_getRowIdLifetime();
        }
        return this.filterChain.reset().DatabaseMetaData_getRowIdLifetime(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getSchemas(String string, String string2) {
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getSchemas(string, string2);
            }
            return this.filterChain.reset().DatabaseMetaData_getSchemas(this, string, string2);
        }
    }

    @Override
    public boolean supportsStoredFunctionsUsingCallSyntax() {
        if (this.filterChain == null) {
            return this.do_supportsStoredFunctionsUsingCallSyntax();
        }
        return this.filterChain.reset().DatabaseMetaData_supportsStoredFunctionsUsingCallSyntax(this);
    }

    @Override
    public boolean autoCommitFailureClosesAllResultSets() {
        if (this.filterChain == null) {
            return this.do_autoCommitFailureClosesAllResultSets();
        }
        return this.filterChain.reset().DatabaseMetaData_autoCommitFailureClosesAllResultSets(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getClientInfoProperties() {
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getClientInfoProperties();
            }
            return this.filterChain.reset().DatabaseMetaData_getClientInfoProperties(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getFunctions(String string, String string2, String string3) {
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getFunctions(string, string2, string3);
            }
            return this.filterChain.reset().DatabaseMetaData_getFunctions(this, string, string2, string3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getFunctionColumns(String string, String string2, String string3, String string4) {
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getFunctionColumns(string, string2, string3, string4);
            }
            return this.filterChain.reset().DatabaseMetaData_getFunctionColumns(this, string, string2, string3, string4);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getPseudoColumns(String string, String string2, String string3, String string4) {
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getPseudoColumns(string, string2, string3, string4);
            }
            return this.filterChain.reset().DatabaseMetaData_getPseudoColumns(this, string, string2, string3, string4);
        }
    }

    @Override
    public boolean generatedKeyAlwaysReturned() {
        if (this.filterChain == null) {
            return this.do_generatedKeyAlwaysReturned();
        }
        return this.filterChain.reset().DatabaseMetaData_generatedKeyAlwaysReturned(this);
    }

    @Override
    public long getMaxLogicalLobSize() {
        if (this.filterChain == null) {
            return this.do_getMaxLogicalLobSize();
        }
        return this.filterChain.reset().DatabaseMetaData_getMaxLogicalLobSize(this);
    }

    @Override
    public boolean supportsRefCursors() {
        if (this.filterChain == null) {
            return this.do_supportsRefCursors();
        }
        return this.filterChain.reset().DatabaseMetaData_supportsRefCursors(this);
    }

    public Object unwrap(Class clazz) {
        return clazz.cast(this);
    }

    public boolean isWrapperFor(Class clazz) {
        return clazz.isInstance(this);
    }
}

