/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core;

import io.lettuce.core.ConnectionPoint;
import io.lettuce.core.SslVerifyMode;
import io.lettuce.core.internal.HostAndPort;
import io.lettuce.core.internal.LettuceAssert;
import io.lettuce.core.internal.LettuceSets;
import io.lettuce.core.internal.LettuceStrings;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.function.LongFunction;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class RedisURI
implements Serializable,
ConnectionPoint {
    public static final String URI_SCHEME_REDIS_SENTINEL = "redis-sentinel";
    public static final String URI_SCHEME_REDIS_SENTINEL_SECURE = "rediss-sentinel";
    public static final String URI_SCHEME_REDIS = "redis";
    public static final String URI_SCHEME_REDIS_SECURE = "rediss";
    public static final String URI_SCHEME_REDIS_SECURE_ALT = "redis+ssl";
    public static final String URI_SCHEME_REDIS_TLS_ALT = "redis+tls";
    public static final String URI_SCHEME_REDIS_SOCKET = "redis-socket";
    public static final String URI_SCHEME_REDIS_SOCKET_ALT = "redis+socket";
    public static final String PARAMETER_NAME_TIMEOUT = "timeout";
    public static final String PARAMETER_NAME_DATABASE = "database";
    public static final String PARAMETER_NAME_DATABASE_ALT = "db";
    public static final String PARAMETER_NAME_SENTINEL_MASTER_ID = "sentinelMasterId";
    public static final String PARAMETER_NAME_CLIENT_NAME = "clientName";
    public static final String PARAMETER_NAME_VERIFY_PEER = "verifyPeer";
    public static final Map<String, LongFunction<Duration>> CONVERTER_MAP;
    public static final int DEFAULT_SENTINEL_PORT = 26379;
    public static final int DEFAULT_REDIS_PORT = 6379;
    public static final long DEFAULT_TIMEOUT = 60L;
    public static final Duration DEFAULT_TIMEOUT_DURATION;
    private String host;
    private String socket;
    private String sentinelMasterId;
    private int port;
    private int database;
    private String clientName;
    private String username;
    private char[] password;
    private boolean ssl = false;
    private SslVerifyMode verifyMode = SslVerifyMode.FULL;
    private boolean startTls = false;
    private Duration timeout = DEFAULT_TIMEOUT_DURATION;
    private final List<RedisURI> sentinels = new ArrayList<RedisURI>();

    public RedisURI() {
    }

    public RedisURI(String host, int port, Duration timeout) {
        LettuceAssert.notEmpty((CharSequence)host, "Host must not be empty");
        LettuceAssert.notNull((Object)timeout, "Timeout duration must not be null");
        LettuceAssert.isTrue(!timeout.isNegative(), "Timeout duration must be greater or equal to zero");
        this.setHost(host);
        this.setPort(port);
        this.setTimeout(timeout);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static RedisURI create(String host, int port) {
        return Builder.redis(host, port).build();
    }

    public static RedisURI create(String uri) {
        LettuceAssert.notEmpty((CharSequence)uri, "URI must not be empty");
        return RedisURI.create(URI.create(uri));
    }

    public static RedisURI create(URI uri) {
        return RedisURI.buildRedisUriFromUri(uri);
    }

    public static Builder builder(RedisURI source) {
        LettuceAssert.notNull((Object)source, "Source RedisURI must not be null");
        Builder builder = RedisURI.builder();
        builder.withSsl(source).withAuthentication(source).withTimeout(source.getTimeout()).withDatabase(source.getDatabase());
        if (source.getClientName() != null) {
            builder.withClientName(source.getClientName());
        }
        if (source.socket != null) {
            builder.socket = source.getSocket();
        } else if (source.getHost() != null) {
            builder.withHost(source.getHost());
            builder.withPort(source.getPort());
        }
        return builder;
    }

    @Override
    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getSentinelMasterId() {
        return this.sentinelMasterId;
    }

    public void setSentinelMasterId(String sentinelMasterId) {
        this.sentinelMasterId = sentinelMasterId;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    @Override
    public String getSocket() {
        return this.socket;
    }

    public void setSocket(String socket) {
        this.socket = socket;
    }

    public void applyAuthentication(RedisURI source) {
        LettuceAssert.notNull((Object)source, "Source RedisURI must not be null");
        this.setUsername(source.getUsername());
        this.setPassword(source.getPassword());
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public char[] getPassword() {
        return this.password;
    }

    @Deprecated
    public void setPassword(String password) {
        this.setPassword((CharSequence)password);
    }

    public void setPassword(CharSequence password) {
        LettuceAssert.notNull((Object)password, "Password must not be null");
        this.password = password.toString().toCharArray();
    }

    public void setPassword(char[] password) {
        this.password = password == null ? null : Arrays.copyOf(password, password.length);
    }

    public Duration getTimeout() {
        return this.timeout;
    }

    public void setTimeout(Duration timeout) {
        LettuceAssert.notNull((Object)timeout, "Timeout must not be null");
        LettuceAssert.isTrue(!timeout.isNegative(), "Timeout must be greater or equal 0");
        this.timeout = timeout;
    }

    public int getDatabase() {
        return this.database;
    }

    public void setDatabase(int database) {
        LettuceAssert.isTrue(database >= 0, "Invalid database number: " + database);
        this.database = database;
    }

    public String getClientName() {
        return this.clientName;
    }

    public void setClientName(String clientName) {
        this.clientName = clientName;
    }

    public void applySsl(RedisURI source) {
        LettuceAssert.notNull((Object)source, "Source RedisURI must not be null");
        this.setSsl(source.isSsl());
        this.setVerifyPeer(source.isVerifyPeer());
        this.setStartTls(source.isStartTls());
    }

    public boolean isSsl() {
        return this.ssl;
    }

    public void setSsl(boolean ssl) {
        this.ssl = ssl;
        this.sentinels.forEach(it -> it.setSsl(ssl));
    }

    public boolean isVerifyPeer() {
        return this.verifyMode != SslVerifyMode.NONE;
    }

    public SslVerifyMode getVerifyMode() {
        return this.verifyMode;
    }

    public void setVerifyPeer(boolean verifyPeer) {
        this.setVerifyPeer(verifyPeer ? SslVerifyMode.FULL : SslVerifyMode.NONE);
    }

    public void setVerifyPeer(SslVerifyMode verifyMode) {
        LettuceAssert.notNull((Object)verifyMode, "VerifyMode must not be null");
        this.verifyMode = verifyMode;
        this.sentinels.forEach(it -> it.setVerifyPeer(this.verifyMode));
    }

    public boolean isStartTls() {
        return this.startTls;
    }

    public void setStartTls(boolean startTls) {
        this.startTls = startTls;
        this.sentinels.forEach(it -> it.setStartTls(startTls));
    }

    public List<RedisURI> getSentinels() {
        return this.sentinels;
    }

    public URI toURI() {
        try {
            return URI.create(this.createUriString(false));
        }
        catch (Exception e) {
            throw new IllegalStateException("Cannot render URI for " + this.toString(), e);
        }
    }

    private String createUriString(boolean maskCredentials) {
        String scheme = this.getScheme();
        String authority = this.getAuthority(scheme, maskCredentials);
        String queryString = this.getQueryString();
        String uri = scheme + "://" + authority;
        if (!queryString.isEmpty()) {
            uri = uri + "?" + queryString;
        }
        return uri;
    }

    private static RedisURI buildRedisUriFromUri(URI uri) {
        String pathSuffix;
        LettuceAssert.notNull((Object)uri, "URI must not be null");
        LettuceAssert.notNull((Object)uri.getScheme(), "URI scheme must not be null");
        Builder builder = RedisURI.isSentinel(uri.getScheme()) ? RedisURI.configureSentinel(uri) : RedisURI.configureStandalone(uri);
        String userInfo = uri.getUserInfo();
        if (LettuceStrings.isEmpty(userInfo) && LettuceStrings.isNotEmpty(uri.getAuthority()) && uri.getAuthority().indexOf(64) > 0) {
            userInfo = uri.getAuthority().substring(0, uri.getAuthority().indexOf(64));
        }
        if (LettuceStrings.isNotEmpty(userInfo)) {
            String password = userInfo;
            String username = null;
            if (password.startsWith(":")) {
                password = password.substring(1);
            } else {
                int index = password.indexOf(58);
                if (index > 0) {
                    username = password.substring(0, index);
                    password = password.substring(index + 1);
                }
            }
            if (LettuceStrings.isNotEmpty(password)) {
                if (username == null) {
                    builder.withPassword(password);
                } else {
                    builder.withAuthentication(username, password);
                }
            }
        }
        if (LettuceStrings.isNotEmpty(uri.getPath()) && builder.socket == null && LettuceStrings.isNotEmpty(pathSuffix = uri.getPath().substring(1))) {
            builder.withDatabase(Integer.parseInt(pathSuffix));
        }
        if (LettuceStrings.isNotEmpty(uri.getQuery())) {
            StringTokenizer st = new StringTokenizer(uri.getQuery(), "&;");
            while (st.hasMoreTokens()) {
                String queryParam = st.nextToken();
                String forStartWith = queryParam.toLowerCase();
                if (forStartWith.startsWith("timeout=")) {
                    RedisURI.parseTimeout(builder, queryParam.toLowerCase());
                }
                if (forStartWith.startsWith("database=") || queryParam.startsWith("db=")) {
                    RedisURI.parseDatabase(builder, queryParam);
                }
                if (forStartWith.startsWith(PARAMETER_NAME_CLIENT_NAME.toLowerCase() + "=")) {
                    RedisURI.parseClientName(builder, queryParam);
                }
                if (forStartWith.startsWith(PARAMETER_NAME_VERIFY_PEER.toLowerCase() + "=")) {
                    RedisURI.parseVerifyPeer(builder, queryParam);
                }
                if (!forStartWith.startsWith(PARAMETER_NAME_SENTINEL_MASTER_ID.toLowerCase() + "=")) continue;
                RedisURI.parseSentinelMasterId(builder, queryParam);
            }
        }
        if (RedisURI.isSentinel(uri.getScheme())) {
            LettuceAssert.notEmpty((CharSequence)builder.sentinelMasterId, "URI must contain the sentinelMasterId");
        }
        return builder.build();
    }

    private String getAuthority(String scheme, boolean maskCredentials) {
        String authority = null;
        if (this.host != null) {
            authority = this.host.contains(",") ? this.host : RedisURI.urlEncode(this.host) + this.getPortPart(this.port, scheme);
        }
        if (this.sentinels.size() != 0) {
            authority = this.sentinels.stream().map(redisURI -> {
                if (LettuceStrings.isNotEmpty(redisURI.getSocket())) {
                    return String.format("[Socket %s]", redisURI.getSocket());
                }
                return RedisURI.urlEncode(redisURI.getHost()) + this.getPortPart(redisURI.getPort(), scheme);
            }).collect(Collectors.joining(","));
        }
        if (this.socket != null) {
            authority = RedisURI.urlEncode(this.socket);
        } else if (this.database != 0) {
            authority = authority + "/" + this.database;
        }
        if (this.password != null && this.password.length != 0) {
            authority = RedisURI.urlEncode(maskCredentials ? IntStream.range(0, this.password.length).mapToObj(ignore -> "*").collect(Collectors.joining()) : new String(this.password)) + "@" + authority;
        }
        if (this.username != null) {
            authority = RedisURI.urlEncode(this.username) + ":" + authority;
        }
        return authority;
    }

    private String getQueryString() {
        ArrayList<String> queryPairs = new ArrayList<String>();
        if (this.database != 0 && LettuceStrings.isNotEmpty(this.socket)) {
            queryPairs.add("database=" + this.database);
        }
        if (this.clientName != null) {
            queryPairs.add("clientName=" + RedisURI.urlEncode(this.clientName));
        }
        if (this.isSsl() && this.getVerifyMode() != SslVerifyMode.FULL) {
            queryPairs.add("verifyPeer=" + this.verifyMode.name());
        }
        if (this.sentinelMasterId != null) {
            queryPairs.add("sentinelMasterId=" + RedisURI.urlEncode(this.sentinelMasterId));
        }
        if (this.timeout.getSeconds() != 60L) {
            if (this.timeout.getNano() == 0) {
                queryPairs.add("timeout=" + this.timeout.getSeconds() + "s");
            } else {
                queryPairs.add("timeout=" + this.timeout.toNanos() + "ns");
            }
        }
        return queryPairs.stream().collect(Collectors.joining("&"));
    }

    private String getPortPart(int port, String scheme) {
        if (RedisURI.isSentinel(scheme) && port == 26379) {
            return "";
        }
        if (URI_SCHEME_REDIS.equals(scheme) && port == 6379) {
            return "";
        }
        return ":" + port;
    }

    private String getScheme() {
        String scheme = URI_SCHEME_REDIS;
        if (this.isSsl()) {
            scheme = this.isStartTls() ? URI_SCHEME_REDIS_TLS_ALT : URI_SCHEME_REDIS_SECURE;
        }
        if (this.socket != null) {
            scheme = URI_SCHEME_REDIS_SOCKET;
        }
        if (this.host == null && !this.sentinels.isEmpty()) {
            scheme = this.isSsl() ? URI_SCHEME_REDIS_SENTINEL_SECURE : URI_SCHEME_REDIS_SENTINEL;
        }
        return scheme;
    }

    private static String urlEncode(String str) {
        try {
            return URLEncoder.encode(str, StandardCharsets.UTF_8.name()).replaceAll("%2F", "/");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e);
        }
    }

    public String toString() {
        return this.createUriString(true);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RedisURI)) {
            return false;
        }
        RedisURI redisURI = (RedisURI)o;
        if (this.port != redisURI.port) {
            return false;
        }
        if (this.database != redisURI.database) {
            return false;
        }
        if (this.host != null ? !this.host.equals(redisURI.host) : redisURI.host != null) {
            return false;
        }
        if (this.socket != null ? !this.socket.equals(redisURI.socket) : redisURI.socket != null) {
            return false;
        }
        if (this.sentinelMasterId != null ? !this.sentinelMasterId.equals(redisURI.sentinelMasterId) : redisURI.sentinelMasterId != null) {
            return false;
        }
        return !(this.sentinels == null ? redisURI.sentinels != null : !this.sentinels.equals(redisURI.sentinels));
    }

    public int hashCode() {
        int result = this.host != null ? this.host.hashCode() : 0;
        result = 31 * result + (this.socket != null ? this.socket.hashCode() : 0);
        result = 31 * result + (this.sentinelMasterId != null ? this.sentinelMasterId.hashCode() : 0);
        result = 31 * result + this.port;
        result = 31 * result + this.database;
        result = 31 * result + (this.sentinels != null ? this.sentinels.hashCode() : 0);
        return result;
    }

    private static void parseTimeout(Builder builder, String queryParam) {
        int numbersEnd;
        int index = queryParam.indexOf(61);
        if (index < 0) {
            return;
        }
        String timeoutString = queryParam.substring(index + 1);
        for (numbersEnd = 0; numbersEnd < timeoutString.length() && Character.isDigit(timeoutString.charAt(numbersEnd)); ++numbersEnd) {
        }
        if (numbersEnd == 0) {
            if (timeoutString.startsWith("-")) {
                builder.withTimeout(Duration.ZERO);
            }
        } else {
            String timeoutValueString = timeoutString.substring(0, numbersEnd);
            long timeoutValue = Long.parseLong(timeoutValueString);
            builder.withTimeout(Duration.ofMillis(timeoutValue));
            String suffix = timeoutString.substring(numbersEnd);
            LongFunction<Duration> converter = CONVERTER_MAP.get(suffix);
            if (converter == null) {
                converter = Duration::ofMillis;
            }
            builder.withTimeout(converter.apply(timeoutValue));
        }
    }

    private static void parseDatabase(Builder builder, String queryParam) {
        int numbersEnd;
        int index = queryParam.indexOf(61);
        if (index < 0) {
            return;
        }
        String databaseString = queryParam.substring(index + 1);
        for (numbersEnd = 0; numbersEnd < databaseString.length() && Character.isDigit(databaseString.charAt(numbersEnd)); ++numbersEnd) {
        }
        if (numbersEnd != 0) {
            String databaseValueString = databaseString.substring(0, numbersEnd);
            int value = Integer.parseInt(databaseValueString);
            builder.withDatabase(value);
        }
    }

    private static void parseClientName(Builder builder, String queryParam) {
        String clientName = RedisURI.getValuePart(queryParam);
        if (LettuceStrings.isNotEmpty(clientName)) {
            builder.withClientName(clientName);
        }
    }

    private static void parseVerifyPeer(Builder builder, String queryParam) {
        String verifyPeer = RedisURI.getValuePart(queryParam);
        if (LettuceStrings.isNotEmpty(verifyPeer)) {
            builder.withVerifyPeer(SslVerifyMode.valueOf(verifyPeer.toUpperCase()));
        }
    }

    private static void parseSentinelMasterId(Builder builder, String queryParam) {
        String masterIdString = RedisURI.getValuePart(queryParam);
        if (LettuceStrings.isNotEmpty(masterIdString)) {
            builder.withSentinelMasterId(masterIdString);
        }
    }

    private static String getValuePart(String queryParam) {
        int index = queryParam.indexOf(61);
        if (index < 0) {
            return null;
        }
        return queryParam.substring(index + 1);
    }

    private static Builder configureStandalone(URI uri) {
        Builder builder = null;
        Set<String> allowedSchemes = LettuceSets.unmodifiableSet(URI_SCHEME_REDIS, URI_SCHEME_REDIS_SECURE, URI_SCHEME_REDIS_SOCKET, URI_SCHEME_REDIS_SOCKET_ALT, URI_SCHEME_REDIS_SECURE_ALT, URI_SCHEME_REDIS_TLS_ALT);
        if (!allowedSchemes.contains(uri.getScheme())) {
            throw new IllegalArgumentException("Scheme " + uri.getScheme() + " not supported");
        }
        if (URI_SCHEME_REDIS_SOCKET.equals(uri.getScheme()) || URI_SCHEME_REDIS_SOCKET_ALT.equals(uri.getScheme())) {
            builder = Builder.socket(uri.getPath());
        } else if (LettuceStrings.isNotEmpty(uri.getHost())) {
            builder = uri.getPort() > 0 ? Builder.redis(uri.getHost(), uri.getPort()) : Builder.redis(uri.getHost());
        } else if (LettuceStrings.isNotEmpty(uri.getAuthority())) {
            String authority = uri.getAuthority();
            if (authority.indexOf(64) > -1) {
                authority = authority.substring(authority.indexOf(64) + 1);
            }
            builder = Builder.redis(authority);
        }
        LettuceAssert.notNull((Object)builder, "Invalid URI, cannot get host or socket part");
        if (URI_SCHEME_REDIS_SECURE.equals(uri.getScheme()) || URI_SCHEME_REDIS_SECURE_ALT.equals(uri.getScheme())) {
            builder.withSsl(true);
        }
        if (URI_SCHEME_REDIS_TLS_ALT.equals(uri.getScheme())) {
            builder.withSsl(true);
            builder.withStartTls(true);
        }
        return builder;
    }

    private static Builder configureSentinel(URI uri) {
        String masterId = uri.getFragment();
        Builder builder = null;
        if (LettuceStrings.isNotEmpty(uri.getHost())) {
            builder = uri.getPort() != -1 ? Builder.sentinel(uri.getHost(), uri.getPort()) : Builder.sentinel(uri.getHost());
        }
        if (builder == null && LettuceStrings.isNotEmpty(uri.getAuthority())) {
            String[] hosts;
            String authority = uri.getAuthority();
            if (authority.indexOf(64) > -1) {
                authority = authority.substring(authority.indexOf(64) + 1);
            }
            for (String host : hosts = authority.split(",")) {
                HostAndPort hostAndPort = HostAndPort.parse(host);
                if (builder == null) {
                    if (hostAndPort.hasPort()) {
                        builder = Builder.sentinel(hostAndPort.getHostText(), hostAndPort.getPort());
                        continue;
                    }
                    builder = Builder.sentinel(hostAndPort.getHostText());
                    continue;
                }
                if (hostAndPort.hasPort()) {
                    builder.withSentinel(hostAndPort.getHostText(), hostAndPort.getPort());
                    continue;
                }
                builder.withSentinel(hostAndPort.getHostText());
            }
        }
        LettuceAssert.notNull(builder, "Invalid URI, cannot get host part");
        if (LettuceStrings.isNotEmpty(masterId)) {
            builder.withSentinelMasterId(masterId);
        }
        if (uri.getScheme().equals(URI_SCHEME_REDIS_SENTINEL_SECURE)) {
            builder.withSsl(true);
        }
        return builder;
    }

    private static boolean isSentinel(String scheme) {
        return URI_SCHEME_REDIS_SENTINEL.equals(scheme) || URI_SCHEME_REDIS_SENTINEL_SECURE.equals(scheme);
    }

    private static boolean isValidPort(int port) {
        return port >= 0 && port <= 65535;
    }

    static {
        HashMap<String, LongFunction<Duration>> unitMap = new HashMap<String, LongFunction<Duration>>();
        unitMap.put("ns", Duration::ofNanos);
        unitMap.put("us", us -> Duration.ofNanos(us * 1000L));
        unitMap.put("ms", Duration::ofMillis);
        unitMap.put("s", Duration::ofSeconds);
        unitMap.put("m", Duration::ofMinutes);
        unitMap.put("h", Duration::ofHours);
        unitMap.put("d", Duration::ofDays);
        CONVERTER_MAP = Collections.unmodifiableMap(unitMap);
        DEFAULT_TIMEOUT_DURATION = Duration.ofSeconds(60L);
    }

    public static class Builder {
        private String host;
        private String socket;
        private String sentinelMasterId;
        private int port = 6379;
        private int database;
        private String clientName;
        private String username;
        private char[] password;
        private char[] sentinelPassword;
        private boolean ssl = false;
        private SslVerifyMode verifyMode = SslVerifyMode.FULL;
        private boolean startTls = false;
        private Duration timeout = DEFAULT_TIMEOUT_DURATION;
        private final List<RedisURI> sentinels = new ArrayList<RedisURI>();

        private Builder() {
        }

        public static Builder socket(String socket) {
            LettuceAssert.notNull((Object)socket, "Socket must not be null");
            Builder builder = RedisURI.builder();
            builder.socket = socket;
            return builder;
        }

        public static Builder redis(String host) {
            return Builder.redis(host, 6379);
        }

        public static Builder redis(String host, int port) {
            LettuceAssert.notEmpty((CharSequence)host, "Host must not be empty");
            LettuceAssert.isTrue(RedisURI.isValidPort(port), () -> String.format("Port out of range: %s", port));
            Builder builder = RedisURI.builder();
            return builder.withHost(host).withPort(port);
        }

        public static Builder sentinel(String host) {
            LettuceAssert.notEmpty((CharSequence)host, "Host must not be empty");
            Builder builder = RedisURI.builder();
            return builder.withSentinel(host);
        }

        public static Builder sentinel(String host, int port) {
            LettuceAssert.notEmpty((CharSequence)host, "Host must not be empty");
            LettuceAssert.isTrue(RedisURI.isValidPort(port), () -> String.format("Port out of range: %s", port));
            Builder builder = RedisURI.builder();
            return builder.withSentinel(host, port);
        }

        public static Builder sentinel(String host, String masterId) {
            return Builder.sentinel(host, 26379, masterId);
        }

        public static Builder sentinel(String host, int port, String masterId) {
            return Builder.sentinel(host, port, masterId, null);
        }

        @Deprecated
        public static Builder sentinel(String host, int port, String masterId, CharSequence password) {
            LettuceAssert.notEmpty((CharSequence)host, "Host must not be empty");
            LettuceAssert.isTrue(RedisURI.isValidPort(port), () -> String.format("Port out of range: %s", port));
            Builder builder = RedisURI.builder();
            if (password != null) {
                builder.sentinelPassword = password.toString().toCharArray();
            }
            return builder.withSentinelMasterId(masterId).withSentinel(host, port);
        }

        public Builder withSentinel(String host) {
            return this.withSentinel(host, 26379);
        }

        public Builder withSentinel(String host, int port) {
            if (this.sentinelPassword != null) {
                return this.withSentinel(host, port, new String(this.sentinelPassword));
            }
            return this.withSentinel(host, port, null);
        }

        public Builder withSentinel(String host, int port, CharSequence password) {
            LettuceAssert.assertState(this.host == null, "Cannot use with Redis mode.");
            LettuceAssert.notEmpty((CharSequence)host, "Host must not be empty");
            LettuceAssert.isTrue(RedisURI.isValidPort(port), () -> String.format("Port out of range: %s", port));
            RedisURI redisURI = RedisURI.create(host, port);
            if (password != null) {
                redisURI.setPassword(password);
            }
            return this.withSentinel(redisURI);
        }

        public Builder withSentinel(RedisURI redisURI) {
            LettuceAssert.notNull((Object)redisURI, "Redis URI must not be null");
            this.sentinels.add(redisURI);
            return this;
        }

        public Builder withHost(String host) {
            LettuceAssert.assertState(this.sentinels.isEmpty(), "Sentinels are non-empty. Cannot use in Sentinel mode.");
            LettuceAssert.notEmpty((CharSequence)host, "Host must not be empty");
            this.host = host;
            return this;
        }

        public Builder withPort(int port) {
            LettuceAssert.assertState(this.host != null, "Host is null. Cannot use in Sentinel mode.");
            LettuceAssert.isTrue(RedisURI.isValidPort(port), () -> String.format("Port out of range: %s", port));
            this.port = port;
            return this;
        }

        public Builder withSsl(RedisURI source) {
            LettuceAssert.notNull((Object)source, "Source RedisURI must not be null");
            this.withSsl(source.isSsl());
            this.withVerifyPeer(source.getVerifyMode());
            this.withStartTls(source.isStartTls());
            return this;
        }

        public Builder withSsl(boolean ssl) {
            this.ssl = ssl;
            this.sentinels.forEach(it -> it.setSsl(ssl));
            return this;
        }

        public Builder withStartTls(boolean startTls) {
            this.startTls = startTls;
            this.sentinels.forEach(it -> it.setStartTls(startTls));
            return this;
        }

        public Builder withVerifyPeer(boolean verifyPeer) {
            return this.withVerifyPeer(verifyPeer ? SslVerifyMode.FULL : SslVerifyMode.NONE);
        }

        public Builder withVerifyPeer(SslVerifyMode verifyMode) {
            LettuceAssert.notNull((Object)verifyMode, "VerifyMode must not be null");
            this.verifyMode = verifyMode;
            this.sentinels.forEach(it -> it.setVerifyPeer(verifyMode));
            return this;
        }

        public Builder withDatabase(int database) {
            LettuceAssert.isTrue(database >= 0, () -> "Invalid database number: " + database);
            this.database = database;
            return this;
        }

        public Builder withClientName(String clientName) {
            LettuceAssert.notNull((Object)clientName, "Client name must not be null");
            this.clientName = clientName;
            return this;
        }

        public Builder withAuthentication(String username, CharSequence password) {
            LettuceAssert.notNull((Object)username, "User name must not be null");
            LettuceAssert.notNull((Object)password, "Password must not be null");
            this.username = username;
            return this.withPassword(password);
        }

        public Builder withAuthentication(RedisURI source) {
            LettuceAssert.notNull((Object)source, "Source RedisURI must not be null");
            this.username = source.getUsername();
            this.withPassword(source.getPassword());
            return this;
        }

        public Builder withAuthentication(String username, char[] password) {
            LettuceAssert.notNull((Object)username, "User name must not be null");
            LettuceAssert.notNull((Object)password, "Password must not be null");
            this.username = username;
            return this.withPassword(password);
        }

        @Deprecated
        public Builder withPassword(String password) {
            LettuceAssert.notNull((Object)password, "Password must not be null");
            return this.withPassword(password.toCharArray());
        }

        public Builder withPassword(CharSequence password) {
            LettuceAssert.notNull((Object)password, "Password must not be null");
            char[] chars = new char[password.length()];
            for (int i = 0; i < password.length(); ++i) {
                chars[i] = password.charAt(i);
            }
            return this.withPassword(chars);
        }

        public Builder withPassword(char[] password) {
            this.password = password == null ? null : Arrays.copyOf(password, password.length);
            return this;
        }

        public Builder withTimeout(Duration timeout) {
            LettuceAssert.notNull((Object)timeout, "Timeout must not be null");
            LettuceAssert.notNull((Object)(!timeout.isNegative() ? 1 : 0), "Timeout must be greater or equal 0");
            this.timeout = timeout;
            return this;
        }

        public Builder withSentinelMasterId(String sentinelMasterId) {
            LettuceAssert.notEmpty((CharSequence)sentinelMasterId, "Sentinel master id must not empty");
            this.sentinelMasterId = sentinelMasterId;
            return this;
        }

        public RedisURI build() {
            if (this.sentinels.isEmpty() && LettuceStrings.isEmpty(this.host) && LettuceStrings.isEmpty(this.socket)) {
                throw new IllegalStateException("Cannot build a RedisURI. One of the following must be provided Host, Socket or Sentinel");
            }
            RedisURI redisURI = new RedisURI();
            redisURI.setHost(this.host);
            redisURI.setPort(this.port);
            if (this.username != null) {
                redisURI.setUsername(this.username);
            }
            if (this.password != null) {
                redisURI.setPassword(this.password);
            }
            redisURI.setDatabase(this.database);
            redisURI.setClientName(this.clientName);
            redisURI.setSentinelMasterId(this.sentinelMasterId);
            for (RedisURI sentinel : this.sentinels) {
                sentinel.setTimeout(this.timeout);
                redisURI.getSentinels().add(sentinel);
            }
            redisURI.setSocket(this.socket);
            redisURI.setSsl(this.ssl);
            redisURI.setStartTls(this.startTls);
            redisURI.setVerifyPeer(this.verifyMode);
            redisURI.setTimeout(this.timeout);
            return redisURI;
        }
    }
}

