/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.util;

import java.nio.charset.Charset;

public class ByteUtil {
    public static int setByte(byte[] byArray, int n2, byte by) {
        byArray[n2] = by;
        return 1;
    }

    public static int setShort(byte[] byArray, int n2, short s2) {
        byArray[n2++] = (byte)s2;
        byArray[n2++] = (byte)(s2 >> 8);
        return 2;
    }

    public static int setInt(byte[] byArray, int n2, int n3) {
        byArray[n2++] = (byte)n3;
        byArray[n2++] = (byte)(n3 >> 8);
        byArray[n2++] = (byte)(n3 >> 16);
        byArray[n2++] = (byte)(n3 >> 24);
        return 4;
    }

    public static int setLong(byte[] byArray, int n2, long l2) {
        byArray[n2++] = (byte)l2;
        byArray[n2++] = (byte)(l2 >> 8);
        byArray[n2++] = (byte)(l2 >> 16);
        byArray[n2++] = (byte)(l2 >> 24);
        byArray[n2++] = (byte)(l2 >> 32);
        byArray[n2++] = (byte)(l2 >> 40);
        byArray[n2++] = (byte)(l2 >> 48);
        byArray[n2++] = (byte)(l2 >> 56);
        return 8;
    }

    public static int setFloat(byte[] byArray, int n2, float f2) {
        return ByteUtil.setInt(byArray, n2, Float.floatToIntBits(f2));
    }

    public static int setDouble(byte[] byArray, int n2, double d2) {
        return ByteUtil.setLong(byArray, n2, Double.doubleToLongBits(d2));
    }

    public static int setUB1(byte[] byArray, int n2, int n3) {
        byArray[n2] = (byte)n3;
        return 1;
    }

    public static int setUB2(byte[] byArray, int n2, int n3) {
        byArray[n2++] = (byte)n3;
        byArray[n2++] = (byte)(n3 >> 8);
        return 2;
    }

    public static int setUB3(byte[] byArray, int n2, int n3) {
        byArray[n2++] = (byte)n3;
        byArray[n2++] = (byte)(n3 >> 8);
        byArray[n2++] = (byte)(n3 >> 16);
        return 3;
    }

    public static int setUB4(byte[] byArray, int n2, long l2) {
        byArray[n2++] = (byte)l2;
        byArray[n2++] = (byte)(l2 >> 8);
        byArray[n2++] = (byte)(l2 >> 16);
        byArray[n2++] = (byte)(l2 >> 24);
        return 4;
    }

    public static int setBytes(byte[] byArray, int n2, byte[] byArray2) {
        System.arraycopy(byArray2, 0, byArray, n2, byArray2.length);
        return byArray2.length;
    }

    public static int setBytes(byte[] byArray, int n2, byte[] byArray2, int n3, int n4) {
        System.arraycopy(byArray2, n3, byArray, n2, n4);
        return n4;
    }

    public static int setBytesWithLength(byte[] byArray, int n2, byte[] byArray2) {
        n2 += ByteUtil.setInt(byArray, n2, byArray2.length);
        return 4 + ByteUtil.setBytes(byArray, n2, byArray2);
    }

    public static int setBytesWithLength(byte[] byArray, int n2, byte[] byArray2, int n3, int n4) {
        n2 += ByteUtil.setInt(byArray, n2, n4);
        return 4 + ByteUtil.setBytes(byArray, n2, byArray2, n3, n4);
    }

    public static int setBytesWithLength2(byte[] byArray, int n2, byte[] byArray2) {
        n2 += ByteUtil.setUB2(byArray, n2, byArray2.length);
        return 2 + ByteUtil.setBytes(byArray, n2, byArray2);
    }

    public static int setBytesWithLength2(byte[] byArray, int n2, byte[] byArray2, int n3, int n4) {
        n2 += ByteUtil.setUB2(byArray, n2, n4);
        return 2 + ByteUtil.setBytes(byArray, n2, byArray2, n3, n4);
    }

    public static int setStringWithLength(byte[] byArray, int n2, String string, Charset charset) {
        byte[] byArray2 = ByteUtil.fromString(string, charset);
        n2 += ByteUtil.setInt(byArray, n2, byArray2.length);
        return 4 + ByteUtil.setBytes(byArray, n2, byArray2);
    }

    public static int setStringWithLength2(byte[] byArray, int n2, String string, Charset charset) {
        byte[] byArray2 = ByteUtil.fromString(string, charset);
        n2 += ByteUtil.setUB2(byArray, n2, byArray2.length);
        return 2 + ByteUtil.setBytes(byArray, n2, byArray2);
    }

    public static byte getByte(byte[] byArray, int n2) {
        return byArray[n2];
    }

    public static short getShort(byte[] byArray, int n2) {
        short s2 = (short)(byArray[n2++] & 0xFF);
        s2 = (short)(s2 | (short)(byArray[n2++] & 0xFF) << 8);
        return s2;
    }

    public static int getInt(byte[] byArray, int n2) {
        int n3 = byArray[n2++] & 0xFF;
        n3 |= (byArray[n2++] & 0xFF) << 8;
        n3 |= (byArray[n2++] & 0xFF) << 16;
        return n3 |= (byArray[n2++] & 0xFF) << 24;
    }

    public static long getLong(byte[] byArray, int n2) {
        long l2 = byArray[n2++] & 0xFF;
        l2 |= (long)(byArray[n2++] & 0xFF) << 8;
        l2 |= (long)(byArray[n2++] & 0xFF) << 16;
        l2 |= (long)(byArray[n2++] & 0xFF) << 24;
        l2 |= (long)(byArray[n2++] & 0xFF) << 32;
        l2 |= (long)(byArray[n2++] & 0xFF) << 40;
        l2 |= (long)(byArray[n2++] & 0xFF) << 48;
        return l2 |= (long)(byArray[n2++] & 0xFF) << 56;
    }

    public static float getFloat(byte[] byArray, int n2) {
        int n3 = ByteUtil.getInt(byArray, n2);
        return Float.intBitsToFloat(n3);
    }

    public static double getDouble(byte[] byArray, int n2) {
        long l2 = ByteUtil.getLong(byArray, n2);
        return Double.longBitsToDouble(l2);
    }

    public static int getUB1(byte[] byArray, int n2) {
        return byArray[n2] & 0xFF;
    }

    public static int getUB2(byte[] byArray, int n2) {
        int n3 = byArray[n2++] & 0xFF;
        return n3 |= (byArray[n2++] & 0xFF) << 8;
    }

    public static int getUB3(byte[] byArray, int n2) {
        int n3 = byArray[n2++] & 0xFF;
        n3 |= (byArray[n2++] & 0xFF) << 8;
        return n3 |= (byArray[n2++] & 0xFF) << 16;
    }

    public static long getUB4(byte[] byArray, int n2) {
        long l2 = byArray[n2++] & 0xFF;
        l2 |= (long)(byArray[n2++] & 0xFF) << 8;
        l2 |= (long)(byArray[n2++] & 0xFF) << 16;
        return l2 |= (long)(byArray[n2++] & 0xFF) << 24;
    }

    public static byte[] getBytesWithLength(byte[] byArray, int n2) {
        int n3 = ByteUtil.getInt(byArray, n2);
        byte[] byArray2 = new byte[n3];
        System.arraycopy(byArray, n2 + 4, byArray2, 0, n3);
        return byArray2;
    }

    public static byte[] getBytesWithLength2(byte[] byArray, int n2) {
        int n3 = ByteUtil.getUB2(byArray, n2);
        byte[] byArray2 = new byte[n3];
        System.arraycopy(byArray, n2 + 2, byArray2, 0, n3);
        return byArray2;
    }

    public static byte[] getBytes(byte[] byArray, int n2, int n3) {
        byte[] byArray2 = new byte[n3];
        System.arraycopy(byArray, n2, byArray2, 0, n3);
        return byArray2;
    }

    public static int getBytes(byte[] byArray, int n2, byte[] byArray2) {
        return ByteUtil.getBytes(byArray, n2, byArray2, 0, byArray2.length);
    }

    public static int getBytes(byte[] byArray, int n2, byte[] byArray2, int n3, int n4) {
        System.arraycopy(byArray, n2, byArray2, n3, n4);
        return n4;
    }

    public static String getString(byte[] byArray, int n2, int n3, Charset charset) {
        String string = new String(byArray, n2, n3, charset);
        return string;
    }

    public static String getStringWithLength(byte[] byArray, int n2, Charset charset) {
        int n3 = ByteUtil.getInt(byArray, n2);
        return ByteUtil.getString(byArray, n2 += 4, n3, charset);
    }

    public static String getStringWithLength2(byte[] byArray, int n2, Charset charset) {
        int n3 = ByteUtil.getUB2(byArray, n2);
        return ByteUtil.getString(byArray, n2 += 2, n3, charset);
    }

    public static byte[] fromByte(byte by) {
        return new byte[]{by};
    }

    public static byte[] fromShort(short s2) {
        return new byte[]{(byte)s2, (byte)(s2 >> 8)};
    }

    public static byte[] fromInt(int n2) {
        return new byte[]{(byte)n2, (byte)(n2 >> 8), (byte)(n2 >> 16), (byte)(n2 >> 24)};
    }

    public static byte[] fromLong(long l2) {
        return new byte[]{(byte)l2, (byte)(l2 >> 8), (byte)(l2 >> 16), (byte)(l2 >> 24), (byte)(l2 >> 32), (byte)(l2 >> 40), (byte)(l2 >> 48), (byte)(l2 >> 56)};
    }

    public static byte[] fromFloat(float f2) {
        return ByteUtil.fromInt(Float.floatToIntBits(f2));
    }

    public static byte[] fromDouble(double d2) {
        return ByteUtil.fromLong(Double.doubleToLongBits(d2));
    }

    public static byte[] fromUB1(int n2) {
        return new byte[]{(byte)n2};
    }

    public static byte[] fromUB2(int n2) {
        return new byte[]{(byte)n2, (byte)(n2 >> 8)};
    }

    public static byte[] fromUB3(int n2) {
        return new byte[]{(byte)n2, (byte)(n2 >> 8), (byte)(n2 >> 16)};
    }

    public static byte[] fromUB4(long l2) {
        return new byte[]{(byte)l2, (byte)(l2 >> 8), (byte)(l2 >> 16), (byte)(l2 >> 24)};
    }

    public static byte[] fromString(String string, Charset charset) {
        if (string == null) {
            string = "";
        }
        byte[] byArray = null;
        byArray = string.getBytes(charset);
        return byArray;
    }

    public static byte toByte(byte[] byArray) {
        return ByteUtil.getByte(byArray, 0);
    }

    public static short toShort(byte[] byArray) {
        return ByteUtil.getShort(byArray, 0);
    }

    public static int toInt(byte[] byArray) {
        return ByteUtil.getInt(byArray, 0);
    }

    public static long toLong(byte[] byArray) {
        return ByteUtil.getLong(byArray, 0);
    }

    public static float toFloat(byte[] byArray) {
        return ByteUtil.getFloat(byArray, 0);
    }

    public static double toDouble(byte[] byArray) {
        return ByteUtil.getDouble(byArray, 0);
    }

    public static int toUB1(byte[] byArray) {
        return ByteUtil.getUB1(byArray, 0);
    }

    public static int toUB2(byte[] byArray) {
        return ByteUtil.getUB2(byArray, 0);
    }

    public static int toUB3(byte[] byArray) {
        return ByteUtil.getUB3(byArray, 0);
    }

    public static long toUB4(byte[] byArray) {
        return ByteUtil.getUB4(byArray, 0);
    }

    public static String toString(byte[] byArray, Charset charset) {
        return new String(byArray, charset);
    }

    public static int indexOf(byte[] byArray, byte[] byArray2) {
        int n2 = -1;
        int n3 = byArray.length - byArray2.length;
        if (n3 < 0) {
            return n2;
        }
        int n4 = 0;
        while (n4 <= n3) {
            int n5 = 0;
            while (n5 < byArray2.length) {
                int n6 = byArray2[n5] & 0xFF;
                int n7 = byArray[n4 + n5] & 0xFF;
                if (n6 != n7) break;
                ++n5;
            }
            if (n5 == byArray2.length) {
                n2 = n4;
                break;
            }
            ++n4;
        }
        return n2;
    }

    public static void main(String[] stringArray) {
        byte[] byArray = new byte[8];
        ByteUtil.setLong(byArray, 0, -128L);
        System.out.println(ByteUtil.getLong(byArray, 0));
        ByteUtil.setUB4(byArray, 0, 0xFFFFFFFFL);
        System.out.println(ByteUtil.getUB4(byArray, 0));
    }
}

