/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.framework.config;

import com.ruoyi.framework.config.properties.PermitAllUrlProperties;
import com.ruoyi.framework.security.filter.JwtAuthenticationTokenFilter;
import com.ruoyi.framework.security.handle.AuthenticationEntryPointImpl;
import com.ruoyi.framework.security.handle.LogoutSuccessHandlerImpl;
import javax.servlet.Filter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.HttpMethod;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.ProviderManager;
import org.springframework.security.authentication.dao.DaoAuthenticationProvider;
import org.springframework.security.config.annotation.method.configuration.EnableMethodSecurity;
import org.springframework.security.config.annotation.web.HttpSecurityBuilder;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configurers.AuthorizeHttpRequestsConfigurer;
import org.springframework.security.config.annotation.web.configurers.ExceptionHandlingConfigurer;
import org.springframework.security.config.annotation.web.configurers.HeadersConfigurer;
import org.springframework.security.config.annotation.web.configurers.LogoutConfigurer;
import org.springframework.security.config.annotation.web.configurers.SessionManagementConfigurer;
import org.springframework.security.config.http.SessionCreationPolicy;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.security.web.authentication.UsernamePasswordAuthenticationFilter;
import org.springframework.security.web.authentication.logout.LogoutFilter;
import org.springframework.security.web.authentication.logout.LogoutSuccessHandler;
import org.springframework.web.filter.CorsFilter;

@EnableMethodSecurity(prePostEnabled=true, securedEnabled=true)
@Configuration
public class SecurityConfig {
    @Autowired
    private UserDetailsService userDetailsService;
    @Autowired
    private AuthenticationEntryPointImpl unauthorizedHandler;
    @Autowired
    private LogoutSuccessHandlerImpl logoutSuccessHandler;
    @Autowired
    private JwtAuthenticationTokenFilter authenticationTokenFilter;
    @Autowired
    private CorsFilter corsFilter;
    @Autowired
    private PermitAllUrlProperties permitAllUrl;

    @Bean
    public AuthenticationManager authenticationManager() {
        DaoAuthenticationProvider daoAuthenticationProvider = new DaoAuthenticationProvider();
        daoAuthenticationProvider.setUserDetailsService(this.userDetailsService);
        daoAuthenticationProvider.setPasswordEncoder((PasswordEncoder)this.bCryptPasswordEncoder());
        return new ProviderManager(new AuthenticationProvider[]{daoAuthenticationProvider});
    }

    @Bean
    protected SecurityFilterChain filterChain(HttpSecurity httpSecurity) throws Exception {
        return (SecurityFilterChain)httpSecurity.csrf(csrf -> {
            HttpSecurityBuilder httpSecurityBuilder = csrf.disable();
        }).headers(headersCustomizer -> headersCustomizer.cacheControl(cache -> {
            HeadersConfigurer headersConfigurer = cache.disable();
        }).frameOptions(options -> {
            HeadersConfigurer headersConfigurer = options.sameOrigin();
        })).exceptionHandling(exception -> {
            ExceptionHandlingConfigurer exceptionHandlingConfigurer = exception.authenticationEntryPoint((AuthenticationEntryPoint)this.unauthorizedHandler);
        }).sessionManagement(session -> {
            SessionManagementConfigurer sessionManagementConfigurer = session.sessionCreationPolicy(SessionCreationPolicy.STATELESS);
        }).authorizeHttpRequests(requests -> ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)requests.antMatchers(new String[]{"/api/models/list/test"})).permitAll().antMatchers(new String[]{"/watershed/models/list/test"})).permitAll().antMatchers(new String[]{"/watershed/model/list/test"})).permitAll().antMatchers(new String[]{"/api/models/upload"})).permitAll().antMatchers(new String[]{"/watershed/models/upload"})).permitAll().antMatchers(new String[]{"/watershed/model/upload"})).permitAll().antMatchers(new String[]{"/login", "/register", "/captchaImage"})).permitAll().antMatchers(HttpMethod.GET, new String[]{"/", "/*.html", "/**/*.html", "/**/*.css", "/**/*.js", "/profile/**"})).permitAll().antMatchers(new String[]{"/swagger-ui.html", "/swagger-resources/**", "/webjars/**", "/*/api-docs", "/druid/**"})).permitAll().antMatchers(this.permitAllUrl.getUrls().toArray(new String[0]))).permitAll().anyRequest()).authenticated()).logout(logout -> {
            LogoutConfigurer logoutConfigurer = logout.logoutUrl("/logout").logoutSuccessHandler((LogoutSuccessHandler)this.logoutSuccessHandler);
        }).addFilterBefore((Filter)this.authenticationTokenFilter, UsernamePasswordAuthenticationFilter.class).addFilterBefore((Filter)this.corsFilter, JwtAuthenticationTokenFilter.class).addFilterBefore((Filter)this.corsFilter, LogoutFilter.class).build();
    }

    @Bean
    public BCryptPasswordEncoder bCryptPasswordEncoder() {
        return new BCryptPasswordEncoder();
    }
}

