/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.dialect.gaussdb.parser;

import com.alibaba.druid.DbType;
import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLPartitionBy;
import com.alibaba.druid.sql.ast.SQLPartitionByHash;
import com.alibaba.druid.sql.ast.SQLPartitionByList;
import com.alibaba.druid.sql.ast.SQLPartitionByRange;
import com.alibaba.druid.sql.ast.statement.SQLCreateTableStatement;
import com.alibaba.druid.sql.ast.statement.SQLSelectOrderByItem;
import com.alibaba.druid.sql.dialect.gaussdb.ast.GaussDbDistributeBy;
import com.alibaba.druid.sql.dialect.gaussdb.ast.stmt.GaussDbCreateTableStatement;
import com.alibaba.druid.sql.dialect.gaussdb.parser.GaussDbExprParser;
import com.alibaba.druid.sql.dialect.postgresql.parser.PGCreateTableParser;
import com.alibaba.druid.sql.parser.ParserException;
import com.alibaba.druid.sql.parser.SQLExprParser;
import com.alibaba.druid.sql.parser.SQLParserFeature;
import com.alibaba.druid.sql.parser.Token;
import com.alibaba.druid.util.FnvHash;

public class GaussDbCreateTableParser
extends PGCreateTableParser {
    public GaussDbCreateTableParser(String sql) {
        super(new GaussDbExprParser(sql, new SQLParserFeature[0]));
    }

    @Override
    protected SQLCreateTableStatement newCreateStatement() {
        return new GaussDbCreateTableStatement();
    }

    @Override
    public GaussDbExprParser getExprParser() {
        return (GaussDbExprParser)this.exprParser;
    }

    public GaussDbCreateTableParser(SQLExprParser exprParser) {
        super(exprParser);
        this.dbType = DbType.gaussdb;
    }

    @Override
    protected void createTableBodyItem(SQLCreateTableStatement createTable) {
        if (this.lexer.token() == Token.PARTIAL) {
            this.lexer.nextToken();
            if (this.lexer.nextIfIdentifier(FnvHash.Constants.CLUSTER)) {
                this.accept(Token.KEY);
                this.accept(Token.LPAREN);
                while (true) {
                    SQLSelectOrderByItem item = this.exprParser.parseSelectOrderByItem();
                    createTable.addClusteredByItem(item);
                    if (this.lexer.token() == Token.COMMA) {
                        this.lexer.nextToken();
                        continue;
                    }
                    if (this.lexer.token() == Token.RPAREN) break;
                }
                this.accept(Token.RPAREN);
            }
        } else {
            super.createTableBodyItem(createTable);
        }
    }

    @Override
    protected void parseCreateTableRest(SQLCreateTableStatement stmt) {
        SQLPartitionBy partitionClause;
        GaussDbDistributeBy distributeByClause;
        GaussDbCreateTableStatement gdStmt = (GaussDbCreateTableStatement)stmt;
        if (this.lexer.identifierEquals(FnvHash.Constants.SERVER)) {
            this.acceptIdentifier(FnvHash.Constants.SERVER);
            gdStmt.setServer(this.exprParser.expr());
            this.acceptIdentifier(FnvHash.Constants.OPTIONS);
            this.accept(Token.LPAREN);
            this.parseAssignItems(stmt.getTableOptions(), stmt, false);
            this.accept(Token.RPAREN);
            if (this.lexer.nextIfIdentifier("write")) {
                this.accept(Token.ONLY);
                gdStmt.setForeignTableMode(GaussDbCreateTableStatement.ForeignTableMode.WRITE_ONLY);
            } else if (this.lexer.identifierEquals("read")) {
                if (this.lexer.nextIf(Token.ONLY)) {
                    gdStmt.setForeignTableMode(GaussDbCreateTableStatement.ForeignTableMode.READ_ONLY);
                } else if (this.lexer.identifierEquals("write")) {
                    gdStmt.setForeignTableMode(GaussDbCreateTableStatement.ForeignTableMode.READ_WRITE);
                }
            }
        }
        if (this.lexer.token() == Token.WITH) {
            this.lexer.nextToken();
            this.accept(Token.LPAREN);
            this.parseAssignItems(gdStmt.getTableOptions(), gdStmt, false);
            this.accept(Token.RPAREN);
        }
        if (this.lexer.nextIf(Token.ON) && this.lexer.nextIfIdentifier(FnvHash.Constants.COMMIT) && (this.lexer.identifierEquals("PRESERVE") || this.lexer.token() == Token.DELETE)) {
            gdStmt.setOnCommitExpr(this.exprParser.name());
            this.accept(Token.ROWS);
        }
        if (this.lexer.identifierEquals("COMPRESS") || this.lexer.identifierEquals("NOCOMPRESS")) {
            gdStmt.setCompressType(this.exprParser.name());
        }
        if ((distributeByClause = this.parseDistributeBy()) != null) {
            gdStmt.setDistributeBy(distributeByClause);
        }
        if (this.lexer.nextIf(Token.TO)) {
            if (this.lexer.nextIf(Token.GROUP)) {
                SQLExpr group = this.exprParser.expr();
                gdStmt.setToGroup(group);
            }
            if (this.lexer.nextIfIdentifier(FnvHash.Constants.NODE)) {
                SQLExpr node = this.exprParser.expr();
                gdStmt.setToNode(node);
            }
        }
        if ((partitionClause = this.parsePartitionBy()) != null) {
            gdStmt.setPartitionBy(partitionClause);
        }
        this.parseRowMovement(gdStmt);
        if (this.lexer.nextIf(Token.COMMENT)) {
            this.lexer.nextIf(Token.EQ);
            SQLExpr comment = this.exprParser.expr();
            gdStmt.setComment(comment);
        }
    }

    public void parseRowMovement(GaussDbCreateTableStatement stmt) {
        if (this.lexer.token() == Token.ENABLE || this.lexer.token() == Token.DISABLE) {
            stmt.setRowMovementType(this.exprParser.name());
            this.accept(Token.ROW);
            this.acceptIdentifier("MOVEMENT");
        }
    }

    @Override
    public SQLPartitionBy parsePartitionBy() {
        if (this.lexer.nextIf(Token.PARTITION)) {
            this.accept(Token.BY);
            if (this.lexer.nextIfIdentifier(FnvHash.Constants.HASH)) {
                SQLPartitionByHash hashPartition = new SQLPartitionByHash();
                if (this.lexer.nextIf(Token.LPAREN)) {
                    if (this.lexer.token() != Token.IDENTIFIER) {
                        throw new ParserException("expect identifier. " + this.lexer.info());
                    }
                    while (true) {
                        hashPartition.addColumn(this.exprParser.name());
                        if (this.lexer.token() != Token.COMMA) break;
                        this.lexer.nextToken();
                    }
                    this.accept(Token.RPAREN);
                    return hashPartition;
                }
            } else {
                if (this.lexer.nextIfIdentifier(FnvHash.Constants.RANGE)) {
                    return this.partitionByRange();
                }
                if (this.lexer.nextIfIdentifier(FnvHash.Constants.LIST)) {
                    return this.partitionByList();
                }
            }
        }
        return null;
    }

    @Override
    protected SQLPartitionByRange partitionByRange() {
        SQLPartitionByRange rangePartition = new SQLPartitionByRange();
        this.accept(Token.LPAREN);
        while (true) {
            rangePartition.addColumn(this.exprParser.name());
            if (this.lexer.token() != Token.COMMA) break;
            this.lexer.nextToken();
        }
        this.accept(Token.RPAREN);
        this.accept(Token.LPAREN);
        while (true) {
            rangePartition.addPartition(this.getExprParser().parsePartition());
            if (this.lexer.token() != Token.COMMA) break;
            this.lexer.nextToken();
        }
        this.accept(Token.RPAREN);
        return rangePartition;
    }

    private SQLPartitionByList partitionByList() {
        SQLPartitionByList listPartition = new SQLPartitionByList();
        this.accept(Token.LPAREN);
        while (true) {
            listPartition.addColumn(this.exprParser.name());
            if (this.lexer.token() != Token.COMMA) break;
            this.lexer.nextToken();
        }
        this.accept(Token.RPAREN);
        this.accept(Token.LPAREN);
        while (this.lexer.token() == Token.PARTITION) {
            listPartition.addPartition(this.getExprParser().parsePartition());
            if (this.lexer.token() != Token.COMMA) break;
            this.lexer.nextToken();
        }
        this.accept(Token.RPAREN);
        return listPartition;
    }

    @Override
    protected void createTableBefore(SQLCreateTableStatement createTable) {
        this.parseTableType(createTable);
        this.parseTableType(createTable);
    }

    private void parseTableType(SQLCreateTableStatement createTable) {
        if (this.lexer.nextIfIdentifier("UNLOGGED")) {
            createTable.config(SQLCreateTableStatement.Feature.Unlogged);
        } else if (this.lexer.nextIfIdentifier(FnvHash.Constants.GLOBAL)) {
            createTable.config(SQLCreateTableStatement.Feature.Global);
        } else if (this.lexer.nextIfIdentifier(FnvHash.Constants.TEMPORARY) || this.lexer.nextIfIdentifier("TEMP")) {
            createTable.config(SQLCreateTableStatement.Feature.Temporary);
        } else if (this.lexer.nextIf(Token.LOCAL)) {
            createTable.config(SQLCreateTableStatement.Feature.Local);
        } else if (this.lexer.nextIf(Token.FOREIGN)) {
            createTable.config(SQLCreateTableStatement.Feature.External);
        }
    }

    public GaussDbDistributeBy parseDistributeBy() {
        if (this.lexer.token() == Token.DISTRIBUTE) {
            this.lexer.nextToken();
            this.accept(Token.BY);
            GaussDbDistributeBy distributeBy = new GaussDbDistributeBy();
            if (this.lexer.identifierEquals(FnvHash.Constants.HASH)) {
                distributeBy.setType(this.exprParser.name());
                if (this.lexer.nextIf(Token.LPAREN)) {
                    while (true) {
                        distributeBy.addColumn(this.exprParser.name());
                        if (this.lexer.token() != Token.COMMA) break;
                        this.lexer.nextToken();
                    }
                    this.accept(Token.RPAREN);
                    return distributeBy;
                }
            } else {
                if (this.lexer.identifierEquals(FnvHash.Constants.ROUNDROBIN)) {
                    distributeBy.setType(this.exprParser.name());
                    return distributeBy;
                }
                if (this.lexer.identifierEquals(FnvHash.Constants.REPLICATION)) {
                    distributeBy.setType(this.exprParser.name());
                    return distributeBy;
                }
            }
        }
        return null;
    }

    public GaussDbDistributeBy distributionByContent(GaussDbDistributeBy distributeBy) {
        this.accept(Token.LPAREN);
        while (true) {
            distributeBy.addColumn(this.exprParser.name());
            if (this.lexer.token() != Token.COMMA) break;
            this.lexer.nextToken();
        }
        this.accept(Token.RPAREN);
        this.accept(Token.LPAREN);
        while (true) {
            distributeBy.addDistribution(this.getExprParser().parseDistribution());
            if (this.lexer.token() != Token.COMMA) break;
            this.lexer.nextToken();
        }
        this.accept(Token.RPAREN);
        return distributeBy;
    }
}

