/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.dialect.teradata.visitor;

import com.alibaba.druid.DbType;
import com.alibaba.druid.sql.ast.SQLDataType;
import com.alibaba.druid.sql.ast.SQLTop;
import com.alibaba.druid.sql.ast.statement.SQLCreateTableStatement;
import com.alibaba.druid.sql.ast.statement.SQLPrimaryKeyImpl;
import com.alibaba.druid.sql.ast.statement.SQLSelectQueryBlock;
import com.alibaba.druid.sql.dialect.teradata.ast.TDCreateTableStatement;
import com.alibaba.druid.sql.dialect.teradata.ast.TDDateDataType;
import com.alibaba.druid.sql.dialect.teradata.ast.TDNormalize;
import com.alibaba.druid.sql.dialect.teradata.ast.TDSelectQueryBlock;
import com.alibaba.druid.sql.dialect.teradata.visitor.TDASTVisitor;
import com.alibaba.druid.sql.visitor.SQLASTOutputVisitor;

public class TDOutputVisitor
extends SQLASTOutputVisitor
implements TDASTVisitor {
    public TDOutputVisitor(StringBuilder appender) {
        super(appender, DbType.teradata);
    }

    @Override
    protected void printSelectListBefore(SQLSelectQueryBlock x) {
        if (x instanceof TDSelectQueryBlock) {
            this.print(' ');
            TDSelectQueryBlock tdSelectQueryBlock = (TDSelectQueryBlock)x;
            if (tdSelectQueryBlock.isWithDeletedRows()) {
                this.print0(this.ucase ? "WITH DELETED ROWS " : " with deleted rows ");
            }
            if (tdSelectQueryBlock.isAsJson()) {
                this.print0(this.ucase ? "AS JSON " : " as json ");
            }
        }
    }

    @Override
    public void printSqlSetQuantifier(SQLSelectQueryBlock x) {
        int distinctOption = x.getDistionOption();
        if (1 == distinctOption) {
            this.print0(this.ucase ? "ALL " : "all ");
        } else if (2 == distinctOption) {
            this.print0(this.ucase ? "DISTINCT " : "distinct ");
        } else if (x instanceof TDSelectQueryBlock && ((TDSelectQueryBlock)x).getNormalize() != null) {
            TDNormalize normalize = ((TDSelectQueryBlock)x).getNormalize();
            this.print0(this.ucase ? "NORMALIZE " : "normalize ");
            if (normalize.isMeets() || normalize.isOverlaps()) {
                this.print0(this.ucase ? "ON " : "on ");
                if (normalize.isMeetsFirst()) {
                    this.print0(this.ucase ? "MEETS " : "meets ");
                } else {
                    this.print0(this.ucase ? "OVERLAPS " : "overlaps ");
                }
                if (normalize.isMeets() && normalize.isOverlaps()) {
                    this.print0(this.ucase ? "OR " : "or ");
                    if (!normalize.isMeetsFirst()) {
                        this.print0(this.ucase ? "MEETS " : "meets ");
                    } else {
                        this.print0(this.ucase ? "OVERLAPS " : "overlaps ");
                    }
                }
            }
        }
    }

    @Override
    public void printTop(SQLSelectQueryBlock x) {
        SQLTop top;
        if (x instanceof TDSelectQueryBlock && (top = ((TDSelectQueryBlock)x).getTop()) != null) {
            this.print(' ');
            this.visit(top);
        }
    }

    @Override
    public boolean visit(SQLDataType x) {
        TDDateDataType dataType;
        super.visit(x);
        if (x instanceof TDDateDataType && (dataType = (TDDateDataType)x).getFormat() != null) {
            this.print(this.ucase ? " FORMAT " : " format ");
            dataType.getFormat().accept(this);
        }
        return false;
    }

    @Override
    protected void printCreateTableRest(SQLCreateTableStatement x) {
        if (x instanceof TDCreateTableStatement) {
            TDCreateTableStatement stmt = (TDCreateTableStatement)x;
            if (stmt.getPrimaryKey() != null) {
                this.visit((SQLPrimaryKeyImpl)stmt.getPrimaryKey());
            }
            if (stmt.getOnCommitRows() != null) {
                this.print0(this.ucase ? "ON COMMIT " : "on commit ");
                this.print0(this.ucase ? stmt.getOnCommitRows().name().toUpperCase() : stmt.getOnCommitRows().name().toLowerCase());
                this.print0(this.ucase ? " ROWS" : " rows");
            }
        }
    }

    @Override
    public boolean visit(SQLPrimaryKeyImpl x) {
        this.println();
        this.print0(this.ucase ? "PRIMARY INDEX " : "primary index ");
        this.print('(');
        this.printAndAccept(x.getColumns(), ", ");
        this.print(')');
        this.println();
        return false;
    }
}

