/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.common.enums;

import java.util.HashMap;
import java.util.Map;
import org.springframework.lang.Nullable;

public enum HttpMethod {
    GET,
    HEAD,
    POST,
    PUT,
    PATCH,
    DELETE,
    OPTIONS,
    TRACE;

    private static final Map<String, HttpMethod> mappings;

    static {
        mappings = new HashMap<String, HttpMethod>(16);
        HttpMethod[] httpMethodArray = HttpMethod.values();
        int n = httpMethodArray.length;
        int n2 = 0;
        while (n2 < n) {
            HttpMethod httpMethod = httpMethodArray[n2];
            mappings.put(httpMethod.name(), httpMethod);
            ++n2;
        }
    }

    @Nullable
    public static HttpMethod resolve(@Nullable String method) {
        return method != null ? mappings.get(method) : null;
    }

    public boolean matches(String method) {
        return this == HttpMethod.resolve(method);
    }
}

