/*
 * Decompiled with CFR 0.152.
 */
package kl.ssl.gmvpn.crypto.impl.jcajce;

import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.MGF1ParameterSpec;
import java.security.spec.PSSParameterSpec;
import kl.ssl.gmvpn.HashAlgorithm;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.gm.GMObjectIdentifiers;
import org.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.jcajce.util.JcaJceHelper;

class RSAUtil {
    RSAUtil() {
    }

    static String getDigestSigAlgName(String name) {
        int dIndex = name.indexOf(45);
        if (dIndex > 0 && !name.startsWith("SHA3")) {
            return name.substring(0, dIndex) + name.substring(dIndex + 1);
        }
        return name;
    }

    static AlgorithmParameterSpec getPSSParameterSpec(short hash, String digestName, JcaJceHelper helper) throws NoSuchProviderException, NoSuchAlgorithmException {
        MGF1ParameterSpec mgf1Spec = new MGF1ParameterSpec(digestName);
        return new PSSParameterSpec(digestName, "MGF1", mgf1Spec, HashAlgorithm.getOutputSize(hash), 1);
    }

    private static AlgorithmIdentifier getHashAlgorithmID(short hashAlgorithm) {
        switch (hashAlgorithm) {
            case 4: {
                return new AlgorithmIdentifier(NISTObjectIdentifiers.id_sha256, (ASN1Encodable)DERNull.INSTANCE);
            }
            case 5: {
                return new AlgorithmIdentifier(NISTObjectIdentifiers.id_sha384, (ASN1Encodable)DERNull.INSTANCE);
            }
            case 6: {
                return new AlgorithmIdentifier(NISTObjectIdentifiers.id_sha512, (ASN1Encodable)DERNull.INSTANCE);
            }
            case 7: {
                return new AlgorithmIdentifier(GMObjectIdentifiers.sm3, (ASN1Encodable)DERNull.INSTANCE);
            }
        }
        return null;
    }
}

