/*
 * Decompiled with CFR 0.152.
 */
package com.koal.kms.sdk.ed;

import com.ghca.kms.thrift.api.Mode;
import com.koal.kms.sdk.ed.ClientBuilder;
import com.koal.kms.sdk.ed.CompressUtil;
import com.koal.kms.sdk.ed.DataKey;
import com.koal.kms.sdk.ed.KmsCache;
import com.koal.kms.sdk.ed.KmsClient;
import com.koal.kms.sdk.ed.KmsClientConfig;
import com.koal.kms.sdk.ed.KmsSdkException;
import com.koal.kms.sdk.ed.KmsUtil;
import com.koal.kms.sdk.ed.RandomSource;
import java.security.Key;
import java.security.Provider;
import java.security.Security;
import java.util.Arrays;
import java.util.Base64;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class KmsGcm {
    private static final int KEY_LEN = 32;
    private static final int ID_LEN = 36;
    private static final byte[] IV = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};

    public static byte[] encrypt(byte[] plain) throws KmsSdkException {
        DataKey key = KmsCache.CACHE.getEncrypt();
        byte[] iv = KmsUtil.generateRandom(16, RandomSource.LOCAL_RANDOM);
        try {
            if (!KmsClientConfig.getInstance().getLocal().booleanValue()) {
                KmsClient instance = ClientBuilder.getInstance();
                String cipherText = instance.symmetricEncryptByDataKey(KmsClientConfig.getInstance().getCrtKeyId(), key.getDataKeyId(), Base64.getEncoder().encodeToString(plain), Mode.GCM, null);
                return Base64.getDecoder().decode(cipherText);
            }
            byte[] cipherData = KmsGcm.sm4Encrypt(key.getPlainKey(), plain, iv);
            byte[] cipherKey = key.getCipherKey();
            byte[] cmkId = key.getCmkId().getBytes();
            cmkId = CompressUtil.compressCmkIdAndIv(cmkId, iv);
            int total = cipherData.length + cipherKey.length + cmkId.length;
            byte[] temp = new byte[total];
            System.arraycopy(cipherData, 0, temp, 0, cipherData.length);
            System.arraycopy(cipherKey, 0, temp, cipherData.length, cipherKey.length);
            System.arraycopy(cmkId, 0, temp, cipherData.length + cipherKey.length, cmkId.length);
            return temp;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static byte[] encryptOld(byte[] plain) {
        DataKey key = KmsCache.CACHE.getEncrypt();
        try {
            if (!KmsClientConfig.getInstance().getLocal().booleanValue()) {
                KmsClient instance = ClientBuilder.getInstance();
                String cipherText = instance.symmetricEncryptByDataKey(KmsClientConfig.getInstance().getCrtKeyId(), key.getDataKeyId(), Base64.getEncoder().encodeToString(plain), Mode.GCM, null);
                return Base64.getDecoder().decode(cipherText);
            }
            byte[] cipherData = KmsGcm.sm4Encrypt(key.getPlainKey(), plain);
            byte[] cipherKey = key.getCipherKey();
            byte[] cmkId = key.getCmkId().getBytes();
            int total = cipherData.length + cipherKey.length + cmkId.length;
            byte[] temp = new byte[total];
            System.arraycopy(cipherData, 0, temp, 0, cipherData.length);
            System.arraycopy(cipherKey, 0, temp, cipherData.length, cipherKey.length);
            System.arraycopy(cmkId, 0, temp, cipherData.length + cipherKey.length, cmkId.length);
            return temp;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static byte[] sm4Encrypt(byte[] keyBytes, byte[] plain) throws Exception {
        Cipher cipher = Cipher.getInstance("SM4/GCM/NoPadding", "BC");
        SecretKeySpec key = new SecretKeySpec(keyBytes, "SM4");
        cipher.init(1, (Key)key, new IvParameterSpec(IV));
        return cipher.doFinal(plain);
    }

    private static byte[] sm4Encrypt(byte[] keyBytes, byte[] plain, byte[] iv) throws Exception {
        iv = iv == null ? IV : iv;
        Cipher cipher = Cipher.getInstance("SM4/GCM/NoPadding", "BC");
        SecretKeySpec key = new SecretKeySpec(keyBytes, "SM4");
        cipher.init(1, (Key)key, new IvParameterSpec(iv));
        return cipher.doFinal(plain);
    }

    public static byte[] decrypt(byte[] cipherData) throws KmsSdkException {
        byte[] data = Arrays.copyOfRange(cipherData, 0, cipherData.length - 32 - 36);
        byte[] cipherKey = Arrays.copyOfRange(cipherData, data.length, data.length + 32);
        byte[] cmkIdIv = Arrays.copyOfRange(cipherData, data.length + 32, cipherData.length);
        CompressUtil.CmkIdAndIv cmkIdAndIv = CompressUtil.uncompressCmkIdAndIv(cmkIdIv);
        DataKey key = KmsCache.CACHE.getDecrypt(cipherKey, new String(cmkIdAndIv.getCmkId()));
        try {
            if (!KmsClientConfig.getInstance().getLocal().booleanValue()) {
                KmsClient instance = ClientBuilder.getInstance();
                String plainText = instance.symmetricDecryptByDataKey(key.getDataKeyId(), Base64.getEncoder().encodeToString(cipherData), Mode.CBC, Base64.getEncoder().encodeToString(key.getCipherKey()));
                return Base64.getDecoder().decode(plainText);
            }
            return KmsGcm.sm4Decrypt(key.getPlainKey(), data, cmkIdAndIv.getIv());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static byte[] sm4Decrypt(byte[] keyBytes, byte[] plain) throws Exception {
        Cipher cipher = Cipher.getInstance("SM4/GCM/NoPadding", "BC");
        SecretKeySpec key = new SecretKeySpec(keyBytes, "SM4");
        cipher.init(2, (Key)key, new IvParameterSpec(IV));
        return cipher.doFinal(plain);
    }

    private static byte[] sm4Decrypt(byte[] keyBytes, byte[] plain, byte[] iv) throws Exception {
        iv = iv == null ? IV : iv;
        Cipher cipher = Cipher.getInstance("SM4/GCM/NoPadding", "BC");
        SecretKeySpec key = new SecretKeySpec(keyBytes, "SM4");
        cipher.init(2, (Key)key, new IvParameterSpec(iv));
        return cipher.doFinal(plain);
    }

    static {
        if (Security.getProvider("BC") == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
    }
}

