/*
 * Decompiled with CFR 0.152.
 */
package kl.ssl.gmvpn.crypto.impl.bc;

import java.io.IOException;
import java.security.SecureRandom;
import kl.ssl.gmvpn.HashAlgorithm;
import kl.ssl.gmvpn.NamedGroup;
import kl.ssl.gmvpn.ProtocolVersion;
import kl.ssl.gmvpn.SignatureAndHashAlgorithm;
import kl.ssl.gmvpn.TlsFatalAlert;
import kl.ssl.gmvpn.TlsUtils;
import kl.ssl.gmvpn.crypto.SM2CipherText;
import kl.ssl.gmvpn.crypto.TlsCertificate;
import kl.ssl.gmvpn.crypto.TlsCipher;
import kl.ssl.gmvpn.crypto.TlsCryptoParameters;
import kl.ssl.gmvpn.crypto.TlsHMAC;
import kl.ssl.gmvpn.crypto.TlsHash;
import kl.ssl.gmvpn.crypto.TlsNonceGenerator;
import kl.ssl.gmvpn.crypto.TlsSecret;
import kl.ssl.gmvpn.crypto.impl.AbstractTlsCrypto;
import kl.ssl.gmvpn.crypto.impl.SM2Util;
import kl.ssl.gmvpn.crypto.impl.TlsAEADCipher;
import kl.ssl.gmvpn.crypto.impl.TlsAEADCipherImpl;
import kl.ssl.gmvpn.crypto.impl.TlsBlockCipher;
import kl.ssl.gmvpn.crypto.impl.TlsBlockCipherImpl;
import kl.ssl.gmvpn.crypto.impl.TlsEncryptor;
import kl.ssl.gmvpn.crypto.impl.TlsNullCipher;
import kl.ssl.gmvpn.crypto.impl.bc.BcTlsCertificate;
import kl.ssl.gmvpn.crypto.impl.bc.BcTlsSecret;
import org.bouncycastle.crypto.AsymmetricBlockCipher;
import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.ExtendedDigest;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.RuntimeCryptoException;
import org.bouncycastle.crypto.digests.MD5Digest;
import org.bouncycastle.crypto.digests.NullDigest;
import org.bouncycastle.crypto.digests.SHA1Digest;
import org.bouncycastle.crypto.digests.SHA224Digest;
import org.bouncycastle.crypto.digests.SHA256Digest;
import org.bouncycastle.crypto.digests.SHA384Digest;
import org.bouncycastle.crypto.digests.SHA512Digest;
import org.bouncycastle.crypto.digests.SM3Digest;
import org.bouncycastle.crypto.encodings.PKCS1Encoding;
import org.bouncycastle.crypto.engines.AESEngine;
import org.bouncycastle.crypto.engines.RSABlindedEngine;
import org.bouncycastle.crypto.engines.SM2Engine;
import org.bouncycastle.crypto.engines.SM4Engine;
import org.bouncycastle.crypto.macs.HMac;
import org.bouncycastle.crypto.modes.AEADBlockCipher;
import org.bouncycastle.crypto.modes.CBCBlockCipher;
import org.bouncycastle.crypto.modes.GCMBlockCipher;
import org.bouncycastle.crypto.params.AEADParameters;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.params.ECKeyParameters;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;
import org.bouncycastle.crypto.params.ParametersWithRandom;
import org.bouncycastle.crypto.params.RSAKeyParameters;
import org.bouncycastle.crypto.prng.DigestRandomGenerator;
import org.bouncycastle.util.Arrays;

public class BcTlsCrypto
extends AbstractTlsCrypto {
    private final SecureRandom entropySource;

    public BcTlsCrypto(SecureRandom entropySource) {
        this.entropySource = entropySource;
    }

    BcTlsSecret adoptLocalSecret(byte[] data) {
        return new BcTlsSecret(this, data);
    }

    @Override
    public SecureRandom getSecureRandom() {
        return this.entropySource;
    }

    @Override
    public TlsCertificate createCertificate(byte[] encoding) throws IOException {
        return new BcTlsCertificate(this, encoding);
    }

    @Override
    protected TlsCipher createCipher(TlsCryptoParameters cryptoParams, int encryptionAlgorithm, int macAlgorithm) throws IOException {
        switch (encryptionAlgorithm) {
            case 1: {
                return this.createSM4Cipher(cryptoParams, macAlgorithm);
            }
            case 2: {
                return this.createSM4GCMCipher(cryptoParams, 16, 16);
            }
            case 0: {
                return this.createNullCipher(cryptoParams, macAlgorithm);
            }
        }
        throw new TlsFatalAlert(80);
    }

    @Override
    protected TlsEncryptor createEncryptor(TlsCertificate certificate) throws IOException {
        BcTlsCertificate bcCert = BcTlsCertificate.convert(this, certificate);
        bcCert.validateKeyUsage(32);
        final AsymmetricKeyParameter pubKey = bcCert.getPublicKey();
        if (pubKey instanceof ECKeyParameters) {
            return new TlsEncryptor(){

                @Override
                public byte[] encrypt(byte[] input, int inOff, int length) throws IOException {
                    try {
                        SM2Engine sm2Engine = new SM2Engine();
                        sm2Engine.init(true, (CipherParameters)new ParametersWithRandom((CipherParameters)pubKey, BcTlsCrypto.this.getSecureRandom()));
                        byte[] opaqueCipherText = sm2Engine.processBlock(input, inOff, length);
                        SM2CipherText sm2CipherText = SM2Util.getSM2CipherStructure(opaqueCipherText);
                        return sm2CipherText.getEncoded();
                    }
                    catch (InvalidCipherTextException e) {
                        throw new TlsFatalAlert(80, (Throwable)e);
                    }
                }
            };
        }
        final RSAKeyParameters pubKeyRSA = bcCert.getPubKeyRSA();
        return new TlsEncryptor(){

            @Override
            public byte[] encrypt(byte[] input, int inOff, int length) throws IOException {
                try {
                    PKCS1Encoding encoding = new PKCS1Encoding((AsymmetricBlockCipher)new RSABlindedEngine());
                    encoding.init(true, (CipherParameters)new ParametersWithRandom((CipherParameters)pubKeyRSA, BcTlsCrypto.this.getSecureRandom()));
                    return encoding.processBlock(input, inOff, length);
                }
                catch (InvalidCipherTextException e) {
                    throw new TlsFatalAlert(80, (Throwable)e);
                }
            }
        };
    }

    @Override
    public TlsNonceGenerator createNonceGenerator(byte[] additionalSeedMaterial) {
        final DigestRandomGenerator nonceGen = new DigestRandomGenerator(this.createDigest((short)4));
        if (additionalSeedMaterial != null && additionalSeedMaterial.length > 0) {
            nonceGen.addSeedMaterial(additionalSeedMaterial);
        }
        byte[] seed = new byte[this.createDigest((short)4).getDigestSize()];
        this.entropySource.nextBytes(seed);
        nonceGen.addSeedMaterial(seed);
        return new TlsNonceGenerator(){

            @Override
            public byte[] generateNonce(int size) {
                byte[] nonce = new byte[size];
                nonceGen.nextBytes(nonce);
                return nonce;
            }
        };
    }

    @Override
    public boolean hasAllRawSignatureAlgorithms() {
        return false;
    }

    @Override
    public boolean hasEncryptionAlgorithm(int encryptionAlgorithm) {
        return true;
    }

    @Override
    public boolean hasHashAlgorithm(short hashAlgorithm) {
        return true;
    }

    @Override
    public boolean hasMacAlgorithm(int macAlgorithm) {
        return true;
    }

    @Override
    public boolean hasNamedGroup(int namedGroup) {
        return NamedGroup.refersToASpecificGroup(namedGroup);
    }

    @Override
    public boolean hasRSAEncryption() {
        return true;
    }

    @Override
    public boolean hasSignatureAlgorithm(short signatureAlgorithm) {
        switch (signatureAlgorithm) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 11: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean hasSignatureAndHashAlgorithm(SignatureAndHashAlgorithm sigAndHashAlgorithm) {
        return this.hasSignatureAlgorithm(sigAndHashAlgorithm.getSignature());
    }

    @Override
    public TlsSecret createSecret(byte[] data) {
        return this.adoptLocalSecret(Arrays.clone((byte[])data));
    }

    @Override
    public TlsSecret generateRSAPreMasterSecret(ProtocolVersion version) {
        byte[] data = new byte[48];
        this.entropySource.nextBytes(data);
        TlsUtils.writeVersion(version, data, 0);
        return this.adoptLocalSecret(data);
    }

    public Digest createDigest(short hashAlgorithm) {
        switch (hashAlgorithm) {
            case 0: {
                return new NullDigest();
            }
            case 1: {
                return new MD5Digest();
            }
            case 2: {
                return new SHA1Digest();
            }
            case 3: {
                return new SHA224Digest();
            }
            case 4: {
                return new SHA256Digest();
            }
            case 5: {
                return new SHA384Digest();
            }
            case 6: {
                return new SHA512Digest();
            }
            case 7: {
                return new SM3Digest();
            }
        }
        throw new IllegalArgumentException("invalid HashAlgorithm: " + HashAlgorithm.getText(hashAlgorithm));
    }

    @Override
    public TlsHash createHash(short algorithm) {
        return new BcTlsHash(algorithm, this.createDigest(algorithm));
    }

    public static Digest cloneDigest(short hashAlgorithm, Digest hash) {
        switch (hashAlgorithm) {
            case 1: {
                return new MD5Digest((MD5Digest)hash);
            }
            case 2: {
                return new SHA1Digest((SHA1Digest)hash);
            }
            case 3: {
                return new SHA224Digest((SHA224Digest)hash);
            }
            case 4: {
                return new SHA256Digest((SHA256Digest)hash);
            }
            case 5: {
                return new SHA384Digest((SHA384Digest)hash);
            }
            case 6: {
                return new SHA512Digest((SHA512Digest)hash);
            }
            case 7: {
                return new SM3Digest((SM3Digest)hash);
            }
        }
        throw new IllegalArgumentException("invalid HashAlgorithm: " + HashAlgorithm.getText(hashAlgorithm));
    }

    protected TlsCipher createAESCipher(TlsCryptoParameters cryptoParams, int cipherKeySize, int macAlgorithm) throws IOException {
        return new TlsBlockCipher(this, cryptoParams, new BlockOperator(this.createAESBlockCipher(), true), new BlockOperator(this.createAESBlockCipher(), false), this.createHMAC(macAlgorithm), this.createHMAC(macAlgorithm), cipherKeySize);
    }

    protected TlsNullCipher createNullCipher(TlsCryptoParameters cryptoParams, int macAlgorithm) throws IOException {
        return new TlsNullCipher(cryptoParams, this.createHMAC(macAlgorithm), this.createHMAC(macAlgorithm));
    }

    protected TlsCipher createSM4Cipher(TlsCryptoParameters cryptoParams, int macAlgorithm) throws IOException {
        return new TlsBlockCipher(this, cryptoParams, new BlockOperator(this.createSM4BlockCipher(), true), new BlockOperator(this.createSM4BlockCipher(), false), this.createHMAC(macAlgorithm), this.createHMAC(macAlgorithm), 16);
    }

    protected TlsAEADCipher createSM4GCMCipher(TlsCryptoParameters cryptoParams, int cipherKeySize, int macSize) throws IOException {
        return new TlsAEADCipher(cryptoParams, new AeadOperator(this.createSM4GCMBlockCipher(), true), new AeadOperator(this.createSM4GCMBlockCipher(), false), cipherKeySize, macSize);
    }

    protected BlockCipher createAESEngine() {
        return new AESEngine();
    }

    protected BlockCipher createSM4Engine() {
        return new SM4Engine();
    }

    protected BlockCipher createAESBlockCipher() {
        return new CBCBlockCipher(this.createAESEngine());
    }

    protected BlockCipher createSM4BlockCipher() {
        return new CBCBlockCipher(this.createSM4Engine());
    }

    protected AEADBlockCipher createSM4GCMBlockCipher() {
        return new GCMBlockCipher(this.createSM4Engine());
    }

    @Override
    public TlsHMAC createHMAC(short hashAlgorithm) {
        return new HMacOperator(this.createDigest(hashAlgorithm));
    }

    @Override
    public TlsHMAC createHMAC(int macAlgorithm) {
        return this.createHMAC(TlsUtils.getHashAlgorithmForHMACAlgorithm(macAlgorithm));
    }

    @Override
    public TlsSecret hkdfInit(short hashAlgorithm) {
        return this.adoptLocalSecret(new byte[HashAlgorithm.getOutputSize(hashAlgorithm)]);
    }

    private class HMacOperator
    implements TlsHMAC {
        private final HMac hmac;

        HMacOperator(Digest digest) {
            this.hmac = new HMac(digest);
        }

        @Override
        public void setKey(byte[] key, int keyOff, int keyLen) {
            this.hmac.init((CipherParameters)new KeyParameter(key, keyOff, keyLen));
        }

        @Override
        public void update(byte[] input, int inOff, int length) {
            this.hmac.update(input, inOff, length);
        }

        @Override
        public byte[] calculateMAC() {
            byte[] rv = new byte[this.hmac.getMacSize()];
            this.hmac.doFinal(rv, 0);
            return rv;
        }

        @Override
        public void calculateMAC(byte[] output, int outOff) {
            this.hmac.doFinal(output, outOff);
        }

        @Override
        public int getInternalBlockSize() {
            return ((ExtendedDigest)this.hmac.getUnderlyingDigest()).getByteLength();
        }

        @Override
        public int getMacLength() {
            return this.hmac.getMacSize();
        }

        @Override
        public void reset() {
            this.hmac.reset();
        }
    }

    public class AeadOperator
    implements TlsAEADCipherImpl {
        private final boolean isEncrypting;
        private final AEADBlockCipher cipher;
        private KeyParameter key;

        public AeadOperator(AEADBlockCipher cipher, boolean isEncrypting) {
            this.cipher = cipher;
            this.isEncrypting = isEncrypting;
        }

        @Override
        public void setKey(byte[] key, int keyOff, int keyLen) {
            this.key = new KeyParameter(key, keyOff, keyLen);
        }

        @Override
        public void init(byte[] nonce, int macSize, byte[] additionalData) {
            this.cipher.init(this.isEncrypting, (CipherParameters)new AEADParameters(this.key, macSize * 8, nonce, additionalData));
        }

        @Override
        public int getOutputSize(int inputLength) {
            return this.cipher.getOutputSize(inputLength);
        }

        @Override
        public int doFinal(byte[] input, int inputOffset, int inputLength, byte[] output, int outputOffset) {
            int len = this.cipher.processBytes(input, inputOffset, inputLength, output, outputOffset);
            try {
                return len + this.cipher.doFinal(output, outputOffset + len);
            }
            catch (InvalidCipherTextException e) {
                throw new RuntimeCryptoException(e.toString());
            }
        }
    }

    private class BlockOperator
    implements TlsBlockCipherImpl {
        private final boolean isEncrypting;
        private final BlockCipher cipher;
        private KeyParameter key;

        BlockOperator(BlockCipher cipher, boolean isEncrypting) {
            this.cipher = cipher;
            this.isEncrypting = isEncrypting;
        }

        @Override
        public void setKey(byte[] key, int keyOff, int keyLen) {
            this.key = new KeyParameter(key, keyOff, keyLen);
            this.cipher.init(this.isEncrypting, (CipherParameters)new ParametersWithIV((CipherParameters)this.key, new byte[this.cipher.getBlockSize()]));
        }

        @Override
        public void init(byte[] iv, int ivOff, int ivLen) {
            this.cipher.init(this.isEncrypting, (CipherParameters)new ParametersWithIV(null, iv, ivOff, ivLen));
        }

        @Override
        public int doFinal(byte[] input, int inputOffset, int inputLength, byte[] output, int outputOffset) {
            int blockSize = this.cipher.getBlockSize();
            for (int i = 0; i < inputLength; i += blockSize) {
                this.cipher.processBlock(input, inputOffset + i, output, outputOffset + i);
            }
            return inputLength;
        }

        @Override
        public int getBlockSize() {
            return this.cipher.getBlockSize();
        }
    }

    private static class BcTlsHash
    implements TlsHash {
        private final short hashAlgorithm;
        private final Digest digest;

        BcTlsHash(short hashAlgorithm, Digest digest) {
            this.hashAlgorithm = hashAlgorithm;
            this.digest = digest;
        }

        @Override
        public void update(byte[] data, int offSet, int length) {
            this.digest.update(data, offSet, length);
        }

        @Override
        public byte[] calculateHash() {
            byte[] rv = new byte[this.digest.getDigestSize()];
            this.digest.doFinal(rv, 0);
            return rv;
        }

        @Override
        public Object clone() {
            return new BcTlsHash(this.hashAlgorithm, BcTlsCrypto.cloneDigest(this.hashAlgorithm, this.digest));
        }

        @Override
        public void reset() {
            this.digest.reset();
        }
    }
}

