/*
 * Decompiled with CFR 0.152.
 */
package kl.ssl.gmvpn;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Vector;
import kl.ssl.gmvpn.AbstractTlsContext;
import kl.ssl.gmvpn.Certificate;
import kl.ssl.gmvpn.CertificateRequest;
import kl.ssl.gmvpn.CertificateStatus;
import kl.ssl.gmvpn.CipherSuite;
import kl.ssl.gmvpn.ClientHello;
import kl.ssl.gmvpn.DigitallySigned;
import kl.ssl.gmvpn.NewSessionTicket;
import kl.ssl.gmvpn.ProtocolVersion;
import kl.ssl.gmvpn.SecurityParameters;
import kl.ssl.gmvpn.TlsContext;
import kl.ssl.gmvpn.TlsCredentials;
import kl.ssl.gmvpn.TlsExtensionsUtils;
import kl.ssl.gmvpn.TlsFatalAlert;
import kl.ssl.gmvpn.TlsHandshakeHash;
import kl.ssl.gmvpn.TlsKeyExchange;
import kl.ssl.gmvpn.TlsPeer;
import kl.ssl.gmvpn.TlsProtocol;
import kl.ssl.gmvpn.TlsServer;
import kl.ssl.gmvpn.TlsServerContextImpl;
import kl.ssl.gmvpn.TlsUtils;
import org.bouncycastle.util.Arrays;

public class TlsServerProtocol
extends TlsProtocol {
    protected TlsServer tlsServer = null;
    TlsServerContextImpl tlsServerContext = null;
    protected TlsKeyExchange keyExchange = null;
    protected TlsCredentials serverCredentials = null;
    protected CertificateRequest certificateRequest = null;
    protected TlsHandshakeHash prepareFinishHash = null;

    public TlsServerProtocol() {
    }

    public TlsServerProtocol(InputStream input, OutputStream output) {
        super(input, output);
    }

    public void accept(TlsServer tlsServer) throws IOException {
        if (tlsServer == null) {
            throw new IllegalArgumentException("'tlsServer' cannot be null");
        }
        if (this.tlsServer != null) {
            throw new IllegalStateException("'accept' can only be called once");
        }
        this.tlsServer = tlsServer;
        this.tlsServerContext = new TlsServerContextImpl(tlsServer.getCrypto());
        this.tlsServer.init(this.tlsServerContext);
        this.recordStream.init(this.tlsServerContext);
        this.beginHandshake(false);
        if (this.blocking) {
            this.blockForHandshake();
        }
    }

    @Override
    protected void cleanupHandshake() {
        super.cleanupHandshake();
        this.keyExchange = null;
        this.serverCredentials = null;
        this.certificateRequest = null;
        this.prepareFinishHash = null;
    }

    @Override
    protected TlsContext getContext() {
        return this.tlsServerContext;
    }

    @Override
    AbstractTlsContext getContextAdmin() {
        return this.tlsServerContext;
    }

    @Override
    protected TlsPeer getPeer() {
        return this.tlsServer;
    }

    @Override
    protected void handleHandshakeMessage(short type, ByteArrayInputStream buf) throws IOException {
        block0 : switch (type) {
            case 1: {
                switch (this.connection_state) {
                    case 16: {
                        if (!this.handleRenegotiation()) break block0;
                    }
                    case 0: {
                        CertificateStatus certificateStatus;
                        SecurityParameters securityParameters = this.tlsServerContext.getSecurityParametersHandshake();
                        this.receiveClientHelloMessage(buf);
                        this.connection_state = 1;
                        this.invalidateSession();
                        securityParameters.sessionID = TlsUtils.EMPTY_BYTES;
                        this.tlsSession = TlsUtils.importSession(securityParameters.getSessionID(), null);
                        this.sessionParameters = null;
                        this.sendServerHelloMessage();
                        this.connection_state = (short)2;
                        this.recordStream.notifyHelloComplete();
                        Vector serverSupplementalData = this.tlsServer.getServerSupplementalData();
                        if (serverSupplementalData != null) {
                            this.sendSupplementalDataMessage(serverSupplementalData);
                        }
                        this.connection_state = (short)3;
                        this.keyExchange = TlsUtils.initKeyExchangeServer(this.tlsServerContext, this.tlsServer);
                        this.serverCredentials = TlsServerProtocol.validateCredentials(this.tlsServer.getCredentials());
                        Certificate serverCertificate = null;
                        ByteArrayOutputStream endPointHash = new ByteArrayOutputStream();
                        if (null == this.serverCredentials) {
                            this.keyExchange.skipServerCredentials();
                        } else {
                            this.keyExchange.processServerCredentials(this.serverCredentials);
                            serverCertificate = this.serverCredentials.getCertificate();
                            this.sendCertificateMessage(serverCertificate, endPointHash);
                        }
                        securityParameters.tlsServerEndPoint = endPointHash.toByteArray();
                        this.connection_state = (short)4;
                        if (null == serverCertificate || serverCertificate.isEmpty()) {
                            this.allowCertificateStatus = false;
                        }
                        if (this.allowCertificateStatus && (certificateStatus = this.tlsServer.getCertificateStatus()) != null) {
                            this.sendCertificateStatusMessage(certificateStatus);
                        }
                        this.connection_state = (short)5;
                        byte[] serverKeyExchange = this.keyExchange.generateServerKeyExchange();
                        if (serverKeyExchange != null) {
                            this.sendServerKeyExchangeMessage(serverKeyExchange);
                        }
                        this.connection_state = (short)6;
                        if (this.serverCredentials != null) {
                            this.certificateRequest = this.tlsServer.getCertificateRequest();
                            if (this.certificateRequest != null) {
                                this.certificateRequest = TlsUtils.validateCertificateRequest(this.certificateRequest, this.keyExchange);
                                this.sendCertificateRequestMessage(this.certificateRequest);
                                TlsUtils.trackHashAlgorithms(this.recordStream.getHandshakeHash(), this.certificateRequest.getSupportedSignatureAlgorithms());
                            }
                        }
                        this.connection_state = (short)7;
                        this.sendServerHelloDoneMessage();
                        this.connection_state = (short)8;
                        boolean forceBuffering = false;
                        TlsUtils.sealHandshakeHash(this.getContext(), this.recordStream.getHandshakeHash(), forceBuffering);
                        break block0;
                    }
                    default: {
                        throw new TlsFatalAlert(10);
                    }
                }
            }
            case 23: {
                switch (this.connection_state) {
                    case 8: {
                        this.tlsServer.processClientSupplementalData(TlsServerProtocol.readSupplementalDataMessage(buf));
                        this.connection_state = (short)9;
                        break block0;
                    }
                }
                throw new TlsFatalAlert(10);
            }
            case 11: {
                switch (this.connection_state) {
                    case 8: {
                        this.tlsServer.processClientSupplementalData(null);
                    }
                    case 9: {
                        if (this.certificateRequest == null) {
                            throw new TlsFatalAlert(10);
                        }
                        this.receiveCertificateMessage(buf);
                        this.connection_state = (short)10;
                        break block0;
                    }
                }
                throw new TlsFatalAlert(10);
            }
            case 16: {
                switch (this.connection_state) {
                    case 8: {
                        this.tlsServer.processClientSupplementalData(null);
                    }
                    case 9: {
                        if (this.certificateRequest == null) {
                            this.keyExchange.skipClientCredentials();
                        } else {
                            if (TlsUtils.isTLSv12(this.getContext())) {
                                throw new TlsFatalAlert(10);
                            }
                            this.notifyClientCertificate(Certificate.EMPTY_CHAIN);
                        }
                    }
                    case 10: {
                        this.receiveClientKeyExchangeMessage(buf);
                        this.connection_state = (short)11;
                        break block0;
                    }
                }
                throw new TlsFatalAlert(10);
            }
            case 15: {
                switch (this.connection_state) {
                    case 11: {
                        if (!this.expectCertificateVerifyMessage()) {
                            throw new TlsFatalAlert(10);
                        }
                        this.receiveCertificateVerifyMessage(buf);
                        this.connection_state = (short)12;
                        break block0;
                    }
                }
                throw new TlsFatalAlert(10);
            }
            case 20: {
                switch (this.connection_state) {
                    case 11: {
                        if (this.expectCertificateVerifyMessage()) {
                            throw new TlsFatalAlert(10);
                        }
                    }
                    case 12: {
                        this.processFinishedMessage(buf);
                        this.connection_state = (short)13;
                        if (this.expectSessionTicket) {
                            this.sendNewSessionTicketMessage(this.tlsServer.getNewSessionTicket());
                        }
                        this.connection_state = (short)14;
                        this.sendChangeCipherSpecMessage();
                        this.sendFinishedMessage();
                        this.connection_state = (short)15;
                        this.completeHandshake();
                        break block0;
                    }
                }
                throw new TlsFatalAlert(10);
            }
            default: {
                throw new TlsFatalAlert(10);
            }
        }
    }

    @Override
    protected void handleAlertWarningMessage(short alertDescription) throws IOException {
        super.handleAlertWarningMessage(alertDescription);
        switch (alertDescription) {
            case 41: {
                throw new TlsFatalAlert(10);
            }
        }
    }

    protected void notifyClientCertificate(Certificate clientCertificate) throws IOException {
        TlsUtils.processClientCertificate(this.tlsServerContext, clientCertificate, this.certificateRequest, this.keyExchange, this.tlsServer);
    }

    protected void receiveCertificateMessage(ByteArrayInputStream buf) throws IOException {
        Certificate clientCertificate = Certificate.parse(this.getContext(), buf, null);
        TlsServerProtocol.assertEmpty(buf);
        this.notifyClientCertificate(clientCertificate);
    }

    protected void receiveCertificateVerifyMessage(ByteArrayInputStream buf) throws IOException {
        if (this.certificateRequest == null) {
            throw new IllegalStateException();
        }
        DigitallySigned clientCertificateVerify = DigitallySigned.parse(this.tlsServerContext, buf);
        TlsServerProtocol.assertEmpty(buf);
        TlsUtils.verifyCertificateVerify(this.tlsServerContext, this.certificateRequest, clientCertificateVerify, this.prepareFinishHash);
    }

    protected void receiveClientHelloMessage(ByteArrayInputStream buf) throws IOException {
        this.recordStream.setWriteVersion(ProtocolVersion.TLSv10);
        ClientHello clientHello = ClientHello.parse(buf, null);
        ProtocolVersion client_version = clientHello.getClientVersion();
        this.offeredCipherSuites = clientHello.getCipherSuites();
        this.clientExtensions = clientHello.getExtensions();
        SecurityParameters securityParameters = this.tlsServerContext.getSecurityParametersHandshake();
        this.tlsServerContext.setClientSupportedVersions(TlsExtensionsUtils.getSupportedVersionsExtensionClient(this.clientExtensions));
        if (null == this.tlsServerContext.getClientSupportedVersions()) {
            this.tlsServerContext.setClientSupportedVersions(client_version.downTo(ProtocolVersion.GMVPNv11));
        } else {
            client_version = ProtocolVersion.getLatestTLS(this.tlsServerContext.getClientSupportedVersions());
        }
        if (null == client_version) {
            throw new TlsFatalAlert(47);
        }
        if (securityParameters.isRenegotiating()) {
            if (!client_version.equals(this.tlsServerContext.getClientVersion()) && !client_version.equals(this.tlsServerContext.getServerVersion())) {
                throw new TlsFatalAlert(47);
            }
        } else {
            this.tlsServerContext.setClientVersion(client_version);
        }
        this.tlsServer.notifyClientVersion(this.tlsServerContext.getClientVersion());
        securityParameters.clientRandom = clientHello.getRandom();
        this.tlsServer.notifyFallback(Arrays.contains((int[])this.offeredCipherSuites, (int)22016));
        this.tlsServer.notifyOfferedCipherSuites(this.offeredCipherSuites);
        byte[] renegExtData = TlsUtils.getExtensionData(this.clientExtensions, EXT_RenegotiationInfo);
        if (securityParameters.isRenegotiating()) {
            if (!securityParameters.isSecureRenegotiation()) {
                throw new TlsFatalAlert(80);
            }
            if (Arrays.contains((int[])this.offeredCipherSuites, (int)255)) {
                throw new TlsFatalAlert(40);
            }
            if (null == renegExtData) {
                throw new TlsFatalAlert(40);
            }
            SecurityParameters saved = this.tlsServerContext.getSecurityParametersConnection();
            byte[] reneg_conn_info = saved.getPeerVerifyData();
            if (!Arrays.constantTimeAreEqual((byte[])renegExtData, (byte[])TlsServerProtocol.createRenegotiationInfo(reneg_conn_info))) {
                throw new TlsFatalAlert(40);
            }
        } else {
            if (Arrays.contains((int[])this.offeredCipherSuites, (int)255)) {
                securityParameters.secureRenegotiation = true;
            }
            if (renegExtData != null) {
                securityParameters.secureRenegotiation = true;
                if (!Arrays.constantTimeAreEqual((byte[])renegExtData, (byte[])TlsServerProtocol.createRenegotiationInfo(TlsUtils.EMPTY_BYTES))) {
                    throw new TlsFatalAlert(40);
                }
            }
        }
        if (this.clientExtensions != null) {
            TlsExtensionsUtils.getPaddingExtension(this.clientExtensions);
            securityParameters.clientServerNames = TlsExtensionsUtils.getServerNameExtensionClient(this.clientExtensions);
            if (TlsUtils.isSignatureAlgorithmsExtensionAllowed(client_version)) {
                securityParameters.clientSigAlgs = TlsExtensionsUtils.getSignatureAlgorithmsExtension(this.clientExtensions);
                securityParameters.clientSigAlgsCert = TlsExtensionsUtils.getSignatureAlgorithmsCertExtension(this.clientExtensions);
            }
            securityParameters.clientSupportedGroups = TlsExtensionsUtils.getSupportedGroupsExtension(this.clientExtensions);
            this.tlsServer.processClientExtensions(this.clientExtensions);
        }
    }

    protected void receiveClientKeyExchangeMessage(ByteArrayInputStream buf) throws IOException {
        this.keyExchange.processClientKeyExchange(buf);
        TlsServerProtocol.assertEmpty(buf);
        this.prepareFinishHash = this.recordStream.prepareToFinish();
        this.tlsServerContext.getSecurityParametersHandshake().sessionHash = TlsUtils.getCurrentPRFHash(this.prepareFinishHash);
        TlsServerProtocol.establishMasterSecret(this.getContext(), this.keyExchange);
        this.recordStream.setPendingConnectionState(TlsUtils.initCipher(this.getContext()));
    }

    protected void sendCertificateRequestMessage(CertificateRequest certificateRequest) throws IOException {
        TlsProtocol.HandshakeMessage message = new TlsProtocol.HandshakeMessage(13);
        certificateRequest.encode(message);
        message.writeToRecordStream();
    }

    protected void sendCertificateStatusMessage(CertificateStatus certificateStatus) throws IOException {
        TlsProtocol.HandshakeMessage message = new TlsProtocol.HandshakeMessage(22);
        certificateStatus.encode(message);
        message.writeToRecordStream();
    }

    protected void sendHelloRequestMessage() throws IOException {
        byte[] message = new byte[4];
        TlsUtils.writeUint8((short)0, message, 0);
        TlsUtils.writeUint24(0, message, 1);
        this.writeHandshakeMessage(message, 0, message.length);
    }

    protected void sendNewSessionTicketMessage(NewSessionTicket newSessionTicket) throws IOException {
        if (newSessionTicket == null) {
            throw new TlsFatalAlert(80);
        }
        TlsProtocol.HandshakeMessage message = new TlsProtocol.HandshakeMessage(4);
        newSessionTicket.encode(message);
        message.writeToRecordStream();
    }

    protected void sendServerHelloMessage() throws IOException {
        int selectedCipherSuite;
        ProtocolVersion server_version;
        SecurityParameters securityParameters = this.tlsServerContext.getSecurityParametersHandshake();
        if (securityParameters.isRenegotiating()) {
            server_version = this.tlsServerContext.getServerVersion();
        } else {
            server_version = this.tlsServer.getServerVersion();
            if (null == server_version || server_version.isEarlierVersionOf(ProtocolVersion.TLSv10) || server_version.isLaterVersionOf(ProtocolVersion.TLSv12) || !ProtocolVersion.contains(this.tlsServerContext.getClientSupportedVersions(), server_version)) {
                throw new TlsFatalAlert(80);
            }
            ProtocolVersion legacy_record_version = server_version.isLaterVersionOf(ProtocolVersion.TLSv12) ? ProtocolVersion.TLSv12 : server_version;
            this.recordStream.setWriteVersion(legacy_record_version);
            securityParameters.negotiatedVersion = server_version;
        }
        securityParameters.serverRandom = TlsServerProtocol.createRandomBlock(this.tlsServer.shouldUseGMTUnixTime(), this.tlsServerContext);
        if (!server_version.equals(ProtocolVersion.getLatestTLS(this.tlsServer.getSupportedVersions()))) {
            TlsUtils.writeDowngradeMarker(server_version, securityParameters.getServerRandom());
        }
        if (!Arrays.contains((int[])this.offeredCipherSuites, (int)(selectedCipherSuite = this.tlsServer.getSelectedCipherSuite())) || selectedCipherSuite == 0 || CipherSuite.isSCSV(selectedCipherSuite) || !TlsUtils.isValidCipherSuiteForVersion(selectedCipherSuite, this.tlsServerContext.getServerVersion())) {
            throw new TlsFatalAlert(80);
        }
        securityParameters.cipherSuite = selectedCipherSuite;
        this.serverExtensions = TlsExtensionsUtils.ensureExtensionsInitialised(this.tlsServer.getServerExtensions());
        ProtocolVersion legacy_version = server_version;
        if (server_version.isLaterVersionOf(ProtocolVersion.TLSv12)) {
            legacy_version = ProtocolVersion.TLSv12;
            TlsExtensionsUtils.addSupportedVersionsExtensionServer(this.serverExtensions, server_version);
        }
        if (securityParameters.isRenegotiating()) {
            if (!securityParameters.isSecureRenegotiation()) {
                throw new TlsFatalAlert(80);
            }
            SecurityParameters saved = this.tlsServerContext.getSecurityParametersConnection();
            byte[] reneg_conn_info = TlsUtils.concat(saved.getPeerVerifyData(), saved.getLocalVerifyData());
            this.serverExtensions.put(EXT_RenegotiationInfo, TlsServerProtocol.createRenegotiationInfo(reneg_conn_info));
        } else if (securityParameters.isSecureRenegotiation()) {
            boolean noRenegExt;
            byte[] renegExtData = TlsUtils.getExtensionData(this.serverExtensions, EXT_RenegotiationInfo);
            boolean bl = noRenegExt = null == renegExtData;
            if (noRenegExt) {
                this.serverExtensions.put(EXT_RenegotiationInfo, TlsServerProtocol.createRenegotiationInfo(TlsUtils.EMPTY_BYTES));
            }
        }
        securityParameters.applicationProtocol = TlsExtensionsUtils.getALPNExtensionServer(this.serverExtensions);
        securityParameters.applicationProtocolSet = true;
        if (!this.serverExtensions.isEmpty()) {
            securityParameters.encryptThenMAC = TlsExtensionsUtils.hasEncryptThenMACExtension(this.serverExtensions);
            securityParameters.maxFragmentLength = this.processMaxFragmentLengthExtension(this.clientExtensions, this.serverExtensions, (short)80);
            securityParameters.truncatedHMac = TlsExtensionsUtils.hasTruncatedHMacExtension(this.serverExtensions);
            this.allowCertificateStatus = !this.resumedSession && TlsUtils.hasExpectedEmptyExtensionData(this.serverExtensions, TlsExtensionsUtils.EXT_status_request, (short)80);
            this.expectSessionTicket = !this.resumedSession && TlsUtils.hasExpectedEmptyExtensionData(this.serverExtensions, TlsProtocol.EXT_SessionTicket, (short)80);
        }
        securityParameters.prfAlgorithm = TlsServerProtocol.getPRFAlgorithm(this.tlsServerContext, securityParameters.getCipherSuite());
        securityParameters.verifyDataLength = 12;
        this.applyMaxFragmentLengthExtension();
        TlsProtocol.HandshakeMessage message = new TlsProtocol.HandshakeMessage(2);
        TlsUtils.writeVersion(legacy_version, message);
        message.write(securityParameters.getServerRandom());
        TlsUtils.writeOpaque8(this.tlsSession.getSessionID(), message);
        TlsUtils.writeUint16(securityParameters.getCipherSuite(), message);
        TlsUtils.writeUint8((short)0, (OutputStream)message);
        TlsServerProtocol.writeExtensions(message, this.serverExtensions);
        message.writeToRecordStream();
    }

    protected void sendServerHelloDoneMessage() throws IOException {
        byte[] message = new byte[4];
        TlsUtils.writeUint8((short)14, message, 0);
        TlsUtils.writeUint24(0, message, 1);
        this.writeHandshakeMessage(message, 0, message.length);
    }

    protected void sendServerKeyExchangeMessage(byte[] serverKeyExchange) throws IOException {
        TlsProtocol.HandshakeMessage message = new TlsProtocol.HandshakeMessage(12, serverKeyExchange.length);
        message.write(serverKeyExchange);
        message.writeToRecordStream();
    }

    protected boolean expectCertificateVerifyMessage() {
        Certificate clientCertificate = this.tlsServerContext.getSecurityParametersHandshake().getPeerCertificate();
        return null != clientCertificate && !clientCertificate.isEmpty() && this.keyExchange.requiresCertificateVerify();
    }
}

