/*
 * Decompiled with CFR 0.152.
 */
package com.ghca.kms.thrift.api;

import org.apache.thrift.TEnum;
import org.apache.thrift.annotation.Nullable;

public enum SignAlgorithm implements TEnum
{
    ED25519(1),
    ED25519PH(2),
    ED25519CTX(3),
    RSA_PKCS1_5(4),
    RSA_SSA_PSS(5),
    SM2(6),
    ECDSA(7);

    private final int value;

    private SignAlgorithm(int value) {
        this.value = value;
    }

    @Override
    public int getValue() {
        return this.value;
    }

    @Nullable
    public static SignAlgorithm findByValue(int value) {
        switch (value) {
            case 1: {
                return ED25519;
            }
            case 2: {
                return ED25519PH;
            }
            case 3: {
                return ED25519CTX;
            }
            case 4: {
                return RSA_PKCS1_5;
            }
            case 5: {
                return RSA_SSA_PSS;
            }
            case 6: {
                return SM2;
            }
            case 7: {
                return ECDSA;
            }
        }
        return null;
    }
}

