/*
 * Decompiled with CFR 0.152.
 */
package com.koal.kms.sdk.ed;

import com.koal.kms.sdk.ed.KmsCfb;
import com.koal.kms.sdk.ed.KmsSdkException;
import com.koal.kms.sdk.ed.KmsUtil;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;

public class KmsFile {
    private static final String READ = "r";
    private static final String WRITE = "rws";
    private static final int READ_BUFFER_SIZE = 0x400000;

    static void encryptFile(String path, String newName) throws IOException, KmsSdkException {
        File file = new File(path);
        if (!file.exists() || !file.canRead()) {
            throw new RuntimeException("[" + file.getName() + "] not exist or can't read.");
        }
        if (null == newName || newName.trim().length() == 0 || file.getName().equals(newName)) {
            throw new RuntimeException("Illegal encrypted file name.");
        }
        String folder = file.getParentFile().getAbsolutePath();
        File newFile = new File(folder + File.separator + newName);
        KmsFile.prepareNewFile(newFile);
        try (RandomAccessFile src = new RandomAccessFile(file, READ);
             FileChannel fc = src.getChannel();
             RandomAccessFile dest = new RandomAccessFile(newFile, WRITE);
             FileChannel fcw = dest.getChannel();){
            int len;
            byte[] iv = KmsUtil.generateRandom(16);
            fcw.write(ByteBuffer.wrap(iv));
            ByteBuffer reader = ByteBuffer.allocateDirect(0x400000);
            while ((len = fc.read(reader)) != -1) {
                if (len <= 0) continue;
                byte[] data = new byte[len];
                ((Buffer)reader).rewind();
                reader.get(data);
                fcw.write(ByteBuffer.wrap(KmsCfb.encrypt(data, iv)));
                ((Buffer)reader).clear();
            }
        }
    }

    private static void prepareNewFile(File newFile) throws IOException {
        if (newFile.exists() && !newFile.delete()) {
            throw new RuntimeException("[" + newFile.getName() + "] already exist, but delete fail.");
        }
        if (!newFile.createNewFile()) {
            throw new RuntimeException("create [" + newFile.getName() + "] failure.");
        }
    }

    static void decryptFile(String path, String newName) throws IOException, KmsSdkException {
        File file = new File(path);
        if (!file.exists() || !file.canRead()) {
            throw new RuntimeException("[" + file.getName() + "] not exist or can't read.");
        }
        if (null == newName || newName.trim().length() == 0 || file.getName().equals(newName)) {
            throw new RuntimeException("Illegal decrypted file name.");
        }
        String folder = file.getParentFile().getAbsolutePath();
        File newFile = new File(folder + File.separator + newName);
        KmsFile.prepareNewFile(newFile);
        try (RandomAccessFile src = new RandomAccessFile(file, READ);
             FileChannel fc = src.getChannel();
             RandomAccessFile dest = new RandomAccessFile(newFile, WRITE);
             FileChannel fcw = dest.getChannel();){
            int len;
            byte[] iv = new byte[16];
            ByteBuffer ivReader = ByteBuffer.allocateDirect(16);
            fc.read(ivReader);
            ((Buffer)ivReader).rewind();
            ivReader.get(iv);
            ByteBuffer reader = ByteBuffer.allocateDirect(0x400000);
            while ((len = fc.read(reader)) != -1) {
                if (len <= 0) continue;
                byte[] data = new byte[len];
                ((Buffer)reader).rewind();
                reader.get(data);
                fcw.write(ByteBuffer.wrap(KmsCfb.decrypt(data, iv)));
                ((Buffer)reader).clear();
            }
        }
    }
}

