/*
 * Decompiled with CFR 0.152.
 */
package com.koal.kms.sdk.ed.thrift.loadbalance;

import com.koal.kms.sdk.ed.KmsClientConfig;
import com.koal.kms.sdk.ed.thrift.constants.LoadBalance;
import com.koal.kms.sdk.ed.thrift.constants.ServiceLevel;
import com.koal.kms.sdk.ed.thrift.exception.NoServerAvailableException;
import com.koal.kms.sdk.ed.thrift.exception.ValidationException;
import com.koal.kms.sdk.ed.thrift.failover.ConnectionValidator;
import com.koal.kms.sdk.ed.thrift.failover.FailoverChecker;
import com.koal.kms.sdk.ed.thrift.failover.FailoverStrategy;
import com.koal.kms.sdk.ed.thrift.pool.DefaultThriftConnectionPool;
import com.koal.kms.sdk.ed.thrift.pool.ThriftConnectionFactory;
import com.koal.kms.sdk.ed.thrift.pool.ThriftServer;
import com.koal.kms.sdk.ed.thrift.transport.TransportCreator;
import com.koal.kms.sdk.ed.thrift.utils.MurmurHash3;
import com.koal.kms.sdk.ed.thrift.utils.ThriftClientUtil;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import javassist.util.proxy.Proxy;
import javassist.util.proxy.ProxyFactory;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.pool2.KeyedPooledObjectFactory;
import org.apache.commons.pool2.impl.GenericKeyedObjectPoolConfig;
import org.apache.thrift.TServiceClient;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientSelector {
    private static final Logger logger = LoggerFactory.getLogger(ClientSelector.class);
    private final FailoverChecker failoverChecker;
    private final DefaultThriftConnectionPool poolProvider;
    private final LoadBalance loadBalance;
    private final AtomicInteger count = new AtomicInteger(0);
    private static final KmsClientConfig KMS_CLIENT_CONFIG = KmsClientConfig.getInstance();

    public ClientSelector(String servers, LoadBalance loadBalance, ConnectionValidator validator, GenericKeyedObjectPoolConfig<TTransport> poolConfig, FailoverStrategy<ThriftServer> strategy, TransportCreator transportCreator, String backupServers, ServiceLevel serviceLevel) {
        this.failoverChecker = new FailoverChecker(validator, strategy, serviceLevel);
        ThriftConnectionFactory thriftConnectionFactory = new ThriftConnectionFactory(this.failoverChecker, transportCreator);
        this.poolProvider = new DefaultThriftConnectionPool((KeyedPooledObjectFactory<ThriftServer, TTransport>)thriftConnectionFactory, poolConfig);
        this.loadBalance = loadBalance;
        this.failoverChecker.setConnectionPool(this.poolProvider);
        this.failoverChecker.setServerList(ThriftServer.parse(servers));
        if (StringUtils.isNotEmpty(backupServers)) {
            this.failoverChecker.setBackupServerList(ThriftServer.parse(backupServers));
        } else {
            this.failoverChecker.setBackupServerList(new ArrayList<ThriftServer>());
        }
        this.failoverChecker.startChecking();
    }

    public <X extends TServiceClient> X iface(Class<X> ifaceClass) {
        if (this.loadBalance == LoadBalance.HASH) {
            throw new ValidationException("Can not use HASH without a key.");
        }
        switch (this.loadBalance) {
            case ROUND_ROBIN: {
                return this.getRRClient(ifaceClass);
            }
            case WEIGHT: {
                return this.getWeightClient(ifaceClass);
            }
        }
        return this.getRandomClient(ifaceClass);
    }

    public <X extends TServiceClient> X iface(Class<X> ifaceClass, String key) throws ValidationException, NoServerAvailableException {
        if (this.loadBalance != LoadBalance.HASH) {
            throw new ValidationException("Must use other load balance strategy.");
        }
        return this.getHashIface(ifaceClass, key);
    }

    protected <X extends TServiceClient> X getRandomClient(Class<X> ifaceClass) {
        return this.iface(ifaceClass, ThriftClientUtil.randomNextInt());
    }

    protected <X extends TServiceClient> X getRRClient(Class<X> ifaceClass) {
        return this.iface(ifaceClass, this.count.getAndDecrement());
    }

    protected <X extends TServiceClient> X getWeightClient(Class<X> ifaceClass) {
        List<ThriftServer> servers = this.getAvailableServers();
        if (servers == null || servers.isEmpty()) {
            throw new NoServerAvailableException("No server available.");
        }
        int[] weights = new int[servers.size()];
        for (int i = 0; i < servers.size(); ++i) {
            weights[i] = servers.get(i).getWeight();
        }
        return this.iface(ifaceClass, servers.get(ThriftClientUtil.chooseWithWeight(weights)));
    }

    protected <X extends TServiceClient> X getHashIface(Class<X> ifaceClass, String key) {
        byte[] bytes = key.getBytes(StandardCharsets.UTF_8);
        return this.iface(ifaceClass, MurmurHash3.murmurhash3_x86_32(bytes, 0, bytes.length, 305441741));
    }

    protected <X extends TServiceClient> X iface(Class<X> ifaceClass, int index) {
        List<ThriftServer> serverList = this.getAvailableServers();
        if (serverList == null || serverList.isEmpty()) {
            throw new NoServerAvailableException("No server available.");
        }
        index = Math.abs(index);
        ThriftServer selected = serverList.get(index % serverList.size());
        return this.iface(ifaceClass, selected);
    }

    protected <X extends TServiceClient> X iface(Class<X> ifaceClass, ThriftServer selected) {
        TTransport transport;
        try {
            transport = this.poolProvider.getConnection(selected);
        }
        catch (RuntimeException e) {
            if (e.getCause() instanceof TTransportException) {
                this.failoverChecker.getFailoverStrategy().fail(selected);
            }
            throw e;
        }
        TBinaryProtocol protocol = new TBinaryProtocol(transport);
        ProxyFactory factory = new ProxyFactory();
        factory.setSuperclass(ifaceClass);
        factory.setFilter(m -> ThriftClientUtil.getInterfaceMethodNames(ifaceClass).contains(m.getName()));
        try {
            TServiceClient x = (TServiceClient)factory.create(new Class[]{TProtocol.class}, new Object[]{protocol});
            ((Proxy)x).setHandler((self, thisMethod, proceed, args) -> {
                String action = thisMethod.getName();
                logger.debug(" --------------> \u8c03\u7528\u63a5\u53e3\uff1a{} <-------------- ", (Object)action);
                logger.debug(" --------------> \u53c2\u6570\uff1a{} <-------------- ", (Object)Arrays.toString(args));
                try {
                    long begin = System.currentTimeMillis();
                    Object result = proceed.invoke(self, args);
                    long costTime = System.currentTimeMillis() - begin;
                    if (costTime > KMS_CLIENT_CONFIG.getLogTimeout()) {
                        logger.warn("{} - \u8bf7\u6c42\u8017\u65f6: {} ms, pool: {}", new Object[]{thisMethod.getName(), costTime, this.getStatusString()});
                    }
                    if (result != null) {
                        logger.debug(" --------------> \u8fd4\u56de\u503c\uff1a{} <-------------- ", result);
                    }
                    logger.debug("{} \u6210\u529f ", (Object)action);
                    Object object = result;
                    return object;
                }
                catch (InvocationTargetException e) {
                    Throwable t = e.getTargetException();
                    logger.error(action + " \u5931\u8d25 ", t);
                    throw t;
                }
                finally {
                    if (!"getChallenge".equals(action)) {
                        this.poolProvider.returnConnection(selected, transport);
                    }
                }
            });
            return (X)x;
        }
        catch (Exception e) {
            throw new RuntimeException("Fail to create proxy.", e);
        }
    }

    public List<ThriftServer> getAvailableServers() {
        return this.failoverChecker.getAvailableServers();
    }

    public void close() {
        this.failoverChecker.stopChecking();
        this.poolProvider.close();
    }

    protected String getStatusString() {
        StringBuilder builder = new StringBuilder();
        builder.append("active=");
        builder.append(this.poolProvider.getPool().getNumActive());
        builder.append(",wait=");
        builder.append(this.poolProvider.getPool().getNumWaiters());
        builder.append(",idle=");
        builder.append(this.poolProvider.getPool().getNumIdle());
        builder.append(",borrowed=");
        builder.append(this.poolProvider.getPool().getBorrowedCount());
        builder.append(",created=");
        builder.append(this.poolProvider.getPool().getCreatedCount());
        builder.append(",destroyed=");
        builder.append(this.poolProvider.getPool().getDestroyedCount());
        builder.append(",returned=");
        builder.append(this.poolProvider.getPool().getReturnedCount());
        return builder.toString();
    }
}

