/*
 * Decompiled with CFR 0.152.
 */
package kl.ssl.jsse.provider;

import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.security.Principal;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSession;
import kl.ssl.gmvpn.RecordPreview;
import kl.ssl.gmvpn.TlsClientProtocol;
import kl.ssl.gmvpn.TlsFatalAlert;
import kl.ssl.gmvpn.TlsProtocol;
import kl.ssl.gmvpn.TlsServerProtocol;
import kl.ssl.jsse.BCApplicationProtocolSelector;
import kl.ssl.jsse.BCExtendedSSLSession;
import kl.ssl.jsse.BCSSLConnection;
import kl.ssl.jsse.BCSSLEngine;
import kl.ssl.jsse.BCSSLParameters;
import kl.ssl.jsse.provider.ContextData;
import kl.ssl.jsse.provider.ProvSSLConnection;
import kl.ssl.jsse.provider.ProvSSLContextSpi;
import kl.ssl.jsse.provider.ProvSSLParameters;
import kl.ssl.jsse.provider.ProvSSLSession;
import kl.ssl.jsse.provider.ProvSSLSessionHandshake;
import kl.ssl.jsse.provider.ProvTlsClient;
import kl.ssl.jsse.provider.ProvTlsManager;
import kl.ssl.jsse.provider.ProvTlsPeer;
import kl.ssl.jsse.provider.ProvTlsServer;
import kl.ssl.jsse.provider.SSLParametersUtil;

class ProvSSLEngine
extends SSLEngine
implements BCSSLEngine,
ProvTlsManager {
    private static final Logger LOG = Logger.getLogger(ProvSSLEngine.class.getName());
    protected final ProvSSLContextSpi context;
    protected final ContextData contextData;
    protected final ProvSSLParameters sslParameters;
    protected boolean enableSessionCreation = true;
    protected boolean useClientMode = false;
    protected boolean closedEarly = false;
    protected boolean initialHandshakeBegun = false;
    protected SSLEngineResult.HandshakeStatus handshakeStatus = SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING;
    protected TlsProtocol protocol = null;
    protected ProvTlsPeer protocolPeer = null;
    protected ProvSSLConnection connection = null;
    protected ProvSSLSessionHandshake handshakeSession = null;
    protected SSLException deferredException = null;

    protected ProvSSLEngine(ProvSSLContextSpi context, ContextData contextData) {
        this.context = context;
        this.contextData = contextData;
        this.sslParameters = context.getDefaultParameters(!this.useClientMode);
    }

    protected ProvSSLEngine(ProvSSLContextSpi context, ContextData contextData, String host, int port) {
        super(host, port);
        this.context = context;
        this.contextData = contextData;
        this.sslParameters = context.getDefaultParameters(!this.useClientMode);
    }

    @Override
    public ProvSSLContextSpi getContext() {
        return this.context;
    }

    @Override
    public ContextData getContextData() {
        return this.contextData;
    }

    @Override
    public synchronized void beginHandshake() throws SSLException {
        if (this.closedEarly) {
            throw new SSLException("Connection is already closed");
        }
        if (this.initialHandshakeBegun) {
            throw new UnsupportedOperationException("Renegotiation not supported");
        }
        this.initialHandshakeBegun = true;
        try {
            if (this.useClientMode) {
                TlsClientProtocol clientProtocol = new TlsClientProtocol();
                this.protocol = clientProtocol;
                ProvTlsClient client = new ProvTlsClient(this, this.sslParameters.copy());
                this.protocolPeer = client;
                clientProtocol.connect(client);
                this.handshakeStatus = SSLEngineResult.HandshakeStatus.NEED_WRAP;
            } else {
                TlsServerProtocol serverProtocol = new TlsServerProtocol();
                this.protocol = serverProtocol;
                ProvTlsServer server = new ProvTlsServer(this, this.sslParameters.copy());
                this.protocolPeer = server;
                serverProtocol.accept(server);
                this.handshakeStatus = SSLEngineResult.HandshakeStatus.NEED_UNWRAP;
            }
        }
        catch (SSLException e) {
            throw e;
        }
        catch (IOException e) {
            throw new SSLException(e);
        }
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType) throws IOException {
        try {
            this.contextData.getX509TrustManager().checkClientTrusted(chain, authType, this);
        }
        catch (CertificateException e) {
            throw new TlsFatalAlert(46, (Throwable)e);
        }
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType) throws IOException {
        try {
            this.contextData.getX509TrustManager().checkServerTrusted(chain, authType, this);
        }
        catch (CertificateException e) {
            throw new TlsFatalAlert(46, (Throwable)e);
        }
    }

    @Override
    public String chooseClientAlias(String[] keyType, Principal[] issuers) {
        return this.contextData.getX509KeyManager().chooseEngineClientAlias(keyType, issuers, this);
    }

    @Override
    public String chooseServerAlias(String keyType, Principal[] issuers) {
        return this.contextData.getX509KeyManager().chooseEngineServerAlias(keyType, issuers, this);
    }

    @Override
    public synchronized void closeInbound() throws SSLException {
        if (!this.closedEarly) {
            if (null == this.protocol) {
                this.closedEarly = true;
            } else {
                try {
                    this.protocol.closeInput();
                }
                catch (IOException e) {
                    throw new SSLException(e);
                }
            }
        }
    }

    @Override
    public synchronized void closeOutbound() {
        if (!this.closedEarly) {
            if (null == this.protocol) {
                this.closedEarly = true;
            } else {
                try {
                    this.protocol.close();
                }
                catch (IOException e) {
                    LOG.log(Level.WARNING, "Failed to close outbound", e);
                }
            }
        }
    }

    @Override
    public synchronized String getApplicationProtocol() {
        return null == this.connection ? null : this.connection.getApplicationProtocol();
    }

    @Override
    public synchronized BCApplicationProtocolSelector<SSLEngine> getBCHandshakeApplicationProtocolSelector() {
        return this.sslParameters.getEngineAPSelector();
    }

    @Override
    public synchronized BCExtendedSSLSession getBCHandshakeSession() {
        return this.handshakeSession;
    }

    @Override
    public synchronized BCSSLConnection getConnection() {
        return this.connection;
    }

    @Override
    public synchronized Runnable getDelegatedTask() {
        return null;
    }

    @Override
    public synchronized String[] getEnabledCipherSuites() {
        return this.sslParameters.getCipherSuites();
    }

    @Override
    public synchronized String[] getEnabledProtocols() {
        return this.sslParameters.getProtocols();
    }

    @Override
    public synchronized boolean getEnableSessionCreation() {
        return this.enableSessionCreation;
    }

    @Override
    public synchronized String getHandshakeApplicationProtocol() {
        return null == this.handshakeSession ? null : this.handshakeSession.getApplicationProtocol();
    }

    @Override
    public synchronized SSLSession getHandshakeSession() {
        return null == this.handshakeSession ? null : this.handshakeSession.getExportSSLSession();
    }

    @Override
    public synchronized SSLEngineResult.HandshakeStatus getHandshakeStatus() {
        return this.handshakeStatus;
    }

    @Override
    public synchronized boolean getNeedClientAuth() {
        return this.sslParameters.getNeedClientAuth();
    }

    @Override
    public synchronized BCSSLParameters getParameters() {
        return SSLParametersUtil.getParameters(this.sslParameters);
    }

    @Override
    public synchronized SSLSession getSession() {
        ProvSSLSession sslSession = null == this.connection ? ProvSSLSession.NULL_SESSION : this.connection.getSession();
        return sslSession.getExportSSLSession();
    }

    @Override
    public synchronized SSLParameters getSSLParameters() {
        return SSLParametersUtil.getSSLParameters(this.sslParameters);
    }

    @Override
    public synchronized String[] getSupportedCipherSuites() {
        return this.context.getSupportedCipherSuites();
    }

    @Override
    public synchronized String[] getSupportedProtocols() {
        return this.context.getSupportedProtocols();
    }

    @Override
    public synchronized boolean getUseClientMode() {
        return this.useClientMode;
    }

    @Override
    public synchronized boolean getWantClientAuth() {
        return this.sslParameters.getWantClientAuth();
    }

    @Override
    public synchronized boolean isInboundDone() {
        return this.closedEarly || null != this.protocol && this.protocol.isClosed();
    }

    @Override
    public synchronized boolean isOutboundDone() {
        return this.closedEarly || null != this.protocol && this.protocol.isClosed() && this.protocol.getAvailableOutputBytes() < 1;
    }

    @Override
    public synchronized void setBCHandshakeApplicationProtocolSelector(BCApplicationProtocolSelector<SSLEngine> selector) {
        this.sslParameters.setEngineAPSelector(selector);
    }

    @Override
    public synchronized void setEnabledCipherSuites(String[] suites) {
        this.sslParameters.setCipherSuites(suites);
    }

    @Override
    public synchronized void setEnabledProtocols(String[] protocols) {
        this.sslParameters.setProtocols(protocols);
    }

    @Override
    public synchronized void setEnableSessionCreation(boolean flag) {
        this.enableSessionCreation = flag;
    }

    @Override
    public synchronized void setNeedClientAuth(boolean need) {
        this.sslParameters.setNeedClientAuth(need);
    }

    @Override
    public synchronized void setParameters(BCSSLParameters parameters) {
        SSLParametersUtil.setParameters(this.sslParameters, parameters);
    }

    @Override
    public synchronized void setSSLParameters(SSLParameters sslParameters) {
        SSLParametersUtil.setSSLParameters(this.sslParameters, sslParameters);
    }

    @Override
    public synchronized void setUseClientMode(boolean useClientMode) {
        if (this.initialHandshakeBegun) {
            throw new IllegalArgumentException("Mode cannot be changed after the initial handshake has begun");
        }
        if (this.useClientMode != useClientMode) {
            this.context.updateDefaultProtocols(this.sslParameters, !useClientMode);
            this.useClientMode = useClientMode;
        }
    }

    @Override
    public synchronized void setWantClientAuth(boolean want) {
        this.sslParameters.setWantClientAuth(want);
    }

    @Override
    public synchronized SSLEngineResult unwrap(ByteBuffer src, ByteBuffer[] dsts, int offset, int length) throws SSLException {
        if (!this.initialHandshakeBegun) {
            this.beginHandshake();
        }
        SSLEngineResult.Status resultStatus = SSLEngineResult.Status.OK;
        int bytesConsumed = 0;
        int bytesProduced = 0;
        if (this.protocol.isClosed()) {
            resultStatus = SSLEngineResult.Status.CLOSED;
        } else {
            try {
                RecordPreview preview = this.getRecordPreview(src);
                if (preview == null || src.remaining() < preview.getRecordSize()) {
                    resultStatus = SSLEngineResult.Status.BUFFER_UNDERFLOW;
                } else if (this.hasInsufficientSpace(dsts, offset, length, preview.getApplicationDataLimit())) {
                    resultStatus = SSLEngineResult.Status.BUFFER_OVERFLOW;
                } else {
                    byte[] record = new byte[preview.getRecordSize()];
                    src.get(record);
                    this.protocol.offerInput(record);
                    bytesConsumed += record.length;
                    int appDataAvailable = this.protocol.getAvailableInputBytes();
                    for (int dstIndex = 0; dstIndex < length && appDataAvailable > 0; ++dstIndex) {
                        ByteBuffer dst = dsts[offset + dstIndex];
                        int count = Math.min(dst.remaining(), appDataAvailable);
                        if (count <= 0) continue;
                        byte[] appData = new byte[count];
                        int numRead = this.protocol.readInput(appData, 0, count);
                        assert (numRead == count);
                        dst.put(appData);
                        bytesProduced += count;
                        appDataAvailable -= count;
                    }
                    if (appDataAvailable != 0) {
                        throw new TlsFatalAlert(22);
                    }
                }
            }
            catch (IOException e) {
                if (this.handshakeStatus != SSLEngineResult.HandshakeStatus.NEED_UNWRAP) {
                    throw new SSLException(e);
                }
                if (this.deferredException == null) {
                    this.deferredException = new SSLException(e);
                }
                this.handshakeStatus = SSLEngineResult.HandshakeStatus.NEED_WRAP;
                return new SSLEngineResult(SSLEngineResult.Status.OK, SSLEngineResult.HandshakeStatus.NEED_WRAP, bytesConsumed, bytesProduced);
            }
        }
        SSLEngineResult.HandshakeStatus resultHandshakeStatus = this.handshakeStatus;
        if (this.handshakeStatus == SSLEngineResult.HandshakeStatus.NEED_UNWRAP) {
            if (this.protocol.getAvailableOutputBytes() > 0) {
                this.handshakeStatus = SSLEngineResult.HandshakeStatus.NEED_WRAP;
                resultHandshakeStatus = SSLEngineResult.HandshakeStatus.NEED_WRAP;
            } else if (this.protocolPeer.isHandshakeComplete()) {
                this.handshakeStatus = SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING;
                resultHandshakeStatus = SSLEngineResult.HandshakeStatus.FINISHED;
            } else if (this.protocol.isClosed()) {
                this.handshakeStatus = SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING;
                resultHandshakeStatus = SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING;
            }
        }
        return new SSLEngineResult(resultStatus, resultHandshakeStatus, bytesConsumed, bytesProduced);
    }

    @Override
    public synchronized SSLEngineResult wrap(ByteBuffer[] srcs, int offset, int length, ByteBuffer dst) throws SSLException {
        int outputAvailable;
        if (this.deferredException != null) {
            SSLException e = this.deferredException;
            this.deferredException = null;
            throw e;
        }
        if (!this.initialHandshakeBegun) {
            this.beginHandshake();
        }
        SSLEngineResult.Status resultStatus = SSLEngineResult.Status.OK;
        int bytesConsumed = 0;
        int bytesProduced = 0;
        if (this.handshakeStatus == SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING) {
            if (this.protocol.isClosed()) {
                resultStatus = SSLEngineResult.Status.CLOSED;
            } else if (this.protocol.getAvailableOutputBytes() <= 0) {
                try {
                    int srcRemaining = this.getTotalRemaining(srcs, offset, length, this.protocol.getApplicationDataLimit());
                    if (srcRemaining > 0) {
                        RecordPreview preview = this.protocol.previewOutputRecord(srcRemaining);
                        int srcLimit = preview.getApplicationDataLimit();
                        int dstLimit = preview.getRecordSize();
                        if (dst.remaining() < dstLimit) {
                            resultStatus = SSLEngineResult.Status.BUFFER_OVERFLOW;
                        } else {
                            for (int srcIndex = 0; srcIndex < length && srcLimit > 0; ++srcIndex) {
                                ByteBuffer src = srcs[offset + srcIndex];
                                int count = Math.min(src.remaining(), srcLimit);
                                if (count <= 0) continue;
                                byte[] input = new byte[count];
                                src.get(input);
                                this.protocol.writeApplicationData(input, 0, count);
                                bytesConsumed += count;
                                srcLimit -= count;
                            }
                        }
                    }
                }
                catch (IOException e) {
                    throw new SSLException(e);
                }
            }
        }
        if ((outputAvailable = this.protocol.getAvailableOutputBytes()) > 0) {
            int count = Math.min(dst.remaining(), outputAvailable);
            if (count > 0) {
                byte[] output = new byte[count];
                int numRead = this.protocol.readOutput(output, 0, count);
                assert (numRead == count);
                dst.put(output);
                bytesProduced += count;
                outputAvailable -= count;
            } else {
                resultStatus = SSLEngineResult.Status.BUFFER_OVERFLOW;
            }
        }
        SSLEngineResult.HandshakeStatus resultHandshakeStatus = this.handshakeStatus;
        if (this.handshakeStatus == SSLEngineResult.HandshakeStatus.NEED_WRAP && outputAvailable <= 0) {
            if (this.protocolPeer.isHandshakeComplete()) {
                this.handshakeStatus = SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING;
                resultHandshakeStatus = SSLEngineResult.HandshakeStatus.FINISHED;
            } else if (this.protocol.isClosed()) {
                this.handshakeStatus = SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING;
                resultHandshakeStatus = SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING;
            } else {
                this.handshakeStatus = SSLEngineResult.HandshakeStatus.NEED_UNWRAP;
                resultHandshakeStatus = SSLEngineResult.HandshakeStatus.NEED_UNWRAP;
            }
        }
        return new SSLEngineResult(resultStatus, resultHandshakeStatus, bytesConsumed, bytesProduced);
    }

    @Override
    public String getPeerHost() {
        return super.getPeerHost();
    }

    @Override
    public String getPeerHostSNI() {
        return super.getPeerHost();
    }

    @Override
    public int getPeerPort() {
        return super.getPeerPort();
    }

    @Override
    public synchronized void notifyHandshakeComplete(ProvSSLConnection connection) {
        if (null != this.handshakeSession && !this.handshakeSession.isValid()) {
            connection.getSession().invalidate();
        }
        this.handshakeSession = null;
        this.connection = connection;
    }

    @Override
    public synchronized void notifyHandshakeSession(ProvSSLSessionHandshake handshakeSession) {
        this.handshakeSession = handshakeSession;
    }

    @Override
    public synchronized String selectApplicationProtocol(List<String> protocols) {
        return this.sslParameters.getEngineAPSelector().select(this, protocols);
    }

    private RecordPreview getRecordPreview(ByteBuffer src) throws IOException {
        if (src.remaining() < 5) {
            return null;
        }
        byte[] recordHeader = new byte[5];
        int position = src.position();
        src.get(recordHeader);
        ((Buffer)src).position(position);
        return this.protocol.previewInputRecord(recordHeader);
    }

    private int getTotalRemaining(ByteBuffer[] bufs, int off, int len, int limit) {
        int result = 0;
        for (int i = 0; i < len; ++i) {
            ByteBuffer buf = bufs[off + i];
            int next = buf.remaining();
            if (next >= limit - result) {
                return limit;
            }
            result += next;
        }
        return result;
    }

    private boolean hasInsufficientSpace(ByteBuffer[] dsts, int off, int len, int amount) {
        return this.getTotalRemaining(dsts, off, len, amount) < amount;
    }
}

